@extends('layouts.master')

@section('content')
    <style>
        .border-custom {
            border-left:1px solid #dee2e6;
            border-right:1px solid #dee2e6;
        }
    </style>
    <script type="text/javascript">
        $(function () {
            $('#btn-clear-filters').click(function () {
                $('#search').val('');
                $('#filter').submit();
            });
            $('.delete-payment-terms').click(function () {

                $(this).addClass('delete-payment-terms-active');
                $('#modal-placeholder').load('{!! route('payment.terms.delete.modal') !!}', {
                        action: $(this).data('action'),
                        modalName: 'payment-terms',
                        isReload: false,
                    },
                    function (response, status, xhr) {
                        if (status == "error")
                        {
                            var response = JSON.parse(response);
                            alertify.error(response.message);
                        }
                    });
            });
        });
    </script>

    <section class="content-header">

        <div class="container-fluid">
            <div class="row">
                <div class="col-6">
                    <h1><i class="fas fa-file-contract"></i> {{ trans('fi.payment_terms') }}</h1>
                </div>
                <div class="col-6 d-none d-sm-block">
                    <ol class="breadcrumb float-sm-right">{!!  breadcrumbs() !!}</ol>
                </div>
            </div>


        </div>

    </section>

    <section class="content">

        <div class="container-fluid">

            @include('layouts._alerts')

            <div class="card card-primary card-outline">

                <div class="card-header">

                    {!! Form::open(['method' => 'GET', 'id' => 'filter', 'class' => 'form-inline m-0']) !!}

                    <ul class="nav nav-pills">
                        @isset($searchPlaceholder)

                            <li class="nav-item mr-1">

                                <div class="input-group mt-1 mb-1">

                                    {!! Form::text('search', request('search'), ['id' => 'search', 'class' => 'h-auto form-control inline form-control-sm','placeholder' => $searchPlaceholder]) !!}

                                    <div class="input-group-append">

                                        <button type="submit" class="btn btn-sm btn-default" id="search-btn">

                                            <i class="fas fa-search"></i>

                                        </button>

                                    </div>

                                </div>

                            </li>
                        @endisset
                    </ul>
                    <ul class="nav nav-pills ml-auto">
                        <li class="nav-item mt-1 mb-1 mr-1">
                            <a href="{{ route('payment.terms.create') }}" class="btn btn-sm btn-primary">
                                <i class="fa fa-plus"></i> {{ trans('fi.new') }}
                            </a>
                        </li>
                    </ul>

                    {!! Form::close() !!}

                </div>

                <div class="card-body table-responsive">

                    <table class="table table-striped table-sm">
                        <thead>

                        <tr>
                            <th>{!! Sortable::link('name',trans('fi.name'),'payment_terms') !!}</th>
                            <th>{!! Sortable::link('status',trans('fi.status'),'payment_terms') !!}</th>
                            <th>{{ trans('fi.discount_percent') }}</th>
                            <th>{{ trans('fi.discount_days_simple') }}</th>
                            <th>{{ trans('fi.discount_days_nth') }}</th>
                            <th>{{ trans('fi.net_due_days') }}</th>
                            <th>{{ trans('fi.down_payment') }}</th>
                            <th>{{ trans('fi.balance_due_days') }}</th>
                            <th>{{ trans('fi.number_of_installments') }}</th>
                            <th class="text-right">{{ trans('fi.options') }}</th>
                        </tr>

                        </thead>

                        <tbody>

                        @foreach ($paymentTerms as $paymentTerm)

                            <tr>
                                <td>
                                    <a href="{{ route('payment.terms.edit', [$paymentTerm->id]) }}">{{ $paymentTerm->name }}</a>
                                </td>

                                @if($paymentTerm->is_type_locked)
                                    <td>{!! $paymentTerm->formatted_status !!}
                                        <i class="fa fa-sm fa-lock text-maroon align-middle"
                                           data-toggle="tooltip" data-placement="auto"
                                           title="{!! trans('fi.assigned_inv_sent_or_paid') !!}"></i>
                                    </td>
                                @else
                                    <td>{!! $paymentTerm->formatted_status !!}</td>
                                @endif

                                <td @class('text-center')>{{ $paymentTerm->formatted_discount_percent }}</td>
                                <td @class('text-center border-custom')>{{ $paymentTerm->formatted_discount_days_simple }}</td>
                                <td @class('text-center border-custom')>{{ $paymentTerm->formatted_discount_days_nth }}</td>
                                <td @class('text-center border-custom')>{{ $paymentTerm->formatted_net_due_days }}</td>
                                <td @class('text-center border-custom')>{!! $paymentTerm->numeric_formatted_down_payment_with_type !!}</td>
                                <td @class('text-center border-custom')>{{ $paymentTerm->formatted_balance_due_days }}</td>
                                <td @class('text-center')>{{ $paymentTerm->formatted_number_of_installments }}</td>

                                <td class="text-right">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-sm btn-default dropdown-toggle"
                                                data-toggle="dropdown">
                                            {{ trans('fi.options') }} <span class="caret"></span>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <a class="dropdown-item"
                                               href="{{ route('payment.terms.edit', [$paymentTerm->id]) }}">
                                                <i class="fa fa-edit"></i>
                                                {{ trans('fi.edit') }}
                                            </a>
                                            @if($defaultPaymentId != $paymentTerm->id)
                                                <div class="dropdown-divider"></div>
                                                <a href="#"
                                                   data-action="{{ route('payment.terms.delete',[$paymentTerm->id]) }}"
                                                   class="delete-payment-terms text-danger dropdown-item">
                                                    <i class="fa fa-trash"></i> {{ trans('fi.delete') }}
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                            </tr>

                        @endforeach

                        </tbody>

                    </table>

                </div>


                <div class="card-footer">
                    <div class="row">
                        <div class="col-sm-12 col-md-5 mt-3">
                            @if(request('search') )
                                <i class="fa fa-filter"></i> {{ trans('fi.n_records_match', ['label' => $paymentTerms->total(),'plural' => $paymentTerms->total() > 1 ? 's' : '']) }}
                                <button type="button" class="btn btn-sm btn-link"
                                        id="btn-clear-filters">{{ trans('fi.clear') }}</button>
                            @endif
                        </div>
                        <div class="col-sm-12 col-md-7">
                            <div class="float-right mt-3">
                                {!! $paymentTerms->appends(request()->except('page'))->render() !!}
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </section>

@stop