<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\PaymentTerms\Models;

use FI\Modules\Invoices\Models\Invoice;

class PaymentTermObserver
{

    public function updated(PaymentTerm $paymentTerm)
    {

        $invoices = Invoice::wherePaymentTermsId($paymentTerm->id)->get();

        if (count($invoices) > 0)
        {
            foreach ($invoices as $invoice)
            {
                if ($invoice->status == 'draft')
                {
                    $invoice->due_at = Invoice::paymentTermDueDate($paymentTerm->id, $invoice);
                    $invoice->save();
                }
            }
        }
    }

}
