<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\PaymentTerms\Models;

use FI\Support\NumberFormatter;
use FI\Traits\Sortable;
use Illuminate\Database\Eloquent\Model;

class PaymentTermInstallment extends Model
{
    use Sortable;

    /**
     * Guarded properties
     * @var array
     */

    protected $table = 'payment_term_installments';

    protected $guarded = ['id'];

    protected $sortable = [];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */
    public function payments()
    {
        return $this->belongsTo('FI\Modules\Payments\Models\PaymentInvoice', 'id', 'installment_number');
    }


    /*
    |--------------------------------------------------------------------------
    | Accessors
    |--------------------------------------------------------------------------
    */

    public function getFormattedInstallmentPercentAttribute()
    {
        return round($this->attributes['installment_percent'], 2);
    }

    public function getNumericFormattedInstallmentPercentAttribute()
    {
        return NumberFormatter::format($this->attributes['installment_percent']);
    }

}
