<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

Route::group(['prefix' => 'quote/merchant', 'middleware' => 'web', 'namespace' => 'FI\Modules\MerchantQuote\Controllers'], function ()
{
    Route::get('pay/secure/stripe/{urlKey}', ['uses' => 'StripeController@pay', 'as' => 'merchant.pay.quote.stripe']);
    Route::get('pay/secure/stripe/return/success/{urlKey}', ['uses' => 'StripeController@success', 'as' => 'merchant.pay.quote.stripe.return']);
    Route::get('pay/stripe/cancel/{urlKey}', ['uses' => 'StripeController@cancel', 'as' => 'merchant.pay.quote.stripe.cancel']);

    Route::get('pay/secure/paypal/{urlKey}', ['uses' => 'PayPalController@pay', 'as' => 'merchant.pay.quote.paypal']);
    Route::get('pay/secure/paypal/return/success/{urlKey}', ['uses' => 'PayPalController@success', 'as' => 'merchant.pay.quote.paypal.return']);
    Route::get('pay/paypal/cancel/{urlKey}', ['uses' => 'PayPalController@cancel', 'as' => 'merchant.pay.quote.paypal.cancel']);

    Route::get('pay/secure/mollie/{urlKey}', ['uses' => 'MollieController@pay', 'as' => 'merchant.pay.quote.mollie']);
    Route::post('pay/secure/mollie/webhook/verify/{urlKey}', ['uses' => 'MollieController@webhook', 'as' => 'merchant.pay.quote.mollie.webhook']);
    Route::get('pay/mollie/return/{urlKey}', ['uses' => 'MollieController@success', 'as' => 'merchant.pay.quote.mollie.return']);
    Route::get('pay/mollie/cancel/{urlKey}', ['uses' => 'MollieController@cancel', 'as' => 'merchant.pay.quote.mollie.cancel']);

    Route::get('pay/secure/square/{urlKey}', ['uses' => 'SquareController@pay', 'as' => 'merchant.pay.quote.square']);
    Route::post('pay/secure/square/return/success/{urlKey}', ['uses' => 'SquareController@success', 'as' => 'merchant.pay.quote.square.return']);
    Route::get('pay/square/cancel/{urlKey}', ['uses' => 'SquareController@cancel', 'as' => 'merchant.pay.quote.square.cancel']);

});