<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\MerchantQuote\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\MerchantQuote\Support\Drivers\MollieDriver;
use FI\Modules\Quotes\Models\Quote;

class MollieController extends Controller
{
    private $driver;

    public function __construct(MollieDriver $driver)
    {
        $this->driver = $driver;
    }

    public function pay($urlKey)
    {
        $quote = Quote::where('url_key', $urlKey)->first();

        if ($quote)
        {
            if ($quote->status == 'rejected')
            {
                return redirect()->back()->with('error', trans('fi.quote_rejected_not_payable', ['number' => $quote->number]));
            }
            elseif ($quote->amount->total == 0 && $quote->status == 'canceled')
            {
                return redirect()->back()->with('error', trans('fi.quote_add_items'));
            }
            else
            {
                return $this->driver->pay($quote);
            }
        }
        else
        {
            return redirect('/')->with('error', trans('fi.invalid_quote_id'));
        }
    }

    public function success($urlKey)
    {
        $quote = Quote::where('url_key', $urlKey)->first();

        if ($quote)
        {
            return redirect()->route('clientCenter.public.quote.show', [$urlKey, $quote->token]);
        }
        else
        {
            return redirect('/')->with('error', trans('fi.invalid_quote_id'));
        }
    }

    public function webhook($urlKey)
    {
        $quote = Quote::where('url_key', $urlKey)->first();

        if ($quote)
        {
            $this->driver->verify($quote);
            http_response_code(200);
            exit;
        }
        else
        {
            return redirect('/')->with('error', trans('fi.invalid_quote_id'));
            http_response_code(400);
            exit;
        }
    }
}