<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

Route::group(['prefix' => 'merchant', 'middleware' => 'web', 'namespace' => 'FI\Modules\Merchant\Controllers'], function ()
{
    Route::get('pay/secure/stripe/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'StripeController@pay', 'as' => 'merchant.pay.stripe']);
    Route::get('pay/secure/stripe/return/success/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'StripeController@success', 'as' => 'merchant.pay.stripe.return']);
    Route::get('pay/stripe/cancel/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'StripeController@cancel', 'as' => 'merchant.pay.stripe.cancel']);

    Route::get('pay/secure/paypal/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'PayPalController@pay', 'as' => 'merchant.pay.paypal']);
    Route::get('pay/secure/paypal/return/success/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'PayPalController@success', 'as' => 'merchant.pay.paypal.return']);
    Route::get('pay/paypal/cancel/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'PayPalController@cancel', 'as' => 'merchant.pay.paypal.cancel']);

    Route::get('pay/secure/mollie/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'MollieController@pay', 'as' => 'merchant.pay.mollie']);
    Route::post('pay/secure/mollie/webhook/verify/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'MollieController@webhook', 'as' => 'merchant.pay.mollie.webhook']);
    Route::get('pay/mollie/return/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'MollieController@success', 'as' => 'merchant.pay.mollie.return']);
    Route::get('pay/mollie/cancel/{urlKey}', ['uses' => 'MollieController@cancel', 'as' => 'merchant.pay.mollie.cancel']);

    Route::get('pay/secure/square/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'SquareController@pay', 'as' => 'merchant.pay.square']);
    Route::post('pay/secure/square/return/success/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'SquareController@success', 'as' => 'merchant.pay.square.return']);
    Route::get('pay/square/cancel/{urlKey}/{modal}/{quoteUrlKey?}', ['uses' => 'SquareController@cancel', 'as' => 'merchant.pay.square.cancel']);

});