<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <meta name="csrf-token" content="{{ csrf_token() }}"/>

    <title>{{ config('fi.headerTitleText') }}</title>

    @include('layouts._head')

    @include('layouts._js_global')

    @yield('head')

    @yield('javascript')

    @include('layouts._alertifyjs')

    @include('layouts._js_notifications')

</head>
<body class="{{ $skinClass }} position-relative  sidebar-mini fixed">

<div class="wrapper">

    @include('layouts._header')
    
    @include('layouts._side_bar_menu')
    
    <div class="content-wrapper position-relative">
        @yield('content')
        @if (config('time_tracking_enabled') && config('fi.floatingTimeTrackingAddon') == 1)
            @include('time_tracking.widget._task_list')
        @endif
    </div>
</div>

<div id="modal-placeholder"></div>
<div id="attachment-modal-placeholder"></div>
<div id="modal-confirm-credit-application"></div>
<div id="note-modal-placeholder"></div>
<div id="modal-confirm-payment-invoices"></div>
<div class="modal" id="modal-loader">
    <div class="overlay text-center position-absolute p-3"
         style="left: 50%;top: 50%;-webkit-transform: translateX(-50%) translateY(-50%);transform: translateX(-50%) translateY(-50%);">
        <i class="fa fa-spinner fa-9x"></i>
    </div>
</div>

<script>
    var $document = $(document.body);
    $document.find('.main-sidebar > .sidebar > .mt-2 > ul.nav-sidebar > li.nav-item-hover').each(function () {
        $(this).children().each(function (e) {
            $(this).children().each(function (e) {
                if ($(this).hasClass('active'))
                {
                    $(this).next('span.nav-item-plus-icon').addClass('d-block');
                }
            });
        });
    });
    $('.quick-profile-setting').click(function () {

        $('#modal-placeholder').load('{!! route('dashboard.user.modal.edit') !!}', {
            userId: '{{auth()->user()->id}}',
            modalName: 'users'
        });

    });

</script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="{{ asset('assets/plugins/moment/moment.min.js?v='.config('fi.version')) }}"></script>
<script src="{{ asset('assets/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js?v='.config('fi.version')) }}"></script>
@yield('footerJS')

</body>
</html>
