<aside class="main-sidebar sidebar-dark-primary {{($skin == 'light-mode')  ? 'bg-navy' : ''}}">
    <!-- Brand Logo -->
    <a href="{{ route('dashboard.index')}}" class=" bg-{{$topBarColor }}  brand-link shadow-lg ">
        <img src="{{ asset('assets/dist/img/logo.png') }}" alt="{{ config('fi.headerTitleText') }}"
             class="brand-image img-circle elevation-5">
        <span class="brand-text font-weight-dark">{{ config('fi.headerTitleText') }}</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        @if (config('fi.displayProfileImage'))
            <a href="javascript:void(0)" class="d-block quick-profile-setting">
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        {!! auth()->user()->getAvatar(40, true) !!}
                    </div>
                    <div class="info text-wrap">
                        <p class="p-0 m-0">  {!! ucfirst(auth()->user()->name) !!}</p>
                        <span class="small" data-toggle="tooltip" data-placement="auto" title="{{trans('fi.git_branch')}}">
                                {!!getCurrentGitBranch()!!}
                            </span>
                    </div>
                </div>
            </a>
        @endif
        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">
                <!-- Add icons to the links using the .nav-icon class with font-awesome or any other icon font library -->
                <li class="nav-item">
                    <a href="{{ route('dashboard.index') }}"
                       class="{{ $urlSegment1 == 'dashboard' ? 'nav-link active' : 'nav-link' }} detect-changes">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>{{ trans('fi.dashboard') }}</p>
                    </a>
                </li>
                @can('clients.view')
                    <li class="nav-item nav-item-hover">
                        <a href="{{ route('clients.index', ['status' => 'active']) }}"
                           class="link1 {{ $urlSegment1 == 'clients' ? 'nav-link active' : 'nav-link' }}">
                            <i class="nav-icon fas fa-users"></i>
                            <p>{{ trans('fi.clients') }}</p>
                        </a>
                        <a href="@can('clients.create') {{ route('clients.create') }} @endcan"
                           class="link2 btn-link {{ $urlSegment1 == 'clients' ? 'active' : '' }}">
                            @can('clients.create')
                                <i class="fas fa-plus fa-sm text-white "></i>
                            @endcan
                        </a>
                    </li>
                @endcan
                @foreach (config('fi.menus.navigation') as $menu)
                    @if (view()->exists($menu))
                        @if($menu == 'proforma_invoices._navigation')
                            @include($menu)
                        @endif
                    @endif
                @endforeach
                @can('quotes.view')
                    <li class="nav-item nav-item-hover">
                        <a href="{{ route('quotes.index', ['status' => config('fi.quoteStatusFilter')]) }}"
                           class="link1 {{ $urlSegment1 == 'quotes' ? 'nav-link active' : 'nav-link' }}">
                            <i class="nav-icon far fa-file-alt"></i>
                            <p>{{ trans('fi.quotes') }}</p>
                        </a>
                        <a href="javascript:void(0)"
                           class="@can('quotes.create') create-quote @endcan link2 btn-link btn-action-modal {{ $urlSegment1 == 'quotes' ? 'active' : '' }}">
                            @can('quotes.create')
                                <i class="fas fa-plus fa-sm text-white"></i>
                            @endcan
                        </a>
                    </li>
                @endcan
                @can('invoices.view')
                    <li class="nav-item nav-item-hover">
                        <a href="{{ route('invoices.index', ['status' => config('fi.invoiceStatusFilter')]) }}"
                           class="link1 {{ $urlSegment1 == 'invoices' ? 'nav-link active' : 'nav-link' }}">
                            <i class="nav-icon fas fa-file-invoice"></i>
                            <p>{{ trans('fi.invoices') }}</p>
                        </a>
                        <a href="javascript:void(0)"
                           class="link2 btn-link btn-action-modal @can('invoices.create') create-invoice @endcan {{ $urlSegment1 == 'invoices' ? 'active' : '' }}">
                            @can('invoices.create')
                                <i class="fas fa-plus fa-sm text-white"></i>
                            @endcan
                        </a>
                    </li>
                @endcan
                @can('recurring_invoices.view')
                    <li class="nav-item nav-item-hover">
                        <a href="{{ route('recurringInvoices.index') }}"
                           class="link1 {{ $urlSegment1 == 'recurring_invoices' ? 'nav-link active' : 'nav-link' }}">
                            <i class="nav-icon fas fa-sync"></i>
                            <p>{{ trans('fi.subscriptions') }}</p>
                        </a>
                        <a href="javascript:void(0)"
                           class="link2 btn-link @can('recurring_invoices.create') create-recurring-invoice btn-action-modal @endcan {{ $urlSegment1 == 'recurring_invoices' ? 'active' : '' }}">
                            @can('recurring_invoices.create')
                                <i class="fas fa-plus fa-sm text-white"></i>
                            @endcan
                        </a>
                    </li>
                @endcan
                @can('payments.view')
                    <li class="nav-item nav-item-hover">
                        <a href="{{ route('payments.index') }}"
                           class="link1 {{ $urlSegment1 == 'payments' ? 'nav-link active' : 'nav-link' }}">
                            <i class="nav-icon far fa-credit-card"></i>
                            <p>{{ trans('fi.payments') }}</p>
                        </a>
                        <a href="javascript:void(0)"
                           class="link2 btn-link @can('payments.create') create-payment btn-action-modal @endcan {{ $urlSegment1 == 'payments' ? 'active' : '' }}">
                            @can('payments.create')
                                <i class="fas fa-plus fa-sm text-white"></i>
                            @endcan
                        </a>
                    </li>
                @endcan
                @can('expenses.view')
                    <li class="nav-item nav-item-hover">
                        <a href="{{ route('expenses.index') }}"
                           class="link1 {{ $urlSegment1 == 'expenses' ? 'nav-link active' : 'nav-link' }}">
                            <i class="nav-icon fas fa-file-invoice-dollar"></i>
                            <p>{{ trans('fi.expenses') }}</p>
                        </a>
                        <a href="@can('expenses.create'){{ route('expenses.create') }}@endcan"
                           class="link2 btn-link {{ $urlSegment1 == 'expenses' ? 'active' : '' }}">
                            @can('expenses.create')
                                <i class="fas fa-plus fa-sm text-white"></i>
                            @endcan
                        </a>
                    </li>
                @endcan
                <li class="nav-item nav-item-hover">
                    <a href="{{ route('task.index') }}"
                       class="link1 {{ $urlSegment1 == 'task' ? 'nav-link active' : 'nav-link' }}">
                        <i class="nav-icon fas fa-tasks"></i>
                        <p>{{ trans('fi.tasks') }}</p>
                    </a>
                    <a href="{{ route('task.create') }}"
                       class="link2 btn-link {{ $urlSegment1 == 'task' ? 'active' : '' }}">
                        <i class="fas fa-plus fa-sm text-white"></i>
                    </a>
                </li>

                @foreach (config('fi.menus.navigation') as $menu)
                    @if (view()->exists($menu))
                        @if($menu != 'proforma_invoices._navigation')
                            @include($menu)
                        @endif
                    @endif
                @endforeach

                <li class="nav-item {{ ($urlSegment1 == 'report' || $urlSegment2 == 'reports') ? 'menu-open' : '' }}">
                    <a href="#"
                       class="nav-link {{ ($urlSegment1 == 'report' || $urlSegment2 == 'reports') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-chart-bar"></i>
                        <p>
                            {{ trans('fi.reports') }}
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @can('client_statement.view')
                            <li class="nav-item">
                                <a href="{{ route('reports.clientStatement') }}"
                                   class="small nav-link {{ $urlSegment2 == 'client_statement' ? 'active' : '' }}">
                                    <i class="far fa-circle nav-icon text-info"></i>

                                    <p>{{ trans('fi.client_statement') }}</p>
                                </a>
                            </li>
                        @endcan

                        @can('expense_list.view')
                            <li class="nav-item">
                                <a href="{{ route('reports.expenseList') }}"
                                   class="small nav-link {{ $urlSegment2 == 'expense_list' ? 'active' : '' }}">
                                    <i class="far fa-circle nav-icon text-info"></i>

                                    <p>{{ trans('fi.expense_list') }}</p>
                                </a>
                            </li>
                        @endcan
                        @can('item_sales.view')
                            <li class="nav-item">
                                <a href="{{ route('reports.itemSales') }}"
                                   class="small nav-link {{ $urlSegment2 == 'item_sales' ? 'active' : '' }}">
                                    <i class="far fa-circle nav-icon text-info"></i>

                                    <p>{{ trans('fi.item_sales') }}</p>
                                </a>
                            </li>
                        @endcan
                        @can('payments_collected.view')
                            <li class="nav-item">
                                <a href="{{ route('reports.paymentsCollected') }}"
                                   class="small nav-link {{ $urlSegment2 == 'payments_collected' ? 'active' : '' }}">
                                    <i class="far fa-circle nav-icon text-info"></i>

                                    <p>{{ trans('fi.payments_collected') }}</p>
                                </a>
                            </li>
                        @endcan
                        @can('profit_and_loss.view')
                            <li class="nav-item">
                                <a href="{{ route('reports.profitLoss') }}"
                                   class="small nav-link {{ $urlSegment2 == 'profit_loss' ? 'active' : '' }}">
                                    <i class="far fa-circle nav-icon text-info"></i>

                                    <p>{{ trans('fi.profit_and_loss') }}</p>
                                </a>
                            </li>
                        @endcan
                        @can('revenue_by_client.view')
                            <li class="nav-item">
                                <a href="{{ route('reports.revenueByClient') }}"
                                   class="small nav-link {{ $urlSegment2 == 'revenue_by_client' ? 'active' : '' }}">
                                    <i class="far fa-circle nav-icon text-info"></i>

                                    <p>{{ trans('fi.revenue_by_client') }}</p>
                                </a>
                            </li>
                        @endcan
                        @can('tax_report.view')
                            <li class="nav-item">
                                <a href="{{ route('reports.taxReport') }}"
                                   class="small nav-link {{ $urlSegment2 == 'tax_report' ? 'active' : '' }}">
                                    <i class="far fa-circle nav-icon text-info"></i>
                                    <p>{{ trans('fi.tax_report') }}</p>
                                </a>
                            </li>
                        @endcan
                        @can('recurring_invoice_list.view')
                            <li class="nav-item">
                                <a href="{{ route('reports.recurringInvoiceList') }}"
                                   class="small nav-link {{ $urlSegment2 == 'recurring_invoice_list' ? 'active' : '' }}">
                                    <i class="far fa-circle nav-icon text-info"></i>

                                    <p>{{ trans('fi.recurring_invoice_list') }}</p>
                                </a>
                            </li>
                        @endcan

                        <li class="nav-item">
                            <a href="{{ route('reports.clientInvoice') }}"
                               class="small nav-link {{ $urlSegment2 == 'client_invoice' ? 'active' : '' }}">
                                <i class="far fa-circle nav-icon text-info"></i>

                                <p>{{ trans('fi.client_invoice') }}</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="{{ route('reports.creditAndPrepayments') }}"
                               class="small nav-link {{ $urlSegment2 == 'credit_and_pre_payments' ? 'active' : '' }}">
                                <i class="far fa-circle nav-icon text-info"></i>

                                <p>{{ trans('fi.credit-memo-and-prepayments') }}</p>
                            </a>
                        </li>
                        @foreach (config('fi.menus.reports') as $report)
                            @if (view()->exists($report))
                                @include($report)
                            @endif
                        @endforeach
                    </ul>
                </li>

                @include('layouts._mru')
            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>