<script type="text/javascript">

    var all_currencies = @json(isset($allCurrencies) ? $allCurrencies : []);

    function currencyUnformat(input, currency)
    {
        let matchCurrency = all_currencies.find(c => c.code == currency);
        let cleanInput = input;
        cleanInput = cleanInput.replaceAll(matchCurrency.decimal, 'D');
        cleanInput = cleanInput.replaceAll(matchCurrency.thousands, '');
        cleanInput = cleanInput.replaceAll(matchCurrency.symbol, '');
        cleanInput = cleanInput.replaceAll('D', '.');
        return cleanInput;
    }

    function currencyFormat(input, currency)
    {
        let numberFoDecimal = '{{config('fi.amountDecimals')}}';
        var zerosString = Array.from({length: numberFoDecimal}, () => '0').join('');
        let matchCurrency = all_currencies.find(c => c.code == currency);
        let numberFoDecimalInput = (numberFoDecimal > 0) ? '.' + zerosString : '';
        let cleanInput = (input.toString().includes('.')) ? input.toString() : input + numberFoDecimalInput;
        var numParts = cleanInput.split(".");
        numParts[0] = numParts[0].replace(/\B(?=(\d{3})+(?!\d))/g, matchCurrency.thousands);
        return numParts.join(matchCurrency.decimal);
    }

    function currencyWithSymbolFormat(input, currency)
    {
        let matchCurrency = all_currencies.find(c => c.code == currency);
        let cleanInput = (input.toString().includes('.')) ? input.toString() : input;
        var numParts = cleanInput.split(matchCurrency.decimal);
        numParts[0] = numParts[0].replace(/\B(?=(\d{3})+(?!\d))/g, matchCurrency.thousands);
        if (numParts.length >= 2 && numParts[1].length > 2)
        {
            numParts[1] = numParts[1].substr(0, '{{config('fi.amountDecimals')}}');
        }
        else if (numParts.length >= 2 && numParts[1].length == 1)
        {
            numParts[1] = numParts[1] + '0';
        }
        return matchCurrency['symbol'] + ' ' + numParts.join(matchCurrency.decimal);
    }

    function setFormattedValue($this, value)
    {
        let amountWithCurrency = currencyWithSymbolFormat(currencyFormat(value, $('#currency_code').val()), $('#currency_code').val());
        $this.data('value', value);
        $this.val(amountWithCurrency);
    }

    function showAlertifyErrors(errors)
    {

        if (errors == null)
        {
            return;
        }

        $.each(errors, function (id, message) {
            alertify.error(message[0], 5);
        });

    }

    function showErrors(errors, placeholder)
    {

        $('.input-group.has-error').removeClass('has-error');
        $(placeholder).html('');
        if (errors == null && placeholder)
        {
            return;
        }

        $.each(errors, function (id, message) {
            if (id)
            {
                $('#' + id).parents('.input-group').addClass('has-error');
            }
            if (placeholder)
            {
                $(placeholder).append('<div class="alert alert-danger">' + message[0] + '</div>');
            }
        });

    }

    function clearErrors()
    {
        $('.input-group.has-error').removeClass('has-error');
    }

    function initTooltip()
    {
        $('[data-toggle="tooltip"]').tooltip({
            'delay': {show: 1100, hide: 100},
            'boundary': 'window'
        });
    }

    function mustMatchAllTags()
    {
        $('.must-match-all').click(function () {
            if ($(this).prop('checked'))
            {
                $('.filter-tag-chk').prop('checked', true);
            }
            else
            {
                $('.filter-tag-chk').prop('checked', false);
            }
        });
    }

    var leaveChange = false;

    function areObjectsEqual(obj1, obj2, lengthCount = true)
    {
        const keys1 = Object.keys(obj1);
        const keys2 = Object.keys(obj2);

        if (lengthCount)
        {
            if (keys1.length !== keys2.length)
            {
                return false;
            }
        }

        for (const key of keys1)
        {
            const value1 = obj1[key];
            const value2 = obj2[key];

            if (!(value2 == undefined && (value1 != null && value1 != undefined)))
            {
                if (Array.isArray(value1) && Array.isArray(value2))
                {

                    if (value1.length !== value2.length)
                    {
                        if (!(value1.length > value2.length))
                        {
                            return false;
                        }
                    }
                    for (let i = 0; i < value1.length; i++)
                    {
                        if (value1[i] !== value2[i])
                        {
                            if (value2[i] !== undefined)
                            {
                                return false;
                            }
                        }
                    }
                }
                else if (Array.isArray(value1) && !Array.isArray(value2))
                {
                    if (value1[0] !== value2)
                    {
                        return false;
                    }
                }
                else if (!Array.isArray(value1) && Array.isArray(value2))
                {
                    if (value1 !== value2[0])
                    {
                        return false;
                    }
                }
                else if (value1 !== value2)
                {
                    return false;
                }
            }
        }
        return true;
    }

    var filesChecks = true;
    $(document).ready(function () {
        $('.custom-file-input').on('change', function () {
            filesChecks = false;
        });
    });

    function detectChanges()
    {
        $(window).bind('beforeunload', function (e) {
            const formData1 = $('.data-changes-check').data('serialize');
            const formData2 = $('.data-changes-check').serializeFormJSON();
            const currentSerializedFormData1 = JSON.stringify(formData1);
            const currentSerializedFormData2 = JSON.stringify(formData2);
            const currentFormData1 = JSON.parse(currentSerializedFormData1);
            const currentFormData2 = JSON.parse(currentSerializedFormData2);

            if (!currentFormData2.hasOwnProperty('terms'))
            {
                delete currentFormData1['terms'];
            }
            if (!currentFormData2.hasOwnProperty('footer'))
            {
                delete currentFormData1['footer'];
            }
            if (currentFormData2.hasOwnProperty('main_discount_type'))
            {
                currentFormData2['main_discount_type'] = $("#main-discount-type").data('icon');
            }

            const areFormObjectsEqual = areObjectsEqual(currentFormData1, currentFormData2, false);

            let overlay = getUrlParameter('overlay');
            if (overlay != 0 && overlay.length != 0)
            {
                if (!areFormObjectsEqual || !filesChecks)
                {
                    return true;
                }
            }
        });

        var getUrlParameter = function getUrlParameter(sParam) {
            var sPageURL = window.location.search.substring(1),
                sURLVariables = sPageURL.split('&'),
                sParameterName,
                i;

            for (i = 0; i < sURLVariables.length; i++)
            {
                sParameterName = sURLVariables[i].split('=');

                if (sParameterName[0] === sParam)
                {
                    return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
                }
            }
            return false;
        };

        $('.page-leave-mail,.page-leave-email,.page-leave-unMail,.page-leave-enter-payment,.page-leave-status-change-to-draft,.page-leave-copy,.page-leave-RI').click(function (event) {
            leaveChange = matchData();
            if (leaveChange)
            {
                var confirmationMessage = '{!! trans('fi.confirm_approve_leave_page') !!}';
                if (!confirm(confirmationMessage))
                {
                    event.preventDefault();
                    event.stopPropagation();
                    return false;
                }
                else
                {
                    leaveChange = false;
                }
            }
        });
    }

    function matchData()
    {
        const formData1 = $('.data-changes-check').data('serialize');
        const formData2 = $('.data-changes-check').serializeFormJSON();
        const currentSerializedFormData1 = JSON.stringify(formData1);
        const currentSerializedFormData2 = JSON.stringify(formData2);
        const currentFormData1 = JSON.parse(currentSerializedFormData1);
        const currentFormData2 = JSON.parse(currentSerializedFormData2);
        const areFormObjectsEqual = areObjectsEqual(currentFormData1, currentFormData2);

        if (!areFormObjectsEqual || !filesChecks)
        {
            return true;
        }
        else
        {
            return false;
        }
    }


    $(function () {

        @if(config('app.demo') == true)

        let remainingTime = {{$remainingTime}};

        function updateTimer()
        {
            if (remainingTime <= 0)
            {
                remainingTime = {{session('end_timestamp')}} - {{$startTimestamp}};
                $.session.set("end_timestamp", {{session('end_timestamp')}});
            }
            var minutes = Math.floor(remainingTime / 60);

            if (minutes <= '0')
            {
                $('#demo-data-refresh-count-down').text(remainingTime);
                $('#demo-data-refresh-count-unit').text('{{ trans('fi.seconds') }}');
            }
            else
            {
                $('#demo-data-refresh-count-down').text(minutes);
                if (minutes < 2)
                {
                    $('#demo-data-refresh-count-unit').text('{{ trans('fi.minute') }}');
                }
            }

            remainingTime--;

            if (remainingTime == "00")
            {
                location.reload(true);
            }
            setTimeout(updateTimer, 1000);
        }

        updateTimer();

        @endif

        initTooltip();

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        @can('quotes.create')
        $('.create-quote').click(function () {
            var clientName = $(this).data('unique-name');
            var clientId = $(this).data('client-id');

            $('#modal-placeholder').load('{{ route('quotes.create') }}', function () {
                $('#create_client_name').val(clientName).trigger('change');
                if (clientId != null)
                {
                    if (clientId != 'undefined')
                    {
                        $('#create_client_name').val(clientId).trigger('change');
                        $('.client-detail').hide();
                    }
                }
            });
        });
        @endcan

        @can('invoices.create')
        $('.create-invoice').click(function () {

            var clientName = $(this).data('unique-name');
            var clientId = $(this).data('client-id');
            $('#modal-placeholder').load('{{ route('invoices.create') }}', function () {

                $('#create_client_name').val(clientName).trigger('change');

                if (clientId != null)
                {
                    if (clientId != 'undefined')
                    {
                        $('#create_client_name').val(clientId).trigger('change');
                        $('.client-detail').hide();
                    }
                }
            });
        });
        @endcan

        @can('recurring_invoices.create')
        $('.create-recurring-invoice').click(function () {
            var clientName = $(this).data('unique-name');
            var clientId = $(this).data('client-id');
            $('#modal-placeholder').load('{{ route('recurringInvoices.create') }}', function () {
                $('#create_client_name').val(clientName).trigger('change');
                if (clientId != null)
                {
                    if (clientId != 'undefined')
                    {
                        $('#create_client_name').val(clientId).trigger('change');
                        $('.client-detail').hide();
                    }
                }
            });
        });
        @endcan

        $('.btn-action-modal').click(function () {
            $(this).addClass('disabled');
        });

        @can('payments.create')
        $(document).off('click', '.create-payment').on('click', '.create-payment', function () {
            $('#modal-placeholder').load('{{ route('payments.createPayment') }}');
        });
        @endcan


        @can('payments.update')
        $('.edit-payment').click(function () {
            $('#modal-placeholder').load($(this).data('action'));
        });
        @endcan

        @can('invoices.view')
        $(document).off('click', '.payment-applications').on('click', '.payment-applications', function () {
            $('#modal-placeholder').load($(this).data('action'));
        });
        @endcan

        $(document).on('click', '.email-quote', function () {
            if (leaveChange == false)
            {
                $('#modal-placeholder').load('{{ route('quoteMail.create') }}', {
                    quote_id: $(this).data('quote-id'),
                    redirectTo: $(this).data('redirect-to')
                }, function (response, status, xhr) {
                    if (status == 'error')
                    {
                        alertify.error('{{ trans('fi.problem_with_email_template') }}');
                    }
                });
            }
        });


        $(document).off('click', '.email-invoice').on('click', '.email-invoice', function () {
            if (leaveChange == false)
            {
                $('#modal-placeholder').load('{{ route('invoiceMail.create') }}', {
                    invoice_id: $(this).data('invoice-id'),
                    redirectTo: $(this).data('redirect-to')
                }, function (response, status, xhr) {
                    if (status == 'error')
                    {
                        alertify.error('{{ trans('fi.problem_with_email_template') }}');
                    }
                });
            }
        });

        @if(config('sms'))
        $(document).on('click', '.sms-quote', function () {
            $('#modal-placeholder').load('{{ route('addon.quote.sms.create') }}', {
                quote_id: $(this).data('quote-id')
            }, function (response, status, xhr) {
                if (status == 'error')
                {
                    alertify.error('{{ trans('Sms::lang.problem_with_sms_quote_template') }}');
                }
            });
        });
        $(document).off('click', '.sms-invoice').on('click', '.sms-invoice', function () {
            $('#modal-placeholder').load('{{ route('addon.invoice.sms.create') }}', {
                invoice_id: $(this).data('invoice-id')
            }, function (response, status, xhr) {
                if (status == 'error')
                {
                    alertify.error('{{ trans('Sms::lang.problem_with_sms_invoice_template') }}');
                }
            });
        });
        @endif
        $(document).on('click', '#user_notification', function () {
            $('#modal-placeholder').load('{{ route('notifications.userNotifications') }}', function (response, status, xhr) {
                if (status == 'error')
                {
                    alertify.error('{{ trans('fi.problem_with_email_template') }}');
                }
            });
        });

        @can('payments.create')
        $(document).on('click', '.enter-payment', function () {
            $('#modal-placeholder').load('{{ route('payments.create') }}', {
                invoice_id: $(this).data('invoice-id'),
                invoice_balance: $(this).data('invoice-balance'),
                redirectTo: $(this).data('redirect-to'),
                layoutFormDataInclude: $(this).data('layout-form-data-include'),
            });
        });
        @endcan

        @can('payments.update')
        $(document).on('click', '.btn-edit-payment-note', function () {
            $('#modal-placeholder').load('{{ route('payments.note.edit') }}', {
                id: $(this).data('payment-invoice-id'),
                invoice_id: $(this).data('invoice-id')
            });
        });
        @endcan

        $('#bulk-select-all').click(function () {
            if ($(this).prop('checked'))
            {
                $('.bulk-record').prop('checked', true);
                if ($('.bulk-record:checked').length > 0)
                {
                    $('.bulk-actions').show();
                }
            }
            else
            {
                $('.bulk-record').prop('checked', false);
                $('.bulk-actions').hide();
            }
        });

        $('.bulk-record').click(function () {
            if ($('.bulk-record:checked').length > 0)
            {
                $('.bulk-actions').show();
            }
            else
            {
                $('.bulk-actions').hide();
                $('#bulk-select-all').prop('checked', false);
            }

            if ($(this).prop('checked'))
            {
                var isAllChecked = 1;

                $('.bulk-record').each(function () {
                    if (!this.checked)
                    {
                        isAllChecked = 0;
                    }
                });

                if (isAllChecked == 1)
                {
                    $('#bulk-select-all').prop('checked', true);
                }
            }
            else
            {
                $('#bulk-select-all').prop('checked', false);
            }
        });

        $('.bulk-actions').hide();

    });

    function resizeIframe(obj, minHeight)
    {
        obj.style.height = '';
        var height = obj.contentWindow.document.body.scrollHeight;

        if (height < minHeight)
        {
            obj.style.height = minHeight + 'px';
        }
        else
        {
            obj.style.height = (height + 50) + 'px';
        }
    }

    function resizeIframeSection(obj, minHeight)
    {
        obj.style.height = '';
        var height = obj.contentWindow.document.body.scrollHeight;
        if (height < minHeight)
        {
            height = minHeight + 'px';
        }
        else
        {
            height = (height + 95) + 'px';
        }
        $('.iframe-content').css("height", height);
    }

    function standardCurrencyFormat(value)
    {
        @if(config('fi.baseCurrency') == 'EUR')
            return value.toString().replace(",", ".");
        @endif
            return value.replace(",", ".");
    }

    function systemCurrencyFormat(value)
    {

        @if(config('fi.baseCurrency') == 'EUR')
            return value.toString().replace(".", ",");
        @endif

            return value;
    }

    function showHideLoaderModal()
    {
        $('#modal-loader').modal('toggle');
    }

    function showHideClientMergeLoaderModal()
    {
        $('#merge-modal-loader').modal('toggle');
    }

    function itemLookupDetailFills(module_name, fieldName, fieldLabel, data, $this)
    {
        if (module_name === 'quote')
        {
            var customFieldType = data.quoteCustomFieldsType;
        }
        if (module_name === 'invoice')
        {
            var customFieldType = data.customFieldsType;
        }
        if (module_name === 'recurring_invoice')
        {
            var customFieldType = data.recurringInvoiceCustomFieldsType;
        }

        $this.closest('.table').siblings('.main-table').find("tbody input[name='item_lookup_id']").val(data.custom.item_lookup_id);

        if (customFieldType[fieldName] == 'date')
        {
            var date = data.customFields[fieldLabel] != null ? moment(data.customFields[fieldLabel]).format(dateFormat) : '';
            $this.val(date);
        }
        else if (customFieldType[fieldName] == 'datetime')
        {
            var date_time = data.customFields[fieldLabel] != null ? moment(data.customFields[fieldLabel]).format(dateTimeFormat) : '';
            $this.val(date_time);
        }
        else if (customFieldType[fieldName] == 'radio')
        {
            if ($this.data('value') == data.customFields[fieldLabel])
            {
                $this.prop("checked", true);
            }
            else
            {
                $this.prop("checked", false);
            }
        }
        else if (customFieldType[fieldName] == 'checkbox')
        {
            if (data.customFields[fieldLabel] != '')
            {

                $this.prop("checked", true);
                $this.attr('data-value');

            }
            else
            {
                $this.prop("checked", false);
            }
        }
        else if (customFieldType[fieldName] == 'email')
        {
            $this.val(data.customFields[fieldLabel]);
        }
        else if (customFieldType[fieldName] == 'tagselection')
        {
            $this.closest(".custom-select2").select2().val($.parseJSON(data.customFields[fieldLabel])).trigger('change');
        }
        else if (customFieldType[fieldName] == 'image')
        {
            $this.closest('.custom-file').siblings('.custom_img').remove();
            $this.closest('.custom-file').parents('.form-group').children('label').after(data.customFields[fieldLabel]);
            $('.btn-delete-custom-img').click(function () {
                $(this).closest('table').siblings('.table').find('tbody > tr:first-child').find('input[name=data_custom_item_delete]').val('no');
                $(this).closest('.custom_img').html('');
            });
        }
        else
        {
            $this.val(data.customFields[fieldLabel]);
        }

    }

    function printPdf(url)
    {
        var iframe = this._printIframe;
        if (!this._printIframe)
        {
            iframe = this._printIframe = document.createElement('iframe');
            document.body.appendChild(iframe);

            iframe.style.display = 'none';
            iframe.onload = function () {
                setTimeout(function () {
                    iframe.focus();
                    iframe.contentWindow.print();
                }, 1);
            };
        }
        iframe.src = url;
    }

    $(document).on('click', '.select2-selection--single', function () {
        var $_select2 = document.querySelector('.select2-dropdown > .select2-search > .select2-search__field ')
        $_select2 != null ? $_select2.focus() : '';
    });


    $(document).off("click", ".btn-custom-mail-toggle").on("click", ".btn-custom-mail-toggle", function () {

        var appendId = $(this).data('card-name');

        function runCode()
        {
            var content = document.getElementById('body').value;
            var iframe = document.getElementById(appendId + '-targetCode');
            iframe = (iframe.contentWindow) ? iframe.contentWindow : (iframe.contentDocument.document) ? iframe.contentDocument.document : iframe.contentDocument;
            iframe.document.open();
            iframe.document.write(content);
            iframe.document.close();
            return false;
        }

        runCode();

        if (($('.custom-' + appendId + '-sourceCode-display').hasClass('d-block')) === true)
        {
            $(this).attr('title', '{{trans('fi.code')}}');
            $(this).children().removeClass().addClass('fa fa-code');
            $('.toggle-' + appendId + '-header').html('{{trans('fi.preview')}}');
            $('.custom-' + appendId + '-sourceCode-display').removeClass('d-block').addClass('d-none');
            $('.custom-' + appendId + '-iframe-display').removeClass('d-none').addClass('d-block');
        }
        else
        {
            $(this).removeAttr('title');
            $(this).attr('title', '{{trans('fi.preview')}}');
            $(this).children().removeClass().addClass('fa fa-eye');
            $('.toggle-' + appendId + '-header').html('{{trans('fi.code')}}');
            $('.custom-' + appendId + '-sourceCode-display').removeClass('d-none').addClass('d-block');
            $('.custom-' + appendId + '-iframe-display').removeClass('d-block').addClass('d-none');
        }

    });

    $(document).on('click', '.copy-icon-btn', function () {
        var copyText = $(this).closest('tr').find('.item-lookup:first option:selected').text();
        try
        {
            copyToClipboard(copyText);
            alertify.success('{{trans('fi.copy_text')}}');
        }
        catch (e)
        {
            alertify.error(e.message);
        }
    });

    function copyToClipboard(text)
    {
        var $_document = document;
        var sampleTextarea = $_document.createElement("textarea");
        $_document.body.appendChild(sampleTextarea);
        sampleTextarea.value = text;
        sampleTextarea.select();
        $_document.execCommand("copy");
        $_document.body.removeChild(sampleTextarea);
    }

    function calculateDiscount(discount_type, discount, price)
    {
        if (discount_type === 'percentage')
        {
            var returnPrice = (price - ((price * discount) / 100)).toFixed('{{config('fi.amountDecimals')}}');
        }
        else if (discount_type === 'flat_amount')
        {
            var returnPrice = (price - discount).toFixed('{{config('fi.amountDecimals')}}');
        }
        else
        {
            var returnPrice = price;
        }
        discount_type = discount = price = null;
        return returnPrice;
    }

    function invoiceAndQuoteDiscountItemTotal($_this, discountType, type = false)
    {

        var field = ('discount-type' == discountType);
        var row = $_this.parents('tr');
        var discountVal = row.find('input[name="discount"]').val();
        var discount_type_length = row.find('select[name="discount_type"]').length;

        if (discount_type_length == 0)
        {
            var val = row.find('button[name="discount_type"]').children('input').val();

            if (val == 'fa-ban')
            {
                var discount_type = '';
            }
            else if (val == 'fa-percentage')
            {
                var discount_type = 'percentage';
            }
            else if (val == 'fa-money-bill')
            {
                var discount_type = 'flat_amount';
            }
        }
        else
        {
            var discount_type = row.find('select[name="discount_type"]').val();
        }
        if ((typeof discount_type != 'undefined') && (typeof discountVal != 'undefined'))
        {
            var discount = standardCurrencyFormat(discountVal);
        }
        var price = row.find('input[name="price"]').val() || '0';
        var currency = row.find('input[name="price"]').data('currency');
        price = parseFloat(currencyUnformat(price, currency));
        var quantity = (row.find('input[name="quantity"]').val());
        quantity = parseFloat(currencyUnformat(quantity, currency));

        var condition = (field == true) ? (discount_type != '') : (discount > 0 && discount_type != '')

        if (condition)
        {
            if ((price >= 0 && quantity > 0) || (quantity > 0 && type))
            {
                if (field == true && price != 0)
                {
                    row.find('input[name="discount"]').removeClass("d-none");
                }
                else if (price == 0)
                {
                    row.find('input[name="discount"]').val('');
                    discount = 0;
                }
                let totalDiscount = calculateDiscount(discount_type, discount, price);
                let item_subtotal = currencyWithSymbolFormat(currencyFormat((totalDiscount * quantity), currency), currency);
                row.find('.item-subtotal').html(item_subtotal);
            }
            else
            {
                if (quantity <= 0)
                {
                    alertify.error('{{ trans('fi.invalid_quantity_amount') }}', 5);
                }
            }
        }
        else
        {

            if (field == true)
            {
                row.find('input[name="discount"]').addClass("d-none").val('');
            }
            if (price >= 0 && quantity > 0 || (quantity > 0 && type))
            {
                let totalDiscount = calculateDiscount(discount_type, discount, (price * 1).toFixed('{{config('fi.amountDecimals')}}'));
                let item_subtotal = currencyWithSymbolFormat(currencyFormat((totalDiscount * quantity), currency), currency);
                row.find('.item-subtotal').html(item_subtotal);
            }
            else
            {
                row.find('input[name="price"]').prop("readonly", false);
                if (quantity <= 0)
                {
                    alertify.error('{{ trans('fi.invalid_quantity_amount') }}', 5);
                }
            }
        }
    }

    function checkInvoiceTotalLessThenZero(obj, currency)
    {
        var total = 0;

        for (var key in obj)
        {
            if (obj.hasOwnProperty(key))
            {
                if (typeof obj[key] === 'object' && (obj[key]) !== null)
                {
                    let discount_type = obj[key].hasOwnProperty('discount_type') ? obj[key]['discount_type'] : '';
                    let discount = obj[key].hasOwnProperty('discount') ? currencyUnformat(obj[key]['discount'], currency) : '';
                    let price = currencyUnformat(obj[key]['price'], currency);
                    let quantity = currencyUnformat(obj[key]['quantity'], currency);
                    let field = ('discount-type' == discount_type);
                    let condition = (field == true) ? (discount_type != '') : (discount > 0 && discount_type != '')
                    if (condition)
                    {
                        if (price != 0 && quantity > 0)
                        {
                            let totalDiscount = calculateDiscount(discount_type, discount, price);
                            let item_subtotal = (totalDiscount * quantity);
                            total = total + item_subtotal;
                        }
                    }
                    else
                    {
                        if (price != 0 && quantity > 0)
                        {
                            let totalDiscount = calculateDiscount(discount_type, discount, (price * 1).toFixed(2));
                            let item_subtotal = (totalDiscount * quantity);
                            total = total + item_subtotal;
                        }
                    }
                }
            }
        }

        return total;
    }

    if ('{{config('time_tracking_enabled')}}' == true)
    {
        function pad(val)
        {
            return val > 9 ? val : "0" + val;
        }
    }
    $(function () {
        @if( class_exists(\Addons\ProformaInvoice\Models\ProformaInvoice::class) == true && config('proforma_invoice_enabled') == true )
        @can('proforma_invoices.create')
        $('.create-proforma_invoice').click(function () {
            var clientName = $(this).data('unique-name');
            var clientId = $(this).data('client-id');
            if (leaveChange == false)
            {
                $('#modal-placeholder').load('{{ route('proforma.invoices.create') }}', function () {
                    $('#create_client_name').val(clientName).trigger('change');
                    if (clientId != null)
                    {
                        if (clientId != 'undefined')
                        {
                            $('#create_client_name').val(clientId).trigger('change');
                            $('.client-detail').hide();
                        }
                    }
                });
            }
        });
        @endcan
        @endif

        $(document).off('click', '.custom-img-view').on('click', '.custom-img-view', function () {
            var $_this = $(this);
            $('#attachment-modal-placeholder').load('{!! route('custom.img.view.modal') !!}', {
                    id: $_this.data('id'),
                    filed_name: $_this.data('filed_name'),
                    type: $_this.data('type'),
                    modalName: 'custom-img-view',
                },
                function (response, status, xhr) {
                    if (status == "error")
                    {
                        var response = JSON.parse(response);
                        alertify.error(response.message);
                    }
                }
            );
        });
        @if(config('support_ticket_enabled') ==  true)
        $('.create-support-desk').click(function () {
            $('#modal-placeholder').load('{!! route('support.ticket.create.modal') !!}', {
                    modalName: 'support-ticket-create',
                    id: $(this).data('id')
                },
                function (response, status, xhr) {
                    if (status == "error")
                    {
                        var response = JSON.parse(response);
                        alertify.error(response.message);
                    }
                }
            );
        });
        @endif
    });

    function itemLookupTabFunctionality(settings, descriptionSelectUnselect = null)
    {
        $(document).on('select2:open', '.item-lookup', function () {
            var $this = $(this);
            $(document).on('keydown', ".select2-search__field", (e) => {
                if (e.key == 'Tab')
                {
                    $this.select2(settings).val(null).trigger('change');
                    $this.select2(settings).val($this.find('option:last').val()).trigger('change');
                    var row = $(this).closest('tr');
                    row.find('textarea[name="description"]').val(((descriptionSelectUnselect) ? descriptionSelectUnselect : (row.find('textarea[name="description"]').val())));
                    row.find('input[name="quantity"]').val(1);
                    row.find('input[name="price"]').val('');
                    row.find('select[name="tax_rate_id"]').val('{{ config('fi.itemTaxRate') != '' ? config('fi.itemTaxRate') : 0 }}');
                    row.find('select[name="tax_rate_2_id"]').val('{{ config('fi.itemTax2Rate') != '' ? config('fi.itemTax2Rate') : 0 }}');
                    row.find('.lbl_item_lookup').show();
                    row.find('.item-subtotal').text('');
                }
            });
        });
    }

    (function ($) {
        $.fn.serializeFormJSON = function () {

            var o = {};
            var a = this.serializeArray();
            $.each(a, function () {
                if (o[this.name])
                {
                    if (!o[this.name].push)
                    {
                        o[this.name] = [o[this.name]];
                    }
                    o[this.name].push(this.value || '');
                }
                else
                {
                    o[this.name] = this.value || '';
                }
            });
            return o;
        };
    })(jQuery);

</script>