<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\ItemLookups\Models;

use Illuminate\Support\Facades\Cache;

class ItemCategoryObserver
{
    public function created(ItemCategory $itemCategory)
    {
        Cache::forget('getListItemCategoryCache');
        Cache::forget('getDropDownListItemCategoryCache');
    }

    public function updated(ItemCategory $itemCategory)
    {
        Cache::forget('getListItemCategoryCache');
        Cache::forget('getDropDownListItemCategoryCache');
    }

    public function deleted(ItemCategory $itemCategory)
    {
        Cache::forget('getListItemCategoryCache');
        Cache::forget('getDropDownListItemCategoryCache');
        ItemLookup::where('category_id', $itemCategory->id)->update(['category_id' => 0]);
    }
}