<!doctype html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>{{ trans('fi.'.$invoice['type']) }} #{{ $invoice['number'] }}</title>

    <style>
        @page {
            margin: 25px;
        }

        body {
            color: #001028;
            background: #FFFFFF;
            font-family: DejaVu Sans, Helvetica, sans-serif;
            font-size: 12px;
            margin-left: 0px;
            margin-right: 0px;
        }

        a {
            color: #5D6975;
            border-bottom: 1px solid currentColor;
            text-decoration: none;
        }

        h1 {
            color: #5D6975;
            font-size: 2.8em;
            line-height: 1.4em;
            font-weight: bold;
            margin: 0;
        }

        table {
            width: 100%;
            border-spacing: 0;
            margin-bottom: 20px;
            padding: 0 2px;
        }

        th, .section-header {
            padding: 16px 10px;
            color: #5D6975;
            border-bottom: 1px solid #C1CED9;
            white-space: nowrap;
            font-weight: normal;
            text-align: center;
        }

        @media only screen and (max-width: 600px) {
            th, .section-header {
                padding: 5px 4px;
            }
        }

        @media only screen and (max-width: 320px) {
            table {
                width: 100%;
                border-spacing: 0;
                margin-bottom: 20px;
                font-size: 10px;
                margin-left: 0px;
            }
        }

        td {
            padding: 10px 5px;
        }

        table.alternate tr:nth-child(odd) td {
            background: #F5F5F5;
        }

        table.customfield-table tr td {
            background: inherit !important;
        }

        th.amount, td.amount {
            text-align: right;
        }

        .info {
            color: #5D6975;
            font-weight: bold;
        }

        .terms {
            padding: 10px;
            text-align: center;
        }

        .footer {
            text-align: center;
            padding: 10px;
        }

        #cp-logo {
            max-width: 114px;
        }

        .text-danger {
            color: #dc3545;
            font-weight: bold;
        }

    </style>
</head>
<body class="body-light">

<table class="body-light">
    <tr>
        <td style="width: {{ config('fi.qrCodeOnInvoiceQuote') == 1 ? 33 : 50 }}%;" valign="top">
            <h1>{{ mb_strtoupper(trans('fi.'.$invoice['type'])) }}</h1>
            <span class="info">{{ mb_strtoupper(trans('fi.'.$invoice['type'])) }} #</span>{{ $invoice['number'] }}<br>
            <span class="info">{{ mb_strtoupper(trans('fi.issued')) }}</span> {{ $invoice['formatted_created_at'] }}<br>
            <span class="info">{{ mb_strtoupper(trans('fi.due_date')) }}</span> {{ $invoice['due_at'] }}<br><br>
            <span class="info">{{ mb_strtoupper(trans('fi.bill_to')) }}</span><br>
            {{ $invoice['bill_to'] }}
            <br><br>
            @if (isset($invoice['client_formatted_address']) && $invoice['client_formatted_address'] != null)
                {!! $invoice['client_formatted_address'] !!}
                <br>
            @endif
            @if(config('fi.clientColumnSettingsVatTaxId') == 1)
                @if(isset($invoice['vat_tax_id']) && $invoice['vat_tax_id'] != null)
                    <span class="info">{{ trans('fi.vat_tax_id') }}:</span>
                    {{ $invoice['vat_tax_id'] }}
                    <br>
                @endif
            @endif
        </td>
        @if(config('fi.qrCodeOnInvoiceQuote') == 1 && isset($invoice['qr_code']) && $invoice['qr_code'] != null)
            <td style="width: 33%;" valign="top" align="center">
                <img alt="QR-Code" width=""
                     src="data:image/png;base64,{!! $invoice['qr_code'] !!}"
                     class="img-responsive">
            </td>
        @endif
        <td style="width: {{ config('fi.qrCodeOnInvoiceQuote') == 1 ? 33 : 50 }}%; text-align: right;" valign="top">
            {!! $invoice['company_logo'] !!}<br>
            {{ $invoice['company'] }}<br>
            {!! $invoice['company_address'] !!}<br>
            @if (isset($invoice['company_phone']) && $invoice['company_phone'] != null) {{ $invoice['company_phone'] }}
            <br>@endif
            @if (isset($invoice['user_from_email']) && $invoice['user_from_email'] != null)
                <a href="mailto:{{$invoice['user_from_email']}}">{{$invoice['user_from_email']}}</a><br>@endif
            @if(config('fi.clientColumnSettingsVatTaxId') == 1)
                <br>{!! nl2br($invoice['company_vat_detail']) !!}
            @endif
        </td>
    </tr>
</table>


<table class="alternate  table-light">
    <thead>
    <tr>
        <th style="text-align: left;"><strong>{{ mb_strtoupper(trans('fi.product')) }}</strong></th>
        <th style="text-align: left;"><strong>{{ mb_strtoupper(trans('fi.description')) }}</strong></th>
        <th class="amount"><strong>{{ mb_strtoupper(trans('fi.quantity')) }}</strong></th>
        <th class="amount"><strong>{{ mb_strtoupper(trans('fi.price')) }}</strong></th>
        @if ($invoice['has_line_item_discount'])
            <th class="amount"><strong>{{ mb_strtoupper(trans('fi.discount')) }}</strong></th>
        @else
            <th class="amount"></th>
        @endif
        <th class="amount"><strong>{{ mb_strtoupper(trans('fi.total')) }}</strong></th>
    </tr>
    </thead>

    <tbody>

    @foreach ($invoice['items'] as $item)

        <tr>
            <td style="text-align: left;" valign="top">{!! $item['name'] !!}</td>
            <td>
                {!! $item['description'] !!}
                @if(isset($item['custom']) && count($item['custom']))
                    <table class="customfield-table" style="padding: 5px 0 0 0;">
                        @foreach(array_chunk($item['custom'], 3) as $chunkInvoiceItemCustomField)
                            <tr>
                                @foreach($chunkInvoiceItemCustomField as $invoiceItemCustomField)
                                    @foreach($invoiceItemCustomField as $key => $value)

                                        <td style="padding: 10px 0;">
                                            <strong>{{ ucfirst($key) }} :</strong>
                                            <span style="margin-left: 4px;">{!! $value !!}</span>
                                        </td>
                                    @endforeach
                                @endforeach
                            </tr>
                        @endforeach
                    </table>
                @endif
            </td>
            <td class="amount">{{ $item['quantity'] }}</td>
            <td class="amount">{{ $item['price'] }}</td>
            @if ($invoice['has_line_item_discount'])
                <td class="amount">{{ $item['formatted_discount'] }}</td>
            @else
                <td class="amount"></td>
            @endif
            <td class="amount">{{ $item['item_subtotal'] }}</td>
        </tr>
    @endforeach

    <tr>
        <td colspan="5" class="amount"><strong>{{ mb_strtoupper(trans('fi.subtotal')) }}</strong></td>
        <td class="amount">{{ $invoice['subtotal'] }}</td>
    </tr>

    @if ($invoice['discount'] > 0)
        <tr>
            <td colspan="5" class="amount">{{ mb_strtoupper(trans('fi.discount')) }}</td>
            <td class="amount">{{ $invoice['formatted_discount'] }}</td>
        </tr>
    @endif
    @if (isset($invoice['term_discount']) && !empty($invoice['term_discount']))
        <tr>
            <td colspan="5" class="amount">{{ mb_strtoupper(trans('fi.payment_terms_error.term_discount')) }}</td>
            <td class="amount">{{ $invoice['term_discount'] }}</td>
        </tr>
    @endif

    @foreach ($invoice['summarized_taxes'] as $tax)
        <tr>
            <td colspan="5" class="amount">{{ mb_strtoupper($tax['name']) }} ({{ $tax['percent'] }})</td>
            <td class="amount">{{ $tax['total'] }}</td>
        </tr>
    @endforeach

    @if(isset($invoice['convenience_charges']) && !empty($invoice['convenience_charges']))
        <tr>
            <td colspan="5" class="amount"><strong>{{ mb_strtoupper(config('fi.feeName')) }}
                    ({{ config('fi.feePercentage') }}%)</strong>
            </td>
            <td class="amount">{{ $invoice['convenience_charges'] }}</td>
        </tr>
    @endif
    <tr>
        <td colspan="5" class="amount"><strong>{{ mb_strtoupper(trans('fi.total')) }}</strong></td>
        <td class="amount">{{ $invoice['total']}}</td>
    </tr>
    <tr>
        <td colspan="5" class="amount">
            <strong>{{ $invoice['paid_label'] }}</strong>
        </td>
        <td class="amount">{{ $invoice['paid'] }}</td>
    </tr>
    <tr>
        <td colspan="5" class="amount"><strong>{{ mb_strtoupper(trans('fi.balance')) }}</strong></td>
        <td class="amount">{{ $invoice['balance'] }}</td>
    </tr>
    </tbody>
</table>

<table class="body-light">
    <tbody>
    @if($invoice['online_payment_processing_fee'] == trans('fi.yes') || $invoice['terms']  != null)
        <tr>
            <td colspan="2">
                <div class="section-header">{{ mb_strtoupper(trans('fi.terms_and_conditions')) }}</div>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                @if($invoice['online_payment_processing_fee'] == trans('fi.yes'))
                    <div class="terms">{!! config('fi.feeExplanation') !!}<span class="text-danger"> *</span></div>
                @endif

                @if ($invoice['terms'] != null)
                    <div class="terms">{!! $invoice['terms'] !!}</div>
                @endif
            </td>
        </tr>
    @endif

    @if($invoice['footer']  != null)
        <tr>
            <td colspan="2">
                <div class="section-header">{{ mb_strtoupper(trans('fi.footer')) }}</div>
            </td>
        </tr>
        <tr>
            <td colspan="2">

                <div class="footer">{!! $invoice['footer'] !!}</div>

            </td>
        </tr>
    @endif
    </tbody>
</table>

</body>
</html>
