<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Invoices\Requests;

use FI\Modules\Quotes\Requests\QuoteStoreRequest;
use FI\Requests\RemoveTagsRule;

class InvoiceUpdateSummaryAndTagRequest extends QuoteStoreRequest
{
    public function authorize()
    {
        return true;
    }

    public function attributes()
    {
        return [
            'summary' => trans('fi.summary'),
            'tags'    => trans('fi.tags'),
        ];
    }

    public function rules()
    {
        return [
            'summary' => [new RemoveTagsRule],
            'tags.*'  => [new RemoveTagsRule]
        ];
    }
}