<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Invoices\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\Clients\Models\Client;
use FI\Modules\CompanyProfiles\Models\CompanyProfile;
use FI\Modules\DocumentNumberSchemes\Models\DocumentNumberScheme;
use FI\Modules\Invoices\Models\Invoice;
use FI\Modules\Invoices\Requests\InvoiceStoreRequest;
use FI\Modules\PaymentTerms\Models\PaymentTerm;
use FI\Support\DateFormatter;
use Illuminate\Support\Facades\Gate;

class InvoiceCreateController extends Controller
{
    public function create()
    {
        $cp = CompanyProfile::where('is_default', 1)->first();
        return view('invoices._modal_create')
            ->with('companyProfiles', CompanyProfile::getList())
            ->with('clients', Client::getDropDownList())
            ->with('documentNumberSchemes', DocumentNumberScheme::getListGroup())
            ->with('paymentTerms', PaymentTerm::getDropDownList())
            ->with('defaultPaymentTerms', (isset($cp->payment_term_id) && !empty($cp->payment_term_id)) ? $cp->payment_term_id : config('fi.defaultPaymentTerms'))
            ->with('isClientCreate', Gate::check('clients.create'));
    }

    public function store(InvoiceStoreRequest $request)
    {
        $input = $request->except('client_id');

        $client = Client::find($request->input('client_id'));
        if (false === $client)
        {
            return response()->json(['errors' => [[trans('fi.no_auth_to_create_client')]]], 403);
        }
        $input['client_id']    = $client->id;
        $input['invoice_date'] = DateFormatter::unformat($input['invoice_date']);

        $invoice = Invoice::create($input);

        return response()->json(['id' => $invoice->id], 200);
    }
}