<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Expenses\Requests;


use FI\Modules\Expenses\Models\ExpenseVendor;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Response;

class ExpenseVendorDeleteRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $expenseVendor = ExpenseVendor::find($this->id);

        if (isset($expenseVendor->expenses) && $expenseVendor->expenses->count() > 0)
        {
            throw new HttpResponseException(response()->json(
                [
                    'success' => false,
                    'message' => trans('fi.expense_vendor_already_used'),
                ], Response::HTTP_BAD_REQUEST));
        }
        else
        {
            return [];
        }
    }

}