<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Expenses\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class ExpenseCategory extends Model
{
    protected $table = 'expense_categories';

    protected $guarded = ['id'];

    /*
    |--------------------------------------------------------------------------
    | Static Methods
    |--------------------------------------------------------------------------
    */

    public static function getList()
    {
        return Cache::rememberForever('getListExpenseCategoryCache', function ()
        {
            return self::whereIn('id', function ($query)
            {
                $query->select('category_id')->distinct()->from('expenses');
            })->orderBy('name')->pluck('name', 'id')->all();
        });
    }

    public static function getDropDownList()
    {
        return Cache::rememberForever('getDropDownListExpenseCategoryCache', function ()
        {
            return ['' => trans('fi.select-expense-category')] + self::select('name')->orderBy('name')->pluck('name', 'name')->all();
        });
    }

    public static function getCategoryList()
    {
        return Cache::rememberForever('getCategoryListExpenseCategoryCache', function ()
        {
            return ['' => trans('fi.select-expense-category')] + self::select('name', 'id')->orderBy('name')->pluck('name', 'id')->all();
        });
    }
}