<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Expenses\Events;

use FI\Events\Event;
use FI\Modules\Expenses\Models\ExpenseVendor;
use Illuminate\Queue\SerializesModels;

class AddTransitionVendor extends Event
{
    use SerializesModels;

    public $expenseVendor;
    public $actionType;
    public $previousValue;
    public $currentValue;
    public $detail;

    public function __construct(ExpenseVendor $expenseVendor, $actionType, $previousValue = null, $currentValue = null)
    {
        $this->expenseVendor = $expenseVendor;
        $this->actionType    = $actionType;
        $this->previousValue = $previousValue;
        $this->currentValue  = $currentValue;
        $this->detail        = [
            'name' => $expenseVendor->name
        ];
    }
}