<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Emails\Models;

use Illuminate\Database\Eloquent\Model;

class DefaultEmailTemplate extends Model
{
    protected $table = 'default_email_templates';

    protected $guarded = ['id'];

    public static function getOnlyKeyValues($key = null)
    {
        $defaultMailTemplateValues = self::defaultMailTemplateValues();
        $flattenedArray            = array_merge($defaultMailTemplateValues['quotes'], $defaultMailTemplateValues['proformaInvoices'], $defaultMailTemplateValues['invoices'], $defaultMailTemplateValues['payments']);
        return ($key != null) ? $flattenedArray[$key] : $flattenedArray;
    }

    public static function defaultMailTemplateValues($model = null, $key = null)
    {
        $defaultTemplateDetails = [

            'quotes' => [
                'quoteSubjectDefault'              => 'Quote #{!! $quote->number !!}',
                'quoteMailTemplateDefault'         => '<p>To view your quote from {{ $quote->companyProfile->company }} for {{ $quote->amount->formatted_total }}, click the link below:</p>' . "\r\n\r\n" . '<p><a href="{{ $quote->public_url }}">{{ $quote->public_url }}</a></p>',
                'quoteApprovedSubjectDefault'      => 'Quote #{!! $quote->number !!}',
                'quoteApprovedMailTemplateDefault' => '<p><a href="{!! $quote->public_url !!}">Quote #{!! $quote->number !!}</a> has been APPROVED.</p>',
                'quoteRejectedSubjectDefault'      => 'Quote #{!! $quote->number !!}',
                'quoteRejectedMailTemplateDefault' => '<p><a href="{!! $quote->public_url !!}">Quote #{!! $quote->number !!}</a> has been REJECTED.</p>',
                'quoteAttachPDF'                   => 0
            ],

            'proformaInvoices' => [
                'proformaInvoiceSubjectDefault'              => 'PI #{!! $proformainvoice->number !!}',
                'proformaInvoiceMailTemplateDefault'         => '<p>To view your Proforma invoice from {!! $proformainvoice->companyProfile->company !!} for {!! $proformainvoice->amount->formatted_total !!}, click the link below:</p>' . "\r\n\r\n" . '<p><a href="{!! $proformainvoice->public_url !!}">{!! $proformainvoice->public_url !!}</a></p>',
                'proformaInvoiceApprovedSubjectDefault'      => 'PI #{!! $proformainvoice->number !!}',
                'proformaInvoiceApprovedMailTemplateDefault' => '<p><a href="{!! $proformainvoice->public_url !!}">Proforma Invoice #{!! $proformainvoice->number !!}</a> has been APPROVED.</p>',
                'proformaInvoiceRejectedSubjectDefault'      => 'PI #{!! $proformainvoice->number !!}',
                'proformaInvoiceRejectedMailTemplateDefault' => '<p><a href="{!! $proformainvoice->public_url !!}">ProformaInvoice #{!! $proformainvoice->number !!}</a> has been REJECTED.</p>',
                'proformaInvoiceAttachPDF'                   => 0
            ],

            'invoices' => [
                'invoiceSubjectDefault'             => 'Invoice #{!! $invoice->number !!}',
                'invoiceMailTemplateDefault'        => '<p>To view your invoice from {{ $invoice->companyProfile->company }} for {{ $invoice->amount->formatted_total }}, click the link below:</p>' . "\r\n\r\n" . '<p><a href="{{ $invoice->public_url }}">{{ $invoice->public_url }}</a></p>',
                'invoiceAttachPDF'                  => 0,
                'creditMemosSubjectDefault'         => 'Credit Memo #{!! $invoice->number !!}',
                'creditMemosMailTemplateDefault'    => '<p>To view your credit memo from {{ $invoice->companyProfile->company }} for {{ $invoice->amount->formatted_total }}, click the link below:</p>' . "\r\n\r\n" . '<p><a href="{{ $invoice->public_url }}">{{ $invoice->public_url }}</a></p>',
                'overdueInvoiceSubjectDefault'      => 'Invoice #{!! $invoice->number !!}',
                'overdueInvoiceMailTemplateDefault' => '<p>This is a reminder to let you know your invoice from AppleButter Software for {!! $invoice->amount->formatted_total !!} is overdue. Click the link below to view the invoice:</p>' . "\r\n\r\n" . '<p><a href="{!! $invoice->public_url !!}">{!! $invoice->public_url !!}</a></p>',
                'overdueInvoiceReminderFrequency'   => '',
                'overdueAttachInvoice'              => 0
            ],

            'payments' => [
                'paymentReceiptSubjectDefault'       => 'Thank you for your payment of: {!! $payment->formatted_amount_with_currency !!}',
                'paymentReceiptMailTemplateDefault'  => '<p>Thank you! {!! $payment->payment_applications_with_links !!}</p>',
                'paymentAttachInvoice'               => 0,
                'upcomingPaymentSubjectDefault'      => 'Upcoming Payment Due Notice: Invoice #{!! $invoice->number !!}',
                'upcomingPaymentMailTemplateDefault' => '<p>This is a notice to let you know your invoice from {!! $invoice->companyProfile->company !!} for {!! $invoice->amount->formatted_total !!} is due on {!! $invoice->formatted_due_at !!}. Click the link below to view the invoice:</p>' . "\r\n\r\n" . '<p><a href="{!! $invoice->public_url !!}">{!! $invoice->public_url !!}</a></p>',
                'upcomingPaymentNoticeFrequency'     => '',
                'upcomingPaymentNoticeAttachInvoice' => 0
            ]
        ];
        if ($model != '' && $key == '')
        {
            return isset($defaultTemplateDetails[$model]) ? $defaultTemplateDetails[$model] : '';
        }
        if ($model != '' && $key != '')
        {
            return isset($defaultTemplateDetails[$model][$key]) ? $defaultTemplateDetails[$model][$key] : '';
        }
        return $defaultTemplateDetails;
    }

    public static function isDifferenceFromDefaultValue($actionType)
    {
        $isChangeModelValue = [
            'quote'                   => ['quoteSubjectDefault', 'quoteMailTemplateDefault'],
            'quoteApproved'           => ['quoteApprovedSubjectDefault', 'quoteApprovedMailTemplateDefault'],
            'quoteRejected'           => ['quoteRejectedSubjectDefault', 'quoteRejectedMailTemplateDefault'],
            'proformaInvoice'         => ['proformaInvoiceSubjectDefault', 'proformaInvoiceMailTemplateDefault'],
            'proformaInvoiceApproved' => ['proformaInvoiceApprovedSubjectDefault', 'proformaInvoiceApprovedMailTemplateDefault'],
            'proformaInvoiceRejected' => ['proformaInvoiceRejectedSubjectDefault', 'proformaInvoiceRejectedMailTemplateDefault'],
            'invoice'                 => ['invoiceSubjectDefault', 'invoiceMailTemplateDefault', 'invoiceAttachPDF'],
            'creditMemos'             => ['creditMemosSubjectDefault', 'creditMemosMailTemplateDefault'],
            'overdueInvoice'          => ['overdueInvoiceSubjectDefault', 'overdueInvoiceMailTemplateDefault', 'overdueInvoiceReminderFrequency', 'overdueAttachInvoice'],
            'paymentReceipt'          => ['paymentReceiptSubjectDefault', 'paymentReceiptMailTemplateDefault', 'paymentAttachInvoice'],
            'upcomingPayment'         => ['upcomingPaymentSubjectDefault', 'upcomingPaymentMailTemplateDefault', 'upcomingPaymentNoticeFrequency', 'upcomingPaymentNoticeAttachInvoice'],
        ];

        if (isset($isChangeModelValue[$actionType]))
        {
            foreach ($isChangeModelValue[$actionType] as $key)
            {
                if (config('fi.' . $key) != self::getOnlyKeyValues($key))
                {
                    return ['isChange' => true, 'keys' => (isset($isChangeModelValue[$actionType]) ? $isChangeModelValue[$actionType] : '')];
                }
            }
            return ['isChange' => false, 'keys' => (isset($isChangeModelValue[$actionType]) ? $isChangeModelValue[$actionType] : '')];
        }
    }
}