<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Emails\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\Emails\Models\DefaultEmailTemplate;
use FI\Modules\Settings\Models\Setting;
use Illuminate\Http\Request;

class DefaultEmailTemplateController extends Controller
{

    public function resetModel()
    {
        try
        {
            return view('default_mails._modal_default_mail_template')->with('actionType', request('actionType'))->with('modelTemplateName', request('modelTemplateName'));
        }
        catch (\Exception $e)
        {
            return response()->json(['success' => false, 'message' => ($e->getCode() == 0) ? trans('fi.modal_not_found') : $e->getMessage()], 400);
        }
    }

    public function resetMailTemplate(Request $request)
    {
        try
        {
            $defaultValueMailTemplate     = DefaultEmailTemplate::getOnlyKeyValues();
            $isDifferenceFromDefaultValue = DefaultEmailTemplate::isDifferenceFromDefaultValue($request->actionType);
            if (isset($isDifferenceFromDefaultValue['keys']))
            {
                foreach ($isDifferenceFromDefaultValue['keys'] as $key)
                {
                    Setting::saveByKey($key, $defaultValueMailTemplate[$key]);
                }
            }
            return response()->json(['success' => true, 'message' => trans('fi.reset_default_mail_template', ['model' => $request->modelTemplateName])], 200);

        }
        catch (\Exception $e)
        {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 400);
        }
    }
}