<script type="text/javascript">
    $(function () {

        $('body #modal-view-revision').modal();

    });
</script>
<style>
    .revision-scroller::-webkit-scrollbar {
        height: 6px;
        width: 6px;
        cursor: e-resize;
    }

    .revision-scroller::-webkit-scrollbar-thumb {
        border-radius: 10px;
        background-color: #fff;
        -webkit-box-shadow: inset 0 0 6px rgb(206 212 218);
    }

    .font-weight-custom {
        font-size: .875rem !important;
    }

    .dropdown-divider-custom {
        border-top: 1px solid #b5b5b5 !important;
    }

    @media only screen and (max-width: 600px) {
        .revision-doc-watermark {
            left: 50px;
        }
    }

</style>
<div class="modal fade" id="modal-view-revision" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog text-break modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fa fa-history" aria-hidden="true"></i>
                    <span>
                        @if($revisionDoc->revision_number == 1)
                            {{ trans('fi.original') }}
                        @else
                            {{ trans('fi.revision') }} #{{$revisionDoc->revision_number - 1}}
                        @endif
                        <span class="badge">
                            <span class="badge badge-light">{{ $revisionDoc->formatted_created_at }}</span>
                            <span class="badge badge-light">#{{$invoice['number']}}</span>
                        </span>
                    </span>
                </h5>
                <button type="button" class="close close-hide" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body small revision-scroller overflow-auto text-nowrap"
                 style="max-height: calc(100vh - 100px);">
                <section class="content-header p-0">
                    <div class="container-fluid">
                        <div class="revision-doc-watermark"
                             style="top: 35% !important;">
                            @if($revisionDoc->revision_number > 1)
                                {{ trans('fi.revision') }}
                            @else
                                {{ trans('fi.original') }}
                            @endif
                        </div>
                    </div>
                </section>
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-10">
                                <div id="form-status-placeholder"></div>
                                @if($invoice['recurring_invoice_id'] > 0)
                                    <div class="card card-info card-outline">
                                        <div class="card-header">
                                            <h3 class="card-title">{{trans('fi.subscription_details')}}</h3>
                                        </div>
                                        <div class="card-body text-wrap font-weight-custom pt-2 pb-2">
                                            <div class="row">
                                                <div class="col-md-8">

                                                    <div class="form-group">
                                                        <label class="document-options-label">{{ trans('fi.explanation') }}
                                                            : </label>
                                                        <p class="m-0">
                                                            {{ $invoice['service_explanation']}}
                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">

                                                    <div class="form-group">
                                                        <label class="document-options-label">{{ trans('fi.service_starts') }}
                                                            : </label>
                                                        <p class="m-0">
                                                            {{ $invoice['formatted_service_starts_on']}}
                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">

                                                    <div class="form-group">
                                                        <label class="document-options-label">{{ trans('fi.service_ends') }}
                                                            : </label>
                                                        <p class="m-0">
                                                            {{ $invoice['formatted_service_ends_off']}}
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="card card-info card-outline">
                                    <!-- /.card-header -->
                                    <div class="card-body font-weight-custom pt-2 pb-2">
                                        <div class="row">
                                            <div class="col-md-8 text-wrap">
                                                <div class="form-group m-0">
                                                    <label class="m-0">
                                                        <div class="card-header pb-1 pl-0">
                                                            <h3 class="card-title">{{ trans('fi.summary') }}</h3>
                                                        </div>
                                                        <p class="font-weight-custom mb-1">
                                                            {{$invoice['summary']}}
                                                        </p>
                                                    </label>
                                                </div>
                                            </div>

                                            <!-- /.col -->
                                            <div class="col-md-4 text-wrap">
                                                <div class="form-group m-0">

                                                    <label class="m-0">

                                                        <div class="card-header pb-1 pl-0">
                                                            <h3 class="card-title">{{ trans('fi.tags') }}</h3>
                                                        </div>
                                                        <p class="mb-1">
                                                            @foreach($invoice['selected_tags'] as $tag)
                                                                <span class="badge badge-default">{{$tag}}</span>
                                                            @endforeach
                                                        </p>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                </div>

                                <div>
                                    <div class="row">
                                        <div class="col-sm-6 " id="col-from">
                                            <div class="card card-info card-outline">
                                                <div class="card-header">
                                                    <h3 class="card-title">{{ trans('fi.from') }}</h3>
                                                </div>
                                                <div class="card-body font-weight-custom text-wrap pt-2 pb-2">
                                                    <strong>{{ $invoice['company'] }}</strong><br>
                                                    {!! $invoice['company_address'] !!}<br>
                                                    {{ trans('fi.phone') }}: {{ $invoice['company_phone'] }}<br>
                                                    @if(isset($invoice['user_from_email']) && $invoice['user_from_email'] != null)
                                                        {{ trans('fi.email') }} : {{ $invoice['user_from_email'] }}
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-sm-6" id="col-to">
                                            <div class="card card-info card-outline">
                                                <div class="card-header">
                                                    <h3 class="card-title">{{ trans('fi.to') }}</h3>
                                                </div>
                                                <div class="card-body font-weight-custom pt-2 pb-2 text-wrap">
                                                    <strong>{{ $invoice['client_name'] }}</strong><br>

                                                    {!! $invoice['client_formatted_address'] !!}<br>
                                                    {{ trans('fi.phone') }}: {{ $invoice['client_phone'] }}<br>
                                                    {{ trans('fi.email') }}: {{ $invoice['client_email'] }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">

                                        <div class="col-sm-12" style="overflow-x: visible;">
                                            <div class="card card-info card-outline">
                                                <div class="card-header">
                                                    <h3 class="card-title">{{ trans('fi.items') }}</h3>
                                                </div>
                                                <div class="card-body text-wrap pt-2 pb-2 table-responsive font-weight-custom">
                                                    <table class="table table-hover table-striped table-sm text-nowrap">
                                                        <thead>
                                                        <tr>
                                                            <th></th>
                                                            <th> {{ trans('fi.product') }}
                                                                / {{ trans('fi.description') }}</th>
                                                            <th>{{ trans('fi.qty') }}</th>
                                                            <th>{{ trans('fi.price') }}</th>
                                                            @if($invoice['allow_line_item_discounts'] == true)
                                                                <th class="text-center">{{ trans('fi.discount') }}</th>
                                                            @endif
                                                            <th class="text-center">
                                                                {{ trans('fi.tax_1') }} @if(config('fi.numberOfTaxFields') == '2')
                                                                    / {{ trans('fi.tax_2') }}
                                                                @endif
                                                            </th>
                                                            <th class="text-right">{{ trans('fi.total') }}</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        @foreach ($invoice['items'] as $key =>  $item)

                                                            <tr>
                                                                <td><i class="fa fa-circle small"
                                                                       style=" font-size: 10px;"> </i></td>
                                                                <td>
                                                                    {{$item['name']}}
                                                                    <br>
                                                                    {{$item['description']}}
                                                                </td>
                                                                <td class="text-center">{{$item['quantity']}}</td>
                                                                <td class="text-center">{{$item['numeric_price']}}</td>
                                                                @if($invoice['allow_line_item_discounts'] == true)
                                                                    <td class="text-center">
                                                                        @if($item['discount_type'] == '')
                                                                            <i class="fa fa-ban"></i>
                                                                        @elseif($item['discount_type'] == 'percentage')
                                                                            {{$item['numeric_discount']}}
                                                                            <i class="fa fa-percentage"></i>
                                                                        @elseif($item['discount_type'] == 'flat_amount')
                                                                            {{$item['numeric_discount']}}
                                                                            <i class="fa fa-money-bill"></i>
                                                                        @endif
                                                                    </td>
                                                                @endif
                                                                <td class="text-center">
                                                                    <p class="m-0 ">{{ $item['tax_rate_id'] }}</p>@if(config('fi.numberOfTaxFields') == '2')
                                                                        <p class="m-0 ">{{ $item['tax_rate_2_id'] }}</p>
                                                                    @endif
                                                                </td>
                                                                <td class="text-right ">{{ $item['item_subtotal'] }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td></td>
                                                                <td colspan="{{ ($invoice['allow_line_item_discounts'] == true) ? 6 : 5 }}">
                                                                    @if (isset($item['custom']) && count($item['custom']) > 0)
                                                                        @foreach (array_chunk($item['custom'], 3) as $customFieldsChunk)
                                                                            <div class="row">
                                                                                @foreach($customFieldsChunk as $customField)
                                                                                    @foreach($customField as $key => $value)
                                                                                        <div class="col-md-4">
                                                                                            <div class="form-group">
                                                                                                <label>{{ $key }}
                                                                                                    :</label>
                                                                                                <span>{{ $value }}</span>
                                                                                            </div>
                                                                                        </div>
                                                                                    @endforeach
                                                                                @endforeach
                                                                            </div>
                                                                        @endforeach
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                @if($invoice['is_payment_term'] && $invoice['payment_term_description'] !='')
                                    <div class="row font-weight-custom text-wrap">
                                        <div class="col-12">
                                            <div class="card">
                                                <div class="card-header pt-2 pb-2 border-bottom-0">
                                                    <span> <strong>{{trans('fi.payment_terms')}}:</strong> {!! $invoice['payment_term_description'] !!}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <div class="row">
                                    <div class="col-12">
                                        <div class="card card-info card-outline card-outline-tabs">
                                            <div class="card-header p-0 border-bottom-0">
                                                <ul class="nav nav-tabs">
                                                    <li class="nav-item">
                                                        <a href="#tab-additional-inv" class="nav-link  active"
                                                           data-toggle="tab">{{ trans('fi.additional') }}</a>
                                                    </li>
                                                    @if ($invoice['custom'] && count($invoice['custom']) > 0)
                                                        <li class="nav-item">
                                                            <a href="#tab-custom-inv" class="nav-link"
                                                               data-toggle="tab">
                                                                {{ trans('fi.custom_fields') }}
                                                            </a>
                                                        </li>
                                                    @endif

                                                </ul>
                                            </div>

                                            <div class="card-body text-wrap font-weight-custom pt-2 pb-2">
                                                <div class="tab-content">
                                                    <div class="tab-pane active " id="tab-additional-inv">
                                                        <div class="row">
                                                            <div class="col-lg-6 {{$invoice['type'] == 'invoice' && $invoice['payment_term_is_default'] == 0 ? 'd-none': 'd-block'}}">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.terms_and_conditions') }}</label>
                                                                    {!! Form::textarea('footer',$invoice['terms'], ['class' => 'form-control form-control-sm', 'rows' => 3, 'disabled']) !!}
                                                                </div>
                                                            </div>
                                                            <div class="{{$invoice['type'] == 'invoice' && $invoice['payment_term_is_default'] == 0 ? 'col-lg-12': 'col-lg-6'}}">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.footer') }}</label>
                                                                    {!! Form::textarea('footer', $invoice['footer'], ['class' => 'form-control form-control-sm', 'rows' => 3, 'disabled']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @if ($invoice['custom'] && count($invoice['custom']) > 0)
                                                        <div class="tab-pane" id="tab-custom-inv">
                                                            <div class="row">
                                                                @foreach ($invoice['custom'] as $key => $customField)
                                                                    @foreach($customField as $key => $value)
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <label>{{ $key }}:</label>
                                                                                <span>{{ $value }}</span>
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-2">

                                <div id="div-totals text-wrap">
                                    <div class="card card-info card-outline">
                                        <div class="card-body font-weight-custom p-2">

                                            <span class="float-left"><strong>{{ trans('fi.subtotal') }}</strong></span>
                                            <span class="float-right">{{ $invoice['subtotal'] }}</span>

                                            <div class="clearfix"></div>

                                            @if ($invoice['discount'] > 0)
                                                <span class="float-left"><strong>{{ trans('fi.discount') }}</strong></span>
                                                <span class="float-right">{{ $invoice['formatted_discount'] }}</span>

                                                <div class="clearfix"></div>
                                            @endif
                                            @if (isset( $invoice['term_discount']) &&  $invoice['term_discount']!= '')
                                                <span class="float-left"><strong>{{ trans('fi.payment_terms_error.term_discount') }}</strong></span>
                                                <span class="float-right">{{ $invoice['term_discount'] }}</span>

                                                <div class="clearfix"></div>
                                            @endif

                                            <span class="float-left"><strong>{{ trans('fi.tax') }}</strong></span>
                                            <span class="float-right">{{ $invoice['tax'] }}</span>

                                            <div class="clearfix"></div>

                                            @if (isset( $invoice['convenience_charges']) &&  $invoice['convenience_charges']!= '')
                                                <span class="float-left"><strong>{{ trans('fi.conven_charges') }}</strong></span>
                                                <span class="float-right">{{ $invoice['convenience_charges'] }}</span>

                                                <div class="clearfix"></div>
                                            @endif

                                            <span class="float-left"><strong>{{ trans('fi.total') }}</strong></span>
                                            <span class="float-right">{{ $invoice['total'] }}</span>

                                            <div class="clearfix"></div>

                                            <span class="float-left"><strong>{{ $invoice['paid_label']}}</strong></span>
                                            <span class="float-right">{{ $invoice['paid'] }}</span>

                                            <div class="clearfix"></div>

                                            <span class="float-left"><strong>{{ trans('fi.balance') }}</strong></span>
                                            <span class="float-right">{{ $invoice['balance'] }}</span>
                                            <div class="clearfix"></div>
                                        </div>
                                    </div>

                                </div>

                                <div class="text-wrap">
                                    <div class="card card-info card-outline">
                                        <div class="card-header">
                                            <h3 class="card-title">{{ trans('fi.options') }}</h3>
                                        </div>
                                        <div class="card-body font-weight-custom p-2">
                                            @if($invoice['type'] != 'credit_memo')
                                                <div class="form-group">
                                                    <label class="document-options-label">{{ trans('fi.allow_online_pay_fees') }}
                                                        : </label>
                                                    <p class="m-0">
                                                        {{$invoice['online_payment_processing_fee']}}
                                                    </p>
                                                </div>
                                                @if(isset($invoice['payment_term_name']))
                                                    <div class="form-group">
                                                        <label class="document-options-label">{{ trans('fi.payment_terms') }}
                                                            : </label>
                                                        <p class="m-0">
                                                            {{$invoice['payment_term_name']}}
                                                        </p>
                                                    </div>
                                                @endif
                                            @endif

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.invoice') }}
                                                    #</label>
                                                <p class="m-0">
                                                    {{$invoice['number']}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.date') }}</label>
                                                <p class="m-0">
                                                    {{$invoice['formatted_invoice_date']}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.due_date') }}</label>
                                                <p class="m-0">
                                                    {{$invoice['due_at']}}
                                                </p>
                                            </div>

                                            @if( $invoice['date_emailed'] != null)
                                                <div class="form-group">
                                                    <label class="document-options-label">{{ trans('fi.date_emailed') }}</label>
                                                    <p class="m-0">
                                                        {{ $invoice['date_emailed'] }}
                                                    </p>
                                                </div>
                                            @endif

                                            @if( $invoice['date_mailed'] != null)
                                                <div class="form-group">
                                                    <label class="document-options-label">{{ trans('fi.date_mailed') }}</label>
                                                    <p class="m-0">
                                                        {{ $invoice['date_mailed'] }}
                                                    </p>
                                                </div>
                                            @endif

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.discount') }}</label>
                                                <p class="m-0">
                                                    @if($invoice['discount_type'] == '')
                                                        <i class="fa fa-ban text-center"> </i>
                                                    @elseif($invoice['discount_type'] == 'percentage')
                                                        {{ $invoice['numeric_discount'] }}
                                                        <i class="fa fa-percentage pr-2"> </i>
                                                    @elseif($invoice['discount_type'] == 'flat_amount')
                                                        {{ $invoice['numeric_discount'] }}
                                                        <i class="fa fa-money-bill pr-2"> </i>
                                                    @endif
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.currency') }}</label>
                                                <p class="m-0">
                                                    {{$invoice['currency_code']}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.exchange_rate') }}</label>
                                                <p class="m-0">
                                                    {{$invoice['exchange_rate']}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.status') }}</label>
                                                <p class="m-0">
                                                    {{$invoice['status']}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.template') }}</label>
                                                <p class="m-0">{{$invoice['template']}}</p>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <div class="modal-footer pb-1 pt-1">
                <div class="col-sm-12">
                    <button type="button" class="btn btn-sm btn-outline-secondary float-right close-hide"
                            data-dismiss="modal"
                            id="btn-clear-column-filter">
                        {{ trans('fi.cancel') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>