<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\DocumentRevisions\Models;

use Addons\ProformaInvoice\Models\ProformaInvoice;
use FI\Modules\Invoices\Models\Invoice;
use FI\Modules\Quotes\Models\Quote;
use FI\Modules\RecurringInvoices\Models\RecurringInvoice;
use FI\Support\DateFormatter;
use FI\Support\HTML;
use FI\Traits\Sortable;
use Illuminate\Database\Eloquent\Model;

class DocumentRevision extends Model
{
    use Sortable;

    protected $table = 'document_revisions';

    protected $guarded = ['id'];

    public function revisable()
    {
        return $this->morphTo();
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'revisable_id')
            ->where('revisable_type', Invoice::class);
    }

    public function quote()
    {
        return $this->belongsTo(Quote::class, 'revisable_id')
            ->where('revisable_type', Quote::class);
    }

    public function recurringInvoice()
    {
        return $this->belongsTo(RecurringInvoice::class, 'revisable_id')
            ->where('revisable_type', RecurringInvoice::class);
    }

    public function proformaInvoice()
    {
        return $this->belongsTo(ProformaInvoice::class, 'revisable_id')
            ->where('revisable_type', ProformaInvoice::class);
    }

    /*
   |--------------------------------------------------------------------------
   | Accessors
   |--------------------------------------------------------------------------
   */

    public function getFormattedCreatedAtAttribute()
    {
        return DateFormatter::format($this->attributes['created_at']);
    }

    public function getHtmlAttribute()
    {
        return HTML::revision($this);
    }

    public function getFormattedTextAttribute()
    {
        return ($this->attributes['text'] != null) ? json_decode($this->attributes['text'], true) : '';
    }
}
