<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\CustomFields\Models;

use FI\Support\DateFormatter;
use Illuminate\Database\Eloquent\Model;

class UserCustom extends Model
{
    /**
     * The table name
     * @var string
     */
    protected $table = 'users_custom';

    /**
     * The primary key
     * @var string
     */
    protected $primaryKey = 'user_id';

    /**
     * Guarded properties
     * @var array
     */
    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Accessors
    |--------------------------------------------------------------------------
    */

    public function image($field_name, $width = null, $height = null)
    {
        $path = custom_field_path('users/' . $this->$field_name);

        if ($this->$field_name and file_exists($path))
        {
            $logo = base64_encode(file_get_contents($path));

            $style = '';

            if ($width and !$height)
            {
                $style = 'width: ' . $width . 'px;';
            }
            elseif ($width and $height)
            {
                $style = 'width: ' . $width . 'px; height: ' . $height . 'px;';
            }

            return '<p><a href="javascript:void(0)" class="btn custom-img-view p-0" data-type="custom-user" data-id="'.$this->user_id.'" data-filed_name="'.$field_name.'"><img id="cp-logo" src="data:image/png;base64,' . $logo . '" style="' . $style . '"></a></p><p><a href="javascript:void(0)" data-field-name="' . $field_name . '" class="btn-delete-custom-img">' . trans('fi.remove_image') . '</a></p>';
        }

        return null;
    }

    public function getDatePickerFormat()
    {
        return DateFormatter::getDatepickerFormat();
    }

    public function getDateTimePickerFormat()
    {
        return DateFormatter::getDateTimePickerFormat();
    }
}
