<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Countries\Models;

use FI\Traits\Sortable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Country extends Model
{
    use Sortable;

    protected $table = 'countries';

    protected $sortable = ['code', 'name'];

    /**
     * Guarded properties
     * @var array
     */
    protected $guarded = ['id'];

    public static function getAll()
    {
        return Cache::rememberForever('selectRawCountriesCache', function ()
        {
            return self::selectRaw("name,CONCAT(name, IF(local_name='', '', CONCAT(' (', `local_name` ,')'))) AS full_name")
                ->orderBy('name')
                ->pluck('full_name', 'name')
                ->all();
        });
    }
}