<table class="table table-hover table-striped">
    <thead>
    <tr>
        <th>{{ trans('fi.title') }}</th>
        <th>{{ trans('fi.name') }}</th>
        <th>{{ trans('fi.email') }}</th>
        <th>{{ trans('fi.primary_phone') }}</th>
        <th>{{ trans('fi.notes') }}</th>
        <th>{{ trans('fi.default_to') }}</th>
        <th>{{ trans('fi.default_cc') }}</th>
        <th>{{ trans('fi.default_bcc') }}</th>
        @if(Gate::check('contacts.update') || Gate::check('contacts.delete'))
            <th class="text-right">{{ trans('fi.options') }}</th>
        @endif
    </tr>
    </thead>
    <tbody class="contacts-tbody">
    @foreach ($contacts as $contact)
        <tr>
            <td>{{ $contact->title ? trans('fi.'.$contact->title) : '' }}</td>
            <td class="{{(!$contact->status) ? 'text-decoration-line-through' : ''}}">
                @can('contacts.update')
                    <a href="javascript:void(0)" class="btn-edit-contact"
                       data-url="{{ route('clients.contacts.edit', [$clientId, $contact->id]) }}">
                        {{ $contact->name }}
                    </a>
                @else
                    {{ $contact->name }}
                @endcan
            </td>
            <td class="{{(!$contact->status) ? 'text-decoration-line-through' : ''}}">{{ $contact->email }}</td>
            <td>{{ $contact->primary_phone }}</td>
            <td>{!! $contact->formatted_notes !!}</td>
            <td>
                @can('contacts.update')
                    <a href="javascript:void(0)" class="update-default" data-default="to"
                       data-contact-id="{{ $contact->id }}">{{ $contact->formatted_default_to }}</a>
                @else
                    {{ $contact->formatted_default_to }}
                @endcan
            </td>
            <td>
                @can('contacts.update')
                    <a href="javascript:void(0)" class="update-default" data-default="cc"
                       data-contact-id="{{ $contact->id }}">{{ $contact->formatted_default_cc }}</a>
                @else
                    {{ $contact->formatted_default_cc }}
                @endcan
            </td>
            <td>
                @can('contacts.update')
                    <a href="javascript:void(0)" class="update-default" data-default="bcc"
                       data-contact-id="{{ $contact->id }}">{{ $contact->formatted_default_bcc }}</a>
                @else
                    {{ $contact->formatted_default_bcc }}
                @endcan
            </td>
            @if(Gate::check('contacts.update') || Gate::check('contacts.delete'))
                <td class="text-right">
                    <div class="btn-group">
                        <button type="button" class="btn btn-sm btn-default dropdown-toggle"
                                data-toggle="dropdown">
                            {{ trans('fi.options') }} <span class="caret"></span>
                        </button>
                        <div class="dropdown-menu dropdown-menu-right">
                            @can('contacts.update')
                                <a href="javascript:void(0)" class="btn-edit-contact dropdown-item"
                                   data-url="{{ route('clients.contacts.edit', [$clientId, $contact->id]) }}">
                                    <i class="fa fa-edit"></i> {{ trans('fi.edit') }}</a>
                            @endcan
                            @can('contacts.delete')
                                <div class="dropdown-divider"></div>
                                <a href="javascript:void(0)"
                                   class="btn-delete-contact text-danger dropdown-item"
                                   data-contact-id={{ $contact->id }}>
                                    <i class="fa fa-trash"></i> {{ trans('fi.delete') }}</a>
                            @endcan
                        </div>
                    </div>
                </td>
            @endif
        </tr>
    @endforeach
    </tbody>
</table>