<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Contacts;

use FI\Modules\Contacts\Events\AddTransitionTags;
use FI\Modules\Contacts\Models\ContactTag;
use FI\Modules\Transitions\Models\Transitions;

class EventSubscriber
{
    public function addTransitionTags(AddTransitionTags $event)
    {

        $userId = isset(auth()->user()->id) ? auth()->user()->id : $event->userId;

        $transition                      = new Transitions();
        $transition->user_id             = $userId;
        $transition->client_id           = $event->contact->client_id;
        $transition->transitionable_id   = $event->contact->id;
        $transition->transitionable_type = 'FI\Modules\Contacts\Models\Contact';
        $transition->action_type         = $event->actionType;
        if (!empty($event->detail))
        {
            $transition->detail = json_encode($event->detail);
        }
        $transition->previous_value = $event->previousValue;
        $transition->current_value  = $event->currentValue;
        $transition->save();

        if ($event->actionType == 'contact_tag_deleted')
        {
            foreach ($event->tagId as $removeTagId)
            {
                ContactTag::whereContactId($event->contact->id)->whereTagId($removeTagId)->delete();
            }
        }

    }

    public function subscribe($events)
    {
        $events->listen('FI\Modules\Contacts\Events\AddTransitionTags', 'FI\Modules\Contacts\EventSubscriber@addTransitionTags');
    }
}
