<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Clients\Events;

use FI\Events\Event;
use FI\Modules\Clients\Models\Client;
use Illuminate\Queue\SerializesModels;

class AddTransitionMerge extends Event
{
    use SerializesModels;

    public $clientTo;
    public $clientFrom;
    public $actionType;
    public $previousValue;
    public $currentValue;

    public function __construct(Client $clientTo, $clientFrom, $actionType, $previousValue = null, $currentValue = null)
    {

        $this->clientTo      = $clientTo;
        $this->clientFrom    = $clientFrom;
        $this->actionType    = $actionType;
        $this->previousValue = $previousValue;
        $this->currentValue  = $currentValue;

        $this->detail = [
            'idTo'     => $clientTo->id,
            'nameTo'   => $clientTo->name,
            'idFrom'   => $clientFrom->id,
            'nameFrom' => $clientFrom->name,
        ];
    }
}
