<script type="text/javascript">
    $(function () {

        $('body #modal-{{$modalName}}-explore-addons').modal();

        $('.btn-{{$modalName}}-submit').click(function () {
            $('#modal-{{$modalName}}-explore-addons').modal('hide');
            var exploreAddonStatus=[];
            $('.explore-addon-check').each(function () {
                if (!$(this).is(':checked')) {
                    exploreAddonStatus.push({['name']:$(this).data('name'),['status']:0});
                } else {
                    exploreAddonStatus.push({['name']:$(this).data('name'),['status']:1});
                }
            });

            $.post($(this).data('action'), {
                exploreAddonStatus:exploreAddonStatus,
            }).done(function (response) {
                setTimeout(function () {
                    alertify.closeAll();
                    location.reload();
                }, 500);
                alertify.success(response.success);
            }).fail(function (response) {
                alertify.error($.parseJSON(response.responseText).message, 5);
            });

        });
    });
</script>

<div class="modal fade" id="modal-{{$modalName}}-explore-addons" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog text-break modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> {{trans('fi.available_addons')}} </h5>
                <button type="button" class="close btn-{{$modalName}}-cancel" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-sm table-hover table-striped table-responsive-xs table-responsive-sm text-nowrap">
                    <thead>
                    <tr>
                        <th class="" width="10%">{{ trans('fi.enabled') }}</th>
                        <th class="w-25 ">{{ trans('fi.name') }}</th>
                        <th>{{ trans('fi.description') }}</th>
                    </tr>

                    </thead>
                    <tbody>
                    @foreach ($addons as $addon)
                        <tr>
                            <td class="pl-1 text-center">
                                <input type="checkbox" class="bulk-record explore-addon-check"
                                       id="addon_{{Str::lower(str_replace(' ', '_',$addon->name))}}"  data-id="{{$addon->id}}"
                                       data-name="{{$addon->name}}" {{(Cookie::get(Str::lower(str_replace(' ', '_',$addon->name)))) ?? '' == 1 ? 'checked' : ''}}>
                            </td>
                            <td>
                                <label class="font-weight-normal"
                                       for="addon_{{Str::lower(str_replace(' ', '_',$addon->name))}}">
                                    {{ $addon->name}}
                                </label>
                            </td>
                            <td></td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-sm btn-default float-right btn-{{$modalName}}-cancel"
                        data-dismiss="modal" id="btn-{{$modalName}}-cancel">
                    {{ trans('fi.cancel') }}
                </button>
                <button type="button" id="btn-{{$modalName}}"
                        class="btn btn-sm btn-primary float-right btn-{{$modalName}}-submit"
                        data-action="{{route('update.addon.status')}}">
                    {{ trans('fi.submit') }}
                </button>

            </div>

        </div>
    </div>
</div>