<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\API\Requests;

use FI\Requests\RemoveTagsRule;
use FI\Traits\ApiCustomFieldValidator;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;

class APIClientContactStoreRequest extends FormRequest
{
    use ApiCustomFieldValidator;

    private $customFieldType = 'clients';

    public function authorize()
    {
        return true;
    }

    public function attributes()
    {
        return [
            'name'            => trans('fi.name'),
            'email'           => trans('fi.email'),
            'primary_phone'   => trans('fi.primary_phone'),
            'alternate_phone' => trans('fi.alternate_phone'),
        ];
    }

    public function rules()
    {

        return [
            'name'            => ['required', new RemoveTagsRule],
            'email'           => ['required', 'email', new RemoveTagsRule],
            'primary_phone'   => [new RemoveTagsRule],
            'alternate_phone' => [new RemoveTagsRule],
            'notes'           => [new RemoveTagsRule],
            'client_id'       => 'required|exists:clients,id',
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json(['errors' => (new ValidationException($validator))->errors()], JsonResponse::HTTP_UNPROCESSABLE_ENTITY));
    }
}