<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\API\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\API\Requests\APIClientContactStoreRequest;
use FI\Modules\Clients\Models\Contact;
use Illuminate\Http\Request;
use Mockery\Exception;

class ApiClientContactController extends Controller
{
    public function index(Request $request, $id)
    {
        try
        {
            if (!empty($id))
            {
                $keyword = ($request->except('paginated_response') != null) ? $request->except('paginated_response') : null;

                if ($request->has('paginated_response') && $request->get('paginated_response') == 1)
                {
                    $contacts = Contact::select('contacts.*')
                        ->leftJoin('clients', 'contacts.client_id', '=', 'clients.id')
                        ->keywords($keyword['search'] ?? '')
                        ->where('clients.id', $id)
                        ->paginate(config('fi.resultsPerPage'));


                }
                else
                {
                    $contacts = Contact::select('contacts.*')
                        ->leftJoin('clients', 'contacts.client_id', '=', 'clients.id')
                        ->keywords($keyword['search'] ?? '')
                        ->where('clients.id', $id)
                        ->get();
                }

                if (count($contacts) > 0)
                {
                    return response()->json(['success' => true, 'message' => trans('fi.record_successfully_retrieved'), 'contacts' => $contacts], 200);
                }
                else
                {
                    return response()->json(['success' => true, 'message' => trans('fi.record_not_found')], 400);
                }
            }
            else
            {
                return response()->json(['success' => false, 'message' => trans('fi.record_not_found')], 400);
            }
        }
        catch (\Exception $e)
        {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 400);
        }

    }

    public function store(APIClientContactStoreRequest $request)
    {
        try
        {
            $contact = Contact::create($request->all());

            return response()->json(['success' => true, 'message' => trans('fi.record_successfully_created'), 'contact' => $contact], 201);
        }
        catch (\Exception $e)
        {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 400);
        }
    }

    public function show($id)
    {
        try
        {
            $contact = Contact::with('client')->find($id);

            if ($contact)
            {
                return response()->json(['success' => true, 'message' => trans('fi.record_successfully_retrieved'), 'contact' => $contact], 200);
            }
            else
            {
                return response()->json(['success' => false, 'message' => trans('fi.record_not_found')], 400);
            }

        }
        catch (Exception $e)
        {
            return response()->json(['success' => false, 'message' => trans('fi.record_not_found')], 400);
        }

    }


    public function update(APIClientContactStoreRequest $request, $id)
    {
        try
        {
            $contact = Contact::find($id);

            $contact->fill($request->all());

            $contact->save();

            return response()->json(['success' => true, 'message' => trans('fi.record_successfully_updated'), 'contact' => $contact], 200);

        }
        catch (\Exception $e)
        {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 400);
        }
    }

    public function delete($id)
    {
        try
        {
            Contact::destroy($id);

            return response()->json(['success' => true, 'message' => trans('fi.record_successfully_deleted')], 200);
        }
        catch (\Exception $e)
        {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 400);
        }
    }
}