<?php

namespace FI\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OtpMail extends Mailable
{
    use Queueable, SerializesModels;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('sessions.otp-email-body')->from(config('fi.mailFromAddress'), config('fi.mailFromName'))
            ->subject($this->data['companyName'] . ' FusionInvoice Verification Code')
            ->with(['loginotp' => $this->data['loginOtp'], 'ip' => $this->data['ip']]);
    }

}
