<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Http\Middleware;

use Closure;
use FI\Support\Migrations;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;

class Setup
{
    /**
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (auth()->id() != null)
        {
            $migrations = new Migrations();

            if ($migrations->getPendingMigrations(base_path('database/migrations')))
            {
                if (auth()->user())
                {
                    auth()->logout();
                    session()->flush();
                    Cookie::queue(Cookie::forget('time_tracking'));
                    Cookie::queue(Cookie::forget('pricing_formula'));
                    Cookie::queue(Cookie::forget('commission'));
                    Cookie::queue(Cookie::forget('payment_center'));
                }

                redirect('setup')->send();
            }

            return redirect('dashboard');
        }
        return $next($request);
    }
}
