<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Http\Middleware;

use Closure;
use HTMLPurifier;
use HTMLPurifier_Config;

class HTMLPurifierMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        $input = $request->all();

        $config = HTMLPurifier_Config::createDefault();
        $purifier = new HTMLPurifier($config);

        array_walk_recursive($input, function (&$input) use ($purifier)
        {
            $input = $purifier->purify($input);
        });

        $request->merge($input);

        return $next($request);
    }
}
