<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Cookie;

class DemoModeCheckMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        if (config('app.demo') == true)
        {
            if (in_array(request()->segment(1), ['time_tracking', 'commission', 'pricing_formula' ,'payment_center']))
            {
                if (Cookie::get(request()->segment(1)) == 1)
                {
                    return $next($request);
                }
                else
                {
                    if ($request->ajax())
                    {
                        return response()->json(['errors' => [[trans('fi.functionality_not_available_on_demo')]]], 403);
                    }
                    else
                    {
                        return redirect()->route('dashboard.index')->withErrors(trans('fi.functionality_not_available_on_demo'));
                    }
                }
            }

            if (request()->segment(1) == 'system_log')
            {
                return redirect()->back()->withErrors(trans('fi.functionality_not_available_on_demo'));
            }

            return $next($request);
        }
        else
        {
            return $next($request);
        }
    }
}
