<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Http;

use FI\Http\Middleware\AfterMiddleware;
use FI\Http\Middleware\AuthenticateAdmin;
use FI\Http\Middleware\AuthenticateClientCenter;
use FI\Http\Middleware\BeforeMiddleware;
use FI\Http\Middleware\CheckInvoiceStatus;
use FI\Http\Middleware\DemoModeCheckMiddleware;
use FI\Http\Middleware\EncryptCookies;
use FI\Http\Middleware\HTMLPurifierMiddleware;
use FI\Http\Middleware\RedirectIfAuthenticated;
use FI\Http\Middleware\Setup;
use FI\Http\Middleware\SetupBeforeMiddleware;
use FI\Http\Middleware\TrimStrings;
use FI\Http\Middleware\TrustProxies;
use FI\Http\Middleware\ValidateSignature;
use FI\Http\Middleware\VerifyCsrfToken;
use Illuminate\Auth\Middleware\Authenticate;
use Illuminate\Auth\Middleware\AuthenticateWithBasicAuth;
use Illuminate\Auth\Middleware\Authorize;
use Illuminate\Auth\Middleware\EnsureEmailIsVerified;
use Illuminate\Auth\Middleware\RequirePassword;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Foundation\Http\Kernel as HttpKernel;
use Illuminate\Foundation\Http\Middleware\CheckForMaintenanceMode;
use Illuminate\Foundation\Http\Middleware\HandlePrecognitiveRequests;
use Illuminate\Foundation\Http\Middleware\ValidatePostSize;
use Illuminate\Http\Middleware\HandleCors;
use Illuminate\Http\Middleware\SetCacheHeaders;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Routing\Middleware\ThrottleRequests;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        CheckForMaintenanceMode::class,
        HandleCors::class,
        ValidatePostSize::class,
        TrimStrings::class,
        TrustProxies::class,
        AfterMiddleware::class
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            EncryptCookies::class,
            AddQueuedCookiesToResponse::class,
            StartSession::class,
            ShareErrorsFromSession::class,
            VerifyCsrfToken::class,
            SubstituteBindings::class,
            BeforeMiddleware::class,
            'throttle:300,1',
        ],

        'api' => [
            EnsureFrontendRequestsAreStateful::class,
            'throttle:api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],

        'setup' => [
            EncryptCookies::class,
            AddQueuedCookiesToResponse::class,
            StartSession::class,
            ShareErrorsFromSession::class,
            VerifyCsrfToken::class,
            SubstituteBindings::class,
            SetupBeforeMiddleware::class,
            Setup::class,
            'throttle:300,1'
        ]
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'auth'                => Authenticate::class,
        'auth.admin'          => AuthenticateAdmin::class,
        'auth.clientCenter'   => AuthenticateClientCenter::class,
        'auth.basic'          => AuthenticateWithBasicAuth::class,
        'bindings'            => SubstituteBindings::class,
        'can'                 => Authorize::class,
        'guest'               => RedirectIfAuthenticated::class,
        'throttle'            => ThrottleRequests::class,
        'before.middleware'   => BeforeMiddleware::class,
        'check.invoiceStatus' => CheckInvoiceStatus::class,
        'check.demo'          => DemoModeCheckMiddleware::class,
        'htmlpurify'          => HTMLPurifierMiddleware::class,
        'verified'            => EnsureEmailIsVerified::class,
        'auth.session'        => AuthenticateSession::class,
        'cache.headers'       => SetCacheHeaders::class,
        'password.confirm'    => RequirePassword::class,
        'precognitive'        => HandlePrecognitiveRequests::class,
        'signed'              => ValidateSignature::class,
    ];
}
