<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\PaymentTerms\Models\PaymentTerm;
use Illuminate\Support\Carbon;

function onlinePaymentQuoteChargesDetail($quote)
{
    $quoteAmountBalance = floatval(number_format($quote->amount->total, 2, '.', ''));
    $feePercentage      = config('fi.feePercentage') != null ? (config('fi.feePercentage') / 100) : null;
    $feeCharges         = floatval(number_format($quoteAmountBalance * $feePercentage, 2, '.', ''));
    $addChargeAsItem    = true;

    if ($quote->online_payment_processing_fee == 'yes')
    {
        $amountValue = number_format(($quoteAmountBalance + $feeCharges), 2, '.', '');
    }
    else
    {
        $addChargeAsItem = false;
        $amountValue     = $quoteAmountBalance;
    }

    return quotePaymentTermsDiscountDetail(
        [
            'percentage'           => 0,
            'type'                 => null,
            'originalAmountValue'  => $quoteAmountBalance,
            'amountValue'          => floatval($amountValue),
            'addChargesItem'       => $addChargeAsItem,
            'feeCharges'           => $feeCharges,
            'paymentTermsDiscount' => 0.00,
            'installment'          => 0,
        ], $quote);
}

function quotePaymentTermsDiscountDetail($details, $quote, $addFeeCharge = true)
{
    $amountValue           = $details['amountValue'];
    $currentDate           = Carbon::now()->format('Y-m-d');
    $paymentTerm           = PaymentTerm::find($quote->payment_term_id);
    $details['percentage'] = 0;

    if ($quote->amount != null && $paymentTerm != null)
    {
        $details['type'] = $paymentTerm->type;

        if ($currentDate < $quote->formatted_payment_term_due_date['expire'])
        {

            if ($paymentTerm->type == 2 || $paymentTerm->type == 3)
            {
                $discount                        = floatval(number_format(((floatval($paymentTerm->discount_percent) * floatval($quote->amount->total)) / 100), 2, '.', ''));
                $details['paymentTermsDiscount'] = $discount;
                $details['percentage']           = floatval($paymentTerm->discount_percent);
                $details['installment']          = 0;
                if ($discount > 0)
                {
                    if ($details['addChargesItem'] == true)
                    {
                        $type2FeePercentage             = config('fi.feePercentage') != null ? (config('fi.feePercentage') / 100) : null;
                        $details['originalAmountValue'] = ($details['originalAmountValue'] - $discount);
                        $details['amountValue']         = floatval(number_format($details['originalAmountValue'] + ($details['originalAmountValue'] * $type2FeePercentage), 2, '.', ''));
                        $details['feeCharges']          = floatval(number_format(($details['originalAmountValue'] * $type2FeePercentage), 2, '.', ''));
                    }
                    else
                    {
                        $details['originalAmountValue'] = $details['amountValue'] = ($amountValue - $discount);
                    }
                }
            }
            elseif ($paymentTerm->type == 4)
            {
                $paymentTermDownPayment = floatval(number_format($paymentTerm->down_payment, 2, '.', ''));
                if ($paymentTerm->down_payment_type == 'percentage')
                {
                    $totalPayment = ($quote->amount->total * ($paymentTermDownPayment / 100));

                    $paymentTermDownPayment = floatval(number_format($totalPayment, 2, '.', ''));
                }

                $totalPay               = 0;

                $flag                   = ($paymentTermDownPayment > $totalPay);

                if ($flag)
                {
                    $paymentTermDownPayment = floatval(number_format($paymentTermDownPayment - $totalPay, 2, '.', ''));
                }

                if (floatval($quote->amount->total) > $paymentTermDownPayment && $flag)
                {
                    $feePercentage                  = config('fi.feePercentage') != null ? (config('fi.feePercentage') / 100) : null;
                    $feeCharges                     = floatval(number_format(($paymentTermDownPayment * $feePercentage), 2, '.', ''));
                    $details['originalAmountValue'] = $paymentTermDownPayment;

                    if ($quote->online_payment_processing_fee == 'yes' && $addFeeCharge == true)
                    {
                        $details['amountValue'] = floatval(number_format(($paymentTermDownPayment + $feeCharges), 2, '.', ''));
                        $details['feeCharges']  = $feeCharges;
                    }
                    else
                    {
                        $details['amountValue']    = $paymentTermDownPayment;
                        $details['addChargesItem'] = false;
                    }
                }

                $details['paymentTermsDiscount'] = 0;
                $details['installment']          = 0;
            }
            elseif ($paymentTerm->type == 5)
            {
                $installmentData                = $quote->formatted_payment_term_due_date;
                $installmentPercent             = floatval($installmentData['installment_percent']);
                $totalPayBalance                = ($installmentData['lastPayment'] == true ? floatval(number_format(floatval($quote->amount->total), 2, '.', '')) : floatval(number_format(((floatval($quote->amount->total) * $installmentPercent) / 100), 2, '.', '')));
                $details['originalAmountValue'] = $totalPayBalance;
                $feePercentage                  = config('fi.feePercentage') != null ? (config('fi.feePercentage') / 100) : null;
                $feeCharges                     = floatval(number_format($totalPayBalance, 2, '.', '') * $feePercentage);
                if ($quote->online_payment_processing_fee == 'yes' && $addFeeCharge == true)
                {
                    $details['amountValue'] = floatval(number_format((number_format($totalPayBalance, 2, '.', '') + $feeCharges), 2, '.', ''));
                    $details['feeCharges']  = floatval(number_format($feeCharges, 2, '.', ''));
                }
                else
                {
                    $details['amountValue']    = floatval(number_format($totalPayBalance, 2, '.', ''));
                    $details['feeCharges']     = 0;
                    $details['addChargesItem'] = false;
                }

                $details['installment'] = $installmentData['id'];
            }
        }
    }
    else
    {
        $details['amountValue']         = floatval(number_format($details['amountValue'], 2, '.', ''));
        $details['originalAmountValue'] = floatval(number_format($details['originalAmountValue'], 2, '.', ''));
    }

    return $details;

}