<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

function generateCaptchaString()
{
    $characters = config('captcha.characters');
    shuffle($characters);
    $randomCharacters = array_slice($characters, 0, config('captcha.length'));
    $randomString     = implode('', $randomCharacters);
    session(['captcha' => $randomString]);
    return $randomString;
}

function generateCaptchaImg($width = 50, $height = 15)
{
    $captchaText = session('captcha');
    if ($captchaText != '')
    {
        $RGB = config('captcha.colors_rgb');
        $colors_rgb = array_rand(config('captcha.colors_rgb'),1);
        $img = imagecreate($width, $height);
        imagecolorallocate($img, 234, 234, 234);
        $textcolor = imagecolorallocate($img, $RGB[$colors_rgb][0], $RGB[$colors_rgb][1], $RGB[$colors_rgb][2]);
        imagestring($img, 10, 3, 0, $captchaText, $textcolor);
        ob_start();
        imagepng($img);
        return 'data:image/png;base64,' . base64_encode(ob_get_clean());
    }
    return null;
}