<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class DemoDataSeed extends Command
{
    protected $signature   = 'demo:data-seed';

    protected $description = 'This command will insert demo data!';

    public function handle()
    {
        Artisan::call('db:seed', [
            '--class' => 'DemoDataSeeder',
            '--force' => true,
        ], $this->output);
    }

}
