<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Composers;

use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Session;

class AddonComposer
{
    public function compose($view)
    {

        if (config('app.demo') == true)
        {
            $enableTimeTracking  = Cookie::get('time_tracking') == 1 ? 1 : 0;
            $enableSupportDesk   = Cookie::get('support_tickets') == 1 ? 1 : 0;
            $enablePriceFormulas = Cookie::get('pricing_formula') == 1 ? 1 : 0;
            $enableCommission    = Cookie::get('commission') == 1 ? 1 : 0;
            $enablePaymentCenter = Cookie::get('payment_center') == 1 ? 1 : 0;
            $enableSms           = Cookie::get('sms') == 1 ? 1 : 0;

            $serverTimestamp = time();
            $startTimestamp  = time();
            $second          = abs(date('s'));

            if (30 - date('i') < 1)
            {
                $minute = abs(date('i') - 60);
            }
            else
            {
                $minute = abs(30 - date('i'));
            }

            $endTimestamp = $startTimestamp + ($minute * 60 - $second);

            if (session('end_timestamp', '') != '' || session('end_timestamp') < $endTimestamp)
            {
                session::put('end_timestamp', $endTimestamp);
            }

            $offsetTime    = $serverTimestamp - $startTimestamp;
            $remainingTime = (session('end_timestamp') - $startTimestamp) - $offsetTime;

        }
        else
        {
            $enableTimeTracking  = 1;
            $enablePriceFormulas = 1;
            $enableSupportDesk   = 1;
            $enableCommission    = 1;
            $enablePaymentCenter = 1;
            $remainingTime       = null;
            $startTimestamp      = null;
            $enableSms           = 1;
        }
        $view->with('enableTimeTracking', $enableTimeTracking);
        $view->with('enableSupportDesk', $enableSupportDesk);
        $view->with('enableCommission', $enableCommission);
        $view->with('enablePriceFormulas', $enablePriceFormulas);
        $view->with('enablePaymentCenter', $enablePaymentCenter);
        $view->with('remainingTime', $remainingTime);
        $view->with('startTimestamp', $startTimestamp);
        $view->with('enableSms', $enableSms);
    }
}