<?php

namespace Telnyx\Util;

/**
 * @internal
 * @covers \Telnyx\Util\DefaultLogger
 */
final class DefaultLoggerTest extends \PHPUnit\Framework\TestCase
{
    public function testDefaultLogger()
    {
        // DefaultLogger uses PHP's `error_log` function. In order to capture
        // the output, we need to temporarily redirect it to a temporary file.

        $capture = \tmpfile();
        $origErrorLog = \ini_set('error_log', \stream_get_meta_data($capture)['uri']);

        try {
            $logger = new DefaultLogger();
            $logger->error('This is a test message');

            static::assertRegExp('/This is a test message/', \stream_get_contents($capture));
        } finally {
            \ini_set('error_log', $origErrorLog);
            \fclose($capture);
        }
    }
}
