<?php

namespace Microsoft\Graph\Generated\Models;

use DateTime;
use Microsoft\Kiota\Abstractions\Serialization\AdditionalDataHolder;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;
use Microsoft\Kiota\Abstractions\Store\BackedModel;
use Microsoft\Kiota\Abstractions\Store\BackingStore;
use Microsoft\Kiota\Abstractions\Store\BackingStoreFactorySingleton;

/**
 * Malware category device count
*/
class WindowsMalwareCategoryCount implements AdditionalDataHolder, BackedModel, Parsable 
{
    /**
     * @var BackingStore $backingStore Stores model information.
    */
    private BackingStore $backingStore;
    
    /**
     * Instantiates a new WindowsMalwareCategoryCount and sets the default values.
    */
    public function __construct() {
        $this->backingStore = BackingStoreFactorySingleton::getInstance()->createBackingStore();
        $this->setAdditionalData([]);
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return WindowsMalwareCategoryCount
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): WindowsMalwareCategoryCount {
        return new WindowsMalwareCategoryCount();
    }

    /**
     * Gets the activeMalwareDetectionCount property value. Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
     * @return int|null
    */
    public function getActiveMalwareDetectionCount(): ?int {
        $val = $this->getBackingStore()->get('activeMalwareDetectionCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'activeMalwareDetectionCount'");
    }

    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return array<string, mixed>|null
    */
    public function getAdditionalData(): ?array {
        $val = $this->getBackingStore()->get('additionalData');
        if (is_null($val) || is_array($val)) {
            /** @var array<string, mixed>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'additionalData'");
    }

    /**
     * Gets the BackingStore property value. Stores model information.
     * @return BackingStore
    */
    public function getBackingStore(): BackingStore {
        return $this->backingStore;
    }

    /**
     * Gets the category property value. Malware category id
     * @return WindowsMalwareCategory|null
    */
    public function getCategory(): ?WindowsMalwareCategory {
        $val = $this->getBackingStore()->get('category');
        if (is_null($val) || $val instanceof WindowsMalwareCategory) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'category'");
    }

    /**
     * Gets the deviceCount property value. Count of devices with malware detections for this malware category
     * @return int|null
    */
    public function getDeviceCount(): ?int {
        $val = $this->getBackingStore()->get('deviceCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'deviceCount'");
    }

    /**
     * Gets the distinctActiveMalwareCount property value. Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
     * @return int|null
    */
    public function getDistinctActiveMalwareCount(): ?int {
        $val = $this->getBackingStore()->get('distinctActiveMalwareCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'distinctActiveMalwareCount'");
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return  [
            'activeMalwareDetectionCount' => fn(ParseNode $n) => $o->setActiveMalwareDetectionCount($n->getIntegerValue()),
            'category' => fn(ParseNode $n) => $o->setCategory($n->getEnumValue(WindowsMalwareCategory::class)),
            'deviceCount' => fn(ParseNode $n) => $o->setDeviceCount($n->getIntegerValue()),
            'distinctActiveMalwareCount' => fn(ParseNode $n) => $o->setDistinctActiveMalwareCount($n->getIntegerValue()),
            'lastUpdateDateTime' => fn(ParseNode $n) => $o->setLastUpdateDateTime($n->getDateTimeValue()),
            '@odata.type' => fn(ParseNode $n) => $o->setOdataType($n->getStringValue()),
        ];
    }

    /**
     * Gets the lastUpdateDateTime property value. The Timestamp of the last update for the device count in UTC
     * @return DateTime|null
    */
    public function getLastUpdateDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('lastUpdateDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'lastUpdateDateTime'");
    }

    /**
     * Gets the @odata.type property value. The OdataType property
     * @return string|null
    */
    public function getOdataType(): ?string {
        $val = $this->getBackingStore()->get('odataType');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'odataType'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        $writer->writeIntegerValue('activeMalwareDetectionCount', $this->getActiveMalwareDetectionCount());
        $writer->writeEnumValue('category', $this->getCategory());
        $writer->writeIntegerValue('deviceCount', $this->getDeviceCount());
        $writer->writeIntegerValue('distinctActiveMalwareCount', $this->getDistinctActiveMalwareCount());
        $writer->writeDateTimeValue('lastUpdateDateTime', $this->getLastUpdateDateTime());
        $writer->writeStringValue('@odata.type', $this->getOdataType());
        $writer->writeAdditionalData($this->getAdditionalData());
    }

    /**
     * Sets the activeMalwareDetectionCount property value. Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
     * @param int|null $value Value to set for the activeMalwareDetectionCount property.
    */
    public function setActiveMalwareDetectionCount(?int $value): void {
        $this->getBackingStore()->set('activeMalwareDetectionCount', $value);
    }

    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param array<string,mixed> $value Value to set for the AdditionalData property.
    */
    public function setAdditionalData(?array $value): void {
        $this->getBackingStore()->set('additionalData', $value);
    }

    /**
     * Sets the BackingStore property value. Stores model information.
     * @param BackingStore $value Value to set for the BackingStore property.
    */
    public function setBackingStore(BackingStore $value): void {
        $this->backingStore = $value;
    }

    /**
     * Sets the category property value. Malware category id
     * @param WindowsMalwareCategory|null $value Value to set for the category property.
    */
    public function setCategory(?WindowsMalwareCategory $value): void {
        $this->getBackingStore()->set('category', $value);
    }

    /**
     * Sets the deviceCount property value. Count of devices with malware detections for this malware category
     * @param int|null $value Value to set for the deviceCount property.
    */
    public function setDeviceCount(?int $value): void {
        $this->getBackingStore()->set('deviceCount', $value);
    }

    /**
     * Sets the distinctActiveMalwareCount property value. Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
     * @param int|null $value Value to set for the distinctActiveMalwareCount property.
    */
    public function setDistinctActiveMalwareCount(?int $value): void {
        $this->getBackingStore()->set('distinctActiveMalwareCount', $value);
    }

    /**
     * Sets the lastUpdateDateTime property value. The Timestamp of the last update for the device count in UTC
     * @param DateTime|null $value Value to set for the lastUpdateDateTime property.
    */
    public function setLastUpdateDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('lastUpdateDateTime', $value);
    }

    /**
     * Sets the @odata.type property value. The OdataType property
     * @param string|null $value Value to set for the @odata.type property.
    */
    public function setOdataType(?string $value): void {
        $this->getBackingStore()->set('odataType', $value);
    }

}
