<?php

namespace Microsoft\Graph\Generated\Drives\Item\Items\Item\Workbook\Functions\DollarDe;

use Microsoft\Graph\Generated\Models\Json;
use Microsoft\Kiota\Abstractions\Serialization\AdditionalDataHolder;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;
use Microsoft\Kiota\Abstractions\Store\BackedModel;
use Microsoft\Kiota\Abstractions\Store\BackingStore;
use Microsoft\Kiota\Abstractions\Store\BackingStoreFactorySingleton;

class DollarDePostRequestBody implements AdditionalDataHolder, BackedModel, Parsable 
{
    /**
     * @var BackingStore $backingStore Stores model information.
    */
    private BackingStore $backingStore;
    
    /**
     * Instantiates a new DollarDePostRequestBody and sets the default values.
    */
    public function __construct() {
        $this->backingStore = BackingStoreFactorySingleton::getInstance()->createBackingStore();
        $this->setAdditionalData([]);
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return DollarDePostRequestBody
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): DollarDePostRequestBody {
        return new DollarDePostRequestBody();
    }

    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return array<string, mixed>|null
    */
    public function getAdditionalData(): ?array {
        $val = $this->getBackingStore()->get('additionalData');
        if (is_null($val) || is_array($val)) {
            /** @var array<string, mixed>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'additionalData'");
    }

    /**
     * Gets the BackingStore property value. Stores model information.
     * @return BackingStore
    */
    public function getBackingStore(): BackingStore {
        return $this->backingStore;
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return  [
            'fraction' => fn(ParseNode $n) => $o->setFraction($n->getObjectValue([Json::class, 'createFromDiscriminatorValue'])),
            'fractionalDollar' => fn(ParseNode $n) => $o->setFractionalDollar($n->getObjectValue([Json::class, 'createFromDiscriminatorValue'])),
        ];
    }

    /**
     * Gets the fraction property value. The fraction property
     * @return Json|null
    */
    public function getFraction(): ?Json {
        $val = $this->getBackingStore()->get('fraction');
        if (is_null($val) || $val instanceof Json) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'fraction'");
    }

    /**
     * Gets the fractionalDollar property value. The fractionalDollar property
     * @return Json|null
    */
    public function getFractionalDollar(): ?Json {
        $val = $this->getBackingStore()->get('fractionalDollar');
        if (is_null($val) || $val instanceof Json) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'fractionalDollar'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        $writer->writeObjectValue('fraction', $this->getFraction());
        $writer->writeObjectValue('fractionalDollar', $this->getFractionalDollar());
        $writer->writeAdditionalData($this->getAdditionalData());
    }

    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param array<string,mixed> $value Value to set for the AdditionalData property.
    */
    public function setAdditionalData(?array $value): void {
        $this->getBackingStore()->set('additionalData', $value);
    }

    /**
     * Sets the BackingStore property value. Stores model information.
     * @param BackingStore $value Value to set for the BackingStore property.
    */
    public function setBackingStore(BackingStore $value): void {
        $this->backingStore = $value;
    }

    /**
     * Sets the fraction property value. The fraction property
     * @param Json|null $value Value to set for the fraction property.
    */
    public function setFraction(?Json $value): void {
        $this->getBackingStore()->set('fraction', $value);
    }

    /**
     * Sets the fractionalDollar property value. The fractionalDollar property
     * @param Json|null $value Value to set for the fractionalDollar property.
    */
    public function setFractionalDollar(?Json $value): void {
        $this->getBackingStore()->set('fractionalDollar', $value);
    }

}
