<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e(trans('fi.welcome')); ?></title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"/>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/fontawesome-free/css/all.min.css')); ?>">
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/dist/css/adminlte.min.css')); ?>">
    <?php if(file_exists(base_path('custom/custom.css'))): ?>
        <link href="<?php echo e(asset('custom/custom.css')); ?>" rel="stylesheet" type="text/css"/>
    <?php endif; ?>
</head>
<body class="hold-transition login-page">
<div class="login-box">
    <?php if($logo != ''): ?>
        <div class="login-logo">
            <img src="<?php echo e($logo); ?>" alt="<?php echo e(config('fi.headerTitleText')); ?>" class="brand-image card-img-top elevation-5">
        </div>
    <?php else: ?>
        <div class="login-logo">
            <img src="<?php echo e(asset('assets/dist/img/logo.png')); ?>" alt="<?php echo e(config('fi.headerTitleText')); ?>"
                 class="brand-image img-circle elevation-3" style="opacity: .8">
        </div>
    <?php endif; ?>

    <!-- /.login-logo -->
    <div class="card">
        <div class="card-body login-card-body">
            <?php echo $__env->make('layouts._alertifyjs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('layouts._alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo Form::open(['route' => 'session.attempt', 'onsubmit' => "this.submit_button.disabled = true;"]); ?>

            <div class="input-group mb-3">
                <input type="email" name="email" id="email" class="form-control form-control-sm" placeholder="<?php echo e(trans('fi.email')); ?>">
                <div class="input-group-append">
                    <div class="input-group-text">
                        <span class="fas fa-envelope"></span>
                    </div>
                </div>
            </div>
            <div class="input-group mb-3">
                <input type="password" name="password" class="form-control form-control-sm" placeholder="<?php echo e(trans('fi.password')); ?>">
                <div class="input-group-append">
                    <div class="input-group-text">
                        <span class="fas fa-lock"></span>
                    </div>
                </div>
            </div>

            <?php if(config('app.demo')): ?>
                <div class="mb-3 form-group">
                    <?php echo Form::select('database', $databaseNames, '', ['id' => 'database_select', 'class' => 'form-control form-control-sm', 'autocomplete' => 'off', 'style'=>"width: 100%;"]); ?>

                </div>
            <?php endif; ?>

            <?php if(config('fi.useCaptchaInLogin')): ?>
                <div class="form-group">
                    <div class="row mb-10 ml-0 mb-2">
                        <div class="col-xs-5">
                            <div id="captcha-container">
                                <?php if(generateCaptchaImg()): ?>
                                    <img src="<?php echo e(generateCaptchaImg()); ?>" width="100"
                                         alt="<?php echo e(trans('fi.tt_captcha_image')); ?>">
                                <?php else: ?>
                                    <span class="text-danger"><?php echo e(trans('fi.reload_page')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xs-2 ml-1 mt-1">
                            <a href="javascript:void(0)" id="refresh-captcha" title="<?php echo e(trans('fi.refresh_captcha')); ?>"><i
                                        class="fa fa-fw fa-sync"></i></a>
                        </div>
                    </div>
                    <input type="text" name="captcha_response" class="form-control form-control-sm" maxlength="5" autocomplete="off"
                           placeholder="<?php echo e(trans('fi.type_captcha')); ?>">
                </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-8">
                    <div class="icheck-primary">
                        <input type="checkbox" id="remember" name="remember_me" value="1">
                        <label for="remember">
                            <?php echo e(trans('fi.remember_me')); ?>

                        </label>
                        <input type="hidden" name="remember_me" value="0">
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-4">
                    <button type="submit" class="btn btn-sm btn-primary btn-block" style="<?php echo \Illuminate\Support\Arr::toCssStyles('box-shadow: 0px 0px 10px lightblue;') ?>"><?php echo e(trans('fi.sign_in')); ?></button>
                </div>
                <!-- /.col -->
            </div>
            <?php echo Form::close(); ?>

        </div>
        <!-- /.login-card-body -->
    </div>
    <div class="login-logo">
        <span class=" btn float-right p-0 mt-2">
            Powered by
            <a href="https://fusioninvoice.com"><b>Fusion</b>Invoice
            </a>
        </span>

    </div>
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="<?php echo e(asset('assets/plugins/jquery/jquery.min.js')); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(asset('assets/dist/js/adminlte.js')); ?>"></script>
<script type="text/javascript">
    $(function () {
        $('#email').focus();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $('#refresh-captcha').click(function () {
            $.post("<?php echo e(route('session.refresh_captcha')); ?>", function (response) {
                $('#captcha-container').html(response);
            });
        });
    });
</script>
</body>
</html>
<?php /**PATH /home/rosscredent/public_html/billing/app/Modules/Sessions/Views/sessions/login.blade.php ENDPATH**/ ?>