<?php

$translations = [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'                        => ':attribute kabul edilmelidir.',
    'active_url'                      => ':attribute geçerli bir URL degil.',
    'after'                           => ':attribute :date den sonraki bir tarih olmalidir.',
    'after_or_equal'                  => ':attribute :date den sonraki veya ona esit bir tarih olmalidir.',
    'alpha'                           => ':attribute yalnizca harf içerebilir.',
    'alpha_dash'                      => ':attribute yalnizca harf, rakam ve tire içerebilir.',
    'alpha_num'                       => ':attribute yalnizca harf ve rakam içerebilir.',
    'array'                           => ':attribute bir dizi olmalidir.',
    'before'                          => ':attribute :date den önceki bir tarih olmalidir.',
    'before_or_equal'                 => ':attribute :date den önceki veya ona esit bir tarih olmalidir.',
    'between'                         => [
        'numeric' => ':attribute :min ile :max arasinda olmalidir.',
        'file'    => ':attribute :min ile :max kilobayt arasinda olmalidir.',
        'string'  => ':attribute :min ve :max karakterleri arasinda olmalidir.',
        'array'   => ':attribute :min ve :max arasinda ögelere sahip olmalidir.',
    ],
    'boolean'                         => ':attribute alani dogru veya yanlis olmalidir.',
    'confirmed'                       => ':attribute onayi eslesmiyor.',
    'date'                            => ':attribute geçerli bir tarih degil.',
    'date_format'                     => ':attribute :format biçimiyle eslesmiyor.',
    'different'                       => ':attribute ve :other farkli olmalidir.',
    'digits'                          => ':attribute :digits rakam olmalidir.',
    'digits_between'                  => ':attribute :min ve :max rakamlari arasinda olmalidir.',
    'dimensions'                      => ':attribute geçersiz resim boyutlarina sahip.',
    'distinct'                        => ':attribute alani yinelenen bir degere sahip.',
    'email'                           => ':attribute geçerli bir e-posta adresi olmalidir.',
    'exists'                          => 'Seçilen :attribute geçersiz.',
    'file'                            => ':attribute bir dosya olmalidir.',
    'filled'                          => ':attribute alani bir degere sahip olmalidir.',
    'image'                           => ':attribute bir resim olmalidir.',
    'in'                              => 'Seçilen :attribute geçersiz.',
    'in_array'                        => ':attribute alani :other dosyasinda mevcut degil.',
    'integer'                         => ':attribute bir tamsayi olmalidir.',
    'ip'                              => ':attribute geçerli bir IP adresi olmalidir.',
    'ipv4'                            => ':attribute geçerli bir IPv4 adresi olmalidir.',
    'ipv6'                            => ':attribute geçerli bir IPv6 adresi olmalidir.',
    'json'                            => ':attribute geçerli bir JSON dizesi olmalidir.',
    'max'                             => [
        'numeric' => ':attribute :max degerinden büyük olamaz.',
        'file'    => ':attribute :max kilobayttan büyük olamaz.',
        'string'  => ':attribute :max karakterden büyük olamaz.',
        'array'   => ':attribute :max ögesinden fazlasini içeremez.',
    ],
    'mimes'                           => ':attribute su türden bir dosya olmalidir: :values.',
    'mimetypes'                       => ':attribute su türden bir dosya olmalidir: :values.',
    'min'                             => [
        'numeric' => ':attribute en az :min olmalidir.',
        'file'    => ':attribute en az :min kilobayt olmalidir.',
        'string'  => ':attribute en az :min karakterden olusmalidir.',
        'array'   => ':attribute en az :min ögeye sahip olmalidir.',
    ],
    'not_in'                          => 'Seçilen :attribute geçersiz.',
    'numeric'                         => ':attribute bir sayi olmalidir.',
    'present'                         => ':attribute alani mevcut olmalidir.',
    'regex'                           => ':attribute biçimi geçersiz.',
    'required'                        => ':attribute alani zorunludur.',
    'required_if'                     => ':attribute alani :other :value oldugunda gereklidir.',
    'required_unless'                 => ':attribute alani :other :values içinde olmadigi sürece gereklidir.',
    'required_with'                   => ':attribute alani :values mevcut oldugunda gereklidir.',
    'required_with_all'               => ':attribute alani :values mevcut oldugunda gereklidir.',
    'required_without'                => ':attribute alani :values mevcut olmadiginda gereklidir.',
    'required_without_all'            => ':attribute alani :values den hiçbiri mevcut olmadiginda gereklidir.',
    'same'                            => ':attribute ve :other eslesmelidir.',
    'size'                            => [
        'numeric' => ':attribute :size olmalidir.',
        'file'    => ':attribute :size kilobayt olmalidir.',
        'string'  => ':attribute :size karakterleri olmalidir.',
        'array'   => ':attribute :size ögelerini içermelidir.',
    ],
    'string'                          => ':attribute bir dize olmalidir.',
    'timezone'                        => ':attribute geçerli bir bölge olmalidir.',
    'unique'                          => ':attribute zaten alinmis.',
    'uploaded'                        => ':attribute yüklenemedi.',
    'url'                             => ':attribute biçimi geçersiz.',
    'captcha'                         => ':attribute dogru degil',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom'                          => [
        'attribute-name' => [
            'rule-name' => 'özel mesaj',
        ],
        'field_label'    => [
            'regex' => 'Alan Etiketi geçersiz bir karakter içeriyor. Izin verilen karakterler: A-Z, a-z, 0-9, bosluk, -, _',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes'                      => [],
    'unique_of_decimal_and_thousands' => 'Decimal point and thousand separator already selected for another currency'

];

return \FI\Support\TranslationOverride::override(__FILE__, $translations);
