<?php

$translations = [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'                        => ':attribute måste accepteras.',
    'active_url'                      => ':attribute är inte en giltig URL.',
    'after'                           => ':attribute måste vara ett datum efter :date.',
    'after_or_equal'                  => ':attribute måste vara ett datum efter eller lika med :date.',
    'alpha'                           => ':attribute får bara innehålla bokstäver.',
    'alpha_dash'                      => ':attribute får bara innehålla bokstäver, siffror och bindestreck.',
    'alpha_num'                       => ':attribute får bara innehålla bokstäver och siffror.',
    'array'                           => ':attribute måste vara en array.',
    'before'                          => ':attribute måste vara ett datum före :date.',
    'before_or_equal'                 => ':attribute måste vara ett datum före eller lika med :date.',
    'between'                         => [
        'numeric' => ':attribute måste vara mellan :min och :max.',
        'file'    => ':attribute måste vara mellan :min och :max kilobyte.',
        'string'  => ':attribute måste vara mellan :min och :max tecken.',
        'array'   => ':attribute måste ha mellan :min och :max poster.',
    ],
    'boolean'                         => 'Fältet :attribute måste vara sant eller falskt.',
    'confirmed'                       => ':attribute -bekräftelsen matchar inte.',
    'date'                            => ':attribute är inte ett giltigt datum.',
    'date_format'                     => ':attribute matchar inte formatet :format.',
    'different'                       => ':attribute och :other måste vara olika.',
    'digits'                          => ':attribute måste vara :digits siffror.',
    'digits_between'                  => ':attribute måste vara mellan :min och :max siffror.',
    'dimensions'                      => ':attribute har ogiltiga bilddimensioner.',
    'distinct'                        => 'Fältet :attribute har ett dubblettvärde.',
    'email'                           => ':attribute måste vara en giltig e-postadress.',
    'exists'                          => 'Det valda :attribute är ogiltigt.',
    'file'                            => ':attribute måste vara en fil.',
    'filled'                          => 'Fältet :attribute måste ha ett värde.',
    'image'                           => ':attribute måste vara en bild.',
    'in'                              => 'Det valda :attribute är ogiltigt.',
    'in_array'                        => 'Fältet :attribute finns inte i :other.',
    'integer'                         => ':attribute måste vara ett heltal.',
    'ip'                              => ':attribute måste vara en giltig IP-adress.',
    'ipv4'                            => ':attribute måste vara en giltig IPv4-adress.',
    'ipv6'                            => ':attribute måste vara en giltig IPv6-adress.',
    'json'                            => ':attribute måste vara en giltig JSON-sträng.',
    'max'                             => [
        'numeric' => ':attribute får inte vara större än :max.',
        'file'    => ':attribute får inte vara större än :max kilobyte.',
        'string'  => ':attribute får inte vara större än :max tecken.',
        'array'   => ':attribute får inte ha fler än :max objekt.',
    ],
    'mimes'                           => ':attribute måste vara en fil av typen: :values.',
    'mimetypes'                       => ':attribute måste vara en fil av typen: :values.',
    'min'                             => [
        'numeric' => ':attribute måste vara minst :min.',
        'file'    => ':attribute måste vara minst :min kilobyte.',
        'string'  => ':attribute måste bestå av minst :min tecken.',
        'array'   => ':attribute måste ha minst :min objekt.',
    ],
    'not_in'                          => 'Det valda :attribute är ogiltigt.',
    'numeric'                         => ':attribute måste vara ett tal.',
    'present'                         => 'Fältet :attribute måste finnas.',
    'regex'                           => 'Formatet :attribute är ogiltigt.',
    'required'                        => 'Fältet :attribute är obligatoriskt.',
    'required_if'                     => 'Fältet :attribute krävs när :other är :value.',
    'required_unless'                 => 'Fältet :attribute är obligatoriskt om inte :other finns i :values.',
    'required_with'                   => 'Fältet :attribute är obligatoriskt när :values finns.',
    'required_with_all'               => 'Fältet :attribute är obligatoriskt när :values finns.',
    'required_without'                => 'Fältet :attribute är obligatoriskt när :values inte finns.',
    'required_without_all'            => 'Fältet :attribute är obligatoriskt när inget av :values finns.',
    'same'                            => ':attribute och :other måste matcha.',
    'size'                            => [
        'numeric' => ':attribute måste vara :size.',
        'file'    => ':attribute måste vara :size kilobyte.',
        'string'  => ':attribute måste vara :size tecken.',
        'array'   => ':attribute måste innehålla :size -objekt.',
    ],
    'string'                          => ':attribute måste vara en sträng.',
    'timezone'                        => ':attribute måste vara en giltig zon.',
    'unique'                          => ':attribute har redan tagits.',
    'uploaded'                        => 'Det gick inte att ladda upp :attribute.',
    'url'                             => 'Formatet :attribute är ogiltigt.',
    'captcha'                         => ':attribute är inte korrekt',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom'                          => [
        'attribute-name' => [
            'rule-name' => 'anpassat meddelande',
        ],
        'field_label'    => [
            'regex' => 'Fältetikett innehåller ett ogiltigt tecken. Tillåtna tecken: A-Z, a-z, 0-9, blanksteg, -, _',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes'                      => [],
    'unique_of_decimal_and_thousands' => 'Decimal point and thousand separator already selected for another currency'

];

return \FI\Support\TranslationOverride::override(__FILE__, $translations);
