<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Kontoinställningar',
    'active'                                          => 'Aktiv',
    'activity'                                        => 'Aktivitet',
    'activity_invoice_paid'                           => 'Faktura <a href=":link">#:number</a> är betald.',
    'activity_invoice_viewed'                         => 'Faktura <a href=":link">#:number</a> är visad.',
    'activity_quote_approved'                         => 'Offert <a href=":link">#:number</a> blev godkänd.',
    'activity_quote_rejected'                         => 'Offert <a href=":link">#:number</a> avslogs.',
    'activity_quote_viewed'                           => 'Offert <a href=":link">#:number</a> är visad.',
    'add_item'                                        => 'Lägg till produkt',
    'add_line_item_to_invoice'                        => 'Lägg till rader på faktura',
    'add_note'                                        => 'Lägg till anteckning',
    'additional'                                      => 'Extra',
    'addon'                                           => 'Tillägg',
    'addons'                                          => 'Tillägg',
    'address'                                         => 'Adress',
    'address_format'                                  => 'Adressformat',
    'after_amount'                                    => 'Efter belopp',
    'all'                                             => 'Alla',
    'all_categories'                                  => 'Alla kategorier',
    'all_statuses'                                    => 'Alla statusar',
    'all_time'                                        => 'Alla tider',
    'all_vendors'                                     => 'Alla leverantörer',
    'allow_login'                                     => 'Tillåt inloggning',
    'always_attach_pdf'                               => 'Bigofa alltid PDF',
    'always_bcc'                                      => 'Alltid hemlig kopia',
    'always_cc'                                       => 'Alltid kopia',
    'amount'                                          => 'Belopp',
    'api_public_key'                                  => 'API publik nyckel',
    'api_secret_key'                                  => 'API hemlig nyckel',
    'approve'                                         => 'Godkänn',
    'approved'                                        => 'Godkänd',
    'approved_quotes'                                 => 'Godkända offerter',
    'attach_files'                                    => 'Bifoga filer',
    'attach_pdf'                                      => 'Bifoga PDF',
    'attachment'                                      => 'Bifogad fil',
    'attachments'                                     => 'Bifogade filer',
    'author'                                          => 'Upphovsman',
    'automatic'                                       => 'Automatiskt',
    'automatic_email_on_recur'                        => 'E-posta automatiskt återkommande fakturor',
    'automatic_email_payment_receipts'                => 'E-posta automatiskt betalkvitton',
    'available_fields'                                => 'Tillgängliga fält',
    'back'                                            => 'Tillbaka',
    'back_to_invoice'                                 => 'Tillbaka till faktura',
    'back_to_quote'                                   => 'Tillbaka till offert',
    'balance'                                         => 'Balans',
    'base_currency'                                   => 'Basvaluta',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Innan belopp',
    'bill_this_expense'                               => 'Räkna ut denna kostnad',
    'bill_to'                                         => 'Fakturera till',
    'billable'                                        => 'Debiterbar',
    'billed'                                          => 'Faktureras',
    'billing_address'                                 => 'Fakturaadress',
    'billing_city'                                    => 'Fakturastad',
    'billing_name'                                    => 'Fakturanamn',
    'billing_state'                                   => 'Fakturastat',
    'billing_zip'                                     => 'Fakturapostnummer',
    'binary_path'                                     => 'Binär sökväg',
    'body'                                            => 'Meddelandet',
    'cancel'                                          => 'Avbryta',
    'canceled'                                        => 'Avbruten',
    'card_number'                                     => 'Kortnummer',
    'cash'                                            => 'Kontant',
    'category'                                        => 'Kategori',
    'cc'                                              => 'CC',
    'change'                                          => 'Byta',
    'change_client'                                   => 'Byt kund',
    'check_for_update'                                => 'Sök efter uppdatering',
    'city'                                            => 'Stad',
    'clear_keys'                                      => 'Rensa nycklar',
    'client'                                          => 'Kund',
    'client_form'                                     => 'Kundformulär',
    'client_name'                                     => 'Kundnamn',
    'client_not_found'                                => 'Kunden hittades inte',
    'client_statement'                                => 'Kundutdrag',
    'client_unique_name_option_1'                     => 'Endast när kundens namn inte är unikt',
    'client_unique_name_option_2'                     => 'Visa alltid',
    'client_visibility'                               => 'Kundsynlighet',
    'clients'                                         => 'Kunder',
    'code'                                            => 'Kod',
    'column_name'                                     => 'Kolumnnamn',
    'column_width'                                    => 'Kolumnbredd',
    'company'                                         => 'Företag',
    'complete'                                        => 'Färdig',
    'complete_upgrade'                                => 'Slutföra uppgraderingen',
    'compound'                                        => 'Sammansätt',
    'compound_tax_note'                               => 'Sammansatta skattesatser måste tillämpas på en vara som skatt 2 för att få önskad effekt.',
    'confirm_approve_quote'                           => 'Är du säker på att du vill godkänna denna offert?',
    'confirm_reject_quote'                            => 'Är du säker på att du vill avslå denna offert?',
    'continue'                                        => 'Fortsätt',
    'convert_quote_option1'                           => 'Fakturan ska behålla villkoren i offerten',
    'convert_quote_option2'                           => 'Fakturan ska använda standardfaktura villkoren',
    'convert_quote_setting'                           => 'När en offert konverteras till en faktura',
    'convert_quote_when_approved'                     => 'Omvandla automatiskt offert till faktura när kunden godkänner',
    'converted_from_quote'                            => 'Konverterad från offert',
    'converted_to_invoice'                            => 'Konverterad till faktura',
    'country'                                         => 'Land',
    'create_invoice'                                  => 'Skapa faktura',
    'create_quote'                                    => 'Skapa offert',
    'created'                                         => 'Skapad',
    'credit_card'                                     => 'Kreditkort',
    'currencies'                                      => 'Valutor',
    'currency'                                        => 'Valuta',
    'currency_form'                                   => 'Valutaformulär',
    'currency_symbol'                                 => 'Valutasymbol',
    'currency_symbol_placement'                       => 'Valutasymbol placering',
    'custom_date_range'                               => 'Anpassat datumintervall',
    'custom_field_form'                               => 'Anpassad fältform',
    'custom_fields'                                   => 'Anpassade fält',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'Panel',
    'dashboard_totals_option'                         => 'Totalsummor på panelen bör inkludera',
    'database_not_configured'                         => 'Det verkar som app/config/database.php inte har konfigurerats ännu.',
    'database_setup'                                  => 'Databasinställningar',
    'date'                                            => 'Datum',
    'date_format'                                     => 'Datumformat',
    'days'                                            => 'Dagar',
    'decimal_point'                                   => 'Decimalpoint',
    'default_currency'                                => 'Standardvaluta',
    'default_footer'                                  => 'Standardsidfot',
    'default_group'                                   => 'Standardgrupp',
    'default_invoice_email_body'                      => 'Standardmall faktura meddelandetext',
    'default_invoice_template'                        => 'Standard fakturamall',
    'default_item_tax_2_rate'                         => 'Standard produkt skatt 2',
    'default_item_tax_rate'                           => 'Standard produkt skatt',
    'default_overdue_invoice_email_body'              => 'Standardmall förfallen faktura meddelandetext',
    'default_payment_receipt_body'                    => 'Standardmall betalningskvitto',
    'default_quote_email_body'                        => 'Standardmall offert meddelandetext',
    'default_quote_template'                          => 'Standardmall offert',
    'default_terms'                                   => 'Standardvillkor',
    'delete'                                          => 'Radera',
    'delete_client_warning'                           => 'Om du tar bort den här kunden tar du också bort eventuella fakturor, offerter och betalningar relaterade till den här kunden. Är du säker på att du vill radera denna kund permanent?',
    'delete_record_warning'                           => 'Är du säker på att du vill radera den här posten?',
    'description'                                     => 'Beskrivning',
    'details'                                         => 'Detaljer',
    'disabled'                                        => 'Inaktiverad',
    'discount'                                        => 'Rabatt',
    'display_client_unique_name'                      => 'Visa kundens unika namn',
    'display_do_not_require'                          => 'Visa men kräv inte',
    'display_order'                                   => 'Visningsordning',
    'display_profile_image'                           => 'Visa profilbild',
    'do_not_add_line_item_to_invoice'                 => 'Lägg inte till raden i fakturan',
    'do_not_display'                                  => 'Visa inte',
    'documentation'                                   => 'Dokumentation',
    'download'                                        => 'Ladda ner',
    'draft'                                           => 'Utkast',
    'draft_invoices'                                  => 'Utkast fakturor',
    'draft_quotes'                                    => 'Utkast offerter',
    'dropdown'                                        => 'Rullgardinsmeny',
    'due'                                             => 'Förfaller',
    'due_date'                                        => 'Förfallodatum',
    'edit'                                            => 'Redigera',
    'edit_client'                                     => 'Redigera kund',
    'email'                                           => 'E-post',
    'email_address'                                   => 'E-postadress',
    'email_invoice'                                   => 'E-post faktura',
    'email_payment_receipt'                           => 'E-post kvitto',
    'email_quote'                                     => 'E-post offert',
    'email_send_method'                               => 'E-postsändningsmetod',
    'email_send_method_phpmail'                       => 'PHP Mail',
    'email_send_method_sendmail'                      => 'Sendmail',
    'email_send_method_sendgrid'                      => 'SendGrid API',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Aktiverad',
    'enter_payment'                                   => 'Ange betalning',
    'error'                                           => 'Fel',
    'every'                                           => 'Varje',
    'exchange_rate'                                   => 'Växlingskurs',
    'exchange_rate_mode'                              => 'Växlingskursläga',
    'expense_form'                                    => 'Kostnadsformulär',
    'expenses'                                        => 'Kostnader',
    'expiration'                                      => 'Utgång',
    'expires'                                         => 'Utgår',
    'export_clients'                                  => 'Exportera kunder',
    'export_data'                                     => 'Exportera data',
    'export_expenses'                                 => 'Exportera kostnader',
    'export_invoice_items'                            => 'Exportera fakturaprodukter',
    'export_invoices'                                 => 'Exportera fakturor',
    'export_payments'                                 => 'Exportera betalningar',
    'export_quote_items'                              => 'Exportera offertprodukter',
    'export_quotes'                                   => 'Exportera offerter',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Faxnummer',
    'field_label'                                     => 'Fältetikett',
    'field_meta'                                      => 'Fältmeta',
    'field_meta_description'                          => 'Använd Meta-fältet endast om fälttypen är en rullgardinsmeny. Om du vill ange rullgardins-värden anger du en lista med rullgardins-värden separerade med kommatecken.',
    'field_type'                                      => 'Fälttyp',
    'footer'                                          => 'Sidfot',
    'format'                                          => 'Format',
    'frequency'                                       => 'Frekvens',
    'from'                                            => 'Från',
    'from_date'                                       => 'Från datum',
    'general'                                         => 'Allmänt',
    'generate_keys'                                   => 'Generera nycklar',
    'group'                                           => 'Grupp',
    'group_form'                                      => 'Gruppformulär',
    'groups'                                          => 'Grupper',
    'header_title_text'                               => 'Rubrik titeltext',
    'help'                                            => 'Hjälp',
    'help_currency_code'                              => 'Valutakoden, t.ex. "SEK"',
    'help_currency_name'                              => 'Valutanamnet, t.ex. "Svenska krona".',
    'help_currency_symbol'                            => 'Valutasymbolen, t.ex. "kr".',
    'help_currency_symbol_placement'                  => 'Var ska man placera valutasymbolen.',
    'help_text_client_name'                           => 'Detta värde kan vara namnet på ett företag eller en person och visas på offerter och fakturor. Detta värde behöver inte vara unikt.',
    'help_text_client_password'                       => 'Lämna det här fältet tomt om du inte skapar eller återställer ett lösenord.',
    'help_text_client_unique_name'                    => 'När en eller flera kunder i systemet delar samma namn måste ett unikt namn anges för att skilja mellan dem. Detta värde kommer inte att visas på offerter eller fakturor.',
    'i_accept'                                        => 'Jag accepterar',
    'import_data'                                     => 'Importera information',
    'inactive'                                        => 'Inaktiv',
    'income'                                          => 'Inkomst',
    'install'                                         => 'Installera',
    'installation_complete'                           => 'Installation färdig',
    'installing_please_wait'                          => 'Installerar, vänta...',
    'invalid_credentials'                             => 'Ogiltiga uppgifter',
    'invoice'                                         => 'Faktura',
    'invoice_default'                                 => 'Standardfaktura',
    'invoice_email_subject'                           => 'Faktura e-postämne',
    'invoice_items'                                   => 'Faktura produkter',
    'invoice_number'                                  => 'Fakturanummer',
    'invoice_summary'                                 => 'Faktura sammanfattning',
    'invoiced'                                        => 'Fakturerad',
    'invoices'                                        => 'Fakturor',
    'invoices_due_after'                              => 'Fakturan förfaller efter (dagar)',
    'issued'                                          => 'Utfärdad',
    'item'                                            => 'Produkt',
    'item_lookup_form'                                => 'Produktsökningsformulär',
    'item_lookups'                                    => 'Produktsökning',
    'item_sales'                                      => 'Produktförsäljning',
    'items'                                           => 'Produkter',
    'label_invoice'                                   => 'Välj faktura för att lägga till denna kostnad till',
    'label_item_description'                          => 'Ange en beskrivning för denna kostnad (valfritt)',
    'label_item_name'                                 => 'Ange namnet på raden för att lägga till fakturan',
    'landscape'                                       => 'Liggande',
    'language'                                        => 'Språk',
    'left_pad'                                        => 'Numrets minsta längd',
    'left_pad_description'                            => 'Längden uppnås genom att lägga till nollor till vänster.',
    'legal'                                           => 'Legal',
    'letter'                                          => 'Letter',
    'license_agreement'                               => 'Licensavtal',
    'license_agreement_accept'                        => 'Jag accepterar villkoren i licensavtalet',
    'logo'                                            => 'Logotyp',
    'mail_hash_error'                                 => 'Det verkar som om din hemliga nyckel har ändrats sedan senaste gången du sparade ditt lösenord för e-post. För att åtgärda detta fel, gå till Systeminställningar -> E-postfliken, skriv in ditt lösenord för e-post och tryck på Spara. Observera att inget mejl kommer att levereras tills detta har gjorts.',
    'manual'                                          => 'Manuellt',
    'map_fields_to_import'                            => 'Mappa fält att importera',
    'merchant_api_key'                                => 'API nyckel',
    'merchant_api_password'                           => 'API lösenord',
    'merchant_api_username'                           => 'API användarnamn',
    'merchant_publishable_key'                        => 'Publicerbar nyckel',
    'merchant_secret_key'                             => 'Hemlig nyckel',
    'merchant_signature'                              => 'Signatur',
    'mobile'                                          => 'Mobil',
    'mobile_number'                                   => 'Mobilnummer',
    'monthly'                                         => 'En gång i månaden',
    'months'                                          => 'Månader',
    'multiple_email_validation'                       => 'Flera e-postadresser ska vara giltiga och åtskilda med kommatecken.',
    'name'                                            => 'Namn',
    'net_income'                                      => 'Nettoinkomst',
    'never'                                           => 'Aldrig',
    'new'                                             => 'Ny',
    'next_date'                                       => 'Nästa datum',
    'next_number'                                     => 'Nästa nummer',
    'no'                                              => 'Nej',
    'no_open_invoices'                                => 'Den här kunden har inga öppna fakturor. För att fakturera en kostnad måste kunden ha minst en faktura som inte har betalats i sin helhet.',
    'no_records_found'                                => 'Inga uppgifter funna',
    'none'                                            => 'Ingen',
    'not_billable'                                    => 'Ej fakturerbar',
    'not_billed'                                      => 'Ej fakturerad',
    'not_viewed'                                      => 'Inte visad',
    'not_visible'                                     => 'Inte synlig',
    'note'                                            => 'Notering',
    'note_notification'                               => 'Notifiering: Ny anteckning',
    'notes'                                           => 'Anteckningar',
    'online_payment'                                  => 'Internetbetalning',
    'online_payment_method'                           => 'Internetbetalningsmetod',
    'online_payments'                                 => 'Internetbetalningar',
    'options'                                         => 'Alternativ',
    'other'                                           => 'Andra',
    'output_type'                                     => 'Utmatningstyp',
    'overdue'                                         => 'Försenad',
    'overdue_email_subject'                           => 'Försenad e-postämne',
    'overdue_invoice_reminder'                        => 'Försenad fakturapåminnelse',
    'overdue_invoice_reminder_frequency'              => 'Försenad fakturapåminnelse frekvens',
    'overdue_invoice_reminder_frequency_help'         => 'En kommaseparerad lista över dagar EFTER för en försenad faktura innan påminnelse skickas. Lämna tomt för att inaktivera försenade fakturapåminnelser. Till exempel skulle ett värde på 1,5,10 skicka påminnelser 1, 5 och 10 dagar efter fakturan förfaller.',
    'overdue_invoices'                                => 'Förfallna fakturor',
    'paid'                                            => 'Betald',
    'paper_orientation'                               => 'Pappersorientering',
    'paper_size'                                      => 'Pappersformat',
    'password'                                        => 'Lösenord',
    'password_confirmation'                           => 'Lösenordsbekräftelse',
    'password_successfully_reset'                     => 'Lösenordet återställs',
    'pay'                                             => 'Betala',
    'pay_now'                                         => 'Betala nu',
    'payment_applied'                                 => 'Din betalning har tillämpats',
    'payment_button_text'                             => 'Betalningsknapp Text',
    'payment_date'                                    => 'Betalningsdag',
    'payment_form'                                    => 'Betalningsformulär',
    'payment_method'                                  => 'Betalningsmetod',
    'payment_method_form'                             => 'Betalningsmetod formulär',
    'payment_methods'                                 => 'Betalningsmetoder',
    'payment_receipt'                                 => 'Kvitto',
    'payment_receipt_email_subject'                   => 'Betalningsbevis e-postämne',
    'payments'                                        => 'Betalningar',
    'payments_collected'                              => 'Samlade inbetalningar',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'PDF drivrutin',
    'pdf_driver_wkhtmltopdf'                          => 'Fältet Binär Filväg måste innehålla en giltig filväg när du använder wkhtmltopdf PDF-drivrutinen.',
    'percent'                                         => 'Procent',
    'phone'                                           => 'Telefon',
    'phone_number'                                    => 'Telefonnummer',
    'php_version_error'                               => 'PHP uppfyller inte versionskravet (%s)',
    'placeholder_type_message'                        => 'Skriv meddelande...',
    'portrait'                                        => 'Stående',
    'postal_code'                                     => 'Postnummer',
    'prefix'                                          => 'Prefix',
    'prerequisites'                                   => 'Förutsättningar',
    'preview'                                         => 'Förhandsvisning',
    'price'                                           => 'Pris',
    'private'                                         => 'Privat',
    'problem_with_email_template'                     => 'Det verkar vara ett problem med e-postmallen. Kontrollera mallarna i Systeminställningar på fliken E-post.',
    'product'                                         => 'Produkt',
    'profit_and_loss'                                 => 'Vinst och förlust',
    'public'                                          => 'Publik',
    'qty'                                             => 'st',
    'quantity'                                        => 'Antal',
    'quantity_price_decimals'                         => 'Antal decimaler för kvantiteter och belopp',
    'quote'                                           => 'Offert',
    'quote_approved'                                  => 'Offert godkänd',
    'quote_approved_email_body'                       => 'Offert godkänd meddelandetext',
    'quote_default'                                   => 'Standardmall offert',
    'quote_email_subject'                             => 'Offert e-postämne',
    'quote_items'                                     => 'Offert produkter',
    'quote_number'                                    => 'Offertnummer',
    'quote_rejected'                                  => 'Offert avslagen',
    'quote_rejected_email_body'                       => 'Offert avslagen meddelandetext',
    'quote_status_change_notification'                => 'Notifiering: Offert statusändring',
    'quote_summary'                                   => 'Offert sammansfattning',
    'quote_to_invoice'                                => 'Offert till faktura',
    'quotes'                                          => 'Offerter',
    'quotes_expire_after'                             => 'Offert går ut efter (dagar)',
    'recalculate'                                     => 'Beräkna om',
    'recalculate_help_text'                           => 'Omberäkning kan ta några minuter att slutföra. Ett meddelande visas när processen är klar.',
    'recalculate_invoices'                            => 'Beräkna om fakturor',
    'recalculate_quotes'                              => 'Beräkna om offerter',
    'recalculating_wait'                              => 'Beräknar om, vänta...',
    'recalculation_complete'                          => 'Omberäkning klar',
    'recent_invoices'                                 => 'Senaste fakturor',
    'recent_payments'                                 => 'Senaste betalningar',
    'recent_quotes'                                   => 'Senaste offerter',
    'record_not_found'                                => 'Posten hittades inte',
    'record_successfully_created'                     => 'Posten skapades',
    'record_successfully_deleted'                     => 'Posten raderades',
    'record_successfully_updated'                     => 'Posten uppdaterades',
    'records_imported_successfully'                   => 'Posten importerades',
    'recurring'                                       => 'Återkommande',
    'reject'                                          => 'Avslå',
    'rejected'                                        => 'Avslagen',
    'rejected_quotes'                                 => 'Avslagna offerter',
    'remember_me'                                     => 'Kom ihåg mig',
    'remove_logo'                                     => 'Ta bort logotypen',
    'report_rev_client_notice'                        => 'Denna rapport kommer att finnas tillgänglig när du har några betalningar inmatade i systemet.',
    'reports'                                         => 'Rapporter',
    'require'                                         => 'Obligatorisk',
    'reset_number'                                    => 'Återställ nummer',
    'reset_password'                                  => 'Återställ lösenord',
    'results_per_page'                                => 'Resultat per sida',
    'revenue_by_client'                               => 'Intäkter per kund',
    'round_tax_decimals'                              => 'Antal decimaler för skatteavrundning',
    'run_report'                                      => 'Kör rapport',
    'save'                                            => 'Spara',
    'save_and_apply_exchange_rate'                    => 'Spara och tillämpa växelkurs',
    'save_item_as_lookup'                             => 'Spara objekt som sökning',
    'search'                                          => 'Sök',
    'select_file_to_import'                           => 'Välj den fil som ska importeras',
    'send'                                            => 'Skicka',
    'sending'                                         => 'Skickar',
    'sendmail_path'                                   => 'Sendmail filväg',
    'sent'                                            => 'Skickad',
    'sent_invoices'                                   => 'Skickade fakturor',
    'sent_quotes'                                     => 'Skickade offerter',
    'settings'                                        => 'Inställningar',
    'settings_successfully_saved'                     => 'Inställningarna har sparats',
    'setup'                                           => 'Setup',
    'sign_in'                                         => 'Logga in',
    'sign_out'                                        => 'Logga ut',
    'skin'                                            => 'Utseende',
    'smtp_encryption'                                 => 'SMTP kryptering',
    'smtp_host_address'                               => 'SMTP värdadress',
    'smtp_host_port'                                  => 'SMTP värdport',
    'smtp_password'                                   => 'SMTP lösenord',
    'smtp_username'                                   => 'SMTP användarnamn',
    'start_date'                                      => 'Start datum',
    'state'                                           => 'Stat',
    'status'                                          => 'Status',
    'step_database_setup'                             => 'Detta steg kommer att installera och uppgradera dina databastabeller. Det här steget kan ta några minuter att slutföra.',
    'step_prerequisites'                              => 'Följande förutsättningar måste lösas innan installationen kan fortsätta:',
    'subject'                                         => 'Ämne',
    'submit'                                          => 'Skicka',
    'subtotal'                                        => 'Delsumma',
    'summary'                                         => 'Sammanfattning',
    'symbol'                                          => 'Symbol',
    'symbol_placement'                                => 'Symbolplacering',
    'system'                                          => 'System',
    'system_settings'                                 => 'Systeminställningar',
    'table_name'                                      => 'Tabellnamn',
    'tax'                                             => 'Skatt',
    'tax_1'                                           => 'Skatt 1',
    'tax_2'                                           => 'Skatt 2',
    'tax_rate'                                        => 'Skattesats',
    'tax_rate_form'                                   => 'Skattesatsformulär',
    'tax_rate_name'                                   => 'Skattesatsnamn',
    'tax_rate_percent'                                => 'Skattesatsprocent',
    'tax_rates'                                       => 'Skattesatser',
    'tax_summary'                                     => 'Skatteöversikt',
    'taxable_amount'                                  => 'Skattepliktiga belopp',
    'taxes'                                           => 'Skatter',
    'template'                                        => 'Mall',
    'terms_and_conditions'                            => 'Villkor',
    'test_mode'                                       => 'Övningsläge',
    'text'                                            => 'Text',
    'textarea'                                        => 'Textarea',
    'this_quarter'                                    => 'Detta kvartal',
    'thousands_separator'                             => 'Tusentals separator',
    'timezone'                                        => 'Tidszon',
    'to'                                              => 'Till',
    'to_date'                                         => 'Hittills',
    'total'                                           => 'Total',
    'total_balance'                                   => 'Total balans',
    'total_invoiced'                                  => 'Totalt fakturerad',
    'total_expenses'                                  => 'Totala utgifter',
    'total_paid_invoices'                             => 'Totala betalade fakturor',
    'try_again'                                       => 'Försök igen',
    'uninstall'                                       => 'Avinstallera',
    'uninstall_addon_warning'                         => 'Om du avinstallerar denna tillägg tar du bort all data du har angett i samband med tillägget. Är du säker på att du vill fortsätta?',
    'unique_name'                                     => 'Unikt namn',
    'unknown_error'                                   => 'Okänt fel',
    'upcoming_payment_notice_email_body'              => 'Kommande betalningsmeddelande meddelandetext',
    'upcoming_payment_notice_email_subject'           => 'Kommande betalningsmeddelande e-postämne',
    'upcoming_payment_notice_frequency'               => 'Kommande betalningsmeddelande frekvens',
    'upcoming_payment_notice_frequency_help'          => 'En kommaseparerad lista över dagar FÖRE en faktura ska skickas. Lämna tomma för att inaktivera kommande betalningsmeddelanden. Till exempel skulle ett värde på 1,5 skicka meddelanden 1 och 5 dagar innan fakturan förfaller.',
    'update_available'                                => 'FusionInvoice :version är tillgänglig för nedladdning!',
    'update_exchange_rate'                            => 'Uppdatera växelkurs',
    'update_not_available'                            => 'Det finns för tillfället inga uppdateringar tillgängliga.',
    'upload_progress'                                 => 'Uppladdning framfart',
    'user'                                            => 'Användare',
    'user_accounts'                                   => 'Användarkonton',
    'user_form'                                       => 'Användarformulär',
    'users'                                           => 'Användare',
    'validation_invoice_summary_from_date'            => 'Datumet på Fakturasammanställningen på Panelen krävs när datumintervallet är inställt på Anpassat datumintervall.',
    'validation_invoice_summary_to_date'              => 'Datumet på Fakturasammanställningen på Panelen krävs när du använder ett anpassat datumintervall.',
    'validation_quote_summary_from_date'              => 'Datumet på Offertsammanställningen på Panelen krävs när datumintervallet är inställt på Anpassat datumintervall.',
    'validation_quote_summary_to_date'                => 'Datumet på Offertsammanställningen på Panelen krävs när du använder ett anpassat datumintervall.',
    'vendor'                                          => 'Säljare',
    'version'                                         => 'Version',
    'view'                                            => 'Visa',
    'view_all'                                        => 'Visa alla',
    'view_all_invoices_for_client'                    => 'Visa alla fakturor för den här kunden',
    'view_all_payments_for_client'                    => 'Visa alla betalningar för den här kunden',
    'view_all_quotes_for_client'                      => 'Visa alla offerter för den här kunden',
    'view_approved_quotes'                            => 'Visa godkända offerter',
    'view_client'                                     => 'Visa kund',
    'view_draft_invoices'                             => 'Visa faktura utkast',
    'view_draft_quotes'                               => 'Visa offert utkast',
    'view_overdue_invoices'                           => 'Visa förfallna fakturor',
    'view_payments'                                   => 'Visa betalningar',
    'view_rejected_quotes'                            => 'Visa avslagna offerter',
    'view_sent_invoices'                              => 'Visa skickade fakturor',
    'view_sent_quotes'                                => 'Visa skickade offerter',
    'view_unique_name'                                => 'Visa unikt namn',
    'viewed'                                          => 'Visad',
    'visible'                                         => 'Synlig',
    'visible_after_payment'                           => 'Synlig efter betalning',
    'web'                                             => 'Hemsida',
    'web_address'                                     => 'Hemsideadress',
    'weekly'                                          => 'Varje vecka',
    'weeks'                                           => 'Veckor',
    'welcome'                                         => 'Välkommen',
    'what_to_import'                                  => 'Vad vill du importera?',
    'year'                                            => 'År',
    'yearly'                                          => 'Årlig',
    'years'                                           => 'År',
    'yes'                                             => 'Ja',
    'you_may_now_sign_in'                             => 'Du kan nu logga in!',

    // 2017-1
    'all_company_profiles'                            => 'Alla företagsprofiler',
    'cannot_delete_record_in_use'                     => 'Den här posten används och kan inte raderas.',
    'cannot_edit_record_in_use'                       => 'Den här posten används och kan inte redigeras.',
    'change_company_profile'                          => 'Ändra företagsprofil',
    'company_profile'                                 => 'Företagsprofil',
    'company_profiles'                                => 'Företagsprofiler',
    'company_profile_form'                            => 'Företagsprofil formulär',
    'copy'                                            => 'Kopiera',
    'create_recurring_invoice'                        => 'Skapa återkommande faktura',
    'custom'                                          => 'Anpassad',
    'date_range'                                      => 'Datumintervall',
    'day_short_sunday'                                => 'Sö',
    'day_short_monday'                                => 'Må',
    'day_short_tuesday'                               => 'Ti',
    'day_short_wednesday'                             => 'On',
    'day_short_thursday'                              => 'To',
    'day_short_friday'                                => 'Fr',
    'day_short_saturday'                              => 'Lö',
    'default_company_profile'                         => 'Standard företagsprofil',
    'first_quarter'                                   => 'Första kvartalet',
    'fourth_quarter'                                  => 'Fjärde kvartalet',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Senaste 7 dagarna',
    'last_30_days'                                    => 'Senaste 30 dagarna',
    'last_month'                                      => 'Förra månaden',
    'last_quarter'                                    => 'Förra kvartalet',
    'last_year'                                       => 'Förra året',
    'month_january'                                   => 'januari',
    'month_february'                                  => 'februari',
    'month_march'                                     => 'mars',
    'month_april'                                     => 'april',
    'month_may'                                       => 'maj',
    'month_june'                                      => 'juni',
    'month_july'                                      => 'juli',
    'month_august'                                    => 'augusti',
    'month_september'                                 => 'september',
    'month_october'                                   => 'oktober',
    'month_november'                                  => 'november',
    'month_december'                                  => 'december',
    'recurring_invoice'                               => 'Återkommande faktura',
    'second_quarter'                                  => 'Andra kvartalet',
    'stop_date'                                       => 'Stoppdatum',
    'third_quarter'                                   => 'Tredje kvartalet',
    'this_month'                                      => 'Den här månaden',
    'this_year'                                       => 'Det här året',
    'today'                                           => 'Idag',
    'user_account'                                    => 'Användarkonto',
    'yesterday'                                       => 'Igår',

    // 2017-3
    'mail_log'                                        => 'E-post logg',
    'recent_client_activity'                          => 'Senaste kundaktivitet',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Exkludera obetalda fakturor',

    // 2017-7
    'please_wait'                                     => 'Vänligen vänta...',
    'reply_to_address'                                => 'Svarsaddress',

    // 2017-8
    'admin'                                           => 'Admin',
    'admin_account'                                   => 'Adminkonto',
    'admin_accounts'                                  => 'Adminkonton',
    'all_accounts'                                    => 'Alla konton',
    'api_key'                                         => 'API nyckel',
    'client_account'                                  => 'Kundkonto',
    'client_accounts'                                 => 'Kundkonton',
    'client_id'                                       => 'Kund ID',
    'client_secret'                                   => 'Kundhemlighet',
    'enable_bitcoin_payments'                         => 'Aktivera Bitcoin-betalningar',
    'live'                                            => 'Live',
    'mode'                                            => 'Läge',
    'publishable_key'                                 => 'Publishable Key',
    'sandbox'                                         => 'Sandlådan',
    'secret_key'                                      => 'Hemlig nyckel',
    'type'                                            => 'Typ',

    // 2017-10
    'deselect_all'                                    => 'Avmarkera alla',
    'select_all'                                      => 'Markera alla',
    'use_24_hour_time_format'                         => 'Använd 24-timmarsformat',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Är du säker på att du vill ta bort dessa poster?',
    'bulk_invoice_change_status_warning'              => 'Är du säker på att du vill ändra status för de valda fakturor?',
    'bulk_quote_change_status_warning'                => 'Är du säker på att du vill ändra statusen för de valda offerten?',
    'calculate_as_vat_gst'                            => 'Beräkna som VAT/GST',
    'change_status'                                   => 'Ändra status',
    'default_status_filter'                           => 'Standard status filter',
    'error_applying_payment'                          => 'Det uppstod ett fel vid tillämpningen av denna betalning. Försök med ett annat kort eller betalningsmetod.',
    'remaining'                                       => 'Kvarstående',

    // 2017-12
    'invoice_date'                                    => 'Fakturadatum',
    'include_profit_based_on'                         => 'Inkludera vinst baserat på',

    // 2018-1
    'add_contact'                                     => 'Lägg till kontakt',
    'allow_self_signed_cert'                          => 'Tillåt självsignerat certifikat',
    'backup'                                          => 'Backup',
    'close'                                           => 'Stäng',
    'change_invoice_date_to_todays_date'              => 'Ändra fakturadatum till dagens datum',
    'change_quote_date_to_todays_date'                => 'Ändra offertdatum till dagens datum',
    'contacts'                                        => 'Kontakter',
    'default_bcc'                                     => 'Standard BCC',
    'default_cc'                                      => 'Standard CC',
    'default_to'                                      => 'Standard till',
    'disable'                                         => 'Inaktivera',
    'download_database_backup'                        => 'Ladda ner databasebackup',
    'edit_contact'                                    => 'Redigera kontakt',
    'expense_list'                                    => 'Kostnadslista',
    'keep_invoice_date_as_is'                         => 'Håll fakturadatum som det är',
    'keep_quote_date_as_is'                           => 'Håll offertdatum som det är',
    'if_quote_is_emailed_while_draft'                 => 'Om offerten skickas i statusutkast',

    // 2018-4
    'force_https'                                     => 'Tvinga HTTPS',
    'force_https_help'                                => 'Innan du aktiverar detta alternativ, se till att din FusionInvoice-installation är funktionell via https. Om du inte gör det kan det leda till en icke-funktionell (men fixbar) installation.',

    // 2019-1
    'attached_to'                                     => 'Kopplad till',
    'customer'                                        => 'Kund',
    'expense'                                         => 'Utgift',
    'expense_categories'                              => 'Utgiftkategorier',
    'expense_category_form'                           => 'Utgiftskategori formulär',
    'expense_vendors'                                 => 'Expense Vendors',
    'expense_vendor_form'                             => 'Expense Vendor Form',
    'lead'                                            => 'Lead',
    'local_time'                                      => 'Lokal tid',
    'prospect'                                        => 'Möjlighet',
    'search_clients'                                  => 'Sök kunder',
    'search_expenses'                                 => 'Sök utgifter',
    'search_invoices'                                 => 'Sök fakturor',
    'search_items'                                    => 'Sök produkter',
    'search_log'                                      => 'Sök logg',
    'search_quotes'                                   => 'Sök offerter',
    'search_payments'                                 => 'Sök betalningar',
    'search_recurring_invoices'                       => 'Sök återkommande fakturor',
    'show_all_statuses'                               => 'Visa alla statusar',
    'show_all_types'                                  => 'Visa alla typer',
    'unknown'                                         => 'Okänd',
    'value'                                           => 'Värde',

    // 2019-2
    'default'                                         => 'Standard',
    'no_data_available'                               => 'ingen data tillgänglig',
    'recurring_invoice_list'                          => 'Återkommande fakturarlista',
    'report_total'                                    => 'Rapportera totaler',

    //2019-3
    'checkbox'                                        => 'Checkbox',
    'custom_dropdown_validate'                        => 'Välj giltigt alternativ från :label',
    'custom_image_validate'                           => 'Välj giltig bild på :label',
    'custom_tag_validate'                             => 'Välj giltig tagg från :label',
    'custom_text_validate'                            => 'Ange giltig information om :label',
    'datetime'                                        => 'DateTime',
    'decimal'                                         => 'Decimal',
    'delete-confirm'                                  => 'Är du säker?',
    'grand_total'                                     => 'Totalsumma',
    'image'                                           => 'Bild',
    'integer'                                         => 'Integer',
    'mailed'                                          => 'Mailad',
    'mailed_invoices'                                 => 'Skickade Fakturor',
    'radio'                                           => 'Radio',
    'recurring_id'                                    => 'Återkommande ID',
    'remove_image'                                    => 'Radera Bild',
    'tags'                                            => 'Taggar',
    'tagselection'                                    => 'Val av tagg',
    'unpaid'                                          => 'Obetald',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Visa skickade fakturor',
    'important'                                       => 'Viktig!',
    'created_recurring_invoice_id'                    => 'Skapat från ID för återkommande faktura',
    'mr'                                              => 'Herr.',
    'miss'                                            => 'Fröken',
    'ms'                                              => 'Fröken.',
    'mrs'                                             => 'Fru.',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Kontakttitel',
    'title'                                           => 'Titel',
    'test_email_subject'                              => 'Hej från FusionInvoice',
    'test_email_body'                                 => 'Detta är ett test-e-postmeddelande från FusionInvoice.',
    'test_email_address'                              => 'Skicka e-posttest till',
    'send_test_email'                                 => 'Skicka test-e-post',
    'invalid_json'                                    => 'Ange en giltig JSON-sträng',
    'textarea_rows_limit'                             => 'Rader får inte överstiga :limit',
    'custom_integer_validate'                         => ':label måste vara ett giltigt heltal',

    //2020-1
    'user_role'                                       => 'Användarroll',
    'standard_user'                                   => 'Standardanvändare',
    'permissions'                                     => 'Behörigheter',
    'modules'                                         => 'Moduler',
    'is_view'                                         => 'Se',
    'is_create'                                       => 'Skapa',
    'is_update'                                       => 'Uppdatering',
    'is_delete'                                       => 'Radera',
    'dashboards'                                      => 'Instrumentpaneler',
    'allow_time_period_change'                        => 'Tillåt tidsperiodändring',
    'page_not_found'                                  => 'hoppsan! Sidan hittas inte.',
    'return_to_dashboard'                             => 'We could not find the page you were looking for. <a href =</a>.',
    'no_auth_to_create_client'                        => 'Du har inte behörighet att skapa kunder!',
    'check-all'                                       => 'Markera alla',
    'invoice_prefix'                                  => 'Fakturaprefix',
    'recently_viewed'                                 => 'nyss sedda',
    'copy_from'                                       => 'Kopiera från',
    'select_user'                                     => 'Välj Användare',
    'please_select_user'                              => 'Välj en användare från listan',
    'allow_client_center_login'                       => 'Tillåt inloggning till kundcenter',
    'online_payment_processing_fee'                   => 'Avgift för betalning online',
    'client_password_required'                        => 'Ange klientlösenord',
    'last_login_at'                                   => 'Senaste inloggning kl',
    'show_notes_panel_below_client'                   => 'Visa panelen Anteckningar under klientinformation',
    'notepad'                                         => 'Anteckningsblock',
    'added'                                           => 'Lagt till',
    'last_edited'                                     => 'Senast redigerad',
    'loading'                                         => 'Bearbetar ....',
    'n_records_match'                                 => ':label Spela in :plural match',
    'initials'                                        => 'Initialer',
    'initials_bg_color'                               => 'Initialer Bakgrundsfärg',
    'more'                                            => 'Mer',
    'must_match_all'                                  => 'Måste matcha alla',
    'clear'                                           => 'Klar',
    'no_client_tags'                                  => 'Det finns inga klientposter med taggar definierade.',
    'qr_code_on_invoice_quote'                        => 'QR-kod för faktura och offert',
    'delete_tags'                                     => 'Tagrensning',
    'orphan_tags_deleted'                             => 'Alla föräldralösa taggar har raderats från systemet.',
    'orphan_tags_delete_confirm'                      => 'Om du kör Tag Cleanup tas bort alla oanvända taggar. Fortsätta?',
    'deleting_tags_wait'                              => 'Tar bort taggar, vänta ...',
    'new-version-available'                           => 'Ny version tillgänglig!',
    'ignore-this-version'                             => 'Ignorera den här versionen',
    'view-release-notes'                              => 'Visa release-anmärkningar',
    'task_list'                                       => 'Uppgiftslista',
    'create_task'                                     => 'Skapa uppgift',
    'open'                                            => 'Öppet',
    'closed'                                          => 'Stängd',
    'assignee'                                        => 'Tilldelad',
    'task'                                            => 'Uppgift',
    'task_successfully_created'                       => 'Uppgiften har skapats',
    'task_successfully_updated'                       => 'Uppgiften har uppdaterats',
    'task_completed'                                  => 'Uppgiften har slutförts',
    'task_marked_incomplete'                          => 'Uppgiften öppnades igen',
    'due_date_validation_date'                        => 'Välj ett giltigt förfallodatum',
    'assignee_validation_required'                    => 'Välj en giltig uppdragsgivare från listan',
    'assignee_validation_exists'                      => 'Välj en giltig uppdragsgivare från listan',
    'tomorrow'                                        => 'I morgon',
    'task_not_authorized'                             => 'Du har inte behörighet att redigera denna uppgift!',
    'me'                                              => 'Mig',
    'task_from_note'                                  => 'Skapa uppgift vid Spara',
    'done'                                            => 'Gjort',
    'refresh'                                         => 'Uppdatera',
    'task_list_page_size'                             => 'Antal uppgifter per sida',
    'select_client'                                   => 'Välj klient',
    'note-search-config'                              => 'Anteckningar Sök för att inkludera',
    'username'                                        => 'Användarnamn',
    'task-search-config'                              => 'Uppgiftssökning för att inkludera',
    'task_section_invalid'                            => 'Ogiltigt uppgiftsavsnitt',
    'task_section'                                    => 'Uppgiftsavsnitt',
    'select_section'                                  => 'Välj avsnitt',
    'email-test-failed'                               => 'E-posttest misslyckades',
    'smtp-setting-suggestion'                         => 'Förslag:<br>1. Verifiera och ange dina användar- / lösenordsvärden på nytt<br>2. Verify that your SMTP settings are entered correctly',
    'mail-setting-suggestion'                         => 'Förslag:<br>1. Kontrollera att PHP Mail-servern är korrekt konfigurerad<br>2. Contact server admin',
    'sendmail-setting-suggestion'                     => 'Förslag:<br>1. Kontrollera att din Sendmail-sökväg är korrekt konfigurerad.<br>2. Contact server admin',
    'sendgrid-setting-suggestion'                     => 'Förslag:<br>1. Kontrollera att din Sendgrid-nyckel är korrekt konfigurerad.<br>2. Contact server admin',
    'later'                                           => 'Senare',
    'test-email-required'                             => 'Du måste ange ett giltigt e-postmeddelande',
    'test_mail_sent_successfully'                     => 'Testmeddelandet skickades',
    'test-mail-btn-title'                             => 'Måste spara ändringar innan test.',
    'agreement_expire'                                => 'Dina produktuppdateringar och support upphör att gälla den :date',
    'agreement_expired'                               => 'Dina produktuppdateringar och support har upphört att gälla den :date',
    'piracy_message'                                  => 'Din FusionInvoice-licensnyckel är inte giltig. Piratkopiering av programvara är ett brott. Snälla spela rättvist. Med en giltig licens får du support, uppdateringar och en bra karma.',
    'buy-now'                                         => 'Köp nu',
    'piracy_alert'                                    => 'Var snäll!',
    'agreement-expire-alert'                          => 'Produktuppdateringar och support upphör snart.',
    'agreement-expired-alert'                         => 'Produktuppdateringar och support har löpt ut.',
    'dismiss-forever'                                 => 'Avvisa för alltid',
    'renew-now'                                       => 'Förnya nu',
    'select_all_permissions'                          => 'Välj Alla behörigheter',
    'app-key-missing'                                 => 'Ange din licensnyckel i config / app.php.',
    'custom_fields_column_width'                      => 'Anpassade fält visar kolumner',
    'select-user-type'                                => 'Välj Användartyp',
    'lead-or-prospect-with-invoices-error'            => 'Tyvärr kan en klients typ inte vara Lead eller Prospect när det finns fakturor eller återkommande fakturor.',
    'sendgrid_key'                                    => 'Sendgrid-nyckel',

    //2020-2.0
    'space'                                           => 'Plats',
    'apostrophe'                                      => 'Apostrof',
    'comma'                                           => 'Kommatecken',
    'fullstop'                                        => 'Punkt (punkt)',
    'middledot'                                       => 'Middle Dot',
    'thinspace'                                       => 'Tunt utrymme',
    'narrow-no-break-space'                           => 'Smalt utrymme utan paus',
    'dotabove'                                        => 'Prick ovanför',
    'arabic-decimal'                                  => 'Arabisk decimalavgränsare',
    'arabic-thousand'                                 => 'Arabiska tusen separator',
    'decimal-separator-key-symbol'                    => 'Symbol för decimalavgränsare',
    'select-item'                                     => 'Välj föremål',
    'item-lookup-overload'                            => 'Max. 100 objekt är tillåtna för artikeluppslag',
    'select-expense-category'                         => 'Välj Kostnadskategori',
    'select-expense-vendor'                           => 'Välj Kostnadsförsäljare',
    'can-not-delete-all-users'                        => 'Du kan tyvärr inte ta bort alla användare från systemet',
    'can-not-change-default-user-role'                => 'Du kan tyvärr inte ändra standardanvändarrollen',
    'can-not-change-default-user-status'              => 'Du kan tyvärr inte ändra standardanvändarstatus',
    'user_not_active'                                 => 'Användaren är inte aktiv',
    'can-not-inactive-your-own-status'                => 'Du kan tyvärr inte göra dig inaktiv.',
    'delete_user_warning'                             => '<p>SLUTA! Att ta bort den här användaren är en destruktiv åtgärd som kan ta bort poster som de skapade i systemet. Överväg att göra användaren inaktiv istället.</p><p>Är du säker på att du vill ta bort den här användaren?</p>',
    'include_time_in_due_date'                        => 'Inkludera tid på förfallodatum',
    'cannot_delete_default_company'                   => 'Du kan inte ta bort företagets standardprofil',
    'make-user-inactive'                              => 'Gör användaren inaktiv',
    'mail_from_address'                               => 'Mail från adress',
    'mail_from_name'                                  => 'Mail från namn',
    'item_categories'                                 => 'Varukategorier',
    'select-item-category'                            => 'Välj artikelkategori',
    'item_category_form'                              => 'Objektkategori formulär',
    'sort_by_due'                                     => 'Sortera efter förfallodatum',
    'affiliate'                                       => 'Dotterbolag',
    'parent_account'                                  => 'Föräldrakonto',
    'child_account'                                   => 'Barnkonton',
    'select_parent_client'                            => 'Välj Föräldrakonto',
    'record_successfully_retrieved'                   => 'Spelet hämtades framgångsrikt',
    'custom-image-not-support'                        => 'Anpassat bildfält stöds inte',
    'custom-tag-not-support'                          => 'Anpassat taggfält stöds inte',
    'custom-checkbox-not-support'                     => 'Anpassat kryssruta stöds inte',
    'custom-date-not-support'                         => 'Anpassat datumfält stöds inte',
    'custom-datetime-not-support'                     => 'Anpassat datetime-fält stöds inte',
    'timeline'                                        => 'TimeLine',
    'client_invoice'                                  => 'Fakturor efter klient',
    'select_client_blank_for_all'                     => 'Välj klient (tom för alla)',
    'invoice_email_success'                           => 'Fakturamail skickades',
    'quote_email_success'                             => 'Offertmail har skickats',
    'document_number_schemes'                         => 'Dokumentnummerering',
    'document_number_scheme'                          => 'Schema för dokumentnummer',
    'document_number_scheme_form'                     => 'Dokumentnummer Schemaformulär',
    'default_document_number_scheme'                  => 'Standarddokumentnummerschema',
    'supporting_data'                                 => 'Stödjande data',
    'customizations'                                  => 'Anpassningar',
    'utilities_and_logs'                              => 'Verktyg och loggar',
    'system_log'                                      => 'System-logg',
    'paid_amount'                                     => 'Betald summa',
    'payment_amount'                                  => 'Betalningsbelopp',
    'payment_intent'                                  => 'Betalningsavsikt',
    'apply_payment_to_one_or_more_invoice'            => 'Tillämpa betalning på en eller flera fakturor',
    'pre_payment_for_future_invoices'                 => 'Förskottsbetalning för framtida fakturor',
    'apply_to_invoices'                               => 'Ansök på faktura (er)',
    'payment_application'                             => 'Betalningsansökan',
    'remaining_payment_balance'                       => 'Återstående betalningssaldo',
    'remaining_balance'                               => 'Återstående balans',
    'payment_warning'                                 => 'Ange belopp',
    'apply_pre_payment_warning'                       => 'Du har inte tillämpat betalningen på några fakturor. Vill du spela in det som förskottsbetalning?',
    'confirm_remaining_balance'                       => 'Det återstående saldot på :value kommer att kunna användas för framtida fakturor för den här klienten.',
    'open_balance'                                    => 'Öppna saldot',
    'more_figure_then_total_payment'                  => 'Ange betalningen igen, din totala fakturabetalning är större än återstående saldo.',
    'remaining_payment_balance_apply_later_info'      => 'Återstående betalningsbalanser kan tillämpas på andra fakturor senare.',
    'invoice_balance'                                 => 'Fakturasaldo',
    'enter_payment_for_invoice'                       => 'Ange betalning för faktura',
    'invoice_pdf'                                     => 'Faktura PDF',
    'payment_applications'                            => 'Betalningsansökningar',
    'multiple'                                        => 'Flera olika',
    'ok'                                              => 'Ok',
    'credit_memo_default'                             => 'Kreditnota standard',
    'edit_payment'                                    => 'Redigera betalning',
    'credit_memo'                                     => 'Kreditnota',
    'credit_memos'                                    => 'Kreditnota',
    'create_credit_memo'                              => 'Skapa kreditnota',
    'credit_applications'                             => 'Ansökningar om kreditnoter',
    'credit_applications_for_invoice'                 => 'Ansökningar om kreditnota för faktura',
    'prepayment_applications_for_invoice'             => 'Förskottsansökningar för faktura',
    'apply_credit_memo'                               => 'Tillämpa kreditnota',
    'apply_pre_payment'                               => 'Applicera förskottsbetalning',
    'applied_amount'                                  => 'Tillämpat belopp',
    'remaining_credit_balance'                        => 'Återstående kreditbalans',
    'remaining_credit_balance_apply_later_info'       => 'Återstående kreditbalanser kan tillämpas på andra fakturor senare.',
    'applied'                                         => 'Applicerad',
    'more_figure_then_invoice_amount'                 => 'Ange beloppet igen, beloppet kan inte vara högre än fakturabeloppet.',
    'more_figure_then_invoice_total'                  => 'Vänligen ange beloppet igen, det totala tillämpade beloppet kan inte vara högre än fakturabeloppet.',
    'invoice_not_selected_warning'                    => 'Vänta, du använde inte kreditnota på några fakturor.',
    'select_type'                                     => 'Välj typ',
    'email_credit_memo'                               => 'E-postkreditnot',
    'back_to_credit_memo'                             => 'Tillbaka till kreditnota',
    'invoice_amount'                                  => 'Fakturabelopp',
    'remaining_invoice_amount'                        => 'Återstående fakturabelopp',
    'settlement_for_credit_memo'                      => 'Avräkning för kreditnota',
    'credit_memo_amount'                              => 'Belopp på kreditnota',
    'confirm_remaining_balance_invoice'               => 'Återstående saldo för denna faktura är :value efter avräkning.',
    'payment_receipt_for_invoices'                    => 'Betalningskvitto för fakturor',
    'primary_phone'                                   => 'Huvudsakligt telefonnummer',
    'alternate_phone'                                 => 'Alternativt telefonnummer',
    'currency_not_match'                              => 'Valutan matchar inte',
    'tasks'                                           => 'Uppgifter',
    'full_and_final_payment'                          => 'full',
    'partial'                                         => 'partiell',
    'transition'                                      => [
        'created'          => 'Skapad',
        'updated'          => 'Uppdaterad',
        'deleted'          => 'raderade',
        'received'         => 'Mottagen',
        'opened'           => 'Öppnad',
        'sent'             => 'Skickat',
        'mail'             => 'Postad',
        'changed'          => 'Ändrats',
        'recurring'        => 'Skapad',
        'completed'        => 'Avslutad',
        'reversed'         => 'Omvänd',
        'quote_to_invoice' => 'Offert till faktura',
        'download'         => 'Ladda ner',
        'added'            => 'Lagt till',
        'email'            => 'E-post',
        'merge'            => 'Sammanfoga',
        'billed'           => 'Fakturerad',
        'failed'           => 'Misslyckades',
        'invoice'          => [
            'created'                => 'Faktura :invoice_number skapades',
            'credit_memo_created'    => 'Kreditmemo :credit_memo_number skapades',
            'credit_memo_updated'    => 'Kreditmemo :credit_memo_number modifierades',
            'created_from_recurring' => 'Faktura :invoice_number skapades (från återkommande mall :recurring_invoice_id)',
            'updated'                => 'Fakturan :invoice_number modifierades',
            'deleted'                => 'Fakturan :invoice_number raderades',
            'credit_memo_deleted'    => 'Kreditmemo :credit_memo_number raderades',
            'status_changed'         => 'Faktura :invoice_number Status ändrad från :previous_value till :current_value',
            'email_sent'             => 'E-post faktura :invoice_number skickad',
            'resend_email'           => 'Faktura :invoice_number e-post skicka igen',
            'email_opened'           => 'E-post faktura :invoice_number har öppnats',
            'payment_updated'        => 'Faktura :invoice_number uppdaterad :full_payment_text betalning',
            'payment_received'       => 'Fakturan :invoice_number mottog :full_payment_text betalning',
            'payment_reversed'       => 'Fakturan :invoice_number hade en :full_payment_text',
            'invoice_tag_updated'    => 'Fakturatagg :tags lades till på faktura :invoice_number',
            'invoice_tag_deleted'    => 'Fakturatagg :invoice_number togs bort :tags',
            'mark_mail'              => 'Faktura :invoice_number markera som postad',
            'unmark_mail'            => 'Faktura :invoice_number maskerar som ej postad',
            'paid_invoice_opened'    => 'Betald faktura öppnades för redigering',
            'sent_invoice_opened'    => 'Skickad faktura öppnades för redigering',
            'sms_sent'               => 'Faktura :invoice_number SMS skickat',
        ],
        'quote'            => [
            'created'           => 'Citat :quote_number skapades',
            'updated'           => 'Citat :quote_number modifierades',
            'deleted'           => 'Citat :quote_number raderades',
            'status_changed'    => 'Citat :quote_number Status ändrad från :previous_value till :current_value',
            'email_sent'        => 'Offert :quote_number e-post skickat',
            'resend_email'      => 'Citat :quote_number skicka e-post igen',
            'email_opened'      => 'Citat :quote_number e-postmeddelande öppnat',
            'quote_to_invoice'  => ':quote_number har konverterats till en faktura - :invoice_number',
            'quote_tag_updated' => 'Citattagg :tags lades till på citat :quote_number',
            'quote_tag_deleted' => 'Citat Tag :quote_number togs bort :tags',
            'sms_sent'          => 'Citat :quote_number SMS skickat',
        ],
        'payment'          => [
            'prepayment_created'           => 'Förskottsbetalningen skapades',
            'payment_receipt_email_sent'   => 'E-postmeddelande om betalningskvitto skickat',
            'payment_receipt_resend_email' => 'Skicka e-post med betalningskvitto igen',
            'payment_updated'              => 'Betalningen ändrades',
            'deleted'                      => 'Betalningen raderades',
            'payment_receipt_pdf_download' => 'Betalningskvitto ladda ner PDF',
            'payment_note_deleted'         => 'Betalningsanmärkning raderad:',
            'payment_note_added'           => 'Betalningsanmärkning tillagd:',
            'payment_note_updated'         => 'Betalningsanmärkning uppdaterad fr.o.m',
            'payment_failed'               => 'Betalning misslyckades',
        ],
        'client'           => [
            'client_created'     => ':client_type skapades',
            'type_changed'       => ':previous_value blev en :current_value',
            'updated'            => 'Klienten uppdaterades',
            'deleted'            => 'Klienten raderades',
            'status_changed'     => 'Klient inställd på :current_value',
            'client_tag_updated' => 'Taggen :tags har lagts till',
            'client_tag_deleted' => 'Taggen :tags raderad',
            'merge'              => 'Klient-ID: :idTo - :nameTo slogs samman till klient-ID: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'Kostnad skapades',
            'updated' => 'Kostnaden ändrades',
            'deleted' => 'Kostnaden raderades',
            'billed'  => 'Kostnader fakturerades',
            'vendor'  => [
                'created' => 'Utgiftsleverantör skapades',
                'updated' => 'Kostnadsleverantör har ändrats',
                'deleted' => 'Expense Vendor har tagits bort',
            ],
        ],
        'note'             => [
            'created'          => 'Not skapades',
            'updated'          => 'Anteckningen ändrades',
            'deleted'          => 'Anteckningen raderades',
            'note_tag_updated' => 'Tagga :tags tillagd på anteckningen',
            'note_tag_deleted' => 'Tagg :tags raderad från anteckningen',
        ],
        'task'             => [
            'created'   => 'Uppgiften skapades',
            'updated'   => 'Uppgiften modifierades',
            'deleted'   => 'Uppgiften raderades',
            'completed' => 'Uppgiften slutfördes',
        ],
        'subscription'     => [
            'created'                       => 'Prenumerationen :invoice_number skapades',
            'updated'                       => 'Prenumerationen :invoice_number har ändrats',
            'deleted'                       => 'Prenumerationen :invoice_number togs bort',
            'recurring_invoice_tag_updated' => 'Prenumerationstagg :tags lades till på Prenumeration :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'Prenumerationstagg :recurringInvoice_number togs bort :tags',
        ],
        'attachment'       => [
            'created' => ':filename laddades upp som en bilaga',
            'deleted' => ':filename togs bort som en bilaga',
        ],
        'tag'              => [
            'created' => 'Taggen :tag lades till',
            'deleted' => 'Taggen :tag togs bort från',
        ],
    ],
    'reset'                                           => 'Återställa',
    'select_event'                                    => 'Välj händelsetyp',
    'select_country'                                  => 'Välj ett land',
    'type_captcha'                                    => 'Vänligen svara på frågan ovan',
    'refresh_captcha'                                 => 'Uppdatera frågan',
    'answer'                                          => 'Svar',
    'use_captcha_in_login'                            => 'Använd captcha i inloggningen',
    'allow_client_timeline'                           => 'Tidslinje',
    'client_timeline'                                 => 'Tidslinje',
    'no_invoice_tags'                                 => 'Det finns inga fakturamärken.',
    'total_notifications'                             => 'Du har :total-aviseringar',
    'no_notifications'                                => 'Inga nya meddelanden',
    'notifications'                                   => 'Meddelanden',
    'notification'                                    => [
        'task'  => [
            'created'           => 'En ny uppgift som tilldelats dig',
            'due_date_breached' => 'Uppgiften',
            'completed'         => ':user slutförd uppgift:',
        ],
        'quote' => [
            'approved'             => ':quote_number har godkänts',
            'quote_to_invoice'     => ':quote_number har konverterats till en faktura -',
            'rejected'             => ':quote_number har avvisats',
            'payment_successfully' => 'Offert :quote_number för klient :client_name har betalats. Faktura :invoice_number skapades och betalningen tillämpades',
        ],
    ],
    'search_tasks'                                    => 'Sökuppgifter',
    'reopen_task'                                     => 'Öppna uppgiften igen',
    'task_form'                                       => 'Lägg till uppgift',
    'view_task'                                       => 'Uppgiftsdetaljer',
    'client_deleted'                                  => 'Klienten raderas',
    'payment_canceled'                                => 'Din betalning har annullerats',
    'default_company_profile_set'                     => 'Vi har ställt in din standardföretagsprofil. Du kan uppdatera det när som helst från inställningarna för företagsprofilen.',
    'file_uploaded_successfully'                      => 'Filen har laddats upp',
    'attachment_notice'                               => 'Maximal filstorlek för bilagor som är mindre än eller lika med :size',
    'attachment_error'                                => 'Bilagans storlek får inte överstiga :size',
    'attachment_warning'                              => 'Bilagans storlek är :size. Att ladda upp många stora bilagor kan försämra din databasprestanda med tiden.',
    'generate_timeline_history'                       => 'Skapa tidslinjehistorik',
    'generating_timeline_wait'                        => 'Genererar tidslinje, vänta ...',
    'generating_timeline_confirm'                     => 'Tidslinjefunktionen lades till i FusionInvoice 2020. Detta genererar tidslinjeposter för alla aktiviteter som föregick det funktionstillägget. Fortsätta?',
    'generated_timeline_request_accepted'             => 'Generering av tidslinjehistorik är klar.',
    'transitions'                                     => 'Tidslinjehistoria',
    'pending'                                         => 'I väntan på',
    'client_transition'                               => 'Klienttidslinjer',
    'expense_transition'                              => 'Kostnadstidslinjer',
    'invoice_transition'                              => 'Fakturatidslinjer',
    'payment_invoice_transition'                      => 'Tidslinjer för betalningsfaktura',
    'payment_transition'                              => 'Betalningstidslinjer',
    'quote_transition'                                => 'Citat tidslinjer',
    'note_transition'                                 => 'Observera tidslinjer',
    'task_transition'                                 => 'Uppgiftens tidslinjer',
    'email_sent'                                      => 'E-post till faktura :invoice_number skickad',
    'credit_applied'                                  => 'Kredit tillämpas',
    'configuration'                                   => 'Konfiguration',
    'include_prepayments'                             => 'Inkludera förskottsbetalningar',
    'pre_payment'                                     => 'Förbetalningar',
    'pre_payments'                                    => 'Förbetalningar',
    'times'                                           => 'Tider',
    'include_prepayments_applied'                     => 'Inkludera tillämpade förskottsbetalningar',
    'confirm_full_payment_applied'                    => 'Betalningen tillämpades helt',
    'confirm_full_credit_memo_applied'                => 'Kreditnota tillämpades fullt ut',
    'all_tasks'                                       => 'Alla uppgifter',
    'my_tasks'                                        => 'Mina uppgifter',
    'assigned_from_others'                            => 'Tilldelad av andra',
    'full_payment_reversed'                           => 'full betalning omvänd.',
    'partial_payment_reversed'                        => 'omvänd delbetalning.',
    'invoice_delete_error'                            => 'Du kan tyvärr inte ta bort en faktura som har betalningar eller kreditmemoapplikationer. Du måste först ta bort ansökningarna om betalningar eller kreditnoter.',
    'mail-from-required'                              => 'Du måste ange en giltig e-post från e-post',
    'contact_updated'                                 => 'Kontakt uppdaterades',
    'contact_added'                                   => 'Kontakt har lagts till',
    'generate_passport_key_wait'                      => 'Generera din passnyckel, vänta ...',
    'generate_passport_key'                           => 'Skapa passnyckel',
    'default_greeting'                                => 'Hallå där!<br>',
    'hi'                                              => 'Hej,',
    'deduct_tax_from_expenses'                        => 'Dra av skatt från kostnader',
    'invalid_invoice_id'                              => 'Ogiltigt faktura-ID',
    'client_related_record_exist'                     => 'Tyvärr har klienten relaterade poster för:: moduler. Kunder med transaktionshistorik kan inte raderas.',
    'email_payment_receipt_notice'                    => 'Klienten har ingen e-postadress registrerad',
    'show_more'                                       => 'Visa mer ...',
    'show_less'                                       => 'Visa mindre ...',
    'invoice_already_paid'                            => 'Faktura är redan betald!',
    'system_default'                                  => 'Systemfel',
    'created_by'                                      => 'Skapad av',
    'created_at'                                      => 'Skapad vid',
    'task_created_by_and_created_at'                  => 'Uppgift skapad av :created_by på :created_at',
    'dashboard_widgets_date_options'                  => 'Systemets standardtid för faktura och offertöversikt',
    'dashboard-widget-from-date-required'             => 'Från datum krävs när anpassat datumintervall har valts i Systemets standardperiod för fakturasammanfattning',
    'dashboard-widget-to-date-required'               => 'Till datum krävs när anpassat datumintervall har valts i Systemets standardtid för faktura och offertöversikt',
    'invoice_currency'                                => 'Fakturavaluta',
    'currency_format'                                 => 'Valutaformat',
    'create_missing_folder_success'                   => 'Skapad saknad obligatorisk mapp har skapats',
    'create_missing_folder_failed'                    => 'Försök att skapa mapp (ar) misslyckades :path',
    'folder_is_not_writable'                          => 'Mappen är inte skrivbar :path',
    'update_item_as_lookup'                           => 'Uppdatera artikeluppslag',
    'number_of_tax_fields'                            => 'Antal skattefält',
    'tax_1_entry'                                     => '1 Inmatning',
    'tax_2_entries'                                   => '2 inlägg',
    'require_tags_on_client_notes'                    => 'Kräv taggar på klientanteckningar',
    'entered_amount_less_than_invoice_amount'         => 'Det angivna beloppet måste vara mindre än eller lika med fakturabeloppet',
    'send-to'                                         => 'Skicka till',
    'print'                                           => 'Skriva ut',
    'pdf_cleanup'                                     => 'PDF-rengöring',
    'pdf_cleanup_confirm'                             => 'Är du säker på att du vill städa upp gamla PDF-filer',
    'pdf_cleanup_success'                             => 'PDF-rensning slutförd',
    'deleting_pdf_wait'                               => 'Raderar gamla PDF-filer, vänta ...',
    'open_invoices'                                   => 'Öppna fakturor',
    'open_credits'                                    => 'Öppna poäng',
    'unapplied_payments'                              => 'Oanvända betalningar',
    'attach_invoice_pdf'                              => 'Bifoga faktura PDF',
    'upcoming_payment_notice'                         => 'Kommande betalningsmeddelande',
    'select_mapping'                                  => 'Välj Kartläggning',
    'select_named_export'                             => 'Välj Named Export',
    'save_mapping'                                    => 'Spara mappning',
    'add_mapping'                                     => 'Skapa ny kartläggning',
    'edit_mapping'                                    => 'Uppdatera kartläggning',
    'save_as_default_mapping'                         => 'Standard mappning',
    'save_as_default_export'                          => 'Standardexport',
    'export_item_lookups'                             => 'Exportera artikelsökningar',
    'import_file_selection'                           => 'Importera filval',
    'next'                                            => 'Nästa',
    'delete_import_mapping_warning'                   => 'Är du säker på att du vill ta bort den här kartläggningen?',
    'export'                                          => 'Exportera',
    'named_exports'                                   => 'Namngiven export',
    'save_named_export'                               => 'Spara namngiven export',
    'delete_named_export'                             => 'Ta bort namngiven export',
    'updated_at'                                      => 'Uppdaterad kl',
    'zip'                                             => 'Blixtlås',
    'fields_to_export'                                => 'Fält som ska exporteras',
    'import-file-type-error'                          => 'Importera filtyp måste vara CSV',
    'recurring_invoice_items'                         => 'Återkommande fakturaposter',
    'important_details'                               => 'Viktiga detaljer',
    'important_information'                           => 'Viktig information',
    'item_lookups_important_information'              => '<p>Om ett matchande objekt -uppslagsnamn hittas i befintliga data under CSV -importen misslyckas importbatchen och visar objektet som orsakade felet.</p>',
    'invoices_important_information'                  => '<p>Kundnamn (från CSV) letas upp i tabellen Klienter och löses till klient_id, om det finns ett matchande namn. Om ingen namnmatchning hittas skapar den en klientpost och använder ID för den nya klientposten</p><p>Fakturanummer,</p><p>Invoice_items letar upp fakturanumret (från CSV) i fakturatabellen och löser det till ID: t. Inga andra nyckelfältuppslag/valideringar görs</p>',
    'invoice_items_important_information'             => '<p>Importen invoice_items gör en sökning på fakturanumret (från CSV) i fakturatabellen och löser det till lämpligt faktura -ID. Klient -ID härrör också från matchande fakturainformation.</p>',
    'payments_important_information'                  => '<p>För att importera betalningar krävs ett giltigt matchande fakturanummer för att tillämpa betalningarna på. Om en matchande faktura inte hittas misslyckas hela batchimporten.</p><p>Lämpliga kunder-</p><p>En sökning utförs på betalningsmetodens namn (från CSV -filen till tabellen payment_methods) och löses till lämplig payment_method_id, om den hittas. om inte matchande namn hittas, skapas en ny betalningsmetodspost och det nya betalningssättet_id används.</p>',
    'run_daily_tasks'                                 => 'Kör dagliga uppgifter',
    'daily_task_ran'                                  => 'Dagliga uppgifter kördes framgångsrikt',
    'csv_row_number'                                  => 'CSV -radnummer :row',
    'max_item_lookup_records'                         => 'Max. Objektsökningsposter',
    'invoice_with_commission_delete_error'            => 'Tyvärr kan du inte ta bort en faktura som har provisionsposter med betald status. Du måste först radera betald provision på denna faktura.',
    'if_invoice_is_emailed_while_draft'               => 'Om fakturan skickas med e-post i utkaststatus',
    'custom_payment_receipt_body_not_exists'          => 'Den anpassade mallen för betalningskvitton hittades inte.',
    'invoice_email_body_type'                         => 'Invoice Email Body Type',
    'send_overdue_reminder'                           => 'Skicka försenad påminnelse',
    'reminder_sent_successfully'                      => 'Påminnelsen har skickats',
    'error_sending_reminder'                          => 'Det uppstod ett fel när påminnelsen skulle skickas, försök igen senare.',
    'expense_date'                                    => 'Kostnadsdatum',
    'group_by'                                        => 'Grupp av',
    'timeline_scope_all_user'                         => 'Tidslinjeomfattning - Alla användare',
    'copy_to_clipboard'                               => 'Kopiera till urklipp',
    'text_copied_clipboard'                           => 'Text kopierad till urklipp!',
    'import_example_csv'                              => 'Ett exempel på CSV-fil finns här',
    'import'                                          => 'Importera',
    'address2'                                        => 'Adress 2',
    'use_parent_email'                                => 'Använd förälders e-post',
    'max_import_records'                              => 'Maximal gräns för import av poster är :total_records',
    'demo_file_attachment_disabled'                   => 'Filbilagor är inaktiverade i demon',
    'drag_drop_file'                                  => 'Drag',
    'or'                                              => 'ELLER',
    'browse_file'                                     => 'Bläddra i filen',
    'system_setting_and_ui'                           => 'Systeminställningar',
    'localization_and_timezone'                       => 'Lokalisering',
    'security'                                        => 'säkerhet',
    'cleanup_and_backup'                              => 'Städa',
    'attach_quote_pdf'                                => 'Bifoga citat PDF',
    'attach_payment_receipt'                          => 'Bifoga betalningskvitto',
    'choose-file'                                     => 'Välj FIL',
    'important-note'                                  => 'Viktig notering',
    'collapse'                                        => 'Kollaps',
    'add_task'                                        => 'Lägg till uppgift',
    'recurring_invoice_commissions'                   => 'Återkommande fakturaprovisioner',
    'invoice_commissions'                             => 'Fakturaprovision',
    'percentage'                                      => 'Procentsats',
    'flat_amount'                                     => 'Fast belopp',
    'discount-amount'                                 => 'Rabatt',
    'discount-type'                                   => 'Rabatttyp',
    'saving'                                          => 'Sparande...',
    'preparing'                                       => 'Förbereder',
    'allow_line_item_discounts'                       => 'Tillåt radrabatter',
    'invalid_price_amount'                            => 'Ogiltigt prisbelopp! Måste vara större än 0.',
    'light-mode'                                      => 'Ljusläge',
    'dark-mode'                                       => 'Mörkt läge',
    'system_base_currency'                            => 'Systemets basvaluta',
    'is_recurring_task'                               => 'Är återkommande uppgift',
    'contact_names'                                   => 'Kontaktnamn',
    'all_client'                                      => 'Alla kunder',
    'invoice_grand_total'                             => 'Faktura Totalsumma',
    'recurring_invoice_grand_total'                   => 'Återkommande faktura totalsumma',
    'is_required'                                     => 'Krävs?',
    'add-new-client'                                  => 'Lägg till ny klient',
    'client_name_required'                            => 'Klientnamn krävs',
    'custom_item_text_validate'                       => 'Ange ett giltigt objekt :label i fältet :label.',
    'assigned_to_others'                              => 'Tilldelad till andra',
    'all_tasks_and_all_users'                         => 'Alla uppgifter/Alla användare',
    'statement'                                       => 'Påstående',
    'profile_code'                                    => 'Profilkod',
    'login-url'                                       => 'Inloggnings-URL',
    'url_copied_clipboard'                            => 'URL kopierad till urklipp!',
    'payment_receipt_email_sent'                      => 'E-post med betalningskvitto har skickats',
    'edit_payment_note_form'                          => 'Redigera betalningsanmärkning',
    'payment_invoices_text'                           => 'Tack! Din betalning av :amount har tillämpats på följande fakturor.',
    'payment_text'                                    => 'Tack för din betalning av :amount .',
    'date_filter_by'                                  => 'Datum Filtrera efter',
    'filter_by_invoice_date'                          => 'Fakturadatum',
    'filter_by_payment_date'                          => 'Betalningsdatum',
    'date-range-required'                             => 'Välj datumintervall',
    'save-and-complete'                               => 'Spara och slutföra',
    'completion-note'                                 => 'Anmärkning om slutförande',
    'complete-with-note'                              => 'Komplettera med anmärkning',
    'placeholder_type_note'                           => 'Skriv dina anteckningar...',
    'credit_memo_email_subject'                       => 'Kreditnota E-postämne',
    'default_credit_memo_email_body'                  => 'Standard kreditnota E-posttext',
    'show_invoices_from'                              => 'Visa fakturor från',
    'system_mail_from_address'                        => 'System Mail från adress',
    'user_who_created_invoice'                        => 'Användare som skapade faktura',
    'completed'                                       => 'Avslutad',
    'no_auth_to_view_task'                            => 'Den här uppgiften finns inte längre i din lista.',
    'credit-memo-and-prepayments'                     => 'Krediter och förskottsbetalningar',
    'all_selected'                                    => 'Alla valda',
    'select_columns'                                  => 'Välj Kolumner',
    'column_settings'                                 => 'Kolumninställningar',
    'minimum_one_column_check_is_required'            => 'Välj minst en kolumn',
    'date_of_entry'                                   => 'Datum för registrering',
    'amount_applied'                                  => 'Ansökt belopp',
    'date_applied'                                    => 'Datum tillämpat',
    'copy_to_recurring_invoice'                       => 'Kopiera till återkommande faktura',
    'top_bar_color'                                   => 'Färg på översta baren',
    'light_grey'                                      => 'Ljusgrå',
    'bg-primary'                                      => 'Blå',
    'bg-warning'                                      => 'Gul',
    'bg-info'                                         => 'Dragonfly blå',
    'bg-danger'                                       => 'Röd',
    'bg-success'                                      => 'Gräsgrön',
    'bg-indigo'                                       => 'Indigo',
    'bg-lightblue'                                    => 'Victoria blå',
    'bg-navy'                                         => 'Marinblå',
    'bg-purple'                                       => 'Lila',
    'bg-fuchsia'                                      => 'Fuchsia',
    'bg-pink'                                         => 'Rosa',
    'bg-maroon'                                       => 'Rödbrun',
    'bg-orange'                                       => 'Orange',
    'bg-lime'                                         => 'Limegrön',
    'bg-teal'                                         => 'Kricka',
    'bg-olive'                                        => 'Oliv',
    'fee_name'                                        => 'Avgiftsnamn',
    'fee_percentage'                                  => 'Avgiftsprocent',
    'fee_explanation'                                 => 'Avgiftsförklaring',
    'enable_online_payment_processing_fees'           => 'Aktivera avgifter för onlinebetalningshantering',
    'allow_online_payment_processing_fees'            => 'Tillåt avgifter för onlinebetalningshantering',
    'allow_online_pay_fees'                           => 'Tillåt onlinebetalningsavgifter',
    'convenience_charges'                             => 'Bekvämlighetsavgifter',
    'opp-fee-percentage-required'                     => 'Procentandel av avgifter för onlinebetalningar krävs',
    'opp-fee-percentage-gt-zero'                      => 'Procentandelen av avgifter för onlinebetalningshantering måste vara större än noll',
    'cron_error'                                      => 'misslyckades på :datetime',
    'cron_start'                                      => 'Daglig uppgiftslöpare startade på :datetime',
    'notification_clear_all'                          => 'Rensa alla aviseringar',
    'show'                                            => 'Visa',
    'report'                                          => 'Rapportera',
    'profit_loss'                                     => 'Vinst och förlust',
    'credit_and_pre_payments'                         => 'Krediter och förskottsbetalningar',
    'expenses_vendors'                                => 'Kostnader Säljare',
    'expenses_categories'                             => 'Utgiftskategorier',
    'create'                                          => 'Skapa',
    'import_map_clients'                              => 'Importera kartklienter',
    'payctr_users'                                    => 'PaymentCenter-användare',
    'ctrl_plus_click'                                 => 'Ctrl-klicka för att lägga till slutförandeanteckningar',
    'edit_note'                                       => 'Redigera anteckning',
    'save-and-unComplete'                             => 'Spara och ej slutföra',
    'sales_chart'                                     => 'Försäljningsdiagram',
    'accumulate_totals'                               => 'Ackumulera totaler',
    'do_not_accumulate_totals'                        => 'Ackumulera inte summor',
    'kpi_cards'                                       => 'KPI-kort',
    'no_data_to_display'                              => 'Ingen data att visa',
    'choose_period'                                   => 'Välj Period',
    'date_mailed'                                     => 'Datum postat',
    'date_emailed'                                    => 'Datum mejlad',
    'action'                                          => 'Handling',
    'mail'                                            => 'Post',
    'mark_as_mailed'                                  => 'Markera som postad',
    'invoice_mailed'                                  => 'Fakturan har markerats som postad',
    'emailed'                                         => 'E-mailade',
    'paid_invoice_canceled_error'                     => 'För att annullera denna faktura, Vänligen radera betalningar från fakturan.',
    'allow_invoice_delete'                            => 'Tillåt radering av faktura',
    'allow_child_accounts'                            => 'Tillåt barnkonton',
    'third_party_bill_payer'                          => 'Tredje parts räkningsbetalare',
    'invoices_paid_by'                                => 'Fakturor betalda av',
    'use_third_party_bill_payer_email'                => 'Använd e-post för tredje parts räkningsbetalare',
    'email_default'                                   => 'Email Standard',
    'client_default'                                  => 'Klient Standard',
    'clear-all'                                       => 'Rensa alla',
    'system_log_is_missing_or_empty'                  => 'Systemloggen saknas eller är tom',
    'change_to_draft'                                 => 'Ändra till Utkast',
    'invoice_status_change_to_draft'                  => 'Fakturastatus ändras till utkast',
    'there_is_some_error'                             => 'Det finns några fel',
    'filter_by_date'                                  => 'Filtrera efter datum',
    'quote_grand_total'                               => 'Citat Grand Total',
    'email_upcoming_payment_due_notice'               => 'E-posta kommande betalningsmeddelande',
    'email_overdue_invoice_reminder'                  => 'E-post påminnelse om försenad faktura',
    'page_totals'                                     => 'Sidsummor',
    'categories'                                      => 'Kategorier',
    'conven_charges'                                  => 'Konv. Kostnader',
    'invoice_status_change_to_cancel'                 => 'Fakturastatus Ändra till Avbryt',
    'filter_by_invoice_number'                        => 'Fakturanummer',
    'filter_by_client_name'                           => 'Kundnamn',
    'custom_mail_template'                            => 'Anpassad e-postmall',
    'invoice_use_custom_mail_template'                => 'Faktura Använd anpassad e-postmall',
    'client_or_company_name'                          => 'Kundens/företagets namn',
    'view_invoice'                                    => 'Visa faktura',
    'tt_active'                                       => 'När en klientpost inte är aktiv visas den inte i standardklientlistan och normala transaktioner kommer inte att tillåtas.',
    'tt_invoice_prefix'                               => 'En unik fakturaprefixkod tilldelas automatiskt en kundpost när den skapas. Det kan ändras manuellt senare. Den kan användas som en del av ditt dokumentnumreringsschema för fakturanumrering, vilket möjliggör ett unikt fakturanummer per kund.',
    'tt_automatic_email_payment_receipts'             => 'Skickar ett e-postat betalningskvitto till kunden när han tar en betalning. En global inställning är tillgänglig i Systeminställningar, men kan åsidosättas på individuell klientbasis.',
    'tt_automatic_email_on_recur'                     => 'Skickar en mejlad faktura till kunden när en återkommande faktura körs och skapar en levande faktura. En global inställning är tillgänglig i Systeminställningar, men kan åsidosättas på individuell klientbasis.',
    'tt_default_currency'                             => 'Valutan som tilldelas detta kundkonto, som kommer att användas för deras faktura-, offert- och betalningstransaktioner. Detta värde är standard från systeminställningen för basvaluta.',
    'tt_language'                                     => 'Språket som kommer att visas för klienten när de loggar in på klientcentret.',
    'tt_allow_client_center_login'                    => 'Ska kunden få logga in på ditt FusionInvoice-klientcenter? Deras e-postadress måste användas för deras användarnamn och du måste tilldela ett lösenord. Webbadressen till klientcentret är',
    'tt_timezone'                                     => 'Tidszon för klienten. Om den skrivs in, kommer klientens lokala tid att visas överst i klientens sidvy.',
    'tt_allow_online_payment_processing_fees'         => 'Bearbetningsavgifter för onlinebetalningar kan beräknas för kunder som betalar med kreditkort, med hjälp av deras offentliga fakturalänk (ingår i e-postfakturan). Det här alternativet har en global systeminställning, men kan också åsidosättas på individuell klientbasis.',
    'tt_allow_child_accounts'                         => 'Om du ställer in Tillåt barnkonton till Ja gör det möjligt för den här klienten att agera som ett föräldrakonto och låter dig välja det från listan för överordnade konton.',
    'tt_third_party_bill_payer'                       => 'En tredje parts räkningsbetalare är en organisation som betalar räkningar för sina kunder, till exempel en extern revisionsbyrå.',
    'tt_parent_account'                               => 'Moderföretaget som denna kund är närstående till eller ett dotterbolag till. Den här listan innehåller de klientposter som har inställningen Tillåt barnkonton inställd på Ja. Lämna tomt om kunden inte har något föräldrakonto.',
    'tt_invoices_paid_by'                             => 'Tredjepartsföretaget som denna klient använder för att betala sina fakturor. Den här listan innehåller klientposter som har inställningen 3rd Party Bill Payer inställd på Ja. Lämna tomt om kunden betalar sina egna fakturor.',
    'tt_email_default'                                => 'När du skickar e-postmeddelanden till den här klienten, välj den e-post som ska användas. Om den här klienten har ett kopplat överordnat konto eller fakturor som betalas med konto, kan något av dessa alternativ väljas. Standard är klientens standard-e-post.',
    'tt_default_to'                                   => 'När du skickar e-post, ska den här kontakten automatiskt läggas till i mottagarlistan \'To:\'?',
    'tt_default_cc'                                   => 'Ska den här kontakten automatiskt läggas till i mottagarlistan \'CC:\' när du skickar e-postmeddelanden?',
    'tt_default_bcc'                                  => 'När du skickar e-post, ska den här kontakten automatiskt läggas till i',
    'tt_client_type'                                  => 'En Lead är en okvalificerad säljkandidat. En prospekt är en kvalificerad kandidat som snart kan bli kund. En kund är ett företag eller en individ med vilken du har sålt (eller snart kommer att sälja) varor eller tjänster till. En affiliate är ett företag eller en individ som säljer dina varor eller tjänster vidare. Övrigt används för affärer som inte passar de andra typerna, t.ex. Tredjepartsräkningsbetalare eller föräldrakonton som du inte gör affärer med direkt.',
    'tt_client_tags'                                  => 'Taggar kan tilldelas en kund för att hjälpa till att kategorisera eller filtrera din kundlista för visning eller rapportering.',
    'tt_important_note'                               => 'En anteckning som skrivs in här kommer automatiskt att dyka upp i ett VIKTIGT! fönster när klientposten visas.',
    'tt_gen_header_title_text'                        => 'Texten som visas i det övre vänstra hörnet, bredvid din logotyp, vanligtvis ditt företagsnamn.',
    'tt_gen_default_company_profile'                  => 'Den företagsprofil som ska användas som standard när du skapar nya fakturor, offerter etc. Företagsprofiler gör att du kan presentera din verksamhet på olika sätt med varje profil, vilket tillåter olika företagsnamn, logotyper, fakturaformat etc.',
    'tt_gen_address_format'                           => 'Låter dig bygga adressformatet som visas på fakturor och offerter genom att använda det enda adressfältet eller en kombination av de individuella adressfälten, såsom stad, stat, land, etc.',
    'tt_gen_custom_fields_columns'                    => 'Anpassade fält kan visas från 1 till 3 fält per rad.',
    'tt_gen_require_tags_on_client_notes'             => 'Om den är inställd på Ja, kommer det att kräva att en tagg väljs eller anges när en kundanteckning läggs till, till exempel \'Support\' eller \'Försäljning\'. Detta är användbart för att kategorisera och söka efter anteckningar.',
    'tt_gen_skin'                                     => 'Hur skulle du vilja att ditt FI UI visas, ljust eller mörkt läge',
    'tt_gen_top_bar_color'                            => 'Färgen på den övre titelraden. Om du arbetar med flera olika FusionInvoice-installationer kan detta vara en hjälpsam visuell identifiering.',
    'tt_gen_results_per_page'                         => 'Antalet poster som visas per sida för alla listvyer, såsom kunder, fakturor, offerter, utgifter etc.',
    'tt_gen_allow_line_item_discounts'                => 'Aktiverar eller inaktiverar radrabattfunktionen i fakturor och offerter.',
    'tt_gen_language'                                 => 'Språket som ska användas för din FusionInvoice-installation. Observera att du kan tilldela ett annat språk för dina kunder, så att de kan interagera med FusionInvoice Client Center på sitt modersmål.',
    'tt_gen_date_format'                              => 'Ditt föredragna datumformat',
    'tt_gen_use_24_hour_time_format'                  => 'Tillåter stöd för 24 eller 12 timmars tidsformat.',
    'tt_gen_timezone'                                 => 'Ditt företags primära tidszon.',
    'tt_gen_base_currency'                            => 'Den valuta som ditt företag använder oftast.',
    'tt_gen_exchange_rate_mode'                       => 'Manuell låter dig ange växelkursvärdet när du skapar fakturor. Automatisk kommer att försöka använda ett offentligt API för att hämta valutakursen. Detta används endast när du gör en transaktion med en annan valuta än din basvaluta.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice stöder upp till 2 skattefält per rad. Värdet som valts med visa eller dölj det andra skattefältet.',
    'tt_gen_quantity_price_decimals'                  => 'Antalet decimaler som ska visas för kvantitets- och mängdvärden. Välj 0 till 4 baserat på din önskade noggrannhetsnivå.',
    'tt_gen_round_tax_decimals'                       => 'Välj önskat antal decimaler för beräkningar av skatteavrundning.',
    'tt_gen_use_captcha_in_login'                     => 'Om den är inställd på Ja, kräver det att dina användare svarar på en CAPTCHA-utmaningsfråga under inloggningen.',
    'tt_gen_force_https'                              => 'Vi rekommenderar sällan att du aktiverar det här alternativet. Om din installation inte har ett korrekt fungerande SSL-certifikat installerat på din webbserver, för din FusionInvoice-installation, kan du få problem. Du kan uppnå samma resultat genom att ställa in en serveromdirigeringsregel.',
    'dashboard_settings'                              => 'Inställningar för instrumentpanelen',
    'tt_dashboard_settings'                           => 'Din instrumentpanel används för att visa viktiga affärsmått och händelser, vilket ger dig värdefull insikt om ditt företags resultat. Systeminstrumentpanelen är standard för alla användare, men inom varje användares konfiguration kan du åsidosätta systemets standardinstrumentpanel och definiera specifika inställningar för varje användare. Inställningarna nedan låter dig anpassa din instrumentpanel.',
    'tt_db_default_time_period'                       => 'Ställer in standardstart- och slutdatum för instrumentpanelswidgetar som använder dem, såsom KPI-kort och försäljningsdiagrammet.',
    'tt_db_recent_client_activity'                    => 'En widget som visar klientinteraktioner, såsom gjorda betalningar och visade fakturor eller offerter, från din offentliga faktura eller offertlänkar.',
    'tt_db_display_order'                             => 'Detta ändrar visningsordningen för instrumentpanelswidgets. 1 visas överst, 2 visas efter 1 osv.',
    'tt_db_column_width'                              => 'Dashboard-widgets använder Bootstrap-rutnätssystemet och har en maximal kolumnbredd på 12. Om du ställer in kolumnbredden till 12 kommer widgeten att använda hela den tillgängliga bredden. Om du ställer in den på 6 kommer två widgetar att dela samma rad, 4 tillåter 3 widgets att dela samma rad, etc.',
    'tt_db_accumulate_totals'                         => 'Om du ställer in detta värde på kommer ditt diagram att inkludera föregående dagars totalsummor för varje dag. Till exempel var försäljningen för dag 1 100 USD, dag 2 var 50 USD, dag 3 var 125 USD. Grafen skulle visa en stigande linje med detta alternativ inställt på Ja. Ställ in på Nej, skulle visa en nedgång i försäljningsraden dag 2 och öka till dag 3.',
    'tt_db_kpi_cards'                                 => 'Dessa färgkodade kort visar nyckelprestandaindikatorer överst på din instrumentpanel.',
    'tt_db_sales_chart'                               => 'Ett linjediagram som visar totala fakturor och betalningar.',
    'tt_db_task_list'                                 => 'Med den här widgeten kan du arbeta med modulen Task List, direkt från din instrumentpanel.',
    'tt_db_task_list_include_time'                    => 'Genom att aktivera det här alternativet kan du ange datum och tid för förfallodatum när du arbetar med uppgifter. När inställt på Nej används endast datumvärdet.',
    'tt_db_timeline'                                  => 'Tidslinjewidgeten visar en kronologisk och sökbar lista över viktiga systemhändelser, såsom ändringar av klientstatus, e-postade fakturor, gjorda betalningar, anteckningar etc.',
    'tt_ss_invoices_default_invoice_template'         => 'Välj den mall som ska användas som standard när du skapar nya fakturor. Anpassade mallar bör placeras i .\\custom\\templates\\invoice_templates\\ och måste namnges med tillägget .blade.php.',
    'tt_ss_invoices_default_doc_scheme'               => 'Välj vilket dokumentnummerschema som ska användas, som standard, när du skapar nya fakturor. Dokumentnummerscheman kan skapas inom Konfigurationsinställningar och låter dig anpassa dina dokumentnummer (fakturor, offerter, kreditnotor).',
    'tt_ss_invoices_invoice_due_days'                 => 'Det förinställda antalet dagar, efter fakturans (skapande) datum, som fakturan kommer att förfalla och förväntas bli betald.',
    'tt_ss_invoices_automatic_email_ri'               => 'När en återkommande faktura körs och genererar en aktiv faktura, ska den aktuella fakturan automatiskt skickas till kunden via e-post?',
    'tt_ss_invoices_qr_code'                          => 'Ska en QR-kod automatiskt placeras på standardfakturor och offerter. Om du använder anpassade faktura- eller offertmallar, se standardmallarna för att lägga till QR-koden i dina anpassade mallar.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Om en faktura har status som Utkast och e-postas, antingen manuellt eller automatiskt, vad ska hända med fakturadatumet. Viktigt: När en faktura skickas via e-post ändras statusen automatiskt från Utkast till Skickat.',
    'tt_ss_invoices_recalculate'                      => 'Kör varje transaktion som görs för varje faktura, från det datum den skapades till det aktuella datumet, och räknar om totalsummor, radsummor, skatter, rabatter och fakturasummor. Detta kan ta lång tid att köra om du har en stor datamängd.',
    'tt_ss_invoices_due_after'                        => 'Fakturans förfallodatum kommer att vara fakturadatumet plus det antal dagar som anges här.',
    'tt_ss_invoices_default_status_filter'            => 'Statusfiltret som ska tillämpas som standard när fakturalistan visas.',
    'tt_ss_invoices_default_terms'                    => 'Termens textvärde som visas, på standardfakturamallen, längst ned på fakturan, inom området Villkor.',
    'tt_ss_invoices_default_footer'                   => 'Sidfotstextvärde som visas, på standardfakturamallen, längst ner på fakturan. Till exempel:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'När den dagliga uppgiften (CRON-jobbet) kör och genererar en levande faktura från en återkommande fakturamall, ska den nyskapade fakturan automatiskt skickas till kunden via e-post? Detta kan åsidosättas på kund för kund basis.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'När en betalning tas, ska den betalningsinformationen automatiskt skickas till kunden via e-post?',
    'tt_ss_invoices_online_payment_method'            => 'Betalningsmetoden som tilldelas när en kund betalar med en offentlig fakturalänk. Betalningsmetoder kan upprätthållas genom systeminställningar.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Ska en QR-kod, som leder till fakturans eller offertens offentliga URL, visas på dokumentet?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Bör användare, även administratörsanvändare, tillåtas att radera fakturor? Ett säkrare och mer spårbart alternativ till att ta bort fakturor är att ändra fakturastatus till \'Avbruten\', vilket ändrar fakturasumman till noll och exkluderar den från de flesta listor och rapporter.',
    'tt_ss_invoices_show_invoices_from'               => 'När fakturor skickas via e-post kommer detta att visas som postad från-adress. Viktig anmärkning: Värdet Svara till kommer alltid att vara det värde som tilldelas i Systeminställningar -',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Från fakturavyn, om fakturan är i utkaststatus och skickas via e-post, ska fakturadatumet förbli oförändrat eller ändras till det aktuella datumet? Om fakturadatum ändras uppdateras även förfallodatumet.',
    'tt_ss_quotes_default_quote_template'             => 'Välj mallen som ska användas som standard när du skapar en ny offert. Anpassade mallar bör placeras i .\\custom\\templates\\quote_templates\\ och måste namnges med tillägget .blade.php.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Välj det dokumentnummerschema som ska användas som standard när du skapar nya offerter. Dokumentnummerscheman kan skapas inom Konfigurationsinställningar och låter dig anpassa dina dokumentnummer (fakturor, offerter, kreditnotor).',
    'tt_ss_quotes_expire_days'                        => 'Det förinställda antalet dagar, efter datumet för offerten (skapandet), som offerten kommer att löpa ut. När en offert har passerat sitt utgångsdatum är det underförstått att prissättningen kan ändras på grund av marknadsfluktuationer etc.',
    'tt_ss_quotes_default_status_filter'              => 'Statusfiltret som ska tillämpas som standard när fakturalistan visas.',
    'tt_ss_quotes_auto_convert'                       => 'När en offert godkänns, skulle detta leda till att en faktura automatiskt skapas från offerten.',
    'tt_ss_quotes_when_converted_action'              => 'När en offert konverteras till en faktura, ska betalningsvillkoren användas från offerten eller från standardinställningen för fakturavillkor?',
    'tt_ss_quotes_default_terms'                      => 'Termens textvärde som visas, på standard offertmallen, längst ner i offerten, inom området Villkor.',
    'tt_ss_quotes_default_footer'                     => 'Sidfotstextvärde som visas, på standard offertmallen, längst ner i offerten. Till exempel:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Om en offert har statusen Utkast och skickas via e-post, antingen manuellt eller automatiskt, vad ska hända med offertdatumet. Viktig notering: När en offert skickas via e-post kommer statusen automatiskt att ändras från Utkast till Skickat.',
    'tt_ss_quotes_recalculate'                        => 'Kör varje transaktion som görs för varje offert, från det datum den skapades till det aktuella datumet, och räknar om totalsummor, radsummor, skatter, rabatter och offertsummor. Detta kan ta lång tid att köra om du har en stor datamängd.',
    'tt_ss_taxes_default_rate1'                       => 'Den primära skattesatsen som ska tillämpas automatiskt på nya rader som läggs till på fakturor eller offerter. Skattesatser upprätthålls genom konfiguration -',
    'tt_ss_taxes_default_rate2'                       => 'Den sekundära skattesatsen som automatiskt ska tillämpas på nya rader som läggs till på fakturor eller offerter. Skattesatser upprätthålls genom konfiguration -',
    'tt_ss_email_send_method'                         => 'E-postsändningsmetoden som FusionInvoice ska använda. Genom att ändra sändningsmetoden ändras också visningen av de stödjande fälten för sändningsmetoden.',
    'tt_ss_email_allow_self_cert'                     => 'Om du aktiverar det här alternativet stängs PHP verify_peer-kravet av. För mer information sök på internet efter: PHP e-post självsignerat certifikat openssl.cafile',
    'tt_ss_email_reply_to'                            => 'När du skickar e-postmeddelanden är detta standardsvarsadressen som dina mottagare kommer att se.',
    'tt_ss_email_always_cc'                           => 'En e-postadress som du som standard automatiskt vill skicka med varje e-postmeddelande.',
    'tt_ss_email_always_bcc'                          => 'En e-postadress som du som standard vill automatiskt BCC med varje e-postmeddelande som skickas.',
    'tt_ss_email_send_test_to'                        => 'E-postadressen som ska användas när du klickar på knappen Skicka test-e-post.',
    'tt_ss_email_mail_from_addr'                      => 'Standard Mail From-adress som ska användas när e-postmeddelanden skickas från FusionInvoice. Obs: inom Systeminställningar -',
    'tt_ss_email_mail_from_name'                      => 'Mail From vänligt namn som ska visas på skickade e-postmeddelanden.',
    'tt_ss_email_email_templates'                     => 'E-postmallar finns tillgängliga för många dokument och evenemang, dessa inkluderar: offerter, offertgodkännanden, offertavslag, fakturor, fakturor som blir försenade, kreditnotor, betalningskvitton, kommande betalningsanmärkningar. En standardmall ingår, men du kan också skapa anpassade mallar, som kan vara enkla (som de medföljande standardmallarna) eller fullt formaterad HTML.',
    'tt_ss_pdf_driver'                                => 'Drivrutinen som ska användas när du skapar PDF-dokument. Att välja \'wkhtmltopdf\'-drivrutinen kräver en lokal serverinstallation av detta program och inställning av lämplig binär sökväg för det.',
    'tt_ss_pdf_binary_path'                           => 'Den lokala serversökvägen till den binära filen för wkhtmltopdf. Till exempel C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice stöder flera onlinebetalningsleverantörer. Aktivera de leverantörer som du har etablerat konton hos. De leverantörer som är aktiverade här kommer att visas som betalningsalternativ när dina kunder ser sina fakturor med den offentliga fakturalänken (ingår i standardfaktura-e-postmeddelandet).',
    'tt_ss_olp_api_key'                               => 'API-nyckeln tillhandahålls av din betalningsleverantör.',
    'tt_ss_olp_payment_button_text'                   => 'Texten som visas på betalningsmetodknappen för den här betalningsleverantören, högst upp på din offentliga faktura, så som den ses av dina kunder.',
    'tt_ss_olp_mode'                                  => 'Stöds av vissa betalningsleverantörer, vilket möjliggör Sandbox mer (testning) och live.',
    'tt_ss_olp_client_id'                             => 'Kund-ID:t tillhandahålls av denna betalningsleverantör.',
    'tt_ss_olp_client_secret'                         => 'Klienthemligheten tillhandahålls av denna betalningsleverantör.',
    'tt_ss_olp_publishable_key'                       => 'Den publicerbara nyckeln tillhandahålls av denna betalningsleverantör.',
    'tt_ss_olp_secret_key'                            => 'Den hemliga nyckeln tillhandahålls av denna betalningsleverantör.',
    'tt_ss_olp_opp_fees_about'                        => 'Bearbetningsavgifter för onlinebetalningar kan beräknas för kunder som betalar med kreditkort, med hjälp av deras offentliga fakturalänk (ingår i e-postfakturan).',
    'tt_ss_olp_enable_opp_fees'                       => 'Bearbetningsavgifter för onlinebetalningar kan beräknas för kunder som betalar med kreditkort, med hjälp av deras offentliga fakturalänk (ingår i e-postfakturan). Det här alternativet har en global systeminställning, men kan också åsidosättas på individuell klientbasis.',
    'tt_ss_olp_opp_fee_pct'                           => 'Procentandelen av fakturasumman som ska debiteras som betalningshanteringsavgift (bekvämlighet).',
    'tt_ss_olp_opp_fee_name'                          => 'Avgiftsnamnet som ska visas på fakturan. Dvs.',
    'tt_ss_olp_opp_fee_explanation'                   => 'En förklaring av avgiften som ska visas på fakturan. Dvs.',
    'tt_company_profiles_about'                       => 'Företagsprofiler låter dig presentera ditt företag på olika sätt med varje profil, vilket tillåter olika företagsnamn, logotyper, fakturaformat, etc. Det ger ett sätt att ha flera virtuella företag inom samma FusionInvoice-installation. En standardföretagsprofil måste väljas i Systeminställningar.',
    'tt_users_about'                                  => 'Du kan skapa användare av typen Admin (full åtkomst) eller Standard (individuella systembehörigheter måste beviljas). Om du ställer in \'Tillåt inloggning till klientcenter\' till Ja för en klientpost kommer automatiskt att lägga till en användarpost för klienten, men klientanvändare kan bara läggas till med gränssnittet för klientinställningar.',
    'tt_users_client_about'                           => 'Kundanvändare kan endast logga in på kundcenter, vilket ger dem en begränsad överblick över sina fakturor, offerter och betalningar. Om du ställer in \'Tillåt kundcenterinloggning\' till Ja för en kundpost, ger dem åtkomst till kundcentret.',
    'tt_user_types_about'                             => 'Adminanvändare har full systemåtkomst. Standardanvändare kan beviljas de individuella behörigheter som de behöver. Klientanvändare har bara tillgång till sin specifika information i kundcentret och deras förmåga att logga in ställs in i klientinställningar -',
    'tt_custom_fields_about'                          => 'Med anpassade fält kan du lägga till dina egna datafält i de flesta moduler. Om du behövde fånga branschen för kunder, lägg helt enkelt till ett anpassat fält märkt \'Industri\' på klientsidan, vilket gör det till en rullgardinstyp. Anpassade fält visas automatiskt under de normala fälten.',
    'tt_recurring_invoices_about'                     => 'Återkommande fakturor är egentligen inte fakturor, utan snarare mallar för att skapa framtida fakturor. De har en återkommande frekvens och nästa datum som avgör när de kommer att generera en aktiv faktura. Ett dagligt CRON-jobb eller en schemalagd uppgift krävs för att återkommande fakturor ska fungera korrekt.',
    'tt_addons_about'                                 => 'Tillägg är anpassningar till FusionInvoice för ett unikt affärsbehov, såsom tidsspårning, prissättning eller syliserade fakturamallar. De erbjuds via FusionInvoice tilläggsmarknadsplats.',
    'client_center_user'                              => 'Kundcenteranvändare',
    'user_type'                                       => 'Användartyp',
    'custom_field'                                    => 'Anpassat fält',
    'placeholder_type_email_template'                 => 'Skriv eller klistra in din e-postmall. . .',
    'email_templates'                                 => 'E-postmallar',
    'payment_receipts'                                => 'Betalningskvitton',
    'upcoming_payment_notices'                        => 'Kommande betalningsmeddelanden',
    'convenience_fee_for_credit_card_transactions'    => 'Bekvämlighetsavgift för kreditkortstransaktioner',
    'credit_card_processing_fee'                      => 'Behandlingsavgift för kreditkort',
    'delete_client_user_warning'                      => '<p>Om du tar bort en klientanvändare inaktiveras deras förmåga att logga in på klientcentret.</p>',
    'use_default_mail_template'                       => 'Standard e-postmall',
    'use_custom_mail_template'                        => 'Anpassad e-postmall',
    'quote_email_body'                                => 'Citat Email Body',
    'overdue_invoice_email_body'                      => 'E-posttext för försenad faktura',
    'credit_memo_email_body'                          => 'Kreditnota E-posttext',
    'payment_receipt_body'                            => 'Betalningskvittokropp',
    'invoice_email_body'                              => 'E-posttext för faktura',
    'quote_custom_email_body_require'                 => 'Vänligen ange din anpassade e-postmall för offert-e-posttext',
    'quote_custom_approve_email_body_require'         => 'Vänligen ange din anpassade e-postmall för offertgodkännande e-posttext',
    'quote_reject_email_body_require'                 => 'Ange din anpassade e-postmall för offertavvisande e-posttext',
    'overdue_invoice_email_body_require'              => 'Vänligen ange din anpassade e-postmall för försenad faktura e-posttext',
    'invoice_email_body_require'                      => 'Ange din anpassade e-postmall för e-postfaktura',
    'credit_memo_email_body_require'                  => 'Ange din anpassade e-postmall för e-postmeddelandet med kreditnotan',
    'payment_receipt_email_body_require'              => 'Ange din anpassade e-postmall för e-postmeddelandet med betalningskvitto',
    'upcoming_payment_notice_email_body_require'      => 'Ange din anpassade e-postmall för kommande e-postmeddelande om betalningsmeddelande',
    'copy_text'                                       => 'Kopiera text',
    'tt_preview_template'                             => 'Förhandsgranska mall',
    'tt_view_template_code'                           => 'Visa mallkod',
    'dashboard_date_range'                            => 'Dashboard Datumintervall',
    'tt_dashboard_date_range'                         => 'Dashboard Datumintervall filtrerar vyn för följande widgets: KPI-kort, Försäljningsdiagram, Senaste kundaktivitet.',
    'product_copy'                                    => 'Produktkopia',
    'open_selected_client'                            => 'Öppna vald klient',
    'save_this_client'                                => 'Spara den här klienten (inte en dubblett)',
    'looks_like_duplicate'                            => 'Hmm... Det här ser ut som en dubblett',
    'duplicate_instructions'                          => 'Om du ser den klient du ville ha i listan, välj och öppna den. Om inte, spara den nya klienten.',
    'select_checkbox'                                 => 'Välj en klient',
    'select_lead_source_tag'                          => 'Välj Client Lead Source',
    'lead_source'                                     => 'Blykälla',
    'tt_client_lead_source_tags'                      => 'Välj eller ange potentiell kundkälla (hur kunden förvärvades)',
    'your_link_is_expired'                            => 'hoppsan! Din länk har upphört att gälla.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Återgå till instrumentpanelen</a>.',
    'secure_link_and_expire_link_days'                => 'Säkra och förfalla offentliga fakturalänkar',
    'secure_link_expire_days'                         => 'Antal dagar',
    'tt_secure_link_and_expire_link_days'             => 'När du aktiverar säkra länkar måste du också ställa in antalet dagar efter vilka fakturalänken ska upphöra att gälla. Genom att göra detta kan en kund se sin offentliga fakturalänk tills den löper ut.',
    'expire_time_period'                              => 'Fältet Länk förfaller Antal dagar är obligatoriskt',
    'enter_days'                                      => 'Ange dagar',
    'invalid_field_name'                              => 'Ange ett giltigt fältnamn',
    'lead_source_notes'                               => 'Anteckningar om blykälla',
    'important_note'                                  => 'Viktig notering',
    'social_media_url'                                => 'Sociala medier URL',
    'general_notes'                                   => 'Allmänna anmärkningar',
    'payment_amount_mismatch'                         => 'Betalningsbelopp Missmatch',
    'open_invoice_aging'                              => 'Öppna fakturaåldring',
    'tt_db_open_invoice_aging'                        => 'Öppna fakturaåldring',
    'current'                                         => 'Nuvarande',
    'oneToThirty'                                     => '1-30 dagar',
    'thirtyOneToSixty'                                => '31-60 dagar',
    'sixtyOneToNinety'                                => '61-90 dagar',
    'ninetyOnePlus'                                   => '91 dagar',
    'sent_and_draft'                                  => 'Inkludera både skickade och utkast till fakturor',
    'sent_only'                                       => 'Inkludera endast skickade fakturor',
    'tt_open_ar_aging_settings'                       => 'Inställningar för Åldringssummor för öppen faktura',
    'tt_client_field_settings'                        => 'Välj de fält som du vill ska visas i din klientvy',
    'position_change'                                 => 'Position ändrad',
    'dynamic_width'                                   => 'Dynamisk bredd',
    'full_width'                                      => 'Full bredd',
    'save_configuration_default'                      => 'Spara konfigurationen som systemstandard',
    'assign_configuration_other'                      => 'Tilldela konfiguration till andra användare',
    'tt_user_tags'                                    => 'Användartaggar',
    'select_users'                                    => 'Välj Användare',
    'configuration_assigned'                          => 'Konfigurationen har tilldelats',
    'default_configuration_set'                       => 'Standardkonfigurationen har ställts in',
    'current_user_id'                                 => 'Aktuellt användar-id',
    'tt_users_settings'                               => 'Användarinställningar',
    'invoice_link_expire'                             => 'Din offentliga fakturalänk upphör att gälla om',
    'quote_link_expire'                               => 'Din offentliga offertlänk upphör att gälla om',
    'dashboard_width'                                 => 'Dashboard :widthName kolumnbreddsinställning ändrad',
    'unmark_mailed'                                   => 'Avmarkera som postat',
    'invoice_unmark_mailed'                           => 'Faktura avmarkering som postad',
    'print_mark_mailed'                               => 'Skriva ut',
    'public_link'                                     => 'Offentlig länk',
    'tt_sales_chart_settings'                         => 'Inställning för försäljningsdiagram faktura/total',
    'verify_key'                                      => 'Produktnyckelverifiering',
    'enter_key'                                       => 'Skriv din kod',
    'verify'                                          => 'Verifiera det!',
    'key_required'                                    => 'Produktnyckel krävs',
    'key_length_invalid'                              => 'Vänligen ange produktnyckeln på 32 tecken som angavs vid köptillfället.',
    'invalid_key'                                     => 'Tyvärr, din nyckel är ogiltig. Installationen kan inte fortsätta.',
    'key_verified'                                    => 'Grattis, din nyckel har verifierats.',
    'clear_cache'                                     => 'Rensa cache',
    'clear_cache_confirm'                             => 'Är du säker på att du vill rensa programmets cache?',
    'cache_clear_success'                             => 'Cacheminnet har rensats.',
    'cache_clear_error'                               => 'Kontrollera din serverkonfiguration för PHP exec()-kommandot.',
    'add_new_client'                                  => 'Lägg till ny klient',
    'add'                                             => 'Lägg till',
    'invalid_quantity_amount'                         => 'Ogiltigt kvantitetsbelopp! Måste vara större än 0.',
    'api_version'                                     => 'API-version',
    '2021_prior'                                      => '2021 och tidigare',
    '2022_later'                                      => '2022 och senare',
    'vendors'                                         => 'Försäljare',
    'file_not_found'                                  => ':file_name hittades inte',
    'leave_empty_no_parent_account'                   => 'lämna tomt om klienten inte har något föräldrakonto',
    'leave_empty_client_pays_invoices'                => 'lämna tomt om kunden betalar sina egna fakturor',
    'modal_not_found'                                 => 'Modal hittades inte',
    'payment_delete_success'                          => 'Betalningen har raderats',
    'payment_delete_error'                            => 'Det gick inte att ta bort betalningen. Försök igen senare.',
    'status_change_error'                             => 'Något gick fel! Status ändrades inte.',
    'total_payments'                                  => 'Totala betalningar',
    'licence_verification_error'                      => 'Det gick inte att verifiera din licensnyckel.',
    'line_item_discount_limit'                        => 'Rader får inte ha en rabatt på mer än 99,99 %.',
    'date_range_report'                               => 'Datumintervall (nästa datum att köra)',
    'no_client_found'                                 => 'Hmmm... vi kunde inte hitta den klienten.',
    'tt_line_item_discount'                           => 'En radrabatt kan beräknas med en procentandel av priset eller ett fast belopp för det enskilda artikelpriset.',
    'functionality_not_available_on_demo'             => 'Tyvärr är den funktionen inte tillåten i demon.',
    'vat_tax_id'                                      => 'Momsregistreringsnummer',
    'tt_vat_tax_id'                                   => 'Mervärdesskattenummer (moms).',
    'enable_vat_tax_id'                               => 'Aktivera VAT ID',
    'no-attachment'                                   => 'det finns ingen bilaga',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Städa',
    'allow_edit_status_invoice'                       => 'Redigera :status Faktura',
    'tt_ss_allow_edit_invoices_status'                => 'Som en säkerhetsåtgärd kan endast fakturor i utkaststatus redigeras. Du kan åsidosätta detta genom att tillåta redigering av skickade och/eller betalda fakturor.',
    'allow_edit_invoices_status'                      => 'Tillåt redigering av fakturor i status',
    'draft_and_sent'                                  => 'Utkast och skickat',
    'draft_or_sent_and_paid'                          => 'Utkast, skickat och betalt',
    'invoice_editable'                                => 'Faktura redigerbar',
    'can_not_edit_paid_invoice'                       => 'Du kan inte redigera en betald faktura',
    'item_category'                                   => 'Artikelkategori',
    'itemLookups'                                     => 'Objektsökningar',
    'quoteItems'                                      => 'Citat objekt',
    'invoiceItems'                                    => 'Fakturaartiklar',
    'imports_disabled_in_demo.'                       => 'Importer är inaktiverade i demon.',
    'no_file_selected'                                => 'Ingen fil vald',
    'no_import_records'                               => 'Inga poster hittades att importera',
    'vendor_name'                                     => 'Leverantörsnamn',
    'license_key'                                     => 'Licensnyckel',
    'change_license_key'                              => 'Ändra licensnyckel',
    'verify_and_save'                                 => 'Kontrollera',
    'same_key_error'                                  => 'Ingen förändring upptäckt. Försök med en annan nyckel',
    'trying_invalid_key'                              => 'Den nyckeln kunde tyvärr inte verifieras. Licensnyckeln ändrades inte.',
    'key_updated'                                     => 'Grattis! Din licensnyckel har uppdaterats.',
    'invalid_date_format'                             => 'Ogiltigt datumformat. Obligatoriskt format: ÅÅÅÅ-MM-DD',
    'invalid_datetime_format'                         => 'Ogiltigt DateTime Format. Obligatoriskt format: ÅÅÅÅ-MM-DD TT:MM :SS',
    'profile_setting'                                 => 'Profilinställningar',
    'include_draft_invoices_unpaid_and_overdue'       => 'Inkludera utkast till fakturor i listor över obetalda och förfallna betalningar',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Om inställt på Ja, kommer fakturor med statusen Utkast att inkluderas i listor och beräkningar för förfallna och obetalda fakturor.',
    'tt_utilities_import'                             => 'Importera data från CSV-filer till din FusionInvoice-databas.',
    'tt_utilities_export'                             => 'Exportera data från din FusionInvoice-databas till ett antal olika format: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Visa loggfilen som innehåller alla e-posthändelser inom FusionInvoice.',
    'tt_utilities_system_log'                         => 'Visa systemloggfilen som innehåller systemhändelser för fel och varningar.',
    'tt_utilities_tag_cleanup'                        => 'Tar bort taggar som har definierats men inte använts. Tar även bort alla dubblerade taggar.',
    'tt_utilities_pdf_cleanup'                        => 'Tar bort tillfälliga PDF-filer.',
    'tt_utilities_recalc_invoices'                    => 'Skannar igenom varje faktura och säkerställer att summan matchar summan av alla rader, med hänsyn till rabatter och skatt. *Detta kan ta lång tid.',
    'tt_utilities_recalc_quotes'                      => 'Söker igenom varje offert och säkerställer att summan matchar summan av alla rader, med hänsyn till rabatter och skatt. *Detta kan ta lång tid.',
    'tt_utilities_clear_cache'                        => 'Tar bort tillfälliga cachefiler.',
    'tt_utilities_download_database'                  => 'Ladda ner en exporterad databasfil från dina FusionInvoice-data. Ju större din databas, desto längre tid tar det.',
    'tt_utilities_run_daily_tasks'                    => 'Ett CRON-jobb eller en schemalagd uppgift kör normalt dina dagliga uppgifter. Detta gör att du kan göra det manuellt. Den genererar levande fakturor från återkommande fakturamallar, skickar betalningspåminnelser etc.',
    'include_line_item_detail'                        => 'Inkludera raddetaljer',
    'invoice_tags'                                    => 'Fakturaetiketter',
    'related_accounts'                                => 'Relaterade konton',
    'not_found_related_clients'                       => 'Inga relaterade kundkonton har tilldelats',
    'invoices_paid_for_list'                          => 'Detta kundkonto betalar fakturor för',
    'child_accounts_exist'                            => 'Tillåt inställningen för barnkonton återställd till Ja. Det går inte att ändra till Nej när underordnade konton finns.',
    'third_bp_accounts_exist'                         => 'Inställningen för tredje parts räkningsbetalare återställdes till Ja. Det går inte att ändra till Nej när relaterade konton finns.',
    'tag_name'                                        => 'Taggnamn',
    'tag_new_name'                                    => 'Nytt taggnamn',
    'tag_category'                                    => 'Taggkategori',
    'rename_tags'                                     => 'Byt namn på taggar',
    'apply'                                           => 'Tillämpa',
    'select_tag_category'                             => 'Välj Taggkategori',
    'tt_utilities_rename_tags'                        => 'Byt namn på taggar som tilldelats kunder, anteckningar, försäljningsaktiviteter etc.',
    'system_default_dashboard'                        => 'Systemets standardinstrumentpanel',
    'user_specific_dashboards'                        => 'Användarspecifika instrumentpaneler',
    'tt_default_client_type'                          => 'Standard klienttyp',
    'default_client_type'                             => 'Standard klienttyp',
    'invalid_user'                                    => 'Välj en giltig användare.',
    'create_live_invoice'                             => 'Skapa Live Invoice',
    'create_live_invoice_successfully'                => 'Live faktura',
    'create_live_invoice_unsuccessfully'              => 'Livefaktura skapades inte',
    'live_invoice_not_generate'                       => 'Det går inte att generera en aktiv faktura från en återkommande faktura som har ett stoppdatum idag eller tidigare, eller ett nästa datum mer än 30 dagar i framtiden.',
    'data_seeder'                                     => 'Datasåmaskin',
    'select_module'                                   => 'Välj Modul',
    'number_of_seed'                                  => 'Antal frön',
    'seed_it'                                         => 'Seed It!',
    'seeds_success'                                   => 'Frön har lagts till',
    'tt_ri_generate_the_next_live_invoice'            => 'Generera nästa aktiva faktura för denna återkommande faktura just nu.',
    'system_log_clear_message'                        => 'Är du säker på att du vill rensa systemloggen? Denna åtgärd kan inte ångras och alla tidigare loggar kommer att raderas permanent.',
    'system_log_clear_successfully'                   => 'Systemloggen har rensats',
    'payment_problem'                                 => 'Ett problem uppstod under betalningen. Vänligen försök igen senare.',
    'log_detail'                                      => 'Klicka här för att se detaljloggen.',
    'log_limit_message'                               => 'Loggfil',
    'log_download_file'                               => 'Nedladdning fil',
    'log_delete_all'                                  => 'Ta bort alla filer',
    'log_level'                                       => 'Nivå',
    'log_context'                                     => 'Sammanhang',
    'log_date'                                        => 'Datum',
    'log_line_number'                                 => 'Linje nummer',
    'log_content'                                     => 'Innehåll',
    'addon_install_error'                             => 'Det finns ett problem med tilläggsinstallationen. Försök igen senare.',
    'addon_installed_success'                         => 'Addon har installerats.',
    'allow_edit_status_credit_memo'                   => 'Redigera tillämpad kreditnota',
    'database_seeder'                                 => 'Såmaskin',
    'tt_utilities_database_seeder'                    => 'Seed din databas med testdata med hjälp av seed-klasser',
    'vat_information'                                 => 'Momsinformation',
    'tt_vat_information'                              => 'IBAN bankkontonummer, BIC, e-post etc ...',
    'explore_addons'                                  => 'Utforska tillägg',
    'available_addons'                                => 'Tillgängliga FusionInvoice-tillägg',
    'addon_success'                                   => 'Addon har lagts till.',
    'payment_cannot_enabled_in_demo'                  => 'Betalningsgateways kan inte aktiveras i demon',
    'confirm_approve_leave_page'                      => 'Det finns osparade ändringar på den här sidan! Är du säker på att du vill lämna utan att spara?',
    'leave'                                           => 'Lämna',
    'demo_date_refresh'                               => 'Demodata kommer att uppdateras om',
    'minutes'                                         => 'minuter',
    'minute'                                          => 'minut',
    'seconds'                                         => 'sekunder',
    'mautic-authentication-fail'                      => 'Du har inte behörighet att komma åt den här resursen. Använd en giltig hemlig nyckel.',
    'something_went_wrong'                            => 'Något gick fel!',
    'month_to_date'                                   => 'Denna månad till dags dato',
    'quarter_to_date'                                 => 'Detta kvartal hittills',
    'year_to_date'                                    => 'År till datum',
    'last_active'                                     => 'Senast aktiv',
    'database_seeder_stop'                            => ':name STOPP FÖR FÖRETAGSSEDER',
    'database_seeder_start'                           => ':name BÖRJA FÖR FÖRETAGSSEDER',
    'seeder_records_created'                          => ':total Poster skapade framgångsrikt för :modal',
    'seeder_credit_apply_invoice'                     => 'Kreditnota tillämpas på faktura',
    'seeder_quote_approve_reject'                     => 'Citat Godkänn och förkasta',
    'seeder_executed'                                 => 'Såmaskinen utförd framgångsrikt!',
    'seeder_not_executed'                             => 'Seeder avrättades inte!',
    'db_to_file_system_attachments_migration'         => 'Migrering av bilagor - Databas till filsystem',
    'attachment_content_count'                        => 'Du är på väg att migrera totalt',
    'attachment_repeat_content_count'                 => 'Du är på väg att migrera totalt',
    'attachment_key_invalid'                          => 'Bifogad nyckel är ogiltig',
    'stop'                                            => 'Sluta!',
    'attachment_migration_warning'                    => 'Detta steg kommer att migrera bilagorna från din databas till ditt filsystem. Gör en fullständig säkerhetskopiering av databasen innan du fortsätter och se till att du har tillräckligt med diskutrymme för att utföra denna operation.',
    'attachment_agreement_accept'                     => 'Jag har säkerhetskopierat min databas.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => 'Microsoft 365 lösenord',
    'office365_username'                              => 'Microsoft 365 användarnamn',
    'custom_date_formula_note1'                       => '<b><u>Platshållare för standardvärde :</span></u></b> ~<br> Du kan använda <b>idag, imorgon och igår</b> vilket värde som helst som standard.<br>',
    'custom_date_formula_note2'                       => '<b>För idag + N dagar, använd </b> \'default\': \'+7\' Detta lägger till 7 dagar till dagens datum <br><b>För idag - N dagar, använd </b> \'default\': \'-7\' Detta kommer att subtrahera 7 dagar från dagens datum <br>',
    'mail_config_error'                               => 'Det går inte att skicka ett test-e-postmeddelande utan att e-postsändningsmetoden har definierats.',
    'db_prefix_alert'                                 => 'Vi märkte att du använder ett databasprefix av :prefix . FusionInvoice kommer inte att stödja databasprefix i framtida versioner. Vänligen redigera din databas och byt namn på alla dina tabeller genom att ta bort prefixet, redigera sedan filen database.php och ställ in ditt \'prefix\' värde till tomt',
    'db_prefix_alert_title'                           => 'Stöd för DB-prefix slutar snart',
    'add_title_bar_shortcut'                          => 'Lägg till genväg till titelfältet',
    'title_bar_shortcuts'                             => 'Titelfältsgenvägar',
    'select_icon'                                     => 'Välj ikon',
    'all_payment_method'                              => 'Alla betalningsmetoder',
    'about'                                           => 'Handla om',
    'own_license'                                     => 'Egen licens',
    'tt_own_license'                                  => 'Egen licens',
    'git_branch'                                      => 'Git nuvarande gren',
    'quote_email'                                     => 'Citat E-post',
    'custom1'                                         => 'Anpassad 1',
    'custom2'                                         => 'Anpassad 2',
    'custom3'                                         => 'Anpassad 3',
    'default_document_template'                       => 'Standard dokumentmall',
    'default_email_template'                          => 'Standard e-postmall',
    'sms'                                             => 'SMS',
    'pricing_formula'                                 => 'Prisformel',
    'is_mobile'                                       => 'Är mobil?',
    'default_sms_template'                            => 'Standard SMS-mall',
    'sms_log'                                         => 'SMS-logg',
    'two_factor_auth'                                 => 'Tvåfaktorsautentisering',
    'enabled_mail_driver'                             => 'Vänligen aktivera e-posttjänst',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Ogiltig kontrollkod',
    'otp-subject'                                     => 'Logga in OTP',
    'resend_otp_success'                              => 'Verifieringskod skickas på nytt',
    'resend_otp_btn'                                  => 'Återsänd koden',
    'expired_otp'                                     => 'Verifieringskoden har löpt ut',
    'token_expired'                                   => 'Din CSRF-token har löpt ut',
    'verification_code'                               => 'Verifierings kod',
    'migration'                                       => 'Migration',
    'invoice_status_change_draft_to_sent'             => 'Fakturastatus ändrad från utkast till skickad',
    'default_sales_quantity'                          => 'Standardförsäljningskvantitet',
    'lead_time'                                       => 'Genomsnittlig Ledtid (dagar)',
    'primary_vendor_id'                               => 'Föredragen leverantör',
    'all_items'                                       => 'Alla objekt',
    'non_inventory_items'                             => 'Artiklar som inte finns i lager',
    'back_ordered'                                    => 'Återbeställd',
    'low_inventory'                                   => 'Lågt lager',
    'high_inventory'                                  => 'Högt lager',
    'merge_client_records'                            => 'Slå samman klientposter',
    'primary_merge_to_client'                         => 'Slå samman till (behåll)',
    'surrogate_merge_from_client'                     => 'Slå samman från (kassera)',
    'merge'                                           => 'Sammanfoga',
    'merge_action'                                    => 'Sammanfoga åtgärd',
    'ignore'                                          => 'Ignorera',
    'overwrite'                                       => 'Skriva över',
    'add_to'                                          => 'Lägg till',
    'select_merge_client'                             => 'Välj För sammanfogning',
    'client_to_and_from_not_same'                     => 'Kunden till och klienten från måste vara olika.',
    'client_id_required'                              => 'Fältet för klientval måste vara både obligatoriskt och unikt.',
    'is_merge'                                        => 'Sammanfoga',
    'record_successfully_merged'                      => 'Posten har slagits samman',
    'service_ends'                                    => 'Tjänsten avslutas',
    'service_starts'                                  => 'Tjänsten startar',
    'explanation'                                     => 'Förklaring',
    'subscription_details'                            => 'Prenumerationsinformation',
    'generate_next_invoice'                           => 'Skapa nästa faktura',
    'subscription'                                    => 'Prenumeration',
    'of_the'                                          => 'Av',
    'on'                                              => 'På',
    'invoice_month'                                   => 'Fakturamånad',
    'invoice_year'                                    => 'Faktura år',
    'next_month'                                      => 'Nästa månad',
    'next_year'                                       => 'Nästa år',
    'day'                                             => 'Dag',
    'last_date'                                       => 'Sista datumet',
    'merge_record_warning'                            => 'Sluta! Sammanslagning av kundkonton kan inte ångras. Utöver de fält som du valde att skriva över eller lägga till, kommer all transaktionshistorik för den sammanslagna-från-klienten att överföras till den sammanslagna-till-klienten. Är du säker på att du vill slå samman dessa kundkonton?',
    'merge_child_account_warning'                     => 'Merge(From)-klienten har ett föräldrakonto med relaterade underordnade konton som kommer att omtilldelas till Merge(To)-klienten. Se till att Merge(To)-klienten är tillåten som ett föräldrakonto.',
    'merge_parent_account_warning'                    => 'Sammanslagningen tar bort din koppling till det överordnade kontot.',
    'merge_invoices_paid_by_warning'                  => 'Sammanslagningen tar bort din koppling till den överordnade fakturan som betalats av.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'Antalet relationer i klientmodellen har ändrats.',
    'payment_terms'                                   => 'Betalningsvillkor',
    'net_amount_due_in'                               => 'Nettobelopp som ska betalas in',
    'net_amount_due_by'                               => 'Nettobelopp som förfaller till',
    'if_paid_within'                                  => 'om betalas inom',
    'if_paid_by'                                      => 'om betalas av',
    'th_of_next_month'                                => 'den nästa månaden',
    'of_next_month'                                   => 'nästa månad',
    'down_payment'                                    => 'Handpenning',
    'balance_amount_due_of'                           => 'resterande belopp som ska betalas in',
    'payment_split_over'                              => 'Betalningen delas upp',
    'installments'                                    => 'avbetalningar',
    'days_from_invoice_date'                          => 'dagar från fakturadatum',
    'payment'                                         => 'Betalning',
    'one'                                             => 'Ett',
    'two'                                             => 'Två',
    'three'                                           => 'Tre',
    'four'                                            => 'Fyra',
    'five'                                            => 'Fem',
    'six'                                             => 'Sex',
    'discount_percent'                                => 'Rabatt i procent',
    'discount_days_simple'                            => 'Rabattdagar Enkel',
    'discount_days_nth'                               => 'Rabattdagar Nth',
    'net_due_days'                                    => 'Nettoförfallodagar',
    'balance_due_days'                                => 'Saldo förfallodagar',
    'number_of_installments'                          => 'Antal avbetalningar',
    'payment_term'                                    => 'Betalningsvillkor',
    'select_payment_term'                             => 'Välj Betalningsperiod',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'Fältet Avbetalningsprocent :index är obligatoriskt och större än noll.',
        'installment_due_days_error'                  => 'Avbetalningsdagarna :index som lämnats in krävs',
        'discount_percent_gt_error'                   => 'Den lämnade rabattprocenten krävs och är större än noll.',
        'discount_percent_lt_error'                   => 'Den lämnade rabattprocenten krävs och mindre än 100 %.',
        'down_payment_percent_lt_error'               => 'Handpenningens procent som lämnas in krävs och mindre än 100 %.',
        'discount_percent_numeric_error'              => 'Fältet Rabattprocent måste vara ett numeriskt värde och mindre än 100 %.',
        'down_payment_gt_error'                       => 'Den lämnade handpenningen krävs och är större än noll.',
        'discount_days_gt_net_days_error'             => 'Nettobeloppet för förfallodagar bör vara större än rabattdagar.',
        'discount_days_nth_gt_net_days_error'         => 'Nettobeloppet för förfallodagar bör vara större än N:te rabattdagarna.',
        'installment_due_days_gt_error'               => 'Förfallodagarna för avbetalning :index bör vara större än :preIndex avbetalningsdagar.',
        'installment_percent_total_error'             => 'Summan av avbetalningsprocenten är inte korrekt. den ska vara lika med 100 %.',
        'installment_percent_numeric_error'           => 'Summan av avbetalningsprocenten är inte korrekt. Det ska vara ett numeriskt värde.',
        'term_discount'                               => 'Terminsrabatt',
        'installment_due_days_gt_zero_error'          => 'Avbetalningsdagarna :index bör vara större än eller lika med Noll.',
        'net_due_days_error'                          => 'Nettobeloppet för förfallodagar bör vara större än noll och måste lämnas in.',
        'discount_days_simple_error'                  => 'De enkla rabattdagarna bör vara större än noll och måste lämnas in.',
        'discount_days_nth_error'                     => 'Rabatten N:te dagar bör vara större än noll och måste lämnas in.',
        'balance_due_days_error'                      => 'Förfallodagarna för saldot bör vara större än noll och måste lämnas in.',
        'status_error'                                => 'Tyvärr, statusen har inte ändrats på grund av termen som används i fakturan.',
        'down_payment_type_invoice_description_error' => 'Din angivna fakturabeskrivningstoken stämmer inte överens med din handpenningstyp.',
        'down_payment_type_quote_description_error'   => 'Din angivna offertbeskrivningstoken stämmer inte överens med din handpenningstyp.',
    ],
    'quotes_delete_error'                             => 'Citat raderingsfel',
    'for'                                             => 'För',
    'production'                                      => 'Produktion',
    'access_token'                                    => 'Access Token',
    'application_id'                                  => 'Ansöknings-ID',
    'location_id'                                     => 'Plats-ID',
    'fi_config_check'                                 => 'Förutsättningskontroll',
    'requirement'                                     => 'Krav',
    'required'                                        => 'Nödvändig',
    'actual'                                          => 'Faktisk',
    'result'                                          => 'Resultat',
    'db_prefix_setup_alert'                           => 'Din FusionInvoice-databas använder DB-prefix. Stöd för DB-prefix avslutades med version 2023-3.0. För att kunna fortsätta uppgradera till denna och framtida versioner krävs det att du tar bort DB-prefix. Du kan göra detta genom att byta namn på alla tabeller i din DB och ta bort prefixet och även ställa in värdet \'prefix\' => \'\', i din database.php-fil.',
    'open_tasks'                                      => 'Öppna Uppgifter',
    'closed_tasks'                                    => 'Stängda uppgifter',
    'select_status'                                   => 'Välj Status',
    'net_amount_due_invoice'                          => 'Nettobelopp som ska betalas inom :days dagar.',
    'days_add_in_current_date'                        => 'Det aktuella datumet, per <span class="text-blue">:date</span> , och förfallodatum, är att betrakta som <span class="text-blue">:date</span>  <span class="text-danger">plus</span> <span class="text-blue">antal dagar</span>.',
    'terms'                                           => 'Villkor',
    'quote_rejecting_error'                           => 'Faktura # :invoice_number skapades den :invoice_date från godkännandet av denna offert. Du måste ta bort eller annullera denna faktura innan du avvisar denna offert.',
    'resend_record_warning'                           => 'Vill du skicka det här e-postmeddelandet igen nu?',
    'resend_email'                                    => 'Skicka email igen',
    'requirement_check_fail'                          => 'Innan installationen kan fortsätta måste du åtgärda felen som visas ovan.',
    'failed'                                          => 'Misslyckades',
    'subscriptions'                                   => 'Prenumerationer',
    'tt_explanation'                                  => 'Ange en beskrivning för tjänsten med valfria datumplatshållare. Du kan använda följande tokens för att dynamiskt infoga tjänstens start- och slutdatum:{{service_starts_on}} och {{service_ends_on}}. Dessa kommer att ersättas med de faktiska start- och slutdatumen när innehållet visas.',
    'tt_ss_invoices_default_payment_terms'            => 'Förinställda betalningsvillkor för faktura',
    'invoices_default_terms'                          => 'Standardvillkor för fakturor',
    'net_amount_due_in_n_days'                        => 'Nettobelopp som ska betalas på N dagar',
    'last_day'                                        => 'Sista dagen',
    'down_payment_payment_term1'                      => 'Handpenning av',
    'down_payment_payment_term2'                      => 'krävs.  Saldot ska betalas in',
    '1_type'                                          => 'En faktura som skapats idag kommer att förfalla inom <span class="text-primary">#N</span> dagar',
    '2_type'                                          => 'En faktura som skapats idag ger rabatt om den betalas senast <span class="text-primary">#date</span> , om inte, ska hela beloppet betalas inom <span class="text-primary">#N</span>  dagar',
    '3_type'                                          => 'En faktura som skapas idag ger rabatt om den betalas senast <span class="text-primary">#date</span>  . Nettobeloppet ska betalas inom <span class="text-primary">#N</span>  dagar',
    '4_type'                                          => 'En faktura som skapas idag kommer att kräva en handpenning på <span class="text-primary">#amount</span>  . Det återstående saldot kommer att betalas inom <span class="text-primary">#N</span>  dagar',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>En faktura skapad idag och fördelad på <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Betalning <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Förfallo <span class="text-primary">#date</span></p>',
    'installment'                                     => 'avbetalning',
    'apply_payment_terms'                             => 'Tillämpa betalningsvillkor rabattbelopp',
    'payable_amount'                                  => 'Slutligt betalbart belopp',
    'payable_amount_lt_error'                         => 'Slutligt betalbart belopp bör vara mindre än fakturasaldo.',
    'payment_term_type_4_amount'                      => 'Delbetalning av :amount accepteras',
    'net_terms'                                       => 'Nettovillkor',
    'proforma_invoice_default'                        => 'Proforma faktura standard',
    'expense_vendor'                                  => 'Utgiftsförsäljare',
    'expense_vendor_deleted'                          => 'Utgiftsleverantören togs bort',
    'expense_vendor_already_used'                     => 'Du kan inte ta bort en leverantör som har relaterade utgiftsposter.',
    'total_must_be_gt_zero'                           => 'Summan av :modal_name måste vara större än noll.',
    'payment_failed'                                  => 'Betalningen misslyckades med :error',
    'xss_validation'                                  => ':attribute -fältet innehåller taggar som kan avslöja en XSS-sårbarhet',
    'support_desk'                                    => 'Support Desk',
    'choose_file'                                     => 'Välj FIL',
    'supportTicket'                                   => 'Support Desk',
    'create_support_ticket'                           => 'Skapa supportbiljett',
    'supportTicket_inbox_view'                        => 'Support Desk',
    'support_ticket'                                  => 'Supportbiljett',
    'ticket_number'                                   => 'Biljettnummer',
    'revision'                                        => 'Revision',
    'revisions'                                       => 'Revisioner',
    'recurring_invoices'                              => 'Återkommande fakturor',
    'message'                                         => 'Meddelande',
    'custom_img'                                      => 'Anpassad bild',
    'please_fill_some_data'                           => 'Vänligen fyll i nödvändiga uppgifter om den nya artikeln.',
    'assigned'                                        => 'Tilldelad',
    'add_ons_will_be_disabled'                        => 'FÖLJANDE TILLÄGG KOMMER ATT INAKTIVERAS:',
    'add_ons_will_be_disabled_msg'                    => 'Alla tillägg inaktiveras automatiskt under en kärnuppgradering av FusionInvoice. När den här uppgraderingen är klar, se till att ladda ner lämpliga tilläggszip-filer och installera dem. När du har gjort det kan du återaktivera dem från menyn Systeminställningar, Anpassningar, Tillägg och välja [Installera].',
    'price_not_valid'                                 => 'Priset måste vara högre än noll',
    'free_space'                                      => 'Fritt utrymme',
    'expense_type'                                    => 'Utgiftstyp',
    'standard_expense'                                => 'Standardkostnad',
    'expense_with_deductible_tax'                     => 'Kostnad med avdragsgill skatt',
    'remittance_to_tax_authority'                     => 'Remittering till Skatteverket',
    'tax_paid'                                        => 'Skatt betald',
    'tax_detail'                                      => 'Skatteinformation',
    'select_expense_type'                             => 'Välj kostnadstyp',
    'taxes_paid_on_expenses_or_remitted'              => 'Skatter som betalas på utgifter eller remitteras',
    'tax_name'                                        => 'Skattenamn',
    'last_activity'                                   => 'sista aktiviteten',
    'select_default_company_profile'                  => 'Välj din standardföretagsprofil',
    'mn_sales_tax'                                    => 'MN försäljningsskatt',
    'taxes_collected_on_sales'                        => 'Skatter som samlas in vid försäljning',
    'vatgst_tax_note'                                 => 'Ja beräknar att skatten ingår i artikelsumman. Nej kommer att lägga skatten till varans totala summa.',
    'tt_vatgst_tax'                                   => 'I det här exemplet antar vi en skattesats på 5 % och ett artikelpris på 100 USD. Om du ställer in Aktivera VAT/GST till Ja kommer att ge en fakturasumma på 100 USD, med artikelbeloppet justerat till 95,24 USD och ett skattebelopp på 4,76 USD. Om du ställer in VAT/GST till No kommer det att ge en fakturasumma på 105 USD, med ett artikelpris på 100 USD och en skatt på 5 USD.',
    'level_of_detail'                                 => 'Detaljnivå',
    'tax_report'                                      => 'Skatterapport',
    'detail'                                          => 'Detalj',
    'totals'                                          => 'Summor',
    'totals_with_dots'                                => 'Summor . . .',
    'yes_all'                                         => 'Ja alla)',
    'invoices_only'                                   => 'Endast fakturor',
    'payment_receipts_only'                           => 'Endast betalningskvitton',
    'role'                                            => 'Roll',
    'previous_email'                                  => 'Föregående e-postmeddelandet',
    'web_store_user_id'                               => 'Web Store Användar-ID: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Nettobelopp som ska betalas senast <span class="text-info">#LASTDATE</span>',
        '2_type'       => 'En rabatt på #DISCOUNTPERCENT % kan tas om den betalas senast <span class="text-info">#DISCOUNTDATE</span> , annars förfaller nettobeloppet senast <span class="text-info">#LASTDATE</span> .',
        '3_type'       => 'En rabatt på #DISCOUNTPERCENT % kan tas om den betalas senast <span class="text-info">#DISCOUNTDATE</span> , annars förfaller nettobeloppet senast <span class="text-info">#LASTDATE</span> .',
        '4_type'       => 'En handpenning på <span class="text-info">#DOWNPAYMENT</span>  är #INVOICEDATE . Saldot ska betalas senast <span class="text-info">#LASTDATE</span> .',
        '5_type'       => '<p class="mt-2 mb-1">Betalningar kan delas upp på <span class="text-info">#NUMBEROFINSTALLMENTS</span> delbetalningar</p>',
        '5_1_type'     => '<li>Betalning <span class="text-info">#PERCENT %</span> förfaller <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">Nästa månad har totalt #N dagar, så ange ett värde mellan 1 och #N för rabatten nästa månads dagar.</span>',
    ],
    'payment_term_not_selected'                       => 'Betalningstid ej vald',
    'confirm'                                         => 'Bekräfta',
    'create_live_invoice_now'                         => 'Skapa livefaktura nu?',
    'create_live_invoice_warn_message'                => '<p class="m-0">En prenumeration är som en fakturamall som används för att skapa livefakturor vid en given frekvens.</p><p class="m-0"> Normalt ett CRON-jobb eller en schemalagd uppgift är inställt för att köras en gång per dag och ansvarar för att kontrollera efter aktiva fakturor som ska skapas, baserat på prenumerationens fält Generera nästa fakturadatum.  Om det datumvärdet är idag eller tidigare än idag skapas en aktiv faktura automatiskt.</p><p class="m-0"> Med det här alternativet kan du skapa den aktiva fakturan manuellt från prenumerationen, utan att använda den automatiska metoden . Vill du skapa den aktiva fakturan nu?</p>',
    'contact'                                         => 'Kontakt',
    'invoice_month_plus_one'                          => 'Fakturamånad +1',
    'invoice_month_plus_two'                          => 'Fakturamånad +2',
    'invoice_month_plus_three'                        => 'Fakturamånad +3',
    'inbound_email'                                   => 'Inkommande e-post',
    'outbound_email'                                  => 'Utgående e-post',
    'email_signature'                                 => 'Epostsignatur',
    'mail_credential_error'                           => 'Ogiltig e-postkonfiguration. Kontrollera dina inställningar och försök igen. <strong>( Konfiguration <i class="fa fa-arrow-alt-circle-right"> </i> Systeminställningar <i class="fa fa-arrow-alt-circle-right"> </i> E-post )</strong>',
    'tt_generate_next_invoice'                        => 'Datumet när nästa aktiva faktura kommer att skapas automatiskt från denna prenumeration.',
    'tt_stop_date'                                    => 'Datumtröskeln efter vilken inga fler aktiva fakturor kommer att genereras automatiskt för denna prenumeration. Lämna det här fältet tomt för en prenumeration som ska fortsätta för alltid.',
    'description_template'                            => 'Beskrivningsmall',
    't_1_description'                                 => 'Full betalning ska ske senast #LASTDATE.',
    't_2_description'                                 => 'Ta en rabatt på #DISCOUNTPERCENT % om du betalar senast #DISCOUNTDATE, betalar annars hela fakturabeloppet senast #LASTDATE.',
    't_3_description'                                 => 'Ta en #DISCOUNTPERCENT % rabatt om du betalar senast #DISCOUNTDATE, betalar annars hela fakturabeloppet senast #LASTDATE.',
    't_4_description'                                 => 'En handpenning på #DOWNPAYMENT ska betalas den #INVOICEDATE, saldot på fakturan ska betalas senast #LASTDATE',
    't_4_1_description'                               => 'En handpenning på #DOWNPAYMENTPERCENT ska betalas den #INVOICEDATE, saldot på fakturan ska betalas senast #LASTDATE',
    't_5_description'                                 => 'Betalningarna ska göras i #NUMBEROFINSTALLMENTS lika delar',
    't_5_type_description'                            => 'Betalning #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT ska ske den #LASTDATE',
    'tokens_allowed'                                  => 'Polletter tillåtna',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'Den utvärderade texten från mallen är termbeskrivningen som visas på dokument som faktura, offerter, etc.',
    'cc_mail'                                         => 'CC Mail',
    'assigned_inv_sent_or_paid'                       => '*Det finns fakturor som har betalats eller skickats som har denna betalningstid tilldelad. Det är inte tillåtet att ändra â€˜Typâ€™-detaljerna.',
    'exclude_paid_invoices'                           => 'Uteslut betalda fakturor',
    'phone_number_numeric_error'                      => 'Telefonnumret måste vara ett nummer.',
    'phone_num_same_country_code_error'               => 'Se till att ditt telefonnummer är korrekt formaterat. Det verkar ha angetts med början på landskoden, vilket inte är tillåtet.',
    'tt_expense_amount'                               => 'Ange det totala beloppet för utgiften, inklusive skatt. Det här fältet är inte tillgängligt vid överföring av en skattebetalning till en skattemyndighet.',
    'tt_expense_tax_paid_deductible'                  => 'Ange det skattebelopp som betalades med denna utgift. Detta värde kommer att dras av från din totala skatteskuld i rapporterna Skattesammanfattning och Skattedetaljer.',
    'tt_expense_tax_paid_remittance'                  => 'Ange det skattebelopp som har remitterats till skattemyndigheten. Detta används för att registrera betalningar gjorda för skatter som samlats in på dina betalda fakturor.',
    'tt_expense_client'                               => 'Om denna utgift enbart uppstått för en kunds räkning och du vill fakturera dem för den, välj den relaterade kunden här.',
    'base_currency_not_deleted'                       => 'Basvalutan kan inte tas bort',
    'used_currency_modal_error'                       => 'Valuta som redan används i modulen :modal_names.',
    'addon_uninstall_success'                         => 'Addon har avinstallerats',
    'original'                                        => 'Original',
    'revision_current'                                => 'Revision (nuvarande)',
    'number'                                          => 'siffra',
    'copy_process_error'                              => 'hoppsan! Det verkar ha varit en hicka under kopieringsprocessen. Vänligen försök igen senare.',
    'tt_captcha_image'                                => 'CAPTCHA-bild',
    'reload_page'                                     => 'Vänligen ladda om sidan',
    'discount_limit'                                  => 'Rabatten måste vara mindre än 99,99 %.',
    'tooltip'                                         => 'Verktygstips',
    'authorization_error'                             => 'Du är inte behörig att utföra denna operation.',
    'reset_to_default'                                => 'Återställ till standard',
    'reset_to_default_warning'                        => '<p>Detta kommer att återställa ämnet och brödtexten till standardvärdet för :model . Fortsätta?</p>',
    'reset_default_mail_template'                     => 'Standardmailmallen för :model har återställts.',
    'overdue_invoice'                                 => 'Försenad faktura',
    'total_cannot_be_lt_zero'                         => 'Summan av :modal_name får inte vara mindre än noll.',
    'addons_disabled_during_setup'                    => 'Under uppgraderingsprocessen inaktiverades följande tillägg: :addons . Glöm inte att aktivera dem nu när uppgraderingen är klar.',
    'allow_payments_on_quotes'                        => 'Tillåt betalningar på offerter J/N',
    'allow_payments_on_quote'                         => 'Tillåt betalning J/N',
    'tt_ss_quotes_is_payable'                         => 'Om den är aktiverad, efter godkännande av offerten, visas en Betala nu-knapp i offertens offentliga länkvy. En faktura skapas automatiskt och betalningen kommer att läggas på fakturan.',
    'pay_with_square'                                 => 'Betala med kvadrat',
    'validation_mess_for_is_payable_quote'            => 'Inställningen för att automatiskt konvertera offert till faktura när kunden godkänner krävs när Tillåt betalningar på offerter är inställt på "Ja".',
    'client_requirement_msg'                          => 'Skapa en klient innan du lägger till :seed_name',
    'quote_add_items'                                 => 'Offertobjekt krävs och status inte annullerad',
    'invalid_quote_id'                                => 'Ogiltigt offert-id',
    'information_header'                              => 'Grattis, du är på väg att spara lite pengar!',
    'convenience_charge'                              => 'Bekvämlighetsavgift',
    'credit_card_fee_message'                         => 'Det kommer att tillkomma en kreditkortsavgift på :charge för denna transaktion.',
    'info_payment_term_type_2'                        => 'Även om ditt fakturasaldo är :ORIGINAL_AMOUNT, är du berättigad till en rabatt på betalningsvillkor på :DISCOUNT_PERCENT %, vilket kommer att minska ditt betalningsbelopp till :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Även om ditt fakturasaldo är :ORIGINAL_AMOUNT, är du berättigad till en rabatt på betalningsvillkor på :DISCOUNT_PERCENT %, vilket kommer att minska ditt betalningsbelopp till :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Även om ditt fakturasaldo är :ORIGINAL_AMOUNT, är du berättigad till betalningsvillkor för att betala en handpenning :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Även om ditt fakturasaldo är :ORIGINAL_AMOUNT, är du berättigad till betalningsvillkor för att betala en delbetalning :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'Betalningsvillkor måste tas bort från :modal innan radering.',
    'default_payment_term_warn'                       => '*Du kan bara ändra namn och nettoförfallodagar för <strong>Systemets standardbetalningsvillkor</strong>.',
    'quote_rejected_not_payable'                      => 'Citat # :number har avvisats och kan inte betalas på grund av dess status.',
    'could_not_delete'                                => 'Det gick inte att ta bort',
    'convenience_charges_calculation_fail'            => 'Fel: Beräkning av bekvämlighetsavgifter misslyckades under migreringen. Vänligen försök igen senare.',
    'sign_in_welcome_message'                         => 'ðŸš€ Grattis! Din FusionInvoice installerades framgångsrikt! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>Din FusionInvoice har uppgraderats från version :old_version till version :new_version .</p><p> För en detaljerad översikt över alla nya funktioner och förbättringar, kolla in våra <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">release Notes</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Tack för att du valde FusionInvoice. Ditt förtroende, ditt stöd och din feedback driver vår innovation.</p><p class="m-0 text-bold">Glad fakturering!</p><p class="text-bold">FusionInvoice-teamet</p >',
    'tt_gen_skin_user_profile'                        => 'Ändring av detta värde ställer in systemets standard ENDAST för nya användare. Användare kan åsidosätta denna inställning via sina användarprofilinställningar.',
    'description_template_invoice'                    => 'Beskrivningsmall - Faktura',
    'description_template_quote'                      => 'Beskrivningsmall - Citat',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Full betalning ska ske inom #NETDAYS från fakturadatum.',
    't_2_description_for_quote'                       => 'Ta en #DISCOUNTPERCENT % rabatt om du betalar inom #DISCOUNTDAYS, betalar annars hela offertbeloppet med #NETDAYS.',
    't_3_description_for_quote'                       => 'Ta en #DISCOUNTPERCENT % rabatt om du betalar senast #NTHDAY nästa månad, annars betalar du hela fakturabeloppet inom #NETDAYS dagar.',
    't_4_description_for_quote'                       => 'En handpenning på #DOWNPAYMENT ska betalas på fakturadatumet, det återstående saldot ska betalas inom #NETDAYS dagar',
    't_4_1_description_for_quote'                     => 'En handpenning på #DOWNPAYMENTPERCENT ska betalas på fakturadatumet, det återstående saldot ska betalas inom #NETDAYS dagar',
    't_5_description_for_quote'                       => 'Betalningarna ska göras i #NUMBEROFINSTALLMENTS lika delar',
    't_5_type_description_for_quote'                  => 'Betalning #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT förfaller #INSTALLMENTDUEDAYS dagar från fakturadatum',
    'default_term'                                    => 'Standardterm',
    'proceed_to_payment'                              => 'Fortsätt till betalning',
    'version_upgraded'                                => 'Din ansökan är uppdaterad.',
    'term_amount_gt_payment_amount'                   => 'Beloppet bör vara större än betalningsvillkorens rabattbelopp',
    'payment_term_not_eligible_warning'               => 'Betalningsterminsrabatten är endast tillgänglig för hela betalningar. Tyvärr är du inte kvalificerad för det.',
    'processed_by_user'                               => '<strong>Behandlas av:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Betalningsmetod:</strong> :method',
    'all_methods'                                     => 'Alla metoder',
    'this_payment'                                    => 'Denna betalning',
    'previous_balance'                                => 'Tidigare balansen',
    'payment_applied_with_remaining_balance'          => '<p><strong>Din betalning på :amount har tillämpats delvis. :remaining_balance förblir utestående.</strong></p>',
    'pre_payment_received'                            => '<p><strong>En förskottsbetalning på :amount har mottagits för framtida fakturor den :date .</strong></p>',
    'payment_full_applied'                            => '<p><strong>Din betalning :amount har tillämpats fullt ut.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Betalning <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;"> :formatted_number</span> ~ Detaljer:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>Betalning av :paid har tillämpats på Faktura :invoice_number den :date</span> ~',
    'payment_full_applied_on_inv_with_ptd'            => '<p>Betalning av :paid, minus :payment_terms_discount betalningsvillkorsrabatt, har tillämpats på Faktura :invoice_number den :date</span> ~',
    'payment_full_applied_on_inv_with_cc'             => '<p>Betalning av :paid, plus :convenience_charges convenience charges, har tillämpats på Faktura :invoice_number den :date</span> ~',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>Betalning av :paid, plus :convenience_charges convenience charges och minus :payment_terms_discount betalningsvillkorsrabatt, har tillämpats på Faktura :invoice_number den :date</span> ~',
    'payment_remaining_balance_mail_message'          => '<p>Det återstående saldot på faktura :invoice_number är :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Obetalda fakturor',
    'include'                                         => 'Omfatta',
    'exclude'                                         => 'Utesluta',
    'invoice_with_no_tax'                             => 'Fakturor utan moms',
    'tax_total'                                       => 'Skatt totalt',
];

return TranslationOverride::override(__FILE__, $translations);
