<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Account Instellingen',
    'active'                                          => 'Actief',
    'activity'                                        => 'Activiteit',
    'activity_invoice_paid'                           => 'Factuur <a href=":link">#:number</a> werd betaald.',
    'activity_invoice_viewed'                         => 'Factuur <a href=":link">#:number</a> werd bekeken.',
    'activity_quote_approved'                         => 'Offerte <a href=":link">#:number</a> werd goedgekeurd.',
    'activity_quote_rejected'                         => 'Offerte <a href=":link">#:number</a> werd afgewezen.',
    'activity_quote_viewed'                           => 'Offerte <a href=":link">#:number</a> werd bekeken.',
    'add_item'                                        => 'Item toevoegen',
    'add_line_item_to_invoice'                        => 'Itemregel toevoegen aan factuur',
    'add_note'                                        => 'Notitie toevoegen',
    'additional'                                      => 'Extra',
    'addon'                                           => 'Add-on',
    'addons'                                          => 'Add-ons',
    'address'                                         => 'Adres',
    'address_format'                                  => 'Adresnotatie',
    'after_amount'                                    => 'Na bedrag',
    'all'                                             => 'Alle',
    'all_categories'                                  => 'Alle categorieën',
    'all_statuses'                                    => 'Alle statussen',
    'all_time'                                        => 'Alle tijden',
    'all_vendors'                                     => 'Alle leveranciers',
    'allow_login'                                     => 'Sta login toe',
    'always_attach_pdf'                               => 'Altijd PDF toevoegen',
    'always_bcc'                                      => 'Altijd BCC Adres',
    'always_cc'                                       => 'Altijd CC Adres',
    'amount'                                          => 'Bedrag',
    'api_public_key'                                  => 'API publieke sleutel',
    'api_secret_key'                                  => 'API geheime sleutel',
    'approve'                                         => 'Goedkeuren',
    'approved'                                        => 'Goedgekeurd',
    'approved_quotes'                                 => 'Goedgekeurde offertes',
    'attach_files'                                    => 'Bestanden toevoegen',
    'attach_pdf'                                      => 'PDF Toevoegen',
    'attachment'                                      => 'Bijlage',
    'attachments'                                     => 'Bijlagen',
    'author'                                          => 'Auteur',
    'automatic'                                       => 'Automatisch',
    'automatic_email_on_recur'                        => 'Periodieke facturen automatisch mailen',
    'automatic_email_payment_receipts'                => 'Betaalbevestigingen automatisch mailen',
    'available_fields'                                => 'Beschikbare velden',
    'back'                                            => 'Terug',
    'back_to_invoice'                                 => 'Terug naar factuur',
    'back_to_quote'                                   => 'Terug naar offerte',
    'balance'                                         => 'Balans',
    'base_currency'                                   => 'Basis valuta',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Voor bedrag',
    'bill_this_expense'                               => 'Factureer deze onkosten',
    'bill_to'                                         => 'Factuur aan',
    'billable'                                        => 'Factureerbaar',
    'billed'                                          => 'Gefactureerd',
    'billing_address'                                 => 'Facturatie adres',
    'billing_city'                                    => 'Facturatie stad',
    'billing_name'                                    => 'Facturatie naam',
    'billing_state'                                   => 'Facturatie provincie',
    'billing_zip'                                     => 'Facturatie postcode',
    'binary_path'                                     => 'Binair pad',
    'body'                                            => 'Lichaam',
    'cancel'                                          => 'Annuleer',
    'canceled'                                        => 'Geannuleerd',
    'card_number'                                     => 'Kaartnummer',
    'cash'                                            => 'Contant',
    'category'                                        => 'Categorie',
    'cc'                                              => 'CC',
    'change'                                          => 'Wijzig',
    'change_client'                                   => 'Wijzig klant',
    'check_for_update'                                => 'Controleer op updates',
    'city'                                            => 'Stad',
    'clear_keys'                                      => 'Verwijder sleutels',
    'client'                                          => 'Klant',
    'client_form'                                     => 'Wijzigingsformulier klant',
    'client_name'                                     => 'Klantnaam',
    'client_not_found'                                => 'Klant niet gevonden',
    'client_statement'                                => 'Klantenoverzicht',
    'client_unique_name_option_1'                     => 'Alleen wanneer de klantnaam niet uniek is',
    'client_unique_name_option_2'                     => 'Altijd weergeven',
    'client_visibility'                               => 'Klant zichtbaarheid',
    'clients'                                         => 'Klanten',
    'code'                                            => 'Code',
    'column_name'                                     => 'Kolomnaam',
    'column_width'                                    => 'Kolombreedte',
    'company'                                         => 'Bedrijf',
    'complete'                                        => 'Voltooid',
    'complete_upgrade'                                => 'Upgrade voltooid',
    'compound'                                        => 'Samengesteld',
    'compound_tax_note'                               => 'Samengestelde BTW tarieven moeten worden toegepast op een één item zoals BTW 2 om het gewenste effect te hebben.',
    'confirm_approve_quote'                           => 'Weet je zeker dat je deze offerte wilt goedkeuren?',
    'confirm_reject_quote'                            => 'Weet je zeker dat je deze offerte wilt afkeuren?',
    'continue'                                        => 'Doorgaan',
    'convert_quote_option1'                           => 'De factuur moet de voorwaarden van de offerte behouden',
    'convert_quote_option2'                           => 'De factuur moet de standaard factuur termen gebruiken',
    'convert_quote_setting'                           => 'Wanneer een offerte wordt omgezet naar een factuur',
    'convert_quote_when_approved'                     => 'Offerte automatisch omzetten naar factuur indien klant deze goedkeurd',
    'converted_from_quote'                            => 'Omgezet vanuit offerte',
    'converted_to_invoice'                            => 'Omgezet naar factuur',
    'country'                                         => 'Land',
    'create_invoice'                                  => 'Factuur aanmaken',
    'create_quote'                                    => 'Offerte aanmaken',
    'created'                                         => 'Aangemaakt',
    'credit_card'                                     => 'Kredietkaart',
    'currencies'                                      => 'Valuta',
    'currency'                                        => 'Valuta',
    'currency_form'                                   => 'Valuta formulier',
    'currency_symbol'                                 => 'Valuta symbool',
    'currency_symbol_placement'                       => 'Valuta symbool plaatsing',
    'custom_date_range'                               => 'Aangepast datum bereik',
    'custom_field_form'                               => 'Wijzigingsformulier aangepaste velden',
    'custom_fields'                                   => 'Aangepaste velden',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'Dashboard',
    'dashboard_totals_option'                         => 'Totalen op het dashboard moeten bevatten',
    'database_not_configured'                         => 'Het blijkt dat app/config/database.php nog niet is geconfigureerd.',
    'database_setup'                                  => 'Database Setup',
    'date'                                            => 'Datum',
    'date_format'                                     => 'Datum formaat',
    'days'                                            => 'Dagen',
    'decimal_point'                                   => 'Decimale punt',
    'default_currency'                                => 'Standaard valuta',
    'default_footer'                                  => 'Standaard voettekst',
    'default_group'                                   => 'Standaard groep',
    'default_invoice_email_body'                      => 'Standaard factuur E-mail Body',
    'default_invoice_template'                        => 'Standaard factuur sjabloon',
    'default_item_tax_2_rate'                         => 'Standaard item 2 BTW tarief',
    'default_item_tax_rate'                           => 'Standaard item BTW tarief',
    'default_overdue_invoice_email_body'              => 'Standaard achterstallige factuur E-mail Body',
    'default_payment_receipt_body'                    => 'Standaard betalings ontvangst Body',
    'default_quote_email_body'                        => 'Standaard offerte E-mail Body',
    'default_quote_template'                          => 'Standaard offerte sjabloon',
    'default_terms'                                   => 'Standaard voorwaarden',
    'delete'                                          => 'Verwijder',
    'delete_client_warning'                           => '<p>STOP! Als je deze klant verwijdert, dan verwijder je ook alle facturen, offertes en betalingen die aan deze klant hangen. Weet je zeker dat je deze klant permanent wilt verwijderen?</p>',
    'delete_record_warning'                           => 'Weet je zeker dat je deze gegevens wilt verwijderen?',
    'description'                                     => 'Beschrijving',
    'details'                                         => 'Details',
    'disabled'                                        => 'Uitgeschakeld',
    'discount'                                        => 'Korting',
    'display_client_unique_name'                      => 'Unieke klantnaam weergeven',
    'display_do_not_require'                          => 'Weergeven maar niet vereisen',
    'display_order'                                   => 'Weergave volgorde',
    'display_profile_image'                           => 'Weergeven profielfoto',
    'do_not_add_line_item_to_invoice'                 => 'Voeg item regel niet toe aan factuur',
    'do_not_display'                                  => 'Niet weergeven',
    'documentation'                                   => 'Documentatie',
    'download'                                        => 'Download',
    'draft'                                           => 'Concept',
    'draft_invoices'                                  => 'Concept facturen',
    'draft_quotes'                                    => 'Concept offertes',
    'dropdown'                                        => 'Neerklaplijst',
    'due'                                             => 'Vervalt',
    'due_date'                                        => 'Vervaldatum',
    'edit'                                            => 'Bewerk',
    'edit_client'                                     => 'Bewerk Klant',
    'email'                                           => 'E-mail',
    'email_address'                                   => 'E-mail Adres',
    'email_invoice'                                   => 'E-mail factuur',
    'email_payment_receipt'                           => 'E-mail betalingsbevestiging',
    'email_quote'                                     => 'E-mail offerte',
    'email_send_method'                               => 'E-mail verzendmethode',
    'email_send_method_phpmail'                       => 'PHP Mail',
    'email_send_method_sendmail'                      => 'Sendmail',
    'email_send_method_sendgrid'                      => 'SendGrid API',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Ingeschakeld',
    'enter_payment'                                   => 'Betaling ingeven',
    'error'                                           => 'Fout',
    'every'                                           => 'Elke',
    'exchange_rate'                                   => 'Wisselkoers',
    'exchange_rate_mode'                              => 'Wisselkoers modus',
    'expense_form'                                    => 'Formulier onkosten',
    'expenses'                                        => 'Onkosten',
    'expiration'                                      => 'Vervaltijd',
    'expires'                                         => 'Vervalt',
    'export_clients'                                  => 'Exporteer klanten',
    'export_data'                                     => 'Exporteer data',
    'export_expenses'                                 => 'Exporteer onkosten',
    'export_invoice_items'                            => 'Exporteer factuur items',
    'export_invoices'                                 => 'Exporteer facturen',
    'export_payments'                                 => 'Exporteer betalingen',
    'export_quote_items'                              => 'Exporteer offerte items',
    'export_quotes'                                   => 'Exporteer offertes',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Faxnummer',
    'field_label'                                     => 'Veld Label',
    'field_meta'                                      => 'Veld Meta',
    'field_meta_description'                          => 'Gebruik het meta veld alleen als het veld Type: neerklaplijst is. Je kunt neerklaplijst waardes invullen door een lijst in te vullen gescheidden door komma\'s.',
    'field_type'                                      => 'Veld type',
    'footer'                                          => 'Voettekst',
    'format'                                          => 'Formaat',
    'frequency'                                       => 'Frequentie',
    'from'                                            => 'Van',
    'from_date'                                       => 'Van datum',
    'general'                                         => 'Algemeen',
    'generate_keys'                                   => 'Genereer sleutels',
    'group'                                           => 'Groep',
    'group_form'                                      => 'Groep formulier',
    'groups'                                          => 'Groepen',
    'header_title_text'                               => 'Hoofdtitel tekst',
    'help'                                            => 'Help',
    'help_currency_code'                              => 'De munteenheid code, bijv. "EUR".',
    'help_currency_name'                              => 'De munteenheid naam, bijv. "Euro".',
    'help_currency_symbol'                            => 'De munteenheid symbool, bijv. "€".',
    'help_currency_symbol_placement'                  => 'Plaats om het munteenheid symbool te plaatsen.',
    'help_text_client_name'                           => 'Deze waarde mag de naam van een bedrijf of persoon zijn en verschijnt op offertes en facturen. Deze waarde hoeft niet uniek te zijn.',
    'help_text_client_password'                       => 'Laat dit veld leeg tenzij je een wachtwoord aanmaakt of reset.',
    'help_text_client_unique_name'                    => 'Wanneer één of meer klanten in het systeem dezelfde naam bevatten is het vereist dat er een unieke naam wordt meegegeven om onderscheid te kunnen maken. Deze waarde verschijnt niet op offertes of facturen.',
    'i_accept'                                        => 'Ik accepteer',
    'import_data'                                     => 'Importeer data',
    'inactive'                                        => 'Inactief',
    'income'                                          => 'Inkomsten',
    'install'                                         => 'Installeren',
    'installation_complete'                           => 'Installatie compleet',
    'installing_please_wait'                          => 'Installeren, een ogenblik geduld alstublieft...',
    'invalid_credentials'                             => 'Ongeldige gegevens',
    'invoice'                                         => 'Factuur',
    'invoice_default'                                 => 'Factuur standaard',
    'invoice_email_subject'                           => 'Factuur e-mail onderwerp',
    'invoice_items'                                   => 'Factuur items',
    'invoice_number'                                  => 'Factuurnummer',
    'invoice_summary'                                 => 'Factuuroverzicht',
    'invoiced'                                        => 'Gefactureerd',
    'invoices'                                        => 'Facturen',
    'invoices_due_after'                              => 'Facturen vervallen na (dagen)',
    'issued'                                          => 'Uitgegeven',
    'item'                                            => 'Item',
    'item_lookup_form'                                => 'Formulier item zoekenopdracht',
    'item_lookups'                                    => 'Item zoekopdrachten',
    'item_sales'                                      => 'Item verkoop',
    'items'                                           => 'Items',
    'label_invoice'                                   => 'Kies de factuur om deze uitgave aan toe te voegen',
    'label_item_description'                          => 'Vul een beschrijving in voor deze uitgave (optioneel)',
    'label_item_name'                                 => 'Vul een naam in voor de toe te voegen regel item op de factuur',
    'landscape'                                       => 'Liggend',
    'language'                                        => 'Taal',
    'left_pad'                                        => 'Voorloop nullen',
    'left_pad_description'                            => 'Het aantal nullen om optioneel aan de linkerkant van het volgende nummer toe te voegen.',
    'legal'                                           => 'Legal',
    'letter'                                          => 'Letter',
    'license_agreement'                               => 'Licentie Overeenkomst',
    'license_agreement_accept'                        => 'Ik accepteer de voorwaarden van de licentie overeenkomst',
    'logo'                                            => 'Logo',
    'mail_hash_error'                                 => 'Het blijkt dat jouw geheime sleutel is veranderd sinds de laatste keer dat je jouw e-mail wachtwoord had opgeslagen. Om dit probleem op te lossen ga je naar Systeem Instellingen -> E-mail tab, vul hier jouw e-mail wachtwoord opnieuw in en klik op Opslaan. Let op! Totdat dit gedaan is zullen er geen e-mails worden verstuurd.',
    'manual'                                          => 'Handleiding',
    'map_fields_to_import'                            => 'Link velden voor import',
    'merchant_api_key'                                => 'API sleutel',
    'merchant_api_password'                           => 'API wachtwoord',
    'merchant_api_username'                           => 'API gebruikersnaam',
    'merchant_publishable_key'                        => 'Publiceerbare sleutel',
    'merchant_secret_key'                             => 'Geheime sleutel',
    'merchant_signature'                              => 'Handtekening',
    'mobile'                                          => 'Mobiel',
    'mobile_number'                                   => 'Mobiele Nummer',
    'monthly'                                         => 'Maandelijks',
    'months'                                          => 'Maanden',
    'multiple_email_validation'                       => 'Meerdere e-mail adressen dienen geldig en gescheiden door kommas te zijn.',
    'name'                                            => 'Naam',
    'net_income'                                      => 'Netto Inkomsten',
    'never'                                           => 'Nooit',
    'new'                                             => 'Nieuw',
    'next_date'                                       => 'Volgende Datum',
    'next_number'                                     => 'Volgende Nummer',
    'no'                                              => 'Nee',
    'no_open_invoices'                                => 'Deze klant heeft geen openstaande facturen. Om een uitgave te kunnen factureren, dient de klant minimaal 1 factuur te hebben die nog niet volledig betaald is.',
    'no_records_found'                                => 'Geen gegevens gevonden.',
    'none'                                            => 'Geen',
    'not_billable'                                    => 'Niet factureerbaar',
    'not_billed'                                      => 'Niet gefactureerd',
    'not_viewed'                                      => 'Niet bekeken',
    'not_visible'                                     => 'Niet zichtbaar',
    'note'                                            => 'Notitie',
    'note_notification'                               => 'Notificatie: Nieuwe Notitie',
    'notes'                                           => 'Notities',
    'online_payment'                                  => 'Online betaling',
    'online_payment_method'                           => 'Online betalingsmethode',
    'online_payments'                                 => 'Online betalingen',
    'options'                                         => 'Opties',
    'other'                                           => 'Anders',
    'output_type'                                     => 'Uitvoer type',
    'overdue'                                         => 'Achterstallig',
    'overdue_email_subject'                           => 'Achterstallig E-mail onderwerp',
    'overdue_invoice_reminder'                        => 'Achterstallig factuur herinnering',
    'overdue_invoice_reminder_frequency'              => 'Achterstallig factuur herinnering frequentie',
    'overdue_invoice_reminder_frequency_help'         => 'Een door komma gescheiden lijst van dagen NADAT een factuur achterstallig is om een herinnering te sturen. Laat leeg om herinneringen uit te schakelen. Bijvoorbeeld, een waarde van 1,5,10 zal herinneringen sturen: 1, 5 en 10 dagen nadat de factuur achterstallig is.',
    'overdue_invoices'                                => 'Achterstallige facturen',
    'paid'                                            => 'Betaald',
    'paper_orientation'                               => 'Papier oriëntatie',
    'paper_size'                                      => 'Papierformaat',
    'password'                                        => 'Wachtwoord',
    'password_confirmation'                           => 'Wachtwoord bevestiging',
    'password_successfully_reset'                     => 'Wachtwoord succesvol gereset',
    'pay'                                             => 'Betalen',
    'pay_now'                                         => 'Betaal nu',
    'payment_applied'                                 => 'Uw betaling is toegepast',
    'payment_button_text'                             => 'Betaalknop tekst',
    'payment_date'                                    => 'Betaaldatum',
    'payment_form'                                    => 'Betaalformulier',
    'payment_method'                                  => 'Betaalmethode',
    'payment_method_form'                             => 'Betaalmethode formulier',
    'payment_methods'                                 => 'Betaalmethode',
    'payment_receipt'                                 => 'Betaalbevestiging',
    'payment_receipt_email_subject'                   => 'Betaalbevestiging e-mail onderwerp',
    'payments'                                        => 'Betalingen',
    'payments_collected'                              => 'Betalingen verzameld',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'PDF Driver',
    'pdf_driver_wkhtmltopdf'                          => 'Het binaire pad veld moet een geldig pad bevatten wanneer je gebruik maakt van de wkhtmltopdf PDF driver.',
    'percent'                                         => 'Percentage',
    'phone'                                           => 'Telefoon',
    'phone_number'                                    => 'Telefoonnummer',
    'php_version_error'                               => 'PHP voldoet niet aan de vereiste versie (%s)',
    'placeholder_type_message'                        => 'Type uw bericht...',
    'portrait'                                        => 'Portret',
    'postal_code'                                     => 'Postcode',
    'prefix'                                          => 'Voorvoegsel',
    'prerequisites'                                   => 'Vereisten',
    'preview'                                         => 'Voorbeeld',
    'price'                                           => 'Prijs',
    'private'                                         => 'Privé',
    'problem_with_email_template'                     => 'Er lijkt een probleem te zijn met het e-mail sjabloon. Controleer alsjeblieft de sjablonen in Systeem instellingen onder de E-mail tab.',
    'product'                                         => 'Product',
    'profit_and_loss'                                 => 'Winst en verlies',
    'public'                                          => 'Publiek',
    'qty'                                             => 'Aantal',
    'quantity'                                        => 'Hoeveelheid',
    'quantity_price_decimals'                         => 'Aantal decimale nummers voor hoeveelheden en bedragen',
    'quote'                                           => 'Offerte',
    'quote_approved'                                  => 'Offerte goedgekeurd',
    'quote_approved_email_body'                       => 'Goedgekeurde offerte e-mail Body',
    'quote_default'                                   => 'Offerte standaard',
    'quote_email_subject'                             => 'Offerte e-mail onderwerp',
    'quote_items'                                     => 'Offerte items',
    'quote_number'                                    => 'Offertenummer',
    'quote_rejected'                                  => 'Offerte afgekeurd',
    'quote_rejected_email_body'                       => 'Afgekeurde offerte e-mail lichaam',
    'quote_status_change_notification'                => 'Notificatie: Offerte status veranderd',
    'quote_summary'                                   => 'Offerteoverzicht',
    'quote_to_invoice'                                => 'Offerte naar factuur',
    'quotes'                                          => 'Offertes',
    'quotes_expire_after'                             => 'Offertes verlopen na (dagen)',
    'recalculate'                                     => 'Herberekenen',
    'recalculate_help_text'                           => 'Herberekenen kan enkele momenten duren. Er verschijnt een melding zodra dit voltooid is.',
    'recalculate_invoices'                            => 'Herbereken facturen',
    'recalculate_quotes'                              => 'Herbereken offertes',
    'recalculating_wait'                              => 'Herberekenen, een ogenblik geduld...',
    'recalculation_complete'                          => 'Herberekenen voltooid',
    'recent_invoices'                                 => 'Recente facturen',
    'recent_payments'                                 => 'Recente betalingen',
    'recent_quotes'                                   => 'Recente offertes',
    'record_not_found'                                => 'Gegevens niet gevonden',
    'record_successfully_created'                     => 'Gegevens succesvol aangemaakt',
    'record_successfully_deleted'                     => 'Gegevens succesvol verwijderd',
    'record_successfully_updated'                     => 'Gegevens succesvol bijgewerkt',
    'records_imported_successfully'                   => 'Gegevens succesvol geÃ¯mporteerd',
    'recurring'                                       => 'Periodiek',
    'reject'                                          => 'Afkeuren',
    'rejected'                                        => 'Afgekeurd',
    'rejected_quotes'                                 => 'Afgekeurde offertes',
    'remember_me'                                     => 'Herinner mij',
    'remove_logo'                                     => 'Verwijder logo',
    'report_rev_client_notice'                        => 'Zodra er betalingen zijn ingevoerd in het systeem is dit rapport beschikbaar om te downloaden.',
    'reports'                                         => 'Rapporten',
    'require'                                         => 'Vereisen',
    'reset_number'                                    => 'Herinstellen nummer',
    'reset_password'                                  => 'Herinstellen wachtwoord',
    'results_per_page'                                => 'Resultaten per pagina',
    'revenue_by_client'                               => 'Omzet per klant',
    'round_tax_decimals'                              => 'Aantal decimale nummers voor BTW afronding',
    'run_report'                                      => 'Rapport uitvoeren',
    'save'                                            => 'Opslaan',
    'save_and_apply_exchange_rate'                    => 'Opslaan en wisselkoers toepassen',
    'save_item_as_lookup'                             => 'Sla item op als zoekopdracht',
    'search'                                          => 'Zoeken',
    'select_file_to_import'                           => 'Selecteer bestand om te importeren',
    'send'                                            => 'Verstuur',
    'sending'                                         => 'Versturen',
    'sendmail_path'                                   => 'Sendmail pad',
    'sent'                                            => 'Verzonden',
    'sent_invoices'                                   => 'Verzonden facturen',
    'sent_quotes'                                     => 'Verzonden offertes',
    'settings'                                        => 'Instellingen',
    'settings_successfully_saved'                     => 'Instellingen succesvol opgeslagen',
    'setup'                                           => 'Setup',
    'sign_in'                                         => 'Inloggen',
    'sign_out'                                        => 'Uitloggen',
    'skin'                                            => 'Thema',
    'smtp_encryption'                                 => 'SMTP encryptie',
    'smtp_host_address'                               => 'SMTP server adres',
    'smtp_host_port'                                  => 'SMTP server poort',
    'smtp_password'                                   => 'SMTP wachtwoord',
    'smtp_username'                                   => 'SMTP gebruikersnaam',
    'start_date'                                      => 'Startdatum',
    'state'                                           => 'Provincie',
    'status'                                          => 'Status',
    'step_database_setup'                             => 'Deze stap zal de database tabellen installeren en upgraden. Dit kan even duren.',
    'step_prerequisites'                              => 'De volgende benodigdheden moeten opgelost worden voordat de installatie kan doorgaan:',
    'subject'                                         => 'Onderwerp',
    'submit'                                          => 'Versturen',
    'subtotal'                                        => 'Subtotaal',
    'summary'                                         => 'Overzicht',
    'symbol'                                          => 'Symbool',
    'symbol_placement'                                => 'Symbool plaatsing',
    'system'                                          => 'Systeem',
    'system_settings'                                 => 'Systeem instellingen',
    'table_name'                                      => 'Tabel naam',
    'tax'                                             => 'BTW',
    'tax_1'                                           => 'BTW 1',
    'tax_2'                                           => 'BTW 2',
    'tax_rate'                                        => 'BTW-tarief',
    'tax_rate_form'                                   => 'BTW tarief formulier',
    'tax_rate_name'                                   => 'BTW-tarief naam',
    'tax_rate_percent'                                => 'BTW-tarief percentage',
    'tax_rates'                                       => 'BTW-tarieven',
    'tax_summary'                                     => 'BTW overzicht',
    'taxable_amount'                                  => 'Belastbaar bedrag',
    'taxes'                                           => 'BTW',
    'template'                                        => 'Sjabloon',
    'terms_and_conditions'                            => 'Algemene Voorwaarden',
    'test_mode'                                       => 'Testmodus',
    'text'                                            => 'Tekst',
    'textarea'                                        => 'Tekstgebied',
    'this_quarter'                                    => 'Huidig kwartaal',
    'thousands_separator'                             => 'Duizendtal schijding',
    'timezone'                                        => 'Tijdzone',
    'to'                                              => 'Aan',
    'to_date'                                         => 'Tot datum',
    'total'                                           => 'Totaal',
    'total_balance'                                   => 'Totaal balans',
    'total_invoiced'                                  => 'Totaal gefactureerd',
    'total_expenses'                                  => 'Totaal onkosten',
    'total_paid_invoices'                             => 'Totaal betaalde facturen',
    'try_again'                                       => 'Probeer opnieuw',
    'uninstall'                                       => 'Deïnstalleren',
    'uninstall_addon_warning'                         => 'Het deïnstalleren van deze add-on zorgt ervoor dat alle data die hierbij hoort die je hebt ingevuld verwijdert wordt. Weet je zeker dat je wilt doorgaan?',
    'unique_name'                                     => 'Unieke naam',
    'unknown_error'                                   => 'Onbekende fout',
    'upcoming_payment_notice_email_body'              => 'Toekomstige betaalnotificatie e-mail lichaam',
    'upcoming_payment_notice_email_subject'           => 'Toekomstige betaalnotificatie e-mail onderwerp',
    'upcoming_payment_notice_frequency'               => 'Toekomstige betaalnotificatie frequentie',
    'upcoming_payment_notice_frequency_help'          => 'Een door komma gescheiden lijst van dagen VOOR dat een factuur achterstallig is voor een herinnering wordt verzonden. Laat leeg om toekomstige betaal notificaties uit te schakelen. Bijvoorbeeld, een waarde van 1,5, 10 zorgt ervoor dat notificaties 1, 5 en 10 dagen voor een factuur achterstallig is wordt verstuurd.',
    'update_available'                                => 'FusionInvoice versie :version is beschikbaar om te downloaden!',
    'update_exchange_rate'                            => 'Wisselkoers actualiseren',
    'update_not_available'                            => 'Op het moment zijn er geen updates beschikbaar.',
    'upload_progress'                                 => 'Upload voortgang',
    'user'                                            => 'Gebruiker',
    'user_accounts'                                   => 'Gebruikersaccounts',
    'user_form'                                       => 'Gebruiker formulier',
    'users'                                           => 'Gebruikers',
    'validation_invoice_summary_from_date'            => 'De \'vanaf\' datum op het Dashboard Widget van het Factuuroverzicht is vereist wanneer de datum bereik is ingesteld op aangepaste datum bereik.',
    'validation_invoice_summary_to_date'              => 'De \'tot\' datum op het Dashboard Widget van het Factuuroverzicht is vereist wanneer de datum bereik is ingesteld op aangepaste datum bereik.',
    'validation_quote_summary_from_date'              => 'De \'vanaf\' datum op het Dashboard Widget van het Offerteoverzicht is vereist wanneer de datum bereik is ingesteld op aangepaste datum bereik.',
    'validation_quote_summary_to_date'                => 'De \'tot\' datum op het Dashboard Widget van het Offerteoverzicht is vereist wanneer de datum bereik is ingesteld op aangepaste datum bereik.',
    'vendor'                                          => 'Leverancier',
    'version'                                         => 'Versie',
    'view'                                            => 'Weergeven',
    'view_all'                                        => 'Alles weergeven',
    'view_all_invoices_for_client'                    => 'Alle facturen voor deze klant weergeven',
    'view_all_payments_for_client'                    => 'Alle betalingen voor deze klant weergeven',
    'view_all_quotes_for_client'                      => 'Alle offertes voor deze klant weergeven',
    'view_approved_quotes'                            => 'Goedgekeurde offertes weergeven',
    'view_client'                                     => 'Klant weergeven',
    'view_draft_invoices'                             => 'Weergeven conceptfacturen',
    'view_draft_quotes'                               => 'Weergeven offertes',
    'view_overdue_invoices'                           => 'Weergeven achterstallige facturen',
    'view_payments'                                   => 'Weergeven betalingen',
    'view_rejected_quotes'                            => 'Weergeven afgekeurde offertes',
    'view_sent_invoices'                              => 'Weergeven verzonden facturen',
    'view_sent_quotes'                                => 'Weergeven verzonden offertes',
    'view_unique_name'                                => 'Weergeven unieke naam',
    'viewed'                                          => 'Bekeken',
    'visible'                                         => 'Zichtbaar',
    'visible_after_payment'                           => 'Zichtbaar na betaling',
    'web'                                             => 'Web',
    'web_address'                                     => 'Webadres',
    'weekly'                                          => 'Wekelijks',
    'weeks'                                           => 'Weken',
    'welcome'                                         => 'Welkom',
    'what_to_import'                                  => 'Wat wil je importeren?',
    'year'                                            => 'Jaar',
    'yearly'                                          => 'Jaarlijks',
    'years'                                           => 'Jaren',
    'yes'                                             => 'Ja',
    'you_may_now_sign_in'                             => 'Je kunt nu inloggen!',

    // 2017-1
    'all_company_profiles'                            => 'Alle bedrijfsprofielen',
    'cannot_delete_record_in_use'                     => 'Deze gegevens zijn in gebruik en kunnen niet verwijderd worden.',
    'cannot_edit_record_in_use'                       => 'Deze gegevens zijn in gebruik en kunnen niet bewerkt worden.',
    'change_company_profile'                          => 'Wijzig bedrijfsprofiel',
    'company_profile'                                 => 'Bedrijfsprofiel',
    'company_profiles'                                => 'Bedrijfsprofielen',
    'company_profile_form'                            => 'Bedrijfsprofielen formulier',
    'copy'                                            => 'Kopiëren',
    'create_recurring_invoice'                        => 'Aanmaken periodieke factuur',
    'custom'                                          => 'Aangepast',
    'date_range'                                      => 'Datum bereik',
    'day_short_sunday'                                => 'Zo',
    'day_short_monday'                                => 'Ma',
    'day_short_tuesday'                               => 'Di',
    'day_short_wednesday'                             => 'Wo',
    'day_short_thursday'                              => 'Do',
    'day_short_friday'                                => 'Vr',
    'day_short_saturday'                              => 'Za',
    'default_company_profile'                         => 'Standaard bedrijfsprofiel',
    'first_quarter'                                   => 'Eerste kwartaal',
    'fourth_quarter'                                  => 'Vierde kwartaal',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Afgelopen 7 dagen',
    'last_30_days'                                    => 'Afgelopen 30 dagen',
    'last_month'                                      => 'Afgelopen maand',
    'last_quarter'                                    => 'Afgelopen kwartaal',
    'last_year'                                       => 'Afgelopen jaar',
    'month_january'                                   => 'Januari',
    'month_february'                                  => 'Februari',
    'month_march'                                     => 'Maart',
    'month_april'                                     => 'April',
    'month_may'                                       => 'Mei',
    'month_june'                                      => 'Juni',
    'month_july'                                      => 'Juli',
    'month_august'                                    => 'Augustus',
    'month_september'                                 => 'September',
    'month_october'                                   => 'Oktober',
    'month_november'                                  => 'November',
    'month_december'                                  => 'December',
    'recurring_invoice'                               => 'Periodieke factuur',
    'second_quarter'                                  => 'Tweede kwartaal',
    'stop_date'                                       => 'Stop datum',
    'third_quarter'                                   => 'Derde kwartaal',
    'this_month'                                      => 'Deze Maand',
    'this_year'                                       => 'Dit jaar',
    'today'                                           => 'Vandaag',
    'user_account'                                    => 'Gebruikers account',
    'yesterday'                                       => 'Gisteren',

    // 2017-3
    'mail_log'                                        => 'Mail logboek',
    'recent_client_activity'                          => 'Recente klantactiveiten',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Onbetaalde facturen uitsluiten',

    // 2017-7
    'please_wait'                                     => 'Even wachten...',
    'reply_to_address'                                => 'Antwoordadres',

    // 2017-8
    'admin'                                           => 'Beheerder',
    'admin_account'                                   => 'Beheerdersaccount',
    'admin_accounts'                                  => 'Beheerdersaccounts',
    'all_accounts'                                    => 'Alle accounts',
    'api_key'                                         => 'API sleutel',
    'client_account'                                  => 'Klant account',
    'client_accounts'                                 => 'Klant accounts',
    'client_id'                                       => 'Klant identificatie',
    'client_secret'                                   => 'Klant geheim',
    'enable_bitcoin_payments'                         => 'Schakel Bitcoin-betalingen in',
    'live'                                            => 'Live',
    'mode'                                            => 'Modus',
    'publishable_key'                                 => 'Publiceerbare sleutel',
    'sandbox'                                         => 'Sandbox',
    'secret_key'                                      => 'Geheime sleutel',
    'type'                                            => 'Type',

    // 2017-10
    'deselect_all'                                    => 'Deselecteer alles',
    'select_all'                                      => 'Selecteer alles',
    'use_24_hour_time_format'                         => 'Gebruik 24-uurs tijdnotatie',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Weet u zeker dat u deze records wilt verwijderen?',
    'bulk_invoice_change_status_warning'              => 'Weet u zeker dat u de status van de geselecteerde factuur(en) wilt wijzigen?',
    'bulk_quote_change_status_warning'                => 'Weet u zeker dat u de status van de geselecteerde offerte(s) wilt wijzigen?',
    'calculate_as_vat_gst'                            => 'Bereken als BTW',
    'change_status'                                   => 'Verander status',
    'default_status_filter'                           => 'Standaard statusfilter',
    'error_applying_payment'                          => 'Er is een fout opgetreden bij het toepassen van deze betaling. Probeer een andere kaart of betaalmethode.',
    'remaining'                                       => 'Resterend',

    // 2017-12
    'invoice_date'                                    => 'Factuur datum',
    'include_profit_based_on'                         => 'Inclusief winst op basis van',

    // 2018-1
    'add_contact'                                     => 'Contact toevoegen',
    'allow_self_signed_cert'                          => 'Sta zelfondertekend certificaat toe',
    'backup'                                          => 'Back-up',
    'close'                                           => 'Dichtbij',
    'change_invoice_date_to_todays_date'              => 'Wijzig factuurdatum in de datum van vandaag',
    'change_quote_date_to_todays_date'                => 'Wijzig offertedatum in de datum van vandaag',
    'contacts'                                        => 'Contacten',
    'default_bcc'                                     => 'Standaard BCC',
    'default_cc'                                      => 'Standaard CC',
    'default_to'                                      => 'Standaard naar',
    'disable'                                         => 'Uitschakelen',
    'download_database_backup'                        => 'Download database back-up',
    'edit_contact'                                    => 'Bewerk contact',
    'expense_list'                                    => 'Onkostenlijst',
    'keep_invoice_date_as_is'                         => 'Behoud factuurdatum',
    'keep_quote_date_as_is'                           => 'Behoud offertedatum',
    'if_quote_is_emailed_while_draft'                 => 'Als een citaat per e-mail wordt verzonden in de conceptstatus',

    // 2018-4
    'force_https'                                     => 'Forceer HTTPS',
    'force_https_help'                                => 'Voordat u deze optie inschakelt, moet u ervoor zorgen dat uw FusionInvoice installatie functioneert via https. Als u dit niet doet, kan dit resulteren in een niet-functionele (maar herstelbare) installatie.',

    // 2019-1
    'attached_to'                                     => 'Bijgevoegd aan',
    'customer'                                        => 'Klant',
    'expense'                                         => 'Uitgave',
    'expense_categories'                              => 'Onkosten categorieën',
    'expense_category_form'                           => 'Onkosten categorie formulier',
    'expense_vendors'                                 => 'Onkosten verkopers',
    'expense_vendor_form'                             => 'Onkosten leverancier formulier',
    'lead'                                            => 'Potentieel',
    'local_time'                                      => 'Lokale tijd',
    'prospect'                                        => 'Vooruitzicht',
    'search_clients'                                  => 'Zoek klanten',
    'search_expenses'                                 => 'Zoek kosten',
    'search_invoices'                                 => 'Zoek facturen',
    'search_items'                                    => 'Zoek items',
    'search_log'                                      => 'Zoek logboek',
    'search_quotes'                                   => 'Zoek offertes',
    'search_payments'                                 => 'Zoek Betalingen',
    'search_recurring_invoices'                       => 'Zoek terugkerende facturen',
    'show_all_statuses'                               => 'Toon alle statussen',
    'show_all_types'                                  => 'Toon alle typen',
    'unknown'                                         => 'Onbekend',
    'value'                                           => 'Waarde',

    // 2019-2
    'default'                                         => 'Standaard',
    'no_data_available'                               => 'Geen data beschikbaar',
    'recurring_invoice_list'                          => 'Terugkerende factuurlijst',
    'report_total'                                    => 'Rapport totalen',

    //2019-3
    'checkbox'                                        => 'Selectievakje',
    'custom_dropdown_validate'                        => 'Selecteer een geldige optie in het veld :label',
    'custom_image_validate'                           => 'Selecteer een geldige afbeelding.',
    'custom_tag_validate'                             => 'Selecteer een geldig label van :label',
    'custom_text_validate'                            => 'Voer een geldige :label in het veld :label in.',
    'datetime'                                        => 'Datum Tijd',
    'decimal'                                         => 'Decimaal',
    'delete-confirm'                                  => 'Weet je het zeker?',
    'grand_total'                                     => 'Eindtotaal',
    'image'                                           => 'Afbeelding',
    'integer'                                         => 'Geheel getal',
    'mailed'                                          => 'Gemaild',
    'mailed_invoices'                                 => 'Gemailde Facturen',
    'radio'                                           => 'Keuzerondje',
    'recurring_id'                                    => 'Periodiek ID',
    'remove_image'                                    => 'Afbeelding verwijderen',
    'tags'                                            => 'Label',
    'tagselection'                                    => 'Tag selectie',
    'unpaid'                                          => 'Onbetaald',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Gemailde facturen bekijken',
    'important'                                       => 'Belangrijk!',
    'created_recurring_invoice_id'                    => 'Gemaakt van Periodieke Factuur ID',
    'mr'                                              => 'Dhr.',
    'miss'                                            => 'Juffrouw',
    'ms'                                              => 'Mevrouw',
    'mrs'                                             => 'Mevrouw',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Contact Titel',
    'title'                                           => 'Titel',
    'test_email_subject'                              => 'Hallo van FusionInvoice!',
    'test_email_body'                                 => 'Dit is een test e-mail van FusionInvoice.',
    'test_email_address'                              => 'Verstuur e-mailmail test naar',
    'send_test_email'                                 => 'Verstuur e-mail test',
    'invalid_json'                                    => 'Vul aub een geldige JSON string in',
    'textarea_rows_limit'                             => 'Rijen kunnen niet overschreden worden :limit',
    'custom_integer_validate'                         => ':label moet een geldige gehele waarde zijn',

    //2020-1
    'user_role'                                       => 'Gebruikersrol',
    'standard_user'                                   => 'Standaard gebruiker',
    'permissions'                                     => 'Rechten',
    'modules'                                         => 'Modules',
    'is_view'                                         => 'Bekijken',
    'is_create'                                       => 'Aanmaken',
    'is_update'                                       => 'Bijwerken',
    'is_delete'                                       => 'Verwijderen',
    'dashboards'                                      => 'Dashboards',
    'allow_time_period_change'                        => 'Tijdperiode wijzigen toestaan',
    'page_not_found'                                  => 'Oops! Pagina niet gevonden.',
    'return_to_dashboard'                             => 'We konden de pagina die u zocht niet vinden. <a href=":dashboard_link">Terug naar dashboard</a>.',
    'no_auth_to_create_client'                        => 'U bent niet gemachtigd om klanten aan te maken!',
    'check-all'                                       => 'Alles aanvinken',
    'invoice_prefix'                                  => 'Factuur voorvoegsel',
    'recently_viewed'                                 => 'Recent bekeken',
    'copy_from'                                       => 'Kopieer van',
    'select_user'                                     => 'Selecteer gebruiker',
    'please_select_user'                              => 'Selecteer een gebruiker uit de lijst',
    'allow_client_center_login'                       => 'Sta Klant Omgeving Login toe',
    'online_payment_processing_fee'                   => 'Online Betaling Verwerkingsvergoeding',
    'client_password_required'                        => 'Voer klant wachtwoord in',
    'last_login_at'                                   => 'Laatste Login Op',
    'show_notes_panel_below_client'                   => 'Toon Notities Panel onder Klant Details',
    'notepad'                                         => 'Notietieblok',
    'added'                                           => 'Bijgevoegd',
    'last_edited'                                     => 'Laatst bijgewerkt',
    'loading'                                         => 'Verwerken ....',
    'n_records_match'                                 => ':label Gegeven:plural gevonden',
    'initials'                                        => 'Initialen',
    'initials_bg_color'                               => 'Initialen achtergrond kleur',
    'more'                                            => 'Meer',
    'must_match_all'                                  => 'Moet aan alle criteria voldoen',
    'clear'                                           => 'Selectie wissen',
    'no_client_tags'                                  => 'Er zijn geen klant records met labels gedefinieerd.',
    'qr_code_on_invoice_quote'                        => 'QR-Code op factuur en offerte',
    'delete_tags'                                     => 'Labels opruimen',
    'orphan_tags_deleted'                             => 'Alle niet verbonden labels succesvol verwijderd van het systeem.',
    'orphan_tags_delete_confirm'                      => 'Als u \'Labels opruimen\' uitvoert, worden alle ongebruikte labels verwijderd van klanten en notities. Doorgaan?',
    'deleting_tags_wait'                              => 'Labels worden verwijderd, even wachten...',
    'new-version-available'                           => 'Nieuwe versie beschikbaar!',
    'ignore-this-version'                             => 'Negeer deze versie',
    'view-release-notes'                              => 'Bekijk versie nota\'s',
    'task_list'                                       => 'Takenlijst',
    'create_task'                                     => 'Taak Aanmaken',
    'open'                                            => 'Open',
    'closed'                                          => 'Gesloten',
    'assignee'                                        => 'Toegewezen aan',
    'task'                                            => 'Taak',
    'task_successfully_created'                       => 'Taak successfully aangemaakt',
    'task_successfully_updated'                       => 'Taak successfully bijgewerkt',
    'task_completed'                                  => 'Taak succesvol voltooid',
    'task_marked_incomplete'                          => 'Taak heropend',
    'due_date_validation_date'                        => 'Selecteer een geldige vervaldatum',
    'assignee_validation_required'                    => 'Selecteer een geldige toe te wijzen persoon uit de lijst',
    'assignee_validation_exists'                      => 'Selecteer een geldige toe te wijzen persoon uit de lijst',
    'tomorrow'                                        => 'Morgen',
    'task_not_authorized'                             => 'U bent niet gemachtigd om deze taak te wijzigen!',
    'me'                                              => 'Mijzelf',
    'task_from_note'                                  => 'Taak aanmaken bij Opslaan',
    'done'                                            => 'Gereed',
    'refresh'                                         => 'Verversen',
    'task_list_page_size'                             => 'Aantal taken per pagina',
    'select_client'                                   => 'Selecteer Klant',
    'note-search-config'                              => 'Notitie zoekopdracht bevat',
    'username'                                        => 'Gebruikersnaam',
    'task-search-config'                              => 'Taak zoekopdracht bevat',
    'task_section_invalid'                            => 'Ongeldige taak sectie',
    'task_section'                                    => 'Taak sectie',
    'select_section'                                  => 'Selecteer sectie',
    'email-test-failed'                               => 'Email test mislukt',
    'smtp-setting-suggestion'                         => 'Suggesties: <br> 1. Controleer en voer uw gebruikersnaam/wachtwoord waarden opnieuw in<br>2. Controleer of uw SMTP-instellingen correct zijn ingevoerd',
    'mail-setting-suggestion'                         => 'Suggesties: <br> 1. Controleer of de PHP Mail-server correct is geconfigureerd<br>2. Neem contact op met serverbeheerder',
    'sendmail-setting-suggestion'                     => 'Suggesties: <br> 1. Controleer of uw Sendmail-pad correct is geconfigureerd.<br>2. Neem contact op met serverbeheerder',
    'sendgrid-setting-suggestion'                     => 'Suggesties:<br>1. Controleer of uw Sendgrid-sleutel correct is geconfigureerd.<br>2. Contact server admin',
    'later'                                           => 'Later',
    'test-email-required'                             => 'U moet een geldige e-mail invoeren om de test naar te sturen.',
    'test_mail_sent_successfully'                     => 'Test e-mail succesvol verzonden',
    'test-mail-btn-title'                             => 'Wijzigingen moeten worden opgeslagen voordat u gaat testen.',
    'agreement_expire'                                => 'Uw product update en ondersteuning verlopen op :date',
    'agreement_expired'                               => 'Uw product update en ondersteuning zijn verlopen op :date',
    'piracy_message'                                  => 'Uw FusionInvoice licentiesleutel is niet geldig. Software piraterij is een misdaad. Wees alsjeblieft eerlijk. Met een geldige licentie ontvangt u ondersteuning, updates en een goed karma.',
    'buy-now'                                         => 'Koop Nu',
    'piracy_alert'                                    => 'Wees alsjeblieft eerlijk!',
    'agreement-expire-alert'                          => 'Product updates en ondersteuning verlopen binnenkort.',
    'agreement-expired-alert'                         => 'Product updates en ondersteuning zijn verlopen.',
    'dismiss-forever'                                 => 'Voor altijd afwijzen',
    'renew-now'                                       => 'Vernieuw Nu',
    'select_all_permissions'                          => 'Selecteer alle rechten',
    'app-key-missing'                                 => 'Voer uw licentiesleutel in config/app.php.',
    'custom_fields_column_width'                      => 'Aangepaste velden kolommen weergave',
    'select-user-type'                                => 'Selecteer Gebruikerstype',
    'lead-or-prospect-with-invoices-error'            => 'Sorry, een klant type kan geen potentiëel of vooruitzicht zijn als er facturen of terugkerende facturen bestaan.',
    'sendgrid_key'                                    => 'Sendgrid sleutel',

    //2020-2.0
    'space'                                           => 'Spatie',
    'apostrophe'                                      => 'Apostrofe',
    'comma'                                           => 'Komma',
    'fullstop'                                        => 'Punt (volledige stop)',
    'middledot'                                       => 'Hoge punt',
    'thinspace'                                       => 'Dunne spatie',
    'narrow-no-break-space'                           => 'Niet-afbrekende spatie',
    'dotabove'                                        => 'Diakritische Punt',
    'arabic-decimal'                                  => 'Arabisch decimaalteken',
    'arabic-thousand'                                 => 'Arabisch duizendtal scheidingsteken',
    'decimal-separator-key-symbol'                    => 'Symbool voor decimaal scheidingsteken',
    'select-item'                                     => 'Selecteer item',
    'item-lookup-overload'                            => 'Maximaal 100 items toegestaan voor het opzoeken van items',
    'select-expense-category'                         => 'Selecteer Uitgavencategorie',
    'select-expense-vendor'                           => 'Selecteer Uitgaven Verkopers',
    'can-not-delete-all-users'                        => 'Sorry, je kunt niet alle gebruikers uit het systeem verwijderen',
    'can-not-change-default-user-role'                => 'Sorry, u kunt de standaard gebruikersrol niet wijzigen',
    'can-not-change-default-user-status'              => 'Sorry, je kunt de standaard gebruikersstatus niet wijzigen',
    'user_not_active'                                 => 'Gebruiker is niet actief',
    'can-not-inactive-your-own-status'                => 'Sorry, je kunt jezelf niet inactief maken.',
    'delete_user_warning'                             => '<p>STOP! Het verwijderen van deze gebruiker is een destuctieve actie waardoor records die ze in het systeem hebben gemaakt, kunnen worden verwijderd. Overweeg om de gebruiker in plaats daarvan inactief te maken. </p> <p> Weet u zeker dat u deze gebruiker wilt verwijderen?</p>',
    'include_time_in_due_date'                        => 'Tijd in vervaldatum opnemen',
    'cannot_delete_default_company'                   => 'U kunt het standaard bedrijfsprofiel niet verwijderen',
    'make-user-inactive'                              => 'Maak gebruiker inactief',
    'mail_from_address'                               => 'E-mail Van adres',
    'mail_from_name'                                  => 'E-mail Van naam',
    'item_categories'                                 => 'Artikel categorieën',
    'select-item-category'                            => 'Selecteer Item Categorie',
    'item_category_form'                              => 'Item categorie formulier',
    'sort_by_due'                                     => 'Sorteer op vervaldatum',
    'affiliate'                                       => 'Partner',
    'parent_account'                                  => 'Bovenliggend account',
    'child_account'                                   => 'Onderliggend accounts',
    'select_parent_client'                            => 'Selecteer bovenliggend account',
    'record_successfully_retrieved'                   => 'Record succesvol opgehaald',
    'custom-image-not-support'                        => 'Aangepast afbeeldingsveld niet ondersteund',
    'custom-tag-not-support'                          => 'Aangepast tag veld wordt niet ondersteund',
    'custom-checkbox-not-support'                     => 'Aangepast selectievakje veld niet ondersteund',
    'custom-date-not-support'                         => 'Aangepast datum veld wordt niet ondersteund',
    'custom-datetime-not-support'                     => 'Aangepast datumtijd veld niet ondersteund',
    'timeline'                                        => 'Tijdlijn',
    'client_invoice'                                  => 'Facturen per klant',
    'select_client_blank_for_all'                     => 'Selecteer Klant (blanco voor iedereen)',
    'invoice_email_success'                           => 'Factuur e-mail succesvol verzonden',
    'quote_email_success'                             => 'Offerte e-mail succesvol verzonden',
    'document_number_schemes'                         => 'Document nummering',
    'document_number_scheme'                          => 'Schema documentnummers',
    'document_number_scheme_form'                     => 'Schema documentnummers formulier',
    'default_document_number_scheme'                  => 'Standaard schema documentnummers',
    'supporting_data'                                 => 'Ondersteunende gegevens',
    'customizations'                                  => 'Aanpassingen',
    'utilities_and_logs'                              => 'Hulpprogramma\'s en logboeken',
    'system_log'                                      => 'Systeem logboek',
    'paid_amount'                                     => 'Betaald bedrag',
    'payment_amount'                                  => 'Betaling bedrag',
    'payment_intent'                                  => 'Betaling intentie',
    'apply_payment_to_one_or_more_invoice'            => 'Betaling toepassen op een of meer facturen',
    'pre_payment_for_future_invoices'                 => 'Vooruitbetaling voor toekomstige facturen',
    'apply_to_invoices'                               => 'Toepassen op factu(u)r(en)',
    'payment_application'                             => 'Betaling aanvraag',
    'remaining_payment_balance'                       => 'Resterend betaling saldo',
    'remaining_balance'                               => 'Resterend saldo',
    'payment_warning'                                 => 'Voer een bedrag in',
    'apply_pre_payment_warning'                       => 'U heeft de betaling niet toegepast op enige facturen. Wilt u deze vastleggen als vooruitbetaling?',
    'confirm_remaining_balance'                       => 'Het resterende saldo van :value zal beschikbaar zijn voor toekomstige facturen voor deze klant.',
    'open_balance'                                    => 'Openstaand saldo',
    'more_figure_then_total_payment'                  => 'Voer de betaling opnieuw in, uw totale factuurbedrag is hoger dan het resterende saldo.',
    'remaining_payment_balance_apply_later_info'      => 'Resterende betalingssaldi kunnen later op andere facturen worden toegepast.',
    'invoice_balance'                                 => 'Factuur saldo',
    'enter_payment_for_invoice'                       => 'Voer de betaling in voor factuur',
    'invoice_pdf'                                     => 'Factuur pdf',
    'payment_applications'                            => 'Betaal applicaties',
    'multiple'                                        => 'Meerdere',
    'ok'                                              => 'OK',
    'credit_memo_default'                             => 'Kredietnota standaard',
    'edit_payment'                                    => 'Bewerk betaling',
    'credit_memo'                                     => 'Kredietnota',
    'credit_memos'                                    => 'Creditnota\'s',
    'create_credit_memo'                              => 'kredietnota aanmaken',
    'credit_applications'                             => 'Kredietnota aanvragen',
    'credit_applications_for_invoice'                 => 'Kredietnota aanvragen voor factuur',
    'prepayment_applications_for_invoice'             => 'Vooruitbetaling aanvragen voor factuur',
    'apply_credit_memo'                               => 'Kredietnota toepassen',
    'apply_pre_payment'                               => 'Vooruitbetaling toepassen',
    'applied_amount'                                  => 'Toegepast bedrag',
    'remaining_credit_balance'                        => 'Resterend creditsaldo',
    'remaining_credit_balance_apply_later_info'       => 'Resterende tegoeden kunnen later op andere facturen worden toegepast.',
    'applied'                                         => 'Toegepast',
    'more_figure_then_invoice_amount'                 => 'Voer het bedrag opnieuw in, het bedrag mag niet hoger zijn dan het factuurbedrag.',
    'more_figure_then_invoice_total'                  => 'Voer het bedrag opnieuw in, het totale toegepaste bedrag kan niet hoger zijn dan het factuurbedrag.',
    'invoice_not_selected_warning'                    => 'Wacht, u heeft de kredietnota niet op facturen toegepast.',
    'select_type'                                     => 'Selecteer type',
    'email_credit_memo'                               => 'Kredietnota  e-mailen',
    'back_to_credit_memo'                             => 'Terug naar kredietnota',
    'invoice_amount'                                  => 'Factuurbedrag',
    'remaining_invoice_amount'                        => 'Resterend factuurbedrag',
    'settlement_for_credit_memo'                      => 'Verrekening voor kredietnota',
    'credit_memo_amount'                              => 'Kredietnota bedrag',
    'confirm_remaining_balance_invoice'               => 'Het resterende saldo voor deze factuur is :value na verrekening.',
    'payment_receipt_for_invoices'                    => 'Betaalbewijs voor facturen',
    'primary_phone'                                   => 'Primair telefoonnummer',
    'alternate_phone'                                 => 'Alternatief telefoonnummer',
    'currency_not_match'                              => 'Valuta komt niet overeen',
    'tasks'                                           => 'Taken',
    'full_and_final_payment'                          => 'volledig en definitief',
    'partial'                                         => 'gedeeltelijk',
    'transition'                                      => [
        'created'          => 'Aangemaakt',
        'updated'          => 'Bijgewerkt',
        'deleted'          => 'Verwijderd',
        'received'         => 'Ontvangen',
        'opened'           => 'Geopend',
        'sent'             => 'Verzonden',
        'mail'             => 'Gemaild',
        'changed'          => 'Veranderd',
        'recurring'        => 'Gemaakt',
        'completed'        => 'Voltooid',
        'reversed'         => 'Omgekeerd',
        'quote_to_invoice' => 'Offerte om te factureren',
        'download'         => 'Downloaden',
        'added'            => 'Toegevoegd',
        'email'            => 'E-mail',
        'merge'            => 'Samenvoegen',
        'billed'           => 'Gefactureerd',
        'failed'           => 'Mislukt',
        'invoice'          => [
            'created'                => 'Factuur :invoice_number is aangemaakt',
            'credit_memo_created'    => 'Kredietnota :credit_memo_number is gemaakt',
            'credit_memo_updated'    => 'Kredietnota :credit_memo_number is gewijzigd',
            'created_from_recurring' => 'Factuur :invoice_number is gemaakt (van terugkerende sjabloon :recurring_invoice_id)',
            'updated'                => 'Factuur :invoice_number is gewijzigd',
            'deleted'                => 'Factuur :invoice_number is verwijderd',
            'credit_memo_deleted'    => 'Kredietnota :credit_memo_number is verwijderd',
            'status_changed'         => 'Factuur :invoice_number Status gewijzigd van :previous_value in :current_value',
            'email_sent'             => 'Factuur :invoice_number e-mail verzonden',
            'resend_email'           => 'Factuur :invoice_number e-mail opnieuw verzonden',
            'email_opened'           => 'Factuur :invoice_number e-mail geopend',
            'payment_updated'        => 'Factuur :invoice_number bijgewerkt :full_payment_text betaling',
            'payment_received'       => 'Factuur :invoice_number ontvangen :full_payment_text betaling',
            'payment_reversed'       => 'Factuur :invoice_number had een :full_payment_text',
            'invoice_tag_updated'    => 'Factuurtag :tags is toegevoegd aan factuur :invoice_number',
            'invoice_tag_deleted'    => 'Factuurtag :invoice_number is verwijderd :tags',
            'mark_mail'              => 'Factuur :invoice_number markeren als verzonden',
            'unmark_mail'            => 'Factuur :invoice_number maskeer als niet gemaild',
            'paid_invoice_opened'    => 'Betaalde factuur is geopend voor bewerking',
            'sent_invoice_opened'    => 'Verzonden factuur is geopend voor bewerking',
            'sms_sent'               => 'Factuur :invoice_number SMS verzonden',
        ],
        'quote'            => [
            'created'           => 'Offerte :quote_number is gemaakt',
            'updated'           => 'Offerte :quote_number is gewijzigd',
            'deleted'           => 'Offerte :quote_number is verwijderd',
            'status_changed'    => 'Offerte :quote_number Status gewijzigd van :previous_value in :current_value',
            'email_sent'        => 'Offerte :quote_number e-mail verzonden',
            'resend_email'      => 'Quote :quote_number e-mail opnieuw verzenden',
            'email_opened'      => 'Offerte :quote_number e-mail geopend',
            'quote_to_invoice'  => ':quote_number is omgezet in een factuur - :invoice_number',
            'quote_tag_updated' => 'Citaattag :tags is toegevoegd aan citaat :quote_number',
            'quote_tag_deleted' => 'Citaattag :quote_number is verwijderd :tags',
            'sms_sent'          => 'Citaat :quote_number SMS verzonden',
        ],
        'payment'          => [
            'prepayment_created'           => 'Vooruitbetaling is gemaakt',
            'payment_receipt_email_sent'   => 'E-mail met betaalbewijs verzonden',
            'payment_receipt_resend_email' => 'E-mail met betalingsbewijs opnieuw verzonden',
            'payment_updated'              => 'Betaling werd gewijzigd',
            'deleted'                      => 'Betaling werd verwijderd',
            'payment_receipt_pdf_download' => 'Betalingsbewijs pdf downloaden',
            'payment_note_deleted'         => 'Betalingsnota verwijderd:',
            'payment_note_added'           => 'Betalingsnota toegevoegd:',
            'payment_note_updated'         => 'Betalingsnota bijgewerkt vanaf',
            'payment_failed'               => 'Betaling mislukt',
        ],
        'client'           => [
            'client_created'     => ':client_type is gemaakt',
            'type_changed'       => ':previous_value werd een :current_value',
            'updated'            => 'Klant werd bijgewerkt',
            'deleted'            => 'Klant is verwijderd',
            'status_changed'     => 'Klant ingesteld op :current_value',
            'client_tag_updated' => 'Tag :tags toegevoegd',
            'client_tag_deleted' => 'Tag :tags verwijderd',
            'merge'              => 'Klant-ID: :idTo - :nameTo is samengevoegd met Klant-ID: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'Onkost werd aangemaakt',
            'updated' => 'Onkost werd zijn gewijzigd',
            'deleted' => 'Onkost werd verwijderd',
            'billed'  => 'Onkost werd in rekening gebracht',
            'vendor'  => [
                'created' => 'Onkostenleverancier is gemaakt',
                'updated' => 'Onkostenleverancier is gewijzigd',
                'deleted' => 'Onkostenleverancier is verwijderd',
            ],
        ],
        'note'             => [
            'created'          => 'Notitie werd aangemaakt',
            'updated'          => 'Notitie werd gewijzigd',
            'deleted'          => 'Notitie werd verwijderd',
            'note_tag_updated' => 'Tag :tags toegevoegd aan notitie',
            'note_tag_deleted' => 'Tag :tags verwijderd uit notitie',
        ],
        'task'             => [
            'created'   => 'Taak werd aangemaakt',
            'updated'   => 'Taak werd gewijzigd',
            'deleted'   => 'Taak werd verwijderd',
            'completed' => 'Taak werd voltooid',
        ],
        'subscription'     => [
            'created'                       => 'Abonnement :invoice_number is aangemaakt',
            'updated'                       => 'Abonnement :invoice_number is aangepast',
            'deleted'                       => 'Abonnement :invoice_number is verwijderd',
            'recurring_invoice_tag_updated' => 'Abonnementtag :tags is toegevoegd aan abonnement :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'Abonnementtag :recurringInvoice_number is verwijderd :tags',
        ],
        'attachment'       => [
            'created' => ':filename is geüpload als bijlage',
            'deleted' => ':filename is verwijderd als bijlage',
        ],
        'tag'              => [
            'created' => 'De tag :tag is toegevoegd',
            'deleted' => 'De tag :tag is verwijderd',
        ],
    ],
    'reset'                                           => 'Herinstellen',
    'select_event'                                    => 'Selecteer gebeurtenistype',
    'select_country'                                  => 'Selecteer een land',
    'type_captcha'                                    => 'Beantwoord de bovenstaande vraag',
    'refresh_captcha'                                 => 'Vernieuw vraag',
    'answer'                                          => 'Antwoord',
    'use_captcha_in_login'                            => 'Gebruik captcha in login',
    'allow_client_timeline'                           => 'Tijdlijn',
    'client_timeline'                                 => 'Tijdlijn',
    'no_invoice_tags'                                 => 'Er zijn geen factuur labels.',
    'total_notifications'                             => 'Je hebt :total aantal meldingen',
    'no_notifications'                                => 'Er is geen nieuwe melding',
    'notifications'                                   => 'Meldingen',
    'notification'                                    => [
        'task'  => [
            'created'           => 'Een nieuwe taak toegewezen aan jou',
            'due_date_breached' => 'De taak',
            'completed'         => ':user voltooide taak:',
        ],
        'quote' => [
            'approved'             => ':quote_number is goedgekeurd',
            'quote_to_invoice'     => ':quote_number is geconverteerd naar een factuur -',
            'rejected'             => ':quote_number is afgewezen',
            'payment_successfully' => 'Offerte :quote_number voor klant :client_name is betaald. Factuur :invoice_number is aangemaakt en de betaling is toegepast',
        ],
    ],
    'search_tasks'                                    => 'Zoek taken',
    'reopen_task'                                     => 'Heropen taak',
    'task_form'                                       => 'Taak toevoegen',
    'view_task'                                       => 'Taak details',
    'client_deleted'                                  => 'Klant werd verwijderd',
    'payment_canceled'                                => 'Uw betaling werd geannuleerd',
    'default_company_profile_set'                     => 'We hebben uw standaard bedrijfsprofiel ingesteld. U kunt het op elk moment bijwerken via de instellingen van het bedrijfsprofiel.',
    'file_uploaded_successfully'                      => 'bestand succesvol geüpload',
    'attachment_notice'                               => 'Maximale bestandsgrootte van bijlagen kleiner dan of gelijk aan :size',
    'attachment_error'                                => 'Bijlage grootte mag niet groter zijn dan :size',
    'attachment_warning'                              => 'Bijlage grootte is :size. Het uploaden van veel grote bijlagen kan de prestaties van uw database na verloop van tijd verminderen.',
    'generate_timeline_history'                       => 'Genereer tijdlijn geschiedenis',
    'generating_timeline_wait'                        => 'Tijdlijn wordt gegenereerd, even geduld ...',
    'generating_timeline_confirm'                     => 'De tijdlijn functie is toegevoegd in FusionInvoice 2020. Dit genereert tijdlijn vermeldingen voor alle activiteiten die voorafgingen aan die functie toevoeging. Doorgaan?',
    'generated_timeline_request_accepted'             => 'Het genereren van de tijdlijngeschiedenis is voltooid.',
    'transitions'                                     => 'Overgangen',
    'pending'                                         => 'In afwachting',
    'client_transition'                               => 'Klant tijdlijnen',
    'expense_transition'                              => 'Uitgave tijdlijnen',
    'invoice_transition'                              => 'Factuur tijdlijnen',
    'payment_invoice_transition'                      => 'Factuur betaling tijdlijnen',
    'payment_transition'                              => 'Betaling tijdlijnen',
    'quote_transition'                                => 'Offerte tijdlijnen',
    'note_transition'                                 => 'Notitie tijdlijnen',
    'task_transition'                                 => 'Taak tijdlijnen',
    'email_sent'                                      => 'E-mail verzonden',
    'credit_applied'                                  => 'Krediet toegepast',
    'configuration'                                   => 'Configuratie',
    'include_prepayments'                             => 'Inclusief vooruitbetalingen',
    'pre_payment'                                     => 'Vooruitbetalingen',
    'pre_payments'                                    => 'Vooruitbetalingen',
    'times'                                           => 'Keer',
    'include_prepayments_applied'                     => 'Inclusief vooruitbetalingen toegepast',
    'confirm_full_payment_applied'                    => 'De betaling is volledig toegepast',
    'confirm_full_credit_memo_applied'                => 'Creditnota is volledig toegepast',
    'all_tasks'                                       => 'Alle taken',
    'my_tasks'                                        => 'Mijn taken',
    'assigned_from_others'                            => 'Toegewezen door anderen',
    'full_payment_reversed'                           => 'volledige betaling teruggedraaid.',
    'partial_payment_reversed'                        => 'gedeeltelijke betaling teruggedraaid.',
    'invoice_delete_error'                            => 'Sorry, u kunt geen factuur verwijderen die betalingen of creditnota-aanvragen bevat. U moet eerst de betalingen of creditnota-aanvragen verwijderen.',
    'mail-from-required'                              => 'U moet een geldige e-mail van e-mail invoeren',
    'contact_updated'                                 => 'Contact succesvol bijgewerkt',
    'contact_added'                                   => 'Contact succesvol toegevoegd',
    'generate_passport_key_wait'                      => 'Paspoortsleutel genereren, even geduld ...',
    'generate_passport_key'                           => 'Genereer paspoortsleutel',
    'default_greeting'                                => 'Hallo daar!<br>',
    'hi'                                              => 'Hallo,',
    'deduct_tax_from_expenses'                        => 'Trek BTW af van uitgaven',
    'invalid_invoice_id'                              => 'Ongeldig factuur id',
    'client_related_record_exist'                     => 'Sorry, de klant heeft gerelateerde records voor: :modules. Klanten met transactiegeschiedenis kunnen niet worden verwijderd.',
    'email_payment_receipt_notice'                    => 'De klant heeft geen e-mailadres geregistreerd',
    'show_more'                                       => 'Toon meer ...',
    'show_less'                                       => 'Toon minder ...',
    'invoice_already_paid'                            => 'Factuur is reeds betaald!',
    'system_default'                                  => 'Systeemfout',
    'created_by'                                      => 'Gemaakt door',
    'created_at'                                      => 'Gemaakt bij',
    'task_created_by_and_created_at'                  => 'Taak gemaakt door :created_by op :created_at',
    'dashboard_widgets_date_options'                  => 'Systeem standaard tijdsperiode voor factuur- en offerteoverzicht',
    'dashboard-widget-from-date-required'             => 'De \'vanaf\' datum is vereist wanneer een aangepast datumbereik is geselecteerd bij Systeem standaard tijdsperiode voor factuur- en offerteoverzicht',
    'dashboard-widget-to-date-required'               => 'De \'Tot\' datum is vereist wanneer een aangepast datumbereik is geselecteerd in Systeem standaard tijdsperiode voor factuur- en offerteoverzicht',
    'invoice_currency'                                => 'Factuur valuta',
    'currency_format'                                 => 'Valuta indeling',
    'create_missing_folder_success'                   => 'Ontbrekende vereiste map gemaakt',
    'create_missing_folder_failed'                    => 'Poging om map(pen) te maken is mislukt :path',
    'folder_is_not_writable'                          => 'Map is niet schrijfbaar :path',
    'update_item_as_lookup'                           => 'Update item zoeken',
    'number_of_tax_fields'                            => 'Aantal BTW velden',
    'tax_1_entry'                                     => '1 ingave',
    'tax_2_entries'                                   => '2 ingaves',
    'require_tags_on_client_notes'                    => 'Label(s) op klantnotities vereisen',
    'entered_amount_less_than_invoice_amount'         => 'Het ingevoerde bedrag moet kleiner zijn dan of gelijk zijn aan het factuurbedrag',
    'send-to'                                         => 'Verzenden naar',
    'print'                                           => 'Afdrukken',
    'pdf_cleanup'                                     => 'PDF opschonen',
    'pdf_cleanup_confirm'                             => 'Weet u zeker dat u oude PDF-bestanden wilt opschonen?',
    'pdf_cleanup_success'                             => 'PDF opschonen voltooid',
    'deleting_pdf_wait'                               => 'Oude PDF-bestanden verwijderen, even geduld ...',
    'open_invoices'                                   => 'Open facturen',
    'open_credits'                                    => 'Open tegoeden',
    'unapplied_payments'                              => 'Niet-toegepaste betalingen',
    'attach_invoice_pdf'                              => 'Factuur PDF bijvoegen',
    'upcoming_payment_notice'                         => 'Aanstaande betalingsmededeling',
    'select_mapping'                                  => 'Selecteer Toewijzing',
    'select_named_export'                             => 'Selecteer Benoemd exporteren',
    'save_mapping'                                    => 'Kaart opslaan',
    'add_mapping'                                     => 'Nieuwe toewijzing maken',
    'edit_mapping'                                    => 'Toewijzing bijwerken',
    'save_as_default_mapping'                         => 'Standaardtoewijzing',
    'save_as_default_export'                          => 'Standaard export',
    'export_item_lookups'                             => 'Artikelzoekacties exporteren',
    'import_file_selection'                           => 'Bestandsselectie importeren',
    'next'                                            => 'Volgende',
    'delete_import_mapping_warning'                   => 'Weet u zeker dat u deze toewijzing wilt verwijderen?',
    'export'                                          => 'Exporteren',
    'named_exports'                                   => 'Benoemde export',
    'save_named_export'                               => 'Benoemde export opslaan',
    'delete_named_export'                             => 'Benoemde export verwijderen',
    'updated_at'                                      => 'Bijgewerkt op',
    'zip'                                             => 'Zip',
    'fields_to_export'                                => 'Velden om te exporteren',
    'import-file-type-error'                          => 'Het importbestandstype moet CSV zijn',
    'recurring_invoice_items'                         => 'Terugkerende factuuritems',
    'important_details'                               => 'Belangrijke details',
    'important_information'                           => 'Belangrijke informatie',
    'item_lookups_important_information'              => '<p>Als tijdens de CSV-import een overeenkomende item-opzoeknaam wordt gevonden in de bestaande gegevens, mislukt de importbatch en wordt het item weergegeven dat de fout heeft veroorzaakt.</p>',
    'invoices_important_information'                  => '<p>De naam van de klant (van de CSV) wordt opgezocht in de tabel Klanten en omgezet in client_id, als er een overeenkomende naam is. Als er geen naamovereenkomst wordt gevonden, wordt een klantinvoer gemaakt en wordt de ID van de nieuwe klantinvoer gebruikt</p><p>Factuurnummer,</p><p>Invoice_items zoekt het factuurnummer (uit de CSV) op in de factuurtabel en vertaalt dit naar de ID. Er worden geen andere zoekopdrachten/validaties voor sleutelvelden uitgevoerd</p>',
    'invoice_items_important_information'             => '<p>De import van factuur_items zoekt het factuurnummer (vanuit de CSV) in de factuurtabel op en vertaalt dit naar de juiste factuur-ID. De klant-ID wordt ook afgeleid van de overeenkomende factuurgegevens.</p>',
    'payments_important_information'                  => '<p>Voor het importeren van betalingen is een geldig, overeenkomend factuurnummer vereist om de betalingen op toe te passen. Als er geen overeenkomende factuur wordt gevonden, mislukt de volledige batchimport.</p><p>De juiste klanten-</p><p>Er wordt een zoekopdracht uitgevoerd op de naam van de betalingsmethode (van de CSV naar de tabel met betalingsmethoden) en zal, indien gevonden, worden omgezet in de juiste betalingsmethode-id. als er geen overeenkomende naam wordt gevonden, wordt een nieuwe betalingsmethoderecord gemaakt en wordt de nieuwe betalingsmethode-id gebruikt.</p>',
    'run_daily_tasks'                                 => 'Dagelijkse taken uitvoeren',
    'daily_task_ran'                                  => 'Dagelijkse taken zijn succesvol uitgevoerd',
    'csv_row_number'                                  => 'CSV-rijnummer :row',
    'max_item_lookup_records'                         => 'Maximaal Item opzoeken records',
    'invoice_with_commission_delete_error'            => 'Sorry, u kunt een factuur met provisieboekingen met een betaalde status niet verwijderen. Op deze factuur dient u eerst betaalde commissie te verwijderen.',
    'if_invoice_is_emailed_while_draft'               => 'Als de factuur per e-mail wordt verzonden terwijl deze in conceptstatus is',
    'custom_payment_receipt_body_not_exists'          => 'De aangepaste sjabloon voor betalingsbewijzen is niet gevonden.',
    'invoice_email_body_type'                         => 'Type factuur e-mail',
    'send_overdue_reminder'                           => 'Achterstallige herinnering sturen',
    'reminder_sent_successfully'                      => 'Herinnering succesvol verzonden',
    'error_sending_reminder'                          => 'Er is een fout opgetreden bij het verzenden van de herinnering, probeer het later opnieuw.',
    'expense_date'                                    => 'Onkostendatum',
    'group_by'                                        => 'Groeperen op',
    'timeline_scope_all_user'                         => 'Tijdlijnbereik - Alle gebruikers',
    'copy_to_clipboard'                               => 'Kopieer naar klembord',
    'text_copied_clipboard'                           => 'Tekst gekopieerd naar klembord!',
    'import_example_csv'                              => 'Een voorbeeld van een CSV-bestand vindt u hier',
    'import'                                          => 'Importeren',
    'address2'                                        => 'Adres 2',
    'use_parent_email'                                => 'Gebruik het e-mailadres van de ouder',
    'max_import_records'                              => 'Maximale limiet voor het importeren van records is :total_records',
    'demo_file_attachment_disabled'                   => 'Bestandsbijlagen zijn uitgeschakeld in de demo',
    'drag_drop_file'                                  => 'Sleuren',
    'or'                                              => 'OF',
    'browse_file'                                     => 'Bestand zoeken',
    'system_setting_and_ui'                           => 'Systeem instellingen',
    'localization_and_timezone'                       => 'Lokalisatie',
    'security'                                        => 'Veiligheid',
    'cleanup_and_backup'                              => 'Opruimen',
    'attach_quote_pdf'                                => 'Voeg offerte-pdf toe',
    'attach_payment_receipt'                          => 'Betalingsbewijs bijvoegen',
    'choose-file'                                     => 'Kies bestand',
    'important-note'                                  => 'Belangrijke notitie',
    'collapse'                                        => 'Instorten',
    'add_task'                                        => 'Voeg taak toe',
    'recurring_invoice_commissions'                   => 'Terugkerende factuurcommissies',
    'invoice_commissions'                             => 'Factuur commissies',
    'percentage'                                      => 'Percentage',
    'flat_amount'                                     => 'Vast bedrag',
    'discount-amount'                                 => 'Korting',
    'discount-type'                                   => 'Soort korting',
    'saving'                                          => 'Besparing...',
    'preparing'                                       => 'voorbereidingen treffen',
    'allow_line_item_discounts'                       => 'Regelitemkortingen toestaan',
    'invalid_price_amount'                            => 'Ongeldig prijsbedrag! Moet groter zijn dan 0.',
    'light-mode'                                      => 'Lichte modus',
    'dark-mode'                                       => 'Donkere modus',
    'system_base_currency'                            => 'Systeem basisvaluta',
    'is_recurring_task'                               => 'Is terugkerende taak',
    'contact_names'                                   => 'Contact Namen',
    'all_client'                                      => 'Alle klanten',
    'invoice_grand_total'                             => 'Factuur eindtotaal',
    'recurring_invoice_grand_total'                   => 'Eindtotaal periodieke factuur',
    'is_required'                                     => 'Is benodigd?',
    'add-new-client'                                  => 'Nieuwe klant toevoegen',
    'client_name_required'                            => 'Klantnaam is vereist',
    'custom_item_text_validate'                       => 'Voer een geldig item :label in het veld :label in.',
    'assigned_to_others'                              => 'Toegewezen aan anderen',
    'all_tasks_and_all_users'                         => 'Alle taken/Alle gebruikers',
    'statement'                                       => 'Uitspraak',
    'profile_code'                                    => 'Profielcode',
    'login-url'                                       => 'Inlog-URL',
    'url_copied_clipboard'                            => 'URL gekopieerd naar klembord!',
    'payment_receipt_email_sent'                      => 'E-mail met betalingsbewijs succesvol verzonden',
    'edit_payment_note_form'                          => 'Betalingsnota bewerken',
    'payment_invoices_text'                           => 'Bedankt! Uw betaling van :amount is toegepast op volgende facturen.',
    'payment_text'                                    => 'Bedankt voor uw betaling van :amount .',
    'date_filter_by'                                  => 'Datum Filter op',
    'filter_by_invoice_date'                          => 'Factuur datum',
    'filter_by_payment_date'                          => 'Betaaldatum',
    'date-range-required'                             => 'Selecteer een datumbereik',
    'save-and-complete'                               => 'Opslaan en voltooien',
    'completion-note'                                 => 'Voltooiing Opmerking',
    'complete-with-note'                              => 'Compleet met notitie',
    'placeholder_type_note'                           => 'Typ je notities...',
    'credit_memo_email_subject'                       => 'E-mailonderwerp creditnota',
    'default_credit_memo_email_body'                  => 'Standaard hoofdtekst e-mail creditnota',
    'show_invoices_from'                              => 'Toon facturen van',
    'system_mail_from_address'                        => 'Systeem Mail From-adres',
    'user_who_created_invoice'                        => 'Gebruiker die de factuur heeft gemaakt',
    'completed'                                       => 'Voltooid',
    'no_auth_to_view_task'                            => 'Deze taak staat niet meer in je lijst.',
    'credit-memo-and-prepayments'                     => 'Kredieten en vooruitbetalingen',
    'all_selected'                                    => 'Allemaal geselecteerd',
    'select_columns'                                  => 'Selecteer Kolommen',
    'column_settings'                                 => 'Kolom instellingen',
    'minimum_one_column_check_is_required'            => 'Selecteer ten minste één kolom',
    'date_of_entry'                                   => 'Datum van binnenkomst',
    'amount_applied'                                  => 'Bedrag toegepast',
    'date_applied'                                    => 'Datum toegepast',
    'copy_to_recurring_invoice'                       => 'Kopiëren naar terugkerende factuur',
    'top_bar_color'                                   => 'Kleur bovenbalk',
    'light_grey'                                      => 'Lichtgrijs',
    'bg-primary'                                      => 'Blauw',
    'bg-warning'                                      => 'Geel',
    'bg-info'                                         => 'Libelle Blauw',
    'bg-danger'                                       => 'Rood',
    'bg-success'                                      => 'Turf groen',
    'bg-indigo'                                       => 'Indigo',
    'bg-lightblue'                                    => 'Victoria blauw',
    'bg-navy'                                         => 'Marineblauw',
    'bg-purple'                                       => 'Paars',
    'bg-fuchsia'                                      => 'Fuchsia',
    'bg-pink'                                         => 'Roze',
    'bg-maroon'                                       => 'Kastanjebruin',
    'bg-orange'                                       => 'Oranje',
    'bg-lime'                                         => 'Limoen groen',
    'bg-teal'                                         => 'Wintertaling',
    'bg-olive'                                        => 'Olijf',
    'fee_name'                                        => 'Naam vergoeding',
    'fee_percentage'                                  => 'Vergoedingspercentage',
    'fee_explanation'                                 => 'Vergoeding Toelichting',
    'enable_online_payment_processing_fees'           => 'Verwerkingskosten voor online betalingen inschakelen',
    'allow_online_payment_processing_fees'            => 'Sta verwerkingskosten voor online betalingen toe',
    'allow_online_pay_fees'                           => 'Sta online betaalkosten toe',
    'convenience_charges'                             => 'Gemakskosten',
    'opp-fee-percentage-required'                     => 'Percentage verwerkingskosten voor online betalingen is vereist',
    'opp-fee-percentage-gt-zero'                      => 'Het percentage verwerkingskosten voor online betalingen moet groter zijn dan nul',
    'cron_error'                                      => 'mislukt bij :datetime',
    'cron_start'                                      => 'Dagelijkse taakloper begon bij :datetime',
    'notification_clear_all'                          => 'Wis alle meldingen',
    'show'                                            => 'Tonen',
    'report'                                          => 'Rapport',
    'profit_loss'                                     => 'Winst en verlies',
    'credit_and_pre_payments'                         => 'Kredieten en vooruitbetalingen',
    'expenses_vendors'                                => 'Onkosten leveranciers',
    'expenses_categories'                             => 'Onkosten categorieën',
    'create'                                          => 'Creëren',
    'import_map_clients'                              => 'Importeer kaartclients',
    'payctr_users'                                    => 'PaymentCenter-gebruikers',
    'ctrl_plus_click'                                 => 'Ctrl-klik om voltooiingsnotities toe te voegen',
    'edit_note'                                       => 'Opmerking bewerken',
    'save-and-unComplete'                             => 'Opslaan en onvoltooien',
    'sales_chart'                                     => 'Verkoop grafiek',
    'accumulate_totals'                               => 'Verzamel totalen',
    'do_not_accumulate_totals'                        => 'Verzamel geen totalen',
    'kpi_cards'                                       => 'KPI-kaarten',
    'no_data_to_display'                              => 'Geen gegevens om weer te geven',
    'choose_period'                                   => 'Kies Periode',
    'date_mailed'                                     => 'Datum gemaild',
    'date_emailed'                                    => 'Datum gemaild',
    'action'                                          => 'Actie',
    'mail'                                            => 'Mail',
    'mark_as_mailed'                                  => 'Markeren als verzonden',
    'invoice_mailed'                                  => 'Factuur is gemarkeerd als verzonden',
    'emailed'                                         => 'Gemaild',
    'paid_invoice_canceled_error'                     => 'Als u deze factuur wilt annuleren, verwijdert u betalingen van de factuur.',
    'allow_invoice_delete'                            => 'Factuur verwijderen toestaan',
    'allow_child_accounts'                            => 'Sta kinderaccounts toe',
    'third_party_bill_payer'                          => 'Factuurbetaler van derden',
    'invoices_paid_by'                                => 'Facturen betaald door',
    'use_third_party_bill_payer_email'                => 'Gebruik het e-mailadres van de rekeningbetaler van derden',
    'email_default'                                   => 'Standaard e-mail',
    'client_default'                                  => 'Klant Standaard',
    'clear-all'                                       => 'Wis alles',
    'system_log_is_missing_or_empty'                  => 'Systeemlogboek ontbreekt of is leeg',
    'change_to_draft'                                 => 'Verander naar Concept',
    'invoice_status_change_to_draft'                  => 'Factuurstatus gewijzigd in Concept',
    'there_is_some_error'                             => 'Er zijn enkele fouten',
    'filter_by_date'                                  => 'Filteren op datum',
    'quote_grand_total'                               => 'Citeer eindtotaal',
    'email_upcoming_payment_due_notice'               => 'E-mail aankomende betalingskennisgeving',
    'email_overdue_invoice_reminder'                  => 'E-mail herinnering achterstallige factuur',
    'page_totals'                                     => 'Pagina totalen',
    'categories'                                      => 'Categorieën',
    'conven_charges'                                  => 'conv. kosten',
    'invoice_status_change_to_cancel'                 => 'Factuurstatus Wijzigen in Annuleren',
    'filter_by_invoice_number'                        => 'Factuurnummer',
    'filter_by_client_name'                           => 'klantnaam',
    'custom_mail_template'                            => 'Aangepaste e-mailsjabloon',
    'invoice_use_custom_mail_template'                => 'Factuur Gebruik aangepaste e-mailsjabloon',
    'client_or_company_name'                          => 'Klant/Bedrijfsnaam',
    'view_invoice'                                    => 'Bekijk factuur',
    'tt_active'                                       => 'Als een klantrecord niet actief is, verschijnt deze niet in de standaard klantenlijst en zijn normale transacties niet toegestaan.',
    'tt_invoice_prefix'                               => 'Er wordt automatisch een unieke factuurvoorvoegselcode toegewezen aan een klantrecord wanneer deze wordt aangemaakt. Het kan later handmatig worden gewijzigd. Het kan worden gebruikt als onderdeel van uw documentnummeringsschema voor factuurnummering, waardoor een uniek factuurnummer per klant mogelijk is.',
    'tt_automatic_email_payment_receipts'             => 'Stuurt een betalingsbewijs per e-mail naar de klant bij het innen van een betaling. Een algemene instelling is beschikbaar binnen Systeeminstellingen, maar kan op individuele clientbasis worden overschreven.',
    'tt_automatic_email_on_recur'                     => 'Stuurt een factuur per e-mail naar de klant wanneer een terugkerende factuur wordt uitgevoerd en maakt een live factuur aan. Een algemene instelling is beschikbaar binnen Systeeminstellingen, maar kan op individuele clientbasis worden overschreven.',
    'tt_default_currency'                             => 'De valuta die is toegewezen aan dit klantaccount, die zal worden gebruikt voor hun factuur, offerte en betalingstransacties. Deze waarde is standaard afkomstig uit de systeeminstelling voor basisvaluta.',
    'tt_language'                                     => 'De taal die wordt weergegeven voor de klant wanneer deze inlogt in het klantencentrum.',
    'tt_allow_client_center_login'                    => 'Moet de klant kunnen inloggen op uw FusionInvoice-klantencentrum? Hun e-mailadres moet worden gebruikt voor hun gebruikersnaam en u moet een wachtwoord toewijzen. De URL van het klantencentrum is',
    'tt_timezone'                                     => 'Tijdzone voor de klant. Indien ingevoerd, wordt de lokale tijd van de klant weergegeven bovenaan de paginaweergave van de klant.',
    'tt_allow_online_payment_processing_fees'         => 'Er kunnen verwerkingskosten voor online betalingen worden berekend voor klanten die met een creditcard betalen, met behulp van hun openbare factuurlink (inbegrepen in de e-mail met de factuur). Deze optie heeft een globale systeeminstelling, maar kan ook op individuele klantbasis worden overschreven.',
    'tt_allow_child_accounts'                         => 'Door Kinderaccounts toestaan in te stellen op Ja, kan deze client fungeren als een ouderaccount en kunt u deze selecteren in de lijst Ouderaccounts.',
    'tt_third_party_bill_payer'                       => 'Een externe rekeningbetaler is een organisatie die rekeningen betaalt voor hun klanten, zoals een extern accountantskantoor.',
    'tt_parent_account'                               => 'Het moederbedrijf waarmee deze klant verbonden is of een dochteronderneming van is. Deze lijst bevat de klantrecords waarvan de instelling Kinderaccounts toestaan is ingesteld op Ja. Laat leeg als de klant geen ouderaccount heeft.',
    'tt_invoices_paid_by'                             => 'Het externe bedrijf dat deze klant gebruikt om zijn facturen te betalen. Deze lijst bevat de klantrecords waarvan de instelling 3rd Party Bill Payer op Ja staat. Laat leeg als de klant zijn eigen facturen betaalt.',
    'tt_email_default'                                => 'Selecteer bij het verzenden van e-mails naar deze client de e-mail die moet worden gebruikt. Als deze klant een gekoppelde bovenliggende rekening of rekening met facturen betaald door heeft, kan een van deze opties worden geselecteerd. Standaard is het standaard e-mailadres van de klant.',
    'tt_default_to'                                   => 'Moet dit contact bij het verzenden van e-mails automatisch worden toegevoegd aan de lijst \'To:\' ontvangers?',
    'tt_default_cc'                                   => 'Moet dit contact bij het verzenden van e-mails automatisch worden toegevoegd aan de lijst met \'CC:\' ontvangers?',
    'tt_default_bcc'                                  => 'Moet dit contact bij het verzenden van e-mails automatisch worden toegevoegd aan de lijst met \'BCC:\' ontvangers?',
    'tt_client_type'                                  => 'Een Lead is een ongekwalificeerde verkoopkandidaat. Een prospect is een gekwalificeerde kandidaat die binnenkort klant kan worden. Een klant is een bedrijf of persoon aan wie u goederen of diensten hebt verkocht (of binnenkort zult verkopen). Een Affiliate is een bedrijf of persoon die uw goederen of diensten doorverkoopt. Overig wordt gebruikt voor zaken die niet bij de andere typen passen, zoals externe rekeningbetalers of ouderrekeningen waarmee u niet rechtstreeks zaken doet.',
    'tt_client_tags'                                  => 'Tags kunnen aan een klant worden toegewezen om uw klantenlijst te helpen categoriseren of filteren voor weergave of rapportage.',
    'tt_important_note'                               => 'Een notitie die hier wordt ingevoerd, verschijnt automatisch in een BELANGRIJK! venster wanneer het klantdossier wordt bekeken.',
    'tt_gen_header_title_text'                        => 'De tekst die wordt weergegeven in de linkerbovenhoek, naast uw logo, meestal uw bedrijfsnaam.',
    'tt_gen_default_company_profile'                  => 'Het standaard te gebruiken bedrijfsprofiel bij het maken van nieuwe facturen, offertes, enz. Met bedrijfsprofielen kunt u uw bedrijf met elk profiel anders presenteren, waardoor verschillende bedrijfsnamen, logo\'s, factuurformaten, enz. mogelijk zijn.',
    'tt_gen_address_format'                           => 'Stelt u in staat om de adresopmaak op facturen en offertes te bouwen door het enkele adresveld te gebruiken of een combinatie van de individuele adresvelden, zoals stad, staat, land, etc.',
    'tt_gen_custom_fields_columns'                    => 'Aangepaste velden kunnen worden weergegeven van 1 tot 3 velden per rij.',
    'tt_gen_require_tags_on_client_notes'             => 'Indien ingesteld op Ja, moet er een tag worden geselecteerd of ingevoerd bij het toevoegen van een klantnotitie, zoals \'Ondersteuning\' of \'Verkoop\'. Dit is handig voor het categoriseren en zoeken van notities.',
    'tt_gen_skin'                                     => 'Hoe wilt u dat uw FI UI wordt weergegeven, lichte of donkere modus',
    'tt_gen_top_bar_color'                            => 'De kleur van de bovenste titelbalk. Als u met verschillende FusionInvoice-installaties werkt, kan dit een nuttige visuele identificatie zijn.',
    'tt_gen_results_per_page'                         => 'Het aantal records dat per pagina wordt weergegeven voor alle lijstweergaven, zoals klanten, facturen, offertes, onkosten, enz.',
    'tt_gen_allow_line_item_discounts'                => 'Schakelt de kortingsfunctie voor regelitems in of uit binnen facturen en offertes.',
    'tt_gen_language'                                 => 'De taal die moet worden gebruikt voor uw FusionInvoice-installatie. Houd er rekening mee dat u uw klanten een andere taal kunt toewijzen, zodat ze in hun moedertaal kunnen communiceren met het FusionInvoice Client Center.',
    'tt_gen_date_format'                              => 'Uw voorkeursdatumnotatie',
    'tt_gen_use_24_hour_time_format'                  => 'Maakt ondersteuning van 24- of 12-uurs tijdnotaties mogelijk.',
    'tt_gen_timezone'                                 => 'De primaire tijdzin van uw bedrijf.',
    'tt_gen_base_currency'                            => 'De valuta die uw bedrijf het vaakst gebruikt.',
    'tt_gen_exchange_rate_mode'                       => 'Met Handmatig kunt u de wisselkoerswaarde invoeren terwijl u facturen maakt. Automatic zal proberen een openbare API te gebruiken om de wisselkoers van de valuta op te halen. Dit wordt alleen gebruikt wanneer u een transactie invoert met een andere valuta dan uw basisvaluta.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice ondersteunt maximaal 2 belastingvelden per regelitem. De geselecteerde waarde met toon of verberg het tweede belastingveld.',
    'tt_gen_quantity_price_decimals'                  => 'Het aantal decimalen dat moet worden weergegeven voor aantal- en bedragwaarden. Selecteer 0 tot 4 op basis van uw vereiste nauwkeurigheidsniveau.',
    'tt_gen_round_tax_decimals'                       => 'Selecteer het gewenste aantal decimalen voor berekeningen van belastingafronding.',
    'tt_gen_use_captcha_in_login'                     => 'Indien ingesteld op Ja, moeten uw gebruikers tijdens het inloggen een CAPTCHA-uitdagingsvraag beantwoorden.',
    'tt_gen_force_https'                              => 'We raden zelden aan om deze optie in te schakelen. Als uw installatie geen correct werkend SSL-certificaat op uw webserver heeft geïnstalleerd, kunt u voor uw FusionInvoice-installatie problemen ondervinden. U kunt hetzelfde resultaat bereiken door een serveromleidingsregel in te stellen.',
    'dashboard_settings'                              => 'Dashboard-instellingen',
    'tt_dashboard_settings'                           => 'Uw dashboard wordt gebruikt om belangrijke zakelijke statistieken en gebeurtenissen weer te geven, waardoor u waardevol inzicht krijgt in de prestaties van uw bedrijf. Het systeemdashboard is het standaarddashboard voor alle gebruikers, maar binnen de configuratie van elke gebruiker kunt u het standaarddashboard van het systeem overschrijven en specifieke instellingen voor elke gebruiker definiëren. Met de onderstaande instellingen kunt u uw dashboard aanpassen.',
    'tt_db_default_time_period'                       => 'Stelt de standaard begin- en einddatums in voor dashboardwidgets die ze gebruiken, zoals KPI-kaarten en de verkoopgrafiek.',
    'tt_db_recent_client_activity'                    => 'Een widget die klantinteracties weergeeft, zoals gedane betalingen en bekeken facturen of offertes, vanuit uw openbare factuur- of offertelinks.',
    'tt_db_display_order'                             => 'Dit verandert de weergavevolgorde voor dashboardwidgets. 1 wordt bovenaan weergegeven, 2 wordt weergegeven na 1, enz.',
    'tt_db_column_width'                              => 'Dashboard-widgets gebruiken het Bootstrap-rastersysteem en hebben een maximale kolombreedte van 12. Als u de kolombreedte instelt op 12, gebruikt de widget de volledige beschikbare breedte. Als je dit instelt op 6, kunnen twee widgets dezelfde rij delen, bij 4 kunnen 3 widgets dezelfde rij delen, enz.',
    'tt_db_accumulate_totals'                         => 'Als u deze waarde inschakelt, bevat uw grafiek de totalen van de voorgaande dagen voor elke dag. De verkoop voor dag 1 was bijvoorbeeld $ 100, dag 2 was $ 50, dag 3 was $ 125. De grafiek zou een stijgende lijn laten zien als deze optie is ingesteld op Ja. Ingesteld op Nee, zou een dip in de verkoopregel op dag 2 worden weergegeven en toenemen tot dag 3.',
    'tt_db_kpi_cards'                                 => 'Deze kleurgecodeerde kaarten tonen de belangrijkste prestatie-indicatoren bovenaan uw dashboard.',
    'tt_db_sales_chart'                               => 'Een lijngrafiek met factuur- en betalingstotalen.',
    'tt_db_task_list'                                 => 'Met deze widget kunt u rechtstreeks vanuit uw dashboard met de module Takenlijst werken.',
    'tt_db_task_list_include_time'                    => 'Als u deze optie inschakelt, kunt u de datum en tijd opgeven voor vervaldatums wanneer u met taken werkt. Indien ingesteld op Nee wordt alleen de datumwaarde gebruikt.',
    'tt_db_timeline'                                  => 'De tijdlijnwidget geeft een chronologische en doorzoekbare lijst weer van belangrijke systeemgebeurtenissen, zoals wijzigingen in de status van klanten, gemailde facturen, gemaakte betalingen, gemaakte notities, enz.',
    'tt_ss_invoices_default_invoice_template'         => 'Selecteer de sjabloon die standaard wordt gebruikt bij het maken van nieuwe facturen. Aangepaste sjablonen moeten worden geplaatst in .\\custom\\templates\\invoice_templates\\ en moeten de extensie .blade.php hebben.',
    'tt_ss_invoices_default_doc_scheme'               => 'Selecteer het documentnummerschema dat standaard moet worden gebruikt bij het aanmaken van nieuwe facturen. Documentnummerschema\'s kunnen worden gemaakt binnen Configuratie-instellingen en stellen u in staat om uw documentnummers (facturen, offertes, creditnota\'s) te personaliseren.',
    'tt_ss_invoices_invoice_due_days'                 => 'Het standaard aantal dagen, na de (aanmaak)datum van de factuur, dat de factuur opeisbaar wordt en naar verwachting zal worden betaald.',
    'tt_ss_invoices_automatic_email_ri'               => 'Wanneer een terugkerende factuur wordt uitgevoerd en een live factuur genereert, moet die live factuur dan automatisch naar de klant worden gemaild?',
    'tt_ss_invoices_qr_code'                          => 'Moet er automatisch een QR-code op de standaard facturen en offertes worden geplaatst. Als u aangepaste factuur- of offertesjablonen gebruikt, raadpleeg dan de standaardsjablonen om de QR-code aan uw aangepaste sjablonen toe te voegen.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Als een factuur de status Concept heeft en handmatig of automatisch per e-mail wordt verzonden, wat moet er dan met de factuurdatum gebeuren? Belangrijke opmerking: wanneer een factuur per e-mail wordt verzonden, wordt de status automatisch gewijzigd van Concept in Verzonden.',
    'tt_ss_invoices_recalculate'                      => 'Voert elke transactie uit die voor elke factuur is gemaakt, vanaf de datum waarop deze is gemaakt tot de huidige datum, en herberekent de totalen, regelitemtotalen, belastingen, kortingen en factuurtotalen. Dit kan lang duren als u een grote dataset heeft.',
    'tt_ss_invoices_due_after'                        => 'De vervaldatum van de factuur is de factuurdatum plus het aantal dagen dat hier is ingevoerd.',
    'tt_ss_invoices_default_status_filter'            => 'Het statusfilter dat standaard moet worden toegepast bij het bekijken van de facturenlijst.',
    'tt_ss_invoices_default_terms'                    => 'De tekstwaarde van de voorwaarden die op het standaardfactuursjabloon wordt weergegeven in het onderste gedeelte van de factuur, in het gebied Algemene voorwaarden.',
    'tt_ss_invoices_default_footer'                   => 'Voettekstwaarde die op de standaardfactuursjabloon onderaan de factuur wordt weergegeven. Bijvoorbeeld:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Wanneer de dagelijkse taakrunner (CRON-taak) een live factuur uitvoert en genereert op basis van een terugkerende factuursjabloon, moet die nieuwe factuur dan automatisch naar de klant worden gemaild? Dit kan per klant worden overschreven.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Wanneer een betaling wordt afgeschreven, moet die betalingsinformatie dan automatisch naar de klant worden gemaild?',
    'tt_ss_invoices_online_payment_method'            => 'De betaalmethode die wordt toegewezen wanneer een klant betaalt via een openbare factuurlink. Betaalmethoden kunnen worden onderhouden via Systeeminstellingen.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Moet er een QR-code op het document worden weergegeven die naar de openbare URL van de factuur of offerte leidt?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Moeten gebruikers, zelfs admin-gebruikers, facturen kunnen verwijderen? Een veiliger en beter traceerbaar alternatief voor het verwijderen van facturen is om de factuurstatus te wijzigen in \'Geannuleerd\', waardoor het factuurtotaal op nul wordt gezet en wordt uitgesloten van de meeste lijsten en rapporten.',
    'tt_ss_invoices_show_invoices_from'               => 'Wanneer facturen per e-mail worden verzonden, wordt dit weergegeven als het adres Gemaild van. Belangrijke opmerking: de waarde Beantwoorden aan is altijd de waarde die is toegewezen in Systeeminstellingen -',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Als de factuur in de factuurweergave de status Concept heeft en per e-mail is verzonden, moet de factuurdatum dan ongewijzigd blijven of veranderen in de huidige datum? Als de factuurdatum verandert, wordt ook de vervaldatum bijgewerkt.',
    'tt_ss_quotes_default_quote_template'             => 'Selecteer de sjabloon die standaard zal worden gebruikt bij het maken van een nieuwe offerte. Aangepaste sjablonen moeten worden geplaatst in .\\custom\\templates\\quote_templates\\ en moeten de extensie .blade.php hebben.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Selecteer het documentnummerschema dat standaard moet worden gebruikt bij het maken van nieuwe offertes. Documentnummerschema\'s kunnen worden gemaakt binnen Configuratie-instellingen en stellen u in staat om uw documentnummers (facturen, offertes, creditnota\'s) te personaliseren.',
    'tt_ss_quotes_expire_days'                        => 'Het standaard aantal dagen, na de (aanmaak)datum van de offerte, dat de offerte vervalt. Wanneer een offerte zijn vervaldatum heeft overschreden, is het duidelijk dat prijzen kunnen veranderen als gevolg van marktschommelingen, enz.',
    'tt_ss_quotes_default_status_filter'              => 'Het statusfilter dat standaard moet worden toegepast bij het bekijken van de facturenlijst.',
    'tt_ss_quotes_auto_convert'                       => 'Wanneer een offerte wordt goedgekeurd, moet hierdoor automatisch een factuur worden aangemaakt op basis van de offerte.',
    'tt_ss_quotes_when_converted_action'              => 'Als een offerte wordt omgezet in een factuur, moeten dan de betalingsvoorwaarden worden gebruikt uit de offerte of uit de standaardinstelling voor factuurvoorwaarden?',
    'tt_ss_quotes_default_terms'                      => 'De tekstwaarde van de voorwaarden die wordt weergegeven op de standaard offertesjabloon, in het onderste gedeelte van de offerte, in het gebied Algemene voorwaarden.',
    'tt_ss_quotes_default_footer'                     => 'Voettekstwaarde die op de standaard offertesjabloon onderaan de offerte wordt weergegeven. Bijvoorbeeld:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Als een offerte de status Concept heeft en handmatig of automatisch per e-mail wordt verzonden, wat moet er dan met de offertedatum gebeuren? Belangrijke opmerking: wanneer een offerte per e-mail wordt verzonden, wordt de status automatisch gewijzigd van Concept naar Verzonden.',
    'tt_ss_quotes_recalculate'                        => 'Voert elke transactie uit die voor elke offerte is gemaakt, vanaf de datum waarop deze is gemaakt tot de huidige datum, en berekent de totalen, regelitemtotalen, belastingen, kortingen en offertetotalen opnieuw. Dit kan lang duren als u een grote dataset heeft.',
    'tt_ss_taxes_default_rate1'                       => 'Het primaire belastingtarief dat automatisch moet worden toegepast op nieuwe regelitems die aan facturen of offertes worden toegevoegd. Belastingtarieven worden onderhouden via Configuratie -',
    'tt_ss_taxes_default_rate2'                       => 'Het secundaire belastingtarief dat automatisch moet worden toegepast op nieuwe regelitems die aan facturen of offertes worden toegevoegd. Belastingtarieven worden onderhouden via Configuratie -',
    'tt_ss_email_send_method'                         => 'De e-mailverzendmethode die FusionInvoice moet gebruiken. Als u de verzendmethode wijzigt, verandert ook de weergave van de ondersteunende velden voor de verzendmethode.',
    'tt_ss_email_allow_self_cert'                     => 'Als u deze optie inschakelt, wordt de PHP-verifieer_peer-vereiste uitgeschakeld. Zoek voor meer informatie op internet naar: PHP e-mail zelfondertekend certificaat openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Bij het verzenden van e-mails is dit het standaard Beantwoorden-adres dat uw ontvangers zullen zien.',
    'tt_ss_email_always_cc'                           => 'Een e-mailadres dat u standaard automatisch wilt CCen bij elke verzonden e-mail.',
    'tt_ss_email_always_bcc'                          => 'Een e-mailadres dat u standaard automatisch wilt BCC-en bij elke verzonden e-mail.',
    'tt_ss_email_send_test_to'                        => 'Het e-mailadres dat moet worden gebruikt wanneer op de knop Test-e-mail verzenden wordt geklikt.',
    'tt_ss_email_mail_from_addr'                      => 'Het standaard Mail From-adres dat moet worden gebruikt wanneer e-mails worden verzonden vanuit FusionInvoice. Opmerking: binnen Systeeminstellingen -',
    'tt_ss_email_mail_from_name'                      => 'De Mail From beschrijvende naam die moet worden weergegeven op verzonden e-mails.',
    'tt_ss_email_email_templates'                     => 'Er zijn e-mailsjablonen beschikbaar voor veel documenten en gebeurtenissen, waaronder: offertes, offertegoedkeuringen, offerteafwijzingen, facturen, achterstallige facturen, creditnota\'s, betalingsbewijzen, aanstaande betalingsberichten. Een standaardsjabloon is inbegrepen, maar u kunt ook aangepaste sjablonen maken, die eenvoudig kunnen zijn (zoals de meegeleverde standaardsjablonen) of volledig opgemaakte HTML.',
    'tt_ss_pdf_driver'                                => 'Het stuurprogramma dat moet worden gebruikt bij het maken van PDF-documenten. Het selecteren van het stuurprogramma \'wkhtmltopdf\' vereist een lokale serverinstallatie van dit programma en het instellen van het juiste binaire pad ervoor.',
    'tt_ss_pdf_binary_path'                           => 'Het lokale serverpad naar het binaire bestand voor wkhtmltopdf. Bijvoorbeeld C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice ondersteunt verschillende online betalingsproviders. Schakel de providers in waarbij u accounts heeft aangemaakt. De providers die hier zijn ingeschakeld, worden weergegeven als betalingsopties wanneer uw klanten hun facturen bekijken met behulp van de openbare factuurlink (inbegrepen in de standaardfactuur-e-mail).',
    'tt_ss_olp_api_key'                               => 'De API-sleutel wordt u verstrekt door uw betalingsprovider.',
    'tt_ss_olp_payment_button_text'                   => 'De tekst die wordt weergegeven op de betaalmethodeknop voor deze betalingsprovider, bovenaan uw openbare factuur, zoals bekeken door uw klanten.',
    'tt_ss_olp_mode'                                  => 'Ondersteund door sommige betalingsproviders, waardoor Sandbox meer (testen) en live is.',
    'tt_ss_olp_client_id'                             => 'De klant-ID wordt u verstrekt door deze betalingsprovider.',
    'tt_ss_olp_client_secret'                         => 'Het Client Secret wordt u verstrekt door deze betalingsprovider.',
    'tt_ss_olp_publishable_key'                       => 'De Publishable Key wordt u verstrekt door deze betalingsprovider.',
    'tt_ss_olp_secret_key'                            => 'De geheime sleutel wordt u verstrekt door deze betalingsprovider.',
    'tt_ss_olp_opp_fees_about'                        => 'Er kunnen verwerkingskosten voor online betalingen worden berekend voor klanten die met een creditcard betalen, met behulp van hun openbare factuurlink (inbegrepen in de e-mail met de factuur).',
    'tt_ss_olp_enable_opp_fees'                       => 'Er kunnen verwerkingskosten voor online betalingen worden berekend voor klanten die met een creditcard betalen, met behulp van hun openbare factuurlink (inbegrepen in de e-mail met de factuur). Deze optie heeft een globale systeeminstelling, maar kan ook op individuele klantbasis worden overschreven.',
    'tt_ss_olp_opp_fee_pct'                           => 'Het percentage van het factuurtotaal dat in rekening wordt gebracht als verwerkingskosten voor online betalingen (gemak).',
    'tt_ss_olp_opp_fee_name'                          => 'De naam van de vergoeding die op de factuur moet worden weergegeven. D.w.z. \'Creditcardgemakskosten\'.',
    'tt_ss_olp_opp_fee_explanation'                   => 'Een toelichting op de vergoeding die op de factuur moet worden weergegeven. D.w.z. \'Er wordt een toeslag van 3% berekend voor alle creditcardtransacties\'',
    'tt_company_profiles_about'                       => 'Met bedrijfsprofielen kunt u uw bedrijf met elk profiel anders presenteren, waardoor verschillende bedrijfsnamen, logo\'s, factuurformaten, enz. mogelijk zijn. Het biedt een manier om meerdere virtuele bedrijven binnen dezelfde FusionInvoice-installatie te hebben. Er moet een standaard bedrijfsprofiel worden geselecteerd in Systeeminstellingen.',
    'tt_users_about'                                  => 'U kunt gebruikers van het type Admin (volledige toegang) of Standaard (individuele systeemrechten moeten worden verleend) aanmaken. Als u \'Aanmelding bij Klantencentrum toestaan\' instelt op Ja voor een klantrecord, wordt automatisch een gebruikersrecord voor de klant toegevoegd. Klantgebruikers kunnen echter alleen worden toegevoegd met behulp van de interface voor klantinstellingen.',
    'tt_users_client_about'                           => 'Klantgebruikers kunnen alleen inloggen in het Klantencentrum, waardoor ze een beperkt zicht hebben op hun facturen, offertes en betalingen. Als u \'Aanmelden bij Klantencentrum toestaan\' op Ja zet voor een klantrecord, krijgt u toegang tot het Klantencentrum.',
    'tt_user_types_about'                             => 'Beheerders hebben volledige systeemtoegang. Standaardgebruikers kunnen de individuele machtigingen krijgen die ze nodig hebben. Klantgebruikers hebben alleen toegang tot hun specifieke informatie binnen het Klantencentrum en hun mogelijkheid om in te loggen wordt ingesteld in Klantinstellingen -',
    'tt_custom_fields_about'                          => 'Met aangepaste velden kunt u uw eigen gegevensvelden aan de meeste modules toevoegen. Als u de branche voor klanten wilt vastleggen, voegt u gewoon een aangepast veld met het label \'Branche\' toe op de pagina Klanten, waardoor het een Dropdown-type wordt. Aangepaste velden worden automatisch weergegeven onder de normale velden.',
    'tt_recurring_invoices_about'                     => 'Terugkerende facturen zijn eigenlijk geen facturen, maar eerder sjablonen voor het maken van toekomstige facturen. Ze hebben een herhalingsfrequentie en volgende datum die bepalen wanneer ze een live factuur genereren. Een dagelijkse CRON-taak of geplande taak is vereist om terugkerende facturen goed te laten werken.',
    'tt_addons_about'                                 => 'Add-ons zijn aanpassingen aan FusionInvoice voor unieke zakelijke behoeften, zoals urenregistratie, prijsformules of gestileerde factuursjablonen. Ze worden aangeboden via de FusionInvoice add-on-marktplaats.',
    'client_center_user'                              => 'Klantcentrum gebruiker',
    'user_type'                                       => 'Gebruikerstype',
    'custom_field'                                    => 'Aangepast veld',
    'placeholder_type_email_template'                 => 'Typ of plak uw e-mailsjabloon. . .',
    'email_templates'                                 => 'E-mailsjablonen',
    'payment_receipts'                                => 'Betalingsbewijzen',
    'upcoming_payment_notices'                        => 'Aankomende betalingsberichten',
    'convenience_fee_for_credit_card_transactions'    => 'Gemakskosten voor creditcardtransacties',
    'credit_card_processing_fee'                      => 'Verwerkingskosten voor creditcards',
    'delete_client_user_warning'                      => '<p>Als u een klantgebruiker verwijdert, wordt de mogelijkheid om in te loggen bij het klantencentrum uitgeschakeld.</p>',
    'use_default_mail_template'                       => 'Standaard e-mailsjabloon',
    'use_custom_mail_template'                        => 'Aangepaste e-mailsjabloon',
    'quote_email_body'                                => 'Citeer e-mailtekst',
    'overdue_invoice_email_body'                      => 'Hoofdtekst e-mail achterstallige factuur',
    'credit_memo_email_body'                          => 'Hoofdtekst e-mail creditnota',
    'payment_receipt_body'                            => 'Instantie voor betalingsontvangst',
    'invoice_email_body'                              => 'Hoofdtekst factuur e-mail',
    'quote_custom_email_body_require'                 => 'Voer uw aangepaste e-mailsjabloon in voor de hoofdtekst van de offerte-e-mail',
    'quote_custom_approve_email_body_require'         => 'Voer uw aangepaste e-mailsjabloon in om de e-mail goed te keuren',
    'quote_reject_email_body_require'                 => 'Voer uw aangepaste e-mailsjabloon in voor de hoofdtekst van de e-mail voor het afwijzen van offertes',
    'overdue_invoice_email_body_require'              => 'Voer uw aangepaste e-mailsjabloon in voor de hoofdtekst van de achterstallige factuur',
    'invoice_email_body_require'                      => 'Voer uw aangepaste e-mailsjabloon in voor de hoofdtekst van de factuur-e-mail',
    'credit_memo_email_body_require'                  => 'Voer uw aangepaste e-mailsjabloon in voor de hoofdtekst van de e-mail van de creditnota',
    'payment_receipt_email_body_require'              => 'Voer uw aangepaste e-mailsjabloon in voor de hoofdtekst van de e-mail met het betalingsbewijs',
    'upcoming_payment_notice_email_body_require'      => 'Voer uw aangepaste e-mailsjabloon in voor de hoofdtekst van de e-mail met aanstaande betalingsberichten',
    'copy_text'                                       => 'Kopieer tekst',
    'tt_preview_template'                             => 'Voorbeeld sjabloon',
    'tt_view_template_code'                           => 'Sjablooncode bekijken',
    'dashboard_date_range'                            => 'Dashboard-datumbereik',
    'tt_dashboard_date_range'                         => 'Dashboard-datumbereik filtert de weergave voor de volgende widgets: KPI-kaarten, verkoopgrafiek, recente klantactiviteit.',
    'product_copy'                                    => 'Productkopie',
    'open_selected_client'                            => 'Open geselecteerde klant',
    'save_this_client'                                => 'Sla deze klant op (geen duplicaat)',
    'looks_like_duplicate'                            => 'Hmm... Dit lijkt op een duplicaat',
    'duplicate_instructions'                          => 'Als u de gewenste client in de lijst ziet, selecteert en opent u deze. Zo niet, sla dan de nieuwe client op.',
    'select_checkbox'                                 => 'Selecteer een klant',
    'select_lead_source_tag'                          => 'Selecteer Klantleadbron',
    'lead_source'                                     => 'Leadbron',
    'tt_client_lead_source_tags'                      => 'Selecteer of voer klantleadbron in (hoe de klant is geworven)',
    'your_link_is_expired'                            => 'Oeps! Je link is verlopen.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Keer terug naar dashboard</a>.',
    'secure_link_and_expire_link_days'                => 'Koppelingen voor openbare facturen beveiligen en laten verlopen',
    'secure_link_expire_days'                         => 'Aantal dagen',
    'tt_secure_link_and_expire_link_days'             => 'Bij het inschakelen van beveiligde koppelingen moet u ook het aantal dagen instellen waarna de factuurkoppeling vervalt. Door dit te doen, kan een klant zijn openbare factuurlink bekijken totdat deze verloopt.',
    'expire_time_period'                              => 'Het veld Koppeling vervalt aantal dagen is verplicht',
    'enter_days'                                      => 'Voer Dagen in',
    'invalid_field_name'                              => 'Voer een geldige veldnaam in',
    'lead_source_notes'                               => 'Opmerkingen over leadbronnen',
    'important_note'                                  => 'Belangrijke notitie',
    'social_media_url'                                => 'Sociale media-URL',
    'general_notes'                                   => 'Algemene opmerkingen',
    'payment_amount_mismatch'                         => 'Betalingsbedrag komt niet overeen',
    'open_invoice_aging'                              => 'Open Factuurveroudering',
    'tt_db_open_invoice_aging'                        => 'Open Factuurveroudering',
    'current'                                         => 'Huidig',
    'oneToThirty'                                     => '1-30 dagen',
    'thirtyOneToSixty'                                => '31-60 dagen',
    'sixtyOneToNinety'                                => '61-90 dagen',
    'ninetyOnePlus'                                   => '91 dagen',
    'sent_and_draft'                                  => 'Voeg zowel verzonden als conceptfacturen toe',
    'sent_only'                                       => 'Voeg alleen verzonden facturen toe',
    'tt_open_ar_aging_settings'                       => 'Instellingen voor ouderdomstotalen openstaande facturen',
    'tt_client_field_settings'                        => 'Selecteer de velden die u in uw klantweergave wilt weergeven',
    'position_change'                                 => 'Positie veranderd',
    'dynamic_width'                                   => 'Dynamische breedte',
    'full_width'                                      => 'Volledige breedte',
    'save_configuration_default'                      => 'Sla de configuratie op als systeemstandaard',
    'assign_configuration_other'                      => 'Configuratie toewijzen aan andere gebruikers',
    'tt_user_tags'                                    => 'Gebruikerstags',
    'select_users'                                    => 'Selecteer Gebruikers',
    'configuration_assigned'                          => 'Configuratie toegewezen',
    'default_configuration_set'                       => 'Standaardconfiguratie succesvol ingesteld',
    'current_user_id'                                 => 'Huidige gebruikers-ID',
    'tt_users_settings'                               => 'Gebruikers instellingen',
    'invoice_link_expire'                             => 'De openbare link van uw factuur verloopt over',
    'quote_link_expire'                               => 'De openbare link van uw offerte verloopt over',
    'dashboard_width'                                 => 'Dashboard :widthName kolombreedte-instelling gewijzigd',
    'unmark_mailed'                                   => 'Demarkeren als gemaild ongedaan maken',
    'invoice_unmark_mailed'                           => 'Factuur ongedaan maken als gemaild',
    'print_mark_mailed'                               => 'Afdrukken',
    'public_link'                                     => 'Openbare koppeling',
    'tt_sales_chart_settings'                         => 'Instelling voor verkoopgrafiek factuur/totaal',
    'verify_key'                                      => 'Verificatie van productsleutels',
    'enter_key'                                       => 'Voer uw sleutel in',
    'verify'                                          => 'Verifieer het!',
    'key_required'                                    => 'Productcode is vereist',
    'key_length_invalid'                              => 'Voer de productcode van 32 tekens in die u bij aankoop hebt ontvangen.',
    'invalid_key'                                     => 'Sorry, uw sleutel is ongeldig. De installatie kan niet doorgaan.',
    'key_verified'                                    => 'Gefeliciteerd, uw sleutel is geverifieerd.',
    'clear_cache'                                     => 'Cache wissen',
    'clear_cache_confirm'                             => 'Weet u zeker dat u de cache van uw toepassing wilt wissen?',
    'cache_clear_success'                             => 'Cache succesvol gewist.',
    'cache_clear_error'                               => 'Controleer uw serverconfiguratie voor de PHP exec()-opdracht.',
    'add_new_client'                                  => 'Nieuwe klant toevoegen',
    'add'                                             => 'Toevoegen',
    'invalid_quantity_amount'                         => 'Ongeldig hoeveelheidsbedrag! Moet groter zijn dan 0.',
    'api_version'                                     => 'API-versie',
    '2021_prior'                                      => '2021 en vroeger',
    '2022_later'                                      => '2022 en later',
    'vendors'                                         => 'Verkoper',
    'file_not_found'                                  => ':file_name is niet gevonden',
    'leave_empty_no_parent_account'                   => 'leeg laten als de klant geen ouderaccount heeft',
    'leave_empty_client_pays_invoices'                => 'leeg laten als de klant zijn eigen facturen betaalt',
    'modal_not_found'                                 => 'Modaal niet gevonden',
    'payment_delete_success'                          => 'Betaling succesvol verwijderd',
    'payment_delete_error'                            => 'Er is een probleem opgetreden bij het verwijderen van de betaling. Probeer het later opnieuw.',
    'status_change_error'                             => 'Er is iets fout gegaan! Status is niet gewijzigd.',
    'total_payments'                                  => 'Totaal betalingen',
    'licence_verification_error'                      => 'Kan uw licentiesleutel niet verifiëren.',
    'line_item_discount_limit'                        => 'Regelitems mogen niet meer dan 99,99% korting hebben.',
    'date_range_report'                               => 'Datumbereik (volgende datum om uit te voeren)',
    'no_client_found'                                 => 'Hmmm... we konden die klant niet vinden.',
    'tt_line_item_discount'                           => 'Een regelitemkorting kan worden berekend door een percentage van de prijs of een vast bedrag voor de individuele itemprijs.',
    'functionality_not_available_on_demo'             => 'Sorry, die functie is niet toegestaan in de demo.',
    'vat_tax_id'                                      => 'Btw-ID',
    'tt_vat_tax_id'                                   => 'Belasting over de toegevoegde waarde (btw-nummer).',
    'enable_vat_tax_id'                               => 'Btw-ID inschakelen',
    'no-attachment'                                   => 'er is geen bijlage',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Opruimen',
    'allow_edit_status_invoice'                       => 'Bewerk :status Factuur',
    'tt_ss_allow_edit_invoices_status'                => 'Uit veiligheidsoverwegingen kunnen alleen facturen met de status Concept worden bewerkt. U kunt dit opheffen door bewerking van Verzonden en/of Betaalde facturen toe te staan.',
    'allow_edit_invoices_status'                      => 'Sta bewerking van facturen in status toe',
    'draft_and_sent'                                  => 'Concept en verzonden',
    'draft_or_sent_and_paid'                          => 'Concept, verzonden en betaald',
    'invoice_editable'                                => 'Factuur bewerkbaar',
    'can_not_edit_paid_invoice'                       => 'U kunt een betaalde factuur niet wijzigen',
    'item_category'                                   => 'Artikelcategorie',
    'itemLookups'                                     => 'Item opzoeken',
    'quoteItems'                                      => 'Citeer artikelen',
    'invoiceItems'                                    => 'Factuuritems',
    'imports_disabled_in_demo.'                       => 'Importeren is uitgeschakeld in de demo.',
    'no_file_selected'                                => 'Geen bestand geselecteerd',
    'no_import_records'                               => 'Er zijn geen records gevonden om te importeren',
    'vendor_name'                                     => 'Naam van de leverancier',
    'license_key'                                     => 'Licentiesleutel',
    'change_license_key'                              => 'Licentiesleutel wijzigen',
    'verify_and_save'                                 => 'Verifiëren',
    'same_key_error'                                  => 'Geen wijziging gedetecteerd. Probeer een andere sleutel',
    'trying_invalid_key'                              => 'Sorry, die sleutel kan niet worden geverifieerd. Licentiesleutel is niet gewijzigd.',
    'key_updated'                                     => 'Gefeliciteerd! Uw licentiesleutel is succesvol bijgewerkt.',
    'invalid_date_format'                             => 'Ongeldige datum. Vereist formaat: JJJJ-MM-DD',
    'invalid_datetime_format'                         => 'Ongeldige datum-tijdnotatie. Vereist formaat: JJJJ-MM-DD HH:MM :SS',
    'profile_setting'                                 => 'Profielinstellingen',
    'include_draft_invoices_unpaid_and_overdue'       => 'Voeg conceptfacturen toe aan onbetaalde en achterstallige lijsten',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Indien ingesteld op Ja, worden facturen met de status Concept opgenomen in lijsten en berekeningen voor achterstallige en onbetaalde facturen.',
    'tt_utilities_import'                             => 'Importeer gegevens uit CSV-bestanden in uw FusionInvoice-database.',
    'tt_utilities_export'                             => 'Exporteer gegevens uit uw FusionInvoice-database naar een aantal verschillende formaten: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Bekijk het logbestand met alle e-mailgebeurtenissen binnen FusionInvoice.',
    'tt_utilities_system_log'                         => 'Bekijk het systeemlogbestand met fout- en waarschuwingssysteemgebeurtenissen.',
    'tt_utilities_tag_cleanup'                        => 'Verwijdert tags die zijn gedefinieerd, maar niet worden gebruikt. Verwijdert ook eventuele dubbele tags.',
    'tt_utilities_pdf_cleanup'                        => 'Verwijdert tijdelijke PDF-bestanden.',
    'tt_utilities_recalc_invoices'                    => 'Scant elke factuur en zorgt ervoor dat de totalen overeenkomen met de som van alle regelitems, waarbij rekening wordt gehouden met kortingen en belastingen. *Dit kan lang duren.',
    'tt_utilities_recalc_quotes'                      => 'Scant elke offerte en zorgt ervoor dat de totalen overeenkomen met de som van alle regelitems, waarbij rekening wordt gehouden met kortingen en belastingen. *Dit kan lang duren.',
    'tt_utilities_clear_cache'                        => 'Verwijdert tijdelijke cachebestanden.',
    'tt_utilities_download_database'                  => 'Download een geëxporteerd databasebestand van uw live FusionInvoice-gegevens. Hoe groter uw database, hoe langer dit zal duren.',
    'tt_utilities_run_daily_tasks'                    => 'Een CRON-taak of geplande taak voert normaal gesproken uw dagelijkse taken uit. Hierdoor kunt u het handmatig doen. Het genereert live facturen op basis van terugkerende factuursjablonen, verzendt betalingsherinneringen, enz.',
    'include_line_item_detail'                        => 'Voeg details van regelitems toe',
    'invoice_tags'                                    => 'Factuurlabels',
    'related_accounts'                                => 'Gerelateerde rekeningen',
    'not_found_related_clients'                       => 'Er zijn geen gerelateerde klantaccounts toegewezen',
    'invoices_paid_for_list'                          => 'Met dit klantaccount worden facturen betaald',
    'child_accounts_exist'                            => 'De instelling Kinderaccounts toestaan is teruggezet naar Ja. Kan niet wijzigen in Nee als er kinderaccounts bestaan.',
    'third_bp_accounts_exist'                         => 'Instelling Factuurbetaler van derde partij teruggezet naar Ja. Kan niet wijzigen in Nee wanneer gerelateerde accounts bestaan.',
    'tag_name'                                        => 'Labelnaam',
    'tag_new_name'                                    => 'Nieuwe tagnaam',
    'tag_category'                                    => 'Tagcategorie',
    'rename_tags'                                     => 'Labels hernoemen',
    'apply'                                           => 'Toepassen',
    'select_tag_category'                             => 'Selecteer Tagcategorie',
    'tt_utilities_rename_tags'                        => 'Wijzig de naam van tags die zijn toegewezen aan klanten, notities, verkoopactiviteiten, enz.',
    'system_default_dashboard'                        => 'Standaard systeemdashboard',
    'user_specific_dashboards'                        => 'Gebruikersspecifieke dashboards',
    'tt_default_client_type'                          => 'Standaard klanttype',
    'default_client_type'                             => 'Standaard klanttype',
    'invalid_user'                                    => 'Selecteer een geldige gebruiker.',
    'create_live_invoice'                             => 'Live factuur maken',
    'create_live_invoice_successfully'                => 'Levende factuur',
    'create_live_invoice_unsuccessfully'              => 'Live factuur is niet gemaakt',
    'live_invoice_not_generate'                       => 'Kan geen live factuur genereren van een terugkerende factuur met een stopdatum van vandaag of eerder, of een volgende datum die meer dan 30 dagen in de toekomst ligt.',
    'data_seeder'                                     => 'Gegevens Zaaier',
    'select_module'                                   => 'Selecteer module',
    'number_of_seed'                                  => 'Aantal zaden',
    'seed_it'                                         => 'Zaad het!',
    'seeds_success'                                   => 'Zaden succesvol toegevoegd',
    'tt_ri_generate_the_next_live_invoice'            => 'Genereer nu de volgende live factuur voor deze terugkerende factuur.',
    'system_log_clear_message'                        => 'Weet u zeker dat u het systeemlogboek wilt wissen? Deze actie kan niet ongedaan worden gemaakt en alle eerdere logboeken worden permanent verwijderd.',
    'system_log_clear_successfully'                   => 'Systeemlogboek gewist. Succesvol',
    'payment_problem'                                 => 'Er is een probleem opgetreden tijdens de betaling. Probeer het later opnieuw.',
    'log_detail'                                      => 'Klik hier om het detaillogboek te bekijken.',
    'log_limit_message'                               => 'Logbestand',
    'log_download_file'                               => 'Download bestand',
    'log_delete_all'                                  => 'Verwijder alle bestanden',
    'log_level'                                       => 'Niveau',
    'log_context'                                     => 'Context',
    'log_date'                                        => 'Datum',
    'log_line_number'                                 => 'Lijn nummer',
    'log_content'                                     => 'Inhoud',
    'addon_install_error'                             => 'Er is een probleem met de installatie van de add-on. Probeer het later opnieuw.',
    'addon_installed_success'                         => 'Add-on succesvol geïnstalleerd.',
    'allow_edit_status_credit_memo'                   => 'Bewerk toegepaste creditnota',
    'database_seeder'                                 => 'Zaaimachine',
    'tt_utilities_database_seeder'                    => 'Zaad uw database met testgegevens met behulp van zaadklassen',
    'vat_information'                                 => 'BTW-informatie',
    'tt_vat_information'                              => 'IBAN bankrekeningnummer, BIC, e-mail enz ...',
    'explore_addons'                                  => 'Ontdek Add-ons',
    'available_addons'                                => 'Beschikbare FusionInvoice-add-ons',
    'addon_success'                                   => 'Add-on is succesvol toegevoegd.',
    'payment_cannot_enabled_in_demo'                  => 'Betalingsgateways kunnen niet worden ingeschakeld in de demo',
    'confirm_approve_leave_page'                      => 'Er zijn niet-opgeslagen wijzigingen op deze pagina! Weet u zeker dat u wilt vertrekken zonder op te slaan?',
    'leave'                                           => 'Vertrekken',
    'demo_date_refresh'                               => 'Demogegevens worden vernieuwd',
    'minutes'                                         => 'minuten',
    'minute'                                          => 'minuut',
    'seconds'                                         => 'seconden',
    'mautic-authentication-fail'                      => 'U heeft geen toegang tot deze bron. Gebruik een geldige geheime sleutel.',
    'something_went_wrong'                            => 'Er is iets fout gegaan!',
    'month_to_date'                                   => 'Deze maand tot nu toe',
    'quarter_to_date'                                 => 'Dit kwartaal tot nu toe',
    'year_to_date'                                    => 'Dit jaar',
    'last_active'                                     => 'Laatst actief',
    'database_seeder_stop'                            => ':name BEDRIJFSZAAIER STOP',
    'database_seeder_start'                           => ':name BEDRIJFSZAAIER START',
    'seeder_records_created'                          => ':total Records zijn succesvol aangemaakt voor :modal',
    'seeder_credit_apply_invoice'                     => 'Creditnota toepassen op factuur',
    'seeder_quote_approve_reject'                     => 'Offerte goedkeuren en afwijzen',
    'seeder_executed'                                 => 'Zaaimachine succesvol uitgevoerd!',
    'seeder_not_executed'                             => 'Seeder werd niet uitgevoerd!',
    'db_to_file_system_attachments_migration'         => 'Migratie van bijlagen - Database naar bestandssysteem',
    'attachment_content_count'                        => 'U staat op het punt om in totaal te migreren',
    'attachment_repeat_content_count'                 => 'U staat op het punt om in totaal te migreren',
    'attachment_key_invalid'                          => 'Bijlagesleutel is ongeldig',
    'stop'                                            => 'Stop!',
    'attachment_migration_warning'                    => 'Met deze stap worden de bijlagen van uw database naar uw bestandssysteem gemigreerd. Voer een volledige databaseback-up uit voordat u doorgaat en zorg ervoor dat u voldoende schijfruimte heeft om deze bewerking uit te voeren.',
    'attachment_agreement_accept'                     => 'Ik heb een back-up gemaakt van mijn database.',
    'microsoft365'                                    => 'Microsoft365',
    'office365_password'                              => 'Microsoft 365-wachtwoord',
    'office365_username'                              => 'Microsoft 365-gebruikersnaam',
    'custom_date_formula_note1'                       => '<b><u>Standaardwaarde Tijdelijke aanduidingen :</span></u></b> ~<br> U kunt <b>vandaag, morgen en gisteren</b> elke willekeurige waarde als standaard gebruiken.<br>',
    'custom_date_formula_note2'                       => '<b>Voor vandaag + N dagen, gebruik </b> \'default\': \'+7\' Dit voegt 7 dagen toe aan de datum van vandaag <br><b>Voor vandaag - N dagen, gebruik </b> \'default\': \'-7\' Hierdoor worden 7 dagen afgetrokken van de datum van vandaag <br>',
    'mail_config_error'                               => 'Kan geen test-e-mail verzenden zonder dat de e-mailverzendmethode is gedefinieerd.',
    'db_prefix_alert'                                 => 'We hebben gemerkt dat u het databasevoorvoegsel :prefix gebruikt. FusionInvoice ondersteunt in toekomstige versies geen databasevoorvoegsels. Bewerk uw database en hernoem al uw tabellen door het voorvoegsel te verwijderen. Bewerk vervolgens uw database.php-bestand en stel uw \'voorvoegsel\'-waarde in op leeg',
    'db_prefix_alert_title'                           => 'Ondersteuning voor DB-voorvoegsels eindigt binnenkort',
    'add_title_bar_shortcut'                          => 'Titelbalksnelkoppeling toevoegen',
    'title_bar_shortcuts'                             => 'Snelkoppelingen op de titelbalk',
    'select_icon'                                     => 'Selecteer Pictogram',
    'all_payment_method'                              => 'Alle betaalmethoden',
    'about'                                           => 'Over',
    'own_license'                                     => 'Eigen licentie',
    'tt_own_license'                                  => 'Eigen licentie',
    'git_branch'                                      => 'Git huidige branch',
    'quote_email'                                     => 'E-mail met offerte',
    'custom1'                                         => 'Op maat 1',
    'custom2'                                         => 'Maatwerk 2',
    'custom3'                                         => 'Maatwerk 3',
    'default_document_template'                       => 'Standaard documentsjabloon',
    'default_email_template'                          => 'Standaard e-mailsjabloon',
    'sms'                                             => 'Sms',
    'pricing_formula'                                 => 'Prijsformule',
    'is_mobile'                                       => 'Is mobiel?',
    'default_sms_template'                            => 'Standaard SMS-sjabloon',
    'sms_log'                                         => 'SMS-logboek',
    'two_factor_auth'                                 => 'Tweefactorauthenticatie',
    'enabled_mail_driver'                             => 'Schakel de e-mailservice in',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Ongeldige verificatie code',
    'otp-subject'                                     => 'Inloggen OTP',
    'resend_otp_success'                              => 'Verificatiecode opnieuw verzonden',
    'resend_otp_btn'                                  => 'Code nogmaals versturen',
    'expired_otp'                                     => 'verificatie code verlopen',
    'token_expired'                                   => 'Uw CSRF-token is verlopen',
    'verification_code'                               => 'Verificatie code',
    'migration'                                       => 'Migratie',
    'invoice_status_change_draft_to_sent'             => 'Factuurstatus gewijzigd van concept in verzonden',
    'default_sales_quantity'                          => 'Standaard verkoophoeveelheid',
    'lead_time'                                       => 'Gem. Doorlooptijd (dagen)',
    'primary_vendor_id'                               => 'Voorkeursleverancier',
    'all_items'                                       => 'Alle spullen',
    'non_inventory_items'                             => 'Niet-voorraadartikelen',
    'back_ordered'                                    => 'Terug besteld',
    'low_inventory'                                   => 'Lage voorraad',
    'high_inventory'                                  => 'Hoge voorraad',
    'merge_client_records'                            => 'Klantrecords samenvoegen',
    'primary_merge_to_client'                         => 'Samenvoegen in (behouden)',
    'surrogate_merge_from_client'                     => 'Samenvoegen van (weggooien)',
    'merge'                                           => 'Samenvoegen',
    'merge_action'                                    => 'Actie samenvoegen',
    'ignore'                                          => 'Negeren',
    'overwrite'                                       => 'Overschrijven',
    'add_to'                                          => 'Optellen bij',
    'select_merge_client'                             => 'Selecteer voor samenvoegen',
    'client_to_and_from_not_same'                     => 'De cliënt aan en de cliënt van moeten verschillend zijn.',
    'client_id_required'                              => 'Het klantselectieveld moet zowel verplicht als uniek zijn.',
    'is_merge'                                        => 'Samenvoegen',
    'record_successfully_merged'                      => 'Record succesvol samengevoegd',
    'service_ends'                                    => 'Dienst eindigt',
    'service_starts'                                  => 'De dienst begint',
    'explanation'                                     => 'Uitleg',
    'subscription_details'                            => 'Abonnementsgegevens',
    'generate_next_invoice'                           => 'Genereer de volgende factuur',
    'subscription'                                    => 'Abonnement',
    'of_the'                                          => 'Van de',
    'on'                                              => 'Op',
    'invoice_month'                                   => 'Factuurmaand',
    'invoice_year'                                    => 'Factuurjaar',
    'next_month'                                      => 'Volgende maand',
    'next_year'                                       => 'Volgend jaar',
    'day'                                             => 'Dag',
    'last_date'                                       => 'Laatste datum',
    'merge_record_warning'                            => 'Stop! Het samenvoegen van klantaccounts kan niet ongedaan worden gemaakt. Naast de velden die u hebt geselecteerd om te overschrijven of toe te voegen, wordt de gehele transactiegeschiedenis voor de samenvoeg-van-client overgedragen naar de samenvoeg-naar-client. Weet u zeker dat u deze klantaccounts wilt samenvoegen?',
    'merge_child_account_warning'                     => 'De Merge(To)-client heeft een ouderaccount met gerelateerde onderliggende accounts die opnieuw worden toegewezen aan de Merge(To)-client. Zorg ervoor dat de Merge(To)-client is toegestaan als ouderaccount.',
    'merge_parent_account_warning'                    => 'Door samen te voegen wordt uw koppeling met het bovenliggende account verwijderd.',
    'merge_invoices_paid_by_warning'                  => 'Als u samenvoegt, wordt uw koppeling met de bovenliggende factuur verwijderd die is betaald door.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'Het aantal relaties in het Klantmodel is gewijzigd.',
    'payment_terms'                                   => 'Betaalvoorwaarden',
    'net_amount_due_in'                               => 'Nettobedrag dat moet worden betaald',
    'net_amount_due_by'                               => 'Nettobedrag verschuldigd door',
    'if_paid_within'                                  => 'indien binnen betaald',
    'if_paid_by'                                      => 'indien betaald door',
    'th_of_next_month'                                => 'e van volgende maand',
    'of_next_month'                                   => 'van volgende maand',
    'down_payment'                                    => 'Aanbetaling',
    'balance_amount_due_of'                           => 'saldo verschuldigd in',
    'payment_split_over'                              => 'Betaling verdeeld',
    'installments'                                    => 'termijnen',
    'days_from_invoice_date'                          => 'dagen na factuurdatum',
    'payment'                                         => 'Betaling',
    'one'                                             => 'Een',
    'two'                                             => 'Twee',
    'three'                                           => 'Drie',
    'four'                                            => 'Vier',
    'five'                                            => 'Vijf',
    'six'                                             => 'Zes',
    'discount_percent'                                => 'Kortingspercentage',
    'discount_days_simple'                            => 'Kortingsdagen Eenvoudig',
    'discount_days_nth'                               => 'Kortingsdagen Nde',
    'net_due_days'                                    => 'Netto vervaldagen',
    'balance_due_days'                                => 'Saldo vervaldagen',
    'number_of_installments'                          => 'Aantal Installaties',
    'payment_term'                                    => 'Betalingstermijn',
    'select_payment_term'                             => 'Selecteer Betalingstermijn',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'Het veld Termijnpercentage :index is verplicht en groter dan nul.',
        'installment_due_days_error'                  => 'De ingediende termijnbetalingsdagen :index zijn vereist',
        'discount_percent_gt_error'                   => 'Het ingediende Kortingspercentage is vereist en groter dan nul.',
        'discount_percent_lt_error'                   => 'Het ingediende kortingspercentage is vereist en minder dan 100%.',
        'down_payment_percent_lt_error'               => 'Het ingediende aanbetalingspercentage is vereist en minder dan 100%.',
        'discount_percent_numeric_error'              => 'Het veld Kortingspercentage moet een numerieke waarde zijn en kleiner dan 100%.',
        'down_payment_gt_error'                       => 'De ingediende aanbetaling is vereist en groter dan nul.',
        'discount_days_gt_net_days_error'             => 'De dagen waarop het nettobedrag moet worden betaald, moeten groter zijn dan de kortingsdagen.',
        'discount_days_nth_gt_net_days_error'         => 'Het nettobedrag dat moet worden betaald, moet groter zijn dan de N-de kortingsdagen.',
        'installment_due_days_gt_error'               => 'De vervaldagen voor termijnen :index moeten groter zijn dan :preIndex vervaldagen voor termijnen.',
        'installment_percent_total_error'             => 'Het totaalbedrag van het termijnpercentage is niet nauwkeurig. het moet gelijk zijn aan 100%.',
        'installment_percent_numeric_error'           => 'Het totaalbedrag van het termijnpercentage is niet nauwkeurig. Het moet een numerieke waarde zijn.',
        'term_discount'                               => 'Termijnkorting',
        'installment_due_days_gt_zero_error'          => 'De termijndagen :index moeten groter zijn dan of gelijk zijn aan nul.',
        'net_due_days_error'                          => 'Het nettobedrag van de vervaldagen moet groter zijn dan nul en moet worden ingediend.',
        'discount_days_simple_error'                  => 'De kortingsdagen eenvoudig moeten groter zijn dan nul en moeten worden ingediend.',
        'discount_days_nth_error'                     => 'De korting N-de dagen moet groter zijn dan nul en moet worden ingediend.',
        'balance_due_days_error'                      => 'De dagen waarop het saldo moet worden betaald, moeten groter zijn dan nul en moeten worden ingediend.',
        'status_error'                                => 'Sorry, de status is niet gewijzigd vanwege de term die in de factuur wordt gebruikt.',
        'down_payment_type_invoice_description_error' => 'Uw ingevoerde factuurbeschrijvingstoken komt niet overeen met uw aanbetalingstype.',
        'down_payment_type_quote_description_error'   => 'Uw ingevoerde offertebeschrijvingstoken komt niet overeen met uw aanbetalingstype.',
    ],
    'quotes_delete_error'                             => 'Fout bij het verwijderen van citaten',
    'for'                                             => 'Voor',
    'production'                                      => 'Productie',
    'access_token'                                    => 'Toegangstoken',
    'application_id'                                  => 'Applicatie ID',
    'location_id'                                     => 'Locatie-ID',
    'fi_config_check'                                 => 'Vereistencontrole',
    'requirement'                                     => 'Vereiste',
    'required'                                        => 'Vereist',
    'actual'                                          => 'Werkelijk',
    'result'                                          => 'Resultaat',
    'db_prefix_setup_alert'                           => 'Uw FusionInvoice-database gebruikt DB-voorvoegsels. Ondersteuning voor DB-voorvoegsels eindigde met versie 2023-3.0. Om door te gaan met upgraden naar deze en toekomstige versies, is het vereist dat u DB-voorvoegsels verwijdert. U kunt dit doen door alle tabellen in uw DB te hernoemen en het voorvoegsel te verwijderen en ook de waarde \'prefix\' => \'\' in uw database.php-bestand in te stellen.',
    'open_tasks'                                      => 'Taken openen',
    'closed_tasks'                                    => 'Gesloten taken',
    'select_status'                                   => 'Selecteer Status',
    'net_amount_due_invoice'                          => 'Netto verschuldigd bedrag in :days dagen.',
    'days_add_in_current_date'                        => 'De huidige datum, vanaf <span class="text-blue">:date</span> , en de vervaldatum, moeten worden beschouwd als <span class="text-blue">:date</span>  <span class="text-danger">plus</span> <span class="text-blue">aantal dagen</span>.',
    'terms'                                           => 'Voorwaarden',
    'quote_rejecting_error'                           => 'Factuur # :invoice_number is aangemaakt op :invoice_date vanaf de goedkeuring van deze offerte. Voordat u deze offerte afwijst, moet u deze factuur verwijderen of annuleren.',
    'resend_record_warning'                           => 'Deze e-mail nu opnieuw verzenden?',
    'resend_email'                                    => 'Email opnieuw verzenden',
    'requirement_check_fail'                          => 'Voordat de installatie kan worden voortgezet, moet u de hierboven weergegeven fouten corrigeren.',
    'failed'                                          => 'Mislukt',
    'subscriptions'                                   => 'Abonnementen',
    'tt_explanation'                                  => 'Voer een beschrijving in voor de service met optionele tijdelijke aanduidingen voor de datum. U kunt de volgende tokens gebruiken om de start- en einddatum van de service dynamisch in te voegen:{{service_starts_on}} en {{service_ends_on}}. Deze worden vervangen door de daadwerkelijke begin- en einddatum wanneer de inhoud wordt weergegeven.',
    'tt_ss_invoices_default_payment_terms'            => 'Standaardbetalingsvoorwaarden voor facturen',
    'invoices_default_terms'                          => 'Standaardvoorwaarden voor facturen',
    'net_amount_due_in_n_days'                        => 'Nettobedrag verschuldigd over N dagen',
    'last_day'                                        => 'Laatste dag',
    'down_payment_payment_term1'                      => 'Aanbetaling van',
    'down_payment_payment_term2'                      => 'Is benodigd.  Het saldo moet binnen zijn',
    '1_type'                                          => 'Een factuur die vandaag is gemaakt, wordt over <span class="text-primary">#N</span> dagen betaald',
    '2_type'                                          => 'Een factuur die vandaag wordt aangemaakt, geeft een korting als deze vóór <span class="text-primary">#date</span> wordt betaald.</span> Zo niet, dan is het volledige bedrag binnen <span class="text-primary">#N</span>  dagen verschuldigd',
    '3_type'                                          => 'Een vandaag aangemaakte factuur geeft een korting als deze vóór <span class="text-primary">#date</span>  wordt betaald. Het nettobedrag moet binnen <span class="text-primary">#N</span>  dagen worden betaald',
    '4_type'                                          => 'Voor een vandaag aangemaakte factuur is een aanbetaling van <span class="text-primary">#amount</span>  vereist. Het resterende saldo moet binnen <span class="text-primary">#N</span>  dagen worden betaald',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>Een factuur die vandaag is aangemaakt en is verdeeld over <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Betaling <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Vervaldatum <span class="text-primary">#date</span></p>',
    'installment'                                     => 'termijn',
    'apply_payment_terms'                             => 'Pas het kortingsbedrag voor de betalingsvoorwaarden toe',
    'payable_amount'                                  => 'Uiteindelijk te betalen bedrag',
    'payable_amount_lt_error'                         => 'Het eindbedrag moet lager zijn dan het factuursaldo.',
    'payment_term_type_4_amount'                      => 'Gedeeltelijke betaling van :amount geaccepteerd',
    'net_terms'                                       => 'Netto voorwaarden',
    'proforma_invoice_default'                        => 'Standaard proformafactuur',
    'expense_vendor'                                  => 'Kostenleverancier',
    'expense_vendor_deleted'                          => 'Onkostenleverancier is verwijderd',
    'expense_vendor_already_used'                     => 'U kunt een leverancier die gerelateerde onkostenposten heeft, niet verwijderen.',
    'total_must_be_gt_zero'                           => 'Het :modal_name totaal moet groter zijn dan nul.',
    'payment_failed'                                  => 'Betaling mislukt met :error',
    'xss_validation'                                  => 'Het veld :attribute bevat tags die een XSS-kwetsbaarheid kunnen blootleggen',
    'support_desk'                                    => 'Ondersteuningsbalie',
    'choose_file'                                     => 'Kies bestand',
    'supportTicket'                                   => 'Ondersteuningsbalie',
    'create_support_ticket'                           => 'Ondersteuningsticket maken',
    'supportTicket_inbox_view'                        => 'Ondersteuningsbalie',
    'support_ticket'                                  => 'Ondersteuningsticket',
    'ticket_number'                                   => 'Ticket nummer',
    'revision'                                        => 'Herziening',
    'revisions'                                       => 'Revisies',
    'recurring_invoices'                              => 'Periodieke facturen',
    'message'                                         => 'Bericht',
    'custom_img'                                      => 'Aangepaste afbeelding',
    'please_fill_some_data'                           => 'Vul bij het nieuwe artikel de benodigde gegevens in.',
    'assigned'                                        => 'Toegewezen',
    'add_ons_will_be_disabled'                        => 'DE VOLGENDE ADD-ONS WORDEN UITGESCHAKELD:',
    'add_ons_will_be_disabled_msg'                    => 'Alle add-ons worden automatisch uitgeschakeld tijdens een kernupgrade van FusionInvoice. Nadat deze upgrade is voltooid, moet u ervoor zorgen dat u de juiste add-on-zipbestanden downloadt en installeert. Zodra u dat heeft gedaan, kunt u ze opnieuw inschakelen via het menu Systeeminstellingen, Aanpassingen, Add-ons en door [Installeren] te selecteren.',
    'price_not_valid'                                 => 'De prijs moet groter zijn dan nul',
    'free_space'                                      => 'Vrije ruimte',
    'expense_type'                                    => 'Soort uitgaven',
    'standard_expense'                                => 'Standaard kosten',
    'expense_with_deductible_tax'                     => 'Kosten met aftrekbare belasting',
    'remittance_to_tax_authority'                     => 'Afdracht aan de belastingdienst',
    'tax_paid'                                        => 'Belasting betaald',
    'tax_detail'                                      => 'Belastinggegevens',
    'select_expense_type'                             => 'Selecteer Onkostensoort',
    'taxes_paid_on_expenses_or_remitted'              => 'Belastingen betaald over uitgaven of kwijtgescholden',
    'tax_name'                                        => 'Belastingnaam',
    'last_activity'                                   => 'Laatste Activiteit',
    'select_default_company_profile'                  => 'Selecteer uw standaardbedrijfsprofiel',
    'mn_sales_tax'                                    => 'MN omzetbelasting',
    'taxes_collected_on_sales'                        => 'Belastingen geïnd op verkopen',
    'vatgst_tax_note'                                 => 'Ja berekent de belasting als zijnde opgenomen in het artikeltotaal. Nee, de belasting wordt bij het artikeltotaal opgeteld.',
    'tt_vatgst_tax'                                   => 'Voor dit voorbeeld gaan we uit van een belastingtarief van 5% en een artikelprijs van € 100. Als u BTW/GST inschakelen instelt op Ja, krijgt u een factuurtotaal van € 100, waarbij het artikelbedrag wordt aangepast naar € 95,24 en een belastingbedrag van € 4,76. Als u de BTW/GST instelt op Nee, krijgt u een factuurtotaal van €105, met een artikelprijs van €100 en een belasting van €5.',
    'level_of_detail'                                 => 'Detailniveau',
    'tax_report'                                      => 'Belastingrapport',
    'detail'                                          => 'Detail',
    'totals'                                          => 'Totalen',
    'totals_with_dots'                                => 'Totalen. . .',
    'yes_all'                                         => 'Ja alles)',
    'invoices_only'                                   => 'Alleen facturen',
    'payment_receipts_only'                           => 'Alleen betalingsbewijzen',
    'role'                                            => 'Rol',
    'previous_email'                                  => 'Vorige e-mail',
    'web_store_user_id'                               => 'Gebruikers-ID webwinkel: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Nettobedrag verschuldigd vóór <span class="text-info">#LASTDATE</span>',
        '2_type'       => 'Er kan een korting van #DISCOUNTPERCENT % worden toegepast als deze vóór <span class="text-info">#DISCOUNTDATE</span> wordt betaald, anders is het nettobedrag vóór <span class="text-info">#LASTDATE</span>  verschuldigd.',
        '3_type'       => 'Er kan een korting van #DISCOUNTPERCENT % worden toegepast als deze vóór <span class="text-info">#DISCOUNTDATE</span> wordt betaald, anders is het nettobedrag vóór <span class="text-info">#LASTDATE</span>  verschuldigd.',
        '4_type'       => 'Een aanbetaling van <span class="text-info">#DOWNPAYMENT</span>  staat op #INVOICEDATE . Het saldo moet uiterlijk op <span class="text-info">#LASTDATE</span>  worden betaald.',
        '5_type'       => '<p class="mt-2 mb-1">Betalingen kunnen worden verdeeld over <span class="text-info">#NUMBEROFINSTALLMENTS</span> termijnen</p>',
        '5_1_type'     => '<li>Betaling <span class="text-info">#PERCENT %</span> verschuldigd <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">Volgende maand heeft in totaal #N dagen, dus voer een waarde tussen 1 en #N in voor de kortingsdagen van de volgende maand.</span>',
    ],
    'payment_term_not_selected'                       => 'Betalingstermijn niet geselecteerd',
    'confirm'                                         => 'Bevestigen',
    'create_live_invoice_now'                         => 'Nu een live factuur maken?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Een abonnement is als een factuursjabloon dat wordt gebruikt voor het maken van live facturen met een bepaalde frequentie.</p><p class="m-0"> Normaal gesproken een CRON-taak of geplande taak is ingesteld om één keer per dag te worden uitgevoerd en is verantwoordelijk voor het controleren op live-facturen die moeten worden aangemaakt, op basis van het veld Genereer volgende factuurdatum van het abonnement.  Als die datumwaarde vandaag of eerder dan vandaag is, wordt er automatisch een live factuur aangemaakt.</p><p class="m-0"> Met deze optie kunt u handmatig de live factuur van het abonnement maken, waarbij u de geautomatiseerde methode omzeilt. . Wilt u nu de live factuur maken?</p>',
    'contact'                                         => 'Contact',
    'invoice_month_plus_one'                          => 'Factuurmaand +1',
    'invoice_month_plus_two'                          => 'Factuurmaand +2',
    'invoice_month_plus_three'                        => 'Factuurmaand +3',
    'inbound_email'                                   => 'Inkomende e-mail',
    'outbound_email'                                  => 'Uitgaande e-mail',
    'email_signature'                                 => 'Email handtekening',
    'mail_credential_error'                           => 'Ongeldige e-mailconfiguratie. Controleer uw instellingen en probeer het opnieuw. <strong>( Configuratie <i class="fa fa-arrow-alt-circle-right"> </i> Systeeminstellingen <i class="fa fa-arrow-alt-circle-right"> </i> E-mail )</strong>',
    'tt_generate_next_invoice'                        => 'De datum waarop de volgende live factuur automatisch wordt aangemaakt op basis van dit abonnement.',
    'tt_stop_date'                                    => 'De datumdrempel waarna er automatisch geen live facturen meer worden gegenereerd voor dit abonnement. Laat dit veld leeg voor een abonnement dat voor altijd moet doorlopen.',
    'description_template'                            => 'Beschrijving sjabloon',
    't_1_description'                                 => 'De volledige betaling dient uiterlijk op #LASTDATE te zijn voldaan.',
    't_2_description'                                 => 'Neem een #DISCOUNTPERCENT % korting als u vóór #DISCOUNTDATE, betaal anders het volledige factuurbedrag vóór #LASTDATE.',
    't_3_description'                                 => 'Neem een #DISCOUNTPERCENT % korting indien betaald vóór #DISCOUNTDATE, betaal anders het volledige factuurbedrag vóór #LASTDATE.',
    't_4_description'                                 => 'Een aanbetaling van #DOWNPAYMENT is verschuldigd op #INVOICEDATE, het saldo van de factuur is verschuldigd op #LASTDATE',
    't_4_1_description'                               => 'Een aanbetaling van #DOWNPAYMENTPERCENT is verschuldigd op #INVOICEDATE, het saldo van de factuur is verschuldigd op #LASTDATE',
    't_5_description'                                 => 'De betalingen moeten worden gedaan in #NUMBEROFINSTALLMENTS gelijke termijnen',
    't_5_type_description'                            => 'Betaling #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT dient te worden voldaan op #LASTDATE',
    'tokens_allowed'                                  => 'Tokens toegestaan',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'De geëvalueerde tekst uit de sjabloon is de omschrijving van de termen die wordt weergegeven op documenten zoals facturen, offertes, enz.',
    'cc_mail'                                         => 'CC-mail',
    'assigned_inv_sent_or_paid'                       => '*Er zijn facturen die zijn betaald of verzonden en waaraan deze betalingstermijn is toegekend. Het wijzigen van de ‘Type’ gegevens is niet toegestaan.',
    'exclude_paid_invoices'                           => 'Sluit betaalde facturen uit',
    'phone_number_numeric_error'                      => 'Het telefoonnummer moet een nummer zijn.',
    'phone_num_same_country_code_error'               => 'Zorg ervoor dat uw telefoonnummer de juiste notatie heeft. Het lijkt erop dat de invoer begint met de landcode, wat niet is toegestaan.',
    'tt_expense_amount'                               => 'Vul het totaalbedrag van de uitgave in, inclusief belasting. Dit veld is niet beschikbaar bij het overmaken van een belastingbetaling aan een belastingdienst.',
    'tt_expense_tax_paid_deductible'                  => 'Vul het bedrag aan belasting in dat met deze uitgave is betaald. Deze waarde wordt afgetrokken van uw totale belastingschuld in de rapporten Belastingoverzicht en Belastingdetails.',
    'tt_expense_tax_paid_remittance'                  => 'Vul het bedrag aan belasting in dat is afgedragen aan de belastingdienst. Dit wordt gebruikt om betalingen vast te leggen voor belastingen die zijn geïnd op uw betaalde facturen.',
    'tt_expense_client'                               => 'Als deze kosten uitsluitend voor een klant zijn gemaakt en u deze hiervoor wilt factureren, selecteert u hier de betreffende klant.',
    'base_currency_not_deleted'                       => 'Basisvaluta kan niet worden verwijderd',
    'used_currency_modal_error'                       => 'Valuta die al wordt gebruikt in de module :modal_names.',
    'addon_uninstall_success'                         => 'Add-on succesvol verwijderd',
    'original'                                        => 'Origineel',
    'revision_current'                                => 'Revisie (huidige)',
    'number'                                          => 'Nummer',
    'copy_process_error'                              => 'Oeps! Het lijkt erop dat er een probleem is opgetreden tijdens het kopiëren. Probeer het later opnieuw.',
    'tt_captcha_image'                                => 'CAPTCHA-afbeelding',
    'reload_page'                                     => 'Herlaad alstublieft de pagina',
    'discount_limit'                                  => 'De korting moet minder dan 99,99% zijn.',
    'tooltip'                                         => 'Tooltip',
    'authorization_error'                             => 'U bent niet bevoegd om deze handeling uit te voeren.',
    'reset_to_default'                                => 'Terugzetten naar standaard',
    'reset_to_default_warning'                        => '<p>Hierdoor worden het onderwerp en de hoofdtekst opnieuw ingesteld op de standaardwaarde voor :model . Doorgaan?</p>',
    'reset_default_mail_template'                     => 'Het standaard e-mailsjabloon voor :model is succesvol opnieuw ingesteld.',
    'overdue_invoice'                                 => 'Achterstallige factuur',
    'total_cannot_be_lt_zero'                         => 'Het :modal_name totaal kan niet kleiner zijn dan nul.',
    'addons_disabled_during_setup'                    => 'Tijdens het upgradeproces zijn de volgende add-ons uitgeschakeld: :addons . Vergeet niet ze in te schakelen nu de upgrade is voltooid.',
    'allow_payments_on_quotes'                        => 'Betalingen op offertes toestaan J/N',
    'allow_payments_on_quote'                         => 'Betaling toestaan J/N',
    'tt_ss_quotes_is_payable'                         => 'Indien ingeschakeld, verschijnt na goedkeuring van de offerte een knop Nu betalen in de openbare linkweergave van de offerte. Er wordt automatisch een factuur aangemaakt en de betaling wordt op de factuur toegepast.',
    'pay_with_square'                                 => 'Betaal met vierkant',
    'validation_mess_for_is_payable_quote'            => 'De instelling om offerte automatisch om te zetten in factuur bij goedkeuring door klant is vereist wanneer Betalingen op offertes toestaan is ingesteld op \'Ja\'.',
    'client_requirement_msg'                          => 'Maak een client aan voordat u :seed_name toevoegt',
    'quote_add_items'                                 => 'Offerte-items vereist en status niet geannuleerd',
    'invalid_quote_id'                                => 'Ongeldige offerte-ID',
    'information_header'                              => 'Gefeliciteerd, u staat op het punt wat geld te besparen!',
    'convenience_charge'                              => 'Gemakstoeslag',
    'credit_card_fee_message'                         => 'Voor deze transactie wordt een creditcardtoeslag van :charge rekening gebracht.',
    'info_payment_term_type_2'                        => 'Hoewel uw factuursaldo :ORIGINAL_AMOUNT, komt u in aanmerking voor een korting op de betalingsvoorwaarden van :DISCOUNT_PERCENT %, waardoor uw betalingsbedrag wordt verlaagd naar :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Hoewel uw factuursaldo :ORIGINAL_AMOUNT, komt u in aanmerking voor een korting op de betalingsvoorwaarden van :DISCOUNT_PERCENT %, waardoor uw betalingsbedrag wordt verlaagd naar :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Hoewel uw factuursaldo :ORIGINAL_AMOUNT, komt u in aanmerking voor betalingsvoorwaarden voor het betalen van een aanbetaling :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Hoewel uw factuursaldo :ORIGINAL_AMOUNT, komt u in aanmerking voor betalingsvoorwaarden voor betaling in termijnen :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'Betalingsvoorwaarden moeten vóór verwijdering uit de :modal worden verwijderd.',
    'default_payment_term_warn'                       => '*U kunt alleen de Naam en Netto Vervaldagen wijzigen voor de <strong>Standaardbetalingsvoorwaarden van het systeem</strong>.',
    'quote_rejected_not_payable'                      => 'Offerte # :number is afgewezen en is vanwege de status ervan niet betaalbaar.',
    'could_not_delete'                                => 'Kan niet verwijderen',
    'convenience_charges_calculation_fail'            => 'Fout: berekening van gemakskosten is mislukt tijdens migratie. Probeer het later opnieuw.',
    'sign_in_welcome_message'                         => 'ðŸš€ Gefeliciteerd! Uw FusionInvoice is succesvol geïnstalleerd! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>Uw FusionInvoice is succesvol geüpgraded van versie :old_version naar versie :new_version .</p><p> Voor een gedetailleerd overzicht van alle nieuwe functies en verbeteringen, bekijk onze <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Release Notes</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Bedankt dat u voor FusionInvoice hebt gekozen. Uw vertrouwen, steun en feedback drijven onze innovatie aan.</p><p class="m-0 text-bold">Veel succes met factureren!</p><p class="text-bold">Het FusionInvoice-team</p >',
    'tt_gen_skin_user_profile'                        => 'Als u deze waarde wijzigt, wordt de systeemstandaard ALLEEN voor nieuwe gebruikers ingesteld. Gebruikers kunnen deze instelling overschrijven via hun gebruikersprofielinstellingen.',
    'description_template_invoice'                    => 'Beschrijving Sjabloon - Factuur',
    'description_template_quote'                      => 'Beschrijving Sjabloon - Offerte',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Volledige betaling dient te geschieden binnen #NETDAYS na de factuurdatum.',
    't_2_description_for_quote'                       => 'Neem een #DISCOUNTPERCENT % korting als u binnen #DISCOUNTDAYS, betaal anders het volledige offertebedrag vóór #NETDAYS.',
    't_3_description_for_quote'                       => 'Neem een korting van #DISCOUNTPERCENT % indien betaald vóór #NTHDAY van de volgende maand, of betaal het volledige factuurbedrag binnen #NETDAYS dagen.',
    't_4_description_for_quote'                       => 'Een aanbetaling van #DOWNPAYMENT is verschuldigd op de factuurdatum, het resterende saldo binnen #NETDAYS dagen',
    't_4_1_description_for_quote'                     => 'Op de factuurdatum is een aanbetaling van #DOWNPAYMENTPERCENT verschuldigd, het resterende saldo binnen #NETDAYS dagen',
    't_5_description_for_quote'                       => 'De betalingen moeten worden gedaan in #NUMBEROFINSTALLMENTS gelijke termijnen',
    't_5_type_description_for_quote'                  => 'Betaling #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT is verschuldigd #INSTALLMENTDUEDAYS dagen vanaf de factuurdatum',
    'default_term'                                    => 'Standaardtermijn',
    'proceed_to_payment'                              => 'Ga door naar betaling',
    'version_upgraded'                                => 'Uw aanvraag is up-to-date.',
    'term_amount_gt_payment_amount'                   => 'Het Bedrag moet groter zijn dan het kortingsbedrag voor de betalingsvoorwaarden',
    'payment_term_not_eligible_warning'               => 'De betalingstermijnkorting is alleen beschikbaar voor volledige betalingen. Helaas kom je er niet voor in aanmerking.',
    'processed_by_user'                               => '<strong>Verwerkt door:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Betaalmethode:</strong> :method',
    'all_methods'                                     => 'Alle methoden',
    'this_payment'                                    => 'Deze betaling',
    'previous_balance'                                => 'Vorige balans',
    'payment_applied_with_remaining_balance'          => '<p><strong>Uw betaling van :amount is gedeeltelijk toegepast. :remaining_balance blijft openstaan.</strong></p>',
    'pre_payment_received'                            => '<p><strong>Er is een vooruitbetaling van :amount ontvangen voor toekomstige facturen op :date .</strong></p>',
    'payment_full_applied'                            => '<p><strong>Uw betaling :amount is volledig toegepast.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Betaling <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;"> :formatted_number</span> ~ Details:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>Betaling van :paid is toegepast op factuur :invoice_number op :date</span> ~',
    'payment_full_applied_on_inv_with_ptd'            => '<p>Betaling van :paid, minus :payment_terms_discount betalingstermijnkorting is toegepast op factuur :invoice_number op :date</span> ~',
    'payment_full_applied_on_inv_with_cc'             => '<p>Betaling van :paid, plus :convenience_charges gemakskosten, is toegepast op factuur :invoice_number op :date</span> ~',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>Betaling van :paid, plus :convenience_charges gemakskosten en min :payment_terms_discount betalingstermijnkorting, is toegepast op Factuur :invoice_number op :date</span> ~',
    'payment_remaining_balance_mail_message'          => '<p>Het resterende saldo van Factuur :invoice_number is :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Onbetaalde facturen',
    'include'                                         => 'Erbij betrekken',
    'exclude'                                         => 'Uitsluiten',
    'invoice_with_no_tax'                             => 'Facturen zonder belasting',
    'tax_total'                                       => 'Belasting Totaal',
];

return TranslationOverride::override(__FILE__, $translations);
