<?php

$translations = [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'                        => ':attribute turi buti priimtas.',
    'active_url'                      => ':attribute nera tinkamas URL.',
    'after'                           => ':attribute turi buti data po :date.',
    'after_or_equal'                  => ':attribute turi buti data po :date arba jai lygi.',
    'alpha'                           => ':attribute gali sudaryti tik raides.',
    'alpha_dash'                      => ':attribute gali sudaryti tik raides, skaiciai ir brukšniai.',
    'alpha_num'                       => ':attribute gali sudaryti tik raides ir skaiciai.',
    'array'                           => ':attribute turi buti masyvas.',
    'before'                          => ':attribute turi buti data prieš :date.',
    'before_or_equal'                 => ':attribute turi buti data prieš :date arba jai lygi.',
    'between'                         => [
        'numeric' => ':attribute turi buti nuo :min iki :max.',
        'file'    => ':attribute turi buti nuo :min iki :max kilobaitu.',
        'string'  => ':attribute turi buti nuo :min iki :max simboliu.',
        'array'   => ':attribute turi tureti nuo :min iki :max elementu.',
    ],
    'boolean'                         => 'Laukas :attribute turi buti teisingas arba klaidingas.',
    'confirmed'                       => ':attribute patvirtinimas nesutampa.',
    'date'                            => ':attribute nera tinkama data.',
    'date_format'                     => ':attribute neatitinka formato :format.',
    'different'                       => ':attribute ir :other turi skirtis.',
    'digits'                          => ':attribute turi buti :digits skaitmenys.',
    'digits_between'                  => ':attribute turi buti nuo :min iki :max skaitmenu.',
    'dimensions'                      => ':attribute yra netinkami vaizdo matmenys.',
    'distinct'                        => 'Lauko :attribute reikšme pasikartoja.',
    'email'                           => ':attribute turi buti galiojantis el. pašto adresas.',
    'exists'                          => 'Pasirinktas :attribute neteisingas.',
    'file'                            => ':attribute turi buti failas.',
    'filled'                          => 'Lauke :attribute turi buti reikšme.',
    'image'                           => ':attribute turi buti vaizdas.',
    'in'                              => 'Pasirinktas :attribute neteisingas.',
    'in_array'                        => ':attribute lauko :other neegzistuoja.',
    'integer'                         => ':attribute turi buti sveikasis skaicius.',
    'ip'                              => ':attribute turi buti galiojantis IP adresas.',
    'ipv4'                            => ':attribute turi buti galiojantis IPv4 adresas.',
    'ipv6'                            => ':attribute turi buti galiojantis IPv6 adresas.',
    'json'                            => ':attribute turi buti tinkama JSON eilute.',
    'max'                             => [
        'numeric' => ':attribute negali buti didesnis nei :max.',
        'file'    => ':attribute negali buti didesnis nei :max kilobaitu.',
        'string'  => ':attribute negali buti didesnis nei :max simboliu.',
        'array'   => ':attribute negali tureti daugiau nei :max elementu.',
    ],
    'mimes'                           => ':attribute turi buti failo tipas: :values.',
    'mimetypes'                       => ':attribute turi buti failo tipas: :values.',
    'min'                             => [
        'numeric' => ':attribute turi buti bent :min.',
        'file'    => ':attribute turi buti bent :min kilobaitu.',
        'string'  => ':attribute turi sudaryti bent :min simboliu.',
        'array'   => ':attribute turi tureti bent :min elementus.',
    ],
    'not_in'                          => 'Pasirinktas :attribute neteisingas.',
    'numeric'                         => ':attribute turi buti skaicius.',
    'present'                         => 'Laukas :attribute turi buti.',
    'regex'                           => 'Netinkamas :attribute formatas.',
    'required'                        => 'Laukas :attribute yra butinas.',
    'required_if'                     => 'Laukas :attribute butinas, kai :other yra :value.',
    'required_unless'                 => 'Lauka :attribute butina užpildyti, nebent :other yra :values.',
    'required_with'                   => 'Laukas :attribute butinas, kai yra :values.',
    'required_with_all'               => 'Laukas :attribute butinas, kai yra :values.',
    'required_without'                => 'Laukas :attribute butinas, kai :values nera.',
    'required_without_all'            => 'Laukas :attribute butinas, kai nera ne vienos iš :values.',
    'same'                            => ':attribute ir :other turi sutapti.',
    'size'                            => [
        'numeric' => ':attribute turi buti :size.',
        'file'    => ':attribute turi buti :size kilobaitu.',
        'string'  => ':attribute turi sudaryti :size simboliai.',
        'array'   => ':attribute turi buti :size elementu.',
    ],
    'string'                          => ':attribute turi buti eilute.',
    'timezone'                        => ':attribute turi buti tinkama zona.',
    'unique'                          => ':attribute jau užimtas.',
    'uploaded'                        => 'Nepavyko ikelti :attribute.',
    'url'                             => 'Netinkamas :attribute formatas.',
    'captcha'                         => ':attribute neteisingas',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom'                          => [
        'attribute-name' => [
            'rule-name' => 'pasirinktinis pranešimas',
        ],
        'field_label'    => [
            'regex' => 'Lauko etiketeje yra netinkamas simbolis. Leidžiami simboliai: A-Z, a-z, 0-9, tarpas, -, _',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes'                      => [],
    'unique_of_decimal_and_thousands' => 'Decimal point and thousand separator already selected for another currency'

];

return \FI\Support\TranslationOverride::override(__FILE__, $translations);
