<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Paskyros nustatymas',
    'active'                                          => 'Aktyvus',
    'activity'                                        => 'Veikla',
    'activity_invoice_paid'                           => 'Invoice <a href=":link">#:number</a> was paid.',
    'activity_invoice_viewed'                         => 'Invoice <a href=":link">#:number</a> was viewed.',
    'activity_quote_approved'                         => 'Quote <a href=":link">#:number</a> was approved.',
    'activity_quote_rejected'                         => 'Quote <a href=":link">#:number</a> was rejected.',
    'activity_quote_viewed'                           => 'Quote <a href=":link">#:number</a> was viewed.',
    'add_item'                                        => 'Prideti daikta',
    'add_line_item_to_invoice'                        => 'Pridekite eilutes elementa prie saskaitos fakturos',
    'add_note'                                        => 'Prideti pastaba',
    'additional'                                      => 'Papildomas',
    'addon'                                           => 'Prideti',
    'addons'                                          => 'Priedai',
    'address'                                         => 'Adresas',
    'address_format'                                  => 'Adreso formatas',
    'after_amount'                                    => 'Po sumos',
    'all'                                             => 'Viskas',
    'all_categories'                                  => 'Visos kategorijos',
    'all_statuses'                                    => 'Visi busenos',
    'all_time'                                        => 'Visa laika',
    'all_vendors'                                     => 'Visi pardavejai',
    'allow_login'                                     => 'Leisti prisijungti',
    'always_attach_pdf'                               => 'Visada pridekite PDF',
    'always_bcc'                                      => 'Visada BCC adresas',
    'always_cc'                                       => 'Visada CC adresas',
    'amount'                                          => 'Suma',
    'api_public_key'                                  => 'API viešasis raktas',
    'api_secret_key'                                  => 'API slaptasis raktas',
    'approve'                                         => 'Patvirtinti',
    'approved'                                        => 'Patvirtinta',
    'approved_quotes'                                 => 'Patvirtintos citatos',
    'attach_files'                                    => 'Prisegti failus',
    'attach_pdf'                                      => 'Pridekite PDF',
    'attachment'                                      => 'Priedas',
    'attachments'                                     => 'Priedai',
    'author'                                          => 'Autorius',
    'automatic'                                       => 'Automatinis',
    'automatic_email_on_recur'                        => 'Automatiškai išsiusti pasikartojancias saskaitas el. Paštu',
    'automatic_email_payment_receipts'                => 'Automatiškai išsiusti mokejimo kvitus el. Paštu',
    'available_fields'                                => 'Galimi laukai',
    'back'                                            => 'Atgal',
    'back_to_invoice'                                 => 'Grižti i saskaita faktura',
    'back_to_quote'                                   => 'Atgal i citata',
    'balance'                                         => 'Balansas',
    'base_currency'                                   => 'Bazine valiuta',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Prieš suma',
    'bill_this_expense'                               => 'Saskaita už šias išlaidas',
    'bill_to'                                         => 'Saskaita',
    'billable'                                        => 'Saskaita',
    'billed'                                          => 'Saskaita',
    'billing_address'                                 => 'Atsiskaitymo adresas',
    'billing_city'                                    => 'Atsiskaitymo miestas',
    'billing_name'                                    => 'Atsiskaitymo pavadinimas',
    'billing_state'                                   => 'Atsiskaitymo valstybe',
    'billing_zip'                                     => 'Atsiskaitymo pašto kodas',
    'binary_path'                                     => 'Dvejetainis kelias',
    'body'                                            => 'kunas',
    'cancel'                                          => 'Atšaukti',
    'canceled'                                        => 'Atšauktas',
    'card_number'                                     => 'Korteles numeris',
    'cash'                                            => 'Grynieji pinigai',
    'category'                                        => 'Kategorija',
    'cc'                                              => 'CC',
    'change'                                          => 'Keisti',
    'change_client'                                   => 'Keisti klienta',
    'check_for_update'                                => 'Patikrinkite, ar nera naujiniu',
    'city'                                            => 'Miestas',
    'clear_keys'                                      => 'Išvalyti raktus',
    'client'                                          => 'Klientas',
    'client_form'                                     => 'Kliento forma',
    'client_name'                                     => 'Kliento vardas',
    'client_not_found'                                => 'Klientas nerastas',
    'client_statement'                                => 'Kliento pareiškimas',
    'client_unique_name_option_1'                     => 'Tik tada, kai kliento vardas nera unikalus',
    'client_unique_name_option_2'                     => 'Visada rodyti',
    'client_visibility'                               => 'Kliento matomumas',
    'clients'                                         => 'Klientai',
    'code'                                            => 'Kodas',
    'column_name'                                     => 'Stulpelio pavadinimas',
    'column_width'                                    => 'Stulpelio plotis',
    'company'                                         => 'Imone',
    'complete'                                        => 'Baigta',
    'complete_upgrade'                                => 'Užbaigti naujovinima',
    'compound'                                        => 'Junginys',
    'compound_tax_note'                               => 'Sudetiniai mokescio tarifai turi buti taikomi 2 mokesciui, kad gautu norima efekta.',
    'confirm_approve_quote'                           => 'Ar tikrai norite patvirtinti šia citata?',
    'confirm_reject_quote'                            => 'Ar tikrai norite atmesti šia citata?',
    'continue'                                        => 'Testi',
    'convert_quote_option1'                           => 'Saskaitoje fakturoje turetu buti nurodytos citatos salygos',
    'convert_quote_option2'                           => 'Saskaitoje turetu buti naudojami numatytieji saskaitos fakturos terminai',
    'convert_quote_setting'                           => 'Kai citata paverciama saskaita faktura',
    'convert_quote_when_approved'                     => 'Automatiškai konvertuoti citata i saskaita, kai klientas patvirtina',
    'converted_from_quote'                            => 'Konvertuota iš citatos',
    'converted_to_invoice'                            => 'Konvertuota i saskaita faktura',
    'country'                                         => 'Šalis',
    'create_invoice'                                  => 'Sukurti saskaita faktura',
    'create_quote'                                    => 'Sukurti citata',
    'created'                                         => 'Sukurta',
    'credit_card'                                     => 'Kreditine kortele',
    'currencies'                                      => 'Valiutos',
    'currency'                                        => 'Valiuta',
    'currency_form'                                   => 'Valiutos forma',
    'currency_symbol'                                 => 'Valiutos simbolis',
    'currency_symbol_placement'                       => 'Valiutos simbolio pateikimas',
    'custom_date_range'                               => 'Tinkinta dienu seka',
    'custom_field_form'                               => 'Tinkinto lauko forma',
    'custom_fields'                                   => 'Tinkinti laukai',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'Prietaisu skydelis',
    'dashboard_totals_option'                         => 'I informacijos suvestine turetu buti itraukta:',
    'database_not_configured'                         => 'Atrodo, kad programa / config / database.php dar nebuvo sukonfiguruota.',
    'database_setup'                                  => 'Duomenu bazes saranka',
    'date'                                            => 'Data',
    'date_format'                                     => 'Datos formatas',
    'days'                                            => 'Dienos',
    'decimal_point'                                   => 'Kablelio',
    'default_currency'                                => 'Numatytoji valiuta',
    'default_footer'                                  => 'Numatytoji porašte',
    'default_group'                                   => 'Numatytoji grupe',
    'default_invoice_email_body'                      => 'Numatytasis saskaitos fakturos el. Laiškas',
    'default_invoice_template'                        => 'Numatytasis saskaitos fakturos šablonas',
    'default_item_tax_2_rate'                         => 'Numatytasis prekes mokescio 2 tarifas',
    'default_item_tax_rate'                           => 'Numatytasis prekes mokescio tarifas',
    'default_overdue_invoice_email_body'              => 'Numatytasis pradelstas saskaitos fakturos el. Laiškas',
    'default_payment_receipt_body'                    => 'Numatytasis mokejimo kvito tekstas',
    'default_quote_email_body'                        => 'Numatytasis citatos el. Laiško turinys',
    'default_quote_template'                          => 'Numatytasis citatos šablonas',
    'default_terms'                                   => 'Numatytieji terminai',
    'delete'                                          => 'Ištrinti',
    'delete_client_warning'                           => '<p>SUSTABDYTI! Ištryne ši klienta, taip pat ištrinsite VISA jo operaciju istorija, iskaitant saskaitas fakturas, citatas ir mokejimus.</p><p>Ar tikrai norite visam laikui ištrinti ši klienta?</p>',
    'delete_record_warning'                           => 'Ar tikrai norite ištrinti ši iraša?',
    'description'                                     => 'apibudinimas',
    'details'                                         => 'Išsami informacija',
    'disabled'                                        => 'Neigalus',
    'discount'                                        => 'Nuolaida',
    'display_client_unique_name'                      => 'Rodyti kliento unikalu pavadinima',
    'display_do_not_require'                          => 'Rodyti, bet nereikia',
    'display_order'                                   => 'Rodyti tvarka',
    'display_profile_image'                           => 'Rodyti profilio vaizda',
    'do_not_add_line_item_to_invoice'                 => 'Prie saskaitos fakturos nepridekite eilutes elemento',
    'do_not_display'                                  => 'Nerodyti',
    'documentation'                                   => 'Dokumentacija',
    'download'                                        => 'parsisiusti',
    'draft'                                           => 'Juodraštis',
    'draft_invoices'                                  => 'Saskaitu projektai',
    'draft_quotes'                                    => 'Juodrašciu citatos',
    'dropdown'                                        => 'Išskleidžiamasis meniu',
    'due'                                             => 'Terminas',
    'due_date'                                        => 'Terminas',
    'edit'                                            => 'Redaguoti',
    'edit_client'                                     => 'Redaguoti klienta',
    'email'                                           => 'El',
    'email_address'                                   => 'Elektroninio pašto adresas',
    'email_invoice'                                   => 'Saskaita faktura el. Paštu',
    'email_payment_receipt'                           => 'El. Pašto kvitas',
    'email_quote'                                     => 'El. Pašto citata',
    'email_send_method'                               => 'El. Pašto siuntimo budas',
    'email_send_method_phpmail'                       => 'PHP paštas',
    'email_send_method_sendmail'                      => 'Išsiusti laiška',
    'email_send_method_sendgrid'                      => '„SendGrid“ API',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Ijungtas',
    'enter_payment'                                   => 'Iveskite mokejima',
    'error'                                           => 'Klaida',
    'every'                                           => 'Kiekvienas',
    'exchange_rate'                                   => 'Valiutos kursas',
    'exchange_rate_mode'                              => 'Valiutos kurso režimas',
    'expense_form'                                    => 'Išlaidu forma',
    'expenses'                                        => 'Išlaidos',
    'expiration'                                      => 'Galiojimas',
    'expires'                                         => 'Pasibaigia',
    'export_clients'                                  => 'Eksporto klientai',
    'export_data'                                     => 'Eksportuoti duomenis',
    'export_expenses'                                 => 'Eksporto išlaidos',
    'export_invoice_items'                            => 'Eksportuoti saskaitos fakturos elementus',
    'export_invoices'                                 => 'Eksporto saskaitos fakturos',
    'export_payments'                                 => 'Eksporto mokejimai',
    'export_quote_items'                              => 'Eksportuoti citatos elementus',
    'export_quotes'                                   => 'Eksportuoti citatas',
    'fax'                                             => 'Faksas',
    'fax_number'                                      => 'Fakso numeris',
    'field_label'                                     => 'Lauko etikete',
    'field_meta'                                      => 'Lauko meta',
    'field_meta_description'                          => 'Lauko lauka naudokite tik tada, jei lauko tipas yra išskleidžiamasis meniu. Noredami nurodyti išskleidžiamuju verciu reikšmes, iveskite kableliais atskirtu išskleidžiamuju verciu saraša.',
    'field_type'                                      => 'Lauko tipas',
    'footer'                                          => 'Porašte',
    'format'                                          => 'Formatas',
    'frequency'                                       => 'Dažnis',
    'from'                                            => 'Nuo',
    'from_date'                                       => 'Nuo datos',
    'general'                                         => 'Generolas',
    'generate_keys'                                   => 'Generuoti raktus',
    'group'                                           => 'Grupe',
    'group_form'                                      => 'Grupes forma',
    'groups'                                          => 'Grupes',
    'header_title_text'                               => 'Antraštes pavadinimo tekstas',
    'help'                                            => 'Pagalba',
    'help_currency_code'                              => 'Valiutos kodas, pvz.',
    'help_currency_name'                              => 'Valiutos pavadinimas, pvz.',
    'help_currency_symbol'                            => 'Valiutos simbolis, pvz.',
    'help_currency_symbol_placement'                  => 'Kur deti valiutos simboli.',
    'help_text_client_name'                           => 'Ši verte gali buti imones ar asmens vardas ir bus rodoma citatuose ir saskaitose. Ši verte neturi buti unikali.',
    'help_text_client_password'                       => 'Palikite ši lauka tušcia, nebent sukuriate ar nenustatote slaptažodžio iš naujo.',
    'help_text_client_unique_name'                    => 'Kai vienas ar keli sistemos klientai turi ta pati varda, turi buti pateiktas unikalus vardas, kad butu galima juos atskirti. Ši verte nebus rodoma citatuose ar saskaitose fakturose.',
    'i_accept'                                        => 'Aš priimu',
    'import_data'                                     => 'Importuoti duomenis',
    'inactive'                                        => 'Neaktyvus',
    'income'                                          => 'Pajamos',
    'install'                                         => 'Diegti',
    'installation_complete'                           => 'Instaliacija baigta',
    'installing_please_wait'                          => 'Diegiama, palaukite ...',
    'invalid_credentials'                             => 'Neteisingi igaliojimai',
    'invoice'                                         => 'Saskaita faktura',
    'invoice_default'                                 => 'Numatytoji saskaita faktura',
    'invoice_email_subject'                           => 'Saskaitos fakturos el. Pašto adresas',
    'invoice_items'                                   => 'Saskaitos fakturos elementai',
    'invoice_number'                                  => 'Saskaitos numeris',
    'invoice_summary'                                 => 'Saskaitos fakturu suvestine',
    'invoiced'                                        => 'Saskaita faktura',
    'invoices'                                        => 'Saskaitos',
    'invoices_due_after'                              => 'Saskaitos fakturos, moketinos po (dienu)',
    'issued'                                          => 'Išleista',
    'item'                                            => 'Preke',
    'item_lookup_form'                                => 'Prekiu paieškos forma',
    'item_lookups'                                    => 'Prekiu paieškos',
    'item_sales'                                      => 'Prekiu pardavimas',
    'items'                                           => 'Daiktai',
    'label_invoice'                                   => 'Pasirinkite saskaita faktura, prie kurios pridesite šias išlaidas',
    'label_item_description'                          => 'Iveskite šiu išlaidu apraša (nebutina)',
    'label_item_name'                                 => 'Iveskite eilutes elemento, kuri norite prideti prie saskaitos, pavadinima',
    'landscape'                                       => 'Peizažas',
    'language'                                        => 'Kalba',
    'left_pad'                                        => 'Kairysis padas',
    'left_pad_description'                            => 'Nuliu skaicius, pasirinktinai paliekant kita skaiciu su.',
    'legal'                                           => 'Teiseta',
    'letter'                                          => 'Laiškas',
    'license_agreement'                               => 'Licencijos sutartis',
    'license_agreement_accept'                        => 'Aš sutinku su licencijos sutarties salygomis',
    'logo'                                            => 'Logotipas',
    'mail_hash_error'                                 => 'Panašu, kad jusu slaptasis raktas buvo pakeistas nuo tada, kai paskutini karta išsaugojote el. Pašto slaptažodi. Noredami ištaisyti šia klaida, eikite i sistemos nustatymus -',
    'manual'                                          => 'Rankinis',
    'map_fields_to_import'                            => 'Žemelapiu laukai, kuriuos norite importuoti',
    'merchant_api_key'                                => 'API raktas',
    'merchant_api_password'                           => 'API slaptažodis',
    'merchant_api_username'                           => 'API vartotojo vardas',
    'merchant_publishable_key'                        => 'Publikuojamas raktas',
    'merchant_secret_key'                             => 'Slaptas raktas',
    'merchant_signature'                              => 'Parašas',
    'mobile'                                          => 'Mobilusis',
    'mobile_number'                                   => 'Mobilaus telefono numeris',
    'monthly'                                         => 'Kas menesi',
    'months'                                          => 'Menesiu',
    'multiple_email_validation'                       => 'Keli el. Pašto adresai turetu buti galiojantys ir atskirti kableliais.',
    'name'                                            => 'vardas',
    'net_income'                                      => 'Grynosios pajamos',
    'never'                                           => 'Niekada',
    'new'                                             => 'Nauja',
    'next_date'                                       => 'Kita data',
    'next_number'                                     => 'Kitas numeris',
    'no'                                              => 'Ne',
    'no_open_invoices'                                => 'Šis klientas neturi neapmoketu saskaitu fakturu. Noredamas atsiskaityti už išlaidas, klientas turi tureti bent viena saskaita, kuri nebuvo visiškai apmoketa.',
    'no_records_found'                                => 'Irašu nerasta.',
    'none'                                            => 'Ne vienas',
    'not_billable'                                    => 'Neapmokestinama',
    'not_billed'                                      => 'Neapmoketa',
    'not_viewed'                                      => 'Neperžiureta',
    'not_visible'                                     => 'Nematomas',
    'note'                                            => 'Pastaba',
    'note_notification'                               => 'Pranešimas: nauja pastaba',
    'notes'                                           => 'Pastabos',
    'online_payment'                                  => 'Mokejimas internetu',
    'online_payment_method'                           => 'Mokejimo internetu budas',
    'online_payments'                                 => 'Mokejimai internetu',
    'options'                                         => 'Galimybes',
    'other'                                           => 'Kita',
    'output_type'                                     => 'Išvesties tipas',
    'overdue'                                         => 'Paveluota',
    'overdue_email_subject'                           => 'Paveluotas el. Pašto adresas',
    'overdue_invoice_reminder'                        => 'Praleistas saskaitos fakturos priminimas',
    'overdue_invoice_reminder_frequency'              => 'Paveluoto saskaitos fakturos priminimo dažnumas',
    'overdue_invoice_reminder_frequency_help'         => 'Kableliais atskirtu dienu PO Saskaita faktura turi išsiusti priminima. Palikite tušcia, jei norite išjungti veluojancius saskaitu fakturu priminimus. Pavyzdžiui, 1,5,10 verte nusius priminimus praejus 1, 5 ir 10 dienu nuo saskaitos fakturos pateikimo dienos.',
    'overdue_invoices'                                => 'Praleistos saskaitos fakturos',
    'paid'                                            => 'Mokama',
    'paper_orientation'                               => 'Popieriaus orientacija',
    'paper_size'                                      => 'Popieriaus dydis',
    'password'                                        => 'Slaptažodis',
    'password_confirmation'                           => 'Slaptažodžio patvirtinimas',
    'password_successfully_reset'                     => 'Slaptažodis sekmingai nustatytas iš naujo',
    'pay'                                             => 'Mokek',
    'pay_now'                                         => 'Sumokek dabar',
    'payment_applied'                                 => 'Jusu mokejimas pritaikytas',
    'payment_button_text'                             => 'Mokejimo mygtuko tekstas',
    'payment_date'                                    => 'Mokejimo diena',
    'payment_form'                                    => 'Mokejimo forma',
    'payment_method'                                  => 'Mokejimo budas',
    'payment_method_form'                             => 'Mokejimo budo forma',
    'payment_methods'                                 => 'mokejimo metodai',
    'payment_receipt'                                 => 'Mokejimo kvitas',
    'payment_receipt_email_subject'                   => 'Mokejimo kvito el. Pašto adresas',
    'payments'                                        => 'Mokejimai',
    'payments_collected'                              => 'Surinkti mokejimai',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'PDF tvarkykle',
    'pdf_driver_wkhtmltopdf'                          => 'Naudojant wkhtmltopdf PDF tvarkykle, lauke „Dvejetainis kelias“ turi buti galiojantis failo kelias.',
    'percent'                                         => 'Procentais',
    'phone'                                           => 'Telefonas',
    'phone_number'                                    => 'Telefono numeris',
    'php_version_error'                               => 'PHP neatitinka versijos reikalavimo (% s)',
    'placeholder_type_message'                        => 'Iveskite pranešima ...',
    'portrait'                                        => 'Portretas',
    'postal_code'                                     => 'Pašto kodas',
    'prefix'                                          => 'Priešdelis',
    'prerequisites'                                   => 'Butinos salygos',
    'preview'                                         => 'Peržiura',
    'price'                                           => 'Kaina',
    'private'                                         => 'Privatus',
    'problem_with_email_template'                     => 'Atrodo, kad kilo problemu del el. Pašto šablono. Prašome patikrinti šablonus sistemos nustatymu skirtuke El. Paštas.',
    'product'                                         => 'Produktas',
    'profit_and_loss'                                 => 'Pelnas ir nuostoliai',
    'public'                                          => 'Viešas',
    'qty'                                             => 'Kiekis',
    'quantity'                                        => 'Kiekis',
    'quantity_price_decimals'                         => 'Dešimtainiu skaiciu skaicius ir kiekis',
    'quote'                                           => 'Citata',
    'quote_approved'                                  => 'Citata patvirtinta',
    'quote_approved_email_body'                       => 'Citata Patvirtinta el. Pašto dežute',
    'quote_default'                                   => 'Numatyta citata',
    'quote_email_subject'                             => 'Citata El. Laiško tema',
    'quote_items'                                     => 'Cituoti daiktus',
    'quote_number'                                    => 'Pasiulymo numeris',
    'quote_rejected'                                  => 'Citata atmesta',
    'quote_rejected_email_body'                       => 'Citata Atmesta el. Pašto adreso turinys',
    'quote_status_change_notification'                => 'Pranešimas: citatos busenos pakeitimas',
    'quote_summary'                                   => 'Citatu santrauka',
    'quote_to_invoice'                                => 'Citata i saskaita faktura',
    'quotes'                                          => 'Citatos',
    'quotes_expire_after'                             => 'Citatos baigiasi po (dienu)',
    'recalculate'                                     => 'Perskaiciuokite',
    'recalculate_help_text'                           => 'Perskaiciavimas gali užtrukti kelias akimirkas. Kai procesas bus baigtas, bus rodomas pranešimas.',
    'recalculate_invoices'                            => 'Perskaiciuokite saskaitas fakturas',
    'recalculate_quotes'                              => 'Perskaiciuokite citatas',
    'recalculating_wait'                              => 'Perskaiciuojama, palaukite ...',
    'recalculation_complete'                          => 'Perskaiciavimas baigtas',
    'recent_invoices'                                 => 'Naujausios saskaitos fakturos',
    'recent_payments'                                 => 'Naujausi mokejimai',
    'recent_quotes'                                   => 'Naujausios citatos',
    'record_not_found'                                => 'Irašas nerastas',
    'record_successfully_created'                     => 'Irašas sekmingai sukurtas',
    'record_successfully_deleted'                     => 'Irašas sekmingai ištrintas',
    'record_successfully_updated'                     => 'Irašas sekmingai atnaujintas',
    'records_imported_successfully'                   => 'Irašai importuoti sekmingai',
    'recurring'                                       => 'Pasikartojantis',
    'reject'                                          => 'Atmesti',
    'rejected'                                        => 'Atstumtas',
    'rejected_quotes'                                 => 'Atmesta citata',
    'remember_me'                                     => 'Prisimink mane',
    'remove_logo'                                     => 'Pašalinti logotipa',
    'report_rev_client_notice'                        => 'Ši ataskaita bus prieinama, kai i sistema ivesite keleta mokejimu.',
    'reports'                                         => 'Ataskaitos',
    'require'                                         => 'Reikalauti',
    'reset_number'                                    => 'Nustatyti numeri iš naujo',
    'reset_password'                                  => 'Atstatyti slaptažodi',
    'results_per_page'                                => 'Rezultatai viename puslapyje',
    'revenue_by_client'                               => 'Kliento pajamos',
    'round_tax_decimals'                              => 'Dešimtainiu skaitmenu skaicius apvalinant mokescius',
    'run_report'                                      => 'Vykdyti ataskaita',
    'save'                                            => 'Sutaupyti',
    'save_and_apply_exchange_rate'                    => 'Išsaugokite ir pritaikykite valiutu kursa',
    'save_item_as_lookup'                             => 'Išsaugoti elementa kaip paieška',
    'search'                                          => 'Paieška',
    'select_file_to_import'                           => 'Pasirinkite faila, kuri norite importuoti',
    'send'                                            => 'Siusti',
    'sending'                                         => 'Siunciu',
    'sendmail_path'                                   => '„Sendmail“ kelias',
    'sent'                                            => 'Išsiusta',
    'sent_invoices'                                   => 'Išsiustos saskaitos fakturos',
    'sent_quotes'                                     => 'Išsiustos / laukiancios citatos',
    'settings'                                        => 'Nustatymai',
    'settings_successfully_saved'                     => 'Nustatymai sekmingai išsaugoti',
    'setup'                                           => 'Saranka',
    'sign_in'                                         => 'Prisijungti',
    'sign_out'                                        => 'Atsijungti',
    'skin'                                            => 'Oda',
    'smtp_encryption'                                 => 'SMTP šifravimas',
    'smtp_host_address'                               => 'SMTP pagrindinio kompiuterio adresas',
    'smtp_host_port'                                  => 'SMTP pagrindinio kompiuterio prievadas',
    'smtp_password'                                   => 'SMTP slaptažodis',
    'smtp_username'                                   => 'SMTP vartotojo vardas',
    'start_date'                                      => 'Pradžios data',
    'state'                                           => 'Valstija',
    'status'                                          => 'Statusas',
    'step_database_setup'                             => 'Šis žingsnis idiegs ir atnaujins jusu duomenu bazes lenteles. Šis veiksmas gali užtrukti kelias akimirkas.',
    'step_prerequisites'                              => 'Kad butu galima testi diegima, reikia išspresti šias butinas salygas:',
    'subject'                                         => 'Tema',
    'submit'                                          => 'Pateikti',
    'subtotal'                                        => 'Tarpine suma',
    'summary'                                         => 'Santrauka',
    'symbol'                                          => 'Simbolis',
    'symbol_placement'                                => 'Simbolio talpinimas',
    'system'                                          => 'Sistema',
    'system_settings'                                 => 'Sistemos nustatymai',
    'table_name'                                      => 'Lenteles pavadinimas',
    'tax'                                             => 'Mokesciai',
    'tax_1'                                           => '1 mokestis',
    'tax_2'                                           => '2 mokestis',
    'tax_rate'                                        => 'Mokescio tarifas',
    'tax_rate_form'                                   => 'Mokescio tarifo forma',
    'tax_rate_name'                                   => 'Mokescio tarifo pavadinimas',
    'tax_rate_percent'                                => 'Mokescio tarifas procentais',
    'tax_rates'                                       => 'Mokesciu tarifai',
    'tax_summary'                                     => 'Mokesciu suvestine',
    'taxable_amount'                                  => 'Apmokestinamoji suma',
    'taxes'                                           => 'Mokesciai',
    'template'                                        => 'Šablonas',
    'terms_and_conditions'                            => 'Terminai ir salygos',
    'test_mode'                                       => 'Testavimo režimas',
    'text'                                            => 'Tekstas',
    'textarea'                                        => '„Textarea“',
    'this_quarter'                                    => 'Šis kvartalas',
    'thousands_separator'                             => 'Tukstanciai separatoriaus',
    'timezone'                                        => 'Laiko zona',
    'to'                                              => 'I',
    'to_date'                                         => 'Iki šiol',
    'total'                                           => 'Iš viso',
    'total_balance'                                   => 'Bendras likutis',
    'total_invoiced'                                  => 'Iš viso saskaitos fakturos',
    'total_expenses'                                  => 'Iš viso išlaidu',
    'total_paid_invoices'                             => 'Iš viso apmoketu saskaitu',
    'try_again'                                       => 'Bandyk iš naujo',
    'uninstall'                                       => 'Pašalinti',
    'uninstall_addon_warning'                         => 'Ar tikrai norite išjungti ši prieda?',
    'unique_name'                                     => 'Unikalus vardas',
    'unknown_error'                                   => 'Nežinoma klaida',
    'upcoming_payment_notice_email_body'              => 'Busimas mokejimo pranešimo el. Laiško turinys',
    'upcoming_payment_notice_email_subject'           => 'Busimas mokejimo pranešimo el. Pašto adresas',
    'upcoming_payment_notice_frequency'               => 'Busimas mokejimo pranešimo dažnumas',
    'upcoming_payment_notice_frequency_help'          => 'Kableliais atskirtu dienu PRIEŠ saskaita faktura reikia išsiusti priminima. Jei norite išjungti busimus mokejimo pranešimus, palikite tušcia. Pavyzdžiui, verte 1,5 siuncia pranešimus likus 1 ir 5 dienoms iki saskaitos fakturos mokejimo termino.',
    'update_available'                                => '„FusionInvoice :version“ galima atsisiusti!',
    'update_exchange_rate'                            => 'Atnaujinti valiutos kursa',
    'update_not_available'                            => 'Šiuo metu nera jokiu atnaujinimu.',
    'upload_progress'                                 => 'Ikelimo pažanga',
    'user'                                            => 'Vartotojas',
    'user_accounts'                                   => 'Vartotojo abonementai',
    'user_form'                                       => 'Vartotojo forma',
    'users'                                           => 'Vartotojai',
    'validation_invoice_summary_from_date'            => 'Nuo datos saskaitos fakturos suvestines informacijos suvestines valdiklyje butina nurodyti, kai dienu seka nustatyta kaip pasirinktine dienu seka.',
    'validation_invoice_summary_to_date'              => 'Saskaitos fakturu suvestines informacijos suvestines valdiklyje nurodyta data yra reikalinga, kai naudojama tinkinta dienu seka.',
    'validation_quote_summary_from_date'              => '„Citatos suvestines informacijos suvestines valdiklyje“ nuo datos reikia naudoti, kai naudojate pasirinktine dienu seka.',
    'validation_quote_summary_to_date'                => 'Datos, nurodytos citatos suvestines informacijos suvestines valdiklyje, reikia norint naudoti pasirinktine dienu seka.',
    'vendor'                                          => 'Pardavejas',
    'version'                                         => 'Versija',
    'view'                                            => 'Vaizdas',
    'view_all'                                        => 'Peržiureti visus',
    'view_all_invoices_for_client'                    => 'Peržiurekite visas šio kliento saskaitas fakturas',
    'view_all_payments_for_client'                    => 'Peržiurekite visus šio kliento mokejimus',
    'view_all_quotes_for_client'                      => 'Peržiurekite visas šio kliento citatas',
    'view_approved_quotes'                            => 'Peržiureti patvirtintas citatas',
    'view_client'                                     => 'Peržiureti klienta',
    'view_draft_invoices'                             => 'Peržiureti saskaitu fakturu projekta',
    'view_draft_quotes'                               => 'Peržiureti juodrašciu pasiulymus',
    'view_overdue_invoices'                           => 'Peržiureti pradelstas saskaitas fakturas',
    'view_payments'                                   => 'Peržiureti mokejimus',
    'view_rejected_quotes'                            => 'Peržiureti atmestas citatas',
    'view_sent_invoices'                              => 'Peržiureti išsiustas saskaitas fakturas',
    'view_sent_quotes'                                => 'Peržiureti išsiustas citatas',
    'view_unique_name'                                => 'Peržiureti unikalu varda',
    'viewed'                                          => 'Peržiureta',
    'visible'                                         => 'Matomas',
    'visible_after_payment'                           => 'Matoma po apmokejimo',
    'web'                                             => 'Žiniatinklis',
    'web_address'                                     => 'Tinklalapio adresas',
    'weekly'                                          => 'Kas savaite',
    'weeks'                                           => 'Savaites',
    'welcome'                                         => 'Sveiki',
    'what_to_import'                                  => 'Ka noretumete importuoti?',
    'year'                                            => 'Metai',
    'yearly'                                          => 'Kasmet',
    'years'                                           => 'Metai',
    'yes'                                             => 'Taip',
    'you_may_now_sign_in'                             => 'Dabar galite prisijungti!',

    // 2017-1
    'all_company_profiles'                            => 'Visi imones profiliai',
    'cannot_delete_record_in_use'                     => 'Šis irašas naudojamas ir jo negalima ištrinti.',
    'cannot_edit_record_in_use'                       => 'Šis irašas yra naudojamas ir jo negalima redaguoti.',
    'change_company_profile'                          => 'Keisti imones profili',
    'company_profile'                                 => 'Kompanijos profilis',
    'company_profiles'                                => 'Imones profiliai',
    'company_profile_form'                            => 'Imones profilio forma',
    'copy'                                            => 'Kopijuoti',
    'create_recurring_invoice'                        => 'Sukurkite pasikartojancia saskaita faktura',
    'custom'                                          => 'Pasirinktinis',
    'date_range'                                      => 'Data asortimentas',
    'day_short_sunday'                                => 'Su',
    'day_short_monday'                                => 'Mo',
    'day_short_tuesday'                               => 'Tu',
    'day_short_wednesday'                             => 'Mes',
    'day_short_thursday'                              => 'Th',
    'day_short_friday'                                => 'Kun',
    'day_short_saturday'                              => 'Sa',
    'default_company_profile'                         => 'Numatytasis imones profilis',
    'first_quarter'                                   => 'Pirmasis ketvirtis',
    'fourth_quarter'                                  => 'Ketvirta ketvirti',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Paskutines 7 dienos',
    'last_30_days'                                    => 'Paskutines 30 dienu',
    'last_month'                                      => 'Praeita menesi',
    'last_quarter'                                    => 'Paskutinis ketvirtis',
    'last_year'                                       => 'Praeitais metais',
    'month_january'                                   => 'Sausio men',
    'month_february'                                  => 'Vasario men',
    'month_march'                                     => 'Kovas',
    'month_april'                                     => 'Balandis',
    'month_may'                                       => 'Geguže',
    'month_june'                                      => 'Birželio men',
    'month_july'                                      => 'Liepos men',
    'month_august'                                    => 'Rugpjutis',
    'month_september'                                 => 'Rugsejo men',
    'month_october'                                   => 'Spalio men',
    'month_november'                                  => 'Lapkricio men',
    'month_december'                                  => 'Gruodžio men',
    'recurring_invoice'                               => 'Pasikartojanti saskaita faktura',
    'second_quarter'                                  => 'Antras ketvirtis',
    'stop_date'                                       => 'Stop data',
    'third_quarter'                                   => 'Trecias ketvirtis',
    'this_month'                                      => 'Ši menesi',
    'this_year'                                       => 'Šiais metais',
    'today'                                           => 'Šiandien',
    'user_account'                                    => 'Vartotojo paskyra',
    'yesterday'                                       => 'Vakar',

    // 2017-3
    'mail_log'                                        => 'Pašto žurnalas',
    'recent_client_activity'                          => 'Naujausia kliento veikla',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Išskirkite neapmoketas saskaitas fakturas',

    // 2017-7
    'please_wait'                                     => 'Prašau palauk...',
    'reply_to_address'                                => 'Atsakyti i adresa',

    // 2017-8
    'admin'                                           => 'Administratorius',
    'admin_account'                                   => 'Administratoriaus paskyra',
    'admin_accounts'                                  => 'Administratoriaus paskyros',
    'all_accounts'                                    => 'Visos saskaitos',
    'api_key'                                         => 'API raktas',
    'client_account'                                  => 'Kliento saskaita',
    'client_accounts'                                 => 'Kliento saskaitos',
    'client_id'                                       => 'Kliento ID',
    'client_secret'                                   => 'Kliento paslaptis',
    'enable_bitcoin_payments'                         => 'Igalinti „Bitcoin Payments“',
    'live'                                            => 'Tiesiogiai',
    'mode'                                            => 'Režimas',
    'publishable_key'                                 => 'Publikuojamas raktas',
    'sandbox'                                         => 'Smelio deže',
    'secret_key'                                      => 'Slaptas raktas',
    'type'                                            => 'Tipas',

    // 2017-10
    'deselect_all'                                    => 'Atzymeti visus pasirinkimus',
    'select_all'                                      => 'Pasirinkti viska',
    'use_24_hour_time_format'                         => 'Naudokite 24 valandu laiko formata',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Ar tikrai norite ištrinti šiuos irašus?',
    'bulk_invoice_change_status_warning'              => 'Ar tikrai norite pakeisti pasirinktos (-u) saskaitos (-u) busena?',
    'bulk_quote_change_status_warning'                => 'Ar tikrai norite pakeisti pasirinktos (-u) citatos (-u) busena?',
    'calculate_as_vat_gst'                            => 'Apskaiciuokite kaip PVM / GST',
    'change_status'                                   => 'Keisti busena',
    'default_status_filter'                           => 'Numatytasis busenos filtras',
    'error_applying_payment'                          => 'Taikant ši mokejima ivyko klaida. Pabandykite naudoti kita kortele ar mokejimo metoda.',
    'remaining'                                       => 'Likes',

    // 2017-12
    'invoice_date'                                    => 'Saskaitos data',
    'include_profit_based_on'                         => 'Itraukti pelna, pagrista',

    // 2018-1
    'add_contact'                                     => 'Prideti kontakta',
    'allow_self_signed_cert'                          => 'Leisti paciu pasirašyta sertifikata',
    'backup'                                          => 'Atsargine kopija',
    'close'                                           => 'Uždaryti',
    'change_invoice_date_to_todays_date'              => 'Pakeiskite saskaitos fakturos data i šios dienos data',
    'change_quote_date_to_todays_date'                => 'Pakeiskite citatos data i šios dienos data',
    'contacts'                                        => 'Kontaktai',
    'default_bcc'                                     => 'Numatytasis BCC',
    'default_cc'                                      => 'Numatytasis CC',
    'default_to'                                      => 'Numatytasis',
    'disable'                                         => 'Išjungti',
    'download_database_backup'                        => 'Atsisiuskite duomenu bazes atsargine kopija',
    'edit_contact'                                    => 'Redaguoti kontakta',
    'expense_list'                                    => 'Išlaidu sarašas',
    'keep_invoice_date_as_is'                         => 'Išsaugoti saskaitos fakturos data tokia, kokia yra',
    'keep_quote_date_as_is'                           => 'Laikykite citatos data tokia, kokia yra',
    'if_quote_is_emailed_while_draft'                 => 'Jei citata siunciama el. Laiško busenoje',

    // 2018-4
    'force_https'                                     => 'Priversti HTTPS',
    'force_https_help'                                => 'Prieš ijungdami šia parinkti, isitikinkite, kad jusu „FusionInvoice“ diegimas veikia per https. To nepadarius, gali buti nefunkcionalus (bet pataisomas) diegimas.',

    // 2019-1
    'attached_to'                                     => 'Pridedamas prie',
    'customer'                                        => 'Klientas',
    'expense'                                         => 'Išlaidos',
    'expense_categories'                              => 'Išlaidu kategorijos',
    'expense_category_form'                           => 'Išlaidu kategorijos forma',
    'expense_vendors'                                 => 'Išlaidu pardavejai',
    'expense_vendor_form'                             => 'Išlaidu tiekejo forma',
    'lead'                                            => 'Vadovauti',
    'local_time'                                      => 'Vietinis laikas',
    'prospect'                                        => 'Perspektyva',
    'search_clients'                                  => 'Ieškoti klientu',
    'search_expenses'                                 => 'Paieškos išlaidos',
    'search_invoices'                                 => 'Ieškoti saskaitu fakturu',
    'search_items'                                    => 'Ieškoti elementu',
    'search_log'                                      => 'Paieškos žurnalas',
    'search_quotes'                                   => 'Paieškos citatos',
    'search_payments'                                 => 'Paieškos mokejimai',
    'search_recurring_invoices'                       => 'Ieškoti pasikartojanciu saskaitu fakturu',
    'show_all_statuses'                               => 'Rodyti visus busenas',
    'show_all_types'                                  => 'Rodyti visus tipus',
    'unknown'                                         => 'Nežinoma',
    'value'                                           => 'Verte',

    // 2019-2
    'default'                                         => 'Numatytas',
    'no_data_available'                               => 'Nera duomenu',
    'recurring_invoice_list'                          => 'Pasikartojanciu saskaitu fakturu sarašas',
    'report_total'                                    => 'Pranešti iš viso',

    //2019-3
    'checkbox'                                        => 'Žymimasis langelis',
    'custom_dropdown_validate'                        => 'Laukelyje :label pasirinkite galiojancia parinkti',
    'custom_image_validate'                           => 'Pasirinkite tinkama vaizda.',
    'custom_tag_validate'                             => 'Pasirinkite galiojancia žyma iš :label',
    'custom_text_validate'                            => 'Lauke :label iveskite galiojanti :label.',
    'datetime'                                        => 'DateTime',
    'decimal'                                         => 'Dešimtainis skaicius',
    'delete-confirm'                                  => 'Ar tu tuo tikras?',
    'grand_total'                                     => 'Iš viso',
    'image'                                           => 'Vaizdas',
    'integer'                                         => 'Sveikasis skaicius',
    'mailed'                                          => 'Paštu',
    'mailed_invoices'                                 => 'Saskaitos paštu',
    'radio'                                           => 'Radijas',
    'recurring_id'                                    => 'Pasikartojantis ID',
    'remove_image'                                    => 'Pašalinti vaizda',
    'tags'                                            => 'Žymos',
    'tagselection'                                    => 'Žymos pasirinkimas',
    'unpaid'                                          => 'Neapmoketa',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Peržiureti saskaitas paštu',
    'important'                                       => 'Svarbu!',
    'created_recurring_invoice_id'                    => 'Sukurta iš pasikartojancios saskaitos fakturos ID',
    'mr'                                              => 'Ponas.',
    'miss'                                            => 'Panele',
    'ms'                                              => 'Ponia',
    'mrs'                                             => 'Ponia.',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Kontaktu pavadinimas',
    'title'                                           => 'Pavadinimas',
    'test_email_subject'                              => 'Sveiki iš „FusionInvoice“',
    'test_email_body'                                 => 'Tai bandomasis „FusionInvoice“ el. Laiškas.',
    'test_email_address'                              => 'Siusti el. Pašto testa',
    'send_test_email'                                 => 'Siusti bandomaji el. Laiška',
    'invalid_json'                                    => 'Iveskite galiojancia JSON eilute',
    'textarea_rows_limit'                             => 'Eilutes negali viršyti :limit',
    'custom_integer_validate'                         => ':label turi buti teisinga sveiko skaiciaus reikšme',

    //2020-1
    'user_role'                                       => 'Vartotojo vaidmuo',
    'standard_user'                                   => 'Standartinis vartotojas',
    'permissions'                                     => 'Leidimai',
    'modules'                                         => 'Moduliai',
    'is_view'                                         => 'Vaizdas',
    'is_create'                                       => 'Kurti',
    'is_update'                                       => 'Atnaujinti',
    'is_delete'                                       => 'Ištrinti',
    'dashboards'                                      => 'Prietaisu skydeliai',
    'allow_time_period_change'                        => 'Leisti laikotarpio keitima',
    'page_not_found'                                  => 'Oi! Puslapis nerastas.',
    'return_to_dashboard'                             => 'We could not find the page you were looking for. <a href =</a>.',
    'no_auth_to_create_client'                        => 'Jus neturite teises kurti klientu!',
    'check-all'                                       => 'Viska Patikrink',
    'invoice_prefix'                                  => 'Saskaitos fakturos priešdelis',
    'recently_viewed'                                 => 'Neseniai žiureta',
    'copy_from'                                       => 'Kopijuoti iš',
    'select_user'                                     => 'Pasirinkite Vartotojas',
    'please_select_user'                              => 'Pasirinkite naudotoja iš sarašo',
    'allow_client_center_login'                       => 'Leisti prisijungti prie klientu centro',
    'online_payment_processing_fee'                   => 'Mokejimo internetu apdorojimo mokestis',
    'client_password_required'                        => 'Iveskite kliento slaptažodi',
    'last_login_at'                                   => 'Paskutinis prisijungimas',
    'show_notes_panel_below_client'                   => 'Rodyti pastabu skydeli žemiau Kliento informacijos',
    'notepad'                                         => 'Užrašu knygele',
    'added'                                           => 'Prideta',
    'last_edited'                                     => 'Paskutini karta redaguota',
    'loading'                                         => 'Apdorojimas ....',
    'n_records_match'                                 => ':label Irašykite :plural rungtynes',
    'initials'                                        => 'Inicialai',
    'initials_bg_color'                               => 'Inicialu fono spalva',
    'more'                                            => 'Daugiau',
    'must_match_all'                                  => 'Turi atitikti visus',
    'clear'                                           => 'Aišku',
    'no_client_tags'                                  => 'Nera kliento irašu su apibrežtomis žymomis.',
    'qr_code_on_invoice_quote'                        => 'Saskaitos fakturos ir citatos QR kodas',
    'delete_tags'                                     => 'Žymu valymas',
    'orphan_tags_deleted'                             => 'Sekmingai ištrintos visos našlaiciu žymos iš sistemos.',
    'orphan_tags_delete_confirm'                      => 'Vykdydami Žymu valyma pašalinsite visas nepanaudotas žymas. Testi?',
    'deleting_tags_wait'                              => 'Ištrinamos žymos, palaukite ...',
    'new-version-available'                           => 'Yra nauja versija!',
    'ignore-this-version'                             => 'Nepaisykite šios versijos',
    'view-release-notes'                              => 'Peržiureti laidos pastabas',
    'task_list'                                       => 'Užduociu sarašas',
    'create_task'                                     => 'Sukurti užduoti',
    'open'                                            => 'Atviras',
    'closed'                                          => 'Uždaryta',
    'assignee'                                        => 'Paskirtas asmuo',
    'task'                                            => 'Užduotis',
    'task_successfully_created'                       => 'Užduotis sekmingai sukurta',
    'task_successfully_updated'                       => 'Užduotis sekmingai atnaujinta',
    'task_completed'                                  => 'Užduotis sekmingai atlikta',
    'task_marked_incomplete'                          => 'Užduotis vel atidaryta',
    'due_date_validation_date'                        => 'Pasirinkite galiojancia termina',
    'assignee_validation_required'                    => 'Iš sarašo pasirinkite galiojanti peremeja',
    'assignee_validation_exists'                      => 'Iš sarašo pasirinkite galiojanti peremeja',
    'tomorrow'                                        => 'Rytoj',
    'task_not_authorized'                             => 'Jus nesate igaliotas redaguoti šios užduoties!',
    'me'                                              => 'Aš',
    'task_from_note'                                  => 'Sukurti užduoti išsaugoti',
    'done'                                            => 'padaryta',
    'refresh'                                         => 'Atnaujinti',
    'task_list_page_size'                             => 'Užduociu skaicius viename puslapyje',
    'select_client'                                   => 'Pasirinkite klientas',
    'note-search-config'                              => 'Pastabos, kurias norite itraukti',
    'username'                                        => 'Vartotojo vardas',
    'task-search-config'                              => 'Užduociu paieška, kuria norite itraukti',
    'task_section_invalid'                            => 'Netinkama užduociu skiltis',
    'task_section'                                    => 'Užduoties skyrius',
    'select_section'                                  => 'Pasirinkite skyriu',
    'email-test-failed'                               => 'El. Pašto bandymas nepavyko',
    'smtp-setting-suggestion'                         => 'Pasiulymai:<br>1. Patikrinkite ir vel iveskite vartotojo / slaptažodžio reikšmes<br>2. Verify that your SMTP settings are entered correctly',
    'mail-setting-suggestion'                         => 'Pasiulymai:<br>1. Patikrinkite, ar tinkamai sukonfiguruotas PHP pašto serveris<br>2. Contact server admin',
    'sendmail-setting-suggestion'                     => 'Pasiulymai:<br>1. Patikrinkite, ar teisingai sukonfiguruotas jusu „Sendmail“ kelias.<br>2. Contact server admin',
    'sendgrid-setting-suggestion'                     => 'Pasiulymai:<br>1. Patikrinkite, ar jusu „Sendgrid“ raktas sukonfiguruotas teisingai.<br>2. Contact server admin',
    'later'                                           => 'Veliau',
    'test-email-required'                             => 'Turite ivesti galiojanti el. Laiška',
    'test_mail_sent_successfully'                     => 'Bandomasis laiškas sekmingai išsiustas',
    'test-mail-btn-title'                             => 'Prieš bandyma turi išsaugoti pakeitimus.',
    'agreement_expire'                                => 'Produktu naujiniu ir palaikymo galiojimo laikas baigsis :date',
    'agreement_expired'                               => 'Jusu produktu naujiniu ir palaikymo galiojimo laikas baigesi :date',
    'piracy_message'                                  => 'Netinkamas jusu „FusionInvoice“ licencijos raktas. Programines irangos piratavimas yra nusikaltimas. Prašau žaisti sažiningai. Turedami galiojancia licencija, gausite palaikyma, atnaujinimus ir gera karma.',
    'buy-now'                                         => 'Pirkti dabar',
    'piracy_alert'                                    => 'Prašau buti sažiningam!',
    'agreement-expire-alert'                          => 'Produktu atnaujinimas ir palaikymas netrukus baigsis.',
    'agreement-expired-alert'                         => 'Produktu atnaujinimas ir palaikymas nebegalioja.',
    'dismiss-forever'                                 => 'Atmesti visam laikui',
    'renew-now'                                       => 'Atnaujinkite dabar',
    'select_all_permissions'                          => 'Pasirinkite Visi leidimai',
    'app-key-missing'                                 => 'Iveskite licencijos rakta i config / app.php.',
    'custom_fields_column_width'                      => 'Tinkintuose laukuose rodomi stulpeliai',
    'select-user-type'                                => 'Pasirinkite Vartotojo tipas',
    'lead-or-prospect-with-invoices-error'            => 'Deja, kliento tipas negali buti „Lead“ arba „Prospect“, kai yra saskaitos fakturos arba pasikartojancios saskaitos fakturos.',
    'sendgrid_key'                                    => '„Sendgrid“ raktas',

    //2020-2.0
    'space'                                           => 'Erdve',
    'apostrophe'                                      => 'Apaštrofe',
    'comma'                                           => 'Kablelis',
    'fullstop'                                        => 'Taškas (taškas)',
    'middledot'                                       => 'Vidurinis taškas',
    'thinspace'                                       => 'Plona erdve',
    'narrow-no-break-space'                           => 'Siaura erdve be pertrauku',
    'dotabove'                                        => 'Taškas aukšciau',
    'arabic-decimal'                                  => 'Arabu dešimtainis skyriklis',
    'arabic-thousand'                                 => 'Arabu tukstantis separatorius',
    'decimal-separator-key-symbol'                    => 'Dešimtainio skyriklio rakto simbolis',
    'select-item'                                     => 'Pasirinkite elementa',
    'item-lookup-overload'                            => 'Leidžiama ieškoti ne daugiau kaip 100 elementu',
    'select-expense-category'                         => 'Pasirinkite išlaidu kategorija',
    'select-expense-vendor'                           => 'Pasirinkite „Expense Vendor“',
    'can-not-delete-all-users'                        => 'Deja, negalite ištrinti visu vartotoju iš sistemos',
    'can-not-change-default-user-role'                => 'Deja, negalite pakeisti numatytojo vartotojo vaidmens',
    'can-not-change-default-user-status'              => 'Deja, negalite pakeisti numatytojo vartotojo busenos',
    'user_not_active'                                 => 'Vartotojas nera aktyvus',
    'can-not-inactive-your-own-status'                => 'Deja, negalite padaryti saves neaktyviu.',
    'delete_user_warning'                             => '<p>SUSTABDYTI! Šio vartotojo ištrynimas yra griaunamasis veiksmas, kuris gali pašalinti irašus, kuriuos jie sukure sistemoje. Apsvarstykite galimybe padaryti vartotoja neaktyvu.</p><p>Ar tikrai norite ištrinti ši vartotoja?</p>',
    'include_time_in_due_date'                        => 'Itraukite laika i termina',
    'cannot_delete_default_company'                   => 'Negalite ištrinti numatytojo imones profilio',
    'make-user-inactive'                              => 'Padaryti vartotoja neaktyviu',
    'mail_from_address'                               => 'Paštas iš adreso',
    'mail_from_name'                                  => 'Paštas nuo vardo',
    'item_categories'                                 => 'Prekiu kategorijos',
    'select-item-category'                            => 'Pasirinkite elemento kategorija',
    'item_category_form'                              => 'Prekiu kategorijos forma',
    'sort_by_due'                                     => 'Rušiuoti pagal termina',
    'affiliate'                                       => 'Filialas',
    'parent_account'                                  => 'Tevu saskaita',
    'child_account'                                   => 'Vaiko saskaitos',
    'select_parent_client'                            => 'Pasirinkite „Tevu saskaita“',
    'record_successfully_retrieved'                   => 'Irašas sekmingai gautas',
    'custom-image-not-support'                        => 'Tinkintas vaizdo laukas nepalaikomas',
    'custom-tag-not-support'                          => 'Tinkinto žymos laukas nepalaikomas',
    'custom-checkbox-not-support'                     => 'Tinkinto žymes langelio laukas nepalaikomas',
    'custom-date-not-support'                         => 'Tinkintas datos laukas nepalaikomas',
    'custom-datetime-not-support'                     => 'Tinkinto lauko laikas nepalaikomas',
    'timeline'                                        => '„TimeLine“',
    'client_invoice'                                  => 'Saskaitos pagal klienta',
    'select_client_blank_for_all'                     => 'Pasirinkite klienta (tušcias visiems)',
    'invoice_email_success'                           => 'Saskaitos fakturos el. Paštas sekmingai išsiustas',
    'quote_email_success'                             => 'Citatos el. laiškas sekmingai išsiustas',
    'document_number_schemes'                         => 'Dokumentu numeravimas',
    'document_number_scheme'                          => 'Dokumento numerio schema',
    'document_number_scheme_form'                     => 'Dokumento numerio schemos forma',
    'default_document_number_scheme'                  => 'Numatytoji dokumento numerio schema',
    'supporting_data'                                 => 'Palaikomi duomenys',
    'customizations'                                  => 'Tinkinimai',
    'utilities_and_logs'                              => 'Komunalines paslaugos ir žurnalai',
    'system_log'                                      => 'Sistemos žurnalas',
    'paid_amount'                                     => 'Sumoketa suma',
    'payment_amount'                                  => 'Mokejimo suma',
    'payment_intent'                                  => 'Mokejimo ketinimas',
    'apply_payment_to_one_or_more_invoice'            => 'Taikykite mokejima vienai ar daugiau saskaitu fakturu',
    'pre_payment_for_future_invoices'                 => 'Išankstinis apmokejimas už busimas saskaitas',
    'apply_to_invoices'                               => 'Taikyti saskaitai (-oms)',
    'payment_application'                             => 'Mokejimo paraiška',
    'remaining_payment_balance'                       => 'Likes mokejimo balansas',
    'remaining_balance'                               => 'Esamas likutis',
    'payment_warning'                                 => 'Iveskite suma',
    'apply_pre_payment_warning'                       => 'Jus netaikete mokejimo jokioms saskaitoms fakturoms. Ar noretumete ji irašyti kaip išankstini mokejima?',
    'confirm_remaining_balance'                       => 'Likusia :value likuti bus galima pritaikyti busimoms šio kliento saskaitoms fakturoms.',
    'open_balance'                                    => 'Atviras balansas',
    'more_figure_then_total_payment'                  => 'Iveskite mokejima iš naujo, visas saskaitos apmokejimas yra didesnis nei likes likutis.',
    'remaining_payment_balance_apply_later_info'      => 'Like mokejimo likuciai veliau gali buti taikomi kitoms saskaitoms fakturoms.',
    'invoice_balance'                                 => 'Saskaitos fakturos likutis',
    'enter_payment_for_invoice'                       => 'Iveskite saskaitos fakturos mokejima',
    'invoice_pdf'                                     => 'Saskaita faktura PDF',
    'payment_applications'                            => 'Mokejimo programos',
    'multiple'                                        => 'Daugkartinis',
    'ok'                                              => 'Gerai',
    'credit_memo_default'                             => 'Kredito pažymos neivykdymas',
    'edit_payment'                                    => 'Redaguoti mokejima',
    'credit_memo'                                     => 'Kredito atmintine',
    'credit_memos'                                    => 'Kredito pažymos',
    'create_credit_memo'                              => 'Sukurkite kreditini pažymejima',
    'credit_applications'                             => 'Kredito pažymos paraiškos',
    'credit_applications_for_invoice'                 => 'Kredito atmintines paraiškos saskaitai fakturai',
    'prepayment_applications_for_invoice'             => 'Išankstinio apmokejimo paraiškos saskaitai fakturai',
    'apply_credit_memo'                               => 'Taikyti kredito pažyma',
    'apply_pre_payment'                               => 'Taikyti išankstini mokejima',
    'applied_amount'                                  => 'Taikoma suma',
    'remaining_credit_balance'                        => 'Likes kredito likutis',
    'remaining_credit_balance_apply_later_info'       => 'Like kredito likuciai veliau gali buti taikomi kitoms saskaitoms fakturoms.',
    'applied'                                         => 'Taikoma',
    'more_figure_then_invoice_amount'                 => 'Iveskite suma iš naujo, suma negali buti didesne už saskaitos fakturos suma.',
    'more_figure_then_invoice_total'                  => 'Iveskite suma iš naujo, visa pritaikyta suma negali buti didesne už saskaitos fakturos suma.',
    'invoice_not_selected_warning'                    => 'Palaukite, jus netaikete kredito pažymos jokioms saskaitoms fakturoms.',
    'select_type'                                     => 'Pasirinkite Tipas',
    'email_credit_memo'                               => 'El. Pašto kredito pažyma',
    'back_to_credit_memo'                             => 'Grižti i kreditini pažymejima',
    'invoice_amount'                                  => 'Saskaitos fakturos suma',
    'remaining_invoice_amount'                        => 'Likusi saskaitos fakturos suma',
    'settlement_for_credit_memo'                      => 'Atsiskaitymas už kredito pažyma',
    'credit_memo_amount'                              => 'Kredito pažymos suma',
    'confirm_remaining_balance_invoice'               => 'Likes šios saskaitos likutis bus :value po atsiskaitymo.',
    'payment_receipt_for_invoices'                    => 'Saskaitu fakturu apmokejimo kvitas',
    'primary_phone'                                   => 'Pagrindinis telefono numeris',
    'alternate_phone'                                 => 'Pakaitinis telefono numeris',
    'currency_not_match'                              => 'Valiuta nesutampa',
    'tasks'                                           => 'Užduotys',
    'full_and_final_payment'                          => 'pilnas',
    'partial'                                         => 'dalinis',
    'transition'                                      => [
        'created'          => 'Sukurta',
        'updated'          => 'Atnaujinta',
        'deleted'          => 'Ištrinta',
        'received'         => 'Gauta',
        'opened'           => 'Atidaryta',
        'sent'             => 'Išsiusta',
        'mail'             => 'Paštu',
        'changed'          => 'Pasikeite',
        'recurring'        => 'Sukurta',
        'completed'        => 'Baigta',
        'reversed'         => 'Atvirkštinis',
        'quote_to_invoice' => 'Citata i saskaita faktura',
        'download'         => 'parsisiusti',
        'added'            => 'Prideta',
        'email'            => 'El. paštas',
        'merge'            => 'Sujungti',
        'billed'           => 'Išrašyta saskaita',
        'failed'           => 'Nepavyko',
        'invoice'          => [
            'created'                => 'Buvo sukurta saskaita faktura :invoice_number',
            'credit_memo_created'    => 'Sukurta kreditine atmintis :credit_memo_number',
            'credit_memo_updated'    => 'Kreditine atmintis :credit_memo_number buvo pakeista',
            'created_from_recurring' => 'Buvo sukurta saskaita faktura :invoice_number (iš pasikartojancio šablono :recurring_invoice_id)',
            'updated'                => 'Saskaita faktura :invoice_number buvo pakeista',
            'deleted'                => 'Saskaita faktura :invoice_number buvo ištrinta',
            'credit_memo_deleted'    => 'Kredito atmintine :credit_memo_number buvo ištrinta',
            'status_changed'         => 'Saskaitos faktura :invoice_number busena pakeista iš :previous_value i :current_value',
            'email_sent'             => 'Saskaita faktura :invoice_number išsiusta',
            'resend_email'           => 'Saskaita faktura :invoice_number išsiusta iš naujo el. paštu',
            'email_opened'           => 'Saskaita faktura :invoice_number atidarytas',
            'payment_updated'        => 'Saskaita :invoice_number atnaujinta :full_payment_text apmokejimas',
            'payment_received'       => 'Saskaita :invoice_number gavo mokejima :full_payment_text',
            'payment_reversed'       => 'Saskaitoje :invoice_number buvo :full_payment_text',
            'invoice_tag_updated'    => 'Saskaitos fakturos žyma :tags buvo prideta prie saskaitos fakturos :invoice_number',
            'invoice_tag_deleted'    => 'Saskaitos fakturos žyma :invoice_number buvo ištrinta :tags',
            'mark_mail'              => 'Saskaita faktura :invoice_number pažymima kaip išsiusta',
            'unmark_mail'            => 'Saskaita faktura :invoice_number kauke kaip neišsiusta',
            'paid_invoice_opened'    => 'Apmoketa saskaita faktura atidaryta redaguoti',
            'sent_invoice_opened'    => 'Išsiusta saskaita faktura atidaryta redaguoti',
            'sms_sent'               => 'Saskaita :invoice_number SMS išsiusta',
        ],
        'quote'            => [
            'created'           => 'Sukurta citata :quote_number',
            'updated'           => 'Citata :quote_number buvo pakeista',
            'deleted'           => 'Citata :quote_number buvo ištrinta',
            'status_changed'    => 'Citata :quote_number Busena pakeista iš :previous_value i :current_value',
            'email_sent'        => 'Citata :quote_number el. Laiškas išsiustas',
            'resend_email'      => 'Citata :quote_number el. pašto siuntimas iš naujo',
            'email_opened'      => 'Citata :quote_number el. Laiškas atidarytas',
            'quote_to_invoice'  => ':quote_number buvo paverstas saskaita faktura - :invoice_number',
            'quote_tag_updated' => 'Citatos žyma :tags buvo prideta prie citatos :quote_number',
            'quote_tag_deleted' => 'Citatos žyma :quote_number buvo ištrinta :tags',
            'sms_sent'          => 'Citata :quote_number SMS išsiusta',
        ],
        'payment'          => [
            'prepayment_created'           => 'Buvo sukurtas išankstinis apmokejimas',
            'payment_receipt_email_sent'   => 'Mokejimo kvito el. Laiškas išsiustas',
            'payment_receipt_resend_email' => 'Mokejimo kvito el. laiškas išsiustas dar karta',
            'payment_updated'              => 'Mokejimas buvo pakeistas',
            'deleted'                      => 'Mokejimas buvo ištrintas',
            'payment_receipt_pdf_download' => 'Mokejimo kvito PDF parsisiusti',
            'payment_note_deleted'         => 'Mokejimo pažyma ištrinta:',
            'payment_note_added'           => 'Prideta mokejimo pažyma:',
            'payment_note_updated'         => 'Mokejimo pažyma atnaujinta nuo',
            'payment_failed'               => 'Mokejimas nepavyko',
        ],
        'client'           => [
            'client_created'     => ':client_type buvo sukurtas',
            'type_changed'       => ':previous_value tapo :current_value',
            'updated'            => 'Klientas buvo atnaujintas',
            'deleted'            => 'Klientas buvo ištrintas',
            'status_changed'     => 'Klientas nustatytas i :current_value',
            'client_tag_updated' => 'Prideta žyma :tags',
            'client_tag_deleted' => 'Žyma :tags ištrinta',
            'merge'              => 'Kliento ID: :idTo - :nameTo buvo sujungtas i kliento ID: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'Buvo sukurtos išlaidos',
            'updated' => 'Išlaidos buvo pakeistos',
            'deleted' => 'Išlaidos ištrintos',
            'billed'  => 'Buvo išrašytos išlaidos',
            'vendor'  => [
                'created' => 'Buvo sukurtas išlaidu pardavejas',
                'updated' => 'Išlaidu pardavejas buvo pakeistas',
                'deleted' => 'Išlaidu pardavejas buvo ištrintas',
            ],
        ],
        'note'             => [
            'created'          => 'Pastaba sukurta',
            'updated'          => 'Pastaba modifikuota',
            'deleted'          => 'Užrašas buvo ištrintas',
            'note_tag_updated' => 'Žyma :tags prideta pastaboje',
            'note_tag_deleted' => 'Žyma :tags ištrinta iš užrašo',
        ],
        'task'             => [
            'created'   => 'Užduotis buvo sukurta',
            'updated'   => 'Užduotis buvo modifikuota',
            'deleted'   => 'Užduotis buvo ištrinta',
            'completed' => 'Užduotis buvo baigta',
        ],
        'subscription'     => [
            'created'                       => 'Sukurta prenumerata :invoice_number',
            'updated'                       => 'Prenumerata :invoice_number buvo pakeista',
            'deleted'                       => 'Prenumerata :invoice_number buvo ištrinta',
            'recurring_invoice_tag_updated' => 'Prenumeratos žyma :tags buvo prideta prie prenumeratos :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'Prenumeratos žyma :recurringInvoice_number buvo ištrinta :tags',
        ],
        'attachment'       => [
            'created' => ':filename buvo ikeltas kaip priedas',
            'deleted' => ':filename buvo pašalintas kaip priedas',
        ],
        'tag'              => [
            'created' => 'Prideta žyma :tag',
            'deleted' => 'Žyma :tag buvo pašalinta',
        ],
    ],
    'reset'                                           => 'Atstatyti',
    'select_event'                                    => 'Pasirinkite Ivykio tipas',
    'select_country'                                  => 'Pasirinkite šali',
    'type_captcha'                                    => 'Prašau atsakyti i aukšciau pateikta klausima',
    'refresh_captcha'                                 => 'Atnaujinti klausima',
    'answer'                                          => 'Atsakymas',
    'use_captcha_in_login'                            => 'Prisijungdami naudokite captcha',
    'allow_client_timeline'                           => 'Laiko juosta',
    'client_timeline'                                 => 'Laiko juosta',
    'no_invoice_tags'                                 => 'Nera saskaitos fakturos žymu.',
    'total_notifications'                             => 'Turite :total pranešimus',
    'no_notifications'                                => 'Nauju pranešimu nera',
    'notifications'                                   => 'Pranešimai',
    'notification'                                    => [
        'task'  => [
            'created'           => 'Jums paskirta nauja užduotis',
            'due_date_breached' => 'Užduotis',
            'completed'         => ':user atlikta užduotis:',
        ],
        'quote' => [
            'approved'             => ':quote_number buvo patvirtintas',
            'quote_to_invoice'     => ':quote_number buvo konvertuotas i saskaita faktura -',
            'rejected'             => ':quote_number buvo atmestas',
            'payment_successfully' => 'Citata :quote_number klientui :client_name buvo apmoketa. Saskaita :invoice_number buvo sukurta ir mokejimas pritaikytas',
        ],
    ],
    'search_tasks'                                    => 'Paieškos užduotys',
    'reopen_task'                                     => 'Iš naujo atidaryti užduoti',
    'task_form'                                       => 'Prideti užduoti',
    'view_task'                                       => 'Išsami užduoties informacija',
    'client_deleted'                                  => 'Klientas ištrintas',
    'payment_canceled'                                => 'Jusu mokejimas atšauktas',
    'default_company_profile_set'                     => 'Mes nustateme jusu numatytaji imones profili. Galite bet kada ja atnaujinti naudodamiesi imones profilio nustatymais.',
    'file_uploaded_successfully'                      => 'Failas sekmingai ikeltas',
    'attachment_notice'                               => 'Maksimalus priedo failo dydis yra mažesnis arba lygus :size',
    'attachment_error'                                => 'Priedo dydis negali viršyti :size',
    'attachment_warning'                              => 'Priedo dydis yra :size. Ikeliant daug dideliu priedu, laikui begant gali pablogeti jusu duomenu bazes našumas.',
    'generate_timeline_history'                       => 'Generuoti laiko juostos istorija',
    'generating_timeline_wait'                        => 'Generuojama laiko skale, palaukite ...',
    'generating_timeline_confirm'                     => 'Laiko juostos funkcija buvo prideta prie „FusionInvoice 2020“. Tai sukurs visu veiksmu, kurie buvo vykdomi prieš ta funkcija, laiko juostos irašus. Testi?',
    'generated_timeline_request_accepted'             => 'Laiko juostos istorija sukurta.',
    'transitions'                                     => 'Laiko juostos istorija',
    'pending'                                         => 'Kol',
    'client_transition'                               => 'Kliento laiko juostos',
    'expense_transition'                              => 'Išlaidu tvarkarašciai',
    'invoice_transition'                              => 'Saskaitu fakturu tvarkarašciai',
    'payment_invoice_transition'                      => 'Mokejimo saskaitos fakturos grafikai',
    'payment_transition'                              => 'Mokejimo terminai',
    'quote_transition'                                => 'Citata „Tvarkarašciai“',
    'note_transition'                                 => 'Pastaba Laiko juostos',
    'task_transition'                                 => 'Užduociu laiko juostos',
    'email_sent'                                      => 'Saskaita faktura :invoice_number išsiusta',
    'credit_applied'                                  => 'Pritaikytas kreditas',
    'configuration'                                   => 'Konfiguracija',
    'include_prepayments'                             => 'Itraukite išankstinius mokejimus',
    'pre_payment'                                     => 'Išankstiniai mokejimai',
    'pre_payments'                                    => 'Išankstiniai mokejimai',
    'times'                                           => 'Laikai',
    'include_prepayments_applied'                     => 'Itraukti taikomus išankstinius mokejimus',
    'confirm_full_payment_applied'                    => 'Mokejimas buvo visiškai pritaikytas',
    'confirm_full_credit_memo_applied'                => 'Kredito pažyma buvo visiškai pritaikyta',
    'all_tasks'                                       => 'Visos užduotys',
    'my_tasks'                                        => 'Mano užduotys',
    'assigned_from_others'                            => 'Paskirtas fom Kiti',
    'full_payment_reversed'                           => 'visas mokejimas panaikintas.',
    'partial_payment_reversed'                        => 'dalinis mokejimas panaikintas.',
    'invoice_delete_error'                            => 'Apgailestaujame, negalite ištrinti saskaitos fakturos, kurioje yra mokejimu ar kredito pažymos programu. Pirmiausia turite ištrinti mokejimu ar kredito pažymos programas.',
    'mail-from-required'                              => 'Turite ivesti galiojanti laiška iš el. Pašto',
    'contact_updated'                                 => 'Kontaktas sekmingai atnaujintas',
    'contact_added'                                   => 'Kontaktas sekmingai pridetas',
    'generate_passport_key_wait'                      => 'Generuojamas paso raktas, palaukite ...',
    'generate_passport_key'                           => 'Generuoti paso rakta',
    'default_greeting'                                => 'Sveiki!<br>',
    'hi'                                              => 'Labas',
    'deduct_tax_from_expenses'                        => 'Išskaiciuokite mokesti iš išlaidu',
    'invalid_invoice_id'                              => 'Neteisingas saskaitos fakturos ID',
    'client_related_record_exist'                     => 'Atsiprašome, klientas turi susijusiu irašu apie:: modulius. Klientai, turintys operaciju istorija, negali buti ištrinti.',
    'email_payment_receipt_notice'                    => 'Klientas neturi savo el. Pašto adreso',
    'show_more'                                       => 'Rodyti daugiau ...',
    'show_less'                                       => 'Rodyti mažiau ...',
    'invoice_already_paid'                            => 'Saskaita jau apmoketa!',
    'system_default'                                  => 'Numatyta sistema',
    'created_by'                                      => 'Sukurta',
    'created_at'                                      => 'Sukurta',
    'task_created_by_and_created_at'                  => 'Užduotis sukurta :created_by ant :created_at',
    'dashboard_widgets_date_options'                  => 'Sistemos numatytasis saskaitos fakturos ir citatos suvestines laikotarpis',
    'dashboard-widget-from-date-required'             => 'Nuo datos reikia, kai saskaitos fakturos ir citatos suvestines sistemos numatytame sistemos laikotarpyje pasirinktas pasirinktinis dienu intervalas',
    'dashboard-widget-to-date-required'               => 'Iki šios dienos reikia, kai saskaitos fakturos ir citatos suvestines sistemos numatytame sistemos laikotarpyje pasirenkama pasirinktine dienu seka',
    'invoice_currency'                                => 'Saskaitos fakturos valiuta',
    'currency_format'                                 => 'Valiutos formatas',
    'create_missing_folder_success'                   => 'Sukurtas trukstamas reikalingas aplankas',
    'create_missing_folder_failed'                    => 'Bandymas sukurti aplanka (-us) nepavyko :path',
    'folder_is_not_writable'                          => 'Aplankas nerašomas :path',
    'update_item_as_lookup'                           => 'Atnaujinti elemento paieška',
    'number_of_tax_fields'                            => 'Mokesciu lauku skaicius',
    'tax_1_entry'                                     => '1 irašas',
    'tax_2_entries'                                   => '2 irašai',
    'require_tags_on_client_notes'                    => 'Reikalauti žymos (-iu) kliento užrašuose',
    'entered_amount_less_than_invoice_amount'         => 'Ivesta suma turi buti mažesne arba lygi saskaitos fakturos sumai',
    'send-to'                                         => 'Siusti',
    'print'                                           => 'Spausdinti',
    'pdf_cleanup'                                     => 'PDF valymas',
    'pdf_cleanup_confirm'                             => 'Ar tikrai norite išvalyti senus PDF failus',
    'pdf_cleanup_success'                             => 'PDF valymas baigtas',
    'deleting_pdf_wait'                               => 'Ištrinami seni PDF failai, palaukite ...',
    'open_invoices'                                   => 'Atidaryti saskaitas fakturas',
    'open_credits'                                    => 'Atviri kreditai',
    'unapplied_payments'                              => 'Netaikyti mokejimai',
    'attach_invoice_pdf'                              => 'Prideti saskaita faktura PDF',
    'upcoming_payment_notice'                         => 'Busimas mokejimo pranešimas',
    'select_mapping'                                  => 'Pasirinkite Mapping',
    'select_named_export'                             => 'Pasirinkite Pavadintas eksportas',
    'save_mapping'                                    => 'Išsaugoti žemelapius',
    'add_mapping'                                     => 'Sukurkite nauja žemelapi',
    'edit_mapping'                                    => 'Atnaujinti žemelapius',
    'save_as_default_mapping'                         => 'Numatytasis susiejimas',
    'save_as_default_export'                          => 'Numatytasis eksportas',
    'export_item_lookups'                             => 'Eksportuoti elementu paieškas',
    'import_file_selection'                           => 'Importuoti failo pasirinkima',
    'next'                                            => 'Kitas',
    'delete_import_mapping_warning'                   => 'Ar tikrai norite ištrinti ši susiejima?',
    'export'                                          => 'Eksportuoti',
    'named_exports'                                   => 'Pavadintas eksportas',
    'save_named_export'                               => 'Išsaugoti pavadinta eksporta',
    'delete_named_export'                             => 'Ištrinti pavadinta eksporta',
    'updated_at'                                      => 'Atnaujinta At',
    'zip'                                             => 'Užtrauktukas',
    'fields_to_export'                                => 'Laukai, kuriuos reikia eksportuoti',
    'import-file-type-error'                          => 'Importuojamo failo tipas turi buti CSV',
    'recurring_invoice_items'                         => 'Pasikartojancios saskaitos fakturos',
    'important_details'                               => 'Svarbios detales',
    'important_information'                           => 'Svarbi informacija',
    'item_lookups_important_information'              => '<p>Jei importuojant CSV esamuose duomenyse randamas atitinkantis elemento paieškos pavadinimas, importavimo paketas nepavyks, parodant elementa, kuris sukele gedima.</p>',
    'invoices_important_information'                  => '<p>Kliento vardas (iš CSV) ieškomas lenteleje Klientai ir išsprendžiamas i kliento_id, jei yra atitinkantis vardas. Jei nerandama vardo atitiktis, jis sukuria kliento iraša ir naudoja naujo kliento irašo ID</p><p>Saskaitos numeris,</p><p>„Invoice_items“ peržiuri saskaitos fakturos lenteleje pateikta saskaitos fakturos numeri (iš CSV) ir nustato ji iki ID. Jokiu kitu pagrindiniu lauku peržiuru/patvirtinimu neatliekama</p>',
    'invoice_items_important_information'             => '<p>Importuojant „invoice_items“ atliekama saskaitu fakturu lenteles saskaitos fakturos numerio (iš CSV) paieška ir nustatomas atitinkamas saskaitos fakturos ID. Kliento ID taip pat gaunamas iš atitinkamos saskaitos fakturos informacijos.</p>',
    'payments_important_information'                  => '<p>Norint importuoti mokejimus, reikia taikyti galiojanti atitinkanti saskaitos fakturos numeri. Jei nerandama atitinkanti saskaita faktura, visas partijos importavimas nepavyks.</p><p>Tinkami klientai-</p><p>Ieškoma pagal mokejimo metodo pavadinima (iš CSV i mokejimo_metodu lentele) ir, jei randama, bus išspresta atitinkama mokejimo_metodu_id. jei nerastas atitinkantis pavadinimas, bus sukurtas naujas mokejimo metodo irašas ir bus naudojamas naujas mokejimo_metodo_id.</p>',
    'run_daily_tasks'                                 => 'Vykdykite kasdienes užduotis',
    'daily_task_ran'                                  => 'Dienos užduotys sekmingai atliktos',
    'csv_row_number'                                  => 'CSV eilutes numeris :row',
    'max_item_lookup_records'                         => 'Maks. Elemento paieškos irašai',
    'invoice_with_commission_delete_error'            => 'Atsiprašome, negalite ištrinti saskaitos fakturos, kurioje yra komisiniu irašu su apmoketa busena. Pirmiausia turite ištrinti sumoketus komisinius iš šios saskaitos fakturos.',
    'if_invoice_is_emailed_while_draft'               => 'Jei saskaita faktura išsiusta el. paštu, kai yra juodrašcio busena',
    'custom_payment_receipt_body_not_exists'          => 'Pasirinktinis mokejimo kvitu šablonas nerastas.',
    'invoice_email_body_type'                         => 'Saskaitos fakturos el. pašto dežutes tipas',
    'send_overdue_reminder'                           => 'Siusti paveluota priminima',
    'reminder_sent_successfully'                      => 'Priminimas sekmingai išsiustas',
    'error_sending_reminder'                          => 'Siunciant priminima ivyko klaida. Veliau bandykite dar karta.',
    'expense_date'                                    => 'Išlaidu data',
    'group_by'                                        => 'Grupuoti pagal',
    'timeline_scope_all_user'                         => 'Laiko juostos apimtis – visi vartotojai',
    'copy_to_clipboard'                               => 'Nukopijuoti i iškarpine',
    'text_copied_clipboard'                           => 'Tekstas nukopijuotas i mainu sriti!',
    'import_example_csv'                              => 'CSV failo pavyzdi rasite cia',
    'import'                                          => 'Importuoti',
    'address2'                                        => '2-as Adresas',
    'use_parent_email'                                => 'Naudokite tevu el',
    'max_import_records'                              => 'Didžiausias importo irašu limitas yra :total_records',
    'demo_file_attachment_disabled'                   => 'Demonstracineje versijoje failu priedai išjungti',
    'drag_drop_file'                                  => 'Vilkite',
    'or'                                              => 'ARBA',
    'browse_file'                                     => 'Naršyti faila',
    'system_setting_and_ui'                           => 'Sistemos nustatymai',
    'localization_and_timezone'                       => 'Lokalizacija',
    'security'                                        => 'Saugumas',
    'cleanup_and_backup'                              => 'Išvalyti',
    'attach_quote_pdf'                                => 'Prideti citata PDF',
    'attach_payment_receipt'                          => 'Pridekite mokejimo kvita',
    'choose-file'                                     => 'Pasirinkti faila',
    'important-note'                                  => 'Svarbi pastaba',
    'collapse'                                        => 'Sutraukti',
    'add_task'                                        => 'Prideti užduoti',
    'recurring_invoice_commissions'                   => 'Pasikartojantys komisiniai iš saskaitos fakturos',
    'invoice_commissions'                             => 'Saskaitu fakturu komisiniai',
    'percentage'                                      => 'Procentas',
    'flat_amount'                                     => 'Butas kiekis',
    'discount-amount'                                 => 'Nuolaida',
    'discount-type'                                   => 'Nuolaidos tipas',
    'saving'                                          => 'Išsaugoma...',
    'preparing'                                       => 'Rengia',
    'allow_line_item_discounts'                       => 'Leisti nuolaidas eilutes elementams',
    'invalid_price_amount'                            => 'Neteisinga kainos suma! Turi buti didesnis nei 0.',
    'light-mode'                                      => 'Šviesos režimas',
    'dark-mode'                                       => 'Tamsusis režimas',
    'system_base_currency'                            => 'Sistemos bazine valiuta',
    'is_recurring_task'                               => 'Yra pasikartojanti užduotis',
    'contact_names'                                   => 'Kontaktu vardai',
    'all_client'                                      => 'Visi Klientai',
    'invoice_grand_total'                             => 'Saskaitos fakturos bendra suma',
    'recurring_invoice_grand_total'                   => 'Pasikartojancios saskaitos fakturos bendra suma',
    'is_required'                                     => 'Ar reikalingas?',
    'add-new-client'                                  => 'Prideti nauja klienta',
    'client_name_required'                            => 'Butinas kliento vardas',
    'custom_item_text_validate'                       => 'Lauke :label iveskite tinkama elementa :label.',
    'assigned_to_others'                              => 'Priskirta kitiems',
    'all_tasks_and_all_users'                         => 'Visos užduotys / Visi vartotojai',
    'statement'                                       => 'pareiškimas',
    'profile_code'                                    => 'Profilio kodas',
    'login-url'                                       => 'Prisijungimo URL',
    'url_copied_clipboard'                            => 'URL nukopijuotas i mainu sriti!',
    'payment_receipt_email_sent'                      => 'Mokejimo kvito el. laiškas sekmingai išsiustas',
    'edit_payment_note_form'                          => 'Redaguoti mokejimo pastaba',
    'payment_invoices_text'                           => 'Aciu! Jusu :amount mokejimas buvo pritaikytas šioms saskaitoms fakturoms.',
    'payment_text'                                    => 'Dekojame, kad sumokejote :amount .',
    'date_filter_by'                                  => 'Data Filtruoti pagal',
    'filter_by_invoice_date'                          => 'Saskaitos data',
    'filter_by_payment_date'                          => 'Mokejimo diena',
    'date-range-required'                             => 'Pasirinkite dienu seka',
    'save-and-complete'                               => 'Išsaugokite ir užpildykite',
    'completion-note'                                 => 'Užbaigimo pastaba',
    'complete-with-note'                              => 'Komplektuojama su pastaba',
    'placeholder_type_note'                           => 'Iveskite savo pastabas...',
    'credit_memo_email_subject'                       => 'Kredito pažymos el. pašto tema',
    'default_credit_memo_email_body'                  => 'Numatytasis kredito pažymos el. pašto tekstas',
    'show_invoices_from'                              => 'Rodyti saskaitas fakturas iš',
    'system_mail_from_address'                        => 'Sistemos paštas iš adreso',
    'user_who_created_invoice'                        => 'Vartotojas, sukures saskaita faktura',
    'completed'                                       => 'Užbaigta',
    'no_auth_to_view_task'                            => 'Šios užduoties jusu saraše nebera.',
    'credit-memo-and-prepayments'                     => 'Kreditai ir išankstiniai mokejimai',
    'all_selected'                                    => 'Visi atrinkti',
    'select_columns'                                  => 'Pasirinkite Stulpeliai',
    'column_settings'                                 => 'Stulpelio nustatymai',
    'minimum_one_column_check_is_required'            => 'Pasirinkite bent viena stulpeli',
    'date_of_entry'                                   => 'Registracijos diena',
    'amount_applied'                                  => 'Taikyta suma',
    'date_applied'                                    => 'Pritaikymo data',
    'copy_to_recurring_invoice'                       => 'Kopijuoti i pasikartojancia saskaita faktura',
    'top_bar_color'                                   => 'Viršutines juostos spalva',
    'light_grey'                                      => 'Šviesiai pilka',
    'bg-primary'                                      => 'Melyna',
    'bg-warning'                                      => 'Geltona',
    'bg-info'                                         => 'Dragonfly Blue',
    'bg-danger'                                       => 'Raudona',
    'bg-success'                                      => 'Turf Green',
    'bg-indigo'                                       => 'Indigo',
    'bg-lightblue'                                    => 'Viktorija melyna',
    'bg-navy'                                         => 'Tamsiai melyna',
    'bg-purple'                                       => 'Violetine',
    'bg-fuchsia'                                      => 'Fuksija',
    'bg-pink'                                         => 'Rožinis',
    'bg-maroon'                                       => 'Maroon',
    'bg-orange'                                       => 'Oranžine',
    'bg-lime'                                         => 'Laimo žalia',
    'bg-teal'                                         => 'žalsvai melyna',
    'bg-olive'                                        => 'Alyvuogiu',
    'fee_name'                                        => 'Mokescio pavadinimas',
    'fee_percentage'                                  => 'Mokescio procentas',
    'fee_explanation'                                 => 'Mokescio paaiškinimas',
    'enable_online_payment_processing_fees'           => 'Igalinti internetiniu mokejimu apdorojimo mokescius',
    'allow_online_payment_processing_fees'            => 'Leisti mokejimu apdorojimo internetu mokescius',
    'allow_online_pay_fees'                           => 'Leisti moketi internetu',
    'convenience_charges'                             => 'Patogumo mokesciai',
    'opp-fee-percentage-required'                     => 'Reikalingas mokejimu internetu apdorojimo mokesciu procentas',
    'opp-fee-percentage-gt-zero'                      => 'Mokejimo internetu apdorojimo mokesciu procentas turi buti didesnis nei nulis',
    'cron_error'                                      => 'nepavyko :datetime',
    'cron_start'                                      => 'Dienos užduociu vykdytojas prasidejo :datetime',
    'notification_clear_all'                          => 'Išvalyti visus pranešimus',
    'show'                                            => 'Rodyti',
    'report'                                          => 'Pranešimas',
    'profit_loss'                                     => 'Pelnas ir nuostoliai',
    'credit_and_pre_payments'                         => 'Kreditai ir išankstiniai mokejimai',
    'expenses_vendors'                                => 'Išlaidos Pardavejai',
    'expenses_categories'                             => 'Išlaidu kategorijos',
    'create'                                          => 'Sukurti',
    'import_map_clients'                              => 'Importuoti žemelapiu klientus',
    'payctr_users'                                    => 'Mokejimu centro vartotojai',
    'ctrl_plus_click'                                 => 'Ctrl ir spustelekite, kad pridetumete užbaigimo pastabas',
    'edit_note'                                       => 'Redaguoti pastaba',
    'save-and-unComplete'                             => 'Išsaugoti ir neužbaigti',
    'sales_chart'                                     => 'Pardavimu diagrama',
    'accumulate_totals'                               => 'Sukaupti sumas',
    'do_not_accumulate_totals'                        => 'Nekaupti sumu',
    'kpi_cards'                                       => 'KPI korteles',
    'no_data_to_display'                              => 'Nera rodomu duomenu',
    'choose_period'                                   => 'Pasirinkite Laikotarpis',
    'date_mailed'                                     => 'Siuntimo data',
    'date_emailed'                                    => 'El. pašto data',
    'action'                                          => 'Veiksmas',
    'mail'                                            => 'Paštas',
    'mark_as_mailed'                                  => 'Pažymeti kaip išsiusta',
    'invoice_mailed'                                  => 'Saskaita faktura pažymeta kaip išsiusta paštu',
    'emailed'                                         => 'El. paštu',
    'paid_invoice_canceled_error'                     => 'Noredami atšaukti šia saskaita faktura, ištrinkite mokejimus iš saskaitos fakturos.',
    'allow_invoice_delete'                            => 'Leisti ištrinti saskaita faktura',
    'allow_child_accounts'                            => 'Leisti antrines paskyras',
    'third_party_bill_payer'                          => 'Treciosios šalies saskaitu moketojas',
    'invoices_paid_by'                                => 'Saskaitas fakturas apmokejo',
    'use_third_party_bill_payer_email'                => 'Naudokite treciosios šalies saskaitu moketojo el. pašta',
    'email_default'                                   => 'Numatytasis el. pašto adresas',
    'client_default'                                  => 'Numatytasis klientas',
    'clear-all'                                       => 'Išvalyti viska',
    'system_log_is_missing_or_empty'                  => 'Truksta sistemos žurnalo arba jis tušcias',
    'change_to_draft'                                 => 'Keisti i juodrašti',
    'invoice_status_change_to_draft'                  => 'Saskaitos fakturos busenos pakeitimas i juodrašti',
    'there_is_some_error'                             => 'Yra keletas klaidu',
    'filter_by_date'                                  => 'Filtruoti pagal data',
    'quote_grand_total'                               => 'Citata Grand Total',
    'email_upcoming_payment_due_notice'               => 'El. paštu pranešimas apie busima mokejima',
    'email_overdue_invoice_reminder'                  => 'El. paštu priminimas apie pradelsta saskaita faktura',
    'page_totals'                                     => 'Puslapiu sumos',
    'categories'                                      => 'Kategorijos',
    'conven_charges'                                  => 'Konv. Mokesciai',
    'invoice_status_change_to_cancel'                 => 'Saskaitos fakturos busenos keitimas i Atšaukti',
    'filter_by_invoice_number'                        => 'Saskaitos numeris',
    'filter_by_client_name'                           => 'Kliento vardas',
    'custom_mail_template'                            => 'Pasirinktinis pašto šablonas',
    'invoice_use_custom_mail_template'                => 'Saskaitos fakturos naudokite tinkinta pašto šablona',
    'client_or_company_name'                          => 'Kliento / Imones pavadinimas',
    'view_invoice'                                    => 'Žiureti saskaita faktura',
    'tt_active'                                       => 'Kai kliento irašas neaktyvus, jie nebus rodomi numatytame klientu saraše ir nebus leidžiamos iprastos operacijos.',
    'tt_invoice_prefix'                               => 'Unikalus saskaitos fakturos priešdelio kodas automatiškai priskiriamas kliento irašui, kai jis sukuriamas. Veliau ji galima pakeisti rankiniu budu. Jis gali buti naudojamas kaip jusu dokumentu numeravimo schemos dalis saskaitoms fakturoms numeruoti, todel kiekvienam klientui suteikiamas unikalus saskaitos fakturos numeris.',
    'tt_automatic_email_payment_receipts'             => 'Gaves mokejima klientui išsiuncia mokejimo kvita el. paštu. Visuotinis nustatymas pasiekiamas sistemos nustatymuose, bet gali buti nepaisomas individualaus kliento pagrindu.',
    'tt_automatic_email_on_recur'                     => 'Išsiuncia klientui el. paštu atsiusta saskaita faktura, kai paleidžiama pasikartojanti saskaita faktura, ir sukuria tiesiogine saskaita. Visuotinis nustatymas pasiekiamas sistemos nustatymuose, bet gali buti nepaisomas individualaus kliento pagrindu.',
    'tt_default_currency'                             => 'Šiai kliento paskyrai priskirta valiuta, kuri bus naudojama saskaitoms fakturoms, pasiulymams ir mokejimo operacijoms. Ši verte yra numatytoji iš sistemos nustatymu bazinei valiutai.',
    'tt_language'                                     => 'Kalba, kuri bus rodoma klientui prisijungus prie klientu centro.',
    'tt_allow_client_center_login'                    => 'Ar klientui turetu buti leista prisijungti prie jusu „FusionInvoice“ klientu centro? Ju el. pašto adresas turi buti naudojamas ju vartotojo vardui ir jus turite priskirti slaptažodi. Klientu centro URL yra',
    'tt_timezone'                                     => 'Laiko juosta klientui. Jei ivesite, kliento vietos laikas bus rodomas Kliento puslapio rodinio viršuje.',
    'tt_allow_online_payment_processing_fees'         => 'Mokejimo internetu apdorojimo mokesciai gali buti nustatomi klientams, atsiskaitantiems kredito kortele, naudojant vieša saskaitos fakturos nuoroda (itraukta i saskaitos fakturos el. laiška). Ši parinktis turi visuotini sistemos nustatyma, bet taip pat gali buti nepaisoma individualaus kliento pagrindu.',
    'tt_allow_child_accounts'                         => 'Nustacius Leisti vaiko paskyras i Taip, šis klientas gali veikti kaip pagrindine paskyra ir pasirinkti ji iš tevu paskyru sarašo.',
    'tt_third_party_bill_payer'                       => 'Treciosios šalies saskaitu moketojas yra organizacija, kuri apmoka saskaitas už savo klientus, pavyzdžiui, išorine apskaitos imone.',
    'tt_parent_account'                               => 'Pagrindine imone, su kuria šis klientas yra susijes arba kurios dukterine imone. Šiame saraše yra klientu irašai, kuriu nustatymas Leisti antrines paskyras nustatytas i Taip. Palikite tušcia, jei klientas neturi pagrindines paskyros.',
    'tt_invoices_paid_by'                             => 'Treciosios šalies imone, kuria šis klientas naudoja saskaitoms fakturoms apmoketi. Šiame saraše yra klientu irašai, kuriu nustatymas Treciosios šalies saskaitu moketojas nustatytas i Taip. Palikite tušcia, jei klientas apmoka savo saskaitas fakturas.',
    'tt_email_default'                                => 'Siusdami el. laiškus šiam klientui, pasirinkite el. pašta, kuris turetu buti naudojamas. Jei šis klientas turi susieta pagrindine paskyra arba saskaita faktura, kuria apmokejo, galima pasirinkti bet kuria iš šiu parinkciu. Numatytasis yra standartinis kliento el.',
    'tt_default_to'                                   => 'Ar siunciant el. laiškus šis kontaktas turetu buti automatiškai itrauktas i \'To:\' gaveju saraša?',
    'tt_default_cc'                                   => 'Ar siunciant el. laiškus šis kontaktas turetu buti automatiškai itrauktas i \CC:\' gaveju saraša?',
    'tt_default_bcc'                                  => 'Ar siunciant el. laiškus šis kontaktas turetu buti automatiškai itrauktas i \BCC:\' gaveju saraša?',
    'tt_client_type'                                  => 'Potencialus klientas yra nekvalifikuotas pardavimo kandidatas. Prospektas yra kvalifikuotas kandidatas, kuris netrukus gali tapti klientu. Klientas yra imone arba asmuo, su kuriuo pardavete (arba netrukus parduosite) prekes ar paslaugas. Filialas yra imone arba asmuo, perparduodantis jusu prekes ar paslaugas. Kita naudojama verslui, kuris neatitinka kitu tipu, pvz., treciuju šaliu saskaitu moketojai arba patronuojancios saskaitos, su kuriomis tiesiogiai nedirbate.',
    'tt_client_tags'                                  => 'Klientui galima priskirti žymas, kad butu lengviau suskirstyti arba filtruoti klientu saraša, kad butu galima peržiureti ar teikti ataskaitas.',
    'tt_important_note'                               => 'Cia ivestas užrašas automatiškai pasirodys skiltyje SVARBU! langas, kai peržiurimas kliento irašas.',
    'tt_gen_header_title_text'                        => 'Viršutiniame kairiajame kampe šalia logotipo rodomas tekstas, dažniausiai jusu imones pavadinimas.',
    'tt_gen_default_company_profile'                  => 'Imones profilis, naudojamas pagal numatytuosius nustatymus kuriant naujas saskaitas fakturas, kainas ir pan. Imones profiliai leidžia skirtingai pristatyti savo versla kiekviename profilyje, leidžiant skirtingus imoniu pavadinimus, logotipus, saskaitu fakturu formatus ir kt.',
    'tt_gen_address_format'                           => 'Leidžia sukurti saskaitose fakturose ir kainose rodoma adreso formata naudojant viena adreso lauka arba atskiru adreso lauku derini, pvz., miesta, valstija, šali ir kt.',
    'tt_gen_custom_fields_columns'                    => 'Pasirinktiniai laukai gali buti rodomi nuo 1 iki 3 lauku vienoje eiluteje.',
    'tt_gen_require_tags_on_client_notes'             => 'Jei nustatyta „Taip“, pridedant kliento pastaba reikes pasirinkti arba ivesti žyma, pvz., „Palaikymas“ arba „Pardavimas“. Tai naudinga skirstant i kategorijas ir ieškant pastabu.',
    'tt_gen_skin'                                     => 'Kaip noretumete, kad butu rodoma jusu FI vartotojo sasaja, šviesus arba tamsus režimas',
    'tt_gen_top_bar_color'                            => 'Viršutines pavadinimo juostos spalva. Jei dirbate su keliais skirtingais „FusionInvoice“ irenginiais, tai gali buti naudingas vizualinis identifikavimas.',
    'tt_gen_results_per_page'                         => 'Visu sarašo rodiniu, pvz., klientu, saskaitu fakturu, kabuciu, išlaidu ir kt., puslapyje rodomu irašu skaicius.',
    'tt_gen_allow_line_item_discounts'                => 'Igalinama arba išjungiama eilutes elementu nuolaidu funkcija saskaitose fakturose ir pasiulymuose.',
    'tt_gen_language'                                 => 'Kalba, kuria naudosite diegdami „FusionInvoice“. Atminkite, kad savo klientams galite priskirti kita kalba, kad jie galetu bendrauti su „FusionInvoice“ klientu centru savo gimtaja kalba.',
    'tt_gen_date_format'                              => 'Jusu pageidaujamas datos formatas',
    'tt_gen_use_24_hour_time_format'                  => 'Leidžia palaikyti 24 arba 12 valandu laiko formatus.',
    'tt_gen_timezone'                                 => 'Jusu imones pagrindine laiko juosta.',
    'tt_gen_base_currency'                            => 'Valiuta, kuria jusu imone naudoja dažniausiai.',
    'tt_gen_exchange_rate_mode'                       => 'Rankinis leidžia ivesti valiutos kurso verte, kai kuriate saskaitas fakturas. Automatinis bandys naudoti viešaja API, kad gautu valiutos kursa. Tai naudojama tik tada, kai ivedate operacija naudodami kita valiuta nei jusu bazine valiuta.',
    'tt_gen_number_of_tax_fields'                     => '„FusionInvoice“ viename eilutes elemente palaiko iki 2 mokesciu lauku. Pasirinkta reikšme rodo arba slepia antraji mokesciu lauka.',
    'tt_gen_quantity_price_decimals'                  => 'Dešimtainiu skaicius, rodomas kiekio ir sumos reikšmems. Pasirinkite nuo 0 iki 4, atsižvelgdami i reikalinga tikslumo lygi.',
    'tt_gen_round_tax_decimals'                       => 'Pasirinkite reikiama dešimtainiu skaiciu mokesciu apvalinimui apskaiciuoti.',
    'tt_gen_use_captcha_in_login'                     => 'Jei nustatyta „Taip“, naudotojai prisijungdami turi atsakyti i CAPTCHA iššukio klausima.',
    'tt_gen_force_https'                              => 'Retai rekomenduojame ijungti šia parinkti. Jei jusu žiniatinklio serveryje neidiegtas tinkamai veikiantis SSL sertifikatas, gali kilti problemu, susijusiu su „FusionInvoice“ diegimu. Ta pati rezultata galite pasiekti nustate serverio peradresavimo taisykle.',
    'dashboard_settings'                              => 'Prietaisu skydelio nustatymai',
    'tt_dashboard_settings'                           => 'Informacijos suvestine naudojama svarbiai verslo metrikai ir ivykiams rodyti, suteikiant vertingos informacijos apie imones veikla. Sistemos prietaisu skydelis yra numatytasis visiems vartotojams, taciau kiekvieno vartotojo konfiguracijoje galite nepaisyti numatytosios sistemos prietaisu skydelio, nustatydami konkrecius kiekvieno vartotojo nustatymus. Toliau pateikti nustatymai leidžia tinkinti prietaisu skydeli.',
    'tt_db_default_time_period'                       => 'Nustato numatytasias juos naudojanciu prietaisu skydelio valdikliu, pvz., KPI korteliu ir pardavimo diagramos, pradžios ir pabaigos datas.',
    'tt_db_recent_client_activity'                    => 'Valdiklis, rodantis kliento saveika, pvz., atliktus mokejimus ir peržiuretas saskaitas fakturas ar kainas, naudojant viešas saskaitas fakturas arba citatos nuorodas.',
    'tt_db_display_order'                             => 'Tai pakeicia prietaisu skydelio valdikliu rodymo tvarka. 1 bus rodomas viršuje, 2 bus rodomas po 1 ir tt.',
    'tt_db_column_width'                              => 'Prietaisu skydelio valdikliai naudoja Bootstrap tinklelio sistema, o didžiausias stulpelio plotis yra 12. Nustacius stulpelio ploti i 12, valdiklis naudos visa galima ploti. Nustacius 6, du valdikliai gales bendrinti ta pacia eilute, 4 leis 3 valdikliams bendrinti ta pacia eilute ir t. t.',
    'tt_db_accumulate_totals'                         => 'Ijungus šia verte i diagrama bus itrauktos kiekvienos dienos ankstesniu dienu sumos. Pavyzdžiui, 1 dienos pardavimas buvo 100 USD, 2 diena 50 USD, 3 diena 125 USD. Diagramoje butu rodoma kylanti linija, kai ši parinktis nustatyta i Taip. Nustacius Ne, 2 diena pardavimo eilute sumažetu, o padidetu iki 3 dienos.',
    'tt_db_kpi_cards'                                 => 'Šiose spalvotose kortelese prietaisu skydelio viršuje rodomi pagrindiniai našumo rodikliai.',
    'tt_db_sales_chart'                               => 'Linijines diagramos diagrama, kurioje rodomos saskaitos fakturos ir mokejimu sumos.',
    'tt_db_task_list'                                 => 'Šis valdiklis leidžia dirbti su užduociu sarašo moduliu tiesiai iš prietaisu skydelio.',
    'tt_db_task_list_include_time'                    => 'Ijungus šia parinkti, dirbant su užduotimis galite nurodyti terminu data ir laika. Kai nustatyta i Ne, naudojama tik datos reikšme.',
    'tt_db_timeline'                                  => 'Laiko juostos valdiklis rodo chronologini ir ieškoma svarbiu sistemos ivykiu saraša, pvz., kliento busenos pasikeitimus, el. paštu išsiustas saskaitas fakturas, atliktus mokejimus, užrašus ir kt.',
    'tt_ss_invoices_default_invoice_template'         => 'Pasirinkite šablona, kuris pagal numatytuosius nustatymus bus naudojamas kuriant naujas saskaitas fakturas. Pasirinktiniai šablonai turi buti dedami i .\\custom\\templates\\invoice_templates\\ ir turi buti pavadinti .blade.php pletiniu.',
    'tt_ss_invoices_default_doc_scheme'               => 'Pasirinkite dokumento numeravimo schema, kuri pagal numatytuosius nustatymus bus naudojama kuriant naujas saskaitas fakturas. Konfiguracijos nustatymuose galima sukurti dokumentu numeriu schemas, kurios leidžia suasmeninti dokumentu numerius (saskaitas fakturas, kainas, kredito pažymas).',
    'tt_ss_invoices_invoice_due_days'                 => 'Numatytasis dienu skaicius po saskaitos fakturos (sukurimo) datos, per kurias sueis saskaitos fakturos terminas ir tikimasi, kad ji bus apmoketa.',
    'tt_ss_invoices_automatic_email_ri'               => 'Kai paleidžiama pasikartojanti saskaita faktura ir generuojama tiesiogine saskaita faktura, ar ši tiesiogine saskaita faktura turi buti automatiškai išsiusta klientui el. paštu?',
    'tt_ss_invoices_qr_code'                          => 'Ar QR kodas turetu buti automatiškai idetas i numatytasias saskaitas fakturas ir kainas. Jei naudojate tinkintus saskaitu fakturu ar pasiulymo šablonus, žr. numatytuosius šablonus, kad pridetumete QR koda prie tinkintu šablonu.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Jei saskaitos fakturos busenos Juodraštis ir ji siunciama el. paštu rankiniu budu arba automatiškai, kas turetu nutikti su saskaitos fakturos data. Svarbi pastaba: kai saskaita faktura siunciama el. paštu, busena automatiškai pakeiciama iš Juodrašcio i Išsiusta.',
    'tt_ss_invoices_recalculate'                      => 'Vykdo kiekviena operacija, atlikta kiekvienai saskaitai fakturai, nuo jos sukurimo datos iki dabartines datos, ir perskaiciuoja sumas, eiluciu straipsniu sumas, mokescius, nuolaidas ir saskaitu fakturu sumas. Tai gali užtrukti ilgai, jei turite dideli duomenu rinkini.',
    'tt_ss_invoices_due_after'                        => 'Saskaitos fakturos mokejimo data bus saskaitos fakturos data ir cia ivestas dienu skaicius.',
    'tt_ss_invoices_default_status_filter'            => 'Busenos filtras, kuris pagal numatytuosius nustatymus turi buti taikomas peržiurint saskaitu fakturu saraša.',
    'tt_ss_invoices_default_terms'                    => 'Salygu teksto verte, kuri rodoma numatytojo saskaitos fakturos šablone, saskaitos fakturos apacioje, srityje Salygos.',
    'tt_ss_invoices_default_footer'                   => 'Poraštes teksto reikšme, kuri rodoma numatytojo saskaitos fakturos šablone, saskaitos fakturos apacioje. Pavyzdžiui:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Kai kasdieninis užduociu vykdytojas (CRON darbas) vykdo ir generuoja tiesiogine saskaita faktura iš pasikartojancios saskaitos fakturos šablono, ar ta naujai sukurta saskaita faktura turi buti automatiškai išsiusta klientui el. paštu? Tai gali buti nepaisoma kiekvienam klientui atskirai.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Ar atlikus mokejima ši mokejimo informacija turetu buti automatiškai išsiusta klientui el. paštu?',
    'tt_ss_invoices_online_payment_method'            => 'Mokejimo budas, kuris priskiriamas klientui atsiskaitant naudodamas vieša saskaitos fakturos nuoroda. Mokejimo budus galima palaikyti sistemos nustatymuose.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Ar dokumente turi buti rodomas QR kodas, nukreipiantis i viešaji saskaitos fakturos arba pasiulymo URL adresa?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Ar vartotojams, net ir administratoriams, turetu buti leidžiama ištrinti saskaitas fakturas? Saugesne ir atsekamesne saskaitu fakturu ištrynimo alternatyva yra pakeisti saskaitos fakturos busena i „Atšaukta“, o tai pakeicia bendra saskaitos fakturos suma i nuli ir pašalina ja iš daugumos sarašu ir ataskaitu.',
    'tt_ss_invoices_show_invoices_from'               => 'Kai saskaitos fakturos siunciamos el. paštu, tai bus rodoma kaip pašto adresas. Svarbi pastaba: Atsakymo i verte visada bus reikšme, priskirta sistemos nustatymuose -',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Ar saskaitos fakturos rodinyje, jei saskaitos fakturos busena yra Juodraštis ir ji išsiusta el. paštu, ar saskaitos fakturos data turetu likti nepakitusi arba pakeisti i dabartine data? Pasikeitus saskaitos fakturos datai, atnaujinama ir mokejimo data.',
    'tt_ss_quotes_default_quote_template'             => 'Pasirinkite šablona, kuris pagal numatytuosius nustatymus bus naudojamas kuriant nauja citata. Pasirinktiniai šablonai turi buti dedami i .\\custom\\templates\\quote_templates\\ ir turi buti pavadinti .blade.php pletiniu.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Pasirinkite dokumento numeriu schema, kuri bus naudojama pagal numatytuosius nustatymus kuriant naujas citatas. Konfiguracijos nustatymuose galima sukurti dokumentu numeriu schemas, kurios leidžia suasmeninti dokumentu numerius (saskaitas fakturas, kainas, kredito pažymas).',
    'tt_ss_quotes_expire_days'                        => 'Numatytasis dienu skaicius, praejus citatai (sukurimo) datai, per kurias baigsis pasiulymo galiojimo laikas. Pasibaigus pasiulymo galiojimo laikui, suprantama, kad kainodara gali keistis del rinkos svyravimu ir pan.',
    'tt_ss_quotes_default_status_filter'              => 'Busenos filtras, kuris pagal numatytuosius nustatymus turi buti taikomas peržiurint saskaitu fakturu saraša.',
    'tt_ss_quotes_auto_convert'                       => 'Jei kaina patvirtinama, ar del to iš pasiulymo bus automatiškai sukurta saskaita faktura.',
    'tt_ss_quotes_when_converted_action'              => 'Kai citata konvertuojama i saskaita faktura, ar mokejimo salygos turi buti naudojamos iš pasiulymo ar numatytojo saskaitos fakturos salygu nustatymo?',
    'tt_ss_quotes_default_terms'                      => 'Salygu teksto reikšme, kuri rodoma numatytame pasiulymo šablone, kainos pasiulymo apacioje, srityje Salygos.',
    'tt_ss_quotes_default_footer'                     => 'Poraštes teksto reikšme, kuri rodoma numatytame citatos šablone citatos apacioje. Pavyzdžiui:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Jei citatos busena yra Juodraštis ir ji siunciama el. paštu rankiniu budu arba automatiškai, kas turetu nutikti su pasiulymo data. Svarbi pastaba: kai citata siunciama el. paštu, busena automatiškai pakeiciama iš Juodrašcio i Išsiusta.',
    'tt_ss_quotes_recalculate'                        => 'Vykdo kiekviena operacija, atlikta kiekvienai citatai, nuo jos sukurimo datos iki dabartines datos, ir perskaiciuoja sumas, eiluciu straipsniu sumas, mokescius, nuolaidas ir sumas. Tai gali užtrukti ilgai, jei turite dideli duomenu rinkini.',
    'tt_ss_taxes_default_rate1'                       => 'Pagrindinis mokescio tarifas, kuris turetu buti automatiškai taikomas naujoms eilutems, itrauktoms i saskaitas fakturas ar kainas. Mokesciu tarifai palaikomi per konfiguracija -',
    'tt_ss_taxes_default_rate2'                       => 'Antrinis mokescio tarifas, kuris turetu buti automatiškai taikomas naujoms eilutems, itrauktoms i saskaitas fakturas ar kainas. Mokesciu tarifai palaikomi per konfiguracija -',
    'tt_ss_email_send_method'                         => 'El. pašto siuntimo metodas, kuri turetu naudoti „FusionInvoice“. Siuntimo metodo pakeitimas taip pat keicia siuntimo metodo pagalbiniu lauku rodyma.',
    'tt_ss_email_allow_self_cert'                     => 'Ijungus šia parinkti, PHP verify_peer reikalavimas išjungiamas. Daugiau informacijos ieškokite internete: PHP el. paštas savarankiškai pasirašytas sertifikatas openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Siunciant el. laiškus tai yra numatytasis atsakymo adresas, kuri matys jusu gavejai.',
    'tt_ss_email_always_cc'                           => 'El. pašto adresas, kuri pagal numatytuosius nustatymus noretumete automatiškai nukopijuoti su kiekvienu išsiustu el.',
    'tt_ss_email_always_bcc'                          => 'El. pašto adresas, kuri pagal numatytuosius nustatymus noretumete automatiškai nukopijuoti i BCC su kiekvienu išsiustu el.',
    'tt_ss_email_send_test_to'                        => 'Pašto adresas, kuris bus naudojamas spustelejus mygtuka Siusti bandomaji el. laiška.',
    'tt_ss_email_mail_from_addr'                      => 'Numatytasis pašto adresas, kuris bus naudojamas, kai el. laiškai siunciami iš „FusionInvoice“. Pastaba: Sistemos nustatymuose -',
    'tt_ss_email_mail_from_name'                      => 'Pašto siuntejo draugiškas pavadinimas, kuris bus rodomas siunciamuose el. laiškuose.',
    'tt_ss_email_email_templates'                     => 'El. pašto šablonai yra prieinami daugeliui dokumentu ir ivykiu, iskaitant: citatas, pasiulymu patvirtinimus, pasiulymu atmetima, saskaitas fakturas, saskaitas fakturas, kuriu terminas veluoja, kredito pažymas, mokejimo kvitus, pranešimus apie busimus mokejimus. Itrauktas numatytasis šablonas, taciau taip pat galite kurti pasirinktinius šablonus, kurie gali buti paprasti (pvz., pateikti numatytieji šablonai) arba visiškai suformatuoti HTML.',
    'tt_ss_pdf_driver'                                => 'Tvarkykles, naudojamos kuriant pdf dokumentus. Norint pasirinkti „wkhtmltopdf“ tvarkykle, šia programa reikia idiegti vietiniame serveryje ir nustatyti atitinkama dvejetaini kelia.',
    'tt_ss_pdf_binary_path'                           => 'Vietinio serverio kelias i dvejetaini wkhtmltopdf faila. Pavyzdžiui, C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => '„FusionInvoice“ palaiko kelis internetiniu mokejimo paslaugu teikejus. Igalinkite teikejus, pas kuriuos sukurete paskyras. Cia igalinti teikejai bus rodomi kaip mokejimo parinktys, kai jusu klientai peržiures savo saskaitas naudodami viešosios saskaitos fakturos nuoroda (itraukta i numatytaji saskaitos fakturos el. laiška).',
    'tt_ss_olp_api_key'                               => 'API rakta jums suteikia mokejimo paslaugu teikejas.',
    'tt_ss_olp_payment_button_text'                   => 'Tekstas, kuris rodomas šio mokejimo teikejo mokejimo metodo mygtuke viešosios saskaitos fakturos viršuje, kaip mato jusu klientai.',
    'tt_ss_olp_mode'                                  => 'Palaikoma kai kuriu mokejimo paslaugu teikeju, leidžianciu naudoti daugiau smelio dežes (testuoti) ir tiesiogiai.',
    'tt_ss_olp_client_id'                             => 'Kliento ID jums suteikia šis mokejimo teikejas.',
    'tt_ss_olp_client_secret'                         => 'Kliento paslapti jums suteikia šis mokejimo teikejas.',
    'tt_ss_olp_publishable_key'                       => 'Paskelbtina rakta jums suteikia šis mokejimo teikejas.',
    'tt_ss_olp_secret_key'                            => 'Slaptaji rakta jums suteikia šis mokejimo teikejas.',
    'tt_ss_olp_opp_fees_about'                        => 'Mokejimo internetu apdorojimo mokesciai gali buti nustatomi klientams, atsiskaitantiems kredito kortele, naudojant vieša saskaitos fakturos nuoroda (itraukta i saskaitos fakturos el. laiška).',
    'tt_ss_olp_enable_opp_fees'                       => 'Mokejimo internetu apdorojimo mokesciai gali buti nustatomi klientams, atsiskaitantiems kredito kortele, naudojant vieša saskaitos fakturos nuoroda (itraukta i saskaitos fakturos el. laiška). Ši parinktis turi visuotini sistemos nustatyma, bet taip pat gali buti nepaisoma individualaus kliento pagrindu.',
    'tt_ss_olp_opp_fee_pct'                           => 'Procentas nuo visos saskaitos fakturos, kuri turi buti apmokestinta kaip internetinio mokejimo apdorojimo (patogumo) mokestis.',
    'tt_ss_olp_opp_fee_name'                          => 'Mokescio pavadinimas, kuris turi buti nurodytas saskaitoje fakturoje. T.y. „Kredito korteles patogumo mokestis“.',
    'tt_ss_olp_opp_fee_explanation'                   => 'Mokescio paaiškinimas, kuris turi buti nurodytas saskaitoje fakturoje. T.y. „Už visas kredito korteliu operacijas taikomas 3 % mokestis“',
    'tt_company_profiles_about'                       => 'Imones profiliai leidžia skirtingai pristatyti savo versla kiekviename profilyje, leidžiant naudoti skirtingus imoniu pavadinimus, logotipus, saskaitu fakturu formatus ir kt. Tai suteikia galimybe tame paciame „FusionInvoice“ diegime tureti kelias virtualias imones. Sistemos nustatymuose turi buti pasirinktas numatytasis imones profilis.',
    'tt_users_about'                                  => 'Galite sukurti administratoriaus (visa prieiga) arba standartinio tipo vartotojus (turi buti suteikti atskiri sistemos leidimai). Kliento irašui nustacius „Leisti prisijungti prie klientu centro“ i Taip, bus automatiškai pridetas kliento vartotojo irašas, taciau Kliento naudotojai gali buti itraukti tik naudojant Kliento nustatymu sasaja.',
    'tt_users_client_about'                           => 'Klientu vartotojai gali prisijungti tik prie Klientu centro, todel jie gali ribotai matyti savo saskaitas fakturas, kainas ir mokejimus. Kliento irašui nustacius „Leisti prisijungti prie klientu centro“ i Taip, bus suteikta prieiga prie klientu centro.',
    'tt_user_types_about'                             => 'Administratoriai turi visiška prieiga prie sistemos. Standartiniams vartotojams gali buti suteikti individualus leidimai, kuriu jiems reikia. Klientu vartotojai turi prieiga tik prie konkrecios informacijos Klientu centre, o galimybe prisijungti yra nustatyta Kliento nustatymuose –',
    'tt_custom_fields_about'                          => 'Pasirinktiniai laukai leidžia prideti savo duomenu laukus prie daugumos moduliu. Jei jums reikejo užfiksuoti pramones šaka klientams, tiesiog klientu puslapyje pridekite pasirinktini lauka pavadinimu „Pramone“, kad jis butu išskleidžiamasis tipas. Pasirinktiniai laukai automatiškai rodomi po iprastais laukais.',
    'tt_recurring_invoices_about'                     => 'Pasikartojancios saskaitos fakturos nera saskaitos fakturos, o greiciau busimu saskaitu fakturu kurimo šablonai. Jie turi pasikartojimo dažni ir kita data, kurie nustato, kada jie sugeneruos tiesiogine saskaita. Kad pasikartojancios saskaitos fakturos tinkamai veiktu, reikalinga kasdiene CRON užduotis arba suplanuota užduotis.',
    'tt_addons_about'                                 => 'Priedai yra „FusionInvoice“ tinkinimai, skirti unikaliems verslo poreikiams, pvz., laiko sekimui, kainodaros formoms ar silizuotiems saskaitu fakturu šablonams. Jie siulomi per „FusionInvoice“ priedu rinka.',
    'client_center_user'                              => 'Klientu centro vartotojas',
    'user_type'                                       => 'Vartotojo tipas',
    'custom_field'                                    => 'Pasirinktinis laukas',
    'placeholder_type_email_template'                 => 'Iveskite arba iklijuokite el. pašto šablona. . .',
    'email_templates'                                 => 'El. pašto šablonai',
    'payment_receipts'                                => 'Mokejimo kvitai',
    'upcoming_payment_notices'                        => 'Busimi mokejimo pranešimai',
    'convenience_fee_for_credit_card_transactions'    => 'Patogumo mokestis už operacijas kredito kortele',
    'credit_card_processing_fee'                      => 'Kreditines korteles apdorojimo mokestis',
    'delete_client_user_warning'                      => '<p>Ištrynus kliento vartotoja bus išjungta galimybe prisijungti prie klientu centro.</p>',
    'use_default_mail_template'                       => 'Numatytasis pašto šablonas',
    'use_custom_mail_template'                        => 'Pasirinktinis pašto šablonas',
    'quote_email_body'                                => 'El. pašto citata',
    'overdue_invoice_email_body'                      => 'Neapmoketos saskaitos fakturos el. pašto tekstas',
    'credit_memo_email_body'                          => 'Kredito pažymos el. pašto tekstas',
    'payment_receipt_body'                            => 'Mokejimo kvito korpusas',
    'invoice_email_body'                              => 'Saskaitos fakturos el. pašto tekstas',
    'quote_custom_email_body_require'                 => 'Iveskite tinkinta el. pašto šablona, skirta pasiulymo el. laiško turiniui',
    'quote_custom_approve_email_body_require'         => 'Iveskite tinkinta el. pašto šablona, kad patvirtintumete pasiulyma',
    'quote_reject_email_body_require'                 => 'Iveskite tinkinta el. pašto šablona, kad pasiulytumete atmesti el. laiško turini',
    'overdue_invoice_email_body_require'              => 'Iveskite tinkinta el. pašto šablona, skirta pradelstos saskaitos fakturos el. laiško tekstui',
    'invoice_email_body_require'                      => 'Iveskite tinkinta el. pašto šablona, skirta saskaitos fakturos el. laiško turiniui',
    'credit_memo_email_body_require'                  => 'Iveskite tinkinta kredito pažymos el. pašto šablona',
    'payment_receipt_email_body_require'              => 'Iveskite tinkinta el. pašto šablona, skirta mokejimo kvito el. laiško turiniui',
    'upcoming_payment_notice_email_body_require'      => 'Iveskite tinkinta el. pašto šablona busimam pranešimo apie mokejima el. laiškui',
    'copy_text'                                       => 'Kopijuoti teksta',
    'tt_preview_template'                             => 'Peržiuros šablonas',
    'tt_view_template_code'                           => 'Žiureti šablono koda',
    'dashboard_date_range'                            => 'Prietaisu skydelio dienu seka',
    'tt_dashboard_date_range'                         => 'Informacijos suvestines dienu seka filtruoja šiu valdikliu rodini: KPI korteles, pardavimo diagrama, naujausia kliento veikla.',
    'product_copy'                                    => 'Produkto kopija',
    'open_selected_client'                            => 'Atidarykite pasirinkta klienta',
    'save_this_client'                                => 'Išsaugoti ši klienta (ne dublikata)',
    'looks_like_duplicate'                            => 'Hmm... Tai atrodo kaip dublikatas',
    'duplicate_instructions'                          => 'Jei saraše matote norima klienta, pasirinkite ir atidarykite. Jei ne, išsaugokite nauja klienta.',
    'select_checkbox'                                 => 'Pasirinkite klienta',
    'select_lead_source_tag'                          => 'Pasirinkite kliento potencialaus kliento šaltini',
    'lead_source'                                     => 'Švino šaltinis',
    'tt_client_lead_source_tags'                      => 'Pasirinkite arba iveskite kliento potencialiu klientu šaltini (kaip klientas buvo igytas)',
    'your_link_is_expired'                            => 'Oi! Jusu nuoroda nebegalioja.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Grižti i prietaisu skydeli</a>.',
    'secure_link_and_expire_link_days'                => 'Apsaugokite ir pasibaigiancias viešuju saskaitu fakturu nuorodas',
    'secure_link_expire_days'                         => 'Dienu skaicius',
    'tt_secure_link_and_expire_link_days'             => 'Ijungdami saugias nuorodas taip pat turite nustatyti dienu skaiciu, po kurio nustos galioti saskaitos fakturos nuoroda. Tai darydamas klientas gali peržiureti savo viešosios saskaitos fakturos nuoroda, kol baigsis jos galiojimo laikas.',
    'expire_time_period'                              => 'Laukas Nuorodos galiojimo laikas Dienu skaicius yra privalomas',
    'enter_days'                                      => 'Iveskite dienas',
    'invalid_field_name'                              => 'Iveskite tinkama lauko pavadinima',
    'lead_source_notes'                               => 'Pagrindinio šaltinio pastabos',
    'important_note'                                  => 'Svarbi pastaba',
    'social_media_url'                                => 'Socialines medijos URL',
    'general_notes'                                   => 'Pagrindiniai užrašai',
    'payment_amount_mismatch'                         => 'Mokejimo sumos neatitikimas',
    'open_invoice_aging'                              => 'Atviras saskaitos fakturos senejimas',
    'tt_db_open_invoice_aging'                        => 'Atviras saskaitos fakturos senejimas',
    'current'                                         => 'Dabartine',
    'oneToThirty'                                     => '1-30 dienu',
    'thirtyOneToSixty'                                => '31-60 dienu',
    'sixtyOneToNinety'                                => '61-90 dienu',
    'ninetyOnePlus'                                   => '91 diena',
    'sent_and_draft'                                  => 'Itraukite išsiustas ir juodraštines saskaitas fakturas',
    'sent_only'                                       => 'Itraukite tik išsiustas saskaitas fakturas',
    'tt_open_ar_aging_settings'                       => 'Neapmoketu saskaitu fakturu senejimo sumu nustatymai',
    'tt_client_field_settings'                        => 'Pasirinkite laukus, kuriuos norite rodyti savo kliento rodinyje',
    'position_change'                                 => 'Pozicija pakeista',
    'dynamic_width'                                   => 'Dinaminis plotis',
    'full_width'                                      => 'Visas plotis',
    'save_configuration_default'                      => 'Išsaugoti konfiguracija kaip numatytaja sistemos',
    'assign_configuration_other'                      => 'Priskirkite konfiguracija kitiems vartotojams',
    'tt_user_tags'                                    => 'Vartotojo žymos',
    'select_users'                                    => 'Pasirinkite Vartotojai',
    'configuration_assigned'                          => 'Konfiguracija priskirta sekmingai',
    'default_configuration_set'                       => 'Numatytoji konfiguracija sekmingai nustatyta',
    'current_user_id'                                 => 'Dabartinis vartotojo ID',
    'tt_users_settings'                               => 'Vartotoju nustatymai',
    'invoice_link_expire'                             => 'Jusu saskaitos fakturos viešoji nuoroda baigs galioti',
    'quote_link_expire'                               => 'Jusu citatos vieša nuoroda baigs galioti',
    'dashboard_width'                                 => 'Informacijos suvestines :widthName stulpelio plocio nustatymas pakeistas',
    'unmark_mailed'                                   => 'Panaikinkite išsiuntimo žymejima',
    'invoice_unmark_mailed'                           => 'Saskaitos fakturos atžymejimas kaip išsiustas',
    'print_mark_mailed'                               => 'Spausdinti',
    'public_link'                                     => 'Vieša nuoroda',
    'tt_sales_chart_settings'                         => 'Pardavimo diagramos saskaitos fakturos/suma nustatymas',
    'verify_key'                                      => 'Produkto rakto patvirtinimas',
    'enter_key'                                       => 'Iveskite savo rakta',
    'verify'                                          => 'Patvirtinkite!',
    'key_required'                                    => 'Butinas produkto raktas',
    'key_length_invalid'                              => 'Iveskite 32 simboliu produkto koda, pateikta pirkimo metu.',
    'invalid_key'                                     => 'Atsiprašome, jusu raktas neteisingas. Diegimas negali testis.',
    'key_verified'                                    => 'Sveikiname, jusu raktas buvo patvirtintas.',
    'clear_cache'                                     => 'Išvalyti talpykla',
    'clear_cache_confirm'                             => 'Ar tikrai norite išvalyti programos talpykla?',
    'cache_clear_success'                             => 'Talpykla sekmingai išvalyta.',
    'cache_clear_error'                               => 'Patikrinkite savo serverio konfiguracija PHP exec() komandai.',
    'add_new_client'                                  => 'Prideti nauja klienta',
    'add'                                             => 'Papildyti',
    'invalid_quantity_amount'                         => 'Neteisinga kiekio suma! Turi buti didesnis nei 0.',
    'api_version'                                     => 'API versija',
    '2021_prior'                                      => '2021 ir anksciau',
    '2022_later'                                      => '2022 ir veliau',
    'vendors'                                         => 'Pardavejai',
    'file_not_found'                                  => ':file_name nerastas',
    'leave_empty_no_parent_account'                   => 'palikite tušcia, jei klientas neturi pagrindines paskyros',
    'leave_empty_client_pays_invoices'                => 'palikite tušcia, jei klientas apmoka savo saskaitas fakturas',
    'modal_not_found'                                 => 'Modalas nerastas',
    'payment_delete_success'                          => 'Mokejimas sekmingai ištrintas',
    'payment_delete_error'                            => 'Ištrinant mokejima kilo problema. Veliau bandykite dar karta.',
    'status_change_error'                             => 'Kažkas ne taip! Statusas nebuvo pakeistas.',
    'total_payments'                                  => 'Iš viso mokejimu',
    'licence_verification_error'                      => 'Nepavyko patvirtinti jusu licencijos rakto.',
    'line_item_discount_limit'                        => 'Eiluciu elementams nuolaida negali buti didesne nei 99,99%.',
    'date_range_report'                               => 'Dienu seka (kita data, kuria reikia pradeti)',
    'no_client_found'                                 => 'Hmm... mums nepavyko rasti to kliento.',
    'tt_line_item_discount'                           => 'Eilutinio elemento nuolaida gali buti apskaiciuojama procentais nuo kainos arba fiksuota suma už atskiros prekes kaina.',
    'functionality_not_available_on_demo'             => 'Atsiprašome, ši funkcija neleidžiama demonstracineje versijoje.',
    'vat_tax_id'                                      => 'PVM moketojo kodas',
    'tt_vat_tax_id'                                   => 'Pridetines vertes mokescio (PVM) numeris',
    'enable_vat_tax_id'                               => 'Igalinti PVM moketojo koda',
    'no-attachment'                                   => 'Priedo nera',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Išvalyti',
    'allow_edit_status_invoice'                       => 'Redaguoti :status saskaita faktura',
    'tt_ss_allow_edit_invoices_status'                => 'Saugumo sumetimais galima redaguoti tik Juodrašcio busenos saskaitas fakturas. Galite tai nepaisyti leisdami redaguoti išsiustas ir (arba) apmoketas saskaitas fakturas.',
    'allow_edit_invoices_status'                      => 'Leisti redaguoti saskaitas fakturas',
    'draft_and_sent'                                  => 'Juodraštis ir išsiustas',
    'draft_or_sent_and_paid'                          => 'Juodraštis, išsiustas ir apmoketas',
    'invoice_editable'                                => 'Redaguojama saskaita faktura',
    'can_not_edit_paid_invoice'                       => 'Negalite redaguoti apmoketos saskaitos fakturos',
    'item_category'                                   => 'Prekes kategorija',
    'itemLookups'                                     => 'Elementu paieškos',
    'quoteItems'                                      => 'Citatos elementai',
    'invoiceItems'                                    => 'Saskaitos fakturos elementai',
    'imports_disabled_in_demo.'                       => 'Demonstracineje versijoje importavimas išjungtas.',
    'no_file_selected'                                => 'Nepasirinktas failas',
    'no_import_records'                               => 'Importuotinu irašu nerasta',
    'vendor_name'                                     => 'Pardavejo pavadinimas',
    'license_key'                                     => 'Licencijos raktas',
    'change_license_key'                              => 'Pakeiskite licencijos rakta',
    'verify_and_save'                                 => 'Patvirtinti',
    'same_key_error'                                  => 'Pakeitimu neaptikta. Pabandykite naudoti kita rakta',
    'trying_invalid_key'                              => 'Atsiprašome, nepavyko patvirtinti šio rakto. Licencijos raktas nebuvo pakeistas.',
    'key_updated'                                     => 'Sveikiname! Licencijos raktas sekmingai atnaujintas.',
    'invalid_date_format'                             => 'Neteisingas datos formatas. Butinas formatas: YYYY-MM-DD',
    'invalid_datetime_format'                         => 'Neteisingas datos ir laiko formatas. Butinas formatas: YYYY-MM-DD HH:MM :SS',
    'profile_setting'                                 => 'Profilio nustatymai',
    'include_draft_invoices_unpaid_and_overdue'       => 'Itraukite saskaitu projektus i neapmoketu ir pradelstu moketinu terminu sarašus',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Jei nustatyta i Taip, saskaitos fakturos, kuriu busena yra Juodraštis, bus itrauktos i pradelstu ir neapmoketu saskaitu fakturu sarašus ir skaiciavimus.',
    'tt_utilities_import'                             => 'Importuokite duomenis iš CSV failu i savo „FusionInvoice“ duomenu baze.',
    'tt_utilities_export'                             => 'Eksportuokite duomenis iš „FusionInvoice“ duomenu bazes i ivairius formatus: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Peržiurekite žurnalo faila, kuriame yra visi „FusionInvoice“ el. pašto ivykiai.',
    'tt_utilities_system_log'                         => 'Peržiurekite sistemos žurnalo faila, kuriame yra klaidu ir ispejimu sistemos ivykiai.',
    'tt_utilities_tag_cleanup'                        => 'Pašalina žymas, kurios buvo apibrežtos, bet nenaudotos. Taip pat pašalinamos visos pasikartojancios žymos.',
    'tt_utilities_pdf_cleanup'                        => 'Pašalina laikinus PDF failus.',
    'tt_utilities_recalc_invoices'                    => 'Nuskaito kiekviena saskaita faktura ir užtikrina, kad sumos sutaptu su visu eiluciu straipsniu suma, atsižvelgiant i nuolaidas ir mokescius. *Tai gali užtrukti ilgai.',
    'tt_utilities_recalc_quotes'                      => 'Nuskaito kiekviena pasiulyma ir užtikrina, kad sumos sutaptu su visu eiluciu straipsniu suma, atsižvelgiant i nuolaidas ir mokescius. *Tai gali užtrukti ilgai.',
    'tt_utilities_clear_cache'                        => 'Pašalina laikinus talpyklos failus.',
    'tt_utilities_download_database'                  => 'Atsisiuskite eksportuota duomenu bazes faila iš tiesioginiu „FusionInvoice“ duomenu. Kuo didesne jusu duomenu baze, tuo ilgiau tai užtruks.',
    'tt_utilities_run_daily_tasks'                    => 'CRON darbas arba suplanuota užduotis paprastai atlieka jusu kasdienes užduotis. Tai leidžia tai padaryti rankiniu budu. Jis generuoja tiesiogines saskaitas fakturas iš pasikartojanciu saskaitu fakturu šablonu, siuncia mokejimo priminimus ir kt.',
    'include_line_item_detail'                        => 'Itraukti išsamia eilutes elemento informacija',
    'invoice_tags'                                    => 'Saskaitu fakturu žymos',
    'related_accounts'                                => 'Susijusios paskyros',
    'not_found_related_clients'                       => 'Susijusiu klientu paskyru nepriskirta',
    'invoices_paid_for_list'                          => 'Šioje kliento paskyroje apmokamos saskaitos fakturos',
    'child_accounts_exist'                            => 'Nustatymas Leisti antrines paskyras gražintas i Taip. Neimanoma pakeisti i Ne, kai yra antriniu paskyru.',
    'third_bp_accounts_exist'                         => 'Treciosios šalies saskaitu moketojo nustatymas gražintas i Taip. Neimanoma pakeisti i Ne, kai yra susijusiu paskyru.',
    'tag_name'                                        => 'Žymes pavadinimas',
    'tag_new_name'                                    => 'Naujas žymos pavadinimas',
    'tag_category'                                    => 'Žymes kategorija',
    'rename_tags'                                     => 'Pervardyti žymas',
    'apply'                                           => 'Taikyti',
    'select_tag_category'                             => 'Pasirinkite žymos kategorija',
    'tt_utilities_rename_tags'                        => 'Pervardyti žymas, priskirtas klientams, pastaboms, pardavimo veiklai ir kt.',
    'system_default_dashboard'                        => 'Sistemos numatytasis prietaisu skydelis',
    'user_specific_dashboards'                        => 'Naudotojui budingi prietaisu skydeliai',
    'tt_default_client_type'                          => 'Numatytasis kliento tipas',
    'default_client_type'                             => 'Numatytasis kliento tipas',
    'invalid_user'                                    => 'Pasirinkite tinkama naudotoja.',
    'create_live_invoice'                             => 'Sukurkite tiesiogine saskaita faktura',
    'create_live_invoice_successfully'                => 'Tiesiogine saskaita faktura',
    'create_live_invoice_unsuccessfully'              => 'Tiesiogine saskaita faktura nebuvo sukurta',
    'live_invoice_not_generate'                       => 'Negalima generuoti tiesiogines saskaitos fakturos iš pasikartojancios saskaitos fakturos, kurios sustabdymo data yra šiandien ar ankstesne, arba kita data yra daugiau nei 30 dienu ateityje.',
    'data_seeder'                                     => 'Duomenu sejamoji',
    'select_module'                                   => 'Pasirinkite Modulis',
    'number_of_seed'                                  => 'Seklu skaicius',
    'seed_it'                                         => 'Sek!',
    'seeds_success'                                   => 'Seklos pridetos sekmingai',
    'tt_ri_generate_the_next_live_invoice'            => 'Sugeneruokite kita tiesiogine šios pasikartojancios saskaitos faktura dabar.',
    'system_log_clear_message'                        => 'Ar tikrai norite išvalyti sistemos žurnala? Šio veiksmo anuliuoti negalima ir visi ankstesni žurnalai bus visam laikui ištrinti.',
    'system_log_clear_successfully'                   => 'Sistemos žurnalas sekmingai išvalytas',
    'payment_problem'                                 => 'Mokejimo metu ivyko problema. Pabandykite dar karta veliau.',
    'log_detail'                                      => 'Spustelekite cia noredami peržiureti išsamia žurnala.',
    'log_limit_message'                               => 'Žurnalo failas',
    'log_download_file'                               => 'Atsisiusti faila',
    'log_delete_all'                                  => 'Ištrinti visus failus',
    'log_level'                                       => 'Lygis',
    'log_context'                                     => 'Kontekstas',
    'log_date'                                        => 'Data',
    'log_line_number'                                 => 'Eiles numeris',
    'log_content'                                     => 'Turinys',
    'addon_install_error'                             => 'Iškilo problema diegiant prieda. Veliau bandykite dar karta.',
    'addon_installed_success'                         => 'Priedas sekmingai idiegtas.',
    'allow_edit_status_credit_memo'                   => 'Redaguoti taikoma kredito pažyma',
    'database_seeder'                                 => 'Sejamoji',
    'tt_utilities_database_seeder'                    => 'Idekite i savo duomenu baze bandymo duomenis naudodami pradiniu klasiu klases',
    'vat_information'                                 => 'PVM informacija',
    'tt_vat_information'                              => 'IBAN banko saskaitos numeris, BIC, el.',
    'explore_addons'                                  => 'Naršykite priedus',
    'available_addons'                                => 'Galimi „FusionInvoice“ priedai',
    'addon_success'                                   => 'Priedas sekmingai pridetas.',
    'payment_cannot_enabled_in_demo'                  => 'Demonstracineje versijoje negalima ijungti mokejimo šliuzu',
    'confirm_approve_leave_page'                      => 'Šiame puslapyje yra neišsaugotu pakeitimu! Ar tikrai norite išeiti neišsaugojes?',
    'leave'                                           => 'Palikti',
    'demo_date_refresh'                               => 'Demonstraciniai duomenys bus atnaujinti',
    'minutes'                                         => 'minuciu',
    'minute'                                          => 'minute',
    'seconds'                                         => 'sekundžiu',
    'mautic-authentication-fail'                      => 'Jus neturite prieigos prie šio šaltinio, naudokite galiojanti slaptaji rakta.',
    'something_went_wrong'                            => 'Kažkas ne taip!',
    'month_to_date'                                   => 'Ši menesi iki šiol',
    'quarter_to_date'                                 => 'Šis ketvirtis iki šiol',
    'year_to_date'                                    => 'Šiais metais',
    'last_active'                                     => 'Paskutinis aktyvus',
    'database_seeder_stop'                            => ':name BUSINESS SEEDER STOP',
    'database_seeder_start'                           => ':name VERSLO SEEDER PRADŽIA',
    'seeder_records_created'                          => ':total Sekmingai sukurti irašai, skirti :modal',
    'seeder_credit_apply_invoice'                     => 'Kredito pažyma taikoma saskaitai fakturai',
    'seeder_quote_approve_reject'                     => 'Citata Patvirtinti ir atmesti',
    'seeder_executed'                                 => 'Sejamoji sekmingai ivykdyta!',
    'seeder_not_executed'                             => 'Sejamoji nebuvo ivykdyta!',
    'db_to_file_system_attachments_migration'         => 'Priedu perkelimas – duomenu baze i failu sistema',
    'attachment_content_count'                        => 'Jus ketinate perkelti iš viso',
    'attachment_repeat_content_count'                 => 'Jus ketinate perkelti iš viso',
    'attachment_key_invalid'                          => 'Priedo raktas netinkamas',
    'stop'                                            => 'Sustabdyti!',
    'attachment_migration_warning'                    => 'Šis veiksmas perkels priedus iš duomenu bazes i failu sistema. Prieš tesdami atlikite visa duomenu bazes atsargine kopija ir isitikinkite, kad turite pakankamai vietos diske šiai operacijai atlikti.',
    'attachment_agreement_accept'                     => 'Sukuriau atsargine duomenu bazes kopija.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => '„Microsoft 365“ slaptažodis',
    'office365_username'                              => 'Microsoft 365 vartotojo vardas',
    'custom_date_formula_note1'                       => '<b><u>Numatytosios reikšmes rezervuotos vietos :</span></u></b> ~<br> <b>Šiandien, rytoj ir vakar</b> galite naudoti bet kuria reikšme kaip numatytaja.<br>',
    'custom_date_formula_note2'                       => '<b>Šiandien + N d. naudokite </b> \'numatytasis\': \'+7\' Tai prideda 7 dienas prie šiandienos datos. <br><b>Šiandien - N d., naudokite </b> \'numatytasis\': \'-7\' Iš šiandienos datos bus atimtos 7 dienos <br>',
    'mail_config_error'                               => 'Neimanoma išsiusti bandomojo el. laiško, jei nenurodytas el. pašto siuntimo budas.',
    'db_prefix_alert'                                 => 'Pastebejome, kad naudojate duomenu bazes priešdeli :prefix . „FusionInvoice“ busimose versijose nepalaikys duomenu bazes priešdeliu. Redaguokite savo duomenu baze ir pervardykite visas lenteles, pašalindami priešdeli, tada redaguokite duomenu bazes.php faila ir nustatykite priešdelio reikšme tušcia',
    'db_prefix_alert_title'                           => 'Netrukus baigsis DB prefiksu palaikymas',
    'add_title_bar_shortcut'                          => 'Prideti pavadinimo juostos nuoroda',
    'title_bar_shortcuts'                             => 'Pavadinimo juostos spartieji klavišai',
    'select_icon'                                     => 'Pasirinkite piktograma',
    'all_payment_method'                              => 'Visi mokejimo budai',
    'about'                                           => 'Apie',
    'own_license'                                     => 'Nuosavas licencija',
    'tt_own_license'                                  => 'Nuosavas licencija',
    'git_branch'                                      => 'Git dabartinis filialas',
    'quote_email'                                     => 'Citata el',
    'custom1'                                         => 'Tinkintas 1',
    'custom2'                                         => 'Tinkintas 2',
    'custom3'                                         => 'Pasirinktinis 3',
    'default_document_template'                       => 'Numatytasis dokumento šablonas',
    'default_email_template'                          => 'Numatytasis el. pašto šablonas',
    'sms'                                             => 'Trumpoji žinute',
    'pricing_formula'                                 => 'Kainodaros formule',
    'is_mobile'                                       => 'Ar mobilusis?',
    'default_sms_template'                            => 'Numatytasis SMS šablonas',
    'sms_log'                                         => 'SMS žurnalas',
    'two_factor_auth'                                 => 'Dvieju faktoriu autentifikavimas',
    'enabled_mail_driver'                             => 'Igalinkite el. pašto paslauga',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Neteisingas patvirtinimo kodas',
    'otp-subject'                                     => 'Prisijunkite OTP',
    'resend_otp_success'                              => 'Patvirtinimo kodas išsiustas iš naujo',
    'resend_otp_btn'                                  => 'Atsiuskite koda dar karta',
    'expired_otp'                                     => 'Patvirtinimo kodas baigesi',
    'token_expired'                                   => 'Jusu CSRF prieigos raktas nebegalioja',
    'verification_code'                               => 'Patvirtinimo kodas',
    'migration'                                       => 'Migracija',
    'invoice_status_change_draft_to_sent'             => 'Saskaitos fakturos busena pakeista iš juodrašcio i išsiusta',
    'default_sales_quantity'                          => 'Numatytasis pardavimo kiekis',
    'lead_time'                                       => 'Vid. Pristatymo laikas (dienomis)',
    'primary_vendor_id'                               => 'Pageidaujamas pardavejas',
    'all_items'                                       => 'Visi daiktai',
    'non_inventory_items'                             => 'Neinventorines prekes',
    'back_ordered'                                    => 'Atgal Užsakyta',
    'low_inventory'                                   => 'Mažos atsargos',
    'high_inventory'                                  => 'Didelis inventorius',
    'merge_client_records'                            => 'Sujungti kliento irašus',
    'primary_merge_to_client'                         => 'Sujungti i (išlikti)',
    'surrogate_merge_from_client'                     => 'Sujungti iš (išmesti)',
    'merge'                                           => 'Sujungti',
    'merge_action'                                    => 'Sujungimo veiksmas',
    'ignore'                                          => 'Ignoruoti',
    'overwrite'                                       => 'Perrašyti',
    'add_to'                                          => 'Prideti prie',
    'select_merge_client'                             => 'Pasirinkite Sujungti',
    'client_to_and_from_not_same'                     => 'Klientas ir klientas turi skirtis.',
    'client_id_required'                              => 'Kliento pasirinkimo laukas turi buti privalomas ir unikalus.',
    'is_merge'                                        => 'Sujungti',
    'record_successfully_merged'                      => 'Irašas sekmingai sujungtas',
    'service_ends'                                    => 'Paslauga baigiasi',
    'service_starts'                                  => 'Paslauga prasideda',
    'explanation'                                     => 'Paaiškinimas',
    'subscription_details'                            => 'Išsami prenumeratos informacija',
    'generate_next_invoice'                           => 'Sukurti kita saskaita faktura',
    'subscription'                                    => 'Prenumerata',
    'of_the'                                          => 'Iš',
    'on'                                              => 'Ijungta',
    'invoice_month'                                   => 'Saskaitos fakturos menuo',
    'invoice_year'                                    => 'Saskaitos fakturos metai',
    'next_month'                                      => 'Kita menesi',
    'next_year'                                       => 'Kitais metais',
    'day'                                             => 'Diena',
    'last_date'                                       => 'Paskutine data',
    'merge_record_warning'                            => 'Sustabdyti! Klientu paskyru sujungimo anuliuoti negalima. Be lauku, kuriuos pasirinkote perrašyti arba prideti, visa sujungimo iš kliento operaciju istorija bus perkelta i sujungimo i klienta. Ar tikrai norite sujungti šias klientu paskyras?',
    'merge_child_account_warning'                     => 'Sujungimo (nuo) klientas turi pirmine paskyra su susijusiomis antrinemis paskyromis, kurios bus iš naujo priskirtos sujungimo (kam) klientui. Isitikinkite, kad sujungimo (kam) klientas yra leidžiamas kaip pagrindine paskyra.',
    'merge_parent_account_warning'                    => 'Sujungus bus pašalintas jusu susiejimas su pagrindine paskyra.',
    'merge_invoices_paid_by_warning'                  => 'Sujungus bus pašalintas jusu susiejimas su pagrindine saskaita faktura, kuria apmokejo.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'Ryšiu skaicius kliento modelyje pasikeite.',
    'payment_terms'                                   => 'Mokejimo salygos',
    'net_amount_due_in'                               => 'Grynoji moketina suma',
    'net_amount_due_by'                               => 'Grynoji suma iki',
    'if_paid_within'                                  => 'jei mokama per',
    'if_paid_by'                                      => 'jei sumokejo',
    'th_of_next_month'                                => 'kito menesio d',
    'of_next_month'                                   => 'kito menesio',
    'down_payment'                                    => 'Pradinis inašas',
    'balance_amount_due_of'                           => 'moketina likucio suma',
    'payment_split_over'                              => 'Mokejimas padalintas',
    'installments'                                    => 'imokomis',
    'days_from_invoice_date'                          => 'dienu nuo saskaitos fakturos datos',
    'payment'                                         => 'Mokejimas',
    'one'                                             => 'Vienas',
    'two'                                             => 'Du',
    'three'                                           => 'Trys',
    'four'                                            => 'Keturi',
    'five'                                            => 'Penkios',
    'six'                                             => 'Šeši',
    'discount_percent'                                => 'Nuolaidos procentas',
    'discount_days_simple'                            => 'Nuolaidu dienos Paprastos',
    'discount_days_nth'                               => 'Nuolaidu dienos N',
    'net_due_days'                                    => 'Grynosios mokejimo dienos',
    'balance_due_days'                                => 'Mokejimo dienos',
    'number_of_installments'                          => 'Imoku skaicius',
    'payment_term'                                    => 'Mokejimo terminas',
    'select_payment_term'                             => 'Pasirinkite Mokejimo terminas',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'Laukas Imokos procentas :index yra privalomas ir didesnis už nuli.',
        'installment_due_days_error'                  => 'Butina nurodyti imokos mokejimo dienas :index',
        'discount_percent_gt_error'                   => 'Pateiktas nuolaidos procentas yra privalomas ir didesnis už nuli.',
        'discount_percent_lt_error'                   => 'Butina nurodyti nuolaidos procenta ir mažiau nei 100%.',
        'down_payment_percent_lt_error'               => 'Reikalingas imokos procentas ir mažesnis nei 100%.',
        'discount_percent_numeric_error'              => 'Lauke Nuolaidos procentas turi buti skaitine reikšme ir mažesne nei 100%.',
        'down_payment_gt_error'                       => 'Pateiktas pradinis inašas yra privalomas ir didesnis už nuli.',
        'discount_days_gt_net_days_error'             => 'Grynoji moketina suma turetu buti didesne už nuolaidu dienas.',
        'discount_days_nth_gt_net_days_error'         => 'Grynoji moketinu dienu suma turetu buti didesne nei N-osios nuolaidos dienos.',
        'installment_due_days_gt_error'               => 'Imokos mokejimo dienos :index turetu buti didesnes nei :preIndex imokos mokejimo dienos.',
        'installment_percent_total_error'             => 'Bendra imokos procentu suma nera tiksli. jis turetu buti lygus 100%.',
        'installment_percent_numeric_error'           => 'Bendra imokos procentu suma nera tiksli. Tai turetu buti skaitine reikšme.',
        'term_discount'                               => 'Termino nuolaida',
        'installment_due_days_gt_zero_error'          => 'Imokos mokejimo dienos :index turetu buti didesnes arba lygios nuliui.',
        'net_due_days_error'                          => 'Grynoji moketina suma turetu buti didesne už nuli ir privaloma pateikti.',
        'discount_days_simple_error'                  => 'Paprastos nuolaidos dienos turetu buti didesnes už nuli ir butinos.',
        'discount_days_nth_error'                     => 'N-osios nuolaidos dienos turetu buti didesnes už nuli ir butinos.',
        'balance_due_days_error'                      => 'Likutis, kuri reikia sumoketi, turetu buti didesnis už nuli ir privalomas.',
        'status_error'                                => 'Atsiprašome, busena nepasikeite del saskaitoje fakturoje vartojamo termino.',
        'down_payment_type_invoice_description_error' => 'Jusu ivestas saskaitos fakturos aprašo prieigos raktas nesutampa su pradinio mokejimo tipu.',
        'down_payment_type_quote_description_error'   => 'Jusu ivestas pasiulymo aprašymo prieigos raktas nesutampa su pradinio mokejimo tipu.',
    ],
    'quotes_delete_error'                             => 'Citatos ištrynimo klaida',
    'for'                                             => 'Del',
    'production'                                      => 'Gamyba',
    'access_token'                                    => 'Prieigos raktas',
    'application_id'                                  => 'Programos ID',
    'location_id'                                     => 'Vietos ID',
    'fi_config_check'                                 => 'Butinos salygos Patikrinti',
    'requirement'                                     => 'Reikalavimas',
    'required'                                        => 'Privaloma',
    'actual'                                          => 'Faktinis',
    'result'                                          => 'Rezultatas',
    'db_prefix_setup_alert'                           => 'Jusu „FusionInvoice“ duomenu bazeje naudojami DB priešdeliai. DB prefiksu palaikymas baigesi 2023-3.0 versija. Norint testi naujovinima i šia ir busimas versijas, butina pašalinti DB prefiksus. Tai galite padaryti pervardydami visas savo duomenu bazes lenteles ir pašalindami priešdeli, taip pat nustatydami reikšme \'prefix\' => \'\' savo duomenu bazeje.php faile.',
    'open_tasks'                                      => 'Atidarykite Užduotys',
    'closed_tasks'                                    => 'Uždarytos užduotys',
    'select_status'                                   => 'Pasirinkite Busena',
    'net_amount_due_invoice'                          => 'Grynoji moketina suma per :days dienas.',
    'days_add_in_current_date'                        => 'Dabartine data nuo <span class="text-blue">:date</span> , ir terminas turi buti laikomi <span class="text-blue">:date</span>  <span class="text-danger">plius</span> <span class="text-blue">dienu skaicius</span>.',
    'terms'                                           => 'Salygos',
    'quote_rejecting_error'                           => 'Saskaita faktura # :invoice_number buvo sukurta :invoice_date patvirtinus šia pasiulyma. Prieš atmesdami šia pasiulyma, turite ištrinti arba atšaukti šia saskaita faktura.',
    'resend_record_warning'                           => 'Iš naujo išsiusti ši el. laiška dabar?',
    'resend_email'                                    => 'Iš naujo siusti el. laiška',
    'requirement_check_fail'                          => 'Prieš tesdami diegima, turite ištaisyti aukšciau nurodytus gedimus.',
    'failed'                                          => 'Nepavyko',
    'subscriptions'                                   => 'Prenumeratos',
    'tt_explanation'                                  => 'Iveskite paslaugos apraša su pasirenkamais datos rezervavimo ženklais. Noredami dinamiškai iterpti paslaugos pradžios ir pabaigos datas, galite naudoti šiuos prieigos raktus:{{service_starts_on}} ir {{service_ends_on}}. Kai bus rodomas turinys, jos bus pakeistos tikrosiomis pradžios ir pabaigos datomis.',
    'tt_ss_invoices_default_payment_terms'            => 'Saskaitos fakturos numatytosios mokejimo salygos',
    'invoices_default_terms'                          => 'Saskaitu fakturu numatytosios salygos',
    'net_amount_due_in_n_days'                        => 'Grynoji moketina suma per N dienu',
    'last_day'                                        => 'Paskutine diena',
    'down_payment_payment_term1'                      => 'Pradinis inašas',
    'down_payment_payment_term2'                      => 'yra butinas.  Sumoketas likutis',
    '1_type'                                          => 'Šiandien sukurta saskaita faktura bus apmoketa po <span class="text-primary">#N</span> dienu',
    '2_type'                                          => 'Šiandien sukurta saskaita faktura suteiks nuolaida, jei apmokesite iki <span class="text-primary">#date</span> , jei ne, visa suma turi buti sumoketa per <span class="text-primary">#N</span>  dienu',
    '3_type'                                          => 'Šiandien sukurta saskaita faktura suteiks nuolaida, jei apmokesite iki <span class="text-primary">#date</span>  . Grynoji suma turi buti sumoketa per <span class="text-primary">#N</span>  dienu',
    '4_type'                                          => 'Šiandien sukurtai saskaitai fakturai reikes sumoketi <span class="text-primary">#amount</span>  pradini inaša. Likes likutis bus sumoketas per <span class="text-primary">#N</span>  dienu',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>Šiandien sukurta saskaita faktura, padalinta i <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Mokejimas <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Terminas <span class="text-primary">#date</span></p>',
    'installment'                                     => 'imoka',
    'apply_payment_terms'                             => 'Taikyti mokejimo salygas nuolaidos suma',
    'payable_amount'                                  => 'Galutine moketina suma',
    'payable_amount_lt_error'                         => 'Galutine moketina suma turi buti mažesne už saskaitos fakturos likuti.',
    'payment_term_type_4_amount'                      => 'Priimamas dalinis :amount mokejimas',
    'net_terms'                                       => 'Grynosios salygos',
    'proforma_invoice_default'                        => 'Numatytasis išankstines saskaitos fakturos nustatymas',
    'expense_vendor'                                  => 'Išlaidu pardavejas',
    'expense_vendor_deleted'                          => 'Išlaidu pardavejas buvo ištrintas',
    'expense_vendor_already_used'                     => 'Negalite ištrinti tiekejo, turincio susijusiu išlaidu irašu.',
    'total_must_be_gt_zero'                           => 'Bendra :modal_name suma turi buti didesne už nuli.',
    'payment_failed'                                  => 'Mokejimas nepavyko del :error',
    'xss_validation'                                  => 'Lauke :attribute yra žymu, kurios gali atskleisti XSS pažeidžiamuma',
    'support_desk'                                    => 'Palaikymo tarnyba',
    'choose_file'                                     => 'Pasirinkti faila',
    'supportTicket'                                   => 'Palaikymo tarnyba',
    'create_support_ticket'                           => 'Sukurkite palaikymo bilieta',
    'supportTicket_inbox_view'                        => 'Palaikymo tarnyba',
    'support_ticket'                                  => 'Palaikymo bilietas',
    'ticket_number'                                   => 'Bilieto numeris',
    'revision'                                        => 'Peržiura',
    'revisions'                                       => 'Pataisymai',
    'recurring_invoices'                              => 'Pasikartojancios saskaitos',
    'message'                                         => 'Pranešimas',
    'custom_img'                                      => 'Pasirinktinis vaizdas',
    'please_fill_some_data'                           => 'Prašome užpildyti reikiamus duomenis apie nauja preke.',
    'assigned'                                        => 'Paskirta',
    'add_ons_will_be_disabled'                        => 'BUS IŠJUNGTI ŠIAUSI PRIEDAI:',
    'add_ons_will_be_disabled_msg'                    => 'Visi priedai automatiškai išjungiami atnaujinant pagrindini „FusionInvoice“. Baige atnaujinti, butinai atsisiuskite atitinkamus zip failus ir idiekite juos. Kai tai padarysite, galesite juos iš naujo ijungti sistemos nustatymu meniu, tinkinimuose, prieduose ir pasirinke [Idiegti].',
    'price_not_valid'                                 => 'Kaina turi buti didesne už nuli',
    'free_space'                                      => 'Laisva vieta',
    'expense_type'                                    => 'Išlaidu tipas',
    'standard_expense'                                => 'Standartines išlaidos',
    'expense_with_deductible_tax'                     => 'Išlaidos su atskaitomu mokesciu',
    'remittance_to_tax_authority'                     => 'Perlaida mokesciu inspekcijai',
    'tax_paid'                                        => 'Sumoketas mokestis',
    'tax_detail'                                      => 'Mokesciu detale',
    'select_expense_type'                             => 'Pasirinkite išlaidu tipa',
    'taxes_paid_on_expenses_or_remitted'              => 'Mokesciai, sumoketi už išlaidas arba pervesti',
    'tax_name'                                        => 'Mokescio pavadinimas',
    'last_activity'                                   => 'Paskutine veikla',
    'select_default_company_profile'                  => 'Pasirinkite numatytaji imones profili',
    'mn_sales_tax'                                    => 'MN pardavimo mokestis',
    'taxes_collected_on_sales'                        => 'Parduodant surenkami mokesciai',
    'vatgst_tax_note'                                 => 'Taip apskaiciuojamas mokestis kaip itrauktas i bendra prekiu suma. Ne, mokestis bus pridetas prie bendros prekes sumos.',
    'tt_vatgst_tax'                                   => 'Šiame pavyzdyje laikysime 5% mokescio tarifa ir 100 USD prekes kaina. Nustacius Igalinti PVM / GST i Taip, bendra saskaita faktura bus 100 USD, prekes suma bus pakoreguota i 95,24 USD, o mokesciu suma - 4,76 USD. Nustacius PVM / GST i Ne, bendra saskaita faktura bus 105 USD, prekes kaina 100 USD ir 5 USD mokestis.',
    'level_of_detail'                                 => 'Detalumo lygis',
    'tax_report'                                      => 'Mokesciu ataskaita',
    'detail'                                          => 'Detale',
    'totals'                                          => 'Sumos',
    'totals_with_dots'                                => 'Sumos . . .',
    'yes_all'                                         => 'Taip (visi)',
    'invoices_only'                                   => 'Tik saskaitos fakturos',
    'payment_receipts_only'                           => 'Tik mokejimo kvitai',
    'role'                                            => 'Vaidmuo',
    'previous_email'                                  => 'Ankstesnis el',
    'web_store_user_id'                               => 'Internetines parduotuves naudotojo ID: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Grynoji suma, kuria reikia sumoketi iki <span class="text-info">#LASTDATE</span>',
        '2_type'       => '#DISCOUNTPERCENT % nuolaida gali buti taikoma sumokejus iki <span class="text-info">#DISCOUNTDATE</span> ~,</span> kitu atveju grynoji suma turi buti sumoketa iki <span class="text-info">#LASTDATE</span> .',
        '3_type'       => '#DISCOUNTPERCENT % nuolaida gali buti taikoma sumokejus iki <span class="text-info">#DISCOUNTDATE</span> ~,</span> kitu atveju grynoji suma turi buti sumoketa iki <span class="text-info">#LASTDATE</span> .',
        '4_type'       => '<span class="text-info">#DOWNPAYMENT</span>  pradinis inašas yra #INVOICEDATE . Likutis turi buti sumoketas iki <span class="text-info">#LASTDATE</span> .',
        '5_type'       => '<p class="mt-2 mb-1">Mokejimai gali buti padalyti i <span class="text-info">#NUMBEROFINSTALLMENTS</span> imokas</p>',
        '5_1_type'     => '<li>Mokejimas <span class="text-info">#PERCENT %</span> Apmokejimo terminas <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">Kita menesi iš viso yra #N dienu, todel iveskite reikšme nuo 1 iki #N kad gautumete nuolaida kito menesio dienomis.</span>',
    ],
    'payment_term_not_selected'                       => 'Mokejimo terminas nepasirinktas',
    'confirm'                                         => 'Patvirtinti',
    'create_live_invoice_now'                         => 'Sukurti tiesiogine saskaita faktura dabar?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Prenumerata yra kaip saskaitos fakturos šablonas, kuris naudojamas tam tikru dažnumu kuriant tiesiogines saskaitas fakturas.</p><p class="m-0"> Paprastai tai CRON darbas arba suplanuota užduotis yra nustatytas veikti viena karta per diena ir yra atsakingas už tiesioginiu saskaitu fakturu, kurios turetu buti sukurtos, tikrinima pagal prenumeratos lauka Generuoti kita saskaita faktura.  Jei ta datos reikšme yra šiandien arba ankstesne nei šiandien, automatiškai sukuriama tiesiogine saskaita faktura.</p><p class="m-0"> Ši parinktis leidžia rankiniu budu sukurti tiesiogine saskaita faktura iš prenumeratos, apeinant automatini metoda. . Ar noretumete dabar sukurti tiesiogine saskaita faktura?</p>',
    'contact'                                         => 'kontaktas',
    'invoice_month_plus_one'                          => 'Saskaitos fakturos menuo +1',
    'invoice_month_plus_two'                          => 'Saskaitos menuo +2',
    'invoice_month_plus_three'                        => 'Saskaitos menuo +3',
    'inbound_email'                                   => 'Gaunamas el',
    'outbound_email'                                  => 'Siunciamas el',
    'email_signature'                                 => 'Elektroninio pašto parašas',
    'mail_credential_error'                           => 'Netinkama el. pašto konfiguracija. Patikrinkite nustatymus ir bandykite dar karta. <strong>( Konfiguracija <i class="fa fa-arrow-alt-circle-right"> </i> Sistemos nustatymai <i class="fa fa-arrow-alt-circle-right"> </i> El. )</strong>',
    'tt_generate_next_invoice'                        => 'Data, kada iš šios prenumeratos bus automatiškai sukurta kita tiesiogine saskaita.',
    'tt_stop_date'                                    => 'Datos slenkstis, po kurio daugiau šios prenumeratos saskaitos fakturos nebus automatiškai generuojamos. Palikite ši lauka tušcia, jei prenumerata turetu testis amžinai.',
    'description_template'                            => 'Aprašymo šablonas',
    't_1_description'                                 => 'Visas mokejimas turi buti atliktas iki #LASTDATE.',
    't_2_description'                                 => 'Pasinaudokite #DISCOUNTPERCENT % nuolaida, jei apmokesite iki #DISCOUNTDATE, kitu atveju apmokekite visa saskaitos fakturos suma iki #LASTDATE.',
    't_3_description'                                 => 'Pasinaudokite #DISCOUNTPERCENT % nuolaida, jei apmokesite iki #DISCOUNTDATE, kitu atveju apmokekite visa saskaitos fakturos suma iki #LASTDATE.',
    't_4_description'                                 => '#DOWNPAYMENT pradinis inašas turi buti atliktas #INVOICEDATE, saskaitos fakturos likutis iki #LASTDATE',
    't_4_1_description'                               => '#DOWNPAYMENTPERCENT pradine imoka turi buti sumoketa #INVOICEDATE, saskaitos fakturos likutis iki #LASTDATE',
    't_5_description'                                 => 'Mokejimai turi buti atlikti #NUMBEROFINSTALLMENTS lygiomis dalimis',
    't_5_type_description'                            => 'Mokejimas #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT turi buti atliktas #LASTDATE',
    'tokens_allowed'                                  => 'Leidžiami žetonai',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'Ivertintas šablono tekstas yra terminu aprašymas, kuris rodomas tokiuose dokumentuose kaip saskaita faktura, kainos pasiulymai ir kt.',
    'cc_mail'                                         => 'CC paštas',
    'assigned_inv_sent_or_paid'                       => '*Yra apmoketu ar išsiustu saskaitu fakturu, kurioms priskirtas šis mokejimo terminas. Keisti „Tipo“ informacijos neleidžiama.',
    'exclude_paid_invoices'                           => 'Išskirkite apmoketas saskaitas fakturas',
    'phone_number_numeric_error'                      => 'Telefono numeris turi buti skaicius.',
    'phone_num_same_country_code_error'               => 'Isitikinkite, kad jusu telefono numeris yra tinkamai suformatuotas. Atrodo, kad jis buvo ivestas pradedant šalies kodu, o tai neleidžiama.',
    'tt_expense_amount'                               => 'Iveskite visa išlaidu suma, iskaitant mokescius. Šis laukas nepasiekiamas pervedant mokesciu mokejima mokesciu institucijai.',
    'tt_expense_tax_paid_deductible'                  => 'Iveskite mokesciu suma, sumoketa už šias išlaidas. Ši verte bus išskaiciuota iš jusu bendros mokestines prievoles mokesciu suvestines ir išsamios mokesciu ataskaitose.',
    'tt_expense_tax_paid_remittance'                  => 'Iveskite mokesciu suma, kuri buvo pervesta mokesciu institucijai. Tai naudojama jusu apmoketose saskaitose fakturose irašyti mokejimus už surinktus mokescius.',
    'tt_expense_client'                               => 'Jei šios išlaidos buvo patirtos tik kliento vardu ir norite už jas išrašyti saskaita faktura, cia pasirinkite susijusi klienta.',
    'base_currency_not_deleted'                       => 'Bazines valiutos ištrinti negalima',
    'used_currency_modal_error'                       => 'Valiuta jau naudojama :modal_names modulyje.',
    'addon_uninstall_success'                         => 'Priedas sekmingai pašalintas',
    'original'                                        => 'Originalus',
    'revision_current'                                => 'Peržiura (dabartine)',
    'number'                                          => 'Skaicius',
    'copy_process_error'                              => 'Oi! Panašu, kad kopijuojant ivyko triktis. Pabandykite dar karta veliau.',
    'tt_captcha_image'                                => 'CAPTCHA vaizdas',
    'reload_page'                                     => 'Ikelkite puslapi iš naujo',
    'discount_limit'                                  => 'Nuolaida turi buti mažesne nei 99,99%.',
    'tooltip'                                         => 'Patarimas',
    'authorization_error'                             => 'Jus neturite teises atlikti šios operacijos.',
    'reset_to_default'                                => 'Atstatyti i numatytuosius',
    'reset_to_default_warning'                        => '<p>Tai iš naujo nustatys subjekto ir turinio numatytasias :model reikšmes. Testi?</p>',
    'reset_default_mail_template'                     => 'Numatytasis :model pašto šablonas buvo sekmingai nustatytas iš naujo.',
    'overdue_invoice'                                 => 'Neapmoketa saskaita faktura',
    'total_cannot_be_lt_zero'                         => 'Bendra :modal_name suma negali buti mažesne už nuli.',
    'addons_disabled_during_setup'                    => 'Atnaujinimo proceso metu šie priedai buvo išjungti: :addons . Nepamirškite ju ijungti dabar, kai atnaujinimas baigtas.',
    'allow_payments_on_quotes'                        => 'Leisti mokejimus už kotiruotes Y/N',
    'allow_payments_on_quote'                         => 'Leisti mokejima T/N',
    'tt_ss_quotes_is_payable'                         => 'Jei ijungta, patvirtinus pasiulyma, pasiulymo viešosios nuorodos rodinyje pasirodys mygtukas Moketi dabar. Saskaita bus sukurta automatiškai ir mokejimas bus pritaikytas saskaitai fakturai.',
    'pay_with_square'                                 => 'Mokekite su kvadratu',
    'validation_mess_for_is_payable_quote'            => 'Nustatymas automatiškai konvertuoti pasiulyma i saskaita faktura, kai klientas patvirtina, yra butinas, kai Leisti mokejimus pagal kainas nustatytas i „Taip“.',
    'client_requirement_msg'                          => 'Prieš pridedami :seed_name sukurkite klienta',
    'quote_add_items'                                 => 'Reikalingi elementai ir busena neatšaukta',
    'invalid_quote_id'                                => 'Neteisingas citatos ID',
    'information_header'                              => 'Sveikiname, ketinate sutaupyti pinigu!',
    'convenience_charge'                              => 'Patogumo mokestis',
    'credit_card_fee_message'                         => 'Už šia operacija bus taikomas :charge kreditines korteles patogumo mokestis.',
    'info_payment_term_type_2'                        => 'Nors jusu saskaitos fakturos likutis yra :ORIGINAL_AMOUNT, jus turite teise gauti :DISCOUNT_PERCENT % mokejimo salygu nuolaida, todel mokejimo suma sumažinama iki :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Nors jusu saskaitos fakturos likutis yra :ORIGINAL_AMOUNT, jus turite teise gauti :DISCOUNT_PERCENT % mokejimo salygu nuolaida, todel mokejimo suma sumažinama iki :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Nors jusu saskaitos fakturos likutis yra :ORIGINAL_AMOUNT, jus turite teise i mokejimo salygas sumoketi pradini inaša :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Nors jusu saskaitos fakturos likutis yra :ORIGINAL_AMOUNT, jus turite teise moketi išsimoketinai :DISCOUNT_AMOUNT mokejimo salygas.',
    'payment_terms_applied'                           => 'Mokejimo salygos turi buti pašalintos iš :modal prieš ištrinant.',
    'default_payment_term_warn'                       => '*Galite pakeisti tik pavadinima ir grynasias mokejimo dienas pagal <strong>numatytasias sistemos mokejimo salygas</strong>.',
    'quote_rejected_not_payable'                      => 'Citata # :number buvo atmesta ir nera mokama del jos busenos.',
    'could_not_delete'                                => 'Nepavyko ištrinti',
    'convenience_charges_calculation_fail'            => 'Klaida: perkelimo metu nepavyko apskaiciuoti patogumo mokesciu. Pabandykite dar karta veliau.',
    'sign_in_welcome_message'                         => 'ðŸš€ Sveikiname! Jusu „FusionInvoice“ sekmingai idiegta! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>Jusu „FusionInvoice“ sekmingai atnaujinta iš :old_version versijos i :new_version versija.</p><p> Išsamia visu nauju funkciju ir patobulinimu apžvalga rasite musu <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Išleidimo pastabose</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Dekojame, kad pasirinkote „FusionInvoice“. Jusu pasitikejimas, palaikymas ir atsiliepimai skatina musu naujoves.</p><p class="m-0 text-bold">Laimingo saskaitu fakturu išrašymo!</p><p class="text-bold">FusionInvoice komanda</p >',
    'tt_gen_skin_user_profile'                        => 'Pakeitus šia reikšme, sistemos numatytosios nuostatos nustatomos TIK naujiems vartotojams. Vartotojai gali nepaisyti šio nustatymo naudodami savo vartotojo profilio nustatymus.',
    'description_template_invoice'                    => 'Aprašymo šablonas – saskaita faktura',
    'description_template_quote'                      => 'Aprašymo šablonas – citata',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Visas mokejimas turi buti atliktas per #NETDAYS nuo saskaitos fakturos datos.',
    't_2_description_for_quote'                       => 'Pasinaudokite #DISCOUNTPERCENT % nuolaida, jei sumokesite per #DISCOUNTDAYS, kitu atveju sumokekite visa pasiulymo suma iki #NETDAYS.',
    't_3_description_for_quote'                       => 'Pasinaudokite #DISCOUNTPERCENT % nuolaida, jei sumokesite iki kito menesio #NTHDAY , kitu atveju apmokekite visa saskaitos fakturos suma per #NETDAYS dienas.',
    't_4_description_for_quote'                       => '#DOWNPAYMENT pradinis inašas turi buti sumoketas saskaitos fakturos data, likes likutis turi sumoketi per #NETDAYS dienas',
    't_4_1_description_for_quote'                     => '#DOWNPAYMENTPERCENT pradinis inašas turi buti sumoketas saskaitos fakturos data, likusi likuti reikia sumoketi per #NETDAYS dienas',
    't_5_description_for_quote'                       => 'Mokejimai turi buti atlikti #NUMBEROFINSTALLMENTS lygiomis dalimis',
    't_5_type_description_for_quote'                  => 'Mokejimas #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT turi sumoketi #INSTALLMENTDUEDAYS dienas nuo saskaitos fakturos datos',
    'default_term'                                    => 'Numatytasis terminas',
    'proceed_to_payment'                              => 'Pereikite prie mokejimo',
    'version_upgraded'                                => 'Jusu paraiška yra atnaujinta.',
    'term_amount_gt_payment_amount'                   => 'Suma turi buti didesne už mokejimo salygu nuolaidos suma',
    'payment_term_not_eligible_warning'               => 'Mokejimo termino nuolaida taikoma tik apmokant pilnus mokejimus. Deja, jus tam netinkate.',
    'processed_by_user'                               => '<strong>Apdorojo:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Mokejimo budas:</strong> :method',
    'all_methods'                                     => 'Visi metodai',
    'this_payment'                                    => 'Šis mokejimas',
    'previous_balance'                                => 'Ankstesnis balansas',
    'payment_applied_with_remaining_balance'          => '<p><strong>Jusu :amount mokejimas buvo iš dalies pritaikytas. :remaining_balance lieka neapmoketas.</strong></p>',
    'pre_payment_received'                            => '<p><strong>Gautas :amount išankstinis mokejimas už busimas saskaitas fakturas :date .</strong></p>',
    'payment_full_applied'                            => '<p><strong>Jusu mokejimas :amount buvo visiškai pritaikytas.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Mokejimas <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;"> :formatted_number</span> ~ Išsami informacija:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>Mokejimas :paid buvo pritaikytas saskaitai fakturai :invoice_number :date</span> ~',
    'payment_full_applied_on_inv_with_ptd'            => '<p>Mokejimas :paid, atemus :payment_terms_discount mokejimo termino nuolaida, buvo pritaikytas saskaitai fakturai :invoice_number :date</span> ~',
    'payment_full_applied_on_inv_with_cc'             => '<p>Mokejimas :paid, ir :convenience_charges patogumo mokesciai buvo pritaikytas saskaitai fakturai :invoice_number :date</span> ~',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>Apmokejimas :paid, plius :convenience_charges patogumo mokesciai ir minus :payment_terms_discount mokejimo termino nuolaida, buvo pritaikytas saskaitai fakturai :invoice_number :date</span> ~',
    'payment_remaining_balance_mail_message'          => '<p>Likes saskaitos fakturos :invoice_number likutis yra :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Neapmoketos saskaitos fakturos',
    'include'                                         => 'Itraukti',
    'exclude'                                         => 'Neitraukti',
    'invoice_with_no_tax'                             => 'Saskaitos be mokesciu',
    'tax_total'                                       => 'Mokesciu suma',
];

return TranslationOverride::override(__FILE__, $translations);
