<?php

$translations = [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'                        => 'L :attribute deve essere accettato.',
    'active_url'                      => ':attribute non è un URL valido.',
    'after'                           => ':attribute deve essere una data successiva :date.',
    'after_or_equal'                  => ':attribute deve essere una data successiva o uguale a :date.',
    'alpha'                           => 'L :attribute può contenere solo lettere.',
    'alpha_dash'                      => 'L :attribute può contenere solo lettere, numeri e trattini.',
    'alpha_num'                       => 'L :attribute può contenere solo lettere e numeri.',
    'array'                           => 'L :attribute deve essere un array.',
    'before'                          => ':attribute deve essere una data precedente :date.',
    'before_or_equal'                 => ':attribute deve essere una data precedente o uguale a :date.',
    'between'                         => [
        'numeric' => 'Il :attribute deve essere compreso tra :min e :max.',
        'file'    => 'L :attribute deve essere compreso tra :min e :max kilobyte.',
        'string'  => 'L :attribute deve essere compreso tra i caratteri :min e :max.',
        'array'   => 'L :attribute deve contenere elementi compresi tra :min e :max.',
    ],
    'boolean'                         => 'Il campo :attribute deve essere vero o falso.',
    'confirmed'                       => 'La conferma :attribute non corrisponde.',
    'date'                            => 'L :attribute non è una data valida.',
    'date_format'                     => 'L :attribute non corrisponde al formato :format.',
    'different'                       => ':attribute e :other devono essere diversi.',
    'digits'                          => 'L :attribute deve essere :digits cifre.',
    'digits_between'                  => 'L :attribute deve essere compreso tra le cifre :min e :max.',
    'dimensions'                      => 'L :attribute ha dimensioni dell\'immagine non valide.',
    'distinct'                        => 'Il campo :attribute ha un valore duplicato.',
    'email'                           => 'Il :attribute deve essere un indirizzo email valido.',
    'exists'                          => 'L :attribute selezionato non è valido.',
    'file'                            => 'L :attribute deve essere un file.',
    'filled'                          => 'Il campo :attribute deve avere un valore.',
    'image'                           => 'L :attribute deve essere un\'immagine.',
    'in'                              => 'L :attribute selezionato non è valido.',
    'in_array'                        => 'Il campo :attribute non esiste in :other.',
    'integer'                         => 'L :attribute deve essere un numero intero.',
    'ip'                              => 'Il :attribute deve essere un indirizzo IP valido.',
    'ipv4'                            => 'L :attribute deve essere un indirizzo IPv4 valido.',
    'ipv6'                            => 'Il :attribute deve essere un indirizzo IPv6 valido.',
    'json'                            => ':attribute deve essere una stringa JSON valida.',
    'max'                             => [
        'numeric' => 'Il :attribute non può essere maggiore di :max.',
        'file'    => 'Il :attribute non può essere maggiore di :max kilobyte.',
        'string'  => 'Il :attribute non può essere maggiore di :max caratteri.',
        'array'   => 'L\' :attribute non può contenere più di :max elementi.',
    ],
    'mimes'                           => ':attribute deve essere un file di tipo: :values.',
    'mimetypes'                       => ':attribute deve essere un file di tipo: :values.',
    'min'                             => [
        'numeric' => 'L :attribute deve essere almeno :min.',
        'file'    => 'L\' :attribute deve essere almeno :min kilobyte.',
        'string'  => 'L :attribute deve contenere almeno :min caratteri.',
        'array'   => 'L :attribute deve contenere almeno :min elementi.',
    ],
    'not_in'                          => 'L :attribute selezionato non è valido.',
    'numeric'                         => 'L :attribute deve essere un numero.',
    'present'                         => 'Il campo :attribute deve essere presente.',
    'regex'                           => 'Il formato :attribute non è valido.',
    'required'                        => 'Il campo :attribute è obbligatorio.',
    'required_if'                     => 'Il campo :attribute è obbligatorio quando :other è :value.',
    'required_unless'                 => 'Il campo :attribute è obbligatorio a meno che :other non sia in :values.',
    'required_with'                   => 'Il campo :attribute è obbligatorio quando è presente :values.',
    'required_with_all'               => 'Il campo :attribute è obbligatorio quando è presente :values.',
    'required_without'                => 'Il campo :attribute è obbligatorio quando :values non è presente.',
    'required_without_all'            => 'Il campo :attribute è obbligatorio quando nessuno dei :values è presente.',
    'same'                            => ':attribute e :other devono corrispondere.',
    'size'                            => [
        'numeric' => 'Il :attribute deve essere :size.',
        'file'    => 'L :attribute deve essere :size kilobyte.',
        'string'  => 'Gli :attribute devono essere costituiti :size caratteri.',
        'array'   => 'L :attribute deve contenere elementi :size.',
    ],
    'string'                          => 'L :attribute deve essere una stringa.',
    'timezone'                        => 'L :attribute deve essere una zona valida.',
    'unique'                          => 'L\' :attribute è già stato preso.',
    'uploaded'                        => 'Impossibile caricare l\' :attribute.',
    'url'                             => 'Il formato :attribute non è valido.',
    'captcha'                         => 'L\' :attribute non è corretto',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom'                          => [
        'attribute-name' => [
            'rule-name' => 'messaggio personalizzato',
        ],
        'field_label'    => [
            'regex' => 'L\'etichetta del campo contiene un carattere non valido. Caratteri consentiti: A-Z, a-z, 0-9, spazio, -, _',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes'                      => [],
    'unique_of_decimal_and_thousands' => 'Decimal point and thousand separator already selected for another currency'

];

return \FI\Support\TranslationOverride::override(__FILE__, $translations);
