<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Configurazione account',
    'active'                                          => 'Attivo',
    'activity'                                        => 'Attività',
    'activity_invoice_paid'                           => 'La fattura <a href=":link">#:number</a> è stata pagata.',
    'activity_invoice_viewed'                         => 'La fattura <a href=":link">#:number</a> è stata visualizzata.',
    'activity_quote_approved'                         => 'Il preventivo <a href=":link">#:number</a> è stato approvato.',
    'activity_quote_rejected'                         => 'Il preventivo <a href=":link">#:number</a> è stato rifiutato.',
    'activity_quote_viewed'                           => 'Il preventivo <a href=":link">#:number</a> è stato visualizzato.',
    'add_item'                                        => 'Aggiungi elemento',
    'add_line_item_to_invoice'                        => 'Aggiungi oggetto alla fattura',
    'add_note'                                        => 'Aggiungi nota',
    'additional'                                      => 'Aggiuntivo',
    'addon'                                           => 'Add-on',
    'addons'                                          => 'Add-on',
    'address'                                         => 'Indirizzo',
    'address_format'                                  => 'Formato indirizzo',
    'after_amount'                                    => 'Dopo l\'importo',
    'all'                                             => 'Tutto',
    'all_categories'                                  => 'Tutte le categorie',
    'all_statuses'                                    => 'Tutti gli stati',
    'all_time'                                        => 'Tutto',
    'all_vendors'                                     => 'Tutti i fornitori',
    'allow_login'                                     => 'Permetti login',
    'always_attach_pdf'                               => 'Allega sempre il PDF',
    'always_bcc'                                      => 'Indirizzo sempre in BCC',
    'always_cc'                                       => 'Indirizzo sempre in CC',
    'amount'                                          => 'Importo',
    'api_public_key'                                  => 'Chiave pubblica API',
    'api_secret_key'                                  => 'Chiave privata API',
    'approve'                                         => 'Approva',
    'approved'                                        => 'Approvato',
    'approved_quotes'                                 => 'Preventivi approvati',
    'attach_files'                                    => 'Allega file',
    'attach_pdf'                                      => 'Allega PDF',
    'attachment'                                      => 'Allegato',
    'attachments'                                     => 'Allegati',
    'author'                                          => 'Autore',
    'automatic'                                       => 'Automatico',
    'automatic_email_on_recur'                        => 'Invia automaticamente le fatture ricorrenti',
    'automatic_email_payment_receipts'                => 'Invia automaticamente le ricevute di pagamento',
    'available_fields'                                => 'Campi disponibili',
    'back'                                            => 'Indietro',
    'back_to_invoice'                                 => 'Ritorna alla fattura',
    'back_to_quote'                                   => 'Ritorna al preventivo',
    'balance'                                         => 'Saldo',
    'base_currency'                                   => 'Valuta di base',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Prima dell\'importo',
    'bill_this_expense'                               => 'Fattura questa spesa',
    'bill_to'                                         => 'Fatturare a',
    'billable'                                        => 'Fatturabile',
    'billed'                                          => 'Fatturato',
    'billing_address'                                 => 'Indirizzo di fatturazione',
    'billing_city'                                    => 'Città di fatturazione',
    'billing_name'                                    => 'Nome di fatturazione',
    'billing_state'                                   => 'Stato di fatturazione',
    'billing_zip'                                     => 'CAP di fatturazione',
    'binary_path'                                     => 'Path dei binari',
    'body'                                            => 'Messaggio',
    'cancel'                                          => 'Cancella',
    'canceled'                                        => 'Cancellato',
    'card_number'                                     => 'Numero della carta',
    'cash'                                            => 'Contanti',
    'category'                                        => 'Categoria',
    'cc'                                              => 'CC',
    'change'                                          => 'Cambia',
    'change_client'                                   => 'Cambia cliente',
    'check_for_update'                                => 'Controlla aggiornamenti',
    'city'                                            => 'Città',
    'clear_keys'                                      => 'Cancella le chiavi',
    'client'                                          => 'Cliente',
    'client_form'                                     => 'Modifica cliente',
    'client_name'                                     => 'Nome cliente',
    'client_not_found'                                => 'Cliente non trovato',
    'client_statement'                                => 'Estratto conto cliente',
    'client_unique_name_option_1'                     => 'Solo quando il nome cliente non è unico',
    'client_unique_name_option_2'                     => 'Visualizza sempre',
    'client_visibility'                               => 'Visibilità cliente',
    'clients'                                         => 'Clienti',
    'code'                                            => 'Codice',
    'column_name'                                     => 'Nome colonna',
    'column_width'                                    => 'Larghezza colonna',
    'company'                                         => 'Azienda',
    'complete'                                        => 'Completa',
    'complete_upgrade'                                => 'Completa aggiornamento',
    'compound'                                        => 'Composta',
    'compound_tax_note'                               => 'Le aliquote per le tasse composte devono essere applicate ad un elemento tramite il campo Tassa 2 per avere l\'effetto desiderato.',
    'confirm_approve_quote'                           => 'Sei sicuro di voler approvare questo preventivo?',
    'confirm_reject_quote'                            => 'Sei sicuro di voler rifiutare questo preventivo?',
    'continue'                                        => 'Continua',
    'convert_quote_option1'                           => 'La fattura deve conservare i termini del preventivo',
    'convert_quote_option2'                           => 'La fattura deve usare i termini di default',
    'convert_quote_setting'                           => 'Quando un preventivo viene convertito in una fattura',
    'convert_quote_when_approved'                     => 'Converti automaticamente il preventivo in fattura quando il cliente lo approva',
    'converted_from_quote'                            => 'Convertito da preventivo',
    'converted_to_invoice'                            => 'Convertito in fattura',
    'country'                                         => 'Nazione',
    'create_invoice'                                  => 'Crea fattura',
    'create_quote'                                    => 'Crea preventivo',
    'created'                                         => 'Creato',
    'credit_card'                                     => 'Carta di credito',
    'currencies'                                      => 'Valute',
    'currency'                                        => 'Valuta',
    'currency_form'                                   => 'Formato valuta',
    'currency_symbol'                                 => 'Simbolo di valuta',
    'currency_symbol_placement'                       => 'Posizionamento del simbolo di valuta',
    'custom_date_range'                               => 'Intervallo date personalizzato',
    'custom_field_form'                               => 'Modifica campo personalizzato',
    'custom_fields'                                   => 'Campi personalizzati',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'Dashboard',
    'dashboard_totals_option'                         => 'I totali nella dashboard devono includere',
    'database_not_configured'                         => 'Sembra che app/config/database.php non sia stato ancora configurato.',
    'database_setup'                                  => 'Configurazione database',
    'date'                                            => 'Data',
    'date_format'                                     => 'Formato data',
    'days'                                            => 'Giorni',
    'decimal_point'                                   => 'Punto decimale',
    'default_currency'                                => 'Valuta di default',
    'default_footer'                                  => 'Footer di default',
    'default_group'                                   => 'Gruppo di default',
    'default_invoice_email_body'                      => 'Messaggio email di default per le fatture',
    'default_invoice_template'                        => 'Modello di default per le fatture',
    'default_item_tax_2_rate'                         => 'Aliquota di default per la Tassa 2 di un elemento',
    'default_item_tax_rate'                           => 'Aliquota IVA di default',
    'default_overdue_invoice_email_body'              => 'Messaggio email di default per le fatture in ritardo',
    'default_payment_receipt_body'                    => 'Messaggio email di default per le ricevute di pagamento',
    'default_quote_email_body'                        => 'Messaggio email di default per i preventivi',
    'default_quote_template'                          => 'Modello di default per i preventivi',
    'default_terms'                                   => 'Termini di default',
    'delete'                                          => 'Elimina',
    'delete_client_warning'                           => 'Se elimini questo cliente eliminerai anche tutte le fatture, i preventivi e i pagamenti relativi a questo cliente. Sei sicuro di voler eliminare definitivamente questo cliente?',
    'delete_record_warning'                           => 'Sei sicuro di voler eliminare questo record?',
    'description'                                     => 'Descrizione',
    'details'                                         => 'Dettagli',
    'disabled'                                        => 'Disabilitato',
    'discount'                                        => 'Sconto',
    'display_client_unique_name'                      => 'Visualizza nome unico cliente',
    'display_do_not_require'                          => 'Visualizza ma non renderlo obbligatorio',
    'display_order'                                   => 'Ordine di visualizzazione',
    'display_profile_image'                           => 'Visualizza immagine profilo',
    'do_not_add_line_item_to_invoice'                 => 'Non aggiungere elemento alla fattura',
    'do_not_display'                                  => 'Non visualizzare',
    'documentation'                                   => 'Documentazione',
    'download'                                        => 'Download',
    'draft'                                           => 'Bozza',
    'draft_invoices'                                  => 'Bozze fatture',
    'draft_quotes'                                    => 'Bozze preventivi',
    'dropdown'                                        => 'Dropdown',
    'due'                                             => 'Dovuto',
    'due_date'                                        => 'Scadenza',
    'edit'                                            => 'Modifica',
    'edit_client'                                     => 'Modifica cliente',
    'email'                                           => 'Email',
    'email_address'                                   => 'Indirizzo email',
    'email_invoice'                                   => 'Invia fattura tramite email',
    'email_payment_receipt'                           => 'Invia ricveuta di pagamento tramite email',
    'email_quote'                                     => 'Invia preventivo tramite email',
    'email_send_method'                               => 'Metodo di invio mail',
    'email_send_method_phpmail'                       => 'PHP Mail',
    'email_send_method_sendmail'                      => 'Sendmail',
    'email_send_method_sendgrid'                      => 'API SendGrid',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Abilitato',
    'enter_payment'                                   => 'Inserisci pagamento',
    'error'                                           => 'Errore',
    'every'                                           => 'Ogni',
    'exchange_rate'                                   => 'Tasso di cambio',
    'exchange_rate_mode'                              => 'Modalità tasso di cambio',
    'expense_form'                                    => 'Modifica spesa',
    'expenses'                                        => 'Spese',
    'expiration'                                      => 'Scadenza',
    'expires'                                         => 'Scade',
    'export_clients'                                  => 'Esporta clienti',
    'export_data'                                     => 'Esporta dati',
    'export_expenses'                                 => 'Esporta spese',
    'export_invoice_items'                            => 'Esporta prodotti fatture',
    'export_invoices'                                 => 'Esporta fatture',
    'export_payments'                                 => 'Esporta pagamenti',
    'export_quote_items'                              => 'Esporta prodotti preventivi',
    'export_quotes'                                   => 'Esporta preventivi',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Numero di fax',
    'field_label'                                     => 'Etichetta campo',
    'field_meta'                                      => 'Campo meta',
    'field_meta_description'                          => 'Usa il campo meta solo se il campo è di tipo dropdown. Per specificare i valori del menu dropdown, inserisci una lista di elementi separati da virgole.',
    'field_type'                                      => 'Tipo di campo',
    'footer'                                          => 'Footer',
    'format'                                          => 'Formato',
    'frequency'                                       => 'Frequenza',
    'from'                                            => 'Da',
    'from_date'                                       => 'Data di inizio',
    'general'                                         => 'Generale',
    'generate_keys'                                   => 'Genera chiavi',
    'group'                                           => 'Gruppo',
    'group_form'                                      => 'Modifica gruppo',
    'groups'                                          => 'Gruppi',
    'header_title_text'                               => 'Testo del titolo nell\'intestazione',
    'help'                                            => 'Aiuto',
    'help_currency_code'                              => 'Il codice della valuta, ad esempio "USD".',
    'help_currency_name'                              => 'Il nome della valuta, ad esempio "Dollaro americano".',
    'help_currency_symbol'                            => 'Il simbolo della valuta, ad esempio "$".',
    'help_currency_symbol_placement'                  => 'Dove posizionare il simbolo della valuta.',
    'help_text_client_name'                           => 'Questo valore potrebbe essere il nome di un\'azienda o di una persona e apparirà nei preventivi e nelle fatture. Non è necessario che questo valore sia unico.',
    'help_text_client_password'                       => 'Lascia vuoto questo campo a meno che tu non stia creando o resettando una password.',
    'help_text_client_unique_name'                    => 'Quando uno o più clienti nel sistema hanno lo stesso nome, è necessario inserire un nome unico per distinguerli. Questo nome non apparirà nei preventivi o nelle fatture.',
    'i_accept'                                        => 'Accetto',
    'import_data'                                     => 'Importa dati',
    'inactive'                                        => 'Inattivo',
    'income'                                          => 'Reddito',
    'install'                                         => 'Installa',
    'installation_complete'                           => 'Installazione completa',
    'installing_please_wait'                          => 'Installazione in corso, si prega di attendere...',
    'invalid_credentials'                             => 'Credenziali invalide',
    'invoice'                                         => 'Fattura',
    'invoice_default'                                 => 'Fattura di default',
    'invoice_email_subject'                           => 'Oggetto email di default per le fatture',
    'invoice_items'                                   => 'Elementi fattura',
    'invoice_number'                                  => 'Numero fattura',
    'invoice_summary'                                 => 'Riassunto fatture',
    'invoiced'                                        => 'Fatturato',
    'invoices'                                        => 'Fatture',
    'invoices_due_after'                              => 'Fatture dovute dopo (giorni)',
    'issued'                                          => 'Emessa',
    'item'                                            => 'Prodotto',
    'item_lookup_form'                                => 'Modifica lookup prodotto',
    'item_lookups'                                    => 'Lookup prodotti',
    'item_sales'                                      => 'Vendite prodotti',
    'items'                                           => 'Prodotti',
    'label_invoice'                                   => 'Scegli la fattura a cui aggiungere questa spesa',
    'label_item_description'                          => 'Inserisci una descrizione per questa spesa (opzionale)',
    'label_item_name'                                 => 'Inserisci il nome del prodotto da aggiungere alla fattura',
    'landscape'                                       => 'Orizzontale',
    'language'                                        => 'Lingua',
    'left_pad'                                        => 'Imbottitura a sinistra',
    'left_pad_description'                            => 'Il numero di zeri da applicare opzionalmente al prossimo numero.',
    'legal'                                           => 'Legale',
    'letter'                                          => 'Lettera',
    'license_agreement'                               => 'Accordo di licenza',
    'license_agreement_accept'                        => 'Accetto i termini dell\'accordo di licenza',
    'logo'                                            => 'Logo',
    'mail_hash_error'                                 => 'Sembra che la tua chiave segreta sia stata cambiata dall\'ultima volta che hai salvato la password della tua email. Per risolvere questo problema, vai alle Impostazioni di sitema -> Scheda Email, inserisci nuovamente la password della tua email e premi Salva. Ricordati che non verranno inviate ulteriori email finché non avrai seguito questi passaggi.',
    'manual'                                          => 'Manuale',
    'map_fields_to_import'                            => 'Mappa i campi da importare',
    'merchant_api_key'                                => 'Chiave API',
    'merchant_api_password'                           => 'Password API',
    'merchant_api_username'                           => 'Username API',
    'merchant_publishable_key'                        => 'Chiave pubblicabile',
    'merchant_secret_key'                             => 'Chiave segreta',
    'merchant_signature'                              => 'Firma',
    'mobile'                                          => 'Cellulare',
    'mobile_number'                                   => 'Numero di cellulare',
    'monthly'                                         => 'Mensile',
    'months'                                          => 'Mesi',
    'multiple_email_validation'                       => 'Gli indirizzi email multipli devono essere validi e separati da virgole.',
    'name'                                            => 'Nome',
    'net_income'                                      => 'Reddito netto',
    'never'                                           => 'Mai',
    'new'                                             => 'Nuovo',
    'next_date'                                       => 'Prossima data',
    'next_number'                                     => 'Prossimo numero',
    'no'                                              => 'No',
    'no_open_invoices'                                => 'Questo cliente non ha fatture aperte. Per fatturare una spesa, il cliente deve avere almeno una fattura non pagata completamente.',
    'no_records_found'                                => 'Nessun record trovato.',
    'none'                                            => 'Nessuno',
    'not_billable'                                    => 'Non fatturabile',
    'not_billed'                                      => 'Non fatturato',
    'not_viewed'                                      => 'Non visualizzato',
    'not_visible'                                     => 'Non visibile',
    'note'                                            => 'Nota',
    'note_notification'                               => 'Notifica: Nuova nota',
    'notes'                                           => 'Note',
    'online_payment'                                  => 'Pagamento online',
    'online_payment_method'                           => 'Metodo di pagamento online',
    'online_payments'                                 => 'Pagamenti online',
    'options'                                         => 'Opzioni',
    'other'                                           => 'Altro',
    'output_type'                                     => 'Tipo di output',
    'overdue'                                         => 'Scadute',
    'overdue_email_subject'                           => 'Oggetto email di default per le fatture scadute',
    'overdue_invoice_reminder'                        => 'Promemoria fatture scadute',
    'overdue_invoice_reminder_frequency'              => 'Frequenza del promemoria per le fatture scadute',
    'overdue_invoice_reminder_frequency_help'         => 'Una lista separata da virgole di giorni DOPO i quali verrà inviato un promemoria per la fattura. Lasciare in bianco per disabilitare i promemoria per le fatture non pagate. Per esempio, un valore di 1,5,10 invierebbe promemoria 1, 5 e 10 dopo la data di scadenza della fattura.',
    'overdue_invoices'                                => 'Fatture scadute',
    'paid'                                            => 'Pagata',
    'paper_orientation'                               => 'Orientamento carta',
    'paper_size'                                      => 'Dimensioni carta',
    'password'                                        => 'Password',
    'password_confirmation'                           => 'Conferma password',
    'password_successfully_reset'                     => 'Password resettata correttamente',
    'pay'                                             => 'Paga',
    'pay_now'                                         => 'Paga ora',
    'payment_applied'                                 => 'Il tuo pagamento è stato applicato',
    'payment_button_text'                             => 'Testo per il pulsante di pagamento',
    'payment_date'                                    => 'Data pagamento',
    'payment_form'                                    => 'Modifica pagamento',
    'payment_method'                                  => 'Metodo di pagamento',
    'payment_method_form'                             => 'Modifica metodo di pagamento',
    'payment_methods'                                 => 'Metodi di pagamento',
    'payment_receipt'                                 => 'Ricevuta di pagamento',
    'payment_receipt_email_subject'                   => 'Oggetto della mail per le ricevute di pagamento',
    'payments'                                        => 'Pagamenti',
    'payments_collected'                              => 'Pagamenti ricevuti',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'Driver PDF',
    'pdf_driver_wkhtmltopdf'                          => 'Il campo Path dei binari deve contenere un file path valido quando si usa il driver PDF wkhtmltopdf.',
    'percent'                                         => 'Percentuale',
    'phone'                                           => 'Telefono',
    'phone_number'                                    => 'Numero di telefono',
    'php_version_error'                               => 'PHP non rispetta i requisiti di versione (%s)',
    'placeholder_type_message'                        => 'Inserisci messaggio...',
    'portrait'                                        => 'Verticale',
    'postal_code'                                     => 'CAP',
    'prefix'                                          => 'Prefisso',
    'prerequisites'                                   => 'Prerequisiti',
    'preview'                                         => 'Anteprima',
    'price'                                           => 'Prezzo',
    'private'                                         => 'Privato',
    'problem_with_email_template'                     => 'Sembra che ci sia un problema con il modello delle email. Si prega di controllare i modelli nelle Impostazioni di sistema nella scheda Email.',
    'product'                                         => 'Prodotto',
    'profit_and_loss'                                 => 'Profitti e perdite',
    'public'                                          => 'Pubblico',
    'qty'                                             => 'Q.tà',
    'quantity'                                        => 'Quantità',
    'quantity_price_decimals'                         => 'Numero di cifre decimali per quantità e importi',
    'quote'                                           => 'Preventivo',
    'quote_approved'                                  => 'Preventivo approvato',
    'quote_approved_email_body'                       => 'Messaggio email per i preventivi approvati',
    'quote_default'                                   => 'Preventivo di default',
    'quote_email_subject'                             => 'Oggetto email per i preventivi',
    'quote_items'                                     => 'Prodotti preventivo',
    'quote_number'                                    => 'Numero di preventivo',
    'quote_rejected'                                  => 'Preventivo rifiutato',
    'quote_rejected_email_body'                       => 'Messaggio email per i preventivi rifiutati',
    'quote_status_change_notification'                => 'Notifica: stato del preventivo aggiornato',
    'quote_summary'                                   => 'Riassunto preventivi',
    'quote_to_invoice'                                => 'Da preventivo a fattura',
    'quotes'                                          => 'Preventivi',
    'quotes_expire_after'                             => 'I preventivi scadono dopo (giorni)',
    'recalculate'                                     => 'Ricalcola',
    'recalculate_help_text'                           => 'Il ricalcolo potrebbe avere bisogno di un po\' di tempo. Verrà visualizzato un messaggio al termine del processo.',
    'recalculate_invoices'                            => 'Ricalcola fatture',
    'recalculate_quotes'                              => 'Ricalcola preventivi',
    'recalculating_wait'                              => 'Ricalcolo in corso, si prega di attendere...',
    'recalculation_complete'                          => 'Ricalcolo completo',
    'recent_invoices'                                 => 'Fatture recenti',
    'recent_payments'                                 => 'Pagamenti recenti',
    'recent_quotes'                                   => 'Preventivi recenti',
    'record_not_found'                                => 'Record non trovato',
    'record_successfully_created'                     => 'Record creato con successo',
    'record_successfully_deleted'                     => 'Record eliminato con successo',
    'record_successfully_updated'                     => 'Record aggiornato con successo updated',
    'records_imported_successfully'                   => 'Records importati con successo',
    'recurring'                                       => 'Ricorrenti',
    'reject'                                          => 'Rifiuta',
    'rejected'                                        => 'Rifiutato',
    'rejected_quotes'                                 => 'Preventivi rifiutati',
    'remember_me'                                     => 'Ricordami',
    'remove_logo'                                     => 'Rimuovi logo',
    'report_rev_client_notice'                        => 'Questo report sarà disponibile quando avrai inserito alcuni pagamenti nel sistema.',
    'reports'                                         => 'Report',
    'require'                                         => 'Richiedi',
    'reset_number'                                    => 'Resetta numero',
    'reset_password'                                  => 'Resetta password',
    'results_per_page'                                => 'Risultati per pagina',
    'revenue_by_client'                               => 'Reddito per cliente',
    'round_tax_decimals'                              => 'Numero di cifre decimali per l\'arrotondamento delle tasse',
    'run_report'                                      => 'Esegui report',
    'save'                                            => 'Salva',
    'save_and_apply_exchange_rate'                    => 'Salva e applica tasso di cambio',
    'save_item_as_lookup'                             => 'Salva elemento come lookup',
    'search'                                          => 'Cerca',
    'select_file_to_import'                           => 'Seleziona il file da importare',
    'send'                                            => 'Invia',
    'sending'                                         => 'Invio in corso',
    'sendmail_path'                                   => 'Path sendmail',
    'sent'                                            => 'Inviato',
    'sent_invoices'                                   => 'Fatture inviate',
    'sent_quotes'                                     => 'Preventivi inviati',
    'settings'                                        => 'Impostazioni',
    'settings_successfully_saved'                     => 'Impostazioni salvate correttamente',
    'setup'                                           => 'Installazione',
    'sign_in'                                         => 'Accedi',
    'sign_out'                                        => 'Esci',
    'skin'                                            => 'Tema',
    'smtp_encryption'                                 => 'Cifratura SMTP',
    'smtp_host_address'                               => 'Indirizzo host SMTP',
    'smtp_host_port'                                  => 'Porta host SMTP',
    'smtp_password'                                   => 'Password SMTP',
    'smtp_username'                                   => 'Username SMTP',
    'start_date'                                      => 'Data di inizio',
    'state'                                           => 'Stato',
    'status'                                          => 'Stato',
    'step_database_setup'                             => 'Questo passaggio installerà e aggiornerà le tabelle del database. Questo passaggio potrebbe metterci un po\' di tempo.',
    'step_prerequisites'                              => 'I seguenti prerequisiti devono essere risolti prima di poter proseguire con l\'installazione:',
    'subject'                                         => 'Oggetto',
    'submit'                                          => 'Invia',
    'subtotal'                                        => 'Imponibile',
    'summary'                                         => 'Riassunto',
    'symbol'                                          => 'Simbolo',
    'symbol_placement'                                => 'Posizionamento del simbolo',
    'system'                                          => 'Sistema',
    'system_settings'                                 => 'Impostazioni di sistema',
    'table_name'                                      => 'Nome tabella',
    'tax'                                             => 'IVA',
    'tax_1'                                           => 'Tassa 1',
    'tax_2'                                           => 'Tassa 2',
    'tax_rate'                                        => 'Aliquota IVA',
    'tax_rate_form'                                   => 'Modifica aliquota tassa',
    'tax_rate_name'                                   => 'Nome aliquota tassa',
    'tax_rate_percent'                                => 'Percentuale aliquota tassa',
    'tax_rates'                                       => 'Aliquote tasse',
    'tax_summary'                                     => 'Riassunto tasse',
    'taxable_amount'                                  => 'Importo tassabile',
    'taxes'                                           => 'Tasse',
    'template'                                        => 'Modello',
    'terms_and_conditions'                            => 'Termini e condizioni',
    'test_mode'                                       => 'Modalità test',
    'text'                                            => 'Testo',
    'textarea'                                        => 'Area di testo',
    'this_quarter'                                    => 'Questo trimestre',
    'thousands_separator'                             => 'Separatore migliaia',
    'timezone'                                        => 'Fuso orario',
    'to'                                              => 'A',
    'to_date'                                         => 'Data di fine',
    'total'                                           => 'Totale',
    'total_balance'                                   => 'Totale saldo',
    'total_invoiced'                                  => 'Totale fatturato',
    'total_expenses'                                  => 'Totale spese',
    'total_paid_invoices'                             => 'Totale fatture pagate',
    'try_again'                                       => 'Riprova',
    'uninstall'                                       => 'Disinstalla',
    'uninstall_addon_warning'                         => 'La disintallazione di questo add-on rimuoverà tutti i dati che hai inserito collegati a questo add-on. Sei sicuro di voler continuare?',
    'unique_name'                                     => 'Nome unico',
    'unknown_error'                                   => 'Errore sconosciuto',
    'upcoming_payment_notice_email_body'              => 'Messaggio email per i pagamenti imminenti',
    'upcoming_payment_notice_email_subject'           => 'Oggetto email per i pagamenti imminenti',
    'upcoming_payment_notice_frequency'               => 'Frequenza delle notifiche per i pagamenti imminenti',
    'upcoming_payment_notice_frequency_help'          => 'Una lista separata da virgole di giorni PRIMA dei quali verrà inviato un promemoria per la fattura. Lasciare in bianco per disabilitare i promemoria per i pagamenti imminenti. Per esempio, un valore di 1,5 invierebbe promemoria 1 e 5 giorni prima della data di scadenza della fatturae 10 dopo la data di scadenza della fattura.',
    'update_available'                                => 'FusionInvoice :version è disponibile per il download!',
    'update_exchange_rate'                            => 'Aggiorna tasso di cambio',
    'update_not_available'                            => 'Non ci sono aggiornamenti disponibili.',
    'upload_progress'                                 => 'Progresso dell\'upload',
    'user'                                            => 'Utente',
    'user_accounts'                                   => 'Account utente',
    'user_form'                                       => 'Modifica utente',
    'users'                                           => 'Utenti',
    'validation_invoice_summary_from_date'            => 'La data di inizio nel widget Dashboard riassunto fatture è necessaria quando l\'intervallo date è impostato su Intervallo date personalizzato.',
    'validation_invoice_summary_to_date'              => 'La data di fine nel widget Dashboard riassunto fatture è necessaria quando si usa un intervallo date personalizzato.',
    'validation_quote_summary_from_date'              => 'La data di inizio nel widget Dashboard riassunto preventivi è necessaria quando si usa un intervallo date personalizzato.',
    'validation_quote_summary_to_date'                => 'La data di fine nel widget Dashboard riassunto preventivi è necessaria quando si usa un intervallo date personalizzato.',
    'vendor'                                          => 'Fornitore',
    'version'                                         => 'Versione',
    'view'                                            => 'Visualizza',
    'view_all'                                        => 'Visualizza tutto',
    'view_all_invoices_for_client'                    => 'Visualizza tutte le fatture per questo cliente',
    'view_all_payments_for_client'                    => 'Visualizza tutti i pagamenti per questo cliente',
    'view_all_quotes_for_client'                      => 'Visualizza tutti i preventivi per questo cliente',
    'view_approved_quotes'                            => 'Visualizza preventivi approvati',
    'view_client'                                     => 'Visualizza cliente',
    'view_draft_invoices'                             => 'Visualizza fatture in formato bozza',
    'view_draft_quotes'                               => 'Visualizza preventivi in formato bozza',
    'view_overdue_invoices'                           => 'Visualizza fatture scadute',
    'view_payments'                                   => 'Visualizza pagamenti',
    'view_rejected_quotes'                            => 'Visualizza preventivi rifiutati',
    'view_sent_invoices'                              => 'Visualizza fatture inviate',
    'view_sent_quotes'                                => 'Visualizza preventivi inviati',
    'view_unique_name'                                => 'Visualizza nome unico',
    'viewed'                                          => 'Visualizzato',
    'visible'                                         => 'Visibile',
    'visible_after_payment'                           => 'Visibile dopo il pagamento',
    'web'                                             => 'Web',
    'web_address'                                     => 'Indirizzo Web',
    'weekly'                                          => 'Settimanale',
    'weeks'                                           => 'Settimane',
    'welcome'                                         => 'Benvenuto',
    'what_to_import'                                  => 'Cosa vuoi importare?',
    'year'                                            => 'Anno',
    'yearly'                                          => 'Annuale',
    'years'                                           => 'Anni',
    'yes'                                             => 'sì',
    'you_may_now_sign_in'                             => 'Ora puoi accedere!',

    // 2017-1
    'all_company_profiles'                            => 'Tutti i profili aziendali',
    'cannot_delete_record_in_use'                     => 'Questo record è in uso e non puà essere cancellato.',
    'cannot_edit_record_in_use'                       => 'Questo record è in uso e non puà essere modificato.',
    'change_company_profile'                          => 'Cambia profilo aziendale',
    'company_profile'                                 => 'Profilo aziendali',
    'company_profiles'                                => 'Profili aziendali',
    'company_profile_form'                            => 'Modifica profilo aziendale',
    'copy'                                            => 'Copia',
    'create_recurring_invoice'                        => 'Crea fattura ricorrente',
    'custom'                                          => 'Personalizzato',
    'date_range'                                      => 'Intervallo date',
    'day_short_sunday'                                => 'Do',
    'day_short_monday'                                => 'Lu',
    'day_short_tuesday'                               => 'Ma',
    'day_short_wednesday'                             => 'Me',
    'day_short_thursday'                              => 'Gi',
    'day_short_friday'                                => 'Ve',
    'day_short_saturday'                              => 'Sa',
    'default_company_profile'                         => 'Profilo aziendale di default',
    'first_quarter'                                   => 'Primo trimestre',
    'fourth_quarter'                                  => 'Quarto trimestre',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Ultimi 7 giorni',
    'last_30_days'                                    => 'Ultimi 30 giorni',
    'last_month'                                      => 'Mese scorso',
    'last_quarter'                                    => 'Trimestre scorso',
    'last_year'                                       => 'Anno scorso',
    'month_january'                                   => 'Gennaio',
    'month_february'                                  => 'Febbraio',
    'month_march'                                     => 'Marzo',
    'month_april'                                     => 'Aprile',
    'month_may'                                       => 'Maggio',
    'month_june'                                      => 'Giugno',
    'month_july'                                      => 'Luglio',
    'month_august'                                    => 'Agosto',
    'month_september'                                 => 'Settembre',
    'month_october'                                   => 'Ottobre',
    'month_november'                                  => 'Novembre',
    'month_december'                                  => 'Dicembre',
    'recurring_invoice'                               => 'Fattura ricorrente',
    'second_quarter'                                  => 'Secondo trimestre',
    'stop_date'                                       => 'Data di fine',
    'third_quarter'                                   => 'Terzo trimestre',
    'this_month'                                      => 'Questo mese',
    'this_year'                                       => 'Quest\'anno',
    'today'                                           => 'Oggi',
    'user_account'                                    => 'Account utente',
    'yesterday'                                       => 'Ieri',

    // 2017-3
    'mail_log'                                        => 'Log mail',
    'recent_client_activity'                          => 'Attività recenti del cliente',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Escludi fatture non pagate',

    // 2017-7
    'please_wait'                                     => 'Attendere prego...',
    'reply_to_address'                                => 'Indirizzo di risposta',

    // 2017-8
    'admin'                                           => 'Admin',
    'admin_account'                                   => 'Account amministratore',
    'admin_accounts'                                  => 'Account amministratore',
    'all_accounts'                                    => 'Tutti gli account',
    'api_key'                                         => 'Chiave API',
    'client_account'                                  => 'Account cliente',
    'client_accounts'                                 => 'Account cliente',
    'client_id'                                       => 'Identificativo cliente',
    'client_secret'                                   => 'Segreto del cliente',
    'enable_bitcoin_payments'                         => 'Abilita pagamenti Bitcoin',
    'live'                                            => 'Vivere',
    'mode'                                            => 'Modalità',
    'publishable_key'                                 => 'Chiave pubblicabile',
    'sandbox'                                         => 'Sandbox',
    'secret_key'                                      => 'Chiave segreta',
    'type'                                            => 'genere',

    // 2017-10
    'deselect_all'                                    => 'Deselezionare tutto',
    'select_all'                                      => 'Seleziona tutto',
    'use_24_hour_time_format'                         => 'Usa formato ora 24 ore',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Sei sicuro di voler eliminare questi record?',
    'bulk_invoice_change_status_warning'              => 'Sei sicuro di voler cambiare lo stato delle fatture selezionate?',
    'bulk_quote_change_status_warning'                => 'Sei sicuro di voler cambiare lo stato dei preventivi selezionati?',
    'calculate_as_vat_gst'                            => 'Calcola come IVA / GST',
    'change_status'                                   => 'Cambiare stato',
    'default_status_filter'                           => 'Filtro di stato predefinito',
    'error_applying_payment'                          => 'Si è verificato un errore durante l\'applicazione di questo pagamento. Prova una carta o un metodo di pagamento diversi.',
    'remaining'                                       => 'Residuo',

    // 2017-12
    'invoice_date'                                    => 'Data fattura',
    'include_profit_based_on'                         => 'Includi profitto basato su',

    // 2018-1
    'add_contact'                                     => 'Aggiungi contatto',
    'allow_self_signed_cert'                          => 'Consenti certificato autofirmato',
    'backup'                                          => 'Backup',
    'close'                                           => 'Vicino',
    'change_invoice_date_to_todays_date'              => 'Cambia la data della fattura alla data odierna',
    'change_quote_date_to_todays_date'                => 'Cambia la data della citazione nella data odierna',
    'contacts'                                        => 'Contatti',
    'default_bcc'                                     => 'BCC predefinito',
    'default_cc'                                      => 'CC predefinito',
    'default_to'                                      => 'Predefinito a',
    'disable'                                         => 'disattivare',
    'download_database_backup'                        => 'Scarica Database Backup',
    'edit_contact'                                    => 'Modifica il contatto',
    'expense_list'                                    => 'Lista delle spese',
    'keep_invoice_date_as_is'                         => 'Mantieni la data della fattura così com\'è',
    'keep_quote_date_as_is'                           => 'Mantieni la data del preventivo così com\'è',
    'if_quote_is_emailed_while_draft'                 => 'Se il preventivo viene inviato via email mentre si è in stato di bozza',

    // 2018-4
    'force_https'                                     => 'Forza HTTPS',
    'force_https_help'                                => 'Prima di abilitare questa opzione, assicurati che l\'installazione di FusionInvoice sia funzionante tramite https. In caso contrario, l\'installazione potrebbe non essere funzionale (ma risolvibile).',

    // 2019-1
    'attached_to'                                     => 'Allegato a',
    'customer'                                        => 'Cliente',
    'expense'                                         => 'Spese',
    'expense_categories'                              => 'Categorie di spesa',
    'expense_category_form'                           => 'Modulo categoria di spesa',
    'expense_vendors'                                 => 'Fornitori di spese',
    'expense_vendor_form'                             => 'Modulo fornitore di spese',
    'lead'                                            => 'Piombo',
    'local_time'                                      => 'Ora locale',
    'prospect'                                        => 'Prospettiva',
    'search_clients'                                  => 'Cerca clienti',
    'search_expenses'                                 => 'Spese di ricerca',
    'search_invoices'                                 => 'Cerca fatture',
    'search_items'                                    => 'Cerca elementi',
    'search_log'                                      => 'Registro di ricerca',
    'search_quotes'                                   => 'Citazioni di ricerca',
    'search_payments'                                 => 'Cerca pagamenti',
    'search_recurring_invoices'                       => 'Cerca fatture ricorrenti',
    'show_all_statuses'                               => 'Mostra tutti gli stati',
    'show_all_types'                                  => 'Mostra tutti i tipi',
    'unknown'                                         => 'Sconosciuto',
    'value'                                           => 'Valore',

    // 2019-2
    'default'                                         => 'Predefinito',
    'no_data_available'                               => 'Nessun dato disponibile',
    'recurring_invoice_list'                          => 'Elenco fatture ricorrenti',
    'report_total'                                    => 'Report totali',

    //2019-3
    'checkbox'                                        => 'Casella di controllo',
    'custom_dropdown_validate'                        => 'Seleziona un\'opzione valida dal campo :label',
    'custom_image_validate'                           => 'Seleziona un\'immagine valida.',
    'custom_tag_validate'                             => 'Seleziona un tag valido da :label',
    'custom_text_validate'                            => 'Inserisci un :label valido nel campo :label.',
    'datetime'                                        => 'Appuntamento',
    'decimal'                                         => 'Decimale',
    'delete-confirm'                                  => 'Sei sicuro?',
    'grand_total'                                     => 'Somma totale',
    'image'                                           => 'Immagine',
    'integer'                                         => 'Numero intero',
    'mailed'                                          => 'Spedito',
    'mailed_invoices'                                 => 'Fatture spedite',
    'radio'                                           => 'Radio',
    'recurring_id'                                    => 'ID ricorrente',
    'remove_image'                                    => 'Rimuovi immagine',
    'tags'                                            => 'Tag',
    'tagselection'                                    => 'Selezione tag',
    'unpaid'                                          => 'Non pagato',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Visualizza fatture spedite',
    'important'                                       => 'Importante!',
    'created_recurring_invoice_id'                    => 'Creato da ID fattura ricorrente',
    'mr'                                              => 'Sig.',
    'miss'                                            => 'Perdere',
    'ms'                                              => 'SM.',
    'mrs'                                             => 'Sig.ra.',
    'dr'                                              => 'Dott.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Titolo del contatto',
    'title'                                           => 'Titolo',
    'test_email_subject'                              => 'Ciao da FusionInvoice',
    'test_email_body'                                 => 'Questa è un\'e-mail di prova da FusionInvoice.',
    'test_email_address'                              => 'Invia test e-mail a',
    'send_test_email'                                 => 'Invia email di prova',
    'invalid_json'                                    => 'Inserisci una stringa JSON valida',
    'textarea_rows_limit'                             => 'Le righe non possono superare :limit',
    'custom_integer_validate'                         => ':label deve essere un valore intero valido',

    //2020-1
    'user_role'                                       => 'Ruolo utente',
    'standard_user'                                   => 'Utente standard',
    'permissions'                                     => 'Autorizzazioni',
    'modules'                                         => 'Moduli',
    'is_view'                                         => 'Visualizza',
    'is_create'                                       => 'Creare',
    'is_update'                                       => 'Aggiornare',
    'is_delete'                                       => 'Elimina',
    'dashboards'                                      => 'Dashboard',
    'allow_time_period_change'                        => 'Consenti modifica del periodo di tempo',
    'page_not_found'                                  => 'Ops! Pagina non trovata.',
    'return_to_dashboard'                             => 'We could not find the page you were looking for. <a href =</a>.',
    'no_auth_to_create_client'                        => 'Non sei autorizzato a creare client!',
    'check-all'                                       => 'Seleziona tutto',
    'invoice_prefix'                                  => 'Prefisso fattura',
    'recently_viewed'                                 => 'visualizzato recentemente',
    'copy_from'                                       => 'Copia da',
    'select_user'                                     => 'Seleziona Utente',
    'please_select_user'                              => 'Seleziona un utente dall\'elenco',
    'allow_client_center_login'                       => 'Consenti accesso al Centro clienti',
    'online_payment_processing_fee'                   => 'Commissione per l\'elaborazione dei pagamenti online',
    'client_password_required'                        => 'Inserisci la password del cliente',
    'last_login_at'                                   => 'Ultimo accesso a',
    'show_notes_panel_below_client'                   => 'Mostra il pannello delle note sotto i dettagli del cliente',
    'notepad'                                         => 'Bloc notes',
    'added'                                           => 'Aggiunto',
    'last_edited'                                     => 'Ultima modifica',
    'loading'                                         => 'In lavorazione ....',
    'n_records_match'                                 => ':label Registra :plural corrispondenza',
    'initials'                                        => 'Iniziali',
    'initials_bg_color'                               => 'Colore di sfondo delle iniziali',
    'more'                                            => 'Di Più',
    'must_match_all'                                  => 'Deve corrispondere a tutti',
    'clear'                                           => 'Chiaro',
    'no_client_tags'                                  => 'Non sono presenti record client con tag definiti.',
    'qr_code_on_invoice_quote'                        => 'Codice QR su fattura e preventivo',
    'delete_tags'                                     => 'Pulizia tag',
    'orphan_tags_deleted'                             => 'Eliminati con successo tutti i tag orfani dal sistema.',
    'orphan_tags_delete_confirm'                      => 'L\'esecuzione della pulizia dei tag rimuoverà tutti i tag inutilizzati. Continua?',
    'deleting_tags_wait'                              => 'Eliminazione dei tag, attendere ...',
    'new-version-available'                           => 'Nuova versione disponibile!',
    'ignore-this-version'                             => 'Ignora questa versione',
    'view-release-notes'                              => 'Visualizza le note sulla versione',
    'task_list'                                       => 'Elenco delle attività',
    'create_task'                                     => 'Crea attività',
    'open'                                            => 'Aperto',
    'closed'                                          => 'Chiuso',
    'assignee'                                        => 'Assegnatario',
    'task'                                            => 'Compito',
    'task_successfully_created'                       => 'Attività creata con successo',
    'task_successfully_updated'                       => 'Attività aggiornata con successo',
    'task_completed'                                  => 'Attività completata con successo',
    'task_marked_incomplete'                          => 'Attività riaperta',
    'due_date_validation_date'                        => 'Seleziona una data di scadenza valida',
    'assignee_validation_required'                    => 'Seleziona un assegnatario valido dall\'elenco',
    'assignee_validation_exists'                      => 'Seleziona un assegnatario valido dall\'elenco',
    'tomorrow'                                        => 'Domani',
    'task_not_authorized'                             => 'Non sei autorizzato a modificare questa attività!',
    'me'                                              => 'Me',
    'task_from_note'                                  => 'Crea attività al salvataggio',
    'done'                                            => 'Fatto',
    'refresh'                                         => 'ricaricare',
    'task_list_page_size'                             => 'Numero di attività per pagina',
    'select_client'                                   => 'Seleziona cliente',
    'note-search-config'                              => 'Ricerca di note da includere',
    'username'                                        => 'Nome utente',
    'task-search-config'                              => 'Ricerca attività da includere',
    'task_section_invalid'                            => 'Sezione attività non valida',
    'task_section'                                    => 'Sezione attività',
    'select_section'                                  => 'Seleziona sezione',
    'email-test-failed'                               => 'Test e-mail non riuscito',
    'smtp-setting-suggestion'                         => 'Suggerimenti:<br>1. Verificare e reinserire i valori utente / password<br>2. Verify that your SMTP settings are entered correctly',
    'mail-setting-suggestion'                         => 'Suggerimenti:<br>1. Verificare che il server di posta PHP sia configurato correttamente<br>2. Contact server admin',
    'sendmail-setting-suggestion'                     => 'Suggerimenti:<br>1. Verifica che il tuo percorso Sendmail sia configurato correttamente.<br>2. Contact server admin',
    'sendgrid-setting-suggestion'                     => 'Suggerimenti:<br>1. Verifica che la tua chiave Sendgrid sia configurata correttamente.<br>2. Contact server admin',
    'later'                                           => 'Dopo',
    'test-email-required'                             => 'Devi inserire un indirizzo email valido',
    'test_mail_sent_successfully'                     => 'Posta di prova inviata con successo',
    'test-mail-btn-title'                             => 'È necessario salvare le modifiche prima del test.',
    'agreement_expire'                                => 'Gli aggiornamenti del prodotto e il supporto scadranno il :date',
    'agreement_expired'                               => 'Gli aggiornamenti del prodotto e il supporto sono scaduti il :date',
    'piracy_message'                                  => 'La tua chiave di licenza FusionInvoice non è valida. La pirateria del software è un crimine. Per favore, sii leale. Con una licenza valida riceverai supporto, aggiornamenti e un buon karma.',
    'buy-now'                                         => 'Acquista ora',
    'piracy_alert'                                    => 'Per favore sii giusto!',
    'agreement-expire-alert'                          => 'Aggiornamenti del prodotto e supporto in scadenza a breve.',
    'agreement-expired-alert'                         => 'Gli aggiornamenti del prodotto e il supporto sono scaduti.',
    'dismiss-forever'                                 => 'Ignora per sempre',
    'renew-now'                                       => 'Rinnova adesso',
    'select_all_permissions'                          => 'Seleziona tutte le autorizzazioni',
    'app-key-missing'                                 => 'Inserisci la tua chiave di licenza in config / app.php.',
    'custom_fields_column_width'                      => 'Colonne di visualizzazione dei campi personalizzati',
    'select-user-type'                                => 'Seleziona il tipo di utente',
    'lead-or-prospect-with-invoices-error'            => 'Spiacenti, il Tipo di cliente non può essere Lead o Prospect quando esistono fatture o fatture ricorrenti.',
    'sendgrid_key'                                    => 'Chiave Sendgrid',

    //2020-2.0
    'space'                                           => 'Spazio',
    'apostrophe'                                      => 'Apostrofo',
    'comma'                                           => 'Virgola',
    'fullstop'                                        => 'Punto (punto)',
    'middledot'                                       => 'Punto centrale',
    'thinspace'                                       => 'Spazio sottile',
    'narrow-no-break-space'                           => 'Spazio ristretto senza interruzioni',
    'dotabove'                                        => 'Punto sopra',
    'arabic-decimal'                                  => 'Separatore decimale arabo',
    'arabic-thousand'                                 => 'Separatore arabo mille',
    'decimal-separator-key-symbol'                    => 'Simbolo chiave separatore decimale',
    'select-item'                                     => 'Scegliere oggetto',
    'item-lookup-overload'                            => 'Massimo 100 elementi consentiti per la ricerca degli articoli',
    'select-expense-category'                         => 'Seleziona la categoria di spesa',
    'select-expense-vendor'                           => 'Seleziona fornitore di spese',
    'can-not-delete-all-users'                        => 'Spiacenti, non puoi eliminare tutti gli utenti dal sistema',
    'can-not-change-default-user-role'                => 'Spiacenti, non puoi modificare il ruolo utente predefinito',
    'can-not-change-default-user-status'              => 'Spiacenti, non puoi modificare lo stato utente predefinito',
    'user_not_active'                                 => 'L\'utente non è attivo',
    'can-not-inactive-your-own-status'                => 'Spiacenti, non puoi renderti inattivo.',
    'delete_user_warning'                             => '<p>FERMARE! L\'eliminazione di questo utente è un\'azione distruttiva che può rimuovere i record che hanno creato all\'interno del sistema. Considera invece di rendere l\'utente inattivo.</p><p>Sei sicuro di voler eliminare questo utente?</p>',
    'include_time_in_due_date'                        => 'Includi ora nella data di scadenza',
    'cannot_delete_default_company'                   => 'Non puoi eliminare il profilo aziendale predefinito',
    'make-user-inactive'                              => 'Rendi inattivo l\'utente',
    'mail_from_address'                               => 'Mail From Address',
    'mail_from_name'                                  => 'Posta da nome',
    'item_categories'                                 => 'Categorie di articoli',
    'select-item-category'                            => 'Seleziona Categoria articolo',
    'item_category_form'                              => 'Modulo categoria articolo',
    'sort_by_due'                                     => 'Ordina per data di scadenza',
    'affiliate'                                       => 'Affiliato',
    'parent_account'                                  => 'Conto genitore',
    'child_account'                                   => 'Account figlio',
    'select_parent_client'                            => 'Seleziona Account genitore',
    'record_successfully_retrieved'                   => 'Record recuperato con successo',
    'custom-image-not-support'                        => 'Campo immagine personalizzato non supportato',
    'custom-tag-not-support'                          => 'Campo tag personalizzato non supportato',
    'custom-checkbox-not-support'                     => 'Campo casella di controllo personalizzato non supportato',
    'custom-date-not-support'                         => 'Campo data personalizzato non supportato',
    'custom-datetime-not-support'                     => 'Campo datetime personalizzato non supportato',
    'timeline'                                        => 'Sequenza temporale',
    'client_invoice'                                  => 'Fatture per cliente',
    'select_client_blank_for_all'                     => 'Seleziona cliente (vuoto per tutti)',
    'invoice_email_success'                           => 'Email di fatturazione inviata con successo',
    'quote_email_success'                             => 'Email di preventivo inviata con successo',
    'document_number_schemes'                         => 'Numerazione dei documenti',
    'document_number_scheme'                          => 'Schema numero documento',
    'document_number_scheme_form'                     => 'Modulo numero documento schema',
    'default_document_number_scheme'                  => 'Schema numero documento predefinito',
    'supporting_data'                                 => 'Dati di supporto',
    'customizations'                                  => 'Personalizzazioni',
    'utilities_and_logs'                              => 'Utilità e registri',
    'system_log'                                      => 'Registro di sistema',
    'paid_amount'                                     => 'Importo pagato',
    'payment_amount'                                  => 'Importo del pagamento',
    'payment_intent'                                  => 'Intento di pagamento',
    'apply_payment_to_one_or_more_invoice'            => 'Applica il pagamento a una o più fatture',
    'pre_payment_for_future_invoices'                 => 'Pagamento anticipato per fatture future',
    'apply_to_invoices'                               => 'Applica a fattura / e',
    'payment_application'                             => 'Applicazione di pagamento',
    'remaining_payment_balance'                       => 'Saldo di pagamento rimanente',
    'remaining_balance'                               => 'Equilibrio restante',
    'payment_warning'                                 => 'Si prega di inserire l\'importo',
    'apply_pre_payment_warning'                       => 'Non hai applicato il pagamento a nessuna fattura. Vuoi registrarlo come pagamento anticipato?',
    'confirm_remaining_balance'                       => 'Il saldo residuo di :value sarà disponibile per essere applicato a fatture future per questo cliente.',
    'open_balance'                                    => 'Bilancio aperto',
    'more_figure_then_total_payment'                  => 'Reinserire il pagamento, il pagamento totale della fattura è maggiore del saldo residuo.',
    'remaining_payment_balance_apply_later_info'      => 'I saldi di pagamento rimanenti possono essere applicati ad altre fatture in un secondo momento.',
    'invoice_balance'                                 => 'Saldo fattura',
    'enter_payment_for_invoice'                       => 'Inserisci il pagamento per la fattura',
    'invoice_pdf'                                     => 'PDF fattura',
    'payment_applications'                            => 'Applicazioni di pagamento',
    'multiple'                                        => 'multiplo',
    'ok'                                              => 'Ok',
    'credit_memo_default'                             => 'Nota di credito predefinita',
    'edit_payment'                                    => 'Modifica pagamento',
    'credit_memo'                                     => 'Nota di credito',
    'credit_memos'                                    => 'Note di credito',
    'create_credit_memo'                              => 'Crea nota di credito',
    'credit_applications'                             => 'Applicazioni per note di credito',
    'credit_applications_for_invoice'                 => 'Richieste di note di credito per la fattura',
    'prepayment_applications_for_invoice'             => 'Richieste di pagamento anticipato per la fattura',
    'apply_credit_memo'                               => 'Applica nota di credito',
    'apply_pre_payment'                               => 'Applicare il pagamento anticipato',
    'applied_amount'                                  => 'Importo applicato',
    'remaining_credit_balance'                        => 'Saldo residuo del credito',
    'remaining_credit_balance_apply_later_info'       => 'I saldi di credito rimanenti possono essere applicati ad altre fatture in un secondo momento.',
    'applied'                                         => 'Applicato',
    'more_figure_then_invoice_amount'                 => 'Si prega di reinserire l\'importo, l\'importo non può essere maggiore dell\'importo della fattura.',
    'more_figure_then_invoice_total'                  => 'Reinserire l\'importo, l\'importo totale applicato non può essere maggiore dell\'importo della fattura.',
    'invoice_not_selected_warning'                    => 'Aspetta, non hai applicato la nota di credito a nessuna fattura.',
    'select_type'                                     => 'Seleziona il tipo',
    'email_credit_memo'                               => 'Nota di credito via e-mail',
    'back_to_credit_memo'                             => 'Torna alla nota di credito',
    'invoice_amount'                                  => 'Importo fattura',
    'remaining_invoice_amount'                        => 'Importo restante della fattura',
    'settlement_for_credit_memo'                      => 'Liquidazione per nota di credito',
    'credit_memo_amount'                              => 'Importo nota di credito',
    'confirm_remaining_balance_invoice'               => 'Il saldo rimanente per questa fattura sarà :value dopo il pagamento.',
    'payment_receipt_for_invoices'                    => 'Ricevuta di pagamento per fatture',
    'primary_phone'                                   => 'Numero telefonico primario',
    'alternate_phone'                                 => 'Numero di telefono alternativo',
    'currency_not_match'                              => 'La valuta non corrisponde',
    'tasks'                                           => 'Compiti',
    'full_and_final_payment'                          => 'pieno',
    'partial'                                         => 'parziale',
    'transition'                                      => [
        'created'          => 'Creato',
        'updated'          => 'Aggiornato',
        'deleted'          => 'Eliminato',
        'received'         => 'Ricevuto',
        'opened'           => 'Ha aperto',
        'sent'             => 'Inviato',
        'mail'             => 'Spedito',
        'changed'          => 'Cambiato',
        'recurring'        => 'Creato',
        'completed'        => 'Completato',
        'reversed'         => 'Invertito',
        'quote_to_invoice' => 'Preventivo su fattura',
        'download'         => 'Scaricamento',
        'added'            => 'Aggiunto',
        'email'            => 'E-mail',
        'merge'            => 'Unisci',
        'billed'           => 'Fatturato',
        'failed'           => 'Fallito',
        'invoice'          => [
            'created'                => 'La fattura :invoice_number è stata creata',
            'credit_memo_created'    => 'Credit Memo :credit_memo_number è stato creato',
            'credit_memo_updated'    => 'La nota di credito :credit_memo_number è stata modificata',
            'created_from_recurring' => 'La fattura :invoice_number è stata creata (dal modello ricorrente :recurring_invoice_id)',
            'updated'                => 'Fattura :invoice_number è stata modificata',
            'deleted'                => 'La fattura :invoice_number è stata eliminata',
            'credit_memo_deleted'    => 'La nota di credito :credit_memo_number è stata eliminata',
            'status_changed'         => 'Fattura :invoice_number Stato modificato da :previous_value a :current_value',
            'email_sent'             => 'E-mail Fattura :invoice_number inviata',
            'resend_email'           => 'L\'e-mail della fattura :invoice_number viene inviata di nuovo',
            'email_opened'           => 'E-mail Fattura :invoice_number aperta',
            'payment_updated'        => 'Fattura :invoice_number aggiornata :full_payment_text pagamento',
            'payment_received'       => 'Fattura :invoice_number ricevuto pagamento :full_payment_text',
            'payment_reversed'       => 'La fattura :invoice_number aveva un :full_payment_text',
            'invoice_tag_updated'    => 'Il tag fattura :tags è stato aggiunto alla fattura :invoice_number',
            'invoice_tag_deleted'    => 'Il tag della fattura :invoice_number è stato eliminato :tags',
            'mark_mail'              => 'Fattura :invoice_number segna come spedita',
            'unmark_mail'            => 'Fattura :invoice_number mask come non inviata',
            'paid_invoice_opened'    => 'La fattura pagata è stata aperta per la modifica',
            'sent_invoice_opened'    => 'La fattura inviata è stata aperta per la modifica',
            'sms_sent'               => 'Fattura :invoice_number SMS inviato',
        ],
        'quote'            => [
            'created'           => 'Quota :quote_number è stato creato',
            'updated'           => 'Quota :quote_number è stata modificata',
            'deleted'           => 'Quota :quote_number è stata eliminata',
            'status_changed'    => 'Quota :quote_number Lo stato è cambiato da :previous_value a :current_value',
            'email_sent'        => 'Quota :quote_number e-mail inviata',
            'resend_email'      => 'Citazione :quote_number email inviata di nuovo',
            'email_opened'      => 'Quota :quote_number e-mail aperta',
            'quote_to_invoice'  => ':quote_number è stato convertito in una fattura - :invoice_number',
            'quote_tag_updated' => 'Il tag citazione :tags è stato aggiunto alla citazione :quote_number',
            'quote_tag_deleted' => 'Il tag preventivo :quote_number è stato eliminato :tags',
            'sms_sent'          => 'Citazione :quote_number SMS inviato',
        ],
        'payment'          => [
            'prepayment_created'           => 'È stato creato il pagamento anticipato',
            'payment_receipt_email_sent'   => 'Email ricevuta di pagamento inviata',
            'payment_receipt_resend_email' => 'Inviare nuovamente l\'e-mail di ricevuta del pagamento',
            'payment_updated'              => 'Il pagamento è stato modificato',
            'deleted'                      => 'Il pagamento è stato cancellato',
            'payment_receipt_pdf_download' => 'Scarica il PDF della ricevuta di pagamento',
            'payment_note_deleted'         => 'Nota di pagamento eliminata:',
            'payment_note_added'           => 'Nota di pagamento aggiunta:',
            'payment_note_updated'         => 'Nota di pagamento aggiornata da',
            'payment_failed'               => 'Pagamento fallito',
        ],
        'client'           => [
            'client_created'     => ':client_type è stato creato',
            'type_changed'       => ':previous_value è diventato un :current_value',
            'updated'            => 'Il client è stato aggiornato',
            'deleted'            => 'Il cliente è stato eliminato',
            'status_changed'     => 'Client impostato su :current_value',
            'client_tag_updated' => 'Tag :tags aggiunto',
            'client_tag_deleted' => 'Tag :tags eliminato',
            'merge'              => 'L\'ID cliente: :idTo - :nameTo è stato unito all\'ID cliente: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'La spesa è stata creata',
            'updated' => 'La spesa è stata modificata',
            'deleted' => 'La spesa è stata eliminata',
            'billed'  => 'La spesa è stata fatturata',
            'vendor'  => [
                'created' => 'Il fornitore di spese è stato creato',
                'updated' => 'Fornitore di spese è stato modificato',
                'deleted' => 'Il fornitore di spese è stato eliminato',
            ],
        ],
        'note'             => [
            'created'          => 'La nota è stata creata',
            'updated'          => 'La nota è stata modificata',
            'deleted'          => 'La nota è stata eliminata',
            'note_tag_updated' => 'Tag :tags aggiunto alla nota',
            'note_tag_deleted' => 'Tag :tags eliminato dalla nota',
        ],
        'task'             => [
            'created'   => 'L\'attività è stata creata',
            'updated'   => 'L\'attività è stata modificata',
            'deleted'   => 'L\'attività è stata eliminata',
            'completed' => 'L\'attività è stata completata',
        ],
        'subscription'     => [
            'created'                       => 'L\'abbonamento :invoice_number è stato creato',
            'updated'                       => 'L\'abbonamento :invoice_number è stato modificato',
            'deleted'                       => 'L\'abbonamento :invoice_number è stato eliminato',
            'recurring_invoice_tag_updated' => 'Il tag di abbonamento :tags è stato aggiunto all\'abbonamento :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'Il tag di abbonamento :recurringInvoice_number è stato eliminato :tags',
        ],
        'attachment'       => [
            'created' => ':filename è stato caricato come allegato',
            'deleted' => ':filename è stato rimosso come allegato',
        ],
        'tag'              => [
            'created' => 'È stato aggiunto il tag :tag',
            'deleted' => 'Il tag :tag è stato rimosso da',
        ],
    ],
    'reset'                                           => 'Ripristina',
    'select_event'                                    => 'Seleziona il tipo di evento',
    'select_country'                                  => 'Seleziona un Paese',
    'type_captcha'                                    => 'Rispondi alla domanda precedente',
    'refresh_captcha'                                 => 'Aggiorna la domanda',
    'answer'                                          => 'Risposta',
    'use_captcha_in_login'                            => 'Usa captcha nel login',
    'allow_client_timeline'                           => 'Sequenza temporale',
    'client_timeline'                                 => 'Sequenza temporale',
    'no_invoice_tags'                                 => 'Non sono presenti tag di fattura.',
    'total_notifications'                             => 'Hai notifiche :total',
    'no_notifications'                                => 'Nessuna nuova notifica',
    'notifications'                                   => 'Notifiche',
    'notification'                                    => [
        'task'  => [
            'created'           => 'Un nuovo compito assegnato a te',
            'due_date_breached' => 'L\'obiettivo',
            'completed'         => ':user compito completato:',
        ],
        'quote' => [
            'approved'             => ':quote_number è stato approvato',
            'quote_to_invoice'     => ':quote_number è stato convertito in una fattura -',
            'rejected'             => ':quote_number è stato rifiutato',
            'payment_successfully' => 'Il preventivo :quote_number per il cliente :client_name è stato pagato. La fattura :invoice_number è stata creata e il pagamento è stato applicato',
        ],
    ],
    'search_tasks'                                    => 'Attività di ricerca',
    'reopen_task'                                     => 'Riapri attività',
    'task_form'                                       => 'Aggiungi attività',
    'view_task'                                       => 'Dettagli attività',
    'client_deleted'                                  => 'Il client viene eliminato',
    'payment_canceled'                                => 'Il tuo pagamento è stato annullato',
    'default_company_profile_set'                     => 'Abbiamo impostato il tuo profilo aziendale predefinito. Puoi aggiornarlo in qualsiasi momento dalle impostazioni del profilo aziendale.',
    'file_uploaded_successfully'                      => 'il file è stato caricato con successo',
    'attachment_notice'                               => 'Dimensione massima del file allegato inferiore o uguale a :size',
    'attachment_error'                                => 'La dimensione dell\'allegato non può superare :size',
    'attachment_warning'                              => 'La dimensione degli allegati è :size. Il caricamento di molti allegati di grandi dimensioni può ridurre le prestazioni del database nel tempo.',
    'generate_timeline_history'                       => 'Genera cronologia della sequenza temporale',
    'generating_timeline_wait'                        => 'Generazione della sequenza temporale, attendere ...',
    'generating_timeline_confirm'                     => 'La funzione della sequenza temporale è stata aggiunta in FusionInvoice 2020. Ciò genererà voci della sequenza temporale per tutte le attività che hanno preceduto l\'aggiunta della funzione. Continua?',
    'generated_timeline_request_accepted'             => 'La generazione della cronologia della sequenza temporale è completa.',
    'transitions'                                     => 'Cronologia della sequenza temporale',
    'pending'                                         => 'in attesa di',
    'client_transition'                               => 'Tempistiche del cliente',
    'expense_transition'                              => 'Tempistiche di spesa',
    'invoice_transition'                              => 'Tempistiche delle fatture',
    'payment_invoice_transition'                      => 'Tempistiche delle fatture di pagamento',
    'payment_transition'                              => 'Tempistiche di pagamento',
    'quote_transition'                                => 'Cronologia delle quotazioni',
    'note_transition'                                 => 'Nota le linee temporali',
    'task_transition'                                 => 'Tempistiche delle attività',
    'email_sent'                                      => 'Email inviata',
    'credit_applied'                                  => 'Credito applicato',
    'configuration'                                   => 'Configurazione',
    'include_prepayments'                             => 'Includi pagamenti anticipati',
    'pre_payment'                                     => 'Pagamenti anticipati',
    'pre_payments'                                    => 'Pagamenti anticipati',
    'times'                                           => 'Volte',
    'include_prepayments_applied'                     => 'Includi pagamenti anticipati applicati',
    'confirm_full_payment_applied'                    => 'Il pagamento è stato applicato integralmente',
    'confirm_full_credit_memo_applied'                => 'La nota di credito è stata applicata integralmente',
    'all_tasks'                                       => 'Tutte le attività',
    'my_tasks'                                        => 'I miei compiti',
    'assigned_from_others'                            => 'Assegnato da Altri',
    'full_payment_reversed'                           => 'pagamento completo annullato.',
    'partial_payment_reversed'                        => 'pagamento parziale annullato.',
    'invoice_delete_error'                            => 'Spiacenti, non è possibile eliminare una fattura con applicazioni per pagamenti o note di credito. È necessario prima eliminare i pagamenti o le applicazioni delle note di credito.',
    'mail-from-required'                              => 'È necessario inserire una Mail From Email valida',
    'contact_updated'                                 => 'Contatto aggiornato con successo',
    'contact_added'                                   => 'Contatto aggiunto con successo',
    'generate_passport_key_wait'                      => 'Generazione della chiave del passaporto, attendere prego ...',
    'generate_passport_key'                           => 'Genera passport Key',
    'default_greeting'                                => 'Ciao!<br>',
    'hi'                                              => 'Ciao,',
    'deduct_tax_from_expenses'                        => 'Detrarre l\'imposta dalle spese',
    'invalid_invoice_id'                              => 'ID fattura non valido',
    'client_related_record_exist'                     => 'Spiacenti, il client ha record correlati per:: moduli. I clienti con cronologia delle transazioni non possono essere eliminati.',
    'email_payment_receipt_notice'                    => 'Il client non ha un indirizzo e-mail in archivio',
    'show_more'                                       => 'Mostra di più ...',
    'show_less'                                       => 'Mostra meno ...',
    'invoice_already_paid'                            => 'La fattura è già stata pagata!',
    'system_default'                                  => 'Default del sistema',
    'created_by'                                      => 'Creato da',
    'created_at'                                      => 'Creato a',
    'task_created_by_and_created_at'                  => 'Attività creata da :created_by su :created_at',
    'dashboard_widgets_date_options'                  => 'Periodo di tempo predefinito del sistema per fattura e riepilogo preventivo',
    'dashboard-widget-from-date-required'             => 'La data di inizio è richiesta quando è selezionato un intervallo di date personalizzato in Periodo di tempo predefinito del sistema per fattura e riepilogo preventivo',
    'dashboard-widget-to-date-required'               => 'Fino ad oggi è richiesto quando è selezionato un intervallo di date personalizzato in Periodo di tempo predefinito del sistema per fattura e riepilogo preventivo',
    'invoice_currency'                                => 'Valuta della fattura',
    'currency_format'                                 => 'Formato valuta',
    'create_missing_folder_success'                   => 'Cartella richiesta mancante creata',
    'create_missing_folder_failed'                    => 'Tentativo di creare cartelle non riuscito :path',
    'folder_is_not_writable'                          => 'La cartella non è scrivibile :path',
    'update_item_as_lookup'                           => 'Aggiorna ricerca articolo item',
    'number_of_tax_fields'                            => 'Numero di campi fiscali',
    'tax_1_entry'                                     => '1 ingresso',
    'tax_2_entries'                                   => '2 voci',
    'require_tags_on_client_notes'                    => 'Richiedi tag nelle note del cliente',
    'entered_amount_less_than_invoice_amount'         => 'L\'importo inserito deve essere inferiore o uguale all\'importo della fattura',
    'send-to'                                         => 'Inviare a',
    'print'                                           => 'Stampa',
    'pdf_cleanup'                                     => 'Pulizia PDF',
    'pdf_cleanup_confirm'                             => 'Sei sicuro di voler ripulire i vecchi file PDF?',
    'pdf_cleanup_success'                             => 'Pulizia PDF completata',
    'deleting_pdf_wait'                               => 'Eliminazione dei vecchi file PDF, attendere...',
    'open_invoices'                                   => 'Fatture aperte',
    'open_credits'                                    => 'Apri crediti Open',
    'unapplied_payments'                              => 'Pagamenti non applicati',
    'attach_invoice_pdf'                              => 'Allega il PDF della fattura',
    'upcoming_payment_notice'                         => 'Avviso di pagamento imminente',
    'select_mapping'                                  => 'Seleziona Mappatura',
    'select_named_export'                             => 'Seleziona Esporta con nome',
    'save_mapping'                                    => 'Salva mappatura',
    'add_mapping'                                     => 'Crea nuova mappatura',
    'edit_mapping'                                    => 'Aggiorna mappatura',
    'save_as_default_mapping'                         => 'Mappatura predefinita',
    'save_as_default_export'                          => 'Esportazione predefinita',
    'export_item_lookups'                             => 'Esporta ricerche di elementi',
    'import_file_selection'                           => 'Importa selezione file',
    'next'                                            => 'Prossimo',
    'delete_import_mapping_warning'                   => 'Sei sicuro di voler eliminare questa mappatura?',
    'export'                                          => 'Esportare',
    'named_exports'                                   => 'Esportazioni nominate',
    'save_named_export'                               => 'Salva esportazione con nome',
    'delete_named_export'                             => 'Elimina esportazione con nome',
    'updated_at'                                      => 'Aggiornato alle',
    'zip'                                             => 'Cerniera lampo',
    'fields_to_export'                                => 'Campi da esportare',
    'import-file-type-error'                          => 'Il tipo di file di importazione deve essere CSV',
    'recurring_invoice_items'                         => 'Voci ricorrenti della fattura',
    'important_details'                               => 'Dettagli importanti',
    'important_information'                           => 'Informazioni importanti',
    'item_lookups_important_information'              => '<p>Se viene trovato un nome di ricerca dell\'elemento corrispondente nei dati esistenti durante l\'importazione CSV, il batch di importazione avrà esito negativo, mostrando l\'elemento che ha causato l\'errore.</p>',
    'invoices_important_information'                  => '<p>Il nome del client (dal CSV) viene cercato nella tabella Client e risolto in client_id, se esiste un nome corrispondente. Se non viene trovata alcuna corrispondenza di nome, crea una voce client e utilizza l\'ID della nuova voce client</p><p>Numero di fattura,</p><p>Invoice_items esegue una ricerca sul numero di fattura (dal CSV) nella tabella delle fatture e lo risolve nell\'ID. Non vengono eseguite altre ricerche/convalide di campi chiave</p>',
    'invoice_items_important_information'             => '<p>L\'importazione di fattura_articoli esegue una ricerca sul numero di fattura (dal CSV) nella tabella delle fatture e lo risolve nell\'ID fattura appropriato. L\'ID cliente è derivato anche dalle informazioni di fatturazione corrispondenti.</p>',
    'payments_important_information'                  => '<p>L\'importazione dei pagamenti richiede un numero di fattura corrispondente valido a cui applicare i pagamenti. Se non viene trovata una fattura corrispondente, l\'importazione dell\'intero batch avrà esito negativo.</p><p>I clienti appropriati-</p><p>Viene eseguita una ricerca sul nome del metodo di pagamento (dal CSV alla tabella payment_methods) e si risolverà nell\'appropriato payment_method_id, se trovato. se non viene trovato un nome corrispondente, verrà creato un nuovo record del metodo di pagamento e verrà utilizzato il nuovo payment_method_id.</p>',
    'run_daily_tasks'                                 => 'Esegui attività quotidiane',
    'daily_task_ran'                                  => 'Le attività quotidiane sono state eseguite con successo',
    'csv_row_number'                                  => 'CSV Numero riga :row',
    'max_item_lookup_records'                         => 'massimo Record di ricerca articolo',
    'invoice_with_commission_delete_error'            => 'Spiacenti, non è possibile eliminare una fattura con voci di commissione con stato pagato. Devi prima eliminare la commissione pagata su questa fattura.',
    'if_invoice_is_emailed_while_draft'               => 'Se la fattura viene inviata via e-mail mentre si trova nello stato di bozza',
    'custom_payment_receipt_body_not_exists'          => 'Il modello personalizzato per le ricevute di pagamento non è stato trovato.',
    'invoice_email_body_type'                         => 'Tipo di corpo dell\'e-mail della fattura',
    'send_overdue_reminder'                           => 'Invia sollecito scaduto',
    'reminder_sent_successfully'                      => 'Promemoria inviato con successo',
    'error_sending_reminder'                          => 'Si è verificato un errore durante l\'invio del promemoria, riprova più tardi.',
    'expense_date'                                    => 'Data di spesa',
    'group_by'                                        => 'Raggruppare per',
    'timeline_scope_all_user'                         => 'Ambito sequenza temporale - Tutti gli utenti',
    'copy_to_clipboard'                               => 'Copia negli appunti',
    'text_copied_clipboard'                           => 'Testo copiato negli appunti!',
    'import_example_csv'                              => 'Un file CSV di esempio può essere trovato qui',
    'import'                                          => 'Importare',
    'address2'                                        => 'Indirizzo 2',
    'use_parent_email'                                => 'Usa l\'e-mail del genitore',
    'max_import_records'                              => 'Il limite massimo per importare i record è :total_records',
    'demo_file_attachment_disabled'                   => 'Gli allegati file sono disabilitati nella demo',
    'drag_drop_file'                                  => 'Lagna',
    'or'                                              => 'O',
    'browse_file'                                     => 'Sfoglia file',
    'system_setting_and_ui'                           => 'Impostazioni di sistema',
    'localization_and_timezone'                       => 'Localizzazione',
    'security'                                        => 'Sicurezza',
    'cleanup_and_backup'                              => 'Pulire',
    'attach_quote_pdf'                                => 'Allega Preventivo PDF',
    'attach_payment_receipt'                          => 'Allega ricevuta di pagamento',
    'choose-file'                                     => 'Scegli il file',
    'important-note'                                  => 'Nota importante',
    'collapse'                                        => 'Crollo',
    'add_task'                                        => 'Aggiungi attività',
    'recurring_invoice_commissions'                   => 'Commissioni su fatture ricorrenti',
    'invoice_commissions'                             => 'Commissioni fattura',
    'percentage'                                      => 'Percentuale',
    'flat_amount'                                     => 'Importo forfettario',
    'discount-amount'                                 => 'Sconto',
    'discount-type'                                   => 'Tipo di sconto',
    'saving'                                          => 'Salvataggio...',
    'preparing'                                       => 'Preparazione',
    'allow_line_item_discounts'                       => 'Consenti sconti sugli articoli',
    'invalid_price_amount'                            => 'Importo prezzo non valido! Deve essere maggiore di 0.',
    'light-mode'                                      => 'Modalità luce',
    'dark-mode'                                       => 'Modalità scura',
    'system_base_currency'                            => 'Valuta di base del sistema',
    'is_recurring_task'                               => 'È un\'attività ricorrente',
    'contact_names'                                   => 'Nomi di contatto',
    'all_client'                                      => 'Tutti i clienti',
    'invoice_grand_total'                             => 'Totale generale fattura',
    'recurring_invoice_grand_total'                   => 'Totale complessivo fatture ricorrenti',
    'is_required'                                     => 'È obbligatorio?',
    'add-new-client'                                  => 'Aggiungi nuovo cliente',
    'client_name_required'                            => 'Il nome del cliente è obbligatorio',
    'custom_item_text_validate'                       => 'Inserisci un elemento valido :label nel campo :label.',
    'assigned_to_others'                              => 'Assegnato ad altri',
    'all_tasks_and_all_users'                         => 'Tutte le attività/Tutti gli utenti',
    'statement'                                       => 'Dichiarazione',
    'profile_code'                                    => 'Codice profilo',
    'login-url'                                       => 'URL di accesso',
    'url_copied_clipboard'                            => 'URL copiato negli appunti!',
    'payment_receipt_email_sent'                      => 'Email di ricevuta del pagamento inviata con successo',
    'edit_payment_note_form'                          => 'Modifica nota di pagamento',
    'payment_invoices_text'                           => 'Grazie! Il tuo pagamento di :amount è stato applicato alle seguenti fatture.',
    'payment_text'                                    => 'Grazie per il pagamento di :amount .',
    'date_filter_by'                                  => 'Data Filtra per',
    'filter_by_invoice_date'                          => 'Data fattura',
    'filter_by_payment_date'                          => 'Data di pagamento',
    'date-range-required'                             => 'Seleziona Intervallo di date',
    'save-and-complete'                               => 'Salva e completa',
    'completion-note'                                 => 'Nota di completamento',
    'complete-with-note'                              => 'Completo di Nota',
    'placeholder_type_note'                           => 'Scrivi le tue note...',
    'credit_memo_email_subject'                       => 'Oggetto dell\'e-mail della nota di credito',
    'default_credit_memo_email_body'                  => 'Corpo dell\'e-mail della nota di credito predefinita',
    'show_invoices_from'                              => 'Mostra fatture da',
    'system_mail_from_address'                        => 'Posta di sistema da indirizzo',
    'user_who_created_invoice'                        => 'Utente che ha creato la fattura',
    'completed'                                       => 'Completato',
    'no_auth_to_view_task'                            => 'Questa attività non è più nel tuo elenco.',
    'credit-memo-and-prepayments'                     => 'Crediti e pagamenti anticipati',
    'all_selected'                                    => 'Tutto selezionato',
    'select_columns'                                  => 'Seleziona Colonne',
    'column_settings'                                 => 'Impostazioni colonna',
    'minimum_one_column_check_is_required'            => 'Seleziona almeno una colonna',
    'date_of_entry'                                   => 'Data di ingresso',
    'amount_applied'                                  => 'Importo applicato',
    'date_applied'                                    => 'Data di applicazione',
    'copy_to_recurring_invoice'                       => 'Copia in fattura ricorrente',
    'top_bar_color'                                   => 'Colore della barra superiore',
    'light_grey'                                      => 'Grigio chiaro',
    'bg-primary'                                      => 'Blu',
    'bg-warning'                                      => 'Giallo',
    'bg-info'                                         => 'Libellula Blu',
    'bg-danger'                                       => 'Rosso',
    'bg-success'                                      => 'Verde tappeto erboso',
    'bg-indigo'                                       => 'Indaco',
    'bg-lightblue'                                    => 'Blu Vittoria',
    'bg-navy'                                         => 'Blu navy',
    'bg-purple'                                       => 'Porpora',
    'bg-fuchsia'                                      => 'Fucsia',
    'bg-pink'                                         => 'Rosa',
    'bg-maroon'                                       => 'Marrone',
    'bg-orange'                                       => 'Arancia',
    'bg-lime'                                         => 'Verde lime',
    'bg-teal'                                         => 'Verde acqua',
    'bg-olive'                                        => 'Oliva',
    'fee_name'                                        => 'Nome quota',
    'fee_percentage'                                  => 'Percentuale della commissione',
    'fee_explanation'                                 => 'Spiegazione della tariffa',
    'enable_online_payment_processing_fees'           => 'Abilita le commissioni per l\'elaborazione dei pagamenti online',
    'allow_online_payment_processing_fees'            => 'Consenti commissioni per l\'elaborazione dei pagamenti online',
    'allow_online_pay_fees'                           => 'Consenti commissioni di pagamento online',
    'convenience_charges'                             => 'Spese di convenienza',
    'opp-fee-percentage-required'                     => 'La percentuale delle commissioni per l\'elaborazione dei pagamenti online è obbligatoria',
    'opp-fee-percentage-gt-zero'                      => 'La percentuale delle commissioni per l\'elaborazione dei pagamenti online deve essere maggiore di zero',
    'cron_error'                                      => 'fallito su :datetime',
    'cron_start'                                      => 'L\'attività quotidiana è iniziata da :datetime',
    'notification_clear_all'                          => 'Cancella tutte le notifiche',
    'show'                                            => 'Spettacolo',
    'report'                                          => 'Rapporto',
    'profit_loss'                                     => 'Profitti e perdite',
    'credit_and_pre_payments'                         => 'Crediti e pagamenti anticipati',
    'expenses_vendors'                                => 'Spese fornitori',
    'expenses_categories'                             => 'Categorie di spese',
    'create'                                          => 'Creare',
    'import_map_clients'                              => 'Importa client mappa',
    'payctr_users'                                    => 'Utenti di PaymentCenter',
    'ctrl_plus_click'                                 => 'Ctrl-clic per aggiungere note di completamento',
    'edit_note'                                       => 'Modifica nota',
    'save-and-unComplete'                             => 'Salva e non completa',
    'sales_chart'                                     => 'Grafico delle vendite',
    'accumulate_totals'                               => 'Accumula totali',
    'do_not_accumulate_totals'                        => 'Non accumulare totali',
    'kpi_cards'                                       => 'Schede KPI',
    'no_data_to_display'                              => 'Nessun dato da visualizzare',
    'choose_period'                                   => 'Scegli Periodo',
    'date_mailed'                                     => 'Data di spedizione',
    'date_emailed'                                    => 'Data di invio tramite e-mail',
    'action'                                          => 'Azione',
    'mail'                                            => 'Posta',
    'mark_as_mailed'                                  => 'Segna come spedito',
    'invoice_mailed'                                  => 'La fattura è stata contrassegnata come Spedita',
    'emailed'                                         => 'Inviato per email',
    'paid_invoice_canceled_error'                     => 'Per annullare questa fattura, eliminare i pagamenti dalla fattura.',
    'allow_invoice_delete'                            => 'Consenti eliminazione fattura',
    'allow_child_accounts'                            => 'Consenti account figlio',
    'third_party_bill_payer'                          => 'Pagatore di fatture di terze parti',
    'invoices_paid_by'                                => 'Fatture pagate da',
    'use_third_party_bill_payer_email'                => 'Utilizzare l\'e-mail del pagatore di fatture di terze parti',
    'email_default'                                   => 'E-mail predefinita',
    'client_default'                                  => 'Valore predefinito del cliente',
    'clear-all'                                       => 'Cancella tutto',
    'system_log_is_missing_or_empty'                  => 'Il registro di sistema è mancante o vuoto',
    'change_to_draft'                                 => 'Passare a Bozza',
    'invoice_status_change_to_draft'                  => 'Modifica dello stato della fattura in Bozza',
    'there_is_some_error'                             => 'Ci sono alcuni errori',
    'filter_by_date'                                  => 'Filtra per data',
    'quote_grand_total'                               => 'Quota Totale complessivo',
    'email_upcoming_payment_due_notice'               => 'Avviso di pagamento imminente via e-mail',
    'email_overdue_invoice_reminder'                  => 'Email promemoria fatture scadute',
    'page_totals'                                     => 'Totali pagina',
    'categories'                                      => 'Categorie',
    'conven_charges'                                  => 'Conv. Spese',
    'invoice_status_change_to_cancel'                 => 'Modifica dello stato della fattura in Annulla',
    'filter_by_invoice_number'                        => 'Numero di fattura',
    'filter_by_client_name'                           => 'nome del cliente',
    'custom_mail_template'                            => 'Modello di posta personalizzato',
    'invoice_use_custom_mail_template'                => 'Fattura Usa modello di posta personalizzato',
    'client_or_company_name'                          => 'Nome cliente/azienda',
    'view_invoice'                                    => 'Visualizza Fattura',
    'tt_active'                                       => 'Quando un record cliente non è attivo, non verrà visualizzato nell\'elenco clienti predefinito e le normali transazioni non saranno consentite.',
    'tt_invoice_prefix'                               => 'Un codice di prefisso fattura univoco viene assegnato automaticamente a un record cliente quando viene creato. Può essere modificato manualmente in seguito. Può essere utilizzato come parte dello schema di numerazione dei documenti per la numerazione delle fatture, consentendo un numero di fattura univoco per cliente.',
    'tt_automatic_email_payment_receipts'             => 'Invia una ricevuta di pagamento via e-mail al cliente dopo aver ricevuto un pagamento. Un\'impostazione globale è disponibile in Impostazioni di sistema, ma può essere sovrascritta su base client individuale.',
    'tt_automatic_email_on_recur'                     => 'Invia una fattura via e-mail al cliente quando viene eseguita una fattura ricorrente e crea una fattura in tempo reale. Un\'impostazione globale è disponibile in Impostazioni di sistema, ma può essere sovrascritta su base client individuale.',
    'tt_default_currency'                             => 'La valuta assegnata a questo conto cliente, che verrà utilizzata per le transazioni di fattura, preventivo e pagamento. Questo valore è predefinito dall\'impostazione di sistema per la valuta di base.',
    'tt_language'                                     => 'La lingua che verrà visualizzata per il cliente quando accede al centro clienti.',
    'tt_allow_client_center_login'                    => 'Il cliente dovrebbe essere autorizzato ad accedere al centro clienti di FusionInvoice? La loro email deve essere utilizzata per il loro nome utente e devi assegnare una password. L\'URL del centro clienti è',
    'tt_timezone'                                     => 'Fuso orario per il cliente. Se inserita, l\'ora locale del cliente verrà visualizzata nella parte superiore della visualizzazione della pagina Cliente.',
    'tt_allow_online_payment_processing_fees'         => 'Le commissioni per l\'elaborazione dei pagamenti online possono essere calcolate per i clienti che pagano con carta di credito, utilizzando il collegamento alla fattura pubblica (incluso nell\'e-mail della fattura). Questa opzione ha un\'impostazione di sistema globale, ma può anche essere sovrascritta su base client individuale.',
    'tt_allow_child_accounts'                         => 'L\'impostazione Consenti account figlio su Sì consente a questo client di agire come account padre e ti consentirà di selezionarlo dall\'elenco Account padre.',
    'tt_third_party_bill_payer'                       => 'Un pagatore di fatture di terze parti è un\'organizzazione che paga le fatture per i propri clienti, ad esempio una società di contabilità esterna.',
    'tt_parent_account'                               => 'L\'azienda madre a cui questo cliente è correlato o di cui è una consociata. Questo elenco contiene i record dei clienti che hanno l\'impostazione Consenti account figlio impostata su Sì. Lasciare vuoto se il cliente non ha un account padre.',
    'tt_invoices_paid_by'                             => 'L\'attività di terzi che questo cliente utilizza per pagare le fatture. Questo elenco contiene i record dei clienti che hanno l\'impostazione Pagatore di fatture di terze parti impostata su Sì. Lascia vuoto se il cliente paga le proprie fatture.',
    'tt_email_default'                                => 'Quando si inviano e-mail a questo client, selezionare l\'e-mail da utilizzare. Se questo cliente ha un conto padre associato o un conto con fatture pagate da, è possibile selezionare una di queste opzioni. L\'impostazione predefinita è l\'e-mail client standard.',
    'tt_default_to'                                   => 'Durante l\'invio di e-mail, questo contatto dovrebbe essere aggiunto automaticamente all\'elenco dei destinatari',
    'tt_default_cc'                                   => 'Durante l\'invio di e-mail, questo contatto dovrebbe essere aggiunto automaticamente all\'elenco dei destinatari',
    'tt_default_bcc'                                  => 'Durante l\'invio di e-mail, questo contatto dovrebbe essere aggiunto automaticamente all\'elenco dei destinatari',
    'tt_client_type'                                  => 'Un lead è un candidato alle vendite non qualificato. Un Prospect è un candidato qualificato che potrebbe presto diventare un cliente. Un Cliente è un\'azienda o un individuo a cui hai venduto (o presto venderai) beni o servizi. Un affiliato è un\'azienda o un individuo che rivende i tuoi beni o servizi. Altro viene utilizzato per attività che non si adattano agli altri tipi, ad esempio pagamenti di fatture di terze parti o conti genitori con i quali non si intrattengono rapporti commerciali diretti.',
    'tt_client_tags'                                  => 'I tag possono essere assegnati a un cliente per aiutare a classificare o filtrare l\'elenco dei clienti per la visualizzazione o la segnalazione.',
    'tt_important_note'                               => 'Una nota inserita qui apparirà automaticamente all\'interno di un messaggio IMPORTANTE! finestra quando viene visualizzato il record del cliente.',
    'tt_gen_header_title_text'                        => 'Il testo visualizzato nell\'angolo in alto a sinistra, accanto al tuo logo, di solito il nome della tua azienda.',
    'tt_gen_default_company_profile'                  => 'Il profilo aziendale da utilizzare per impostazione predefinita durante la creazione di nuove fatture, preventivi, ecc. I profili aziendali ti consentono di presentare la tua attività in modo diverso con ogni profilo, consentendo diversi nomi di società, loghi, formati di fattura, ecc.',
    'tt_gen_address_format'                           => 'Consente di creare il formato dell\'indirizzo mostrato su fatture e preventivi utilizzando il campo dell\'indirizzo singolo o una combinazione dei campi dell\'indirizzo singolo, come città, stato, paese, ecc.',
    'tt_gen_custom_fields_columns'                    => 'I campi personalizzati possono essere visualizzati da 1 a 3 campi per riga.',
    'tt_gen_require_tags_on_client_notes'             => 'Se impostato su Sì, sarà necessario selezionare o inserire un tag quando si aggiunge una nota del cliente, ad esempio',
    'tt_gen_skin'                                     => 'Come vorresti che fosse mostrata la tua interfaccia utente FI, modalità chiara o scura',
    'tt_gen_top_bar_color'                            => 'Il colore della barra del titolo superiore. Se lavori con diverse installazioni di FusionInvoice, questa può essere un\'utile identificazione visiva.',
    'tt_gen_results_per_page'                         => 'Il numero di record mostrati per pagina per tutte le visualizzazioni elenco, come clienti, fatture, preventivi, spese, ecc.',
    'tt_gen_allow_line_item_discounts'                => 'Abilita o disabilita la funzione di sconto dell\'articolo all\'interno di fatture e preventivi.',
    'tt_gen_language'                                 => 'La lingua da utilizzare per l\'installazione di FusionInvoice. Tieni presente che puoi assegnare una lingua diversa ai tuoi clienti, consentendo loro di interagire con FusionInvoice Client Center utilizzando la loro lingua madre.',
    'tt_gen_date_format'                              => 'Il tuo formato di data preferito',
    'tt_gen_use_24_hour_time_format'                  => 'Consente il supporto di formati orari di 24 o 12 ore.',
    'tt_gen_timezone'                                 => 'Il timezine principale della tua attività.',
    'tt_gen_base_currency'                            => 'La valuta che la tua azienda utilizza più spesso.',
    'tt_gen_exchange_rate_mode'                       => 'Manuale consente di inserire il valore del tasso di cambio durante la creazione delle fatture. Automatic tenterà di utilizzare un\'API pubblica per recuperare il tasso di cambio della valuta. Viene utilizzato solo quando si inserisce una transazione utilizzando una valuta diversa dalla valuta di base.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice supporta fino a 2 campi fiscali per elemento pubblicitario. Il valore selezionato con mostra o nascondi il secondo campo imposta.',
    'tt_gen_quantity_price_decimals'                  => 'Il numero di decimali da mostrare per i valori di quantità e importo. Selezionare da 0 a 4 in base al livello di precisione richiesto.',
    'tt_gen_round_tax_decimals'                       => 'Seleziona il numero richiesto di decimali per i calcoli di arrotondamento fiscale.',
    'tt_gen_use_captcha_in_login'                     => 'Se impostato su Sì, richiederà agli utenti di rispondere a una domanda di verifica CAPTCHA durante l\'accesso.',
    'tt_gen_force_https'                              => 'Consigliamo raramente di attivare questa opzione. Se la tua installazione non ha un certificato SSL correttamente funzionante installato sul tuo server web, per la tua installazione di FusionInvoice, potresti riscontrare problemi. Puoi ottenere lo stesso risultato impostando una regola di reindirizzamento del server.',
    'dashboard_settings'                              => 'Impostazioni della dashboard',
    'tt_dashboard_settings'                           => 'La tua dashboard viene utilizzata per visualizzare importanti metriche ed eventi aziendali, fornendoti preziose informazioni sulle prestazioni della tua azienda. La dashboard di sistema è l\'impostazione predefinita per tutti gli utenti, tuttavia all\'interno della configurazione di ciascun utente è possibile sovrascrivere la dashboard predefinita di sistema, definendo impostazioni specifiche per ciascun utente. Le impostazioni seguenti ti consentono di personalizzare la tua dashboard.',
    'tt_db_default_time_period'                       => 'Imposta le date di inizio e di fine predefinite per i widget del dashboard che le utilizzano, come le schede KPI e il grafico delle vendite.',
    'tt_db_recent_client_activity'                    => 'Un widget che mostra le interazioni del cliente, come i pagamenti effettuati e le fatture o i preventivi visualizzati, dalla tua fattura pubblica o dai link al preventivo.',
    'tt_db_display_order'                             => 'Ciò modifica l\'ordine di visualizzazione dei widget del dashboard. 1 verrà visualizzato in alto, 2 verrà visualizzato dopo 1, ecc.',
    'tt_db_column_width'                              => 'I widget del dashboard utilizzano il sistema a griglia Bootstrap e hanno una larghezza massima della colonna di 12. Impostando la larghezza della colonna su 12, il widget utilizzerà l\'intera larghezza disponibile. Impostandolo su 6 consentirà a due widget di condividere la stessa riga, 4 consentirà a 3 widget di condividere la stessa riga, ecc.',
    'tt_db_accumulate_totals'                         => 'L\'impostazione di questo valore farà sì che il grafico includa i totali dei giorni precedenti per ogni giorno. Ad esempio, le vendite del giorno 1 sono state di $ 100, del giorno 2 di $ 50 e del giorno 3 di $ 125. Il grafico mostrerebbe una linea crescente con questa opzione impostata su Sì. Impostato su No, mostrerebbe un calo nella linea di vendita il giorno 2 e aumenterebbe al giorno 3.',
    'tt_db_kpi_cards'                                 => 'Queste schede con codice colore mostrano gli indicatori chiave delle prestazioni nella parte superiore della dashboard.',
    'tt_db_sales_chart'                               => 'Un grafico a linee che mostra i totali di fatture e pagamenti.',
    'tt_db_task_list'                                 => 'Questo widget ti consente di lavorare con il modulo Elenco attività, direttamente dalla tua dashboard.',
    'tt_db_task_list_include_time'                    => 'L\'attivazione di questa opzione consente di specificare la data e l\'ora delle date di scadenza quando si lavora con le attività. Se impostato su No, viene utilizzato solo il valore della data.',
    'tt_db_timeline'                                  => 'Il widget della sequenza temporale mostra un elenco cronologico e consultabile di importanti eventi di sistema, come modifiche dello stato del cliente, fatture inviate tramite e-mail, pagamenti effettuati, note prese, ecc.',
    'tt_ss_invoices_default_invoice_template'         => 'Seleziona il modello che verrà utilizzato, per impostazione predefinita, durante la creazione di nuove fatture. I modelli personalizzati devono essere inseriti in .\\custom\\templates\\invoice_templates\\ e devono essere denominati con un\'estensione .blade.php.',
    'tt_ss_invoices_default_doc_scheme'               => 'Selezionare lo schema di numerazione del documento da utilizzare, per impostazione predefinita, durante la creazione di nuove fatture. Gli schemi di numerazione dei documenti possono essere creati all\'interno delle Impostazioni di configurazione e consentono di personalizzare i numeri dei documenti (fatture, preventivi, note di credito).',
    'tt_ss_invoices_invoice_due_days'                 => 'Il numero predefinito di giorni, dopo la data (creazione) della fattura, in cui la fattura scadrà e si prevede che venga pagata.',
    'tt_ss_invoices_automatic_email_ri'               => 'Quando una fattura ricorrente viene eseguita e genera una fattura in tempo reale, tale fattura in tempo reale deve essere inviata automaticamente tramite e-mail al cliente?',
    'tt_ss_invoices_qr_code'                          => 'Dovrebbe essere inserito automaticamente un codice QR sulle fatture e sui preventivi predefiniti. Se utilizzi modelli di fatture o preventivi personalizzati, fai riferimento ai modelli predefiniti per aggiungere il codice QR ai tuoi modelli personalizzati.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Se una fattura è nello stato Bozza e viene inviata tramite e-mail, manualmente o automaticamente, cosa dovrebbe accadere alla data della fattura. Nota importante: quando una fattura viene inviata tramite e-mail, lo stato verrà automaticamente modificato da Bozza a Inviato.',
    'tt_ss_invoices_recalculate'                      => 'Esegue ogni transazione effettuata per ogni fattura, dalla data di creazione alla data corrente, e ricalcola i totali, i totali delle voci, le tasse, gli sconti e i totali delle fatture. L\'esecuzione può richiedere molto tempo se si dispone di un set di dati di grandi dimensioni.',
    'tt_ss_invoices_due_after'                        => 'La data di scadenza della fattura sarà la data della fattura più il numero di giorni inseriti qui.',
    'tt_ss_invoices_default_status_filter'            => 'Il filtro di stato da applicare, per impostazione predefinita, durante la visualizzazione dell\'elenco delle fatture.',
    'tt_ss_invoices_default_terms'                    => 'Il valore del testo dei termini visualizzato, nel modello di fattura predefinito, nell\'area inferiore della fattura, all\'interno dell\'area Termini e condizioni.',
    'tt_ss_invoices_default_footer'                   => 'Valore del testo del piè di pagina che viene visualizzato, nel modello di fattura predefinito, nella parte inferiore della fattura. Per esempio:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Quando il task runner giornaliero (lavoro CRON) esegue e genera una fattura in tempo reale da un modello di fattura ricorrente, la fattura appena creata dovrebbe essere inviata automaticamente al cliente tramite e-mail? Questo può essere ignorato su base client per client.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Quando viene prelevato un pagamento, le informazioni sul pagamento devono essere inviate automaticamente tramite e-mail al cliente?',
    'tt_ss_invoices_online_payment_method'            => 'Il metodo di pagamento che viene assegnato quando un cliente paga utilizzando un collegamento a una fattura pubblica. I metodi di pagamento possono essere mantenuti tramite Impostazioni di sistema.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Sul documento deve essere visualizzato un codice QR, che indirizza all\'URL pubblico della fattura o del preventivo?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Gli utenti, anche gli amministratori, dovrebbero essere autorizzati a eliminare le fatture? Un\'alternativa più sicura e tracciabile all\'eliminazione delle fatture consiste nel modificare lo stato della fattura in',
    'tt_ss_invoices_show_invoices_from'               => 'Quando le fatture vengono inviate tramite e-mail, questo verrà visualizzato come indirizzo Spedito da. Nota importante: il valore Rispondi a sarà sempre il valore assegnato in Impostazioni di sistema',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Dalla visualizzazione della fattura, se la fattura è nello stato Bozza e viene inviata tramite e-mail, la data della fattura deve rimanere invariata o passare alla data corrente? Se la data della fattura cambia, viene aggiornata anche la data di scadenza.',
    'tt_ss_quotes_default_quote_template'             => 'Seleziona il modello che verrà utilizzato, per impostazione predefinita, durante la creazione di un nuovo preventivo. I modelli personalizzati devono essere inseriti in .\\custom\\templates\\quote_templates\\ e devono essere denominati con un\'estensione .blade.php.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Selezionare lo schema di numerazione del documento da utilizzare, per impostazione predefinita, durante la creazione di nuovi preventivi. Gli schemi di numerazione dei documenti possono essere creati all\'interno delle Impostazioni di configurazione e consentono di personalizzare i numeri dei documenti (fatture, preventivi, note di credito).',
    'tt_ss_quotes_expire_days'                        => 'Il numero predefinito di giorni, dopo la data (di creazione) del preventivo, in cui il preventivo scadrà. Quando una quotazione ha superato la data di scadenza, resta inteso che il prezzo può cambiare a causa delle fluttuazioni del mercato, ecc.',
    'tt_ss_quotes_default_status_filter'              => 'Il filtro di stato da applicare, per impostazione predefinita, durante la visualizzazione dell\'elenco delle fatture.',
    'tt_ss_quotes_auto_convert'                       => 'Quando un preventivo viene approvato, dovrebbe causare la creazione automatica di una fattura dal preventivo.',
    'tt_ss_quotes_when_converted_action'              => 'Quando un preventivo viene convertito in una fattura, i termini di pagamento devono essere utilizzati dal preventivo o dall\'impostazione predefinita dei termini di fatturazione?',
    'tt_ss_quotes_default_terms'                      => 'Il valore del testo dei termini che viene visualizzato, nel modello di preventivo predefinito, nell\'area inferiore del preventivo, all\'interno dell\'area Termini e condizioni.',
    'tt_ss_quotes_default_footer'                     => 'Valore del testo del piè di pagina che viene visualizzato, nel modello di preventivo predefinito, nella parte inferiore del preventivo. Per esempio:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Se un preventivo è nello stato Bozza e viene inviato tramite e-mail, manualmente o automaticamente, cosa dovrebbe accadere alla data del preventivo. Nota importante: quando un preventivo viene inviato tramite e-mail, lo stato verrà automaticamente modificato da Bozza a Inviato.',
    'tt_ss_quotes_recalculate'                        => 'Esegue ogni transazione effettuata per ogni preventivo, dalla data di creazione alla data corrente, e ricalcola i totali, i totali delle voci, le tasse, gli sconti e i totali dei preventivi. L\'esecuzione può richiedere molto tempo se si dispone di un set di dati di grandi dimensioni.',
    'tt_ss_taxes_default_rate1'                       => 'L\'aliquota fiscale principale che dovrebbe essere applicata automaticamente alle nuove voci aggiunte a fatture o preventivi. Le aliquote fiscali vengono mantenute tramite Configurazione -',
    'tt_ss_taxes_default_rate2'                       => 'L\'aliquota fiscale secondaria che deve essere applicata automaticamente alle nuove voci aggiunte a fatture o preventivi. Le aliquote fiscali vengono mantenute tramite Configurazione -',
    'tt_ss_email_send_method'                         => 'Il metodo di invio e-mail che FusionInvoice dovrebbe utilizzare. La modifica del metodo di invio cambia anche la visualizzazione dei campi di supporto per il metodo di invio.',
    'tt_ss_email_allow_self_cert'                     => 'L\'attivazione di questa opzione disattiva il requisito PHP describe_peer. Per ulteriori informazioni, cercare in Internet: certificato autofirmato per e-mail PHP openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Quando si inviano e-mail, questo è l\'indirizzo di risposta predefinito che i destinatari vedranno.',
    'tt_ss_email_always_cc'                           => 'Un indirizzo e-mail che, per impostazione predefinita, desideri inserire automaticamente in CC con ogni e-mail inviata.',
    'tt_ss_email_always_bcc'                          => 'Un indirizzo e-mail che, per impostazione predefinita, vorresti inserire automaticamente in CCN con ogni e-mail inviata.',
    'tt_ss_email_send_test_to'                        => 'L\'indirizzo e-mail da utilizzare quando si fa clic sul pulsante Invia e-mail di prova.',
    'tt_ss_email_mail_from_addr'                      => 'L\'indirizzo di posta elettronica predefinito da utilizzare quando le e-mail vengono inviate da FusionInvoice. Nota: in Impostazioni di sistema -',
    'tt_ss_email_mail_from_name'                      => 'Il nome descrittivo Mail From da mostrare nelle e-mail inviate.',
    'tt_ss_email_email_templates'                     => 'I modelli di email sono disponibili per molti documenti ed eventi, tra cui: preventivi, approvazioni di preventivi, rifiuti di preventivi, fatture, fatture scadute, note di credito, ricevute di pagamento, avvisi di pagamento imminenti. È incluso un modello predefinito, ma puoi anche creare modelli personalizzati, che possono essere semplici (come i modelli predefiniti forniti) o HTML completamente formattati.',
    'tt_ss_pdf_driver'                                => 'Il driver da utilizzare durante la creazione di documenti PDF. La selezione del driver \'wkhtmltopdf\' richiede l\'installazione di questo programma sul server locale e l\'impostazione del percorso binario appropriato.',
    'tt_ss_pdf_binary_path'                           => 'Il percorso del server locale al file binario per wkhtmltopdf. Ad esempio C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice supporta diversi fornitori di pagamenti online. Abilita i fornitori con i quali hai stabilito account. I fornitori abilitati qui verranno visualizzati come opzioni di pagamento, quando i tuoi clienti visualizzeranno le loro fatture utilizzando il collegamento alla fattura pubblica (incluso nell\'e-mail di fatturazione predefinita).',
    'tt_ss_olp_api_key'                               => 'La chiave API ti viene fornita dal tuo fornitore di servizi di pagamento.',
    'tt_ss_olp_payment_button_text'                   => 'Il testo che viene visualizzato sul pulsante del metodo di pagamento per questo fornitore di servizi di pagamento, nella parte superiore della tua fattura pubblica, così come viene visualizzato dai tuoi clienti.',
    'tt_ss_olp_mode'                                  => 'Supportato da alcuni fornitori di servizi di pagamento, consentendo Sandbox più (test) e live.',
    'tt_ss_olp_client_id'                             => 'L\'ID cliente ti viene fornito da questo fornitore di servizi di pagamento.',
    'tt_ss_olp_client_secret'                         => 'Il segreto client ti viene fornito da questo fornitore di servizi di pagamento.',
    'tt_ss_olp_publishable_key'                       => 'La chiave pubblicabile ti viene fornita da questo fornitore di servizi di pagamento.',
    'tt_ss_olp_secret_key'                            => 'La chiave segreta ti viene fornita da questo fornitore di servizi di pagamento.',
    'tt_ss_olp_opp_fees_about'                        => 'Le commissioni per l\'elaborazione dei pagamenti online possono essere calcolate per i clienti che pagano con carta di credito, utilizzando il collegamento alla fattura pubblica (incluso nell\'e-mail della fattura).',
    'tt_ss_olp_enable_opp_fees'                       => 'Le commissioni per l\'elaborazione dei pagamenti online possono essere calcolate per i clienti che pagano con carta di credito, utilizzando il collegamento alla fattura pubblica (incluso nell\'e-mail della fattura). Questa opzione ha un\'impostazione di sistema globale, ma può anche essere sovrascritta su base client individuale.',
    'tt_ss_olp_opp_fee_pct'                           => 'La percentuale del totale della fattura da addebitare come commissione per l\'elaborazione del pagamento online (convenienza).',
    'tt_ss_olp_opp_fee_name'                          => 'Il nome della tariffa da mostrare sulla fattura. Cioè. \'Commissione di convenienza della carta di credito\'.',
    'tt_ss_olp_opp_fee_explanation'                   => 'Una spiegazione della commissione da visualizzare sulla fattura. Cioè.',
    'tt_company_profiles_about'                       => 'I profili aziendali ti consentono di presentare la tua attività in modo diverso con ciascun profilo, consentendo diversi nomi di società, loghi, formati di fattura, ecc. Fornisce un modo per avere più società virtuali all\'interno della stessa installazione di FusionInvoice. È necessario selezionare un profilo aziendale predefinito in Impostazioni di sistema.',
    'tt_users_about'                                  => 'È possibile creare utenti di tipo Admin (accesso completo) o Standard (è necessario concedere autorizzazioni di sistema individuali). L\'impostazione di',
    'tt_users_client_about'                           => 'Gli utenti del cliente possono accedere solo al Centro clienti, che consente loro una visione limitata delle loro fatture, preventivi e pagamenti. L\'impostazione di',
    'tt_user_types_about'                             => 'Gli utenti amministratori hanno accesso completo al sistema. Agli utenti standard possono essere concesse le autorizzazioni individuali di cui hanno bisogno. Gli utenti del cliente hanno accesso solo alle loro informazioni specifiche all\'interno del Centro clienti e la loro possibilità di accedere è impostata nelle Impostazioni del cliente -',
    'tt_custom_fields_about'                          => 'I campi personalizzati ti consentono di aggiungere i tuoi campi dati alla maggior parte dei moduli. Se hai bisogno di catturare il settore per i clienti, aggiungi semplicemente un campo personalizzato con l\'etichetta',
    'tt_recurring_invoices_about'                     => 'Le fatture ricorrenti non sono in realtà fatture, ma piuttosto modelli per la creazione di fatture future. Hanno una frequenza di ricorrenza e una data successiva che determinano quando genereranno una fattura in tempo reale. Affinché le fatture ricorrenti funzionino correttamente, è necessario un lavoro CRON giornaliero o un\'attività pianificata.',
    'tt_addons_about'                                 => 'I componenti aggiuntivi sono personalizzazioni di FusionInvoice per esigenze aziendali uniche, come il monitoraggio del tempo, formule di prezzo o modelli di fattura stilizzati. Sono offerti tramite il marketplace dei componenti aggiuntivi di FusionInvoice.',
    'client_center_user'                              => 'Utente Centro clienti',
    'user_type'                                       => 'Tipologia di utente',
    'custom_field'                                    => 'Campo personalizzato',
    'placeholder_type_email_template'                 => 'Digita o incolla il tuo modello di email . . .',
    'email_templates'                                 => 'Modelli di posta elettronica',
    'payment_receipts'                                => 'Ricevute di pagamento',
    'upcoming_payment_notices'                        => 'Prossimi avvisi di pagamento',
    'convenience_fee_for_credit_card_transactions'    => 'Commissione di convenienza per transazioni con carta di credito',
    'credit_card_processing_fee'                      => 'Commissione di elaborazione della carta di credito',
    'delete_client_user_warning'                      => '<p>L\'eliminazione di un utente cliente disabiliterà la sua capacità di accedere al centro clienti.</p>',
    'use_default_mail_template'                       => 'Modello di posta predefinito',
    'use_custom_mail_template'                        => 'Modello di posta personalizzato',
    'quote_email_body'                                => 'Citare il corpo dell\'email',
    'overdue_invoice_email_body'                      => 'Corpo email fattura scaduta',
    'credit_memo_email_body'                          => 'Corpo dell\'email della nota di credito',
    'payment_receipt_body'                            => 'Corpo della ricevuta di pagamento',
    'invoice_email_body'                              => 'Corpo dell\'e-mail della fattura',
    'quote_custom_email_body_require'                 => 'Inserisci il tuo modello di email personalizzato per il corpo dell\'email di preventivo',
    'quote_custom_approve_email_body_require'         => 'Inserisci il tuo modello di email personalizzato per il corpo dell\'email di approvazione del preventivo',
    'quote_reject_email_body_require'                 => 'Inserisci il tuo modello di email personalizzato per il corpo dell\'email di rifiuto del preventivo',
    'overdue_invoice_email_body_require'              => 'Inserisci il tuo modello di email personalizzato per il corpo dell\'email della fattura scaduta',
    'invoice_email_body_require'                      => 'Inserisci il tuo modello di email personalizzato per il corpo dell\'email della fattura',
    'credit_memo_email_body_require'                  => 'Inserisci il tuo modello di email personalizzato per il corpo dell\'email della nota di credito',
    'payment_receipt_email_body_require'              => 'Inserisci il tuo modello di email personalizzato per il corpo dell\'email di ricevuta del pagamento',
    'upcoming_payment_notice_email_body_require'      => 'Inserisci il tuo modello di email personalizzato per il corpo dell\'email di avviso di pagamento in arrivo',
    'copy_text'                                       => 'Copia testo',
    'tt_preview_template'                             => 'Modello di anteprima',
    'tt_view_template_code'                           => 'Visualizza codice modello',
    'dashboard_date_range'                            => 'Intervallo date dashboard',
    'tt_dashboard_date_range'                         => 'Dashboard Date Range filtra la vista per i seguenti widget: KPI Cards, Sales Chart, Recent Client Activity.',
    'product_copy'                                    => 'Copia del prodotto',
    'open_selected_client'                            => 'Apri il cliente selezionato',
    'save_this_client'                                => 'Salva questo cliente (non un duplicato)',
    'looks_like_duplicate'                            => 'Hmm... Questo sembra un duplicato',
    'duplicate_instructions'                          => 'Se vedi il cliente che volevi nell\'elenco, selezionalo e aprilo. In caso contrario, salva il nuovo client.',
    'select_checkbox'                                 => 'Seleziona un cliente',
    'select_lead_source_tag'                          => 'Seleziona Fonte lead cliente',
    'lead_source'                                     => 'Fonte di piombo',
    'tt_client_lead_source_tags'                      => 'Seleziona o inserisci la fonte del lead del cliente (come è stato acquisito il cliente)',
    'your_link_is_expired'                            => 'Ops! Il tuo collegamento è scaduto.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Torna alla dashboard</a>.',
    'secure_link_and_expire_link_days'                => 'Proteggi e fai scadere i collegamenti alle fatture pubbliche',
    'secure_link_expire_days'                         => 'Numero di giorni',
    'tt_secure_link_and_expire_link_days'             => 'Quando si abilitano i collegamenti sicuri, è necessario impostare anche il numero di giorni dopo i quali il collegamento alla fattura scadrà. In questo modo, un cliente può visualizzare il collegamento alla fattura pubblica fino alla scadenza.',
    'expire_time_period'                              => 'Il campo Link Expire Number of Days è obbligatorio',
    'enter_days'                                      => 'Inserisci Giorni',
    'invalid_field_name'                              => 'Inserisci un nome di campo valido',
    'lead_source_notes'                               => 'Note sulla fonte principale',
    'important_note'                                  => 'Nota importante',
    'social_media_url'                                => 'URL dei social media',
    'general_notes'                                   => 'Note generali',
    'payment_amount_mismatch'                         => 'Mancata corrispondenza dell\'importo del pagamento',
    'open_invoice_aging'                              => 'Scadenza fattura aperta',
    'tt_db_open_invoice_aging'                        => 'Scadenza fattura aperta',
    'current'                                         => 'Attuale',
    'oneToThirty'                                     => '1-30 giorni',
    'thirtyOneToSixty'                                => '31-60 giorni',
    'sixtyOneToNinety'                                => '61-90 giorni',
    'ninetyOnePlus'                                   => '91 giorni',
    'sent_and_draft'                                  => 'Includi fatture inviate e bozze',
    'sent_only'                                       => 'Includi solo fatture inviate',
    'tt_open_ar_aging_settings'                       => 'Impostazioni per i totali di scadenza fattura aperta',
    'tt_client_field_settings'                        => 'Seleziona i campi che desideri vengano visualizzati nella tua vista cliente',
    'position_change'                                 => 'Posizione cambiata',
    'dynamic_width'                                   => 'Larghezza dinamica',
    'full_width'                                      => 'Intera larghezza',
    'save_configuration_default'                      => 'Salva la configurazione come predefinita di sistema',
    'assign_configuration_other'                      => 'Assegna la configurazione ad altri utenti',
    'tt_user_tags'                                    => 'Tag utente',
    'select_users'                                    => 'Seleziona Utenti',
    'configuration_assigned'                          => 'Configurazione assegnata correttamente',
    'default_configuration_set'                       => 'Configurazione predefinita impostata correttamente',
    'current_user_id'                                 => 'ID utente corrente',
    'tt_users_settings'                               => 'Impostazioni utenti',
    'invoice_link_expire'                             => 'Il link pubblico della tua fattura scadrà tra',
    'quote_link_expire'                               => 'Il link pubblico del tuo preventivo scadrà tra',
    'dashboard_width'                                 => 'Dashboard :widthName impostazione della larghezza della colonna modificata',
    'unmark_mailed'                                   => 'Deseleziona come spedito',
    'invoice_unmark_mailed'                           => 'Deseleziona la fattura come spedita',
    'print_mark_mailed'                               => 'Stampa',
    'public_link'                                     => 'Collegamento pubblico',
    'tt_sales_chart_settings'                         => 'Impostazione della fattura/totale del grafico delle vendite',
    'verify_key'                                      => 'Verifica della chiave del prodotto',
    'enter_key'                                       => 'Inserisci la tua chiave',
    'verify'                                          => 'Verificalo!',
    'key_required'                                    => 'Il codice prodotto è obbligatorio',
    'key_length_invalid'                              => 'Inserisci il codice Product Key di 32 caratteri fornito al momento dell\'acquisto.',
    'invalid_key'                                     => 'Siamo spiacenti, la tua chiave non è valida. Impossibile procedere con l\'installazione.',
    'key_verified'                                    => 'Congratulazioni, la tua chiave è stata verificata.',
    'clear_cache'                                     => 'Cancella cache',
    'clear_cache_confirm'                             => 'Sei sicuro di voler cancellare la cache dell\'applicazione?',
    'cache_clear_success'                             => 'Cache cancellata correttamente.',
    'cache_clear_error'                               => 'Controlla la configurazione del tuo server per il comando PHP exec().',
    'add_new_client'                                  => 'Aggiungi nuovo cliente',
    'add'                                             => 'Aggiungere',
    'invalid_quantity_amount'                         => 'Importo quantità non valido! Deve essere maggiore di 0.',
    'api_version'                                     => 'Versione dell\'API',
    '2021_prior'                                      => '2021 e precedenti',
    '2022_later'                                      => '2022 e successivi',
    'vendors'                                         => 'Venditori',
    'file_not_found'                                  => ':file_name non trovato',
    'leave_empty_no_parent_account'                   => 'lasciare vuoto se il cliente non ha un account genitore',
    'leave_empty_client_pays_invoices'                => 'lasciare vuoto se il cliente paga le proprie fatture',
    'modal_not_found'                                 => 'Modale non trovato',
    'payment_delete_success'                          => 'Pagamento eliminato con successo',
    'payment_delete_error'                            => 'Si è verificato un problema durante l\'eliminazione del pagamento. Riprova più tardi.',
    'status_change_error'                             => 'Qualcosa è andato storto! Lo stato non è stato modificato.',
    'total_payments'                                  => 'Pagamenti totali',
    'licence_verification_error'                      => 'Impossibile verificare la tua chiave di licenza.',
    'line_item_discount_limit'                        => 'Gli elementi pubblicitari non possono avere uno sconto superiore al 99,99%.',
    'date_range_report'                               => 'Intervallo di date (prossima data di esecuzione)',
    'no_client_found'                                 => 'Hmmm... non siamo riusciti a trovare quel cliente.',
    'tt_line_item_discount'                           => 'Lo sconto di una voce può essere calcolato in base a una percentuale del prezzo oa un importo forfettario per il prezzo del singolo articolo.',
    'functionality_not_available_on_demo'             => 'Siamo spiacenti, questa funzione non è consentita nella demo.',
    'vat_tax_id'                                      => 'partita Iva',
    'tt_vat_tax_id'                                   => 'Numero di imposta sul valore aggiunto (IVA).',
    'enable_vat_tax_id'                               => 'Abilita partita IVA',
    'no-attachment'                                   => 'Non c\'è attaccamento',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Ripulire',
    'allow_edit_status_invoice'                       => 'Modifica fattura :status',
    'tt_ss_allow_edit_invoices_status'                => 'Per precauzione di sicurezza, è possibile modificare solo le fatture in stato Bozza. È possibile ignorare questa impostazione consentendo la modifica delle fatture inviate e/o pagate.',
    'allow_edit_invoices_status'                      => 'Consenti la modifica delle fatture in stato',
    'draft_and_sent'                                  => 'Bozza e inviato',
    'draft_or_sent_and_paid'                          => 'Bozza, inviata e pagata',
    'invoice_editable'                                => 'Fattura modificabile',
    'can_not_edit_paid_invoice'                       => 'Non è possibile modificare una fattura pagata',
    'item_category'                                   => 'Categoria articolo',
    'itemLookups'                                     => 'Ricerche di articoli',
    'quoteItems'                                      => 'Quota articoli',
    'invoiceItems'                                    => 'Elementi fattura',
    'imports_disabled_in_demo.'                       => 'Le importazioni sono disabilitate nella demo.',
    'no_file_selected'                                => 'Nessun file selezionato',
    'no_import_records'                               => 'Nessun record trovato da importare',
    'vendor_name'                                     => 'Nome del fornitore',
    'license_key'                                     => 'Chiave di licenza',
    'change_license_key'                              => 'Cambia chiave di licenza',
    'verify_and_save'                                 => 'Verificare',
    'same_key_error'                                  => 'Nessun cambiamento rilevato. Si prega di provare una chiave diversa',
    'trying_invalid_key'                              => 'Spiacenti, non è stato possibile verificare la chiave. La chiave di licenza non è stata modificata.',
    'key_updated'                                     => 'Congratulazioni! La tua chiave di licenza è stata aggiornata con successo.',
    'invalid_date_format'                             => 'Formato data non valido. Formato richiesto: AAAA-MM-GG',
    'invalid_datetime_format'                         => 'Formato data/ora non valido. Formato richiesto: AAAA-MM-GG HH:MM :SS',
    'profile_setting'                                 => 'Impostazioni del profilo',
    'include_draft_invoices_unpaid_and_overdue'       => 'Includi bozze di fatture negli elenchi non pagati e scaduti',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Se impostato su Sì, le fatture con stato Bozza verranno incluse negli elenchi e nei calcoli per le fatture scadute e non pagate.',
    'tt_utilities_import'                             => 'Importa dati da file CSV nel tuo database FusionInvoice.',
    'tt_utilities_export'                             => 'Esporta i dati dal tuo database FusionInvoice in diversi formati: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Visualizza il file di registro che contiene tutti gli eventi e-mail all\'interno di FusionInvoice.',
    'tt_utilities_system_log'                         => 'Visualizza il file di registro del sistema contenente gli eventi di sistema di errore e avviso.',
    'tt_utilities_tag_cleanup'                        => 'Rimuove i tag definiti ma non utilizzati. Rimuove anche eventuali tag duplicati.',
    'tt_utilities_pdf_cleanup'                        => 'Rimuove i file PDF temporanei.',
    'tt_utilities_recalc_invoices'                    => 'Esegue la scansione di ogni fattura, garantendo che i totali corrispondano alla somma di tutte le voci, tenendo conto di sconti e imposte. *L\'operazione può richiedere molto tempo.',
    'tt_utilities_recalc_quotes'                      => 'Esamina ogni preventivo, assicurandosi che i totali corrispondano alla somma di tutte le voci, tenendo conto di sconti e tasse. *L\'operazione può richiedere molto tempo.',
    'tt_utilities_clear_cache'                        => 'Rimuove i file temporanei della cache.',
    'tt_utilities_download_database'                  => 'Scarica un file di database esportato dai tuoi dati FusionInvoice in tempo reale. Più grande è il tuo database, più tempo richiederà.',
    'tt_utilities_run_daily_tasks'                    => 'Un lavoro CRON o un\'attività pianificata normalmente esegue le tue attività quotidiane. Ciò ti consente di farlo manualmente. Genera fatture in tempo reale da modelli di fatture ricorrenti, invia solleciti di pagamento, ecc.',
    'include_line_item_detail'                        => 'Includi i dettagli dell\'elemento pubblicitario',
    'invoice_tags'                                    => 'Tag fattura',
    'related_accounts'                                => 'Account correlati',
    'not_found_related_clients'                       => 'Nessun account cliente correlato è stato assegnato',
    'invoices_paid_for_list'                          => 'Questo account cliente paga le fatture per',
    'child_accounts_exist'                            => 'L\'impostazione Consenti account figlio è stata ripristinata su Sì. Impossibile passare a No quando esistono account per bambini.',
    'third_bp_accounts_exist'                         => 'L\'impostazione del pagamento di fatture di terze parti è stata ripristinata su Sì. Impossibile passare a No quando esistono account correlati.',
    'tag_name'                                        => 'Nome etichetta',
    'tag_new_name'                                    => 'Nuovo nome tag',
    'tag_category'                                    => 'Tag Categoria',
    'rename_tags'                                     => 'Rinomina tag',
    'apply'                                           => 'Fare domanda a',
    'select_tag_category'                             => 'Seleziona Categoria tag',
    'tt_utilities_rename_tags'                        => 'Rinomina tag assegnati a clienti, note, attività di vendita, ecc.',
    'system_default_dashboard'                        => 'Dashboard predefinito di sistema',
    'user_specific_dashboards'                        => 'Dashboard specifici dell\'utente',
    'tt_default_client_type'                          => 'Tipo di cliente predefinito',
    'default_client_type'                             => 'Tipo di cliente predefinito',
    'invalid_user'                                    => 'Seleziona un utente valido.',
    'create_live_invoice'                             => 'Crea fattura in tempo reale',
    'create_live_invoice_successfully'                => 'Fattura dal vivo',
    'create_live_invoice_unsuccessfully'              => 'La fattura in tempo reale non è stata creata',
    'live_invoice_not_generate'                       => 'Impossibile generare una fattura in tempo reale da una fattura ricorrente che ha una data di fine di oggi o precedente o una data successiva più di 30 giorni nel futuro.',
    'data_seeder'                                     => 'Seminatrice di dati',
    'select_module'                                   => 'Seleziona Modulo',
    'number_of_seed'                                  => 'Numero di semi',
    'seed_it'                                         => 'Seminalo!',
    'seeds_success'                                   => 'Semi aggiunti con successo',
    'tt_ri_generate_the_next_live_invoice'            => 'Genera subito la prossima fattura attiva per questa fattura ricorrente.',
    'system_log_clear_message'                        => 'Sei sicuro di voler cancellare il registro di sistema? Questa azione non può essere annullata e tutti i registri precedenti verranno eliminati definitivamente.',
    'system_log_clear_successfully'                   => 'Registro di sistema cancellato con successo',
    'payment_problem'                                 => 'Si è verificato un problema durante il pagamento. Per favore riprova più tardi.',
    'log_detail'                                      => 'Fare clic qui per visualizzare il registro dettagliato.',
    'log_limit_message'                               => 'File di registro',
    'log_download_file'                               => 'Download file',
    'log_delete_all'                                  => 'Elimina tutti i file',
    'log_level'                                       => 'Livello',
    'log_context'                                     => 'Contesto',
    'log_date'                                        => 'Data',
    'log_line_number'                                 => 'Numero di riga',
    'log_content'                                     => 'Contenuto',
    'addon_install_error'                             => 'Si è verificato un problema con l\'installazione del componente aggiuntivo, riprova più tardi.',
    'addon_installed_success'                         => 'Componente aggiuntivo installato correttamente.',
    'allow_edit_status_credit_memo'                   => 'Modifica nota di credito applicata',
    'database_seeder'                                 => 'Seminatrice',
    'tt_utilities_database_seeder'                    => 'Semina il tuo database con dati di test utilizzando le classi seed',
    'vat_information'                                 => 'Informazioni sull\'IVA',
    'tt_vat_information'                              => 'Numero di conto bancario IBAN, BIC, e-mail ecc...',
    'explore_addons'                                  => 'Esplora i componenti aggiuntivi',
    'available_addons'                                => 'Componenti aggiuntivi di FusionInvoice disponibili',
    'addon_success'                                   => 'Il componente aggiuntivo è stato aggiunto con successo.',
    'payment_cannot_enabled_in_demo'                  => 'I gateway di pagamento non possono essere abilitati nella demo',
    'confirm_approve_leave_page'                      => 'Sono presenti modifiche non salvate in questa pagina! Sei sicuro di voler uscire senza salvare?',
    'leave'                                           => 'Partire',
    'demo_date_refresh'                               => 'I dati demo verranno aggiornati',
    'minutes'                                         => 'minuti',
    'minute'                                          => 'minuto',
    'seconds'                                         => 'secondi',
    'mautic-authentication-fail'                      => 'Non sei autorizzato ad accedere a questa risorsa. Utilizza una chiave segreta valida.',
    'something_went_wrong'                            => 'Qualcosa è andato storto!',
    'month_to_date'                                   => 'Questo mese fino ad oggi',
    'quarter_to_date'                                 => 'Questo trimestre fino ad oggi',
    'year_to_date'                                    => 'Anno fino ad oggi',
    'last_active'                                     => 'Ultimo attivo',
    'database_seeder_stop'                            => ':name FERMATA SEMINATRICE AZIENDALE',
    'database_seeder_start'                           => ':name INIZIO SEMINATRICE AZIENDALE',
    'seeder_records_created'                          => 'Record :total creati con successo per :modal',
    'seeder_credit_apply_invoice'                     => 'Nota di credito applicata alla fattura',
    'seeder_quote_approve_reject'                     => 'Preventivo Approva e rifiuta',
    'seeder_executed'                                 => 'Seminatrice eseguita con successo!',
    'seeder_not_executed'                             => 'La seminatrice non è stata giustiziata!',
    'db_to_file_system_attachments_migration'         => 'Migrazione degli allegati: dal database al file system',
    'attachment_content_count'                        => 'Stai per eseguire la migrazione di un totale di',
    'attachment_repeat_content_count'                 => 'Stai per eseguire la migrazione di un totale di',
    'attachment_key_invalid'                          => 'La chiave dell\'allegato non è valida',
    'stop'                                            => 'Fermare!',
    'attachment_migration_warning'                    => 'Questo passaggio migrerà gli allegati dal database al file system, esegui un backup completo del database prima di procedere e assicurati di disporre di spazio su disco sufficiente per eseguire questa operazione.',
    'attachment_agreement_accept'                     => 'Ho eseguito il backup del mio database.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => 'Password di Microsoft 365',
    'office365_username'                              => 'Nome utente Microsoft 365',
    'custom_date_formula_note1'                       => '<b><u>Segnaposto del valore predefinito :</span></u></b> ~<br> È possibile utilizzare <b>oggi, domani e ieri</b> qualsiasi valore come predefinito.<br>',
    'custom_date_formula_note2'                       => '<b>Per oggi + N giorni, utilizza </b> \'default\': \'+7\' Ciò aggiunge 7 giorni alla data odierna <br><b>Per oggi - N giorni, utilizza </b> \'default\': \'-7\' Verranno sottratti 7 giorni dalla data odierna <br>',
    'mail_config_error'                               => 'Impossibile inviare un\'e-mail di prova senza aver definito il metodo di invio dell\'e-mail.',
    'db_prefix_alert'                                 => 'Abbiamo notato che stai utilizzando il prefisso del database :prefix . FusionInvoice non supporterà i prefissi del database nelle versioni future. Modifica il tuo database e rinomina tutte le tue tabelle, rimuovendo il prefisso, quindi modifica il tuo file database.php e imposta il valore \'prefisso\' su vuoto',
    'db_prefix_alert_title'                           => 'Il supporto per i prefissi DB terminerà a breve',
    'add_title_bar_shortcut'                          => 'Aggiungi collegamento alla barra del titolo',
    'title_bar_shortcuts'                             => 'Scorciatoie della barra del titolo',
    'select_icon'                                     => 'Seleziona l\'icona',
    'all_payment_method'                              => 'Tutti i metodi di pagamento',
    'about'                                           => 'Di',
    'own_license'                                     => 'Propria licenza',
    'tt_own_license'                                  => 'Propria licenza',
    'git_branch'                                      => 'Git ramo corrente',
    'quote_email'                                     => 'Preventivo e-mail',
    'custom1'                                         => 'Personalizzato 1',
    'custom2'                                         => 'Personalizzato 2',
    'custom3'                                         => 'Personalizzato 3',
    'default_document_template'                       => 'Modello di documento predefinito',
    'default_email_template'                          => 'Modello email predefinito',
    'sms'                                             => 'Sms',
    'pricing_formula'                                 => 'Formula di prezzo',
    'is_mobile'                                       => 'è mobile?',
    'default_sms_template'                            => 'Modello SMS predefinito',
    'sms_log'                                         => 'Registro SMS',
    'two_factor_auth'                                 => 'Autenticazione a due fattori',
    'enabled_mail_driver'                             => 'Si prega di abilitare il servizio email',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Codice di verifica non valido',
    'otp-subject'                                     => 'Accedi all\'OTP',
    'resend_otp_success'                              => 'Codice di verifica rinviato',
    'resend_otp_btn'                                  => 'Codice di rispedizione',
    'expired_otp'                                     => 'Codice di verifica scaduto',
    'token_expired'                                   => 'Il tuo token CSRF è scaduto',
    'verification_code'                               => 'Codice di verifica',
    'migration'                                       => 'Migrazione',
    'invoice_status_change_draft_to_sent'             => 'Lo stato della fattura è cambiato da bozza a inviata',
    'default_sales_quantity'                          => 'Quantità di vendita predefinita',
    'lead_time'                                       => 'Media Tempi di consegna (giorni)',
    'primary_vendor_id'                               => 'Venditore preferito',
    'all_items'                                       => 'Tutti gli articoli',
    'non_inventory_items'                             => 'Articoli non in inventario',
    'back_ordered'                                    => 'Indietro ordinato',
    'low_inventory'                                   => 'Inventario basso',
    'high_inventory'                                  => 'Inventario elevato',
    'merge_client_records'                            => 'Unisci i record del cliente',
    'primary_merge_to_client'                         => 'Unisci in (mantieni)',
    'surrogate_merge_from_client'                     => 'Unisci da (scarta)',
    'merge'                                           => 'Unisci',
    'merge_action'                                    => 'Azione Unisci',
    'ignore'                                          => 'Ignorare',
    'overwrite'                                       => 'Sovrascrivi',
    'add_to'                                          => 'Aggiungere a',
    'select_merge_client'                             => 'Seleziona Per unire',
    'client_to_and_from_not_same'                     => 'Il client da e il client devono essere diversi.',
    'client_id_required'                              => 'Il campo di selezione del cliente deve essere obbligatorio e univoco.',
    'is_merge'                                        => 'Unisci',
    'record_successfully_merged'                      => 'Record unito con successo',
    'service_ends'                                    => 'Il servizio termina',
    'service_starts'                                  => 'Il servizio inizia',
    'explanation'                                     => 'Spiegazione',
    'subscription_details'                            => 'Dettagli dell\'abbonamento',
    'generate_next_invoice'                           => 'Genera la fattura successiva',
    'subscription'                                    => 'Sottoscrizione',
    'of_the'                                          => 'Del',
    'on'                                              => 'SU',
    'invoice_month'                                   => 'Mese della fattura',
    'invoice_year'                                    => 'Anno della fattura',
    'next_month'                                      => 'Il prossimo mese',
    'next_year'                                       => 'L\'anno prossimo',
    'day'                                             => 'Giorno',
    'last_date'                                       => 'Ultimo appuntamento',
    'merge_record_warning'                            => 'Fermare! L\'unione degli account cliente non può essere annullata. Oltre ai campi che hai selezionato per sovrascrivere o aggiungere, tutta la cronologia delle transazioni per il client di unione verrà trasferita al client di unione. Sei sicuro di voler unire questi account cliente?',
    'merge_child_account_warning'                     => 'Il cliente Unisci (da) ha un account principale con account secondari correlati che verranno riassegnati al cliente Unisci (a). Assicurati che il cliente Unisci (a) sia consentito come account principale.',
    'merge_parent_account_warning'                    => 'L\'unione rimuoverà la tua associazione con l\'account genitore.',
    'merge_invoices_paid_by_warning'                  => 'L\'unione rimuoverà la tua associazione con la fattura principale pagata da.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'Il numero di relazioni nel modello Cliente è cambiato.',
    'payment_terms'                                   => 'Termini di pagamento',
    'net_amount_due_in'                               => 'Importo netto dovuto',
    'net_amount_due_by'                               => 'Importo netto dovuto da',
    'if_paid_within'                                  => 'se pagato entro',
    'if_paid_by'                                      => 'se pagato da',
    'th_of_next_month'                                => 'il mese prossimo',
    'of_next_month'                                   => 'del mese prossimo',
    'down_payment'                                    => 'Acconto',
    'balance_amount_due_of'                           => 'importo del saldo dovuto',
    'payment_split_over'                              => 'Pagamento ripartito',
    'installments'                                    => 'rate',
    'days_from_invoice_date'                          => 'giorni dalla data della fattura',
    'payment'                                         => 'Pagamento',
    'one'                                             => 'Uno',
    'two'                                             => 'Due',
    'three'                                           => 'Tre',
    'four'                                            => 'quattro',
    'five'                                            => 'Cinque',
    'six'                                             => 'Sei',
    'discount_percent'                                => 'Percentuale di sconto',
    'discount_days_simple'                            => 'Giorni di sconto semplici',
    'discount_days_nth'                               => 'Giorni di sconto Nesimo',
    'net_due_days'                                    => 'Giorni di scadenza netti',
    'balance_due_days'                                => 'Giorni di scadenza del saldo',
    'number_of_installments'                          => 'Numero di installazioni',
    'payment_term'                                    => 'Termine di pagamento',
    'select_payment_term'                             => 'Seleziona Termine di pagamento',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'Il campo Percentuale rata :index è obbligatorio ed è maggiore di zero.',
        'installment_due_days_error'                  => 'Il campo Giorni di scadenza rata :index è obbligatorio',
        'discount_percent_gt_error'                   => 'La percentuale di sconto inserita è obbligatoria ed è maggiore di zero.',
        'discount_percent_lt_error'                   => 'La percentuale di sconto inserita è obbligatoria e inferiore al 100%.',
        'down_payment_percent_lt_error'               => 'È richiesta la percentuale di acconto archiviata e inferiore al 100%.',
        'discount_percent_numeric_error'              => 'Il campo Percentuale sconto deve essere un valore numerico e inferiore al 100%.',
        'down_payment_gt_error'                       => 'L\'acconto depositato è obbligatorio e maggiore di zero.',
        'discount_days_gt_net_days_error'             => 'L\'importo netto dei giorni di scadenza deve essere maggiore dei giorni di sconto.',
        'discount_days_nth_gt_net_days_error'         => 'L\'importo netto dei giorni di scadenza deve essere maggiore dello sconto N-giorni.',
        'installment_due_days_gt_error'               => 'I giorni di scadenza della rata :index dovrebbero essere maggiori dei giorni di scadenza della rata :preIndex.',
        'installment_percent_total_error'             => 'La percentuale totale della rata non è precisa. dovrebbe essere pari al 100%.',
        'installment_percent_numeric_error'           => 'La percentuale totale della rata non è precisa. Dovrebbe essere un valore numerico.',
        'term_discount'                               => 'Sconto sul termine',
        'installment_due_days_gt_zero_error'          => 'I giorni di scadenza della rata :index devono essere maggiori o uguali a Zero.',
        'net_due_days_error'                          => 'L\'importo netto nei giorni di scadenza deve essere maggiore di zero e deve essere archiviato.',
        'discount_days_simple_error'                  => 'I giorni di sconto semplici devono essere maggiori di zero e devono essere archiviati.',
        'discount_days_nth_error'                     => 'Lo sconto N-esimi giorni deve essere maggiore di Zero e deve essere archiviato.',
        'balance_due_days_error'                      => 'I giorni di scadenza del saldo devono essere maggiori di zero e devono essere archiviati.',
        'status_error'                                => 'Siamo spiacenti, lo stato non è cambiato a causa del termine utilizzato nella fattura.',
        'down_payment_type_invoice_description_error' => 'Il token della descrizione della fattura inserito non corrisponde al tipo di acconto.',
        'down_payment_type_quote_description_error'   => 'Il token della descrizione del preventivo inserito non corrisponde al tipo di acconto.',
    ],
    'quotes_delete_error'                             => 'Le virgolette cancellano l\'errore',
    'for'                                             => 'Per',
    'production'                                      => 'Produzione',
    'access_token'                                    => 'Token di accesso',
    'application_id'                                  => 'ID applicazione',
    'location_id'                                     => 'Identificativo posizione',
    'fi_config_check'                                 => 'Controllo dei prerequisiti',
    'requirement'                                     => 'Requisiti',
    'required'                                        => 'Necessario',
    'actual'                                          => 'Effettivo',
    'result'                                          => 'Risultato',
    'db_prefix_setup_alert'                           => 'Il tuo database FusionInvoice utilizza i prefissi DB. Il supporto per i prefissi DB è terminato con la versione 2023-3.0. Per continuare l\'aggiornamento a questa e alle versioni future, è necessario rimuovere i prefissi DB. Puoi farlo rinominando tutte le tabelle nel tuo DB e rimuovendo il prefisso e impostando anche il valore \'prefix\' => \'\', nel tuo file database.php.',
    'open_tasks'                                      => 'Apri attività',
    'closed_tasks'                                    => 'Compiti chiusi',
    'select_status'                                   => 'Seleziona Stato',
    'net_amount_due_invoice'                          => 'Importo netto dovuto in :days giorni.',
    'days_add_in_current_date'                        => 'La data corrente, a partire da <span class="text-blue">:date</span> , e la data di scadenza, devono essere considerate come <span class="text-blue">:date</span>  <span class="text-danger">più</span> <span class="text-blue">il numero di giorni</span>.',
    'terms'                                           => 'Termini',
    'quote_rejecting_error'                           => 'La fattura n. :invoice_number è stata creata il :invoice_date dall\'approvazione di questo preventivo. È necessario eliminare o annullare questa fattura prima di rifiutare questo preventivo.',
    'resend_record_warning'                           => 'Inviare nuovamente questa email adesso?',
    'resend_email'                                    => 'Rinvia l\'e-mail',
    'requirement_check_fail'                          => 'Prima di poter continuare l\'installazione, è necessario correggere gli errori sopra indicati.',
    'failed'                                          => 'Fallito',
    'subscriptions'                                   => 'Abbonamenti',
    'tt_explanation'                                  => 'Inserisci una descrizione per il servizio con segnaposto di data opzionali. Puoi utilizzare i seguenti token per inserire dinamicamente le date di inizio e fine del servizio:{{service_starts_on}} e {{service_ends_on}}. Queste verranno sostituite con le date di inizio e fine effettive quando il contenuto viene visualizzato.',
    'tt_ss_invoices_default_payment_terms'            => 'Termini di pagamento predefiniti della fattura',
    'invoices_default_terms'                          => 'Termini predefiniti delle fatture',
    'net_amount_due_in_n_days'                        => 'Importo netto dovuto in N giorni',
    'last_day'                                        => 'Ultimo giorno',
    'down_payment_payment_term1'                      => 'Acconto di',
    'down_payment_payment_term2'                      => 'è obbligatorio.  Il saldo è dovuto',
    '1_type'                                          => 'Una fattura creata oggi scadrà tra <span class="text-primary">#N</span> giorni',
    '2_type'                                          => 'Una fattura creata oggi consentirà uno sconto se pagata entro il <span class="text-primary">#date</span> , in caso contrario, l\'intero importo dovrà essere pagato entro <span class="text-primary">#N</span>  giorni',
    '3_type'                                          => 'Una fattura creata oggi consentirà uno sconto se pagata entro il <span class="text-primary">#date</span>  . L\'importo netto è dovuto entro <span class="text-primary">#N</span>  giorni',
    '4_type'                                          => 'Una fattura creata oggi richiederà un acconto di <span class="text-primary">#amount</span>  . Il saldo residuo sarà dovuto entro <span class="text-primary">#N</span>  giorni',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>Una fattura creata oggi e suddivisa in <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Pagamento <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Scadenza <span class="text-primary">#date</span></p>',
    'installment'                                     => 'rata',
    'apply_payment_terms'                             => 'Applicare l\'importo dello sconto sui termini di pagamento',
    'payable_amount'                                  => 'Importo finale pagabile',
    'payable_amount_lt_error'                         => 'L\'importo finale da pagare deve essere inferiore al saldo della fattura.',
    'payment_term_type_4_amount'                      => 'Pagamento parziale di :amount accettato',
    'net_terms'                                       => 'Termini netti',
    'proforma_invoice_default'                        => 'Fattura proforma predefinita',
    'expense_vendor'                                  => 'Venditore di spese',
    'expense_vendor_deleted'                          => 'Il fornitore delle spese è stato eliminato',
    'expense_vendor_already_used'                     => 'Non è possibile eliminare un fornitore con voci di spesa correlate.',
    'total_must_be_gt_zero'                           => 'Il totale :modal_name deve essere maggiore di zero.',
    'payment_failed'                                  => 'Pagamento non riuscito con :error',
    'xss_validation'                                  => 'Il campo :attribute contiene tag che potrebbero esporre una vulnerabilità XSS',
    'support_desk'                                    => 'Banco di supporto',
    'choose_file'                                     => 'Scegli il file',
    'supportTicket'                                   => 'Banco di supporto',
    'create_support_ticket'                           => 'Crea ticket di supporto',
    'supportTicket_inbox_view'                        => 'Banco di supporto',
    'support_ticket'                                  => 'Biglietto di supporto',
    'ticket_number'                                   => 'Numero del biglietto',
    'revision'                                        => 'Revisione',
    'revisions'                                       => 'Revisioni',
    'recurring_invoices'                              => 'Fatture ricorrenti',
    'message'                                         => 'Messaggio',
    'custom_img'                                      => 'Immagine personalizzata',
    'please_fill_some_data'                           => 'Si prega di compilare i dati richiesti sul nuovo articolo.',
    'assigned'                                        => 'Assegnato',
    'add_ons_will_be_disabled'                        => 'I SEGUENTI ADD-ON SARANNO DISABILITATI:',
    'add_ons_will_be_disabled_msg'                    => 'Tutti i componenti aggiuntivi vengono automaticamente disabilitati durante un aggiornamento principale di FusionInvoice. Al termine dell\'aggiornamento, assicurati di scaricare i file zip aggiuntivi appropriati e di installarli. Dopo averlo fatto, puoi riattivarli dal menu Impostazioni di sistema, Personalizzazioni, Componenti aggiuntivi e selezionando [Installa].',
    'price_not_valid'                                 => 'Il prezzo deve essere maggiore di zero',
    'free_space'                                      => 'Spazio libero',
    'expense_type'                                    => 'Tipo di spesa',
    'standard_expense'                                => 'Spesa standard',
    'expense_with_deductible_tax'                     => 'Spese con imposta deducibile',
    'remittance_to_tax_authority'                     => 'Rimessa all\'autorità fiscale',
    'tax_paid'                                        => 'Tassa pagata',
    'tax_detail'                                      => 'Dettaglio fiscale',
    'select_expense_type'                             => 'Seleziona Tipo di spesa',
    'taxes_paid_on_expenses_or_remitted'              => 'Imposte pagate sulle spese o versate',
    'tax_name'                                        => 'Nome fiscale',
    'last_activity'                                   => 'L\'ultima attività',
    'select_default_company_profile'                  => 'Seleziona il profilo aziendale predefinito',
    'mn_sales_tax'                                    => 'Imposta sulle vendite del Minnesota',
    'taxes_collected_on_sales'                        => 'Imposte riscosse sulle vendite',
    'vatgst_tax_note'                                 => 'Sì calcola l\'imposta come inclusa nel totale dell\'articolo. No aggiungerà l\'imposta al totale dell\'articolo.',
    'tt_vatgst_tax'                                   => 'Per questo esempio, assumeremo un\'aliquota fiscale del 5% e un prezzo dell\'articolo di $ 100. Impostando Abilita IVA/GST su Sì, verrà generato un totale della fattura di $ 100, con l\'importo dell\'articolo modificato in $ 95,24 e un importo delle imposte di $ 4,76. Impostando IVA/GST su No, verrà generato un totale della fattura di $ 105, con un prezzo dell\'articolo di $ 100 e un\'imposta di $ 5.',
    'level_of_detail'                                 => 'Livello di dettaglio',
    'tax_report'                                      => 'Rapporto fiscale',
    'detail'                                          => 'Dettaglio',
    'totals'                                          => 'Totali',
    'totals_with_dots'                                => 'Totali. . .',
    'yes_all'                                         => 'Si a tutti)',
    'invoices_only'                                   => 'Solo fatture',
    'payment_receipts_only'                           => 'Solo ricevute di pagamento',
    'role'                                            => 'Ruolo',
    'previous_email'                                  => 'Email precedente',
    'web_store_user_id'                               => 'ID utente del negozio Web: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Importo netto dovuto entro il <span class="text-info">#LASTDATE</span>',
        '2_type'       => 'È possibile applicare uno sconto del #DISCOUNTPERCENT % se il pagamento avviene entro <span class="text-info">#DISCOUNTDATE</span> , altrimenti l\'importo netto è dovuto entro <span class="text-info">#LASTDATE</span> .',
        '3_type'       => 'È possibile applicare uno sconto del #DISCOUNTPERCENT % se il pagamento avviene entro <span class="text-info">#DISCOUNTDATE</span> , altrimenti l\'importo netto è dovuto entro <span class="text-info">#LASTDATE</span> .',
        '4_type'       => 'Un acconto di <span class="text-info">#DOWNPAYMENT</span>  è in data #INVOICEDATE . Il saldo è dovuto entro <span class="text-info">#LASTDATE</span> .',
        '5_type'       => '<p class="mt-2 mb-1">I pagamenti possono essere suddivisi in <span class="text-info">#NUMBEROFINSTALLMENTS</span> rate</p>',
        '5_1_type'     => '<li>Pagamento <span class="text-info">#PERCENT %</span> dovuto <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">Il mese prossimo ha un totale di #N giorni, quindi inserisci un valore compreso tra 1 e #N per lo sconto sui giorni del mese prossimo.</span>',
    ],
    'payment_term_not_selected'                       => 'Termine di pagamento non selezionato',
    'confirm'                                         => 'Confermare',
    'create_live_invoice_now'                         => 'Creare una fattura in tempo reale adesso?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Un abbonamento è come un modello di fattura che viene utilizzato per creare fatture in tempo reale con una determinata frequenza.</p><p class="m-0"> Normalmente un lavoro CRON o un\'attività pianificata è impostato per essere eseguito una volta al giorno ed è responsabile del controllo delle fatture in tempo reale che dovrebbero essere create, in base al campo della data Genera fattura successiva dell\'abbonamento.  Se il valore della data è oggi o è precedente a oggi, viene creata automaticamente una fattura in tempo reale.</p><p class="m-0"> Questa opzione ti consente di creare manualmente la fattura in tempo reale dall\'abbonamento, ignorando il metodo automatizzato . Desideri creare la fattura in tempo reale adesso?</p>',
    'contact'                                         => 'Contatto',
    'invoice_month_plus_one'                          => 'Mese fattura +1',
    'invoice_month_plus_two'                          => 'Mese fattura +2',
    'invoice_month_plus_three'                        => 'Mese fattura +3',
    'inbound_email'                                   => 'E-mail in entrata',
    'outbound_email'                                  => 'E-mail in uscita',
    'email_signature'                                 => 'Firma e-mail',
    'mail_credential_error'                           => 'Configurazione e-mail non valida. Verifica le impostazioni e riprova. <strong>( Configurazione <i class="fa fa-arrow-alt-circle-right"> </i> Impostazioni di sistema <i class="fa fa-arrow-alt-circle-right"> </i> Email )</strong>',
    'tt_generate_next_invoice'                        => 'La data in cui la prossima fattura attiva verrà creata automaticamente da questo abbonamento.',
    'tt_stop_date'                                    => 'La soglia della data dopo la quale non verranno più generate automaticamente fatture attive per questo abbonamento. Lascia questo campo vuoto per un abbonamento che dovrebbe durare per sempre.',
    'description_template'                            => 'Modello di descrizione',
    't_1_description'                                 => 'Il pagamento completo è dovuto entro il #LASTDATE.',
    't_2_description'                                 => 'Ottieni uno sconto del #DISCOUNTPERCENT % se pagato entro il #DISCOUNTDATE, altrimenti paga l\'intero importo della fattura entro #LASTDATE.',
    't_3_description'                                 => 'Ottieni uno sconto del #DISCOUNTPERCENT % se pagato entro il #DISCOUNTDATE, altrimenti paga l\'intero importo della fattura entro #LASTDATE.',
    't_4_description'                                 => 'Un acconto di #DOWNPAYMENT è dovuto il #INVOICEDATE, il saldo della fattura è dovuto entro #LASTDATE',
    't_4_1_description'                               => 'Un acconto del #DOWNPAYMENTPERCENT è dovuto il #INVOICEDATE, il saldo della fattura è dovuto entro #LASTDATE',
    't_5_description'                                 => 'I pagamenti devono essere effettuati in #NUMBEROFINSTALLMENTS rate uguali',
    't_5_type_description'                            => 'Il pagamento #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT deve essere effettuato il #LASTDATE',
    'tokens_allowed'                                  => 'Token ammessi',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'Il testo valutato dal modello è la descrizione dei termini mostrata su documenti come fatture, preventivi, ecc.',
    'cc_mail'                                         => 'CC-mail',
    'assigned_inv_sent_or_paid'                       => '*Ci sono fatture pagate o inviate a cui è assegnato questo termine di pagamento. Non è consentito modificare i dettagli del "Tipo".',
    'exclude_paid_invoices'                           => 'Escludi fatture pagate',
    'phone_number_numeric_error'                      => 'Il numero di telefono deve essere un numero.',
    'phone_num_same_country_code_error'               => 'Assicurati che il tuo numero di telefono sia formattato correttamente. Sembra che sia stato inserito iniziando con il codice del paese, cosa non consentita.',
    'tt_expense_amount'                               => 'Inserisci l\'importo totale della spesa, tasse incluse. Questo campo non è disponibile quando si rimette un pagamento fiscale a un\'autorità fiscale.',
    'tt_expense_tax_paid_deductible'                  => 'Inserisci l\'importo dell\'imposta pagata con questa spesa. Questo valore verrà detratto dal debito fiscale complessivo nei report Riepilogo imposte e Dettagli imposte.',
    'tt_expense_tax_paid_remittance'                  => 'Immettere l\'importo dell\'imposta versata all\'autorità fiscale. Viene utilizzato per registrare i pagamenti effettuati per le imposte riscosse sulle fatture pagate.',
    'tt_expense_client'                               => 'Se questa spesa è stata sostenuta esclusivamente per conto di un cliente e desideri fatturargliela, seleziona qui il cliente correlato.',
    'base_currency_not_deleted'                       => 'La valuta di base non può essere eliminata',
    'used_currency_modal_error'                       => 'Valuta già utilizzata nel modulo :modal_names.',
    'addon_uninstall_success'                         => 'Componente aggiuntivo disinstallato correttamente',
    'original'                                        => 'Originale',
    'revision_current'                                => 'Revisione(attuale)',
    'number'                                          => 'Numero',
    'copy_process_error'                              => 'Ops! Sembra che si sia verificato un intoppo durante il processo di copia. Per favore riprova più tardi.',
    'tt_captcha_image'                                => 'Immagine CAPTCHA',
    'reload_page'                                     => 'Per favore ricarica la pagina',
    'discount_limit'                                  => 'Lo sconto deve essere inferiore al 99,99%.',
    'tooltip'                                         => 'Descrizione comando',
    'authorization_error'                             => 'Non sei autorizzato a eseguire questa operazione.',
    'reset_to_default'                                => 'Riportare alle condizioni originali',
    'reset_to_default_warning'                        => '<p>Ciò ripristinerà Oggetto e Corpo al valore predefinito per :model . Continua?</p>',
    'reset_default_mail_template'                     => 'Il modello di posta predefinito per :model è stato reimpostato con successo.',
    'overdue_invoice'                                 => 'Fattura scaduta',
    'total_cannot_be_lt_zero'                         => 'Il totale di :modal_name non può essere inferiore a zero.',
    'addons_disabled_during_setup'                    => 'Durante il processo di aggiornamento sono stati disabilitati i seguenti componenti aggiuntivi: :addons . Non dimenticare di abilitarli ora che l\'aggiornamento è completo.',
    'allow_payments_on_quotes'                        => 'Consenti pagamenti sui preventivi S/N',
    'allow_payments_on_quote'                         => 'Consenti pagamento S/N',
    'tt_ss_quotes_is_payable'                         => 'Se abilitato, dopo l\'approvazione del preventivo, verrà visualizzato un pulsante Paga adesso nella visualizzazione del collegamento pubblico del preventivo. Verrà creata automaticamente una fattura e il pagamento verrà applicato alla fattura.',
    'pay_with_square'                                 => 'Paga con Square',
    'validation_mess_for_is_payable_quote'            => 'L\'impostazione Converti automaticamente il preventivo in fattura quando il cliente lo approva è necessaria quando Consenti pagamenti sui preventivi è impostato su "Sì".',
    'client_requirement_msg'                          => 'Crea un client prima di aggiungere :seed_name',
    'quote_add_items'                                 => 'Elementi del preventivo richiesti e stato non annullato',
    'invalid_quote_id'                                => 'ID preventivo non valido',
    'information_header'                              => 'Congratulazioni, stai per risparmiare un po\' di soldi!',
    'convenience_charge'                              => 'Tassa di convenienza',
    'credit_card_fee_message'                         => 'Su questa transazione verrà applicata una commissione di convenienza sulla carta di credito pari a :charge.',
    'info_payment_term_type_2'                        => 'Anche se il saldo della tua fattura è :ORIGINAL_AMOUNT, hai diritto a uno sconto sui termini di pagamento del :DISCOUNT_PERCENT %, che ridurrà l\'importo del pagamento a :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Anche se il saldo della tua fattura è :ORIGINAL_AMOUNT, hai diritto a uno sconto sui termini di pagamento del :DISCOUNT_PERCENT %, che ridurrà l\'importo del pagamento a :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Sebbene il saldo della tua fattura sia :ORIGINAL_AMOUNT, hai diritto, in base ai termini di pagamento, a versare un acconto :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Sebbene il saldo della tua fattura sia :ORIGINAL_AMOUNT, hai diritto ai termini di pagamento per effettuare un pagamento rateale :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'I Termini di pagamento devono essere rimossi dal :modal prima della cancellazione.',
    'default_payment_term_warn'                       => '*Puoi modificare solo il nome e i giorni di scadenza netti per i <strong>Termini di pagamento predefiniti del sistema</strong>.',
    'quote_rejected_not_payable'                      => 'Il preventivo # :number è stato rifiutato e non è pagabile a causa del suo stato.',
    'could_not_delete'                                => 'Impossibile eliminare',
    'convenience_charges_calculation_fail'            => 'Errore: il calcolo dei costi aggiuntivi non è riuscito durante la migrazione. Per favore riprova più tardi.',
    'sign_in_welcome_message'                         => 'ðŸš€ Congratulazioni! La tua FusionInvoice è stata installata con successo! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>Il tuo FusionInvoice è stato aggiornato con successo dalla versione :old_version alla versione :new_version .</p><p> Per una panoramica dettagliata di tutte le nuove funzionalità e miglioramenti, consulta le nostre <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Note di rilascio</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Grazie per aver scelto FusionInvoice. La tua fiducia, il tuo supporto e il tuo feedback guidano la nostra innovazione.</p><p class="m-0 text-bold">Buona fatturazione!</p><p class="text-bold">Il team di FusionInvoice</p >',
    'tt_gen_skin_user_profile'                        => 'La modifica di questo valore imposta il valore predefinito del sistema SOLO per i nuovi utenti. Gli utenti possono ignorare questa impostazione tramite le impostazioni del proprio profilo utente.',
    'description_template_invoice'                    => 'Modello di descrizione: fattura',
    'description_template_quote'                      => 'Modello di descrizione - Preventivo',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Il pagamento completo è dovuto entro #NETDAYS dalla data della fattura.',
    't_2_description_for_quote'                       => 'Ottieni uno sconto del #DISCOUNTPERCENT % se pagato entro #DISCOUNTDAYS, altrimenti paga l\'intero importo del preventivo entro #NETDAYS.',
    't_3_description_for_quote'                       => 'Ottieni uno sconto del #DISCOUNTPERCENT % se paghi entro il #NTHDAY del mese successivo, altrimenti paga l\'intero importo della fattura entro #NETDAYS giorni.',
    't_4_description_for_quote'                       => 'Un acconto di #DOWNPAYMENT è dovuto alla data della fattura, il saldo rimanente è dovuto entro #NETDAYS giorni',
    't_4_1_description_for_quote'                     => 'Un acconto del #DOWNPAYMENTPERCENT è dovuto alla data della fattura, il saldo rimanente è dovuto entro #NETDAYS giorni',
    't_5_description_for_quote'                       => 'I pagamenti devono essere effettuati in #NUMBEROFINSTALLMENTS rate uguali',
    't_5_type_description_for_quote'                  => 'Il pagamento #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT deve essere effettuato #INSTALLMENTDUEDAYS giorni dalla data della fattura',
    'default_term'                                    => 'Termine predefinito',
    'proceed_to_payment'                              => 'Procedere al pagamento',
    'version_upgraded'                                => 'La tua applicazione è aggiornata.',
    'term_amount_gt_payment_amount'                   => 'L\'importo deve essere maggiore dell\'importo dello sconto sui termini di pagamento',
    'payment_term_not_eligible_warning'               => 'Lo sconto sul termine di pagamento è disponibile solo per i pagamenti completi. Sfortunatamente, non ne hai i requisiti.',
    'processed_by_user'                               => '<strong>Elaborato da:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Metodo di pagamento:</strong> :method',
    'all_methods'                                     => 'Tutti i metodi',
    'this_payment'                                    => 'Questo pagamento',
    'previous_balance'                                => 'Saldo precedente',
    'payment_applied_with_remaining_balance'          => '<p><strong>Il tuo pagamento di :amount è stato parzialmente applicato. :remaining_balance rimane in sospeso.</strong></p>',
    'pre_payment_received'                            => '<p><strong>È stato ricevuto un pagamento anticipato di :amount per fatture future in :date .</strong></p>',
    'payment_full_applied'                            => '<p><strong>Il tuo pagamento :amount è stato interamente applicato.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Pagamento <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;"> :formatted_number</span> ~ Dettagli:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>Il pagamento di :paid è stato applicato alla fattura :invoice_number il :date</span> ~',
    'payment_full_applied_on_inv_with_ptd'            => '<p>Il pagamento di :paid, meno :payment_terms_discount sconto sul termine di pagamento è stato applicato alla fattura :invoice_number in data :date</span> ~',
    'payment_full_applied_on_inv_with_cc'             => '<p>Il pagamento di :paid, più :convenience_charges spese di servizio, è stato applicato alla fattura :invoice_number in data :date</span> ~',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>Il pagamento di :paid, più :convenience_charges spese di comodo e meno :payment_terms_discount sconto sul termine di pagamento, è stato applicato alla fattura :invoice_number in :date</span> ~',
    'payment_remaining_balance_mail_message'          => '<p>Il saldo rimanente della fattura :invoice_number è :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Fatture non pagate',
    'include'                                         => 'Includere',
    'exclude'                                         => 'Escludere',
    'invoice_with_no_tax'                             => 'Fatture senza tasse',
    'tax_total'                                       => 'Totale imposte',
];

return TranslationOverride::override(__FILE__, $translations);
