<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4 (21 x 29,7 cm)',
    'account_setup'                                   => 'Paramètres du compte',
    'active'                                          => 'Actif',
    'activity'                                        => 'Activité',
    'activity_invoice_paid'                           => 'La facture <a href=":link">:number</a> a été payée.',
    'activity_invoice_viewed'                         => 'La facture <a href=":link">:number</a> a été consultée.',
    'activity_quote_approved'                         => 'Le devis <a href=":link">:number</a> a été approuvé.',
    'activity_quote_rejected'                         => 'Le devis <a href=":link">:number</a> a été rejeté.',
    'activity_quote_viewed'                           => 'Le devis <a href=":link">:number</a> a été consulté.',
    'add_item'                                        => 'Ajouter une ligne',
    'add_line_item_to_invoice'                        => 'Ajouter une ligne à la facture',
    'add_note'                                        => 'Ajouter une note',
    'additional'                                      => 'Additionel',
    'addon'                                           => 'Extension',
    'addons'                                          => 'Extensions',
    'address'                                         => 'Adresse postale',
    'address_format'                                  => 'Formatage des adresses postales',
    'after_amount'                                    => 'Après les montants',
    'all'                                             => 'Tous',
    'all_categories'                                  => 'Toutes les catégories',
    'all_statuses'                                    => 'Tous les statuts',
    'all_time'                                        => 'Toutes les factures',
    'all_vendors'                                     => 'Tous les vendeurs',
    'allow_login'                                     => 'Autoriser la connexion',
    'always_attach_pdf'                               => 'Toujours joindre le PDF',
    'always_bcc'                                      => 'Toujours ajouter cet email en CCI',
    'always_cc'                                       => 'Toujours ajouter cet email en CC',
    'amount'                                          => 'Montant',
    'api_public_key'                                  => 'Clé API publique',
    'api_secret_key'                                  => 'Clé API secrète',
    'approve'                                         => 'Approuver',
    'approved'                                        => 'Approuvé',
    'approved_quotes'                                 => 'Devis approuvés',
    'attach_files'                                    => 'Joindre un fichier',
    'attach_pdf'                                      => 'Joindre le PDF',
    'attachment'                                      => 'Pièce jointe',
    'attachments'                                     => 'Pièces jointes',
    'author'                                          => 'Auteur',
    'automatic'                                       => 'Automatique',
    'automatic_email_on_recur'                        => 'Envoi automatisé des factures récurrentes par email',
    'automatic_email_payment_receipts'                => 'Envoi automatisé des reçus de paiement par email',
    'available_fields'                                => 'Liste des champs disponibles',
    'back'                                            => 'Retour',
    'back_to_invoice'                                 => 'Retour à la facture',
    'back_to_quote'                                   => 'Retour au devis',
    'balance'                                         => 'Solde',
    'base_currency'                                   => 'Devise utilisée par défaut',
    'bcc'                                             => 'CCI',
    'before_amount'                                   => 'Avant les montants',
    'bill_this_expense'                               => 'Facturer cette dépense',
    'bill_to'                                         => 'Facturé à',
    'billable'                                        => 'Facturable',
    'billed'                                          => 'Facturé',
    'billing_address'                                 => 'Adresse postale',
    'billing_city'                                    => 'Ville',
    'billing_name'                                    => 'Nom du client',
    'billing_state'                                   => 'État',
    'billing_zip'                                     => 'Code postal',
    'binary_path'                                     => 'Chemin binaire',
    'body'                                            => 'Texte',
    'cancel'                                          => 'Annuler',
    'canceled'                                        => 'Annulé',
    'card_number'                                     => 'Numéro de carte',
    'cash'                                            => 'Espèces',
    'category'                                        => 'Catégorie',
    'cc'                                              => 'CC',
    'change'                                          => 'Modifier',
    'change_client'                                   => 'Changer de client',
    'check_for_update'                                => 'Vérifier les mises à jour',
    'city'                                            => 'Ville',
    'clear_keys'                                      => 'Effacer les clés',
    'client'                                          => 'Client',
    'client_form'                                     => 'Édition d\'une fiche client',
    'client_name'                                     => 'Nom du client',
    'client_not_found'                                => 'Client introuvable',
    'client_statement'                                => 'Relevé par client',
    'client_unique_name_option_1'                     => 'Seulement lorsque le nom du client n\'est pas unique',
    'client_unique_name_option_2'                     => 'Toujours',
    'client_visibility'                               => 'Visibilité client',
    'clients'                                         => 'Clients',
    'code'                                            => 'Code',
    'column_name'                                     => 'Nom de la colonne',
    'column_width'                                    => 'Largeur du widget',
    'company'                                         => 'Société',
    'complete'                                        => 'Compléter',
    'complete_upgrade'                                => 'Mise à jour terminée',
    'compound'                                        => 'Composée',
    'compound_tax_note'                               => 'Les taxes composées doivent être appliquées sur les articles en tant que seconde taxe pour que le calcul combiné soit correct.',
    'confirm_approve_quote'                           => 'Êtes-vous sûr de vouloir approuver ce devis ?',
    'confirm_reject_quote'                            => 'Êtes-vous sûr de vouloir rejeter ce devis ?',
    'continue'                                        => 'Continuer',
    'convert_quote_option1'                           => 'La facture doit récupérer les conditions générales du devis',
    'convert_quote_option2'                           => 'La facture doit récupérer les conditions générales par défaut',
    'convert_quote_setting'                           => 'Quand un devis est converti en facture',
    'convert_quote_when_approved'                     => 'Convertir automatiquement un devis en facture lorsque le client l\'a approuvé',
    'converted_from_quote'                            => 'Converti depuis le devis',
    'converted_to_invoice'                            => 'Converti depuis la facture',
    'country'                                         => 'Pays',
    'create_invoice'                                  => 'Créer une facture',
    'create_quote'                                    => 'Créer un devis',
    'created'                                         => 'Créé',
    'credit_card'                                     => 'Carte bancaire',
    'currencies'                                      => 'Devises',
    'currency'                                        => 'Devise',
    'currency_form'                                   => 'Édition d\'une devise',
    'currency_symbol'                                 => 'Symbole monétaire',
    'currency_symbol_placement'                       => 'Emplacement du symbole monétaire',
    'custom_date_range'                               => 'Plage de dates personnalisée',
    'custom_field_form'                               => 'Édition d\'un champ personnalisé',
    'custom_fields'                                   => 'Champs personnalisés',
    'cvc'                                             => 'Cryptogramme visuel',
    'dashboard'                                       => 'Tableau de bord',
    'dashboard_totals_option'                         => 'Les totaux du tableau de bord doivent inclure',
    'database_not_configured'                         => 'Il semblerait que votre fichier app/config/database.php ne soit pas configuré.',
    'database_setup'                                  => 'Paramètres de la base de données',
    'date'                                            => 'Date',
    'date_format'                                     => 'Formatage des dates',
    'days'                                            => 'Jours',
    'decimal_point'                                   => 'Séparateur décimal',
    'default_currency'                                => 'Devise utilisée par défaut',
    'default_footer'                                  => 'Pied de page par défaut',
    'default_group'                                   => 'Groupe par défaut',
    'default_invoice_email_body'                      => 'Email par défaut pour l\'envoi des factures',
    'default_invoice_template'                        => 'Modèle de facture par défaut',
    'default_item_tax_2_rate'                         => 'Taxe 2 par défaut',
    'default_item_tax_rate'                           => 'Taxe par défaut pour les articles',
    'default_overdue_invoice_email_body'              => 'Email par défaut pour l\'envoi des relances de factures impayées',
    'default_payment_receipt_body'                    => 'Email par défaut pour l\'envoi des reçus de paiement',
    'default_quote_email_body'                        => 'Email par défaut pour l\'envoi des devis',
    'default_quote_template'                          => 'Modèle de devis par défaut',
    'default_terms'                                   => 'Conditions générales par défaut',
    'delete'                                          => 'Supprimer',
    'delete_client_warning'                           => 'Si vous supprimez ce client, vous supprimerez également les factures, devis et paiements attachés. Êtes-vous sûr de vouloir supprimer ce client ?',
    'delete_record_warning'                           => 'Êtes-vous sûr de vouloir supprimer cet enregistrement ?',
    'description'                                     => 'Description',
    'details'                                         => 'Détails',
    'disabled'                                        => 'Désactivé',
    'discount'                                        => 'Remise',
    'display_client_unique_name'                      => 'Afficher le nom unique du client',
    'display_do_not_require'                          => 'Champ affiché mais pas obligatoire',
    'display_order'                                   => 'Ordre d\'affichage',
    'display_profile_image'                           => 'Afficher l\'image de profil dans la barre latérale',
    'do_not_add_line_item_to_invoice'                 => 'N\'ajouter aucun article à la facture',
    'do_not_display'                                  => 'Ne pas afficher ce champ',
    'documentation'                                   => 'Documentation',
    'download'                                        => 'Télécharger',
    'draft'                                           => 'Brouillon',
    'draft_invoices'                                  => 'Brouillons de facture',
    'draft_quotes'                                    => 'Brouillons de devis',
    'dropdown'                                        => 'Liste déroulante',
    'due'                                             => 'Échéance',
    'due_date'                                        => 'Date d\'échéance',
    'edit'                                            => 'Éditer',
    'edit_client'                                     => 'Éditer client',
    'email'                                           => 'Email',
    'email_address'                                   => 'Adresse email',
    'email_invoice'                                   => 'Envoyer la facture',
    'email_payment_receipt'                           => 'Envoyer le reçu du paiement par email',
    'email_quote'                                     => 'Envoyer le devis',
    'email_send_method'                               => 'Méthode d\'envoi des emails',
    'email_send_method_phpmail'                       => 'PHP Mail',
    'email_send_method_sendmail'                      => 'Sendmail',
    'email_send_method_sendgrid'                      => 'API SendGrid',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Activé',
    'enter_payment'                                   => 'Saisir un paiement',
    'error'                                           => 'Erreur',
    'every'                                           => 'Fréquence',
    'exchange_rate'                                   => 'Taux de change',
    'exchange_rate_mode'                              => 'Mode du taux de change',
    'expense_form'                                    => 'Édition d\'une dépense',
    'expenses'                                        => 'Dépenses',
    'expiration'                                      => 'Date d\'expiration',
    'expires'                                         => 'Valable jusqu\'au',
    'export_clients'                                  => 'Exporter la liste des clients',
    'export_data'                                     => 'Exporter des données',
    'export_expenses'                                 => 'Exporter la liste des dépenses',
    'export_invoice_items'                            => 'Exporter la liste des articles facturés',
    'export_invoices'                                 => 'Exporter la liste des factures',
    'export_payments'                                 => 'Exporter la liste des paiements',
    'export_quote_items'                              => 'Exporter la liste des articles devisés',
    'export_quotes'                                   => 'Exporter la liste des devis',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Fax',
    'field_label'                                     => 'Intitulé du champ',
    'field_meta'                                      => 'Champ meta',
    'field_meta_description'                          => 'Utilisez le champ meta uniquement si le type de champ est une liste déroulante. Pour renseigner des valeurs aux listes, saisissez une suite d\'entrées séparées par des virgules.',
    'field_type'                                      => 'Type de champ',
    'footer'                                          => 'Pied de page',
    'format'                                          => 'Format',
    'frequency'                                       => 'Fréquence',
    'from'                                            => 'Émetteur',
    'from_date'                                       => 'Depuis le',
    'general'                                         => 'Général',
    'generate_keys'                                   => 'Générer les clés',
    'group'                                           => 'Groupe',
    'group_form'                                      => 'Édition d\'un groupe',
    'groups'                                          => 'Regroupements',
    'header_title_text'                               => 'Titre de l\'application',
    'help'                                            => 'Aide',
    'help_currency_code'                              => 'Code de la devise (ex : "EUR")',
    'help_currency_name'                              => 'Nom de la devise (ex : "Euro")',
    'help_currency_symbol'                            => 'Symbole de la devise (ex : "€")',
    'help_currency_symbol_placement'                  => 'Où placer le symbole monétaire.',
    'help_text_client_name'                           => 'Ce champ doit contenir le nom de votre client tel qu\'il doit apparaître sur vos devis et factures.',
    'help_text_client_password'                       => 'Laissez ce champ vide sauf si vous souhaitez créer ou modifier le mot de passe.',
    'help_text_client_unique_name'                    => 'Lorsque plusieurs de vos clients ont le même nom, le nom unique vous permettra de les différencier. Ce nom n\'apparaît pas sur les devis et factures.',
    'i_accept'                                        => 'J\'accepte',
    'import_data'                                     => 'Importer des données',
    'inactive'                                        => 'Inactif',
    'income'                                          => 'Revenu',
    'install'                                         => 'Installer',
    'installation_complete'                           => 'Installation terminée',
    'installing_please_wait'                          => 'Installation en cours, veuillez patienter...',
    'invalid_credentials'                             => 'Identifiant ou mot de passe incorrect',
    'invoice'                                         => 'Facture',
    'invoice_default'                                 => 'Facture par défaut',
    'invoice_email_subject'                           => 'Objet des emails pour l\'envoi des factures',
    'invoice_items'                                   => 'Articles facturés',
    'invoice_number'                                  => 'Numéro de facture',
    'invoice_summary'                                 => 'Factures',
    'invoiced'                                        => 'Facturé',
    'invoices'                                        => 'Factures',
    'invoices_due_after'                              => 'Échéance des factures (en jours)',
    'issued'                                          => 'Émis le',
    'item'                                            => 'Article',
    'item_lookup_form'                                => 'Édition d\'un article générique',
    'item_lookups'                                    => 'Articles génériques',
    'item_sales'                                      => 'Articles vendus',
    'items'                                           => 'Articles',
    'label_invoice'                                   => 'Choisir la facture à laquelle associer cette dépense',
    'label_item_description'                          => 'Indiquer une description pour cette dépense (optionnel)',
    'label_item_name'                                 => 'Saisir le nom de l\'article à ajouter à la facture',
    'landscape'                                       => 'Paysage',
    'language'                                        => 'Langue',
    'left_pad'                                        => 'Nombre de zéros avant',
    'left_pad_description'                            => 'Nombre optionnel de zéros qui doivent précéder la valeur.',
    'legal'                                           => 'Legal (8,5 x 14 pouces)',
    'letter'                                          => 'Letter (8,5 x 11 pouces)',
    'license_agreement'                               => 'Licence d\'utilisation',
    'license_agreement_accept'                        => 'J\'accepte les termes de la licence d\'utilisation',
    'logo'                                            => 'Logo',
    'mail_hash_error'                                 => 'Il semblerait que votre clé secrète ait été modifiée depuis le dernier enregistrement de votre mot de passe. Pour corriger cette erreur, rendez-vous dans Réglages -> onglet Email, re-saisissez votre mot de passe puis enregistrez. Aucun email ne pourra être envoyé tant que cela n\'aura pas été corrigé.',
    'manual'                                          => 'Manuel',
    'map_fields_to_import'                            => 'Ensemble de champs à importer',
    'merchant_api_key'                                => 'Clé API',
    'merchant_api_password'                           => 'Mot de passe API',
    'merchant_api_username'                           => 'Identifiant API',
    'merchant_publishable_key'                        => 'Clé publique',
    'merchant_secret_key'                             => 'Clé secrète',
    'merchant_signature'                              => 'Signature',
    'mobile'                                          => 'Mobile',
    'mobile_number'                                   => 'Mobile',
    'monthly'                                         => 'Chaque mois',
    'months'                                          => 'Mois',
    'multiple_email_validation'                       => 'Les adresses emails doivent être valides et séparées par des virgules.',
    'name'                                            => 'Nom',
    'net_income'                                      => 'Revenu net',
    'never'                                           => 'Jamais',
    'new'                                             => 'Nouveau',
    'next_date'                                       => 'Prochaine date',
    'next_number'                                     => 'Prochain numéro',
    'no'                                              => 'Non',
    'no_open_invoices'                                => 'Aucune facture n\'est associée à ce client. Pour pouvoir facturer une dépense, une facture (non réglée en totalité) doit être associée à ce client.',
    'no_records_found'                                => 'Aucun enregistrement trouvé.',
    'none'                                            => 'Aucun',
    'not_billable'                                    => 'Non facturable',
    'not_billed'                                      => 'Non facturé',
    'not_viewed'                                      => 'Non consulté',
    'not_visible'                                     => 'Non visible',
    'note'                                            => 'Note',
    'note_notification'                               => 'Notification : Nouvelle note',
    'notes'                                           => 'Notes',
    'online_payment'                                  => 'Paiement en ligne',
    'online_payment_method'                           => 'Choix du moyen de paiement en ligne',
    'online_payments'                                 => 'Moyens de paiement en ligne',
    'options'                                         => 'Options',
    'other'                                           => 'Autre',
    'output_type'                                     => 'Type de sortie',
    'overdue'                                         => 'Échue',
    'overdue_email_subject'                           => 'Objet des emails pour l\'envoi des relances de factures impayées',
    'overdue_invoice_reminder'                        => 'Relance de facture échue',
    'overdue_invoice_reminder_frequency'              => 'Fréquence des relances pour les factures échues',
    'overdue_invoice_reminder_frequency_help'         => 'Liste séparée par des virgules du nombre de jours à attendre après la date d\'échéance d\'une facture pour envoyer les relances. Laissez ce champ vide pour désactiver les relances sur les factures échues. Par exemple, en saisissant « 1,5,10 », une relance sera envoyée 1, 5 et 10 jours après la date d\'échéance de la facture.',
    'overdue_invoices'                                => 'Factures échues',
    'paid'                                            => 'Payé',
    'paper_orientation'                               => 'Orientation du papier',
    'paper_size'                                      => 'Format de la page',
    'password'                                        => 'Mot de passe',
    'password_confirmation'                           => 'Confirmation du mot de passe',
    'password_successfully_reset'                     => 'Mot de passe réinitialisé avec succès',
    'pay'                                             => 'Payer',
    'pay_now'                                         => 'Payer maintenant',
    'payment_applied'                                 => 'Votre paiement a été enregistré',
    'payment_button_text'                             => 'Texte du bouton de paiement',
    'payment_date'                                    => 'Date de paiement',
    'payment_form'                                    => 'Édition d\'un paiement',
    'payment_method'                                  => 'Moyen de paiement',
    'payment_method_form'                             => 'Édition d\'un moyen de paiement',
    'payment_methods'                                 => 'Moyens de paiement',
    'payment_receipt'                                 => 'Reçu de paiement',
    'payment_receipt_email_subject'                   => 'Objet des emails pour l\'envoi des reçus de paiement',
    'payments'                                        => 'Paiements',
    'payments_collected'                              => 'Paiements reçus',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'Pilote PDF',
    'pdf_driver_wkhtmltopdf'                          => 'Le champ Binary Path doit contenir un chemin de fichier valide lors de l\'utilisation du pilote wkhtmltopdf PDF.',
    'percent'                                         => 'Pourcentage',
    'phone'                                           => 'Téléphone',
    'phone_number'                                    => 'Téléphone',
    'php_version_error'                               => 'Votre version de PHP ne satisfait pas aux prérequis (%s)',
    'placeholder_type_message'                        => 'Saisissez votre message...',
    'portrait'                                        => 'Portrait',
    'postal_code'                                     => 'Code postal',
    'prefix'                                          => 'Préfixe',
    'prerequisites'                                   => 'Prérequis',
    'preview'                                         => 'Aperçu',
    'price'                                           => 'Prix unitaire',
    'private'                                         => 'Privé',
    'problem_with_email_template'                     => 'Il semble y avoir un problème avec le modèle de courrier électronique. Merci de vérifier vos modèles depuis le menu Réglages -> onglet Email.',
    'product'                                         => 'Article',
    'profit_and_loss'                                 => 'Pertes et profits',
    'public'                                          => 'URL publique',
    'qty'                                             => 'Qté',
    'quantity'                                        => 'Quantité',
    'quantity_price_decimals'                         => 'Nombre de décimales pour les quantités et montants',
    'quote'                                           => 'Devis',
    'quote_approved'                                  => 'Devis approuvé',
    'quote_approved_email_body'                       => 'Email par défaut lorsqu\'un devis est approuvé',
    'quote_default'                                   => 'Devis par défaut',
    'quote_email_subject'                             => 'Objet des emails pour l\'envoi des devis',
    'quote_items'                                     => 'Articles devisés',
    'quote_number'                                    => 'Numéro du devis',
    'quote_rejected'                                  => 'Devis rejeté',
    'quote_rejected_email_body'                       => 'Email par défaut lorsqu\'un devis est rejeté',
    'quote_status_change_notification'                => 'Notification: Quote Status Change',
    'quote_summary'                                   => 'Devis',
    'quote_to_invoice'                                => 'Devis en facture',
    'quotes'                                          => 'Devis',
    'quotes_expire_after'                             => 'Durée de validité des devis (en jours)',
    'recalculate'                                     => 'Recalculer',
    'recalculate_help_text'                           => 'Le recalcul peut prendre du temps. Un message apparaîtra lorsque le processus sera terminé.',
    'recalculate_invoices'                            => 'Recalculer les factures',
    'recalculate_quotes'                              => 'Recalculer les devis',
    'recalculating_wait'                              => 'Recalcul en cours, merci de patienter...',
    'recalculation_complete'                          => 'Recalcul terminé',
    'recent_invoices'                                 => 'Factures récentes',
    'recent_payments'                                 => 'Paiements récents',
    'recent_quotes'                                   => 'Devis récents',
    'record_not_found'                                => 'Enregistrement non trouvé',
    'record_successfully_created'                     => 'Enregistrement créé avec succès',
    'record_successfully_deleted'                     => 'Enregistrement supprimé avec succès',
    'record_successfully_updated'                     => 'Enregistrement mis à jour avec succès',
    'records_imported_successfully'                   => 'Enregistrement importé avec succès',
    'recurring'                                       => 'Récurrence',
    'reject'                                          => 'Rejeter',
    'rejected'                                        => 'Rejeté',
    'rejected_quotes'                                 => 'Devis rejetés',
    'remember_me'                                     => 'Se souvenir de moi',
    'remove_logo'                                     => 'Supprimer le logo',
    'report_rev_client_notice'                        => 'Ce relevé sera disponible dès que vous aurez des paiements entrés dans le système.',
    'reports'                                         => 'Rapports',
    'require'                                         => 'Champ obligatoire',
    'reset_number'                                    => 'Réinitialiser la numérotation',
    'reset_password'                                  => 'Réinitialiser le mot de passe',
    'results_per_page'                                => 'Nombre de résultats par page',
    'revenue_by_client'                               => 'CA par client',
    'round_tax_decimals'                              => 'Nombre de décimales pour les taxes',
    'run_report'                                      => 'Générer le rapport',
    'save'                                            => 'Enregistrer',
    'save_and_apply_exchange_rate'                    => 'Enregistrer et appliquer le taux de change',
    'save_item_as_lookup'                             => 'Sauvegarder l\'article comme générique',
    'search'                                          => 'Rechercher',
    'select_file_to_import'                           => 'Choix du fichier à importer :',
    'send'                                            => 'Envoyer',
    'sending'                                         => 'Envoi en cours',
    'sendmail_path'                                   => 'Sendmail Path',
    'sent'                                            => 'Envoyé',
    'sent_invoices'                                   => 'Factures envoyées',
    'sent_quotes'                                     => 'Devis envoyés',
    'settings'                                        => 'Paramètres',
    'settings_successfully_saved'                     => 'Paramètres enregistrés avec succès',
    'setup'                                           => 'Installation',
    'sign_in'                                         => 'Connexion',
    'sign_out'                                        => 'Déconnexion',
    'skin'                                            => 'Thème',
    'smtp_encryption'                                 => 'Type d\'encryptage SMTP',
    'smtp_host_address'                               => 'Adresse de l\'hôte SMTP',
    'smtp_host_port'                                  => 'Port de l\'hôte SMTP',
    'smtp_password'                                   => 'Mot de passe SMTP',
    'smtp_username'                                   => 'Utilisateur SMTP',
    'start_date'                                      => 'Date début',
    'state'                                           => 'État',
    'status'                                          => 'Statut',
    'step_database_setup'                             => 'Cette étape installera et mettra à niveau les tables de votre base de données. Cela peut nécessiter un certain laps de temps.',
    'step_prerequisites'                              => 'Les prérequis suivants doivent être résolus pour permettre la poursuite de l\'installation :',
    'subject'                                         => 'Objet',
    'submit'                                          => 'Envoyer',
    'subtotal'                                        => 'Sous-total HT',
    'summary'                                         => 'Résumé',
    'symbol'                                          => 'Symbole monétaire',
    'symbol_placement'                                => 'Position du symbole monétaire',
    'system'                                          => 'Système',
    'system_settings'                                 => 'Réglages',
    'table_name'                                      => 'Nom de la table',
    'tax'                                             => 'Taxe',
    'tax_1'                                           => 'Taxe 1',
    'tax_2'                                           => 'Taxe 2',
    'tax_rate'                                        => 'Taux de taxe',
    'tax_rate_form'                                   => 'Édition du taux de taxe',
    'tax_rate_name'                                   => 'Désignation du taux de taxe',
    'tax_rate_percent'                                => 'Pourcentage de taux de taxe',
    'tax_rates'                                       => 'Taux de taxe',
    'tax_summary'                                     => 'Récapitulatif des taxes',
    'taxable_amount'                                  => 'Montant taxable',
    'taxes'                                           => 'Taxes',
    'template'                                        => 'Modèle',
    'terms_and_conditions'                            => 'Conditions générales de vente',
    'test_mode'                                       => 'Mode test',
    'text'                                            => 'Texte',
    'textarea'                                        => 'Zone de texte',
    'this_quarter'                                    => 'Trimestre en cours',
    'thousands_separator'                             => 'Séparateur de milliers',
    'timezone'                                        => 'Fuseau horaire',
    'to'                                              => 'Destinataire',
    'to_date'                                         => 'Jusqu\'au',
    'total'                                           => 'Montant total',
    'total_balance'                                   => 'Solde total',
    'total_invoiced'                                  => 'Total facturé',
    'total_expenses'                                  => 'Total des dépenses',
    'total_paid_invoices'                             => 'Total des factures payées',
    'try_again'                                       => 'Essayer encore',
    'uninstall'                                       => 'Désinstaller',
    'uninstall_addon_warning'                         => 'La désinstallation de cette extension entraînera la perte de toutes les données saisies via l\'extension. Êtes-vous sûr de vouloir continuer ?',
    'unique_name'                                     => 'Nom unique',
    'unknown_error'                                   => 'Erreur inconnue',
    'upcoming_payment_notice_email_body'              => 'Email par défaut pour l\'envoi des avis de paiement',
    'upcoming_payment_notice_email_subject'           => 'Objet des emails pour l\'envoi des avis de paiement',
    'upcoming_payment_notice_frequency'               => 'Fréquence pour l\'envoi des avis de paiement',
    'upcoming_payment_notice_frequency_help'          => 'Nombre de jours, séparés par une virgule, pour l\'envoi des avis de paiement. Laisser ce champ vide pour désactiver l\'envoi des avis de paiement. Exemple : indiquez "1,5" pour envoyer un avis de paiement 5 jours puis 24h avant que la facture n\'arrive à échéance.',
    'update_available'                                => 'Une nouvelle version :version est disponible en téléchargement à cette adresse :url',
    'update_exchange_rate'                            => 'Mettre à jour le taux de change',
    'update_not_available'                            => 'Il n\'y a aucune mise à jour disponible.',
    'upload_progress'                                 => 'Upload en cours de progression',
    'user'                                            => 'Utilisateur',
    'user_accounts'                                   => 'Comptes utilisateurs',
    'user_form'                                       => 'Édition d\'un utilisateur',
    'users'                                           => 'Utilisateurs',
    'validation_invoice_summary_from_date'            => 'La date de début des factures est requise lorsque vous utilisez une plage de dates personnalisée pour le widget Résumé du tableau de bord.',
    'validation_invoice_summary_to_date'              => 'La date de fin des factures est requise lorsque vous utilisez une plage de dates personnalisée pour le widget Résumé du tableau de bord.',
    'validation_quote_summary_from_date'              => 'La date de début des devis est requise lorsque vous utilisez une plage de dates personnalisée pour le widget Résumé du tableau de bord.',
    'validation_quote_summary_to_date'                => 'La date de fin des devis est requise lorsque vous utilisez une plage de dates personnalisée pour le widget Résumé du tableau de bord.',
    'vendor'                                          => 'Vendeur',
    'version'                                         => 'Version',
    'view'                                            => 'Voir',
    'view_all'                                        => 'Afficher tout',
    'view_all_invoices_for_client'                    => 'Voir toutes les factures de ce client',
    'view_all_payments_for_client'                    => 'Voir tous les paiements de ce client',
    'view_all_quotes_for_client'                      => 'Voir tous les devis de ce client',
    'view_approved_quotes'                            => 'Voir les devis approuvés',
    'view_client'                                     => 'Aperçu du client',
    'view_draft_invoices'                             => 'Voir les factures brouillons',
    'view_draft_quotes'                               => 'Voir les devis brouillons',
    'view_overdue_invoices'                           => 'Voir les factures échues',
    'view_payments'                                   => 'Voir les paiements reçus',
    'view_rejected_quotes'                            => 'Voir les devis rejetés',
    'view_sent_invoices'                              => 'Voir les factures envoyées',
    'view_sent_quotes'                                => 'Voir les devis envoyés',
    'view_unique_name'                                => 'Voir le nom unique',
    'viewed'                                          => 'Consulté',
    'visible'                                         => 'Visible',
    'visible_after_payment'                           => 'Visible après paiement',
    'web'                                             => 'Site web',
    'web_address'                                     => 'Site web',
    'weekly'                                          => 'Chaque semaine',
    'weeks'                                           => 'Semaines',
    'welcome'                                         => 'Bienvenue',
    'what_to_import'                                  => 'Que souhaitez-vous importer ?',
    'year'                                            => 'Année',
    'yearly'                                          => 'Chaque année',
    'years'                                           => 'Années',
    'yes'                                             => 'Oui',
    'you_may_now_sign_in'                             => 'Vous pouvez maintenant vous authentifier !',

    // 2017-1
    'all_company_profiles'                            => 'Tous les profils d\'entreprise',
    'cannot_delete_record_in_use'                     => 'Cet enregistrement est utilisé et ne peut pas être supprimé.',
    'cannot_edit_record_in_use'                       => 'Cet enregistrement est utilisé et ne peut pas être édité.',
    'change_company_profile'                          => 'Modifier le profil d\'entreprise',
    'company_profile'                                 => 'Profil d\'entreprise',
    'company_profiles'                                => 'Profils d\'entreprise',
    'company_profile_form'                            => 'Édition du profil d\'entreprise',
    'copy'                                            => 'Dupliquer',
    'create_recurring_invoice'                        => 'Créer une facture récurrente',
    'custom'                                          => 'Personnalisé',
    'date_range'                                      => 'Période',
    'day_short_sunday'                                => 'Di',
    'day_short_monday'                                => 'Lu',
    'day_short_tuesday'                               => 'Ma',
    'day_short_wednesday'                             => 'Me',
    'day_short_thursday'                              => 'Je',
    'day_short_friday'                                => 'Ve',
    'day_short_saturday'                              => 'Sa',
    'default_company_profile'                         => 'Profil d\'entreprise par défaut',
    'first_quarter'                                   => '1er trimestre',
    'fourth_quarter'                                  => '4e trimestre',
    'id'                                              => 'ID',
    'last_7_days'                                     => '7 derniers jours',
    'last_30_days'                                    => '30 derniers jours',
    'last_month'                                      => 'Mois dernier',
    'last_quarter'                                    => 'Dernier trimestre',
    'last_year'                                       => 'Dernière année',
    'month_january'                                   => 'Janvier',
    'month_february'                                  => 'Février',
    'month_march'                                     => 'Mars',
    'month_april'                                     => 'Avril',
    'month_may'                                       => 'Mai',
    'month_june'                                      => 'Juin',
    'month_july'                                      => 'Juillet',
    'month_august'                                    => 'Août',
    'month_september'                                 => 'Septembre',
    'month_october'                                   => 'Octobre',
    'month_november'                                  => 'Novembre',
    'month_december'                                  => 'Décembre',
    'recurring_invoice'                               => 'Facture récurrente',
    'second_quarter'                                  => '2nd trimestre',
    'stop_date'                                       => 'Date de fin',
    'third_quarter'                                   => '3e trimestre',
    'this_month'                                      => 'Mois en cours',
    'this_year'                                       => 'Année en cours',
    'today'                                           => 'Aujourd\'hui',
    'user_account'                                    => 'Compte utilisateur',
    'yesterday'                                       => 'Hier',

    // 2017-3
    'mail_log'                                        => 'Journal des emails',
    'recent_client_activity'                          => 'Activité client récente',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Exclure les factures non payées',

    // 2017-7
    'please_wait'                                     => 'Veuillez patienter...',
    'reply_to_address'                                => 'Répondre à',

    // 2017-8
    'admin'                                           => 'Administrateur',
    'admin_account'                                   => 'Compte d\'administrateur',
    'admin_accounts'                                  => 'Comptes d\'administrateur',
    'all_accounts'                                    => 'Tous les comptes',
    'api_key'                                         => 'Clé API',
    'client_account'                                  => 'Compte client',
    'client_accounts'                                 => 'Comptes clients',
    'client_id'                                       => 'Client ID',
    'client_secret'                                   => 'Client Secret',
    'enable_bitcoin_payments'                         => 'Permettre les paiements en Bitcoin',
    'live'                                            => 'Live',
    'mode'                                            => 'Mode',
    'publishable_key'                                 => 'Clé publiable',
    'sandbox'                                         => 'Sandbox',
    'secret_key'                                      => 'Clé secrète',
    'type'                                            => 'Type',

    // 2017-10
    'deselect_all'                                    => 'Désélectionner tout',
    'select_all'                                      => 'Sélectionner tout',
    'use_24_hour_time_format'                         => 'Utiliser le format 24 heures',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Êtes-vous certain de vouloir supprimer ces enregistrements ?',
    'bulk_invoice_change_status_warning'              => 'Êtes-vous certain de vouloir changer le statut des factures sélectionnées ?',
    'bulk_quote_change_status_warning'                => 'Êtes-vous certain de vouloir changer le statut des devis sélectionnés ?',
    'calculate_as_vat_gst'                            => 'Calculer comme TVA/GST',
    'change_status'                                   => 'Changer le statut',
    'default_status_filter'                           => 'Filtre du statut par défaut',
    'error_applying_payment'                          => 'Il y a eu une erreur pour appliquer ce paiement. Essayer avec une autre carte ou une autre méthode de paiement.',
    'remaining'                                       => 'restant',

    // 2017-12
    'invoice_date'                                    => 'Date de facturation',
    'include_profit_based_on'                         => 'Inclure le profit basé sur',

    // 2018-1
    'add_contact'                                     => 'Ajouter un contact',
    'allow_self_signed_cert'                          => 'Autoriser les certificats auto-signés',
    'backup'                                          => 'Sauvegardes',
    'close'                                           => 'Fermer',
    'change_invoice_date_to_todays_date'              => 'Changer la date de la facture à la date du jour',
    'change_quote_date_to_todays_date'                => 'Changer la date du devis à la date du jour',
    'contacts'                                        => 'Contacts',
    'default_bcc'                                     => 'BCC par défaut',
    'default_cc'                                      => 'CC par défaut',
    'default_to'                                      => 'À par défaut',
    'disable'                                         => 'Désactiver',
    'download_database_backup'                        => 'Télécharger la sauvegarde de la base de données',
    'edit_contact'                                    => 'Editer un contact',
    'expense_list'                                    => 'Liste des dépenses',
    'keep_invoice_date_as_is'                         => 'Conserver la date de la facture telle quelle',
    'keep_quote_date_as_is'                           => 'Conserver la date du devis telle quelle',
    'if_quote_is_emailed_while_draft'                 => 'Lorsqu\'un devis est envoyé avec le statut brouillon',

    // 2018-4
    'force_https'                                     => 'Forcer HTTPS',
    'force_https_help'                                => 'Avant d\'activer cette option, assurez-vous que votre installation de FusionInvoice fonctionne correctement via https. Le non-respect de cette consigne peut entraîner une installation non fonctionnelle (mais réparable).',

    // 2019-1
    'attached_to'                                     => 'Attached To',
    'customer'                                        => 'Client',
    'expense'                                         => 'Dépense',
    'expense_categories'                              => 'Catégories de la dépense',
    'expense_category_form'                           => 'Formulaire des catégories de dépenses',
    'expense_vendors'                                 => 'Vendeurs',
    'expense_vendor_form'                             => 'Expense Vendor Form',
    'lead'                                            => 'Lead',
    'local_time'                                      => 'Local Time',
    'prospect'                                        => 'Prospect',
    'search_clients'                                  => 'Recherche des clients',
    'search_expenses'                                 => 'Recherche des dépenses',
    'search_invoices'                                 => 'Recherche des factures',
    'search_items'                                    => 'Recherche des éléments',
    'search_log'                                      => 'Recherche des journaux',
    'search_quotes'                                   => 'Recherche des devis',
    'search_payments'                                 => 'Recherche des paiements',
    'search_recurring_invoices'                       => 'Recherche des factures récurrentes',
    'show_all_statuses'                               => 'Voir tous les statuts',
    'show_all_types'                                  => 'Voir tous les types',
    'unknown'                                         => 'Inconnu',
    'value'                                           => 'Valeur',

    // 2019-2
    'default'                                         => 'Défaut',
    'no_data_available'                               => 'Aucune donnée disponible',
    'recurring_invoice_list'                          => 'Liste des factures récurrentes',
    'report_total'                                    => 'Totaux du rapport',

    //2019-3
    'checkbox'                                        => 'Case à cocher',
    'custom_dropdown_validate'                        => 'Veuillez sélectionner une option valide pour :label',
    'custom_image_validate'                           => 'Veuillez sélectionner une image valide pour :label',
    'custom_tag_validate'                             => 'Veuillez sélectionner une étiquette valide pour :label',
    'custom_text_validate'                            => 'Veuillez entrer des informations valides pour :label',
    'datetime'                                        => 'Date/Heure',
    'decimal'                                         => 'Décimal',
    'delete-confirm'                                  => 'Êtes-vous certain ?',
    'grand_total'                                     => 'Somme finale',
    'image'                                           => 'Image',
    'integer'                                         => 'Entier',
    'mailed'                                          => 'Envoyé par courrier',
    'mailed_invoices'                                 => 'Factures envoyées par courrier',
    'radio'                                           => 'Radio',
    'recurring_id'                                    => 'ID Récurrent',
    'remove_image'                                    => 'Supprimer l\'image',
    'tags'                                            => 'Etiquettes',
    'tagselection'                                    => 'Sélection d\'étiquette',
    'unpaid'                                          => 'Impayé',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Afficher les factures papier',
    'important'                                       => 'Important!',
    'created_recurring_invoice_id'                    => 'Créer depuis la facture récurrente',
    'mr'                                              => 'M.',
    'miss'                                            => 'Melle.',
    'ms'                                              => 'Mme.',
    'mrs'                                             => 'Mme.',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Titre du contact',
    'title'                                           => 'Titre',
    'test_email_subject'                              => 'Bonjour depuis FusionInvoice!',
    'test_email_body'                                 => 'Ceci est un email de test envoyé à partir de FusionInvoice.',
    'test_email_address'                              => 'Envoyer un email de test à',
    'send_test_email'                                 => 'Envoyer un email de test',
    'invalid_json'                                    => 'Veuillez entrer une chaîne JSON valide',
    'textarea_rows_limit'                             => 'Le nombre de lignes ne peut pas excéder :limit',
    'custom_integer_validate'                         => ':label doit être une valeur entière valide',

    //2020-1
    'user_role'                                       => 'Role de l\'utilisateur',
    'standard_user'                                   => 'Utilisateur standard',
    'permissions'                                     => 'Permissions',
    'modules'                                         => 'Modules',
    'is_view'                                         => 'Visualiser',
    'is_create'                                       => 'Créer',
    'is_update'                                       => 'Mettre à jour',
    'is_delete'                                       => 'Supprimer',
    'dashboards'                                      => 'Tableaux de bord',
    'allow_time_period_change'                        => 'Permettre de changer la période',
    'page_not_found'                                  => 'Oops! Page non trouvée.',
    'return_to_dashboard'                             => 'Nous n\'avons pas trouvé la page que vous cherchiez. <a href=":dashboard_link">Retourner au tableau de bord</a>.',
    'no_auth_to_create_client'                        => 'Vous n\'êtes pas autorisé à créer des clients!',
    'check-all'                                       => 'Vérifier tout',
    'invoice_prefix'                                  => 'Préfixe de facture',
    'recently_viewed'                                 => 'Vu récemment',
    'copy_from'                                       => 'Copier depuis',
    'select_user'                                     => 'Sélectionner un utilisateur',
    'please_select_user'                              => 'Veuillez sélectionner un utilisateur dans la liste',
    'allow_client_center_login'                       => 'Permettre de se connecter à l\'espace client',
    'online_payment_processing_fee'                   => 'Frais de traitement des paiements en ligne',
    'client_password_required'                        => 'Veuillez entrer le mot de passe du client',
    'last_login_at'                                   => 'Dernière connexion à',
    'show_notes_panel_below_client'                   => 'Afficher le panneau de notes sous les détails du client',
    'notepad'                                         => 'Bloc-notes',
    'added'                                           => 'Ajouté',
    'last_edited'                                     => 'Dernière édition',
    'loading'                                         => 'Traitement en cours...',
    'n_records_match'                                 => ':label Record:plural match',
    'initials'                                        => 'Initiales',
    'initials_bg_color'                               => 'Couleur d\'arrière-plan des initiales',
    'more'                                            => 'Plus',
    'must_match_all'                                  => 'Doit correspondre à tous',
    'clear'                                           => 'Effacer',
    'no_client_tags'                                  => 'Il n\'y a aucun client avec les étiquettes définies.',
    'qr_code_on_invoice_quote'                        => 'QR-Code sur les factures et devis',
    'delete_tags'                                     => 'Nettoyer les étiquettes',
    'orphan_tags_deleted'                             => 'Suppression réussie de toutes les balises orphelines du système.',
    'orphan_tags_delete_confirm'                      => 'Le nettoyage des étiquettes supprimera toutes les étiquettes inutilisées des clients et des notes. Continuer ?',
    'deleting_tags_wait'                              => 'Suppression des étiquetttes, veuillez patientier ...',
    'new-version-available'                           => 'Nouvelle version disponible!',
    'ignore-this-version'                             => 'Ignorer cette version',
    'view-release-notes'                              => 'Consulter les notes de version',
    'task_list'                                       => 'Liste des tâches',
    'create_task'                                     => 'Créer une tâche',
    'open'                                            => 'Ouvert',
    'closed'                                          => 'Fermé',
    'assignee'                                        => 'Assigné',
    'task'                                            => 'Tâche',
    'task_successfully_created'                       => 'Tâche créée avec succès',
    'task_successfully_updated'                       => 'Tâche mise à jour avec succès',
    'task_completed'                                  => 'Tâche complétée avec succès',
    'task_marked_incomplete'                          => 'Tâche réouverte',
    'due_date_validation_date'                        => 'Veuillez sélectionner une date d\'échéance valide',
    'assignee_validation_required'                    => 'Veuillez sélectionner une assignation valide depuis la liste',
    'assignee_validation_exists'                      => 'Veuillez sélectionner une assignation valide depuis la liste',
    'tomorrow'                                        => 'Demain',
    'task_not_authorized'                             => 'Vous n\'êtes pas autorisé à modifer cette tâche !',
    'me'                                              => 'Moi',
    'task_from_note'                                  => 'Créer une tâche à l\'enregistrememnt',
    'done'                                            => 'Terminé',
    'refresh'                                         => 'Rafraîchir',
    'task_list_page_size'                             => 'Nombre de tâches par page',
    'select_client'                                   => 'Choisir un client',
    'note-search-config'                              => 'Recherche de notes à inclure',
    'username'                                        => 'Nom d\'utilisateur',
    'task-search-config'                              => 'Recherche de tâches à inclure',
    'task_section_invalid'                            => 'Section de tâche non valide',
    'task_section'                                    => 'Section de tâche',
    'select_section'                                  => 'Choix de section',
    'email-test-failed'                               => 'Test d\'envoi d\'email invalide',
    'smtp-setting-suggestion'                         => 'Suggestions: <br> 1. Vérifiez et réentrez les valeurs du nom d\'utilisateur/mot de passe<br>2. Vérifiez que les paramètres SMTP ont été correctement entrés.',
    'mail-setting-suggestion'                         => 'Suggestions: <br> 1. Vérifiez que le serveur mail PHP est correctement configuré. <br>2. Contactez l\'administrateur du serveur',
    'sendmail-setting-suggestion'                     => 'Suggestions: <br> 1. Vérifiez que le chemin Sendmail est correctement configuré. <br>2. Contactez l\'administrateur du serveur',
    'sendgrid-setting-suggestion'                     => 'Suggestions:<br>1. Vérifiez que votre clé Sendgrid est correctement configurée.<br>2. Contact server admin',
    'later'                                           => 'Plus tard',
    'test-email-required'                             => 'Vous devez saisir une adresse e-mail valide pour envoyer le test.',
    'test_mail_sent_successfully'                     => 'Email de test envoyé avec succès',
    'test-mail-btn-title'                             => 'Doit enregistrer les modifications avant de tester.',
    'agreement_expire'                                => 'Votre forfait pour les mises à jour du produit et l\'assistance expirera le :date',
    'agreement_expired'                               => 'Votre forfait pour les mises à jour du produit et le support ont expiré le :date',
    'piracy_message'                                  => 'Votre clé de licence FusionInvoice n\'est pas valide. Le piratage de logiciels est un crime. Soyez juste! Avec une licence valide, vous recevrez du support, des mises à jour et un bon karma.',
    'buy-now'                                         => 'Achetez maintenant',
    'piracy_alert'                                    => 'Soyez juste!',
    'agreement-expire-alert'                          => 'Le forfait pour les mises à jour et le support expire prochainement.',
    'agreement-expired-alert'                         => 'Le forfait pour les mises à jour et le support a expiré.',
    'dismiss-forever'                                 => 'Rejeter pour toujours',
    'renew-now'                                       => 'Renouveller maintenant',
    'select_all_permissions'                          => 'Sélectionnez toutes les autorisations',
    'app-key-missing'                                 => 'Veuillez entrer votre clé de licence dans le fichier config/app.php.',
    'custom_fields_column_width'                      => 'Colonnes d\'affichage des champs personnalisés',
    'select-user-type'                                => 'Sélectionnez le type d\'utilisateur',
    'lead-or-prospect-with-invoices-error'            => 'Désolé, le type de client ne peut pas être "lead" ou "prospect" lorsqu\'il existe des factures pour celui-ci.',
    'sendgrid_key'                                    => 'Clé Sendgrid',

    //2020-2.0
    'space'                                           => 'Espace',
    'apostrophe'                                      => 'Apostrophe',
    'comma'                                           => 'Virgule',
    'fullstop'                                        => 'Point',
    'middledot'                                       => 'Middle Dot',
    'thinspace'                                       => 'Petit espace',
    'narrow-no-break-space'                           => 'Narrow No-Break Space',
    'dotabove'                                        => 'Dot Above',
    'arabic-decimal'                                  => 'Arabic Decimal Separator',
    'arabic-thousand'                                 => 'Arabic Thousand Separator',
    'decimal-separator-key-symbol'                    => 'Decimal Separator Key Symbol',
    'select-item'                                     => 'Choisir un élément',
    'item-lookup-overload'                            => 'Le maximum autorisé pour l\'aperçu d\'éléments est de 100 éléments',
    'select-expense-category'                         => 'Sélection de la catégorie de dépense',
    'select-expense-vendor'                           => 'Sélection du fournisseur',
    'can-not-delete-all-users'                        => 'Désolé, vous ne pouvez pas supprimer tous les utilisateurs du système',
    'can-not-change-default-user-role'                => 'Désolé, vous ne pouvez pas modifier le rôle d\'utilisateur par défaut',
    'can-not-change-default-user-status'              => 'Désolé, vous ne pouvez pas modifier le statut d\'utilisateur par défaut',
    'user_not_active'                                 => 'L\'utilisateur n\'est pas actif',
    'can-not-inactive-your-own-status'                => 'Désolé, vous ne pouvez pas vous rendre inactif.',
    'delete_user_warning'                             => '<p>STOP! Supprimer cet utilisateur est une action destuctive qui peut supprimer des données créées dans le système. Veuillez considérer de rendre cet utilisateur inactif à la place.</p><p>Êtes-vous certian de vouloir supprimer cet utilisateur ?</p>',
    'include_time_in_due_date'                        => 'Inclure l\'heure dans la date d\'échéance',
    'cannot_delete_default_company'                   => 'Vous ne pouvez pas supprimer le profil d\'entreprise par défaut',
    'make-user-inactive'                              => 'Rendre l\'utilisateur inactif',
    'mail_from_address'                               => 'Adresse email de l\'expéditeur',
    'mail_from_name'                                  => 'Nom de l\'expéditeur',
    'item_categories'                                 => 'Catégories de l\'élément',
    'select-item-category'                            => 'Choisir la catégorie de l\'élément',
    'item_category_form'                              => 'Formulaire de catégorie de l\'élément',
    'sort_by_due'                                     => 'Trier par date d\'échéance',
    'affiliate'                                       => 'Affilié',
    'parent_account'                                  => 'Compte parent',
    'child_account'                                   => 'Compte enfant',
    'select_parent_client'                            => 'Choisir le compte parent',
    'record_successfully_retrieved'                   => 'Enregistrement récupéré avec succès',
    'custom-image-not-support'                        => 'Champ d\'image personnalisé non pris en charge',
    'custom-tag-not-support'                          => 'Champ d\'étiquette personnalisé non pris en charge',
    'custom-checkbox-not-support'                     => 'Champ de case à cocher personnalisé non pris en charge',
    'custom-date-not-support'                         => 'Champ de date personnalisé non pris en charge',
    'custom-datetime-not-support'                     => 'Champ de date/heure personnalisé non pris en charge',
    'timeline'                                        => 'Ligne du temps',
    'client_invoice'                                  => 'Factures par client',
    'select_client_blank_for_all'                     => 'Sélectionner un client (vide pour tous)',
    'invoice_email_success'                           => 'Facture envoyée par email avec succès',
    'quote_email_success'                             => 'E-mail de devis envoyé avec succès',
    'document_number_schemes'                         => 'Numérotation des documents',
    'document_number_scheme'                          => 'Schéma de numération des documents',
    'document_number_scheme_form'                     => 'Formulaire du schéma de numérotation des documents',
    'default_document_number_scheme'                  => 'Schéma de numérotation des documents par défaut',
    'supporting_data'                                 => 'Données de support',
    'customizations'                                  => 'Personnalisations',
    'utilities_and_logs'                              => 'Utilitaires et journaux',
    'system_log'                                      => 'Journal système',
    'paid_amount'                                     => 'Montant payé',
    'payment_amount'                                  => 'Montant du paiement',
    'payment_intent'                                  => 'Intention de paiement',
    'apply_payment_to_one_or_more_invoice'            => 'Appliquer le paiement à une ou plusieurs factures',
    'pre_payment_for_future_invoices'                 => 'Pré-paiement pour les futures factures',
    'apply_to_invoices'                               => 'Appliquer à la (aux) facture(s)',
    'payment_application'                             => 'Application de paiement',
    'remaining_payment_balance'                       => 'Crédit restant',
    'remaining_balance'                               => 'Solde restant',
    'payment_warning'                                 => 'Veuillez saisir le montant',
    'apply_pre_payment_warning'                       => 'Vous n\'avez appliqué le paiement à aucune facture. Souhaitez-vous l\'enregistrer comme un pré-paiement ?',
    'confirm_remaining_balance'                       => 'Le solde restant de :value pourra être appliqué aux futures factures de ce client.',
    'open_balance'                                    => 'Solde ouvert',
    'more_figure_then_total_payment'                  => 'Veuillez saisir à nouveau le paiement, le paiement total de votre facture est supérieur au solde restant.',
    'remaining_payment_balance_apply_later_info'      => 'Les soldes de paiement restants peuvent être appliqués à d\'autres factures ultérieurement.',
    'invoice_balance'                                 => 'Solde de la facture',
    'enter_payment_for_invoice'                       => 'Saisir le paiement pour la facture',
    'invoice_pdf'                                     => 'Facture PDF',
    'payment_applications'                            => 'Demandes de paiement',
    'multiple'                                        => 'Plusieurs',
    'ok'                                              => 'D\'accord',
    'credit_memo_default'                             => 'Défaut de note de crédit',
    'edit_payment'                                    => 'Modifier le paiement',
    'credit_memo'                                     => 'Note de crédit',
    'credit_memos'                                    => 'Notes de crédit',
    'create_credit_memo'                              => 'Créer une note de crédit',
    'credit_applications'                             => 'Demandes de note de crédit',
    'credit_applications_for_invoice'                 => 'Demandes de note de crédit pour facture',
    'prepayment_applications_for_invoice'             => 'Demandes de prépaiement pour facture',
    'apply_credit_memo'                               => 'Appliquer une note de crédit',
    'apply_pre_payment'                               => 'Appliquer le pré-paiement',
    'applied_amount'                                  => 'Montant appliqué',
    'remaining_credit_balance'                        => 'Solde créditeur restant',
    'remaining_credit_balance_apply_later_info'       => 'Les soldes créditeurs restants peuvent être appliqués à d\'autres factures ultérieurement.',
    'applied'                                         => 'Appliqué',
    'more_figure_then_invoice_amount'                 => 'Veuillez saisir à nouveau le montant, le montant ne peut pas être supérieur au montant de la facture.',
    'more_figure_then_invoice_total'                  => 'Veuillez saisir à nouveau le montant, le montant total appliqué ne peut pas être supérieur au montant de la facture.',
    'invoice_not_selected_warning'                    => 'Attendez, vous n\'avez appliqué la note de crédit à aucune facture.',
    'select_type'                                     => 'Sélectionner le genre',
    'email_credit_memo'                               => 'Note de crédit par e-mail',
    'back_to_credit_memo'                             => 'Retour à la note de crédit',
    'invoice_amount'                                  => 'Montant de la facture',
    'remaining_invoice_amount'                        => 'Montant restant de la facture',
    'settlement_for_credit_memo'                      => 'Règlement pour note de crédit',
    'credit_memo_amount'                              => 'Montant de la note de crédit',
    'confirm_remaining_balance_invoice'               => 'Le solde restant de cette facture sera de :value après règlement.',
    'payment_receipt_for_invoices'                    => 'Reçu de paiement pour les factures',
    'primary_phone'                                   => 'Numéro de téléphone principal',
    'alternate_phone'                                 => 'Autre numéro de téléphone',
    'currency_not_match'                              => 'La devise ne correspond pas',
    'tasks'                                           => 'Tâches',
    'full_and_final_payment'                          => 'complet et définitif',
    'partial'                                         => 'partiel',
    'transition'                                      => [
        'created'          => 'Établi',
        'updated'          => 'Mis à jour',
        'deleted'          => 'Supprimé',
        'received'         => 'Reçu',
        'opened'           => 'Ouvert',
        'sent'             => 'Expédié',
        'mail'             => 'Envoyé par la poste',
        'changed'          => 'Modifié',
        'recurring'        => 'Établi',
        'completed'        => 'Terminé',
        'reversed'         => 'Renversé',
        'quote_to_invoice' => 'Devis à facturer',
        'download'         => 'Télécharger',
        'added'            => 'Ajoutée',
        'email'            => 'E-mail',
        'merge'            => 'Fusionner',
        'billed'           => 'Facturé',
        'failed'           => 'Échoué',
        'invoice'          => [
            'created'                => 'La facture :invoice_number a été créée',
            'credit_memo_created'    => 'La note de crédit :credit_memo_number a été créée',
            'credit_memo_updated'    => 'La note de crédit :credit_memo_number a été modifiée',
            'created_from_recurring' => 'La facture :invoice_number a été créée à partir du modèle de facture récurrente :recurring_invoice_id)',
            'updated'                => 'La facture :invoice_number a été modifiée',
            'deleted'                => 'La facture :invoice_number a été supprimée',
            'credit_memo_deleted'    => 'La note de crédit :credit_memo_number a été supprimée',
            'status_changed'         => 'Le statut de la facture :invoice_number est passé de :previous_value à :current_value',
            'email_sent'             => 'La facture :invoice_number a été envoyée par email',
            'resend_email'           => 'Facture :invoice_number renvoi par e-mail',
            'email_opened'           => 'L\'email de la facture :invoice_number a été ouvert',
            'payment_updated'        => 'Facture :invoice_number mise à jour :full_payment_text paiement',
            'payment_received'       => 'Le facture :invoice_number a reçu un paiement de :full_payment_text',
            'payment_reversed'       => 'La facture :invoice_number avait un :full_payment_text',
            'invoice_tag_updated'    => 'L\'étiquette de facture :tags a été ajoutée sur la facture :invoice_number',
            'invoice_tag_deleted'    => 'L\'étiquette de facture :invoice_number a été supprimée :tags',
            'mark_mail'              => 'Facture :invoice_number marquer comme envoyé',
            'unmark_mail'            => 'Facture :invoice_number masque comme non envoyé',
            'paid_invoice_opened'    => 'La facture payée a été ouverte pour modification',
            'sent_invoice_opened'    => 'La facture envoyée a été ouverte pour modification',
            'sms_sent'               => 'Facture :invoice_number SMS envoyé',
        ],
        'quote'            => [
            'created'           => 'Le devis :quote_number a été créé',
            'updated'           => 'Le devis :quote_number a été modifié',
            'deleted'           => 'Le devis :quote_number a été supprimé',
            'status_changed'    => 'Le statut du devis :quote_number est passé de :previous_value à :current_value',
            'email_sent'        => 'Le devis :quote_number a été envoyé par email',
            'resend_email'      => 'Citation :quote_number renvoi d\'e-mail',
            'email_opened'      => 'L\'email du devis :quote_number a été ouvert',
            'quote_to_invoice'  => ':quote_number a été converti en facture - :invoice_number',
            'quote_tag_updated' => 'La balise de citation :tags a été ajoutée sur la citation :quote_number',
            'quote_tag_deleted' => 'La balise de citation :quote_number a été supprimée :tags',
            'sms_sent'          => 'Citation :quote_number SMS envoyé',
        ],
        'payment'          => [
            'prepayment_created'           => 'Le pré-paiement :payment_id a été créé',
            'payment_receipt_email_sent'   => 'Le reçu du paiement :payment_id a été envoyé par email',
            'payment_receipt_resend_email' => 'Renvoyer l\'e-mail du reçu de paiement',
            'payment_updated'              => 'Le paiement :payment_id a été modifié',
            'deleted'                      => 'Le paiement :payment_id a été supprimé',
            'payment_receipt_pdf_download' => 'Télécharger le PDF du reçu de paiement',
            'payment_note_deleted'         => 'Bulletin de paiement supprimé :',
            'payment_note_added'           => 'Note de paiement ajoutée :',
            'payment_note_updated'         => 'Bulletin de paiement mis à jour à partir de',
            'payment_failed'               => 'Paiement échoué',
        ],
        'client'           => [
            'client_created'     => ':client_type :client_id a été créé',
            'type_changed'       => ':previous_value :client_id est devenu :current_value',
            'updated'            => 'Les données du client :client_id ont été mises à jour',
            'deleted'            => 'Le client :client_id a été supprimé',
            'status_changed'     => 'Client défini sur :current_value',
            'client_tag_updated' => 'Tag :tags ajouté',
            'client_tag_deleted' => 'Balise :tags supprimée',
            'merge'              => 'L\'ID client: :idTo - :nameTo a été fusionné avec l\'ID client: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'La dépense :expense_id a été créée',
            'updated' => 'La dépense :expense_id a été modifiée',
            'deleted' => 'La dépense :expense_id a été supprimée',
            'billed'  => 'La dépense :expense_id a été facturée',
            'vendor'  => [
                'created' => 'Le fournisseur de dépenses a été créé',
                'updated' => 'Le fournisseur de dépenses a été modifié',
                'deleted' => 'Le fournisseur de dépenses a été supprimé',
            ],
        ],
        'note'             => [
            'created'          => 'La note :note_id a été créée',
            'updated'          => 'La note :note_id a été modifiée',
            'deleted'          => 'La note :note_id a été supprimée',
            'note_tag_updated' => 'Tag :tags ajouté à la note',
            'note_tag_deleted' => 'Balise :tags supprimée de la note',
        ],
        'task'             => [
            'created'   => 'La tâche :task_id a été créée',
            'updated'   => 'La tâche :task_id a été modifiée',
            'deleted'   => 'La tâche :task_id a été supprimée',
            'completed' => 'La tâche :task_id a été réalisée',
        ],
        'subscription'     => [
            'created'                       => 'L\'abonnement :invoice_number a été créé',
            'updated'                       => 'L\'abonnement :invoice_number a été modifié',
            'deleted'                       => 'L\'abonnement :invoice_number a été supprimé',
            'recurring_invoice_tag_updated' => 'La balise d\'abonnement :tags a été ajoutée à l\'abonnement :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'La balise d\'abonnement :recurringInvoice_number a été supprimée :tags',
        ],
        'attachment'       => [
            'created' => ':filename a été téléchargé en tant que pièce jointe',
            'deleted' => ':filename a été supprimé en tant que pièce jointe',
        ],
        'tag'              => [
            'created' => 'La balise :tag a été ajoutée à',
            'deleted' => 'La balise :tag a été supprimée de',
        ],
    ],
    'reset'                                           => 'Réinitialiser',
    'select_event'                                    => 'Choisir un type d\'événement',
    'select_country'                                  => 'Choisir un pays',
    'type_captcha'                                    => 'Veuillez répondre à la question ci-dessus',
    'refresh_captcha'                                 => 'Actualiser la question',
    'answer'                                          => 'Réponse',
    'use_captcha_in_login'                            => 'Utiliser un captcha pour la connexion',
    'allow_client_timeline'                           => 'Ligne du temps',
    'client_timeline'                                 => 'Ligne du temps',
    'no_invoice_tags'                                 => 'Il n\'y a pas d\'étiquettes de facture',
    'total_notifications'                             => 'Vous avez :total notifications',
    'no_notifications'                                => 'Il n\'y a pas de nouvelles notifications',
    'notifications'                                   => 'Notifications',
    'notification'                                    => [
        'task'  => [
            'created'           => 'Une nouvelle tâche vous a été assignée',
            'due_date_breached' => 'La tâche',
            'completed'         => ':user a terminé la tâche :',
        ],
        'quote' => [
            'approved'             => ':quote_number a été approuvé',
            'quote_to_invoice'     => ':quote_number a été converti en facture -',
            'rejected'             => ':quote_number a été rejeté',
            'payment_successfully' => 'Le devis :quote_number pour le client :client_name a été payé. La facture :invoice_number a été créée et le paiement a été appliqué',
        ],
    ],
    'search_tasks'                                    => 'Rechercher des tâches',
    'reopen_task'                                     => 'Réouvrir une tâche',
    'task_form'                                       => 'Ajouter une tâche',
    'view_task'                                       => 'Détails d\'une tâche',
    'client_deleted'                                  => 'Client supprimé',
    'payment_canceled'                                => 'Votre paiement a été annulé',
    'default_company_profile_set'                     => 'Nous avons défini votre profil d\'entreprise par défaut. Vous pouvez le mettre à jour à tout moment à partir des paramètres du profil d\'entreprise.',
    'file_uploaded_successfully'                      => 'Fichier téléchargé avec succès',
    'attachment_notice'                               => 'Taille maximale du fichier inférieure ou égale à :size',
    'attachment_error'                                => 'La taille du fichier ne peut pas dépasser :size',
    'attachment_warning'                              => 'La taille du fichier est :size. Le téléchargement de nombreuses pièces jointes volumineuses peut dégrader les performances de votre base de données au fil du temps.',
    'generate_timeline_history'                       => 'Générer l\'historique de la chronologie',
    'generating_timeline_wait'                        => 'Génération de la ligne du temps, veillez patienter ...',
    'generating_timeline_confirm'                     => 'La fonction de chronologie a été ajoutée dans FusionInvoice 2020. Cela générera des entrées de chronologie pour toutes les activités qui ont précédé l\'ajout de cette fonctionnalité. Continuer ?',
    'generated_timeline_request_accepted'             => 'La génération de l\'historique de la chronologie est terminée.',
    'transitions'                                     => 'Transitions',
    'pending'                                         => 'En cours',
    'client_transition'                               => 'Chronologie des clients',
    'expense_transition'                              => 'Chronologie des dépenses',
    'invoice_transition'                              => 'Chronologie des factures',
    'payment_invoice_transition'                      => 'Chronologie des paiements de facture',
    'payment_transition'                              => 'Chronologie des paiements',
    'quote_transition'                                => 'Chronologie des devis',
    'note_transition'                                 => 'Chronologie des notes',
    'task_transition'                                 => 'Chronologie des tâches',
    'email_sent'                                      => 'Email envoyé',
    'credit_applied'                                  => 'Crédit appliqué',
    'configuration'                                   => 'Configuration',
    'include_prepayments'                             => 'Inclure les prépaiements',
    'pre_payment'                                     => 'Paiements anticipés',
    'pre_payments'                                    => 'Prépaiements',
    'times'                                           => 'Fois',
    'include_prepayments_applied'                     => 'Inclure les prépaiements appliqués',
    'confirm_full_payment_applied'                    => 'Le paiement a été entièrement appliqué',
    'confirm_full_credit_memo_applied'                => 'La note de crédit a été entièrement appliquée',
    'all_tasks'                                       => 'Toutes les tâches',
    'my_tasks'                                        => 'Mes tâches',
    'assigned_from_others'                            => 'Assigné par d\'autres',
    'full_payment_reversed'                           => 'paiement intégral annulé.',
    'partial_payment_reversed'                        => 'paiement partiel annulé.',
    'invoice_delete_error'                            => 'Désolé, vous ne pouvez pas supprimer une facture contenant des demandes de paiement ou de note de crédit. Vous devez d\'abord supprimer les paiements ou les demandes de note de crédit.',
    'mail-from-required'                              => 'Vous devez entrer un courrier électronique valide',
    'contact_updated'                                 => 'Contact mis à jour avec succès',
    'contact_added'                                   => 'Contact ajouté avec succès',
    'generate_passport_key_wait'                      => 'Génération de votre clé de passeport, veuillez patienter ...',
    'generate_passport_key'                           => 'Générer une clé de passeport',
    'default_greeting'                                => 'Salut!<br>',
    'hi'                                              => 'Salut,',
    'deduct_tax_from_expenses'                        => 'Déduire la taxe des dépenses',
    'invalid_invoice_id'                              => 'ID de facture non valide',
    'client_related_record_exist'                     => 'Désolé, le client a des enregistrements associés pour:: modules. Les clients avec l\'historique des transactions ne peuvent pas être supprimés.',
    'email_payment_receipt_notice'                    => 'Le client n\'a pas d\'adresse e-mail dans le dossier',
    'show_more'                                       => 'Montre plus ...',
    'show_less'                                       => 'Montrer moins ...',
    'invoice_already_paid'                            => 'La facture est déjà payée!',
    'system_default'                                  => 'Défaut du système',
    'created_by'                                      => 'Créé par',
    'created_at'                                      => 'Créé à',
    'task_created_by_and_created_at'                  => 'Tâche créée par :created_by sur :created_at',
    'dashboard_widgets_date_options'                  => 'Période par défaut du système pour la facture et le récapitulatif des devis',
    'dashboard-widget-from-date-required'             => 'La date de début est requise lorsque la plage de dates personnalisée est sélectionnée dans la période par défaut du système pour la facture et le résumé de devis',
    'dashboard-widget-to-date-required'               => 'La date de fin est requise lorsque la plage de dates personnalisée est sélectionnée sur la période par défaut du système pour la facture et le résumé',
    'invoice_currency'                                => 'Devise de la facture',
    'currency_format'                                 => 'Format de devise',
    'create_missing_folder_success'                   => 'Dossier requis manquant créé',
    'create_missing_folder_failed'                    => 'Échec de la tentative de création de dossier(s) :path',
    'folder_is_not_writable'                          => 'Le dossier n\'est pas accessible en écriture :path',
    'update_item_as_lookup'                           => 'Mettre à jour la recherche d\'élément',
    'number_of_tax_fields'                            => 'Nombre de champs de taxe',
    'tax_1_entry'                                     => '1 entrée',
    'tax_2_entries'                                   => '2 entrées',
    'require_tags_on_client_notes'                    => 'Étiquette(s) requise(s) sur les notes client',
    'entered_amount_less_than_invoice_amount'         => 'Le montant saisi doit être inférieur ou égal au montant de la facture',
    'send-to'                                         => 'Envoyer à',
    'print'                                           => 'Imprimer',
    'pdf_cleanup'                                     => 'Nettoyage de PDF',
    'pdf_cleanup_confirm'                             => 'Êtes-vous sûr de vouloir nettoyer les anciens fichiers PDF',
    'pdf_cleanup_success'                             => 'Nettoyage du PDF terminé',
    'deleting_pdf_wait'                               => 'Suppression des anciens fichiers PDF, veuillez patienter...',
    'open_invoices'                                   => 'Factures ouvertes',
    'open_credits'                                    => 'Crédits ouverts',
    'unapplied_payments'                              => 'Paiements non appliqués',
    'attach_invoice_pdf'                              => 'Joindre la facture PDF',
    'upcoming_payment_notice'                         => 'Avis de paiement à venir',
    'select_mapping'                                  => 'Sélectionnez le mappage',
    'select_named_export'                             => 'Sélectionnez l\'exportation nommée',
    'save_mapping'                                    => 'Enregistrer le mappage',
    'add_mapping'                                     => 'Créer un nouveau mappage',
    'edit_mapping'                                    => 'Mettre à jour le mappage',
    'save_as_default_mapping'                         => 'Mappage par défaut',
    'save_as_default_export'                          => 'Exportation par défaut',
    'export_item_lookups'                             => 'Exporter les recherches d\'articles',
    'import_file_selection'                           => 'Importer la sélection de fichier',
    'next'                                            => 'Prochain',
    'delete_import_mapping_warning'                   => 'Voulez-vous vraiment supprimer ce mappage ?',
    'export'                                          => 'Exportation',
    'named_exports'                                   => 'Exportations nommées',
    'save_named_export'                               => 'Enregistrer l\'exportation nommée',
    'delete_named_export'                             => 'Supprimer l\'exportation nommée',
    'updated_at'                                      => 'Mis à jour à',
    'zip'                                             => 'Zipper',
    'fields_to_export'                                => 'Champs à exporter',
    'import-file-type-error'                          => 'Le type de fichier d\'importation doit être CSV',
    'recurring_invoice_items'                         => 'Éléments de facture récurrents',
    'important_details'                               => 'Détails importants',
    'important_information'                           => 'Une information important',
    'item_lookups_important_information'              => '<p>Si un nom de recherche d\'élément correspondant est trouvé dans les données existantes lors de l\'importation CSV, le lot d\'importation échouera, affichant l\'élément qui a causé l\'échec.</p>',
    'invoices_important_information'                  => '<p>Le nom du client (du CSV) est recherché dans la table Clients et résolu en client_id, s\'il existe un nom correspondant. Si aucune correspondance de nom n\'est trouvée, il crée une entrée client et utilise l\'ID de la nouvelle entrée client</p><p>Numéro de facture,</p><p>Invoice_items effectue une recherche sur le numéro de facture (à partir du CSV) dans la table des factures et le résout en ID. Aucune autre recherche/validation de champ clé n\'est effectuée</p>',
    'invoice_items_important_information'             => '<p>L\'importation facture_items effectue une recherche sur le numéro de facture (à partir du fichier CSV) dans la table des factures et le résout en l\'ID de facture approprié. L\'ID client est également dérivé des informations de facturation correspondantes.</p>',
    'payments_important_information'                  => '<p>L\'importation de paiements nécessite un numéro de facture correspondant valide auquel appliquer les paiements. Si aucune facture correspondante n\'est trouvée, l\'ensemble de l\'importation par lots échouera.</p><p>Les clients appropriés-</p><p>Une recherche est effectuée sur le nom du mode de paiement (du fichier CSV dans la table payment_methods) et se résoudra en le payment_method_id approprié, s\'il est trouvé. si aucun nom correspondant n\'est trouvé, un nouvel enregistrement de mode de paiement sera créé et le nouveau payment_method_id sera utilisé.</p>',
    'run_daily_tasks'                                 => 'Exécuter des tâches quotidiennes',
    'daily_task_ran'                                  => 'Tâches quotidiennes exécutées avec succès',
    'csv_row_number'                                  => 'Numéro de ligne CSV :row',
    'max_item_lookup_records'                         => 'Max. Enregistrements de recherche d\'article',
    'invoice_with_commission_delete_error'            => 'Désolé, vous ne pouvez pas supprimer une facture comportant des entrées de commission avec un statut payé. Vous devez d\'abord supprimer la commission payée sur cette facture.',
    'if_invoice_is_emailed_while_draft'               => 'Si la facture est envoyée par e-mail alors qu\'elle est à l\'état de brouillon',
    'custom_payment_receipt_body_not_exists'          => 'Le modèle personnalisé pour les reçus de paiement est introuvable.',
    'invoice_email_body_type'                         => 'Type de corps d\'e-mail de facture',
    'send_overdue_reminder'                           => 'Envoyer un rappel de retard',
    'reminder_sent_successfully'                      => 'Rappel envoyé avec succès',
    'error_sending_reminder'                          => 'Une erreur s\'est produite lors de l\'envoi du rappel, veuillez réessayer plus tard.',
    'expense_date'                                    => 'Date de dépense',
    'group_by'                                        => 'Par groupe',
    'timeline_scope_all_user'                         => 'Portée de la chronologie - Tous les utilisateurs',
    'copy_to_clipboard'                               => 'Copier dans le presse-papier',
    'text_copied_clipboard'                           => 'Texte copié dans le presse-papier !',
    'import_example_csv'                              => 'Un exemple de fichier CSV peut être trouvé ici',
    'import'                                          => 'Importer',
    'address2'                                        => 'Adresse 2',
    'use_parent_email'                                => 'Utiliser l\'e-mail des parents',
    'max_import_records'                              => 'La limite maximale pour importer des enregistrements est :total_records',
    'demo_file_attachment_disabled'                   => 'Les pièces jointes sont désactivées dans la démo',
    'drag_drop_file'                                  => 'Glisser',
    'or'                                              => 'OU ALORS',
    'browse_file'                                     => 'Parcourir le fichier',
    'system_setting_and_ui'                           => 'Les paramètres du système',
    'localization_and_timezone'                       => 'Localisation',
    'security'                                        => 'Sécurité',
    'cleanup_and_backup'                              => 'Nettoyer',
    'attach_quote_pdf'                                => 'Joindre le devis PDF',
    'attach_payment_receipt'                          => 'Joindre le reçu de paiement',
    'choose-file'                                     => 'Choisir le fichier',
    'important-note'                                  => 'Note importante',
    'collapse'                                        => 'S\'effondrer',
    'add_task'                                        => 'Ajouter une tâche',
    'recurring_invoice_commissions'                   => 'Commissions récurrentes sur les factures',
    'invoice_commissions'                             => 'Commissions de facturation',
    'percentage'                                      => 'Pourcentage',
    'flat_amount'                                     => 'Montant forfaitaire',
    'discount-amount'                                 => 'Remise',
    'discount-type'                                   => 'Type de remise',
    'saving'                                          => 'Économie...',
    'preparing'                                       => 'En train de préparer',
    'allow_line_item_discounts'                       => 'Autoriser les remises sur les éléments de campagne',
    'invalid_price_amount'                            => 'Montant du prix invalide ! Doit être supérieur à 0.',
    'light-mode'                                      => 'Mode lumière',
    'dark-mode'                                       => 'Mode sombre',
    'system_base_currency'                            => 'Devise de base du système',
    'is_recurring_task'                               => 'Est une tâche récurrente',
    'contact_names'                                   => 'Noms des contacts',
    'all_client'                                      => 'Tous les clients',
    'invoice_grand_total'                             => 'Total général de la facture',
    'recurring_invoice_grand_total'                   => 'Total général de la facture récurrente',
    'is_required'                                     => 'Est requis?',
    'add-new-client'                                  => 'Ajouter un nouveau client',
    'client_name_required'                            => 'Le nom du client est requis',
    'custom_item_text_validate'                       => 'Veuillez saisir un élément valide :label dans le champ :label.',
    'assigned_to_others'                              => 'Attribué à d\'autres',
    'all_tasks_and_all_users'                         => 'Toutes les tâches/Tous les utilisateurs',
    'statement'                                       => 'Déclaration',
    'profile_code'                                    => 'Code de profil',
    'login-url'                                       => 'URL de connexion',
    'url_copied_clipboard'                            => 'URL copiée dans le presse-papier !',
    'payment_receipt_email_sent'                      => 'E-mail de reçu de paiement envoyé avec succès',
    'edit_payment_note_form'                          => 'Modifier la note de paiement',
    'payment_invoices_text'                           => 'Merci! Votre paiement de :amount a été appliqué aux factures suivantes.',
    'payment_text'                                    => 'Merci pour votre paiement de :amount .',
    'date_filter_by'                                  => 'Date Filtrer par',
    'filter_by_invoice_date'                          => 'Date de facturation',
    'filter_by_payment_date'                          => 'Date de paiement',
    'date-range-required'                             => 'Veuillez sélectionner la plage de dates',
    'save-and-complete'                               => 'Enregistrer et terminer',
    'completion-note'                                 => 'Note d\'achèvement',
    'complete-with-note'                              => 'Complet avec remarque',
    'placeholder_type_note'                           => 'Tapez vos notes...',
    'credit_memo_email_subject'                       => 'Objet de l\'e-mail de la note de crédit',
    'default_credit_memo_email_body'                  => 'Corps de l\'e-mail de note de crédit par défaut',
    'show_invoices_from'                              => 'Afficher les factures de',
    'system_mail_from_address'                        => 'Courrier système depuis l\'adresse',
    'user_who_created_invoice'                        => 'Utilisateur qui a créé la facture',
    'completed'                                       => 'Complété',
    'no_auth_to_view_task'                            => 'Cette tâche n\'est plus dans votre liste.',
    'credit-memo-and-prepayments'                     => 'Crédits et prépaiements',
    'all_selected'                                    => 'Tous sélectionnés',
    'select_columns'                                  => 'Sélectionnez les colonnes',
    'column_settings'                                 => 'Paramètres de colonne',
    'minimum_one_column_check_is_required'            => 'Veuillez sélectionner au moins une colonne',
    'date_of_entry'                                   => 'Date d\'entrée',
    'amount_applied'                                  => 'Montant appliqué',
    'date_applied'                                    => 'Date d\'application',
    'copy_to_recurring_invoice'                       => 'Copier sur la facture récurrente',
    'top_bar_color'                                   => 'Couleur de la barre supérieure',
    'light_grey'                                      => 'Gris clair',
    'bg-primary'                                      => 'Bleu',
    'bg-warning'                                      => 'Jaune',
    'bg-info'                                         => 'Bleu libellule',
    'bg-danger'                                       => 'Rouge',
    'bg-success'                                      => 'Vert gazon',
    'bg-indigo'                                       => 'Indigo',
    'bg-lightblue'                                    => 'Bleu Victoria',
    'bg-navy'                                         => 'Bleu marine',
    'bg-purple'                                       => 'Mauve',
    'bg-fuchsia'                                      => 'Fuchsia',
    'bg-pink'                                         => 'Rose',
    'bg-maroon'                                       => 'Bordeaux',
    'bg-orange'                                       => 'Orange',
    'bg-lime'                                         => 'Vert citron',
    'bg-teal'                                         => 'Sarcelle',
    'bg-olive'                                        => 'olive',
    'fee_name'                                        => 'Nom des frais',
    'fee_percentage'                                  => 'Pourcentage des frais',
    'fee_explanation'                                 => 'Explication des frais',
    'enable_online_payment_processing_fees'           => 'Activer les frais de traitement des paiements en ligne',
    'allow_online_payment_processing_fees'            => 'Autoriser les frais de traitement des paiements en ligne',
    'allow_online_pay_fees'                           => 'Autoriser les frais de paiement en ligne',
    'convenience_charges'                             => 'Frais de commodité',
    'opp-fee-percentage-required'                     => 'Le pourcentage des frais de traitement des paiements en ligne est requis',
    'opp-fee-percentage-gt-zero'                      => 'Le pourcentage des frais de traitement des paiements en ligne doit être supérieur à zéro',
    'cron_error'                                      => 'a échoué à :datetime',
    'cron_start'                                      => 'Le coureur de tâches quotidien a commencé à :datetime',
    'notification_clear_all'                          => 'Effacer toutes les notifications',
    'show'                                            => 'Montrer',
    'report'                                          => 'Rapport',
    'profit_loss'                                     => 'Profit et perte',
    'credit_and_pre_payments'                         => 'Crédits et prépaiements',
    'expenses_vendors'                                => 'Dépenses Fournisseurs',
    'expenses_categories'                             => 'Catégories de dépenses',
    'create'                                          => 'Créer',
    'import_map_clients'                              => 'Importer des clients de carte',
    'payctr_users'                                    => 'Utilisateurs du centre de paiement',
    'ctrl_plus_click'                                 => 'Ctrl-Clic pour ajouter des notes d\'achèvement',
    'edit_note'                                       => 'Note éditée',
    'save-and-unComplete'                             => 'Enregistrer et incomplet',
    'sales_chart'                                     => 'Tableau des ventes',
    'accumulate_totals'                               => 'Cumuler les totaux',
    'do_not_accumulate_totals'                        => 'Ne pas cumuler les totaux',
    'kpi_cards'                                       => 'Cartes KPI',
    'no_data_to_display'                              => 'Aucune donnée à afficher',
    'choose_period'                                   => 'Choisissez la période',
    'date_mailed'                                     => 'Date d\'envoi',
    'date_emailed'                                    => 'Date d\'envoi par e-mail',
    'action'                                          => 'Action',
    'mail'                                            => 'Courrier',
    'mark_as_mailed'                                  => 'Marquer comme envoyé',
    'invoice_mailed'                                  => 'La facture a été marquée comme Envoyée',
    'emailed'                                         => 'Envoyé par e-mail',
    'paid_invoice_canceled_error'                     => 'Pour annuler cette facture, veuillez supprimer les paiements de la facture.',
    'allow_invoice_delete'                            => 'Autoriser la suppression des factures',
    'allow_child_accounts'                            => 'Autoriser les comptes enfants',
    'third_party_bill_payer'                          => 'Tiers payeur de facture',
    'invoices_paid_by'                                => 'Factures payées par',
    'use_third_party_bill_payer_email'                => 'Utiliser l\'e-mail du tiers payeur de facture',
    'email_default'                                   => 'E-mail par défaut',
    'client_default'                                  => 'Client par défaut',
    'clear-all'                                       => 'Tout effacer',
    'system_log_is_missing_or_empty'                  => 'Le journal système est manquant ou vide',
    'change_to_draft'                                 => 'Changer en brouillon',
    'invoice_status_change_to_draft'                  => 'Modification du statut de la facture à Brouillon',
    'there_is_some_error'                             => 'Il y a des erreurs',
    'filter_by_date'                                  => 'Filtrer par date',
    'quote_grand_total'                               => 'Total général du devis',
    'email_upcoming_payment_due_notice'               => 'Envoyer un avis de paiement à venir par e-mail',
    'email_overdue_invoice_reminder'                  => 'Rappel de facture en retard par e-mail',
    'page_totals'                                     => 'Totaux des pages',
    'categories'                                      => 'Catégories',
    'conven_charges'                                  => 'Conv. Des charges',
    'invoice_status_change_to_cancel'                 => 'Modification du statut de la facture à Annuler',
    'filter_by_invoice_number'                        => 'Numéro de facture',
    'filter_by_client_name'                           => 'Nom du client',
    'custom_mail_template'                            => 'Modèle de courrier personnalisé',
    'invoice_use_custom_mail_template'                => 'Facture Utiliser un modèle de courrier personnalisé',
    'client_or_company_name'                          => 'Nom du client/de l\'entreprise',
    'view_invoice'                                    => 'Voir la facture',
    'tt_active'                                       => 'Lorsqu\'un enregistrement de client n\'est pas actif, il n\'apparaîtra pas dans la liste de clients par défaut et les transactions normales ne seront pas autorisées.',
    'tt_invoice_prefix'                               => 'Un code de préfixe de facture unique est automatiquement attribué à un dossier client lors de sa création. Il peut être modifié manuellement ultérieurement. Il peut être utilisé dans le cadre de votre schéma de numérotation des documents pour la numérotation des factures, permettant un numéro de facture unique par client.',
    'tt_automatic_email_payment_receipts'             => 'Envoie un reçu de paiement par e-mail au client lors du paiement. Un paramètre global est disponible dans les paramètres système, mais peut être remplacé sur la base d\'un client individuel.',
    'tt_automatic_email_on_recur'                     => 'Envoie une facture par e-mail au client lorsqu\'une facture récurrente est exécutée et crée une facture en direct. Un paramètre global est disponible dans les paramètres système, mais peut être remplacé sur la base d\'un client individuel.',
    'tt_default_currency'                             => 'La devise attribuée à ce compte client, qui sera utilisée pour leurs transactions de facturation, de devis et de paiement. Cette valeur est la valeur par défaut du paramètre système pour la devise de base.',
    'tt_language'                                     => 'La langue qui sera affichée pour le client lorsqu\'il se connectera au centre client.',
    'tt_allow_client_center_login'                    => 'Le client doit-il être autorisé à se connecter à votre centre client FusionInvoice ? Leur email doit être utilisé pour leur nom d\'utilisateur et vous devez leur attribuer un mot de passe. L\'URL du centre client est',
    'tt_timezone'                                     => 'Fuseau horaire du client. Si elle est saisie, l\'heure locale du client sera affichée en haut de la vue de la page Client.',
    'tt_allow_online_payment_processing_fees'         => 'Des frais de traitement de paiement en ligne peuvent être évalués pour les clients payant par carte de crédit, en utilisant leur lien de facturation public (inclus dans l\'e-mail de facturation). Cette option a un paramètre système global, mais peut également être annulée sur la base d\'un client individuel.',
    'tt_allow_child_accounts'                         => 'Définir Autoriser les comptes enfants sur Oui permet à ce client d\'agir en tant que compte parent et vous permettra de le sélectionner dans la liste des comptes parents.',
    'tt_third_party_bill_payer'                       => 'Un tiers payeur de factures est une organisation qui paie les factures de ses clients, comme un cabinet comptable externe.',
    'tt_parent_account'                               => 'L\'entreprise mère à laquelle ce client est lié ou une filiale de celle-ci. Cette liste contient les enregistrements de clients dont le paramètre Autoriser les comptes enfants est défini sur Oui. Laissez vide si le client n\'a pas de compte parent.',
    'tt_invoices_paid_by'                             => 'L\'entreprise tierce que ce client utilise pour payer ses factures. Cette liste contient les enregistrements de clients dont le paramètre Payeur de facture tiers est défini sur Oui. Laissez vide si le client paie ses propres factures.',
    'tt_email_default'                                => 'Lors de l\'envoi d\'e-mails à ce client, sélectionnez l\'e-mail à utiliser. Si ce client a un compte parent associé ou un compte Factures payées par, l\'une ou l\'autre de ces options peut être sélectionnée. La valeur par défaut est l\'e-mail standard du client.',
    'tt_default_to'                                   => 'Lors de l\'envoi d\'e-mails, ce contact doit-il être automatiquement ajouté à la liste des destinataires \'To:\' ?',
    'tt_default_cc'                                   => 'Lors de l\'envoi d\'e-mails, ce contact doit-il être automatiquement ajouté à la liste des destinataires \'CC:\' ?',
    'tt_default_bcc'                                  => 'Lors de l\'envoi d\'e-mails, ce contact doit-il être automatiquement ajouté à la liste des destinataires \'BCC:\' ?',
    'tt_client_type'                                  => 'Un prospect est un candidat commercial non qualifié. Un prospect est un candidat qualifié qui pourrait bientôt devenir un client. Un client est une entreprise ou un individu à qui vous avez vendu (ou allez bientôt vendre) des biens ou des services. Un affilié est une entreprise ou un particulier qui revend vos biens ou services. Autre est utilisé pour les entreprises qui ne correspondent pas aux autres types, telles que les tiers payeurs de factures ou les comptes parents avec lesquels vous ne faites pas affaire directement.',
    'tt_client_tags'                                  => 'Des balises peuvent être attribuées à un client pour vous aider à catégoriser ou à filtrer votre liste de clients à des fins d\'affichage ou de rapport.',
    'tt_important_note'                               => 'Une note saisie ici apparaîtra automatiquement dans un message IMPORTANT ! fenêtre lorsque le dossier du client est consulté.',
    'tt_gen_header_title_text'                        => 'Le texte qui s\'affiche dans le coin supérieur gauche, à côté de votre logo, généralement le nom de votre entreprise.',
    'tt_gen_default_company_profile'                  => 'Le profil d\'entreprise à utiliser par défaut lors de la création de nouvelles factures, devis, etc. Les profils d\'entreprise vous permettent de présenter votre entreprise différemment avec chaque profil, en permettant différents noms d\'entreprise, logos, formats de facture, etc.',
    'tt_gen_address_format'                           => 'Vous permet de créer le format d\'adresse affiché sur les factures et les devis en utilisant le champ d\'adresse unique ou une combinaison des champs d\'adresse individuels, tels que la ville, l\'état, le pays, etc.',
    'tt_gen_custom_fields_columns'                    => 'Les champs personnalisés peuvent être affichés de 1 à 3 champs par ligne.',
    'tt_gen_require_tags_on_client_notes'             => 'S\'il est défini sur Oui, il faudra qu\'une étiquette soit sélectionnée ou saisie lors de l\'ajout d\'une note client, telle que « Support » ou « Ventes ». Ceci est utile pour catégoriser et rechercher des notes.',
    'tt_gen_skin'                                     => 'Comment souhaitez-vous que votre interface utilisateur FI s\'affiche, en mode clair ou sombre',
    'tt_gen_top_bar_color'                            => 'La couleur de la barre de titre supérieure. Si vous travaillez avec plusieurs installations FusionInvoice différentes, cela peut être une identification visuelle utile.',
    'tt_gen_results_per_page'                         => 'Le nombre d\'enregistrements affichés par page pour toutes les vues de liste, telles que les clients, les factures, les devis, les dépenses, etc.',
    'tt_gen_allow_line_item_discounts'                => 'Active ou désactive la fonctionnalité de remise des éléments de ligne dans les factures et les devis.',
    'tt_gen_language'                                 => 'La langue à utiliser pour votre installation FusionInvoice. Notez que vous pouvez attribuer une langue différente à vos clients, leur permettant d\'interagir avec le Centre client FusionInvoice en utilisant leur langue maternelle.',
    'tt_gen_date_format'                              => 'Votre format de date préféré',
    'tt_gen_use_24_hour_time_format'                  => 'Permet la prise en charge des formats d\'heure 24 ou 12 heures.',
    'tt_gen_timezone'                                 => 'Timezine principal de votre entreprise.',
    'tt_gen_base_currency'                            => 'La devise que votre entreprise utilise le plus souvent.',
    'tt_gen_exchange_rate_mode'                       => 'Manuel vous permet de saisir la valeur du taux de change lorsque vous créez des factures. Automatique tentera d\'utiliser une API publique pour récupérer le taux de change de la devise. Ceci n\'est utilisé que lorsque vous saisissez une transaction en utilisant une devise différente de votre devise de base.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice prend en charge jusqu\'à 2 champs fiscaux par élément de ligne. La valeur sélectionnée avec afficher ou masquer le deuxième champ de taxe.',
    'tt_gen_quantity_price_decimals'                  => 'Nombre de décimales à afficher pour les valeurs de quantité et de montant. Sélectionnez 0 à 4 en fonction du niveau de précision requis.',
    'tt_gen_round_tax_decimals'                       => 'Sélectionnez le nombre de décimales requis pour les calculs d\'arrondi fiscal.',
    'tt_gen_use_captcha_in_login'                     => 'S\'il est défini sur Oui, vos utilisateurs devront répondre à une question d\'identification CAPTCHA lors de la connexion.',
    'tt_gen_force_https'                              => 'Nous recommandons rarement d\'activer cette option. Si votre installation ne dispose pas d\'un certificat SSL fonctionnant correctement installé sur votre serveur Web, pour votre installation FusionInvoice, vous pouvez rencontrer des problèmes. Vous pouvez obtenir le même résultat en configurant une règle de redirection de serveur.',
    'dashboard_settings'                              => 'Paramètres du tableau de bord',
    'tt_dashboard_settings'                           => 'Votre tableau de bord est utilisé pour afficher des mesures et des événements commerciaux importants, vous donnant un aperçu précieux des performances de votre entreprise. Le tableau de bord du système est la valeur par défaut pour tous les utilisateurs, mais dans la configuration de chaque utilisateur, vous pouvez remplacer le tableau de bord par défaut du système, en définissant des paramètres spécifiques pour chaque utilisateur. Les paramètres ci-dessous vous permettent de personnaliser votre tableau de bord.',
    'tt_db_default_time_period'                       => 'Définit les dates de début et de fin par défaut pour les widgets de tableau de bord qui les utilisent, tels que les cartes KPI et le graphique des ventes.',
    'tt_db_recent_client_activity'                    => 'Un widget qui affiche les interactions avec les clients, telles que les paiements effectués et les factures ou devis consultés, à partir de vos liens publics de facturation ou de devis.',
    'tt_db_display_order'                             => 'Cela modifie l\'ordre d\'affichage des widgets du tableau de bord. 1 s\'affichera en haut, 2 s\'affichera après 1, etc.',
    'tt_db_column_width'                              => 'Les widgets de tableau de bord utilisent le système de grille Bootstrap et ont une largeur de colonne maximale de 12. Si vous définissez la largeur de colonne sur 12, le widget utilisera toute la largeur disponible. Le régler sur 6 permettra à deux widgets de partager la même ligne, 4 permettra à 3 widgets de partager la même ligne, etc.',
    'tt_db_accumulate_totals'                         => 'Si vous activez cette valeur, votre graphique inclura les totaux des jours précédents pour chaque jour. Par exemple, les ventes du jour 1 étaient de 100 $, celles du jour 2 de 50 $ et celles du jour 3 de 125 $. Le graphique afficherait une ligne ascendante avec cette option définie sur Oui. Défini sur Non, afficherait une baisse de la ligne de vente le jour 2 et augmenterait au jour 3.',
    'tt_db_kpi_cards'                                 => 'Ces cartes à code couleur affichent des indicateurs de performance clés en haut de votre tableau de bord.',
    'tt_db_sales_chart'                               => 'Un graphique linéaire, affichant les totaux des factures et des paiements.',
    'tt_db_task_list'                                 => 'Ce widget vous permet de travailler avec le module Liste des tâches, directement depuis votre tableau de bord.',
    'tt_db_task_list_include_time'                    => 'L\'activation de cette option vous permet de spécifier la date et l\'heure des dates d\'échéance lorsque vous travaillez avec des tâches. Lorsqu\'il est défini sur Non, seule la valeur de date est utilisée.',
    'tt_db_timeline'                                  => 'Le widget de chronologie affiche une liste chronologique et consultable des événements importants du système, tels que les changements de statut du client, les factures envoyées par e-mail, les paiements effectués, les notes prises, etc.',
    'tt_ss_invoices_default_invoice_template'         => 'Sélectionnez le modèle qui sera utilisé, par défaut, lors de la création de nouvelles factures. Les modèles personnalisés doivent être placés dans .\\custom\\templates\\invoice_templates\\ et doivent être nommés avec une extension .blade.php.',
    'tt_ss_invoices_default_doc_scheme'               => 'Sélectionnez le schéma de numérotation des documents à utiliser, par défaut, lors de la création de nouvelles factures. Des schémas de numéros de documents peuvent être créés dans les paramètres de configuration et vous permettent de personnaliser vos numéros de documents (factures, devis, notes de crédit).',
    'tt_ss_invoices_invoice_due_days'                 => 'Le nombre de jours par défaut, après la date (création) de la facture, pendant lesquels la facture arrivera à échéance et devrait être payée.',
    'tt_ss_invoices_automatic_email_ri'               => 'Lorsqu\'une facture récurrente est exécutée et génère une facture en direct, cette facture en direct doit-elle être automatiquement envoyée par e-mail au client ?',
    'tt_ss_invoices_qr_code'                          => 'Faut-il apposer automatiquement un code QR sur les factures et devis par défaut. Si vous utilisez des modèles de facture ou de devis personnalisés, reportez-vous aux modèles par défaut pour ajouter le code QR à vos modèles personnalisés.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Si une facture est au statut Brouillon et est envoyée par e-mail, manuellement ou automatiquement, que doit-il advenir de la date de la facture. Remarque importante : Lorsqu\'une facture est envoyée par e-mail, le statut passe automatiquement de Brouillon à Envoyé.',
    'tt_ss_invoices_recalculate'                      => 'Exécute chaque transaction effectuée pour chaque facture, de la date de création à la date actuelle, et recalcule les totaux, les totaux des articles, les taxes, les remises et les totaux des factures. Cela peut prendre beaucoup de temps si vous avez un grand ensemble de données.',
    'tt_ss_invoices_due_after'                        => 'La date d\'échéance de la facture sera la date de la facture plus le nombre de jours saisis ici.',
    'tt_ss_invoices_default_status_filter'            => 'Le filtre de statut à appliquer, par défaut, lors de la consultation de la liste des factures.',
    'tt_ss_invoices_default_terms'                    => 'La valeur de texte des conditions qui s\'affiche, sur le modèle de facture par défaut, dans la partie inférieure de la facture, dans la zone Conditions générales.',
    'tt_ss_invoices_default_footer'                   => 'Valeur du texte de pied de page qui s\'affiche, sur le modèle de facture par défaut, au bas de la facture. Par exemple:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Lorsque le gestionnaire de tâches quotidiennes (tâche CRON) exécute et génère une facture en direct à partir d\'un modèle de facture récurrente, cette facture nouvellement créée doit-elle être automatiquement envoyée par e-mail au client ? Cela peut être remplacé client par client.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Lorsqu\'un paiement est effectué, ces informations de paiement doivent-elles être automatiquement envoyées par e-mail au client ?',
    'tt_ss_invoices_online_payment_method'            => 'Le mode de paiement qui est attribué lorsqu\'un client paie à l\'aide d\'un lien de facture publique. Les méthodes de paiement peuvent être gérées via les paramètres système.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Un QR Code, qui conduit à l\'URL publique de la facture ou du devis, doit-il être affiché sur le document ?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Les utilisateurs, même les utilisateurs administrateurs, doivent-ils être autorisés à supprimer des factures ? Une alternative plus sûre et plus traçable à la suppression des factures consiste à changer le statut de la facture en',
    'tt_ss_invoices_show_invoices_from'               => 'Lorsque les factures sont envoyées par e-mail, cela s\'affichera comme l\'adresse de l\'expéditeur. Remarque importante : la valeur Répondre à sera toujours la valeur attribuée dans les paramètres système',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Dans la vue de la facture, si la facture est au statut Brouillon et envoyée par e-mail, la date de la facture doit-elle rester inchangée ou passer à la date actuelle ? Si la date de la facture change, la date d\'échéance est également mise à jour.',
    'tt_ss_quotes_default_quote_template'             => 'Sélectionnez le modèle qui sera utilisé, par défaut, lors de la création d\'un nouveau devis. Les modèles personnalisés doivent être placés dans .\\custom\\templates\\quote_templates\\ et doivent être nommés avec une extension .blade.php.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Sélectionnez le schéma de numérotation des documents à utiliser, par défaut, lors de la création de nouveaux devis. Des schémas de numéros de documents peuvent être créés dans les paramètres de configuration et vous permettent de personnaliser vos numéros de documents (factures, devis, notes de crédit).',
    'tt_ss_quotes_expire_days'                        => 'Le nombre de jours par défaut, après la date (création) du devis, pendant lesquels le devis expirera. Lorsqu\'un devis a dépassé sa date d\'expiration, il est entendu que les prix peuvent changer en raison des fluctuations du marché, etc.',
    'tt_ss_quotes_default_status_filter'              => 'Le filtre de statut à appliquer, par défaut, lors de la consultation de la liste des factures.',
    'tt_ss_quotes_auto_convert'                       => 'Lorsqu\'un devis est approuvé, cela devrait-il entraîner la création automatique d\'une facture à partir du devis.',
    'tt_ss_quotes_when_converted_action'              => 'Lorsqu\'un devis est converti en facture, les conditions de paiement doivent-elles être utilisées à partir du devis ou du paramètre de conditions de facturation par défaut ?',
    'tt_ss_quotes_default_terms'                      => 'La valeur de texte des conditions qui s\'affiche, sur le modèle de devis par défaut, dans la zone inférieure du devis, dans la zone Conditions générales.',
    'tt_ss_quotes_default_footer'                     => 'Valeur du texte de pied de page affichée, sur le modèle de devis par défaut, au bas du devis. Par exemple:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Si un devis est au statut Brouillon et est envoyé par e-mail, manuellement ou automatiquement, que doit-il advenir de la date du devis. Remarque importante : Lorsqu\'un devis est envoyé par e-mail, le statut passe automatiquement de Brouillon à Envoyé.',
    'tt_ss_quotes_recalculate'                        => 'Exécute chaque transaction effectuée pour chaque devis, de la date de création à la date actuelle, et recalcule les totaux, les totaux des articles, les taxes, les remises et les totaux des devis. Cela peut prendre beaucoup de temps si vous avez un grand ensemble de données.',
    'tt_ss_taxes_default_rate1'                       => 'Le taux de taxe principal qui doit être automatiquement appliqué aux nouveaux éléments de ligne ajoutés aux factures ou aux devis. Les taux d\'imposition sont maintenus via Configuration -',
    'tt_ss_taxes_default_rate2'                       => 'Le taux de taxe secondaire qui doit être automatiquement appliqué aux nouveaux éléments de ligne ajoutés aux factures ou aux devis. Les taux d\'imposition sont maintenus via Configuration -',
    'tt_ss_email_send_method'                         => 'La méthode d\'envoi d\'e-mails que FusionInvoice doit utiliser. La modification de la méthode d\'envoi modifie également l\'affichage des champs de prise en charge de la méthode d\'envoi.',
    'tt_ss_email_allow_self_cert'                     => 'L\'activation de cette option désactive l\'exigence PHP verify_peer. Pour plus d\'informations, recherchez sur Internet : Certificat auto-signé de courrier électronique PHP openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Lors de l\'envoi d\'e-mails, il s\'agit de l\'adresse de réponse par défaut que vos destinataires verront.',
    'tt_ss_email_always_cc'                           => 'Une adresse e-mail que, par défaut, vous souhaitez mettre automatiquement en CC avec chaque e-mail envoyé.',
    'tt_ss_email_always_bcc'                          => 'Une adresse e-mail que, par défaut, vous souhaitez mettre automatiquement en Cci avec chaque e-mail envoyé.',
    'tt_ss_email_send_test_to'                        => 'L\'adresse e-mail à utiliser lorsque vous cliquez sur le bouton Envoyer un e-mail de test.',
    'tt_ss_email_mail_from_addr'                      => 'L\'adresse de courrier par défaut à utiliser lorsque des e-mails sont envoyés depuis FusionInvoice. Remarque : dans les paramètres système -',
    'tt_ss_email_mail_from_name'                      => 'Le nom convivial de l\'expéditeur à afficher sur les e-mails envoyés.',
    'tt_ss_email_email_templates'                     => 'Des modèles d\'e-mail sont disponibles pour de nombreux documents et événements, notamment : les devis, les approbations de devis, les rejets de devis, les factures, les factures en retard, les notes de crédit, les reçus de paiement, les avis de paiement à venir. Un modèle par défaut est inclus, mais vous pouvez également créer des modèles personnalisés, qui peuvent être simples (comme les modèles par défaut fournis) ou entièrement formatés en HTML.',
    'tt_ss_pdf_driver'                                => 'Le pilote à utiliser lors de la création de documents PDF. La sélection du pilote \'wkhtmltopdf\' nécessite une installation du serveur local de ce programme et la définition du chemin binaire approprié pour celui-ci.',
    'tt_ss_pdf_binary_path'                           => 'Le chemin du serveur local vers le fichier binaire pour wkhtmltopdf. Par exemple C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice prend en charge plusieurs fournisseurs de paiement en ligne. Activez les fournisseurs avec lesquels vous avez établi des comptes. Les fournisseurs activés ici seront affichés en tant qu\'options de paiement, lorsque vos clients consulteront leurs factures à l\'aide du lien de facture publique (inclus dans l\'e-mail de facturation par défaut).',
    'tt_ss_olp_api_key'                               => 'La clé API vous est fournie par votre fournisseur de paiement.',
    'tt_ss_olp_payment_button_text'                   => 'Le texte qui s\'affiche sur le bouton du mode de paiement pour ce fournisseur de paiement, en haut de votre facture publique, tel qu\'il est vu par vos clients.',
    'tt_ss_olp_mode'                                  => 'Pris en charge par certains fournisseurs de paiement, permettant plus de Sandbox (tests) et en direct.',
    'tt_ss_olp_client_id'                             => 'L\'identifiant client vous est fourni par ce fournisseur de paiement.',
    'tt_ss_olp_client_secret'                         => 'Le secret client vous est fourni par ce fournisseur de paiement.',
    'tt_ss_olp_publishable_key'                       => 'La clé publiable vous est fournie par ce fournisseur de paiement.',
    'tt_ss_olp_secret_key'                            => 'La clé secrète vous est fournie par ce fournisseur de paiement.',
    'tt_ss_olp_opp_fees_about'                        => 'Des frais de traitement de paiement en ligne peuvent être évalués pour les clients payant par carte de crédit, en utilisant leur lien de facturation public (inclus dans l\'e-mail de facturation).',
    'tt_ss_olp_enable_opp_fees'                       => 'Des frais de traitement de paiement en ligne peuvent être évalués pour les clients payant par carte de crédit, en utilisant leur lien de facturation public (inclus dans l\'e-mail de facturation). Cette option a un paramètre système global, mais peut également être annulée sur la base d\'un client individuel.',
    'tt_ss_olp_opp_fee_pct'                           => 'Le pourcentage du total de la facture à facturer en tant que frais de traitement des paiements en ligne (commodité).',
    'tt_ss_olp_opp_fee_name'                          => 'Le nom des frais doit être indiqué sur la facture. C\'est à dire. \'Frais de commodité de carte de crédit\'.',
    'tt_ss_olp_opp_fee_explanation'                   => 'Une explication des frais à afficher sur la facture. C\'est à dire.',
    'tt_company_profiles_about'                       => 'Les profils d\'entreprise vous permettent de présenter votre entreprise différemment avec chaque profil, permettant différents noms d\'entreprise, logos, formats de facture, etc. Il offre un moyen d\'avoir plusieurs entreprises virtuelles dans la même installation FusionInvoice. Un profil d\'entreprise par défaut doit être sélectionné dans les paramètres système.',
    'tt_users_about'                                  => 'Vous pouvez créer des utilisateurs de type Admin (accès complet) ou Standard (des autorisations système individuelles doivent être accordées). Définir « Autoriser la connexion au Centre client » sur Oui pour un enregistrement de client ajoutera automatiquement un enregistrement d\'utilisateur pour le client, cependant, les utilisateurs du client ne peuvent être ajoutés qu\'à l\'aide de l\'interface des paramètres du client.',
    'tt_users_client_about'                           => 'Les utilisateurs clients ne peuvent se connecter qu\'à l\'espace client, ce qui leur permet d\'avoir une vue limitée de leurs factures, devis et paiements. Définir « Autoriser la connexion au Centre client » sur Oui pour un enregistrement de client lui accordera l\'accès au Centre client.',
    'tt_user_types_about'                             => 'Les utilisateurs administrateurs ont un accès complet au système. Les utilisateurs standard peuvent se voir accorder les autorisations individuelles dont ils ont besoin. Les utilisateurs du client n\'ont accès qu\'à leurs informations spécifiques dans le centre client et leur capacité à se connecter est définie dans les paramètres du client -',
    'tt_custom_fields_about'                          => 'Les champs personnalisés vous permettent d\'ajouter vos propres champs de données à la plupart des modules. Si vous aviez besoin de capturer l\'industrie pour les clients, ajoutez simplement un champ personnalisé intitulé',
    'tt_recurring_invoices_about'                     => 'Les factures récurrentes ne sont pas réellement des factures, mais plutôt des modèles pour créer de futures factures. Ils ont une fréquence de récurrence et une date suivante qui déterminent quand ils généreront une facture en direct. Un travail CRON quotidien ou une tâche planifiée est requis pour que les factures récurrentes fonctionnent correctement.',
    'tt_addons_about'                                 => 'Les addons sont des personnalisations de FusionInvoice pour des besoins commerciaux uniques, tels que le suivi du temps, les furmulas de tarification ou les modèles de facture sylisés. Ils sont proposés via le marché complémentaire FusionInvoice.',
    'client_center_user'                              => 'Utilisateur du Centre client',
    'user_type'                                       => 'Type d\'utilisateur',
    'custom_field'                                    => 'Champ personnalisé',
    'placeholder_type_email_template'                 => 'Saisissez ou collez votre modèle d\'e-mail . . .',
    'email_templates'                                 => 'Modèles d\'e-mails',
    'payment_receipts'                                => 'Reçus de paiement',
    'upcoming_payment_notices'                        => 'Avis de paiement à venir',
    'convenience_fee_for_credit_card_transactions'    => 'Frais de commodité pour les transactions par carte de crédit',
    'credit_card_processing_fee'                      => 'Frais de traitement de carte de crédit',
    'delete_client_user_warning'                      => '<p>La suppression d\'un utilisateur client désactivera sa capacité à se connecter au centre client.</p>',
    'use_default_mail_template'                       => 'Modèle de courrier par défaut',
    'use_custom_mail_template'                        => 'Modèle de courrier personnalisé',
    'quote_email_body'                                => 'Corps de l\'e-mail de devis',
    'overdue_invoice_email_body'                      => 'Corps de l\'e-mail de facture en retard',
    'credit_memo_email_body'                          => 'Corps de l\'e-mail de la note de crédit',
    'payment_receipt_body'                            => 'Corps du reçu de paiement',
    'invoice_email_body'                              => 'Corps de l\'e-mail de la facture',
    'quote_custom_email_body_require'                 => 'Veuillez entrer votre modèle d\'e-mail personnalisé pour le corps de l\'e-mail de devis',
    'quote_custom_approve_email_body_require'         => 'Veuillez entrer votre modèle d\'e-mail personnalisé pour le corps de l\'e-mail d\'approbation de devis',
    'quote_reject_email_body_require'                 => 'Veuillez entrer votre modèle d\'e-mail personnalisé pour le corps de l\'e-mail de rejet de devis',
    'overdue_invoice_email_body_require'              => 'Veuillez entrer votre modèle d\'e-mail personnalisé pour le corps de l\'e-mail de facture en retard',
    'invoice_email_body_require'                      => 'Veuillez entrer votre modèle d\'e-mail personnalisé pour le corps de l\'e-mail de facture',
    'credit_memo_email_body_require'                  => 'Veuillez entrer votre modèle d\'e-mail personnalisé pour le corps de l\'e-mail de note de crédit',
    'payment_receipt_email_body_require'              => 'Veuillez entrer votre modèle d\'e-mail personnalisé pour le corps de l\'e-mail de reçu de paiement',
    'upcoming_payment_notice_email_body_require'      => 'Veuillez entrer votre modèle d\'e-mail personnalisé pour le corps de l\'e-mail d\'avis de paiement à venir',
    'copy_text'                                       => 'Copier le texte',
    'tt_preview_template'                             => 'Aperçu du modèle',
    'tt_view_template_code'                           => 'Afficher le code du modèle',
    'dashboard_date_range'                            => 'Plage de dates du tableau de bord',
    'tt_dashboard_date_range'                         => 'La plage de dates du tableau de bord filtre la vue pour les widgets suivants : cartes KPI, graphique des ventes, activité client récente.',
    'product_copy'                                    => 'Copie du produit',
    'open_selected_client'                            => 'Ouvrir le client sélectionné',
    'save_this_client'                                => 'Enregistrer ce client (pas un doublon)',
    'looks_like_duplicate'                            => 'Hmm... Cela ressemble à un doublon',
    'duplicate_instructions'                          => 'Si vous voyez le client que vous vouliez dans la liste, sélectionnez-le et ouvrez-le. Sinon, enregistrez le nouveau client.',
    'select_checkbox'                                 => 'Sélectionnez une cliente',
    'select_lead_source_tag'                          => 'Sélectionnez la source de prospect du client',
    'lead_source'                                     => 'Source principale',
    'tt_client_lead_source_tags'                      => 'Sélectionnez ou entrez la source du client potentiel (comment le client a été acquis)',
    'your_link_is_expired'                            => 'Oops! Votre lien a expiré.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Retour au tableau de bord</a>.',
    'secure_link_and_expire_link_days'                => 'Sécuriser et faire expirer les liens de facturation publique',
    'secure_link_expire_days'                         => 'Nombre de jours',
    'tt_secure_link_and_expire_link_days'             => 'Lors de l\'activation des liens sécurisés, vous devez également définir le nombre de jours après lequel le lien de facturation expirera. Ce faisant, un client peut voir le lien de sa facture publique jusqu\'à son expiration.',
    'expire_time_period'                              => 'Le champ Nombre de jours d\'expiration du lien est obligatoire',
    'enter_days'                                      => 'Entrez les jours',
    'invalid_field_name'                              => 'Veuillez entrer un nom de champ valide',
    'lead_source_notes'                               => 'Remarques sur la source de plomb',
    'important_note'                                  => 'Note importante',
    'social_media_url'                                => 'URL des réseaux sociaux',
    'general_notes'                                   => 'Notes générales',
    'payment_amount_mismatch'                         => 'Non-concordance du montant du paiement',
    'open_invoice_aging'                              => 'Ancienneté des factures ouvertes',
    'tt_db_open_invoice_aging'                        => 'Ancienneté des factures ouvertes',
    'current'                                         => 'Actuel',
    'oneToThirty'                                     => '1-30 jours',
    'thirtyOneToSixty'                                => '31-60 jours',
    'sixtyOneToNinety'                                => '61-90 jours',
    'ninetyOnePlus'                                   => '91 jours',
    'sent_and_draft'                                  => 'Inclure les factures envoyées et brouillons',
    'sent_only'                                       => 'Inclure uniquement les factures envoyées',
    'tt_open_ar_aging_settings'                       => 'Paramètres pour les totaux chronologiques des factures en cours',
    'tt_client_field_settings'                        => 'Sélectionnez les champs que vous souhaitez afficher sur votre vue client',
    'position_change'                                 => 'Poste modifié',
    'dynamic_width'                                   => 'Largeur dynamique',
    'full_width'                                      => 'Pleine largeur',
    'save_configuration_default'                      => 'Enregistrer la configuration comme système par défaut',
    'assign_configuration_other'                      => 'Attribuer la configuration à d\'autres utilisateurs',
    'tt_user_tags'                                    => 'Balises utilisateur',
    'select_users'                                    => 'Sélectionnez les utilisateurs',
    'configuration_assigned'                          => 'Configuration attribuée avec succès',
    'default_configuration_set'                       => 'Configuration par défaut définie avec succès',
    'current_user_id'                                 => 'ID utilisateur actuel',
    'tt_users_settings'                               => 'Paramètres des utilisateurs',
    'invoice_link_expire'                             => 'Le lien public de votre facture expirera dans',
    'quote_link_expire'                               => 'Le lien public de votre devis expirera dans',
    'dashboard_width'                                 => 'Le paramètre de largeur de colonne du tableau de bord :widthName a été modifié',
    'unmark_mailed'                                   => 'Décocher comme envoyé',
    'invoice_unmark_mailed'                           => 'Facture non marquée comme envoyée',
    'print_mark_mailed'                               => 'Imprimer',
    'public_link'                                     => 'Lien public',
    'tt_sales_chart_settings'                         => 'Réglage pour le tableau des ventes facture/total',
    'verify_key'                                      => 'Vérification de la clé de produit',
    'enter_key'                                       => 'Entrez votre clé',
    'verify'                                          => 'Vérifiez-le !',
    'key_required'                                    => 'La clé de produit est requise',
    'key_length_invalid'                              => 'Veuillez entrer la clé de produit à 32 caractères fournie au moment de l\'achat.',
    'invalid_key'                                     => 'Désolé, votre clé n\'est pas valide. L\'installation ne peut pas continuer.',
    'key_verified'                                    => 'Félicitations, votre clé a été vérifiée.',
    'clear_cache'                                     => 'Vider le cache',
    'clear_cache_confirm'                             => 'Voulez-vous vraiment vider le cache de votre application ?',
    'cache_clear_success'                             => 'Cache effacé avec succès.',
    'cache_clear_error'                               => 'Veuillez vérifier la configuration de votre serveur pour la commande PHP exec().',
    'add_new_client'                                  => 'Ajouter un nouveau client',
    'add'                                             => 'Ajouter',
    'invalid_quantity_amount'                         => 'Montant de la quantité invalide ! Doit être supérieur à 0.',
    'api_version'                                     => 'Version de l\'API',
    '2021_prior'                                      => '2021 et avant',
    '2022_later'                                      => '2022 et versions ultérieures',
    'vendors'                                         => 'Vendeurs',
    'file_not_found'                                  => ':file_name est introuvable',
    'leave_empty_no_parent_account'                   => 'laisser vide si le client n\'a pas de compte parent',
    'leave_empty_client_pays_invoices'                => 'laisser vide si le client paie ses propres factures',
    'modal_not_found'                                 => 'Mode introuvable',
    'payment_delete_success'                          => 'Paiement supprimé avec succès',
    'payment_delete_error'                            => 'Un problème est survenu lors de la suppression du paiement, veuillez réessayer plus tard.',
    'status_change_error'                             => 'Quelque chose s\'est mal passé ! Le statut n\'a pas été modifié.',
    'total_payments'                                  => 'Paiements totaux',
    'licence_verification_error'                      => 'Impossible de vérifier votre clé de licence.',
    'line_item_discount_limit'                        => 'Les éléments de campagne ne peuvent pas bénéficier d\'une remise supérieure à 99,99 %.',
    'date_range_report'                               => 'Plage de dates (prochaine date d\'exécution)',
    'no_client_found'                                 => 'Hmmm… nous n\'avons pas pu trouver ce client.',
    'tt_line_item_discount'                           => 'Une remise sur un article peut être calculée selon un pourcentage du prix ou un montant forfaitaire pour le prix de l\'article individuel.',
    'functionality_not_available_on_demo'             => 'Désolé, cette fonction n\'est pas autorisée dans la démo.',
    'vat_tax_id'                                      => 'Numéro de TVA',
    'tt_vat_tax_id'                                   => 'Numéro de taxe sur la valeur ajoutée (TVA)',
    'enable_vat_tax_id'                               => 'Activer le numéro de TVA',
    'no-attachment'                                   => 'Il n\'y a pas de pièce jointe',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Nettoyer',
    'allow_edit_status_invoice'                       => 'Modifier la facture de :status',
    'tt_ss_allow_edit_invoices_status'                => 'Par mesure de sécurité, seules les factures au statut Brouillon peuvent être modifiées. Vous pouvez remplacer cela en autorisant la modification des factures envoyées et/ou payées.',
    'allow_edit_invoices_status'                      => 'Autoriser la modification des factures en statut',
    'draft_and_sent'                                  => 'Brouillon et envoyé',
    'draft_or_sent_and_paid'                          => 'Brouillon, envoyé et payé',
    'invoice_editable'                                => 'Facture modifiable',
    'can_not_edit_paid_invoice'                       => 'Vous ne pouvez pas modifier une facture payée',
    'item_category'                                   => 'Catégorie d\'article',
    'itemLookups'                                     => 'Recherches d\'articles',
    'quoteItems'                                      => 'Articles de devis',
    'invoiceItems'                                    => 'Articles de facture',
    'imports_disabled_in_demo.'                       => 'Les importations sont désactivées dans la démo.',
    'no_file_selected'                                => 'Aucun fichier sélectionné',
    'no_import_records'                               => 'Aucun enregistrement à importer n\'a été trouvé',
    'vendor_name'                                     => 'Nom du fournisseur',
    'license_key'                                     => 'Clé de licence',
    'change_license_key'                              => 'Changer la clé de licence',
    'verify_and_save'                                 => 'Vérifier',
    'same_key_error'                                  => 'Aucun changement détecté. Veuillez essayer une autre clé',
    'trying_invalid_key'                              => 'Désolé, cette clé n\'a pas pu être vérifiée. La clé de licence n\'a pas été modifiée.',
    'key_updated'                                     => 'Toutes nos félicitations! Votre clé de licence a été mise à jour avec succès.',
    'invalid_date_format'                             => 'Format de date invalide. Format requis: AAAA-MM-JJ',
    'invalid_datetime_format'                         => 'Format DateHeure invalide. Format requis: AAAA-MM-JJ HH:MM :SS',
    'profile_setting'                                 => 'Paramètres de profil',
    'include_draft_invoices_unpaid_and_overdue'       => 'Inclure les brouillons de factures dans les listes impayées et en retard',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Si défini sur Oui, les factures dont le statut est Brouillon seront incluses dans les listes et les calculs pour les factures en retard et impayées.',
    'tt_utilities_import'                             => 'Importez des données à partir de fichiers CSV dans votre base de données FusionInvoice.',
    'tt_utilities_export'                             => 'Exportez les données de votre base de données FusionInvoice dans différents formats: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Affichez le fichier journal qui contient tous les événements de courrier électronique dans FusionInvoice.',
    'tt_utilities_system_log'                         => 'Affichez le fichier journal du système contenant les événements d\'erreur et d\'avertissement du système.',
    'tt_utilities_tag_cleanup'                        => 'Supprime les balises qui ont été définies, mais non utilisées. Supprime également toutes les balises en double.',
    'tt_utilities_pdf_cleanup'                        => 'Supprime les fichiers PDF temporaires.',
    'tt_utilities_recalc_invoices'                    => 'Analyse chaque facture, en s\'assurant que les totaux correspondent à la somme de tous les articles, en tenant compte des remises et des taxes. *Cela peut prendre beaucoup de temps.',
    'tt_utilities_recalc_quotes'                      => 'Analyse chaque devis, en s\'assurant que les totaux correspondent à la somme de tous les éléments de campagne, en tenant compte des remises et des taxes. *Cela peut prendre beaucoup de temps.',
    'tt_utilities_clear_cache'                        => 'Supprime les fichiers de cache temporaires.',
    'tt_utilities_download_database'                  => 'Téléchargez un fichier de base de données exporté à partir de vos données FusionInvoice en direct. Plus votre base de données est grande, plus cela prendra du temps.',
    'tt_utilities_run_daily_tasks'                    => 'Une tâche CRON ou une tâche planifiée exécute normalement vos tâches quotidiennes. Cela vous permet de le faire manuellement. Il génère des factures en direct à partir de modèles de factures récurrentes, envoie des rappels de paiement, etc.',
    'include_line_item_detail'                        => 'Inclure les détails de l\'élément de campagne',
    'invoice_tags'                                    => 'Étiquettes de facture',
    'related_accounts'                                => 'Comptes associés',
    'not_found_related_clients'                       => 'Aucun compte client associé n\'a été attribué',
    'invoices_paid_for_list'                          => 'Ce compte client paie des factures pour',
    'child_accounts_exist'                            => 'Le paramètre Autoriser les comptes enfants est revenu à Oui. Impossible de passer à Non lorsqu\'il existe des comptes enfants.',
    'third_bp_accounts_exist'                         => 'Le paramètre Payeur de facture tiers est revenu à Oui. Impossible de passer à Non lorsque des comptes associés existent.',
    'tag_name'                                        => 'Nom de la balise',
    'tag_new_name'                                    => 'Nouveau nom de balise',
    'tag_category'                                    => 'Catégorie de balise',
    'rename_tags'                                     => 'Renommer les balises',
    'apply'                                           => 'Appliquer',
    'select_tag_category'                             => 'Sélectionner la catégorie de balise',
    'tt_utilities_rename_tags'                        => 'Renommer les balises attribuées aux clients, notes, activités de vente, etc.',
    'system_default_dashboard'                        => 'Tableau de bord par défaut du système',
    'user_specific_dashboards'                        => 'Tableaux de bord spécifiques à l\'utilisateur',
    'tt_default_client_type'                          => 'Type de client par défaut',
    'default_client_type'                             => 'Type de client par défaut',
    'invalid_user'                                    => 'Veuillez sélectionner un utilisateur valide.',
    'create_live_invoice'                             => 'Créer une facture en direct',
    'create_live_invoice_successfully'                => 'Facture en direct',
    'create_live_invoice_unsuccessfully'              => 'La facture en direct n\'a pas été créée',
    'live_invoice_not_generate'                       => 'Impossible de générer une facture en direct à partir d\'une facture récurrente qui a une date d\'arrêt d\'aujourd\'hui ou antérieure, ou une prochaine date plus de 30 jours dans le futur.',
    'data_seeder'                                     => 'Semeur de données',
    'select_module'                                   => 'Sélectionnez le module',
    'number_of_seed'                                  => 'Nombre de graines',
    'seed_it'                                         => 'Semez-le !',
    'seeds_success'                                   => 'Graines ajoutées avec succès',
    'tt_ri_generate_the_next_live_invoice'            => 'Générez la prochaine facture en direct pour cette facture récurrente dès maintenant.',
    'system_log_clear_message'                        => 'Voulez-vous vraiment effacer le journal système ? Cette action ne peut pas être annulée et tous les journaux précédents seront définitivement supprimés.',
    'system_log_clear_successfully'                   => 'Journal système effacé avec succès',
    'payment_problem'                                 => 'Un problème est survenu lors du paiement. Veuillez réessayer plus tard.',
    'log_detail'                                      => 'Cliquez ici pour afficher le journal détaillé.',
    'log_limit_message'                               => 'Fichier journal',
    'log_download_file'                               => 'Télécharger un fichier',
    'log_delete_all'                                  => 'Supprimer tous les fichiers',
    'log_level'                                       => 'Niveau',
    'log_context'                                     => 'Contexte',
    'log_date'                                        => 'Date',
    'log_line_number'                                 => 'Numéro de ligne',
    'log_content'                                     => 'Contenu',
    'addon_install_error'                             => 'Il y a un problème avec l\'installation de l\'addon, veuillez réessayer plus tard.',
    'addon_installed_success'                         => 'Module complémentaire installé avec succès.',
    'allow_edit_status_credit_memo'                   => 'Modifier une note de crédit appliqué',
    'database_seeder'                                 => 'Semoir',
    'tt_utilities_database_seeder'                    => 'Semez votre base de données avec des données de test à l\'aide de classes de départ',
    'vat_information'                                 => 'Informations TVA',
    'tt_vat_information'                              => 'Numéro de compte bancaire IBAN, BIC, Email etc...',
    'explore_addons'                                  => 'Explorer les modules complémentaires',
    'available_addons'                                => 'Modules complémentaires FusionInvoice disponibles',
    'addon_success'                                   => 'Le module complémentaire a été ajouté avec succès.',
    'payment_cannot_enabled_in_demo'                  => 'Les passerelles de paiement ne peuvent pas être activées dans la démo',
    'confirm_approve_leave_page'                      => 'Il y a des modifications non enregistrées sur cette page ! Êtes-vous sûr de vouloir quitter sans sauvegarder?',
    'leave'                                           => 'Partir',
    'demo_date_refresh'                               => 'Les données de démonstration seront actualisées dans',
    'minutes'                                         => 'minutes',
    'minute'                                          => 'minute',
    'seconds'                                         => 'secondes',
    'mautic-authentication-fail'                      => 'Vous n\'êtes pas autorisé à accéder à cette ressource. Veuillez utiliser une clé secrète valide.',
    'something_went_wrong'                            => 'Quelque chose s\'est mal passé !',
    'month_to_date'                                   => 'Ce mois-ci à ce jour',
    'quarter_to_date'                                 => 'Ce trimestre à ce jour',
    'year_to_date'                                    => 'Cette année',
    'last_active'                                     => 'Dernier actif',
    'database_seeder_stop'                            => ':name ARRÊT DU SEEDER D\'AFFAIRES',
    'database_seeder_start'                           => ':name DÉBUT DU SEEDER D\'AFFAIRES',
    'seeder_records_created'                          => ':total Enregistrements créés avec succès pour :modal',
    'seeder_credit_apply_invoice'                     => 'Avoir appliqué à la facture',
    'seeder_quote_approve_reject'                     => 'Devis approuvé et rejeté',
    'seeder_executed'                                 => 'Seeder exécuté avec succès !',
    'seeder_not_executed'                             => 'Seeder n\'a pas été exécuté !',
    'db_to_file_system_attachments_migration'         => 'Migration des pièces jointes - Base de données vers le système de fichiers',
    'attachment_content_count'                        => 'Vous êtes sur le point de migrer un total de',
    'attachment_repeat_content_count'                 => 'Vous êtes sur le point de migrer un total de',
    'attachment_key_invalid'                          => 'La clé de pièce jointe n\'est pas valide',
    'stop'                                            => 'Arrêt!',
    'attachment_migration_warning'                    => 'Cette étape migrera les pièces jointes de votre base de données vers votre système de fichiers. Veuillez effectuer une sauvegarde complète de la base de données avant de continuer et assurez-vous que vous disposez de suffisamment d\'espace disque pour effectuer cette opération.',
    'attachment_agreement_accept'                     => 'J\'ai sauvegardé ma base de données.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => 'Mot de passe Microsoft 365',
    'office365_username'                              => 'Nom d\'utilisateur Microsoft 365',
    'custom_date_formula_note1'                       => '<b><u>Espaces réservés aux valeurs par défaut :</span></u></b>~<br> Vous pouvez utiliser <b>aujourd’hui, demain et hier</b> n’importe quelle valeur par défaut.<br>',
    'custom_date_formula_note2'                       => '<b>Pour aujourd\'hui + N jours, utilisez </b> \'default\': \'+7\' Cela ajoute 7 jours à la date d\'aujourd\'hui <br><b>Pour aujourd\'hui - N jours, utilisez </b> \'default\': \'-7\' Cela soustraira 7 jours à la date d\'aujourd\'hui <br>',
    'mail_config_error'                               => 'Impossible d\'envoyer un e-mail test sans que la méthode d\'envoi d\'e-mail soit définie.',
    'db_prefix_alert'                                 => 'Nous avons remarqué que vous utilisez un préfixe de base de données de :prefix . FusionInvoice ne prendra pas en charge les préfixes de base de données dans les versions futures. Veuillez modifier votre base de données et renommer toutes vos tables en supprimant le préfixe, puis modifier votre fichier database.php et définir la valeur "préfixe" sur vide.',
    'db_prefix_alert_title'                           => 'La prise en charge des préfixes de base de données se termine bientôt',
    'add_title_bar_shortcut'                          => 'Ajouter un raccourci dans la barre de titre',
    'title_bar_shortcuts'                             => 'Raccourcis de la barre de titre',
    'select_icon'                                     => 'Sélectionnez l\'icône',
    'all_payment_method'                              => 'Tous les moyens de paiement',
    'about'                                           => 'À propos',
    'own_license'                                     => 'Propre licence',
    'tt_own_license'                                  => 'Propre licence',
    'git_branch'                                      => 'Branche actuelle de Git',
    'quote_email'                                     => 'E-mail de devis',
    'custom1'                                         => 'Personnalisé 1',
    'custom2'                                         => 'Personnalisé 2',
    'custom3'                                         => 'Personnalisé 3',
    'default_document_template'                       => 'Modèle de document par défaut',
    'default_email_template'                          => 'Modèle d\'e-mail par défaut',
    'sms'                                             => 'SMS',
    'pricing_formula'                                 => 'Formule de tarification',
    'is_mobile'                                       => 'Est-ce mobile ?',
    'default_sms_template'                            => 'Modèle SMS par défaut',
    'sms_log'                                         => 'Journal SMS',
    'two_factor_auth'                                 => 'Authentification à deux facteurs',
    'enabled_mail_driver'                             => 'Veuillez activer le service de messagerie',
    'otp'                                             => 'Bureau du Procureur',
    'invalid_otp'                                     => 'Code de vérification invalide',
    'otp-subject'                                     => 'Connexion OTP',
    'resend_otp_success'                              => 'Code de vérification Renvoyer',
    'resend_otp_btn'                                  => 'Renvoyer le code',
    'expired_otp'                                     => 'Le code de vérification est expiré',
    'token_expired'                                   => 'Votre jeton CSRF est expiré',
    'verification_code'                               => 'Le code de vérification',
    'migration'                                       => 'Migration',
    'invoice_status_change_draft_to_sent'             => 'Le statut de la facture est passé de brouillon à envoyé',
    'default_sales_quantity'                          => 'Quantité de vente par défaut',
    'lead_time'                                       => 'Moy. Délai (jours)',
    'primary_vendor_id'                               => 'Fournisseur préféré',
    'all_items'                                       => 'Tous les articles',
    'non_inventory_items'                             => 'Articles hors stock',
    'back_ordered'                                    => 'En rupture de commande',
    'low_inventory'                                   => 'Faible niveau des stocks',
    'high_inventory'                                  => 'Inventaire élevé',
    'merge_client_records'                            => 'Fusionner les enregistrements clients',
    'primary_merge_to_client'                         => 'Fusionner dans (conserver)',
    'surrogate_merge_from_client'                     => 'Fusionner depuis (rejeter)',
    'merge'                                           => 'Fusionner',
    'merge_action'                                    => 'Action de fusion',
    'ignore'                                          => 'Ignorer',
    'overwrite'                                       => 'Écraser',
    'add_to'                                          => 'Ajouter à',
    'select_merge_client'                             => 'Sélectionner pour fusionner',
    'client_to_and_from_not_same'                     => 'Le client vers et le client de doivent être différents.',
    'client_id_required'                              => 'Le champ de sélection du client doit être à la fois obligatoire et unique.',
    'is_merge'                                        => 'Fusionner',
    'record_successfully_merged'                      => 'Enregistrement fusionné avec succès',
    'service_ends'                                    => 'Fin du service',
    'service_starts'                                  => 'Démarrage des services',
    'explanation'                                     => 'Explication',
    'subscription_details'                            => 'Détails de l\'abonnement',
    'generate_next_invoice'                           => 'Générer la prochaine facture',
    'subscription'                                    => 'Abonnement',
    'of_the'                                          => 'De la',
    'on'                                              => 'Sur',
    'invoice_month'                                   => 'Mois de facturation',
    'invoice_year'                                    => 'Année de facturation',
    'next_month'                                      => 'Le mois prochain',
    'next_year'                                       => 'L\'année prochaine',
    'day'                                             => 'Jour',
    'last_date'                                       => 'Dernier rendez-vous',
    'merge_record_warning'                            => 'Arrêt! La fusion des comptes clients ne peut pas être annulée. En plus des champs que vous avez choisi d\'écraser ou d\'ajouter, tout l\'historique des transactions du client issu de la fusion sera transféré au client issu de la fusion. Êtes-vous sûr de vouloir fusionner ces comptes clients?',
    'merge_child_account_warning'                     => 'Le client Merge(From) possède un compte parent avec des comptes enfants associés qui seront réaffectés au client Merge(To). Veuillez vous assurer que le client Merge(To) est autorisé en tant que compte parent.',
    'merge_parent_account_warning'                    => 'La fusion supprimera votre association avec le compte parent.',
    'merge_invoices_paid_by_warning'                  => 'La fusion supprimera votre association avec la facture parent payée par.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'Le nombre de relations dans le modèle Client a changé.',
    'payment_terms'                                   => 'Modalités de paiement',
    'net_amount_due_in'                               => 'Montant net dû en',
    'net_amount_due_by'                               => 'Montant net dû au plus tard',
    'if_paid_within'                                  => 'si payé dans les',
    'if_paid_by'                                      => 'si payé par',
    'th_of_next_month'                                => 'le mois prochain',
    'of_next_month'                                   => 'du mois prochain',
    'down_payment'                                    => 'Acompte',
    'balance_amount_due_of'                           => 'montant du solde dû en',
    'payment_split_over'                              => 'Paiement fractionné',
    'installments'                                    => 'versements',
    'days_from_invoice_date'                          => 'jours à compter de la date de facture',
    'payment'                                         => 'Paiement',
    'one'                                             => 'Un',
    'two'                                             => 'Deux',
    'three'                                           => 'Trois',
    'four'                                            => 'Quatre',
    'five'                                            => 'Cinq',
    'six'                                             => 'Six',
    'discount_percent'                                => 'Pourcentage de remise',
    'discount_days_simple'                            => 'Jours de réduction simples',
    'discount_days_nth'                               => 'Jours de réduction Nth',
    'net_due_days'                                    => 'Jours d\'échéance nets',
    'balance_due_days'                                => 'Jours d\'échéance du solde',
    'number_of_installments'                          => 'Nombre d\'installations',
    'payment_term'                                    => 'Conditions de paiement',
    'select_payment_term'                             => 'Sélectionnez les conditions de paiement',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'Le champ Pourcentage de versement :index est obligatoire et supérieur à zéro.',
        'installment_due_days_error'                  => 'Les jours d\'échéance des versements :index déposés sont requis',
        'discount_percent_gt_error'                   => 'Le pourcentage de remise déposé est obligatoire et supérieur à zéro.',
        'discount_percent_lt_error'                   => 'Le pourcentage de remise déposé est requis et inférieur à 100%.',
        'down_payment_percent_lt_error'               => 'Le pourcentage d\'acompte déposé est requis et inférieur à 100%.',
        'discount_percent_numeric_error'              => 'Le champ Pourcentage de remise doit être une valeur numérique et inférieure à 100%.',
        'down_payment_gt_error'                       => 'L\'acompte déposé est requis et supérieur à zéro.',
        'discount_days_gt_net_days_error'             => 'Le montant net des jours d\'échéance doit être supérieur aux jours de remise.',
        'discount_days_nth_gt_net_days_error'         => 'Le montant net des jours dus doit être supérieur au Nième jour de remise.',
        'installment_due_days_gt_error'               => 'Les jours d\'échéance des versements :index doivent être supérieurs aux jours d\'échéance des versements :preIndex.',
        'installment_percent_total_error'             => 'Le total du pourcentage de versement n’est pas exact. il doit être égal à 100 %.',
        'installment_percent_numeric_error'           => 'Le total du pourcentage de versement n’est pas exact. Il doit s\'agir d\'une valeur numérique.',
        'term_discount'                               => 'Remise à terme',
        'installment_due_days_gt_zero_error'          => 'Les jours d\'échéance des versements :index doivent être supérieurs ou égaux à zéro.',
        'net_due_days_error'                          => 'Le montant net dû en jours doit être supérieur à zéro et doit être déposé.',
        'discount_days_simple_error'                  => 'Le nombre de jours de remise simple doit être supérieur à zéro et doit être déposé.',
        'discount_days_nth_error'                     => 'Les Nièmes jours de remise doivent être supérieurs à zéro et doivent être déposés.',
        'balance_due_days_error'                      => 'Le solde dû en jours doit être supérieur à zéro et doit être déposé.',
        'status_error'                                => 'Désolé, le statut n\'a pas changé en raison du terme utilisé dans la facture.',
        'down_payment_type_invoice_description_error' => 'Le jeton de description de facture saisi ne correspond pas à votre type d\'acompte.',
        'down_payment_type_quote_description_error'   => 'Le jeton de description de devis saisi ne correspond pas à votre type d\'acompte.',
    ],
    'quotes_delete_error'                             => 'Erreur de suppression des guillemets',
    'for'                                             => 'Pour',
    'production'                                      => 'Production',
    'access_token'                                    => 'Jeton d\'accès',
    'application_id'                                  => 'ID d\'application',
    'location_id'                                     => 'Identifiant du lieu',
    'fi_config_check'                                 => 'Vérification des prérequis',
    'requirement'                                     => 'Exigence',
    'required'                                        => 'Requis',
    'actual'                                          => 'Réel',
    'result'                                          => 'Résultat',
    'db_prefix_setup_alert'                           => 'Votre base de données FusionInvoice utilise des préfixes DB. La prise en charge des préfixes de base de données a pris fin avec la version 2023-3.0. Afin de poursuivre la mise à niveau vers cette version et les versions ultérieures, vous devez supprimer les préfixes de base de données. Vous pouvez le faire en renommant toutes les tables de votre base de données, en supprimant le préfixe et en définissant également la valeur \'prefix\' => \'\', dans votre fichier database.php.',
    'open_tasks'                                      => 'Tâches ouvertes',
    'closed_tasks'                                    => 'Tâches fermées',
    'select_status'                                   => 'Sélectionnez le statut',
    'net_amount_due_invoice'                          => 'Montant net dû dans :days jours.',
    'days_add_in_current_date'                        => 'La date actuelle, au <span class="text-blue">:date</span> , et la date d\'échéance, doivent être considérées comme <span class="text-blue">:date</span>  <span class="text-danger">plus</span> <span class="text-blue">le nombre de jours</span>.',
    'terms'                                           => 'Termes',
    'quote_rejecting_error'                           => 'La facture n° :invoice_number a été créée le :invoice_date à compter de l\'approbation de ce devis. Vous devez supprimer ou annuler cette facture avant de rejeter ce devis.',
    'resend_record_warning'                           => 'Renvoyer cet e-mail maintenant?',
    'resend_email'                                    => 'Ré-envoyer l\'email',
    'requirement_check_fail'                          => 'Avant que l\'installation puisse continuer, vous devez corriger les échecs indiqués ci-dessus.',
    'failed'                                          => 'Échoué',
    'subscriptions'                                   => 'Abonnements',
    'tt_explanation'                                  => 'Saisissez une description du service avec des espaces réservés de date facultatifs. Vous pouvez utiliser les jetons suivants pour insérer dynamiquement les dates de début et de fin du service:{{service_starts_on}} et {{service_ends_on}}. Celles-ci seront remplacées par les dates de début et de fin réelles lorsque le contenu sera affiché.',
    'tt_ss_invoices_default_payment_terms'            => 'Conditions de paiement par défaut de la facture',
    'invoices_default_terms'                          => 'Conditions par défaut des factures',
    'net_amount_due_in_n_days'                        => 'Montant net dû dans N jours',
    'last_day'                                        => 'Dernier jour',
    'down_payment_payment_term1'                      => 'Acompte de',
    'down_payment_payment_term2'                      => 'est requis.  Le solde est dû dans',
    '1_type'                                          => 'Une facture créée aujourd\'hui sera due dans <span class="text-primary">#N</span> jours',
    '2_type'                                          => 'Une facture créée aujourd\'hui permettra une remise si elle est payée avant le <span class="text-primary">#date</span> , sinon, le montant total est dû dans <span class="text-primary">#N</span>  jours',
    '3_type'                                          => 'Une facture créée aujourd\'hui permettra une remise si elle est payée avant le <span class="text-primary">#date</span>  . Le montant net est dû dans <span class="text-primary">#N</span>  jours',
    '4_type'                                          => 'Une facture créée aujourd\'hui nécessitera un acompte de <span class="text-primary">#amount</span>  . Le solde restant sera dû dans <span class="text-primary">#N</span>  jours',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>Une facture créée aujourd\'hui et répartie sur <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Paiement <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Échéance <span class="text-primary">#date</span></p>',
    'installment'                                     => 'Versement',
    'apply_payment_terms'                             => 'Appliquer le montant de la remise sur les conditions de paiement',
    'payable_amount'                                  => 'Montant final à payer',
    'payable_amount_lt_error'                         => 'Le montant final à payer doit être inférieur au solde de la facture.',
    'payment_term_type_4_amount'                      => 'Paiement partiel du :amount accepté',
    'net_terms'                                       => 'Conditions nettes',
    'proforma_invoice_default'                        => 'Facture pro forma par défaut',
    'expense_vendor'                                  => 'Fournisseur de dépenses',
    'expense_vendor_deleted'                          => 'Le fournisseur de dépenses a été supprimé',
    'expense_vendor_already_used'                     => 'Vous ne pouvez pas supprimer un fournisseur comportant des entrées de dépenses associées.',
    'total_must_be_gt_zero'                           => 'Le total :modal_name doit être supérieur à zéro.',
    'payment_failed'                                  => 'Le paiement a échoué avec :error',
    'xss_validation'                                  => 'Le champ :attribute contient des balises qui pourraient exposer une vulnérabilité XSS',
    'support_desk'                                    => 'Bureau d\'assistance',
    'choose_file'                                     => 'Choisir le fichier',
    'supportTicket'                                   => 'Bureau d\'assistance',
    'create_support_ticket'                           => 'Créer un ticket d\'assistance',
    'supportTicket_inbox_view'                        => 'Bureau d\'assistance',
    'support_ticket'                                  => 'Billet d\'assistance',
    'ticket_number'                                   => 'Numéro de billet',
    'revision'                                        => 'Révision',
    'revisions'                                       => 'Révisions',
    'recurring_invoices'                              => 'Factures récurrentes',
    'message'                                         => 'Message',
    'custom_img'                                      => 'Image personnalisée',
    'please_fill_some_data'                           => 'Veuillez remplir les données requises sur le nouvel article.',
    'assigned'                                        => 'Attribué',
    'add_ons_will_be_disabled'                        => 'LES ADD-ONS SUIVANTS SERONT DÉSACTIVÉS:',
    'add_ons_will_be_disabled_msg'                    => 'Tous les modules complémentaires sont automatiquement désactivés lors d\'une mise à niveau principale de FusionInvoice. Une fois cette mise à niveau terminée, assurez-vous de télécharger les fichiers zip du module complémentaire approprié et de les installer. Une fois que vous avez fait cela, vous pouvez les réactiver à partir du menu Paramètres système, Personnalisations, Modules complémentaires et en sélectionnant [Installer].',
    'price_not_valid'                                 => 'Le prix doit être supérieur à zéro',
    'free_space'                                      => 'Espace libre',
    'expense_type'                                    => 'Type de dépense',
    'standard_expense'                                => 'Dépense standard',
    'expense_with_deductible_tax'                     => 'Dépense avec taxe déductible',
    'remittance_to_tax_authority'                     => 'Remise à l\'administration fiscale',
    'tax_paid'                                        => 'Impôt payé',
    'tax_detail'                                      => 'Détails fiscaux',
    'select_expense_type'                             => 'Sélectionnez le type de dépense',
    'taxes_paid_on_expenses_or_remitted'              => 'Impôts payés sur les dépenses ou remis',
    'tax_name'                                        => 'Nom de la taxe',
    'last_activity'                                   => 'Dernière Activité',
    'select_default_company_profile'                  => 'Veuillez sélectionner votre profil d\'entreprise par défaut',
    'mn_sales_tax'                                    => 'Taxe de vente du Minnesota',
    'taxes_collected_on_sales'                        => 'Taxes perçues sur les ventes',
    'vatgst_tax_note'                                 => 'Oui calcule la taxe comme étant incluse dans le total de l\'article. Non, la taxe sera ajoutée au total de l\'article.',
    'tt_vatgst_tax'                                   => 'Pour cet exemple, nous supposerons un taux de taxe de 5% et un prix d\'article de 100$. Si vous définissez Activer la TVA/TPS sur Oui, vous obtiendrez un total de facture de 100 $, le montant de l\'article s\'ajustant à 95,24 $ et un montant de taxe de 4,76 $. Si vous définissez la TVA/TPS sur Non, vous obtiendrez une facture totale de 105$, avec un prix d\'article de 100$ et une taxe de 5$.',
    'level_of_detail'                                 => 'Niveau de détail',
    'tax_report'                                      => 'Rapport fiscal',
    'detail'                                          => 'Détail',
    'totals'                                          => 'Totaux',
    'totals_with_dots'                                => 'Totaux . . .',
    'yes_all'                                         => 'Oui tout)',
    'invoices_only'                                   => 'Factures uniquement',
    'payment_receipts_only'                           => 'Reçus de paiement uniquement',
    'role'                                            => 'Rôle',
    'previous_email'                                  => 'Courriel précedent',
    'web_store_user_id'                               => 'ID utilisateur de la boutique Web: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Montant net dû au <span class="text-info">#LASTDATE</span>',
        '2_type'       => 'Une réduction de #DISCOUNTPERCENT % peut être appliquée si le paiement est effectué avant le <span class="text-info">#DISCOUNTDATE</span> , sinon le montant net est dû avant <span class="text-info">#LASTDATE</span> .',
        '3_type'       => 'Une remise de #DISCOUNTPERCENT % peut être appliquée si le paiement est effectué avant le <span class="text-info">#DISCOUNTDATE</span> , sinon le montant net est dû avant <span class="text-info">#LASTDATE</span> .',
        '4_type'       => 'Un acompte de <span class="text-info">#DOWNPAYMENT</span>  est effectué le #INVOICEDATE . Le solde est dû au <span class="text-info">#LASTDATE</span> .',
        '5_type'       => '<p class="mt-2 mb-1">Les paiements peuvent être répartis sur <span class="text-info">#NUMBEROFINSTALLMENTS</span> versements</p>',
        '5_1_type'     => '<li>Paiement <span class="text-info">#PERCENT %</span> dû <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">Le mois prochain compte un total de #N jours, veuillez donc saisir une valeur comprise entre 1 et #N pour la réduction sur les jours du mois prochain.</span>',
    ],
    'payment_term_not_selected'                       => 'Conditions de paiement non sélectionnées',
    'confirm'                                         => 'Confirmer',
    'create_live_invoice_now'                         => 'Créer une facture en direct maintenant?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Un abonnement est comme un modèle de facture utilisé pour créer des factures en direct à une fréquence donnée.</p><p class="m-0"> Normalement, il s\'agit d\'une tâche CRON ou d\'une tâche planifiée. est configuré pour s\'exécuter une fois par jour et est chargé de vérifier les factures en direct qui doivent être créées, en fonction du champ de date Générer la prochaine facture de l\'abonnement.  Si cette valeur de date est aujourd\'hui ou antérieure à aujourd\'hui, une facture en direct est automatiquement créée.</p><p class="m-0"> Cette option vous permet de créer manuellement la facture en direct à partir de l\'abonnement, en contournant la méthode automatisée. . Souhaitez-vous créer la facture en direct maintenant?</p>',
    'contact'                                         => 'Contact',
    'invoice_month_plus_one'                          => 'Mois de facturation +1',
    'invoice_month_plus_two'                          => 'Mois de facturation +2',
    'invoice_month_plus_three'                        => 'Mois de facturation +3',
    'inbound_email'                                   => 'E-mail entrant',
    'outbound_email'                                  => 'E-mail sortant',
    'email_signature'                                 => 'Signature électronique',
    'mail_credential_error'                           => 'Configuration de messagerie invalide. Veuillez vérifier vos paramètres puis essayez une nouvelle fois. <strong>( Configuration <i class="fa fa-arrow-alt-circle-right"> </i> Paramètres système <i class="fa fa-arrow-alt-circle-right"> </i> E-mail )</strong>',
    'tt_generate_next_invoice'                        => 'La date à laquelle la prochaine facture en direct sera automatiquement créée à partir de cet abonnement.',
    'tt_stop_date'                                    => 'La date seuil après laquelle plus aucune facture en direct ne sera automatiquement générée pour cet abonnement. Laissez ce champ vide pour un abonnement qui doit durer éternellement.',
    'description_template'                            => 'Modèle de description',
    't_1_description'                                 => 'Le paiement intégral est dû avant le #LASTDATE.',
    't_2_description'                                 => 'Bénéficiez d\'une remise de #DISCOUNTPERCENT% si vous êtes payé avant le #DISCOUNTDATE, sinon payez le montant total de la facture avant le #LASTDATE.',
    't_3_description'                                 => 'Bénéficiez d\'une remise de #DISCOUNTPERCENT% si vous êtes payé avant le #DISCOUNTDATE, sinon payez le montant total de la facture avant le #LASTDATE.',
    't_4_description'                                 => 'Un acompte de #DOWNPAYMENT est dû le #INVOICEDATE, le solde de la facture est dû au #LASTDATE',
    't_4_1_description'                               => 'Un acompte de #DOWNPAYMENTPERCENT est dû le #INVOICEDATE, le solde de la facture est dû au plus tard le #LASTDATE',
    't_5_description'                                 => 'Les paiements doivent être effectués en #NUMBEROFINSTALLMENTS versements égaux',
    't_5_type_description'                            => 'Le paiement #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT est dû le #LASTDATE',
    'tokens_allowed'                                  => 'Jetons autorisés',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'Le texte évalué à partir du modèle est la description des termes qui apparaît sur les documents tels que la facture, les devis, etc.',
    'cc_mail'                                         => 'Courrier CC',
    'assigned_inv_sent_or_paid'                       => '*Certaines factures payées ou envoyées sont associées à ce délai de paiement. La modification des détails du «Type» n\'est pas autorisée.',
    'exclude_paid_invoices'                           => 'Exclure les factures payées',
    'phone_number_numeric_error'                      => 'Le numéro de téléphone doit être un numéro.',
    'phone_num_same_country_code_error'               => 'Veuillez vous assurer que votre numéro de téléphone est correctement formaté. Il semble avoir été saisi en commençant par le code du pays, ce qui n\'est pas autorisé.',
    'tt_expense_amount'                               => 'Inscrivez le montant total de la dépense, taxes incluses. Ce champ n\'est pas disponible lors de la remise d\'un paiement de taxe à une autorité fiscale.',
    'tt_expense_tax_paid_deductible'                  => 'Entrez le montant de taxe qui a été payé avec cette dépense. Cette valeur sera déduite de votre obligation fiscale globale dans les rapports Récapitulatif fiscal et Détails fiscaux.',
    'tt_expense_tax_paid_remittance'                  => 'Saisissez le montant de la taxe qui a été remis à l\'administration fiscale. Ceci est utilisé pour enregistrer les paiements effectués pour les taxes collectées sur vos factures payées.',
    'tt_expense_client'                               => 'Si cette dépense a été engagée uniquement pour le compte d\'un client et que vous souhaitez la facturer, sélectionnez ici le client concerné.',
    'base_currency_not_deleted'                       => 'La devise de base ne peut pas être supprimée',
    'used_currency_modal_error'                       => 'Devise déjà utilisée dans le module :modal_names.',
    'addon_uninstall_success'                         => 'Module complémentaire désinstallé avec succès',
    'original'                                        => 'Original',
    'revision_current'                                => 'Révision (actuelle)',
    'number'                                          => 'Nombre',
    'copy_process_error'                              => 'Oops! Il semble qu\'il y ait eu un problème lors du processus de copie. Veuillez réessayer plus tard.',
    'tt_captcha_image'                                => 'Image CAPTCHA',
    'reload_page'                                     => 'Veuillez recharger la page',
    'discount_limit'                                  => 'La remise doit être inférieure à 99,99%.',
    'tooltip'                                         => 'Info-bulle',
    'authorization_error'                             => 'Vous n\'êtes pas autorisé à effectuer cette opération.',
    'reset_to_default'                                => 'Réinitialiser aux valeurs par défaut',
    'reset_to_default_warning'                        => '<p>Cela réinitialisera le sujet et le corps à la valeur par défaut pour :model . Continuer?</p>',
    'reset_default_mail_template'                     => 'Le modèle de courrier par défaut pour :model a été réinitialisé avec succès.',
    'overdue_invoice'                                 => 'Facture en retard',
    'total_cannot_be_lt_zero'                         => 'Le total :modal_name ne peut pas être inférieur à zéro.',
    'addons_disabled_during_setup'                    => 'Pendant le processus de mise à niveau, les modules complémentaires suivants ont été désactivés: :addons . N\'oubliez pas de les activer maintenant que la mise à niveau est terminée.',
    'allow_payments_on_quotes'                        => 'Autoriser les paiements sur les devis O/N',
    'allow_payments_on_quote'                         => 'Autoriser le paiement O/N',
    'tt_ss_quotes_is_payable'                         => 'S\'il est activé, après l\'approbation du devis, un bouton Payer maintenant apparaîtra sur la vue du lien public du devis. Une facture sera automatiquement créée et le paiement sera appliqué à la facture.',
    'pay_with_square'                                 => 'Payer avec Square',
    'validation_mess_for_is_payable_quote'            => 'Le paramètre Convertir automatiquement le devis en facture lorsque le client l\'approuve est requis lorsque Autoriser les paiements sur les devis est défini sur «Oui».',
    'client_requirement_msg'                          => 'Veuillez créer un client avant d\'ajouter :seed_name',
    'quote_add_items'                                 => 'Éléments de devis requis et statut non annulé',
    'invalid_quote_id'                                => 'Identifiant de devis invalide',
    'information_header'                              => 'Félicitations, vous êtes sur le point d\'économiser de l\'argent!',
    'convenience_charge'                              => 'Frais de commodité',
    'credit_card_fee_message'                         => 'Il y aura des frais de commodité de carte de crédit de :charge sur cette transaction.',
    'info_payment_term_type_2'                        => 'Bien que le solde de votre facture soit :ORIGINAL_AMOUNT, vous avez droit à une remise sur les conditions de paiement de :DISCOUNT_PERCENT %, ce qui réduira le montant de votre paiement à :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Bien que le solde de votre facture soit :ORIGINAL_AMOUNT, vous avez droit à une remise sur les conditions de paiement de :DISCOUNT_PERCENT %, ce qui réduira le montant de votre paiement à :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Bien que le solde de votre facture soit :ORIGINAL_AMOUNT, vous pouvez bénéficier de conditions de paiement pour verser un acompte :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Bien que le solde de votre facture soit :ORIGINAL_AMOUNT, vous pouvez bénéficier de conditions de paiement pour effectuer un paiement échelonné :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'Les conditions de paiement doivent être supprimées du :modal avant la suppression.',
    'default_payment_term_warn'                       => '*Vous ne pouvez modifier que le nom et les jours d\'échéance nets pour les <strong>Conditions de paiement par défaut du système</strong>.',
    'quote_rejected_not_payable'                      => 'Le devis n° :number a été rejeté et n\'est pas payable en raison de son statut.',
    'could_not_delete'                                => 'Impossible de supprimer',
    'convenience_charges_calculation_fail'            => 'Erreur: Le calcul des frais de commodité a échoué lors de la migration. Veuillez réessayer plus tard.',
    'sign_in_welcome_message'                         => 'ðŸš€ Félicitations! Votre FusionInvoice a été installée avec succès! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>Votre FusionInvoice a été mis à niveau avec succès de la version :old_version vers la version :new_version .</p><p> Pour un aperçu détaillé de toutes les nouvelles fonctionnalités et améliorations, veuillez consulter nos <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Release Notes</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Merci d\'avoir choisi FusionInvoice. Votre confiance, votre soutien et vos commentaires stimulent notre innovation.</p><p class="m-0 text-bold">Bonne facturation!</p><p class="text-bold">L\'équipe FusionInvoice</p >',
    'tt_gen_skin_user_profile'                        => 'La modification de cette valeur définit la valeur par défaut du système UNIQUEMENT pour les nouveaux utilisateurs. Les utilisateurs peuvent remplacer ce paramètre via les paramètres de leur profil utilisateur.',
    'description_template_invoice'                    => 'Modèle de description - Facture',
    'description_template_quote'                      => 'Modèle de description - Devis',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Le paiement intégral est dû dans les #NETDAYS suivant la date de facture.',
    't_2_description_for_quote'                       => 'Bénéficiez d\'une remise de #DISCOUNTPERCENT% si vous payez dans #DISCOUNTDAYS, sinon payez le montant total du devis d\'ici #NETDAYS.',
    't_3_description_for_quote'                       => 'Bénéficiez d\'une remise de #DISCOUNTPERCENT % si vous payez avant le #NTHDAY du mois suivant, sinon payez le montant total de la facture dans les #NETDAYS jours.',
    't_4_description_for_quote'                       => 'Un acompte de #DOWNPAYMENT est dû à la date de facturation, le solde restant est dû dans les #NETDAYS jours',
    't_4_1_description_for_quote'                     => 'Un acompte de #DOWNPAYMENTPERCENT est dû à la date de facturation, le solde restant est dû dans les #NETDAYS jours',
    't_5_description_for_quote'                       => 'Les paiements doivent être effectués en #NUMBEROFINSTALLMENTS versements égaux',
    't_5_type_description_for_quote'                  => 'Le paiement #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT est dû #INSTALLMENTDUEDAYS jours à compter de la date de facture.',
    'default_term'                                    => 'Durée par défaut',
    'proceed_to_payment'                              => 'Procéder au paiement',
    'version_upgraded'                                => 'Votre candidature est à jour.',
    'term_amount_gt_payment_amount'                   => 'Le montant doit être supérieur au montant de la remise selon les conditions de paiement.',
    'payment_term_not_eligible_warning'               => 'La remise sur conditions de paiement n’est disponible que pour les paiements complets. Malheureusement, vous n’y êtes pas admissible.',
    'processed_by_user'                               => '<strong>Traité par:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Mode de paiement:</strong> :method',
    'all_methods'                                     => 'Toutes les méthodes',
    'this_payment'                                    => 'Ce paiement',
    'previous_balance'                                => 'Solde précédent',
    'payment_applied_with_remaining_balance'          => '<p><strong>Votre paiement de :amount a été partiellement appliqué. :remaining_balance reste en suspens.</strong></p>',
    'pre_payment_received'                            => '<p><strong>Un pré-paiement de :amount a été reçu pour les factures futures le :date .</strong></p>',
    'payment_full_applied'                            => '<p><strong>Votre paiement :amount a été entièrement appliqué.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Paiement <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;"> :formatted_number</span> ~ Détails:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>Le paiement de :paid a été appliqué à la facture :invoice_number le :date</span> ~',
    'payment_full_applied_on_inv_with_ptd'            => '<p>Le paiement de :paid, moins :payment_terms_discount remise sur les conditions de paiement a été appliqué à la facture :invoice_number le :date</span> ~',
    'payment_full_applied_on_inv_with_cc'             => '<p>Le paiement de :paid, plus :convenience_charges frais de commodité, a été appliqué à la facture :invoice_number le :date</span> ~',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>Le paiement de :paid, plus :convenience_charges frais de commodité et moins :payment_terms_discount remise sur les conditions de paiement, a été appliqué à la facture :invoice_number le :date</span> ~',
    'payment_remaining_balance_mail_message'          => '<p>Le solde restant de la facture :invoice_number est :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Factures impayées',
    'include'                                         => 'Inclure',
    'exclude'                                         => 'Exclure',
    'invoice_with_no_tax'                             => 'Factures sans taxe',
    'tax_total'                                       => 'Total des taxes',
];

return TranslationOverride::override(__FILE__, $translations);
